<div align="center">

# 🔐 SheerID Verification Tool

[![GitHub Stars](https://img.shields.io/github/stars/ThanhNguyxn/SheerID-Verification-Tool?style=social)](https://github.com/ThanhNguyxn/SheerID-Verification-Tool/stargazers)
[![GitHub Forks](https://img.shields.io/github/forks/ThanhNguyxn/SheerID-Verification-Tool?style=social)](https://github.com/ThanhNguyxn/SheerID-Verification-Tool/network/members)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

**A comprehensive multilingual guide to help students obtain Gemini Advanced & ChatGPT Plus for free through student verification programs.**

<p align="center">
  <a href="https://thanhnguyxn.github.io/SheerID-Verification-Tool/">
    <img src="https://img.shields.io/badge/Live_Tool-4285F4?style=for-the-badge&logo=google-chrome&logoColor=white" alt="Live Tool">
  </a>
  <a href="https://thanhnguyxn.github.io/student-card-generator/">
    <img src="https://img.shields.io/badge/Card_Generator-34A853?style=for-the-badge&logo=google&logoColor=white" alt="Student Card Generator">
  </a>
  <a href="#-table-of-contents">
    <img src="https://img.shields.io/badge/Documentation-gray?style=for-the-badge&logo=readthedocs&logoColor=white" alt="Documentation">
  </a>
  <a href="https://github.com/ThanhNguyxn/SheerID-Verification-Tool/issues">
    <img src="https://img.shields.io/badge/Report_Bug-EA4335?style=for-the-badge&logo=github&logoColor=white" alt="Report Bug">
  </a>
</p>

</div>

---

## 🌍 Language Versions

This guide is available in multiple languages:

- 🇬🇧 **English** (Current)
- 🇻🇳 [Tiếng Việt](docs/README.vi.md)
- 🇪🇸 [Español](docs/README.es.md)
- 🇫🇷 [Français](docs/README.fr.md)
- 🇩🇪 [Deutsch](docs/README.de.md)
- 🇨🇳 [中文](docs/README.zh.md)
- 🇧🇷 [Português](docs/README.pt-BR.md)
- 🇷🇺 [Русский](docs/README.ru.md)
- 🇯🇵 [日本語](docs/README.ja.md)
- 🇰🇷 [한국어](docs/README.ko.md)
- 🇮🇩 [Indonesia](docs/README.id.md)
- 🇮🇳 [हिन्दी](docs/README.hi.md)
- 🇸🇦 [العربية](docs/README.ar.md)
- 🇹🇷 [Türkçe](docs/README.tr.md)
- 🇮🇹 [Italiano](docs/README.it.md)
- 🇹🇭 [ไทย](docs/README.th.md)
- 🇵🇱 [Polski](docs/README.pl.md)

---

## 📖 About the Project

The **SheerID Verification Tool** provides a step-by-step guide for students worldwide to access Google's Gemini Advanced AI platform for free. This tool simplifies the verification process using SheerID's student verification system, enabling students to unlock premium features including Gemini Advanced, 2TB Google Drive storage, NotebookLM Pro, and AI video creation credits.

### ✨ Features

- 🌍 **Multilingual Support** - Available in English, Vietnamese, Spanish, French, German, and Chinese
- 📋 **Step-by-Step Guide** - Clear instructions for the entire verification process
- 🔒 **Security-Focused** - Emphasizes safe practices and trusted sources
- 🎁 **Premium Benefits** - Access to Gemini Advanced, ChatGPT Plus, 2TB storage, and more
- 🤖 **Telegram Bot Integration** - Automated verification through secure Telegram bots
- 🆓 **Completely Free** - No hidden costs during the free student period

---

## 📚 Table of Contents

- [⚠️ Disclaimer & Liability](#️-disclaimer--liability)
- [📋 Requirements](#-requirements)
- [🚀 Installation & Usage](#-installation--usage)
- [🎁 Benefits](#-benefits)
- [⚠️ Security Notes](#️-security-notes)
- [🔗 Additional Resources](#-additional-resources)
- [💖 Support the Project](#-support-the-project)
- [📄 License](#-license)

---

## ⚠️ Disclaimer & Liability

> [!WARNING]
> **Educational Use Only** - This guide is for informational purposes.

**📁 What This Tool Does:**
- 🔗 Acts as a **directory** to third-party verification services  
- 📖 Provides **educational guides** for student verification

**🚫 What We Don't Do:**
- ❌ We do **NOT** host, operate, or manage Telegram bots
- ❌ We are **NOT** responsible for third-party bot security or data privacy  
- ❌ We are **NOT** affiliated with Google, SheerID, or Telegram

**✅ Your Responsibilities:**
- 👤 You are responsible for your own actions
- 📜 You must follow Google's Terms of Service
- 🔒 Verify bot authenticity before sharing information

> [!CAUTION]  
> **Use at your own risk** - Always verify sources before providing personal information.

---

## 📋 Requirements

Before you begin, ensure you have:

- ✅ **Telegram account** - For bot verification
- ✅ **Google/OpenAI account** - A valid account for verification
- ✅ **Valid payment method** - Bank card or e-wallet (no charge for free package)
- ✅ **VPN** - (e.g., Urban VPN) to switch region to US or other eligible countries if needed

## 🚀 Installation & Usage

### 🌐 Step 1: Set Up Your Browser

1. **Create a new browser profile** or use incognito mode to avoid data conflicts

2. **Install a VPN extension** (skip if you're already in a supported region like **US**):
   - [Urban VPN](https://chrome.google.com/webstore/detail/urban-vpn) (Chrome/Edge)
   - [Proton VPN](https://protonvpn.com/) (All browsers)
   - Or any reliable VPN of your choice

> [!IMPORTANT]
> **Using Incognito mode?** Go to your browser's extension settings and enable **"Allow in Incognito"** for your VPN extension to work properly.
>
> ![Allow in Incognito](docs/images/allow-incognito.png)

> [!TIP]
> Connect to **US or other eligible countries** before proceeding to Step 2.

### 🎓 Step 2: Access the Student Program

Choose your program and get your verification link:

| Program | Link | For |
|---------|------|-----|
| 🤖 **Google Gemini** | [gemini.google/students](https://gemini.google/students) | College/University students |
| 💬 **ChatGPT Plus** | [chatgpt.com/plans/k12-teachers](https://chatgpt.com/plans/k12-teachers/) | K-12 Teachers |

Click **Join Student Program** or equivalent button to receive your verification link.

> [!IMPORTANT]
> **✅Country Eligibility:** If your country isn't supported, use a VPN (see [Requirements](#-requirements)) to switch to an eligible country (US, etc.).
> 
> **💡 Tip:** Search "Google Student Program supported countries" online or ask AI for the latest eligible regions.

### 📱 Step 3: Verify Student Status via Telegram

1. Open Telegram and access one of these bots:
   - [SheerID VIP Bot](https://t.me/SheerID_VIP_Bot?start=ref_REF001124) ✅ *Supports GPT K12*
   - [SheerID VN Bot](https://t.me/sheeridvn_bot?start=invite_7762497789)


2. Send the appropriate command based on your program:

   **For Google Gemini:**
   ```
   /verify https://services.sheerid.com/verify/***
   ```
   
   **For ChatGPT Plus (K-12):**
   ```
   /vc https://services.sheerid.com/verify/***
   ```
   
   *(Replace with your verification link)*

3. Wait for bot confirmation

> [!TIP]
> **💰 Completely Free!** Earn free coins by:
> - Inviting friends to the bot
> - Using `/checkin` daily to earn points
> 
> *Need coins urgently? We also support top-up options.*

> [!WARNING]
> **Got an error?** Use `/fix` command and paste your verification link again. If errors persist after multiple attempts, try using a different Google account.

### ✨ Step 4: Activate Your Premium Plan

**For Google Gemini:**
1. After verification, register for **Google One AI Premium**
2. Add your payment method (no charge during free period)
3. Complete registration

**For ChatGPT Plus:**
1. After verification, your ChatGPT Plus will be activated automatically
2. Enjoy your free subscription!

> [!NOTE]
> **VPN Users:** After verification, disconnect VPN and reload the page before adding payment method. This ensures compatibility with your country's payment options.

### ⚙️ Step 5: Manage Your Subscription

Visit [Google Play Subscriptions](https://play.google.com/store/account/subscriptions) to cancel before the 12-month period ends.

**⏰ Tip:** Set a calendar reminder to avoid auto-renewal charges!

## 🎁 Benefits

Upon successful completion, you'll receive:

**Google Gemini:**
- ✨ **Gemini Advanced** - Free for 12 months
- 💾 **2TB Google Drive** - Ample cloud storage
- 📝 **NotebookLM Pro** - Advanced note-taking capabilities
- 🎥 **1,000 AI Video Credits** - Create videos with VEO3

**ChatGPT Plus:**
- 💬 **ChatGPT Plus** - Free subscription for K-12 teachers
- 🧠 **GPT-4o Access** - Advanced AI capabilities
- 🎨 **DALL·E & More** - Image generation and advanced features

## ⚠️ Security Notes

- 🔐 Only use trusted bot sources listed in this guide
- 🚫 Never share payment information with third parties
- ⏰ After 12 months, the package will convert to paid if not canceled

## 🔗 Additional Resources

**Alternative Verification:** If you cannot verify via Telegram, use the [SheerID Verification Tool](https://thanhnguyxn.github.io/SheerID-Verification-Tool/)

**Official Links:**
- [Google One AI Premium](https://one.google.com)
- [Gemini Help Center](https://support.google.com/gemini)

**For Developers:**
> 🛠️ Want to understand how the verification engine works under the hood? Check out the [**Technical Documentation**](auto-verify-tool/README.md) for:
> - 🏗️ System Architecture & API Flow
> - ⚙️ SheerID REST API Integration  
> - 🎓 K12 Teacher Verification Tips
> - 🛡️ Anti-Detection Techniques
> - 📊 Success Rate Tracking

---

## 💖 Support the Project

If you find this guide helpful, please consider supporting it to help maintain and improve the project:

<a href="https://buymeacoffee.com/thanhnguyxn" target="_blank"><img src="https://cdn.buymeacoffee.com/buttons/v2/default-yellow.png" alt="Buy Me A Coffee" style="height: 60px !important;width: 217px !important;" ></a>

---

## 📄 License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

Copyright (c) 2025 SheerID Verification Tool Contributors

---

<div align="center">

**Made with ❤️ for students worldwide**

If you found this guide helpful, please consider giving it a ⭐ on [GitHub](https://github.com/ThanhNguyxn/SheerID-Verification-Tool)!

[⬆ Back to top](#-sheerid-verification-tool)

</div>
