(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.PDFDocument = f()}})(function(){var define,module,exports;return (function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){
(function (Buffer){(function (){
'use strict';

var stream = require('stream');
var zlib = require('zlib');
var CryptoJS = require('crypto-js');
var fs = require('fs');
var fontkit = require('fontkit');
var events = require('events');
var LineBreaker = require('linebreak');
var exif = require('jpeg-exif');
var PNG = require('png-js');

class PDFAbstractReference {
  toString() {
    throw new Error('Must be implemented by subclasses');
  }
}

class PDFTree {
  constructor(options = {}) {
    this._items = {};
    this.limits = typeof options.limits === 'boolean' ? options.limits : true;
  }
  add(key, val) {
    return this._items[key] = val;
  }
  get(key) {
    return this._items[key];
  }
  toString() {
    const sortedKeys = Object.keys(this._items).sort((a, b) => this._compareKeys(a, b));
    const out = ['<<'];
    if (this.limits && sortedKeys.length > 1) {
      const first = sortedKeys[0],
        last = sortedKeys[sortedKeys.length - 1];
      out.push(`  /Limits ${PDFObject.convert([this._dataForKey(first), this._dataForKey(last)])}`);
    }
    out.push(`  /${this._keysName()} [`);
    for (let key of sortedKeys) {
      out.push(`    ${PDFObject.convert(this._dataForKey(key))} ${PDFObject.convert(this._items[key])}`);
    }
    out.push(']');
    out.push('>>');
    return out.join('\n');
  }
  _compareKeys() {
    throw new Error('Must be implemented by subclasses');
  }
  _keysName() {
    throw new Error('Must be implemented by subclasses');
  }
  _dataForKey() {
    throw new Error('Must be implemented by subclasses');
  }
}

class SpotColor {
  constructor(doc, name, C, M, Y, K) {
    this.id = 'CS' + Object.keys(doc.spotColors).length;
    this.name = name;
    this.values = [C, M, Y, K];
    this.ref = doc.ref(['Separation', this.name, 'DeviceCMYK', {
      Range: [0, 1, 0, 1, 0, 1, 0, 1],
      C0: [0, 0, 0, 0],
      C1: this.values.map(value => value / 100),
      FunctionType: 2,
      Domain: [0, 1],
      N: 1
    }]);
    this.ref.end();
  }
  toString() {
    return `${this.ref.id} 0 R`;
  }
}

const pad = (str, length) => (Array(length + 1).join('0') + str).slice(-length);
const escapableRe = /[\n\r\t\b\f()\\]/g;
const escapable = {
  '\n': '\\n',
  '\r': '\\r',
  '\t': '\\t',
  '\b': '\\b',
  '\f': '\\f',
  '\\': '\\\\',
  '(': '\\(',
  ')': '\\)'
};
const swapBytes = function (buff) {
  const l = buff.length;
  if (l & 0x01) {
    throw new Error('Buffer length must be even');
  } else {
    for (let i = 0, end = l - 1; i < end; i += 2) {
      const a = buff[i];
      buff[i] = buff[i + 1];
      buff[i + 1] = a;
    }
  }
  return buff;
};
class PDFObject {
  static convert(object, encryptFn = null) {
    if (typeof object === 'string') {
      return `/${object}`;
    } else if (object instanceof String) {
      let string = object;
      let isUnicode = false;
      for (let i = 0, end = string.length; i < end; i++) {
        if (string.charCodeAt(i) > 0x7f) {
          isUnicode = true;
          break;
        }
      }
      let stringBuffer;
      if (isUnicode) {
        stringBuffer = swapBytes(Buffer.from(`\ufeff${string}`, 'utf16le'));
      } else {
        stringBuffer = Buffer.from(string.valueOf(), 'ascii');
      }
      if (encryptFn) {
        string = encryptFn(stringBuffer).toString('binary');
      } else {
        string = stringBuffer.toString('binary');
      }
      string = string.replace(escapableRe, c => escapable[c]);
      return `(${string})`;
    } else if (Buffer.isBuffer(object)) {
      return `<${object.toString('hex')}>`;
    } else if (object instanceof PDFAbstractReference || object instanceof PDFTree || object instanceof SpotColor) {
      return object.toString();
    } else if (object instanceof Date) {
      let string = `D:${pad(object.getUTCFullYear(), 4)}` + pad(object.getUTCMonth() + 1, 2) + pad(object.getUTCDate(), 2) + pad(object.getUTCHours(), 2) + pad(object.getUTCMinutes(), 2) + pad(object.getUTCSeconds(), 2) + 'Z';
      if (encryptFn) {
        string = encryptFn(Buffer.from(string, 'ascii')).toString('binary');
        string = string.replace(escapableRe, c => escapable[c]);
      }
      return `(${string})`;
    } else if (Array.isArray(object)) {
      const items = object.map(e => PDFObject.convert(e, encryptFn)).join(' ');
      return `[${items}]`;
    } else if ({}.toString.call(object) === '[object Object]') {
      const out = ['<<'];
      for (let key in object) {
        const val = object[key];
        out.push(`/${key} ${PDFObject.convert(val, encryptFn)}`);
      }
      out.push('>>');
      return out.join('\n');
    } else if (typeof object === 'number') {
      return PDFObject.number(object);
    } else {
      return `${object}`;
    }
  }
  static number(n) {
    if (n > -1e21 && n < 1e21) {
      return Math.round(n * 1e6) / 1e6;
    }
    throw new Error(`unsupported number: ${n}`);
  }
}

class PDFReference extends PDFAbstractReference {
  constructor(document, id, data = {}) {
    super();
    this.document = document;
    this.id = id;
    this.data = data;
    this.gen = 0;
    this.compress = this.document.compress && !this.data.Filter;
    this.uncompressedLength = 0;
    this.buffer = [];
  }
  write(chunk) {
    if (!(chunk instanceof Uint8Array)) {
      chunk = Buffer.from(chunk + '\n', 'binary');
    }
    this.uncompressedLength += chunk.length;
    if (this.data.Length == null) {
      this.data.Length = 0;
    }
    this.buffer.push(chunk);
    this.data.Length += chunk.length;
    if (this.compress) {
      this.data.Filter = 'FlateDecode';
    }
  }
  end(chunk) {
    if (chunk) {
      this.write(chunk);
    }
    this.finalize();
  }
  finalize() {
    this.offset = this.document._offset;
    const encryptFn = this.document._security ? this.document._security.getEncryptFn(this.id, this.gen) : null;
    if (this.buffer.length) {
      this.buffer = Buffer.concat(this.buffer);
      if (this.compress) {
        this.buffer = zlib.deflateSync(this.buffer);
      }
      if (encryptFn) {
        this.buffer = encryptFn(this.buffer);
      }
      this.data.Length = this.buffer.length;
    }
    this.document._write(`${this.id} ${this.gen} obj`);
    this.document._write(PDFObject.convert(this.data, encryptFn));
    if (this.buffer.length) {
      this.document._write('stream');
      this.document._write(this.buffer);
      this.buffer = [];
      this.document._write('\nendstream');
    }
    this.document._write('endobj');
    this.document._refEnd(this);
  }
  toString() {
    return `${this.id} ${this.gen} R`;
  }
}

const fArray = new Float32Array(1);
const uArray = new Uint32Array(fArray.buffer);
function PDFNumber(n) {
  const rounded = Math.fround(n);
  if (rounded <= n) return rounded;
  fArray[0] = n;
  if (n <= 0) {
    uArray[0] += 1;
  } else {
    uArray[0] -= 1;
  }
  return fArray[0];
}
function normalizeSides(sides, defaultDefinition = undefined, transformer = v => v) {
  if (sides == null || typeof sides === 'object' && Object.keys(sides).length === 0) {
    sides = defaultDefinition;
  }
  if (sides == null || typeof sides !== 'object') {
    sides = {
      top: sides,
      right: sides,
      bottom: sides,
      left: sides
    };
  } else if (Array.isArray(sides)) {
    if (sides.length === 2) {
      sides = {
        vertical: sides[0],
        horizontal: sides[1]
      };
    } else {
      sides = {
        top: sides[0],
        right: sides[1],
        bottom: sides[2],
        left: sides[3]
      };
    }
  }
  if ('vertical' in sides || 'horizontal' in sides) {
    sides = {
      top: sides.vertical,
      right: sides.horizontal,
      bottom: sides.vertical,
      left: sides.horizontal
    };
  }
  return {
    top: transformer(sides.top),
    right: transformer(sides.right),
    bottom: transformer(sides.bottom),
    left: transformer(sides.left)
  };
}
const MM_TO_CM = 1 / 10;
const CM_TO_IN = 1 / 2.54;
const PX_TO_IN = 1 / 96;
const IN_TO_PT = 72;
const PC_TO_PT = 12;
function cosine(a) {
  if (a === 0) return 1;
  if (a === 90) return 0;
  if (a === 180) return -1;
  if (a === 270) return 0;
  return Math.cos(a * Math.PI / 180);
}
function sine(a) {
  if (a === 0) return 0;
  if (a === 90) return 1;
  if (a === 180) return 0;
  if (a === 270) return -1;
  return Math.sin(a * Math.PI / 180);
}

const DEFAULT_MARGINS = {
  top: 72,
  left: 72,
  bottom: 72,
  right: 72
};
const SIZES = {
  '4A0': [4767.87, 6740.79],
  '2A0': [3370.39, 4767.87],
  A0: [2383.94, 3370.39],
  A1: [1683.78, 2383.94],
  A2: [1190.55, 1683.78],
  A3: [841.89, 1190.55],
  A4: [595.28, 841.89],
  A5: [419.53, 595.28],
  A6: [297.64, 419.53],
  A7: [209.76, 297.64],
  A8: [147.4, 209.76],
  A9: [104.88, 147.4],
  A10: [73.7, 104.88],
  B0: [2834.65, 4008.19],
  B1: [2004.09, 2834.65],
  B2: [1417.32, 2004.09],
  B3: [1000.63, 1417.32],
  B4: [708.66, 1000.63],
  B5: [498.9, 708.66],
  B6: [354.33, 498.9],
  B7: [249.45, 354.33],
  B8: [175.75, 249.45],
  B9: [124.72, 175.75],
  B10: [87.87, 124.72],
  C0: [2599.37, 3676.54],
  C1: [1836.85, 2599.37],
  C2: [1298.27, 1836.85],
  C3: [918.43, 1298.27],
  C4: [649.13, 918.43],
  C5: [459.21, 649.13],
  C6: [323.15, 459.21],
  C7: [229.61, 323.15],
  C8: [161.57, 229.61],
  C9: [113.39, 161.57],
  C10: [79.37, 113.39],
  RA0: [2437.8, 3458.27],
  RA1: [1729.13, 2437.8],
  RA2: [1218.9, 1729.13],
  RA3: [864.57, 1218.9],
  RA4: [609.45, 864.57],
  SRA0: [2551.18, 3628.35],
  SRA1: [1814.17, 2551.18],
  SRA2: [1275.59, 1814.17],
  SRA3: [907.09, 1275.59],
  SRA4: [637.8, 907.09],
  EXECUTIVE: [521.86, 756.0],
  FOLIO: [612.0, 936.0],
  LEGAL: [612.0, 1008.0],
  LETTER: [612.0, 792.0],
  TABLOID: [792.0, 1224.0]
};
class PDFPage {
  constructor(document, options = {}) {
    this.document = document;
    this._options = options;
    this.size = options.size || 'letter';
    this.layout = options.layout || 'portrait';
    const dimensions = Array.isArray(this.size) ? this.size : SIZES[this.size.toUpperCase()];
    this.width = dimensions[this.layout === 'portrait' ? 0 : 1];
    this.height = dimensions[this.layout === 'portrait' ? 1 : 0];
    this.content = this.document.ref();
    if (options.font) document.font(options.font, options.fontFamily);
    if (options.fontSize) document.fontSize(options.fontSize);
    this.margins = normalizeSides(options.margin ?? options.margins, DEFAULT_MARGINS, x => document.sizeToPoint(x, 0, this));
    this.resources = this.document.ref({
      ProcSet: ['PDF', 'Text', 'ImageB', 'ImageC', 'ImageI']
    });
    this.dictionary = this.document.ref({
      Type: 'Page',
      Parent: this.document._root.data.Pages,
      MediaBox: [0, 0, this.width, this.height],
      Contents: this.content,
      Resources: this.resources
    });
    this.markings = [];
  }
  get fonts() {
    const data = this.resources.data;
    return data.Font != null ? data.Font : data.Font = {};
  }
  get xobjects() {
    const data = this.resources.data;
    return data.XObject != null ? data.XObject : data.XObject = {};
  }
  get ext_gstates() {
    const data = this.resources.data;
    return data.ExtGState != null ? data.ExtGState : data.ExtGState = {};
  }
  get patterns() {
    const data = this.resources.data;
    return data.Pattern != null ? data.Pattern : data.Pattern = {};
  }
  get colorSpaces() {
    const data = this.resources.data;
    return data.ColorSpace || (data.ColorSpace = {});
  }
  get annotations() {
    const data = this.dictionary.data;
    return data.Annots != null ? data.Annots : data.Annots = [];
  }
  get structParentTreeKey() {
    const data = this.dictionary.data;
    return data.StructParents != null ? data.StructParents : data.StructParents = this.document.createStructParentTreeNextKey();
  }
  get contentWidth() {
    return this.width - this.margins.left - this.margins.right;
  }
  get contentHeight() {
    return this.height - this.margins.top - this.margins.bottom;
  }
  maxY() {
    return this.height - this.margins.bottom;
  }
  write(chunk) {
    return this.content.write(chunk);
  }
  _setTabOrder() {
    if (!this.dictionary.Tabs && this.document.hasMarkInfoDictionary()) {
      this.dictionary.data.Tabs = 'S';
    }
  }
  end() {
    this._setTabOrder();
    this.dictionary.end();
    this.resources.data.ColorSpace = this.resources.data.ColorSpace || {};
    for (let color of Object.values(this.document.spotColors)) {
      this.resources.data.ColorSpace[color.id] = color;
    }
    this.resources.end();
    return this.content.end();
  }
}

class PDFNameTree extends PDFTree {
  _compareKeys(a, b) {
    return a.localeCompare(b);
  }
  _keysName() {
    return 'Names';
  }
  _dataForKey(k) {
    return new String(k);
  }
}

function inRange(value, rangeGroup) {
  if (value < rangeGroup[0]) return false;
  let startRange = 0;
  let endRange = rangeGroup.length / 2;
  while (startRange <= endRange) {
    const middleRange = Math.floor((startRange + endRange) / 2);
    const arrayIndex = middleRange * 2;
    if (value >= rangeGroup[arrayIndex] && value <= rangeGroup[arrayIndex + 1]) {
      return true;
    }
    if (value > rangeGroup[arrayIndex + 1]) {
      startRange = middleRange + 1;
    } else {
      endRange = middleRange - 1;
    }
  }
  return false;
}

const unassigned_code_points = [0x0221, 0x0221, 0x0234, 0x024f, 0x02ae, 0x02af, 0x02ef, 0x02ff, 0x0350, 0x035f, 0x0370, 0x0373, 0x0376, 0x0379, 0x037b, 0x037d, 0x037f, 0x0383, 0x038b, 0x038b, 0x038d, 0x038d, 0x03a2, 0x03a2, 0x03cf, 0x03cf, 0x03f7, 0x03ff, 0x0487, 0x0487, 0x04cf, 0x04cf, 0x04f6, 0x04f7, 0x04fa, 0x04ff, 0x0510, 0x0530, 0x0557, 0x0558, 0x0560, 0x0560, 0x0588, 0x0588, 0x058b, 0x0590, 0x05a2, 0x05a2, 0x05ba, 0x05ba, 0x05c5, 0x05cf, 0x05eb, 0x05ef, 0x05f5, 0x060b, 0x060d, 0x061a, 0x061c, 0x061e, 0x0620, 0x0620, 0x063b, 0x063f, 0x0656, 0x065f, 0x06ee, 0x06ef, 0x06ff, 0x06ff, 0x070e, 0x070e, 0x072d, 0x072f, 0x074b, 0x077f, 0x07b2, 0x0900, 0x0904, 0x0904, 0x093a, 0x093b, 0x094e, 0x094f, 0x0955, 0x0957, 0x0971, 0x0980, 0x0984, 0x0984, 0x098d, 0x098e, 0x0991, 0x0992, 0x09a9, 0x09a9, 0x09b1, 0x09b1, 0x09b3, 0x09b5, 0x09ba, 0x09bb, 0x09bd, 0x09bd, 0x09c5, 0x09c6, 0x09c9, 0x09ca, 0x09ce, 0x09d6, 0x09d8, 0x09db, 0x09de, 0x09de, 0x09e4, 0x09e5, 0x09fb, 0x0a01, 0x0a03, 0x0a04, 0x0a0b, 0x0a0e, 0x0a11, 0x0a12, 0x0a29, 0x0a29, 0x0a31, 0x0a31, 0x0a34, 0x0a34, 0x0a37, 0x0a37, 0x0a3a, 0x0a3b, 0x0a3d, 0x0a3d, 0x0a43, 0x0a46, 0x0a49, 0x0a4a, 0x0a4e, 0x0a58, 0x0a5d, 0x0a5d, 0x0a5f, 0x0a65, 0x0a75, 0x0a80, 0x0a84, 0x0a84, 0x0a8c, 0x0a8c, 0x0a8e, 0x0a8e, 0x0a92, 0x0a92, 0x0aa9, 0x0aa9, 0x0ab1, 0x0ab1, 0x0ab4, 0x0ab4, 0x0aba, 0x0abb, 0x0ac6, 0x0ac6, 0x0aca, 0x0aca, 0x0ace, 0x0acf, 0x0ad1, 0x0adf, 0x0ae1, 0x0ae5, 0x0af0, 0x0b00, 0x0b04, 0x0b04, 0x0b0d, 0x0b0e, 0x0b11, 0x0b12, 0x0b29, 0x0b29, 0x0b31, 0x0b31, 0x0b34, 0x0b35, 0x0b3a, 0x0b3b, 0x0b44, 0x0b46, 0x0b49, 0x0b4a, 0x0b4e, 0x0b55, 0x0b58, 0x0b5b, 0x0b5e, 0x0b5e, 0x0b62, 0x0b65, 0x0b71, 0x0b81, 0x0b84, 0x0b84, 0x0b8b, 0x0b8d, 0x0b91, 0x0b91, 0x0b96, 0x0b98, 0x0b9b, 0x0b9b, 0x0b9d, 0x0b9d, 0x0ba0, 0x0ba2, 0x0ba5, 0x0ba7, 0x0bab, 0x0bad, 0x0bb6, 0x0bb6, 0x0bba, 0x0bbd, 0x0bc3, 0x0bc5, 0x0bc9, 0x0bc9, 0x0bce, 0x0bd6, 0x0bd8, 0x0be6, 0x0bf3, 0x0c00, 0x0c04, 0x0c04, 0x0c0d, 0x0c0d, 0x0c11, 0x0c11, 0x0c29, 0x0c29, 0x0c34, 0x0c34, 0x0c3a, 0x0c3d, 0x0c45, 0x0c45, 0x0c49, 0x0c49, 0x0c4e, 0x0c54, 0x0c57, 0x0c5f, 0x0c62, 0x0c65, 0x0c70, 0x0c81, 0x0c84, 0x0c84, 0x0c8d, 0x0c8d, 0x0c91, 0x0c91, 0x0ca9, 0x0ca9, 0x0cb4, 0x0cb4, 0x0cba, 0x0cbd, 0x0cc5, 0x0cc5, 0x0cc9, 0x0cc9, 0x0cce, 0x0cd4, 0x0cd7, 0x0cdd, 0x0cdf, 0x0cdf, 0x0ce2, 0x0ce5, 0x0cf0, 0x0d01, 0x0d04, 0x0d04, 0x0d0d, 0x0d0d, 0x0d11, 0x0d11, 0x0d29, 0x0d29, 0x0d3a, 0x0d3d, 0x0d44, 0x0d45, 0x0d49, 0x0d49, 0x0d4e, 0x0d56, 0x0d58, 0x0d5f, 0x0d62, 0x0d65, 0x0d70, 0x0d81, 0x0d84, 0x0d84, 0x0d97, 0x0d99, 0x0db2, 0x0db2, 0x0dbc, 0x0dbc, 0x0dbe, 0x0dbf, 0x0dc7, 0x0dc9, 0x0dcb, 0x0dce, 0x0dd5, 0x0dd5, 0x0dd7, 0x0dd7, 0x0de0, 0x0df1, 0x0df5, 0x0e00, 0x0e3b, 0x0e3e, 0x0e5c, 0x0e80, 0x0e83, 0x0e83, 0x0e85, 0x0e86, 0x0e89, 0x0e89, 0x0e8b, 0x0e8c, 0x0e8e, 0x0e93, 0x0e98, 0x0e98, 0x0ea0, 0x0ea0, 0x0ea4, 0x0ea4, 0x0ea6, 0x0ea6, 0x0ea8, 0x0ea9, 0x0eac, 0x0eac, 0x0eba, 0x0eba, 0x0ebe, 0x0ebf, 0x0ec5, 0x0ec5, 0x0ec7, 0x0ec7, 0x0ece, 0x0ecf, 0x0eda, 0x0edb, 0x0ede, 0x0eff, 0x0f48, 0x0f48, 0x0f6b, 0x0f70, 0x0f8c, 0x0f8f, 0x0f98, 0x0f98, 0x0fbd, 0x0fbd, 0x0fcd, 0x0fce, 0x0fd0, 0x0fff, 0x1022, 0x1022, 0x1028, 0x1028, 0x102b, 0x102b, 0x1033, 0x1035, 0x103a, 0x103f, 0x105a, 0x109f, 0x10c6, 0x10cf, 0x10f9, 0x10fa, 0x10fc, 0x10ff, 0x115a, 0x115e, 0x11a3, 0x11a7, 0x11fa, 0x11ff, 0x1207, 0x1207, 0x1247, 0x1247, 0x1249, 0x1249, 0x124e, 0x124f, 0x1257, 0x1257, 0x1259, 0x1259, 0x125e, 0x125f, 0x1287, 0x1287, 0x1289, 0x1289, 0x128e, 0x128f, 0x12af, 0x12af, 0x12b1, 0x12b1, 0x12b6, 0x12b7, 0x12bf, 0x12bf, 0x12c1, 0x12c1, 0x12c6, 0x12c7, 0x12cf, 0x12cf, 0x12d7, 0x12d7, 0x12ef, 0x12ef, 0x130f, 0x130f, 0x1311, 0x1311, 0x1316, 0x1317, 0x131f, 0x131f, 0x1347, 0x1347, 0x135b, 0x1360, 0x137d, 0x139f, 0x13f5, 0x1400, 0x1677, 0x167f, 0x169d, 0x169f, 0x16f1, 0x16ff, 0x170d, 0x170d, 0x1715, 0x171f, 0x1737, 0x173f, 0x1754, 0x175f, 0x176d, 0x176d, 0x1771, 0x1771, 0x1774, 0x177f, 0x17dd, 0x17df, 0x17ea, 0x17ff, 0x180f, 0x180f, 0x181a, 0x181f, 0x1878, 0x187f, 0x18aa, 0x1dff, 0x1e9c, 0x1e9f, 0x1efa, 0x1eff, 0x1f16, 0x1f17, 0x1f1e, 0x1f1f, 0x1f46, 0x1f47, 0x1f4e, 0x1f4f, 0x1f58, 0x1f58, 0x1f5a, 0x1f5a, 0x1f5c, 0x1f5c, 0x1f5e, 0x1f5e, 0x1f7e, 0x1f7f, 0x1fb5, 0x1fb5, 0x1fc5, 0x1fc5, 0x1fd4, 0x1fd5, 0x1fdc, 0x1fdc, 0x1ff0, 0x1ff1, 0x1ff5, 0x1ff5, 0x1fff, 0x1fff, 0x2053, 0x2056, 0x2058, 0x205e, 0x2064, 0x2069, 0x2072, 0x2073, 0x208f, 0x209f, 0x20b2, 0x20cf, 0x20eb, 0x20ff, 0x213b, 0x213c, 0x214c, 0x2152, 0x2184, 0x218f, 0x23cf, 0x23ff, 0x2427, 0x243f, 0x244b, 0x245f, 0x24ff, 0x24ff, 0x2614, 0x2615, 0x2618, 0x2618, 0x267e, 0x267f, 0x268a, 0x2700, 0x2705, 0x2705, 0x270a, 0x270b, 0x2728, 0x2728, 0x274c, 0x274c, 0x274e, 0x274e, 0x2753, 0x2755, 0x2757, 0x2757, 0x275f, 0x2760, 0x2795, 0x2797, 0x27b0, 0x27b0, 0x27bf, 0x27cf, 0x27ec, 0x27ef, 0x2b00, 0x2e7f, 0x2e9a, 0x2e9a, 0x2ef4, 0x2eff, 0x2fd6, 0x2fef, 0x2ffc, 0x2fff, 0x3040, 0x3040, 0x3097, 0x3098, 0x3100, 0x3104, 0x312d, 0x3130, 0x318f, 0x318f, 0x31b8, 0x31ef, 0x321d, 0x321f, 0x3244, 0x3250, 0x327c, 0x327e, 0x32cc, 0x32cf, 0x32ff, 0x32ff, 0x3377, 0x337a, 0x33de, 0x33df, 0x33ff, 0x33ff, 0x4db6, 0x4dff, 0x9fa6, 0x9fff, 0xa48d, 0xa48f, 0xa4c7, 0xabff, 0xd7a4, 0xd7ff, 0xfa2e, 0xfa2f, 0xfa6b, 0xfaff, 0xfb07, 0xfb12, 0xfb18, 0xfb1c, 0xfb37, 0xfb37, 0xfb3d, 0xfb3d, 0xfb3f, 0xfb3f, 0xfb42, 0xfb42, 0xfb45, 0xfb45, 0xfbb2, 0xfbd2, 0xfd40, 0xfd4f, 0xfd90, 0xfd91, 0xfdc8, 0xfdcf, 0xfdfd, 0xfdff, 0xfe10, 0xfe1f, 0xfe24, 0xfe2f, 0xfe47, 0xfe48, 0xfe53, 0xfe53, 0xfe67, 0xfe67, 0xfe6c, 0xfe6f, 0xfe75, 0xfe75, 0xfefd, 0xfefe, 0xff00, 0xff00, 0xffbf, 0xffc1, 0xffc8, 0xffc9, 0xffd0, 0xffd1, 0xffd8, 0xffd9, 0xffdd, 0xffdf, 0xffe7, 0xffe7, 0xffef, 0xfff8, 0x10000, 0x102ff, 0x1031f, 0x1031f, 0x10324, 0x1032f, 0x1034b, 0x103ff, 0x10426, 0x10427, 0x1044e, 0x1cfff, 0x1d0f6, 0x1d0ff, 0x1d127, 0x1d129, 0x1d1de, 0x1d3ff, 0x1d455, 0x1d455, 0x1d49d, 0x1d49d, 0x1d4a0, 0x1d4a1, 0x1d4a3, 0x1d4a4, 0x1d4a7, 0x1d4a8, 0x1d4ad, 0x1d4ad, 0x1d4ba, 0x1d4ba, 0x1d4bc, 0x1d4bc, 0x1d4c1, 0x1d4c1, 0x1d4c4, 0x1d4c4, 0x1d506, 0x1d506, 0x1d50b, 0x1d50c, 0x1d515, 0x1d515, 0x1d51d, 0x1d51d, 0x1d53a, 0x1d53a, 0x1d53f, 0x1d53f, 0x1d545, 0x1d545, 0x1d547, 0x1d549, 0x1d551, 0x1d551, 0x1d6a4, 0x1d6a7, 0x1d7ca, 0x1d7cd, 0x1d800, 0x1fffd, 0x2a6d7, 0x2f7ff, 0x2fa1e, 0x2fffd, 0x30000, 0x3fffd, 0x40000, 0x4fffd, 0x50000, 0x5fffd, 0x60000, 0x6fffd, 0x70000, 0x7fffd, 0x80000, 0x8fffd, 0x90000, 0x9fffd, 0xa0000, 0xafffd, 0xb0000, 0xbfffd, 0xc0000, 0xcfffd, 0xd0000, 0xdfffd, 0xe0000, 0xe0000, 0xe0002, 0xe001f, 0xe0080, 0xefffd];
const isUnassignedCodePoint = character => inRange(character, unassigned_code_points);
const commonly_mapped_to_nothing = [0x00ad, 0x00ad, 0x034f, 0x034f, 0x1806, 0x1806, 0x180b, 0x180b, 0x180c, 0x180c, 0x180d, 0x180d, 0x200b, 0x200b, 0x200c, 0x200c, 0x200d, 0x200d, 0x2060, 0x2060, 0xfe00, 0xfe00, 0xfe01, 0xfe01, 0xfe02, 0xfe02, 0xfe03, 0xfe03, 0xfe04, 0xfe04, 0xfe05, 0xfe05, 0xfe06, 0xfe06, 0xfe07, 0xfe07, 0xfe08, 0xfe08, 0xfe09, 0xfe09, 0xfe0a, 0xfe0a, 0xfe0b, 0xfe0b, 0xfe0c, 0xfe0c, 0xfe0d, 0xfe0d, 0xfe0e, 0xfe0e, 0xfe0f, 0xfe0f, 0xfeff, 0xfeff];
const isCommonlyMappedToNothing = character => inRange(character, commonly_mapped_to_nothing);
const non_ASCII_space_characters = [0x00a0, 0x00a0, 0x1680, 0x1680, 0x2000, 0x2000, 0x2001, 0x2001, 0x2002, 0x2002, 0x2003, 0x2003, 0x2004, 0x2004, 0x2005, 0x2005, 0x2006, 0x2006, 0x2007, 0x2007, 0x2008, 0x2008, 0x2009, 0x2009, 0x200a, 0x200a, 0x200b, 0x200b, 0x202f, 0x202f, 0x205f, 0x205f, 0x3000, 0x3000];
const isNonASCIISpaceCharacter = character => inRange(character, non_ASCII_space_characters);
const non_ASCII_controls_characters = [0x0080, 0x009f, 0x06dd, 0x06dd, 0x070f, 0x070f, 0x180e, 0x180e, 0x200c, 0x200c, 0x200d, 0x200d, 0x2028, 0x2028, 0x2029, 0x2029, 0x2060, 0x2060, 0x2061, 0x2061, 0x2062, 0x2062, 0x2063, 0x2063, 0x206a, 0x206f, 0xfeff, 0xfeff, 0xfff9, 0xfffc, 0x1d173, 0x1d17a];
const non_character_codepoints = [0xfdd0, 0xfdef, 0xfffe, 0xffff, 0x1fffe, 0x1ffff, 0x2fffe, 0x2ffff, 0x3fffe, 0x3ffff, 0x4fffe, 0x4ffff, 0x5fffe, 0x5ffff, 0x6fffe, 0x6ffff, 0x7fffe, 0x7ffff, 0x8fffe, 0x8ffff, 0x9fffe, 0x9ffff, 0xafffe, 0xaffff, 0xbfffe, 0xbffff, 0xcfffe, 0xcffff, 0xdfffe, 0xdffff, 0xefffe, 0xeffff, 0x10fffe, 0x10ffff];
const prohibited_characters = [0, 0x001f, 0x007f, 0x007f, 0x0340, 0x0340, 0x0341, 0x0341, 0x200e, 0x200e, 0x200f, 0x200f, 0x202a, 0x202a, 0x202b, 0x202b, 0x202c, 0x202c, 0x202d, 0x202d, 0x202e, 0x202e, 0x206a, 0x206a, 0x206b, 0x206b, 0x206c, 0x206c, 0x206d, 0x206d, 0x206e, 0x206e, 0x206f, 0x206f, 0x2ff0, 0x2ffb, 0xd800, 0xdfff, 0xe000, 0xf8ff, 0xfff9, 0xfff9, 0xfffa, 0xfffa, 0xfffb, 0xfffb, 0xfffc, 0xfffc, 0xfffd, 0xfffd, 0xe0001, 0xe0001, 0xe0020, 0xe007f, 0xf0000, 0xffffd, 0x100000, 0x10fffd];
const isProhibitedCharacter = character => inRange(character, non_ASCII_space_characters) || inRange(character, prohibited_characters) || inRange(character, non_ASCII_controls_characters) || inRange(character, non_character_codepoints);
const bidirectional_r_al = [0x05be, 0x05be, 0x05c0, 0x05c0, 0x05c3, 0x05c3, 0x05d0, 0x05ea, 0x05f0, 0x05f4, 0x061b, 0x061b, 0x061f, 0x061f, 0x0621, 0x063a, 0x0640, 0x064a, 0x066d, 0x066f, 0x0671, 0x06d5, 0x06dd, 0x06dd, 0x06e5, 0x06e6, 0x06fa, 0x06fe, 0x0700, 0x070d, 0x0710, 0x0710, 0x0712, 0x072c, 0x0780, 0x07a5, 0x07b1, 0x07b1, 0x200f, 0x200f, 0xfb1d, 0xfb1d, 0xfb1f, 0xfb28, 0xfb2a, 0xfb36, 0xfb38, 0xfb3c, 0xfb3e, 0xfb3e, 0xfb40, 0xfb41, 0xfb43, 0xfb44, 0xfb46, 0xfbb1, 0xfbd3, 0xfd3d, 0xfd50, 0xfd8f, 0xfd92, 0xfdc7, 0xfdf0, 0xfdfc, 0xfe70, 0xfe74, 0xfe76, 0xfefc];
const isBidirectionalRAL = character => inRange(character, bidirectional_r_al);
const bidirectional_l = [0x0041, 0x005a, 0x0061, 0x007a, 0x00aa, 0x00aa, 0x00b5, 0x00b5, 0x00ba, 0x00ba, 0x00c0, 0x00d6, 0x00d8, 0x00f6, 0x00f8, 0x0220, 0x0222, 0x0233, 0x0250, 0x02ad, 0x02b0, 0x02b8, 0x02bb, 0x02c1, 0x02d0, 0x02d1, 0x02e0, 0x02e4, 0x02ee, 0x02ee, 0x037a, 0x037a, 0x0386, 0x0386, 0x0388, 0x038a, 0x038c, 0x038c, 0x038e, 0x03a1, 0x03a3, 0x03ce, 0x03d0, 0x03f5, 0x0400, 0x0482, 0x048a, 0x04ce, 0x04d0, 0x04f5, 0x04f8, 0x04f9, 0x0500, 0x050f, 0x0531, 0x0556, 0x0559, 0x055f, 0x0561, 0x0587, 0x0589, 0x0589, 0x0903, 0x0903, 0x0905, 0x0939, 0x093d, 0x0940, 0x0949, 0x094c, 0x0950, 0x0950, 0x0958, 0x0961, 0x0964, 0x0970, 0x0982, 0x0983, 0x0985, 0x098c, 0x098f, 0x0990, 0x0993, 0x09a8, 0x09aa, 0x09b0, 0x09b2, 0x09b2, 0x09b6, 0x09b9, 0x09be, 0x09c0, 0x09c7, 0x09c8, 0x09cb, 0x09cc, 0x09d7, 0x09d7, 0x09dc, 0x09dd, 0x09df, 0x09e1, 0x09e6, 0x09f1, 0x09f4, 0x09fa, 0x0a05, 0x0a0a, 0x0a0f, 0x0a10, 0x0a13, 0x0a28, 0x0a2a, 0x0a30, 0x0a32, 0x0a33, 0x0a35, 0x0a36, 0x0a38, 0x0a39, 0x0a3e, 0x0a40, 0x0a59, 0x0a5c, 0x0a5e, 0x0a5e, 0x0a66, 0x0a6f, 0x0a72, 0x0a74, 0x0a83, 0x0a83, 0x0a85, 0x0a8b, 0x0a8d, 0x0a8d, 0x0a8f, 0x0a91, 0x0a93, 0x0aa8, 0x0aaa, 0x0ab0, 0x0ab2, 0x0ab3, 0x0ab5, 0x0ab9, 0x0abd, 0x0ac0, 0x0ac9, 0x0ac9, 0x0acb, 0x0acc, 0x0ad0, 0x0ad0, 0x0ae0, 0x0ae0, 0x0ae6, 0x0aef, 0x0b02, 0x0b03, 0x0b05, 0x0b0c, 0x0b0f, 0x0b10, 0x0b13, 0x0b28, 0x0b2a, 0x0b30, 0x0b32, 0x0b33, 0x0b36, 0x0b39, 0x0b3d, 0x0b3e, 0x0b40, 0x0b40, 0x0b47, 0x0b48, 0x0b4b, 0x0b4c, 0x0b57, 0x0b57, 0x0b5c, 0x0b5d, 0x0b5f, 0x0b61, 0x0b66, 0x0b70, 0x0b83, 0x0b83, 0x0b85, 0x0b8a, 0x0b8e, 0x0b90, 0x0b92, 0x0b95, 0x0b99, 0x0b9a, 0x0b9c, 0x0b9c, 0x0b9e, 0x0b9f, 0x0ba3, 0x0ba4, 0x0ba8, 0x0baa, 0x0bae, 0x0bb5, 0x0bb7, 0x0bb9, 0x0bbe, 0x0bbf, 0x0bc1, 0x0bc2, 0x0bc6, 0x0bc8, 0x0bca, 0x0bcc, 0x0bd7, 0x0bd7, 0x0be7, 0x0bf2, 0x0c01, 0x0c03, 0x0c05, 0x0c0c, 0x0c0e, 0x0c10, 0x0c12, 0x0c28, 0x0c2a, 0x0c33, 0x0c35, 0x0c39, 0x0c41, 0x0c44, 0x0c60, 0x0c61, 0x0c66, 0x0c6f, 0x0c82, 0x0c83, 0x0c85, 0x0c8c, 0x0c8e, 0x0c90, 0x0c92, 0x0ca8, 0x0caa, 0x0cb3, 0x0cb5, 0x0cb9, 0x0cbe, 0x0cbe, 0x0cc0, 0x0cc4, 0x0cc7, 0x0cc8, 0x0cca, 0x0ccb, 0x0cd5, 0x0cd6, 0x0cde, 0x0cde, 0x0ce0, 0x0ce1, 0x0ce6, 0x0cef, 0x0d02, 0x0d03, 0x0d05, 0x0d0c, 0x0d0e, 0x0d10, 0x0d12, 0x0d28, 0x0d2a, 0x0d39, 0x0d3e, 0x0d40, 0x0d46, 0x0d48, 0x0d4a, 0x0d4c, 0x0d57, 0x0d57, 0x0d60, 0x0d61, 0x0d66, 0x0d6f, 0x0d82, 0x0d83, 0x0d85, 0x0d96, 0x0d9a, 0x0db1, 0x0db3, 0x0dbb, 0x0dbd, 0x0dbd, 0x0dc0, 0x0dc6, 0x0dcf, 0x0dd1, 0x0dd8, 0x0ddf, 0x0df2, 0x0df4, 0x0e01, 0x0e30, 0x0e32, 0x0e33, 0x0e40, 0x0e46, 0x0e4f, 0x0e5b, 0x0e81, 0x0e82, 0x0e84, 0x0e84, 0x0e87, 0x0e88, 0x0e8a, 0x0e8a, 0x0e8d, 0x0e8d, 0x0e94, 0x0e97, 0x0e99, 0x0e9f, 0x0ea1, 0x0ea3, 0x0ea5, 0x0ea5, 0x0ea7, 0x0ea7, 0x0eaa, 0x0eab, 0x0ead, 0x0eb0, 0x0eb2, 0x0eb3, 0x0ebd, 0x0ebd, 0x0ec0, 0x0ec4, 0x0ec6, 0x0ec6, 0x0ed0, 0x0ed9, 0x0edc, 0x0edd, 0x0f00, 0x0f17, 0x0f1a, 0x0f34, 0x0f36, 0x0f36, 0x0f38, 0x0f38, 0x0f3e, 0x0f47, 0x0f49, 0x0f6a, 0x0f7f, 0x0f7f, 0x0f85, 0x0f85, 0x0f88, 0x0f8b, 0x0fbe, 0x0fc5, 0x0fc7, 0x0fcc, 0x0fcf, 0x0fcf, 0x1000, 0x1021, 0x1023, 0x1027, 0x1029, 0x102a, 0x102c, 0x102c, 0x1031, 0x1031, 0x1038, 0x1038, 0x1040, 0x1057, 0x10a0, 0x10c5, 0x10d0, 0x10f8, 0x10fb, 0x10fb, 0x1100, 0x1159, 0x115f, 0x11a2, 0x11a8, 0x11f9, 0x1200, 0x1206, 0x1208, 0x1246, 0x1248, 0x1248, 0x124a, 0x124d, 0x1250, 0x1256, 0x1258, 0x1258, 0x125a, 0x125d, 0x1260, 0x1286, 0x1288, 0x1288, 0x128a, 0x128d, 0x1290, 0x12ae, 0x12b0, 0x12b0, 0x12b2, 0x12b5, 0x12b8, 0x12be, 0x12c0, 0x12c0, 0x12c2, 0x12c5, 0x12c8, 0x12ce, 0x12d0, 0x12d6, 0x12d8, 0x12ee, 0x12f0, 0x130e, 0x1310, 0x1310, 0x1312, 0x1315, 0x1318, 0x131e, 0x1320, 0x1346, 0x1348, 0x135a, 0x1361, 0x137c, 0x13a0, 0x13f4, 0x1401, 0x1676, 0x1681, 0x169a, 0x16a0, 0x16f0, 0x1700, 0x170c, 0x170e, 0x1711, 0x1720, 0x1731, 0x1735, 0x1736, 0x1740, 0x1751, 0x1760, 0x176c, 0x176e, 0x1770, 0x1780, 0x17b6, 0x17be, 0x17c5, 0x17c7, 0x17c8, 0x17d4, 0x17da, 0x17dc, 0x17dc, 0x17e0, 0x17e9, 0x1810, 0x1819, 0x1820, 0x1877, 0x1880, 0x18a8, 0x1e00, 0x1e9b, 0x1ea0, 0x1ef9, 0x1f00, 0x1f15, 0x1f18, 0x1f1d, 0x1f20, 0x1f45, 0x1f48, 0x1f4d, 0x1f50, 0x1f57, 0x1f59, 0x1f59, 0x1f5b, 0x1f5b, 0x1f5d, 0x1f5d, 0x1f5f, 0x1f7d, 0x1f80, 0x1fb4, 0x1fb6, 0x1fbc, 0x1fbe, 0x1fbe, 0x1fc2, 0x1fc4, 0x1fc6, 0x1fcc, 0x1fd0, 0x1fd3, 0x1fd6, 0x1fdb, 0x1fe0, 0x1fec, 0x1ff2, 0x1ff4, 0x1ff6, 0x1ffc, 0x200e, 0x200e, 0x2071, 0x2071, 0x207f, 0x207f, 0x2102, 0x2102, 0x2107, 0x2107, 0x210a, 0x2113, 0x2115, 0x2115, 0x2119, 0x211d, 0x2124, 0x2124, 0x2126, 0x2126, 0x2128, 0x2128, 0x212a, 0x212d, 0x212f, 0x2131, 0x2133, 0x2139, 0x213d, 0x213f, 0x2145, 0x2149, 0x2160, 0x2183, 0x2336, 0x237a, 0x2395, 0x2395, 0x249c, 0x24e9, 0x3005, 0x3007, 0x3021, 0x3029, 0x3031, 0x3035, 0x3038, 0x303c, 0x3041, 0x3096, 0x309d, 0x309f, 0x30a1, 0x30fa, 0x30fc, 0x30ff, 0x3105, 0x312c, 0x3131, 0x318e, 0x3190, 0x31b7, 0x31f0, 0x321c, 0x3220, 0x3243, 0x3260, 0x327b, 0x327f, 0x32b0, 0x32c0, 0x32cb, 0x32d0, 0x32fe, 0x3300, 0x3376, 0x337b, 0x33dd, 0x33e0, 0x33fe, 0x3400, 0x4db5, 0x4e00, 0x9fa5, 0xa000, 0xa48c, 0xac00, 0xd7a3, 0xd800, 0xfa2d, 0xfa30, 0xfa6a, 0xfb00, 0xfb06, 0xfb13, 0xfb17, 0xff21, 0xff3a, 0xff41, 0xff5a, 0xff66, 0xffbe, 0xffc2, 0xffc7, 0xffca, 0xffcf, 0xffd2, 0xffd7, 0xffda, 0xffdc, 0x10300, 0x1031e, 0x10320, 0x10323, 0x10330, 0x1034a, 0x10400, 0x10425, 0x10428, 0x1044d, 0x1d000, 0x1d0f5, 0x1d100, 0x1d126, 0x1d12a, 0x1d166, 0x1d16a, 0x1d172, 0x1d183, 0x1d184, 0x1d18c, 0x1d1a9, 0x1d1ae, 0x1d1dd, 0x1d400, 0x1d454, 0x1d456, 0x1d49c, 0x1d49e, 0x1d49f, 0x1d4a2, 0x1d4a2, 0x1d4a5, 0x1d4a6, 0x1d4a9, 0x1d4ac, 0x1d4ae, 0x1d4b9, 0x1d4bb, 0x1d4bb, 0x1d4bd, 0x1d4c0, 0x1d4c2, 0x1d4c3, 0x1d4c5, 0x1d505, 0x1d507, 0x1d50a, 0x1d50d, 0x1d514, 0x1d516, 0x1d51c, 0x1d51e, 0x1d539, 0x1d53b, 0x1d53e, 0x1d540, 0x1d544, 0x1d546, 0x1d546, 0x1d54a, 0x1d550, 0x1d552, 0x1d6a3, 0x1d6a8, 0x1d7c9, 0x20000, 0x2a6d6, 0x2f800, 0x2fa1d, 0xf0000, 0xffffd, 0x100000, 0x10fffd];
const isBidirectionalL = character => inRange(character, bidirectional_l);

const mapping2space = isNonASCIISpaceCharacter;
const mapping2nothing = isCommonlyMappedToNothing;
const getCodePoint = character => character.codePointAt(0);
const first = x => x[0];
const last = x => x[x.length - 1];
function toCodePoints(input) {
  const codepoints = [];
  const size = input.length;
  for (let i = 0; i < size; i += 1) {
    const before = input.charCodeAt(i);
    if (before >= 0xd800 && before <= 0xdbff && size > i + 1) {
      const next = input.charCodeAt(i + 1);
      if (next >= 0xdc00 && next <= 0xdfff) {
        codepoints.push((before - 0xd800) * 0x400 + next - 0xdc00 + 0x10000);
        i += 1;
        continue;
      }
    }
    codepoints.push(before);
  }
  return codepoints;
}
function saslprep(input, opts = {}) {
  if (typeof input !== 'string') {
    throw new TypeError('Expected string.');
  }
  if (input.length === 0) {
    return '';
  }
  const mapped_input = toCodePoints(input).map(character => mapping2space(character) ? 0x20 : character).filter(character => !mapping2nothing(character));
  const normalized_input = String.fromCodePoint.apply(null, mapped_input).normalize('NFKC');
  const normalized_map = toCodePoints(normalized_input);
  const hasProhibited = normalized_map.some(isProhibitedCharacter);
  if (hasProhibited) {
    throw new Error('Prohibited character, see https://tools.ietf.org/html/rfc4013#section-2.3');
  }
  if (opts.allowUnassigned !== true) {
    const hasUnassigned = normalized_map.some(isUnassignedCodePoint);
    if (hasUnassigned) {
      throw new Error('Unassigned code point, see https://tools.ietf.org/html/rfc4013#section-2.5');
    }
  }
  const hasBidiRAL = normalized_map.some(isBidirectionalRAL);
  const hasBidiL = normalized_map.some(isBidirectionalL);
  if (hasBidiRAL && hasBidiL) {
    throw new Error('String must not contain RandALCat and LCat at the same time,' + ' see https://tools.ietf.org/html/rfc3454#section-6');
  }
  const isFirstBidiRAL = isBidirectionalRAL(getCodePoint(first(normalized_input)));
  const isLastBidiRAL = isBidirectionalRAL(getCodePoint(last(normalized_input)));
  if (hasBidiRAL && !(isFirstBidiRAL && isLastBidiRAL)) {
    throw new Error('Bidirectional RandALCat character must be the first and the last' + ' character of the string, see https://tools.ietf.org/html/rfc3454#section-6');
  }
  return normalized_input;
}

class PDFSecurity {
  static generateFileID(info = {}) {
    let infoStr = `${info.CreationDate.getTime()}\n`;
    for (let key in info) {
      if (!info.hasOwnProperty(key)) {
        continue;
      }
      infoStr += `${key}: ${info[key].valueOf()}\n`;
    }
    return wordArrayToBuffer(CryptoJS.MD5(infoStr));
  }
  static generateRandomWordArray(bytes) {
    return CryptoJS.lib.WordArray.random(bytes);
  }
  static create(document, options = {}) {
    if (!options.ownerPassword && !options.userPassword) {
      return null;
    }
    return new PDFSecurity(document, options);
  }
  constructor(document, options = {}) {
    if (!options.ownerPassword && !options.userPassword) {
      throw new Error('None of owner password and user password is defined.');
    }
    this.document = document;
    this._setupEncryption(options);
  }
  _setupEncryption(options) {
    switch (options.pdfVersion) {
      case '1.4':
      case '1.5':
        this.version = 2;
        break;
      case '1.6':
      case '1.7':
        this.version = 4;
        break;
      case '1.7ext3':
        this.version = 5;
        break;
      default:
        this.version = 1;
        break;
    }
    const encDict = {
      Filter: 'Standard'
    };
    switch (this.version) {
      case 1:
      case 2:
      case 4:
        this._setupEncryptionV1V2V4(this.version, encDict, options);
        break;
      case 5:
        this._setupEncryptionV5(encDict, options);
        break;
    }
    this.dictionary = this.document.ref(encDict);
  }
  _setupEncryptionV1V2V4(v, encDict, options) {
    let r, permissions;
    switch (v) {
      case 1:
        r = 2;
        this.keyBits = 40;
        permissions = getPermissionsR2(options.permissions);
        break;
      case 2:
        r = 3;
        this.keyBits = 128;
        permissions = getPermissionsR3(options.permissions);
        break;
      case 4:
        r = 4;
        this.keyBits = 128;
        permissions = getPermissionsR3(options.permissions);
        break;
    }
    const paddedUserPassword = processPasswordR2R3R4(options.userPassword);
    const paddedOwnerPassword = options.ownerPassword ? processPasswordR2R3R4(options.ownerPassword) : paddedUserPassword;
    const ownerPasswordEntry = getOwnerPasswordR2R3R4(r, this.keyBits, paddedUserPassword, paddedOwnerPassword);
    this.encryptionKey = getEncryptionKeyR2R3R4(r, this.keyBits, this.document._id, paddedUserPassword, ownerPasswordEntry, permissions);
    let userPasswordEntry;
    if (r === 2) {
      userPasswordEntry = getUserPasswordR2(this.encryptionKey);
    } else {
      userPasswordEntry = getUserPasswordR3R4(this.document._id, this.encryptionKey);
    }
    encDict.V = v;
    if (v >= 2) {
      encDict.Length = this.keyBits;
    }
    if (v === 4) {
      encDict.CF = {
        StdCF: {
          AuthEvent: 'DocOpen',
          CFM: 'AESV2',
          Length: this.keyBits / 8
        }
      };
      encDict.StmF = 'StdCF';
      encDict.StrF = 'StdCF';
    }
    encDict.R = r;
    encDict.O = wordArrayToBuffer(ownerPasswordEntry);
    encDict.U = wordArrayToBuffer(userPasswordEntry);
    encDict.P = permissions;
  }
  _setupEncryptionV5(encDict, options) {
    this.keyBits = 256;
    const permissions = getPermissionsR3(options.permissions);
    const processedUserPassword = processPasswordR5(options.userPassword);
    const processedOwnerPassword = options.ownerPassword ? processPasswordR5(options.ownerPassword) : processedUserPassword;
    this.encryptionKey = getEncryptionKeyR5(PDFSecurity.generateRandomWordArray);
    const userPasswordEntry = getUserPasswordR5(processedUserPassword, PDFSecurity.generateRandomWordArray);
    const userKeySalt = CryptoJS.lib.WordArray.create(userPasswordEntry.words.slice(10, 12), 8);
    const userEncryptionKeyEntry = getUserEncryptionKeyR5(processedUserPassword, userKeySalt, this.encryptionKey);
    const ownerPasswordEntry = getOwnerPasswordR5(processedOwnerPassword, userPasswordEntry, PDFSecurity.generateRandomWordArray);
    const ownerKeySalt = CryptoJS.lib.WordArray.create(ownerPasswordEntry.words.slice(10, 12), 8);
    const ownerEncryptionKeyEntry = getOwnerEncryptionKeyR5(processedOwnerPassword, ownerKeySalt, userPasswordEntry, this.encryptionKey);
    const permsEntry = getEncryptedPermissionsR5(permissions, this.encryptionKey, PDFSecurity.generateRandomWordArray);
    encDict.V = 5;
    encDict.Length = this.keyBits;
    encDict.CF = {
      StdCF: {
        AuthEvent: 'DocOpen',
        CFM: 'AESV3',
        Length: this.keyBits / 8
      }
    };
    encDict.StmF = 'StdCF';
    encDict.StrF = 'StdCF';
    encDict.R = 5;
    encDict.O = wordArrayToBuffer(ownerPasswordEntry);
    encDict.OE = wordArrayToBuffer(ownerEncryptionKeyEntry);
    encDict.U = wordArrayToBuffer(userPasswordEntry);
    encDict.UE = wordArrayToBuffer(userEncryptionKeyEntry);
    encDict.P = permissions;
    encDict.Perms = wordArrayToBuffer(permsEntry);
  }
  getEncryptFn(obj, gen) {
    let digest;
    if (this.version < 5) {
      digest = this.encryptionKey.clone().concat(CryptoJS.lib.WordArray.create([(obj & 0xff) << 24 | (obj & 0xff00) << 8 | obj >> 8 & 0xff00 | gen & 0xff, (gen & 0xff00) << 16], 5));
    }
    if (this.version === 1 || this.version === 2) {
      let key = CryptoJS.MD5(digest);
      key.sigBytes = Math.min(16, this.keyBits / 8 + 5);
      return buffer => wordArrayToBuffer(CryptoJS.RC4.encrypt(CryptoJS.lib.WordArray.create(buffer), key).ciphertext);
    }
    let key;
    if (this.version === 4) {
      key = CryptoJS.MD5(digest.concat(CryptoJS.lib.WordArray.create([0x73416c54], 4)));
    } else {
      key = this.encryptionKey;
    }
    const iv = PDFSecurity.generateRandomWordArray(16);
    const options = {
      mode: CryptoJS.mode.CBC,
      padding: CryptoJS.pad.Pkcs7,
      iv
    };
    return buffer => wordArrayToBuffer(iv.clone().concat(CryptoJS.AES.encrypt(CryptoJS.lib.WordArray.create(buffer), key, options).ciphertext));
  }
  end() {
    this.dictionary.end();
  }
}
function getPermissionsR2(permissionObject = {}) {
  let permissions = 0xffffffc0 >> 0;
  if (permissionObject.printing) {
    permissions |= 0b000000000100;
  }
  if (permissionObject.modifying) {
    permissions |= 0b000000001000;
  }
  if (permissionObject.copying) {
    permissions |= 0b000000010000;
  }
  if (permissionObject.annotating) {
    permissions |= 0b000000100000;
  }
  return permissions;
}
function getPermissionsR3(permissionObject = {}) {
  let permissions = 0xfffff0c0 >> 0;
  if (permissionObject.printing === 'lowResolution') {
    permissions |= 0b000000000100;
  }
  if (permissionObject.printing === 'highResolution') {
    permissions |= 0b100000000100;
  }
  if (permissionObject.modifying) {
    permissions |= 0b000000001000;
  }
  if (permissionObject.copying) {
    permissions |= 0b000000010000;
  }
  if (permissionObject.annotating) {
    permissions |= 0b000000100000;
  }
  if (permissionObject.fillingForms) {
    permissions |= 0b000100000000;
  }
  if (permissionObject.contentAccessibility) {
    permissions |= 0b001000000000;
  }
  if (permissionObject.documentAssembly) {
    permissions |= 0b010000000000;
  }
  return permissions;
}
function getUserPasswordR2(encryptionKey) {
  return CryptoJS.RC4.encrypt(processPasswordR2R3R4(), encryptionKey).ciphertext;
}
function getUserPasswordR3R4(documentId, encryptionKey) {
  const key = encryptionKey.clone();
  let cipher = CryptoJS.MD5(processPasswordR2R3R4().concat(CryptoJS.lib.WordArray.create(documentId)));
  for (let i = 0; i < 20; i++) {
    const xorRound = Math.ceil(key.sigBytes / 4);
    for (let j = 0; j < xorRound; j++) {
      key.words[j] = encryptionKey.words[j] ^ (i | i << 8 | i << 16 | i << 24);
    }
    cipher = CryptoJS.RC4.encrypt(cipher, key).ciphertext;
  }
  return cipher.concat(CryptoJS.lib.WordArray.create(null, 16));
}
function getOwnerPasswordR2R3R4(r, keyBits, paddedUserPassword, paddedOwnerPassword) {
  let digest = paddedOwnerPassword;
  let round = r >= 3 ? 51 : 1;
  for (let i = 0; i < round; i++) {
    digest = CryptoJS.MD5(digest);
  }
  const key = digest.clone();
  key.sigBytes = keyBits / 8;
  let cipher = paddedUserPassword;
  round = r >= 3 ? 20 : 1;
  for (let i = 0; i < round; i++) {
    const xorRound = Math.ceil(key.sigBytes / 4);
    for (let j = 0; j < xorRound; j++) {
      key.words[j] = digest.words[j] ^ (i | i << 8 | i << 16 | i << 24);
    }
    cipher = CryptoJS.RC4.encrypt(cipher, key).ciphertext;
  }
  return cipher;
}
function getEncryptionKeyR2R3R4(r, keyBits, documentId, paddedUserPassword, ownerPasswordEntry, permissions) {
  let key = paddedUserPassword.clone().concat(ownerPasswordEntry).concat(CryptoJS.lib.WordArray.create([lsbFirstWord(permissions)], 4)).concat(CryptoJS.lib.WordArray.create(documentId));
  const round = r >= 3 ? 51 : 1;
  for (let i = 0; i < round; i++) {
    key = CryptoJS.MD5(key);
    key.sigBytes = keyBits / 8;
  }
  return key;
}
function getUserPasswordR5(processedUserPassword, generateRandomWordArray) {
  const validationSalt = generateRandomWordArray(8);
  const keySalt = generateRandomWordArray(8);
  return CryptoJS.SHA256(processedUserPassword.clone().concat(validationSalt)).concat(validationSalt).concat(keySalt);
}
function getUserEncryptionKeyR5(processedUserPassword, userKeySalt, encryptionKey) {
  const key = CryptoJS.SHA256(processedUserPassword.clone().concat(userKeySalt));
  const options = {
    mode: CryptoJS.mode.CBC,
    padding: CryptoJS.pad.NoPadding,
    iv: CryptoJS.lib.WordArray.create(null, 16)
  };
  return CryptoJS.AES.encrypt(encryptionKey, key, options).ciphertext;
}
function getOwnerPasswordR5(processedOwnerPassword, userPasswordEntry, generateRandomWordArray) {
  const validationSalt = generateRandomWordArray(8);
  const keySalt = generateRandomWordArray(8);
  return CryptoJS.SHA256(processedOwnerPassword.clone().concat(validationSalt).concat(userPasswordEntry)).concat(validationSalt).concat(keySalt);
}
function getOwnerEncryptionKeyR5(processedOwnerPassword, ownerKeySalt, userPasswordEntry, encryptionKey) {
  const key = CryptoJS.SHA256(processedOwnerPassword.clone().concat(ownerKeySalt).concat(userPasswordEntry));
  const options = {
    mode: CryptoJS.mode.CBC,
    padding: CryptoJS.pad.NoPadding,
    iv: CryptoJS.lib.WordArray.create(null, 16)
  };
  return CryptoJS.AES.encrypt(encryptionKey, key, options).ciphertext;
}
function getEncryptionKeyR5(generateRandomWordArray) {
  return generateRandomWordArray(32);
}
function getEncryptedPermissionsR5(permissions, encryptionKey, generateRandomWordArray) {
  const cipher = CryptoJS.lib.WordArray.create([lsbFirstWord(permissions), 0xffffffff, 0x54616462], 12).concat(generateRandomWordArray(4));
  const options = {
    mode: CryptoJS.mode.ECB,
    padding: CryptoJS.pad.NoPadding
  };
  return CryptoJS.AES.encrypt(cipher, encryptionKey, options).ciphertext;
}
function processPasswordR2R3R4(password = '') {
  const out = Buffer.alloc(32);
  const length = password.length;
  let index = 0;
  while (index < length && index < 32) {
    const code = password.charCodeAt(index);
    if (code > 0xff) {
      throw new Error('Password contains one or more invalid characters.');
    }
    out[index] = code;
    index++;
  }
  while (index < 32) {
    out[index] = PASSWORD_PADDING[index - length];
    index++;
  }
  return CryptoJS.lib.WordArray.create(out);
}
function processPasswordR5(password = '') {
  password = unescape(encodeURIComponent(saslprep(password)));
  const length = Math.min(127, password.length);
  const out = Buffer.alloc(length);
  for (let i = 0; i < length; i++) {
    out[i] = password.charCodeAt(i);
  }
  return CryptoJS.lib.WordArray.create(out);
}
function lsbFirstWord(data) {
  return (data & 0xff) << 24 | (data & 0xff00) << 8 | data >> 8 & 0xff00 | data >> 24 & 0xff;
}
function wordArrayToBuffer(wordArray) {
  const byteArray = [];
  for (let i = 0; i < wordArray.sigBytes; i++) {
    byteArray.push(wordArray.words[Math.floor(i / 4)] >> 8 * (3 - i % 4) & 0xff);
  }
  return Buffer.from(byteArray);
}
const PASSWORD_PADDING = [0x28, 0xbf, 0x4e, 0x5e, 0x4e, 0x75, 0x8a, 0x41, 0x64, 0x00, 0x4e, 0x56, 0xff, 0xfa, 0x01, 0x08, 0x2e, 0x2e, 0x00, 0xb6, 0xd0, 0x68, 0x3e, 0x80, 0x2f, 0x0c, 0xa9, 0xfe, 0x64, 0x53, 0x69, 0x7a];

const {
  number: number$2
} = PDFObject;
class PDFGradient$1 {
  constructor(doc) {
    this.doc = doc;
    this.stops = [];
    this.embedded = false;
    this.transform = [1, 0, 0, 1, 0, 0];
  }
  stop(pos, color, opacity) {
    if (opacity == null) {
      opacity = 1;
    }
    color = this.doc._normalizeColor(color);
    if (this.stops.length === 0) {
      if (color.length === 3) {
        this._colorSpace = 'DeviceRGB';
      } else if (color.length === 4) {
        this._colorSpace = 'DeviceCMYK';
      } else if (color.length === 1) {
        this._colorSpace = 'DeviceGray';
      } else {
        throw new Error('Unknown color space');
      }
    } else if (this._colorSpace === 'DeviceRGB' && color.length !== 3 || this._colorSpace === 'DeviceCMYK' && color.length !== 4 || this._colorSpace === 'DeviceGray' && color.length !== 1) {
      throw new Error('All gradient stops must use the same color space');
    }
    opacity = Math.max(0, Math.min(1, opacity));
    this.stops.push([pos, color, opacity]);
    return this;
  }
  setTransform(m11, m12, m21, m22, dx, dy) {
    this.transform = [m11, m12, m21, m22, dx, dy];
    return this;
  }
  embed(m) {
    let fn;
    const stopsLength = this.stops.length;
    if (stopsLength === 0) {
      return;
    }
    this.embedded = true;
    this.matrix = m;
    const last = this.stops[stopsLength - 1];
    if (last[0] < 1) {
      this.stops.push([1, last[1], last[2]]);
    }
    const bounds = [];
    const encode = [];
    const stops = [];
    for (let i = 0; i < stopsLength - 1; i++) {
      encode.push(0, 1);
      if (i + 2 !== stopsLength) {
        bounds.push(this.stops[i + 1][0]);
      }
      fn = this.doc.ref({
        FunctionType: 2,
        Domain: [0, 1],
        C0: this.stops[i + 0][1],
        C1: this.stops[i + 1][1],
        N: 1
      });
      stops.push(fn);
      fn.end();
    }
    if (stopsLength === 1) {
      fn = stops[0];
    } else {
      fn = this.doc.ref({
        FunctionType: 3,
        Domain: [0, 1],
        Functions: stops,
        Bounds: bounds,
        Encode: encode
      });
      fn.end();
    }
    this.id = `Sh${++this.doc._gradCount}`;
    const shader = this.shader(fn);
    shader.end();
    const pattern = this.doc.ref({
      Type: 'Pattern',
      PatternType: 2,
      Shading: shader,
      Matrix: this.matrix.map(number$2)
    });
    pattern.end();
    if (this.stops.some(stop => stop[2] < 1)) {
      let grad = this.opacityGradient();
      grad._colorSpace = 'DeviceGray';
      for (let stop of this.stops) {
        grad.stop(stop[0], [stop[2]]);
      }
      grad = grad.embed(this.matrix);
      const pageBBox = [0, 0, this.doc.page.width, this.doc.page.height];
      const form = this.doc.ref({
        Type: 'XObject',
        Subtype: 'Form',
        FormType: 1,
        BBox: pageBBox,
        Group: {
          Type: 'Group',
          S: 'Transparency',
          CS: 'DeviceGray'
        },
        Resources: {
          ProcSet: ['PDF', 'Text', 'ImageB', 'ImageC', 'ImageI'],
          Pattern: {
            Sh1: grad
          }
        }
      });
      form.write('/Pattern cs /Sh1 scn');
      form.end(`${pageBBox.join(' ')} re f`);
      const gstate = this.doc.ref({
        Type: 'ExtGState',
        SMask: {
          Type: 'Mask',
          S: 'Luminosity',
          G: form
        }
      });
      gstate.end();
      const opacityPattern = this.doc.ref({
        Type: 'Pattern',
        PatternType: 1,
        PaintType: 1,
        TilingType: 2,
        BBox: pageBBox,
        XStep: pageBBox[2],
        YStep: pageBBox[3],
        Resources: {
          ProcSet: ['PDF', 'Text', 'ImageB', 'ImageC', 'ImageI'],
          Pattern: {
            Sh1: pattern
          },
          ExtGState: {
            Gs1: gstate
          }
        }
      });
      opacityPattern.write('/Gs1 gs /Pattern cs /Sh1 scn');
      opacityPattern.end(`${pageBBox.join(' ')} re f`);
      this.doc.page.patterns[this.id] = opacityPattern;
    } else {
      this.doc.page.patterns[this.id] = pattern;
    }
    return pattern;
  }
  apply(stroke) {
    const [m0, m1, m2, m3, m4, m5] = this.doc._ctm;
    const [m11, m12, m21, m22, dx, dy] = this.transform;
    const m = [m0 * m11 + m2 * m12, m1 * m11 + m3 * m12, m0 * m21 + m2 * m22, m1 * m21 + m3 * m22, m0 * dx + m2 * dy + m4, m1 * dx + m3 * dy + m5];
    if (!this.embedded || m.join(' ') !== this.matrix.join(' ')) {
      this.embed(m);
    }
    this.doc._setColorSpace('Pattern', stroke);
    const op = stroke ? 'SCN' : 'scn';
    return this.doc.addContent(`/${this.id} ${op}`);
  }
}
class PDFLinearGradient$1 extends PDFGradient$1 {
  constructor(doc, x1, y1, x2, y2) {
    super(doc);
    this.x1 = x1;
    this.y1 = y1;
    this.x2 = x2;
    this.y2 = y2;
  }
  shader(fn) {
    return this.doc.ref({
      ShadingType: 2,
      ColorSpace: this._colorSpace,
      Coords: [this.x1, this.y1, this.x2, this.y2],
      Function: fn,
      Extend: [true, true]
    });
  }
  opacityGradient() {
    return new PDFLinearGradient$1(this.doc, this.x1, this.y1, this.x2, this.y2);
  }
}
class PDFRadialGradient$1 extends PDFGradient$1 {
  constructor(doc, x1, y1, r1, x2, y2, r2) {
    super(doc);
    this.doc = doc;
    this.x1 = x1;
    this.y1 = y1;
    this.r1 = r1;
    this.x2 = x2;
    this.y2 = y2;
    this.r2 = r2;
  }
  shader(fn) {
    return this.doc.ref({
      ShadingType: 3,
      ColorSpace: this._colorSpace,
      Coords: [this.x1, this.y1, this.r1, this.x2, this.y2, this.r2],
      Function: fn,
      Extend: [true, true]
    });
  }
  opacityGradient() {
    return new PDFRadialGradient$1(this.doc, this.x1, this.y1, this.r1, this.x2, this.y2, this.r2);
  }
}
var Gradient = {
  PDFGradient: PDFGradient$1,
  PDFLinearGradient: PDFLinearGradient$1,
  PDFRadialGradient: PDFRadialGradient$1
};

const underlyingColorSpaces = ['DeviceCMYK', 'DeviceRGB'];
class PDFTilingPattern$1 {
  constructor(doc, bBox, xStep, yStep, stream) {
    this.doc = doc;
    this.bBox = bBox;
    this.xStep = xStep;
    this.yStep = yStep;
    this.stream = stream;
  }
  createPattern() {
    const resources = this.doc.ref();
    resources.end();
    const [m0, m1, m2, m3, m4, m5] = this.doc._ctm;
    const [m11, m12, m21, m22, dx, dy] = [1, 0, 0, 1, 0, 0];
    const m = [m0 * m11 + m2 * m12, m1 * m11 + m3 * m12, m0 * m21 + m2 * m22, m1 * m21 + m3 * m22, m0 * dx + m2 * dy + m4, m1 * dx + m3 * dy + m5];
    const pattern = this.doc.ref({
      Type: 'Pattern',
      PatternType: 1,
      PaintType: 2,
      TilingType: 2,
      BBox: this.bBox,
      XStep: this.xStep,
      YStep: this.yStep,
      Matrix: m.map(v => +v.toFixed(5)),
      Resources: resources
    });
    pattern.end(this.stream);
    return pattern;
  }
  embedPatternColorSpaces() {
    underlyingColorSpaces.forEach(csName => {
      const csId = this.getPatternColorSpaceId(csName);
      if (this.doc.page.colorSpaces[csId]) return;
      const cs = this.doc.ref(['Pattern', csName]);
      cs.end();
      this.doc.page.colorSpaces[csId] = cs;
    });
  }
  getPatternColorSpaceId(underlyingColorspace) {
    return `CsP${underlyingColorspace}`;
  }
  embed() {
    if (!this.id) {
      this.doc._patternCount = this.doc._patternCount + 1;
      this.id = 'P' + this.doc._patternCount;
      this.pattern = this.createPattern();
    }
    if (!this.doc.page.patterns[this.id]) {
      this.doc.page.patterns[this.id] = this.pattern;
    }
  }
  apply(stroke, patternColor) {
    this.embedPatternColorSpaces();
    this.embed();
    const normalizedColor = this.doc._normalizeColor(patternColor);
    if (!normalizedColor) throw Error(`invalid pattern color. (value: ${patternColor})`);
    const csId = this.getPatternColorSpaceId(this.doc._getColorSpace(normalizedColor));
    this.doc._setColorSpace(csId, stroke);
    const op = stroke ? 'SCN' : 'scn';
    return this.doc.addContent(`${normalizedColor.join(' ')} /${this.id} ${op}`);
  }
}
var pattern = {
  PDFTilingPattern: PDFTilingPattern$1
};

const {
  PDFGradient,
  PDFLinearGradient,
  PDFRadialGradient
} = Gradient;
const {
  PDFTilingPattern
} = pattern;
var ColorMixin = {
  initColor() {
    this.spotColors = {};
    this._opacityRegistry = {};
    this._opacityCount = 0;
    this._patternCount = 0;
    this._gradCount = 0;
  },
  _normalizeColor(color) {
    if (typeof color === 'string') {
      if (color.charAt(0) === '#') {
        if (color.length === 4) {
          color = color.replace(/#([0-9A-F])([0-9A-F])([0-9A-F])/i, '#$1$1$2$2$3$3');
        }
        const hex = parseInt(color.slice(1), 16);
        color = [hex >> 16, hex >> 8 & 0xff, hex & 0xff];
      } else if (namedColors[color]) {
        color = namedColors[color];
      } else if (this.spotColors[color]) {
        return this.spotColors[color];
      }
    }
    if (Array.isArray(color)) {
      if (color.length === 3) {
        color = color.map(part => part / 255);
      } else if (color.length === 4) {
        color = color.map(part => part / 100);
      }
      return color;
    }
    return null;
  },
  _setColor(color, stroke) {
    if (color instanceof PDFGradient) {
      color.apply(stroke);
      return true;
    } else if (Array.isArray(color) && color[0] instanceof PDFTilingPattern) {
      color[0].apply(stroke, color[1]);
      return true;
    }
    return this._setColorCore(color, stroke);
  },
  _setColorCore(color, stroke) {
    color = this._normalizeColor(color);
    if (!color) {
      return false;
    }
    const op = stroke ? 'SCN' : 'scn';
    const space = this._getColorSpace(color);
    this._setColorSpace(space, stroke);
    if (color instanceof SpotColor) {
      this.page.colorSpaces[color.id] = color.ref;
      this.addContent(`1 ${op}`);
    } else {
      this.addContent(`${color.join(' ')} ${op}`);
    }
    return true;
  },
  _setColorSpace(space, stroke) {
    const op = stroke ? 'CS' : 'cs';
    return this.addContent(`/${space} ${op}`);
  },
  _getColorSpace(color) {
    if (color instanceof SpotColor) {
      return color.id;
    }
    return color.length === 4 ? 'DeviceCMYK' : 'DeviceRGB';
  },
  fillColor(color, opacity) {
    const set = this._setColor(color, false);
    if (set) {
      this.fillOpacity(opacity);
    }
    this._fillColor = [color, opacity];
    return this;
  },
  strokeColor(color, opacity) {
    const set = this._setColor(color, true);
    if (set) {
      this.strokeOpacity(opacity);
    }
    return this;
  },
  opacity(opacity) {
    this._doOpacity(opacity, opacity);
    return this;
  },
  fillOpacity(opacity) {
    this._doOpacity(opacity, null);
    return this;
  },
  strokeOpacity(opacity) {
    this._doOpacity(null, opacity);
    return this;
  },
  _doOpacity(fillOpacity, strokeOpacity) {
    let dictionary, name;
    if (fillOpacity == null && strokeOpacity == null) {
      return;
    }
    if (fillOpacity != null) {
      fillOpacity = Math.max(0, Math.min(1, fillOpacity));
    }
    if (strokeOpacity != null) {
      strokeOpacity = Math.max(0, Math.min(1, strokeOpacity));
    }
    const key = `${fillOpacity}_${strokeOpacity}`;
    if (this._opacityRegistry[key]) {
      [dictionary, name] = this._opacityRegistry[key];
    } else {
      dictionary = {
        Type: 'ExtGState'
      };
      if (fillOpacity != null) {
        dictionary.ca = fillOpacity;
      }
      if (strokeOpacity != null) {
        dictionary.CA = strokeOpacity;
      }
      dictionary = this.ref(dictionary);
      dictionary.end();
      const id = ++this._opacityCount;
      name = `Gs${id}`;
      this._opacityRegistry[key] = [dictionary, name];
    }
    this.page.ext_gstates[name] = dictionary;
    return this.addContent(`/${name} gs`);
  },
  linearGradient(x1, y1, x2, y2) {
    return new PDFLinearGradient(this, x1, y1, x2, y2);
  },
  radialGradient(x1, y1, r1, x2, y2, r2) {
    return new PDFRadialGradient(this, x1, y1, r1, x2, y2, r2);
  },
  pattern(bbox, xStep, yStep, stream) {
    return new PDFTilingPattern(this, bbox, xStep, yStep, stream);
  },
  addSpotColor(name, C, M, Y, K) {
    const color = new SpotColor(this, name, C, M, Y, K);
    this.spotColors[name] = color;
    return this;
  }
};
var namedColors = {
  aliceblue: [240, 248, 255],
  antiquewhite: [250, 235, 215],
  aqua: [0, 255, 255],
  aquamarine: [127, 255, 212],
  azure: [240, 255, 255],
  beige: [245, 245, 220],
  bisque: [255, 228, 196],
  black: [0, 0, 0],
  blanchedalmond: [255, 235, 205],
  blue: [0, 0, 255],
  blueviolet: [138, 43, 226],
  brown: [165, 42, 42],
  burlywood: [222, 184, 135],
  cadetblue: [95, 158, 160],
  chartreuse: [127, 255, 0],
  chocolate: [210, 105, 30],
  coral: [255, 127, 80],
  cornflowerblue: [100, 149, 237],
  cornsilk: [255, 248, 220],
  crimson: [220, 20, 60],
  cyan: [0, 255, 255],
  darkblue: [0, 0, 139],
  darkcyan: [0, 139, 139],
  darkgoldenrod: [184, 134, 11],
  darkgray: [169, 169, 169],
  darkgreen: [0, 100, 0],
  darkgrey: [169, 169, 169],
  darkkhaki: [189, 183, 107],
  darkmagenta: [139, 0, 139],
  darkolivegreen: [85, 107, 47],
  darkorange: [255, 140, 0],
  darkorchid: [153, 50, 204],
  darkred: [139, 0, 0],
  darksalmon: [233, 150, 122],
  darkseagreen: [143, 188, 143],
  darkslateblue: [72, 61, 139],
  darkslategray: [47, 79, 79],
  darkslategrey: [47, 79, 79],
  darkturquoise: [0, 206, 209],
  darkviolet: [148, 0, 211],
  deeppink: [255, 20, 147],
  deepskyblue: [0, 191, 255],
  dimgray: [105, 105, 105],
  dimgrey: [105, 105, 105],
  dodgerblue: [30, 144, 255],
  firebrick: [178, 34, 34],
  floralwhite: [255, 250, 240],
  forestgreen: [34, 139, 34],
  fuchsia: [255, 0, 255],
  gainsboro: [220, 220, 220],
  ghostwhite: [248, 248, 255],
  gold: [255, 215, 0],
  goldenrod: [218, 165, 32],
  gray: [128, 128, 128],
  grey: [128, 128, 128],
  green: [0, 128, 0],
  greenyellow: [173, 255, 47],
  honeydew: [240, 255, 240],
  hotpink: [255, 105, 180],
  indianred: [205, 92, 92],
  indigo: [75, 0, 130],
  ivory: [255, 255, 240],
  khaki: [240, 230, 140],
  lavender: [230, 230, 250],
  lavenderblush: [255, 240, 245],
  lawngreen: [124, 252, 0],
  lemonchiffon: [255, 250, 205],
  lightblue: [173, 216, 230],
  lightcoral: [240, 128, 128],
  lightcyan: [224, 255, 255],
  lightgoldenrodyellow: [250, 250, 210],
  lightgray: [211, 211, 211],
  lightgreen: [144, 238, 144],
  lightgrey: [211, 211, 211],
  lightpink: [255, 182, 193],
  lightsalmon: [255, 160, 122],
  lightseagreen: [32, 178, 170],
  lightskyblue: [135, 206, 250],
  lightslategray: [119, 136, 153],
  lightslategrey: [119, 136, 153],
  lightsteelblue: [176, 196, 222],
  lightyellow: [255, 255, 224],
  lime: [0, 255, 0],
  limegreen: [50, 205, 50],
  linen: [250, 240, 230],
  magenta: [255, 0, 255],
  maroon: [128, 0, 0],
  mediumaquamarine: [102, 205, 170],
  mediumblue: [0, 0, 205],
  mediumorchid: [186, 85, 211],
  mediumpurple: [147, 112, 219],
  mediumseagreen: [60, 179, 113],
  mediumslateblue: [123, 104, 238],
  mediumspringgreen: [0, 250, 154],
  mediumturquoise: [72, 209, 204],
  mediumvioletred: [199, 21, 133],
  midnightblue: [25, 25, 112],
  mintcream: [245, 255, 250],
  mistyrose: [255, 228, 225],
  moccasin: [255, 228, 181],
  navajowhite: [255, 222, 173],
  navy: [0, 0, 128],
  oldlace: [253, 245, 230],
  olive: [128, 128, 0],
  olivedrab: [107, 142, 35],
  orange: [255, 165, 0],
  orangered: [255, 69, 0],
  orchid: [218, 112, 214],
  palegoldenrod: [238, 232, 170],
  palegreen: [152, 251, 152],
  paleturquoise: [175, 238, 238],
  palevioletred: [219, 112, 147],
  papayawhip: [255, 239, 213],
  peachpuff: [255, 218, 185],
  peru: [205, 133, 63],
  pink: [255, 192, 203],
  plum: [221, 160, 221],
  powderblue: [176, 224, 230],
  purple: [128, 0, 128],
  red: [255, 0, 0],
  rosybrown: [188, 143, 143],
  royalblue: [65, 105, 225],
  saddlebrown: [139, 69, 19],
  salmon: [250, 128, 114],
  sandybrown: [244, 164, 96],
  seagreen: [46, 139, 87],
  seashell: [255, 245, 238],
  sienna: [160, 82, 45],
  silver: [192, 192, 192],
  skyblue: [135, 206, 235],
  slateblue: [106, 90, 205],
  slategray: [112, 128, 144],
  slategrey: [112, 128, 144],
  snow: [255, 250, 250],
  springgreen: [0, 255, 127],
  steelblue: [70, 130, 180],
  tan: [210, 180, 140],
  teal: [0, 128, 128],
  thistle: [216, 191, 216],
  tomato: [255, 99, 71],
  turquoise: [64, 224, 208],
  violet: [238, 130, 238],
  wheat: [245, 222, 179],
  white: [255, 255, 255],
  whitesmoke: [245, 245, 245],
  yellow: [255, 255, 0],
  yellowgreen: [154, 205, 50]
};

let cx, cy, px, py, sx, sy;
cx = cy = px = py = sx = sy = 0;
const parameters = {
  A: 7,
  a: 7,
  C: 6,
  c: 6,
  H: 1,
  h: 1,
  L: 2,
  l: 2,
  M: 2,
  m: 2,
  Q: 4,
  q: 4,
  S: 4,
  s: 4,
  T: 2,
  t: 2,
  V: 1,
  v: 1,
  Z: 0,
  z: 0
};
const parse = function (path) {
  let cmd;
  const ret = [];
  let args = [];
  let curArg = '';
  let foundDecimal = false;
  let params = 0;
  for (let c of path) {
    if (parameters[c] != null) {
      params = parameters[c];
      if (cmd) {
        if (curArg.length > 0) {
          args[args.length] = +curArg;
        }
        ret[ret.length] = {
          cmd,
          args
        };
        args = [];
        curArg = '';
        foundDecimal = false;
      }
      cmd = c;
    } else if ([' ', ','].includes(c) || c === '-' && curArg.length > 0 && curArg[curArg.length - 1] !== 'e' || c === '.' && foundDecimal) {
      if (curArg.length === 0) {
        continue;
      }
      if (args.length === params) {
        ret[ret.length] = {
          cmd,
          args
        };
        args = [+curArg];
        if (cmd === 'M') {
          cmd = 'L';
        }
        if (cmd === 'm') {
          cmd = 'l';
        }
      } else {
        args[args.length] = +curArg;
      }
      foundDecimal = c === '.';
      curArg = ['-', '.'].includes(c) ? c : '';
    } else {
      curArg += c;
      if (c === '.') {
        foundDecimal = true;
      }
    }
  }
  if (curArg.length > 0) {
    if (args.length === params) {
      ret[ret.length] = {
        cmd,
        args
      };
      args = [+curArg];
      if (cmd === 'M') {
        cmd = 'L';
      }
      if (cmd === 'm') {
        cmd = 'l';
      }
    } else {
      args[args.length] = +curArg;
    }
  }
  ret[ret.length] = {
    cmd,
    args
  };
  return ret;
};
const apply = function (commands, doc) {
  cx = cy = px = py = sx = sy = 0;
  for (let i = 0; i < commands.length; i++) {
    const c = commands[i];
    if (typeof runners[c.cmd] === 'function') {
      runners[c.cmd](doc, c.args);
    }
  }
};
const runners = {
  M(doc, a) {
    cx = a[0];
    cy = a[1];
    px = py = null;
    sx = cx;
    sy = cy;
    return doc.moveTo(cx, cy);
  },
  m(doc, a) {
    cx += a[0];
    cy += a[1];
    px = py = null;
    sx = cx;
    sy = cy;
    return doc.moveTo(cx, cy);
  },
  C(doc, a) {
    cx = a[4];
    cy = a[5];
    px = a[2];
    py = a[3];
    return doc.bezierCurveTo(...a);
  },
  c(doc, a) {
    doc.bezierCurveTo(a[0] + cx, a[1] + cy, a[2] + cx, a[3] + cy, a[4] + cx, a[5] + cy);
    px = cx + a[2];
    py = cy + a[3];
    cx += a[4];
    return cy += a[5];
  },
  S(doc, a) {
    if (px === null) {
      px = cx;
      py = cy;
    }
    doc.bezierCurveTo(cx - (px - cx), cy - (py - cy), a[0], a[1], a[2], a[3]);
    px = a[0];
    py = a[1];
    cx = a[2];
    return cy = a[3];
  },
  s(doc, a) {
    if (px === null) {
      px = cx;
      py = cy;
    }
    doc.bezierCurveTo(cx - (px - cx), cy - (py - cy), cx + a[0], cy + a[1], cx + a[2], cy + a[3]);
    px = cx + a[0];
    py = cy + a[1];
    cx += a[2];
    return cy += a[3];
  },
  Q(doc, a) {
    px = a[0];
    py = a[1];
    cx = a[2];
    cy = a[3];
    return doc.quadraticCurveTo(a[0], a[1], cx, cy);
  },
  q(doc, a) {
    doc.quadraticCurveTo(a[0] + cx, a[1] + cy, a[2] + cx, a[3] + cy);
    px = cx + a[0];
    py = cy + a[1];
    cx += a[2];
    return cy += a[3];
  },
  T(doc, a) {
    if (px === null) {
      px = cx;
      py = cy;
    } else {
      px = cx - (px - cx);
      py = cy - (py - cy);
    }
    doc.quadraticCurveTo(px, py, a[0], a[1]);
    px = cx - (px - cx);
    py = cy - (py - cy);
    cx = a[0];
    return cy = a[1];
  },
  t(doc, a) {
    if (px === null) {
      px = cx;
      py = cy;
    } else {
      px = cx - (px - cx);
      py = cy - (py - cy);
    }
    doc.quadraticCurveTo(px, py, cx + a[0], cy + a[1]);
    cx += a[0];
    return cy += a[1];
  },
  A(doc, a) {
    solveArc(doc, cx, cy, a);
    cx = a[5];
    return cy = a[6];
  },
  a(doc, a) {
    a[5] += cx;
    a[6] += cy;
    solveArc(doc, cx, cy, a);
    cx = a[5];
    return cy = a[6];
  },
  L(doc, a) {
    cx = a[0];
    cy = a[1];
    px = py = null;
    return doc.lineTo(cx, cy);
  },
  l(doc, a) {
    cx += a[0];
    cy += a[1];
    px = py = null;
    return doc.lineTo(cx, cy);
  },
  H(doc, a) {
    cx = a[0];
    px = py = null;
    return doc.lineTo(cx, cy);
  },
  h(doc, a) {
    cx += a[0];
    px = py = null;
    return doc.lineTo(cx, cy);
  },
  V(doc, a) {
    cy = a[0];
    px = py = null;
    return doc.lineTo(cx, cy);
  },
  v(doc, a) {
    cy += a[0];
    px = py = null;
    return doc.lineTo(cx, cy);
  },
  Z(doc) {
    doc.closePath();
    cx = sx;
    return cy = sy;
  },
  z(doc) {
    doc.closePath();
    cx = sx;
    return cy = sy;
  }
};
const solveArc = function (doc, x, y, coords) {
  const [rx, ry, rot, large, sweep, ex, ey] = coords;
  const segs = arcToSegments(ex, ey, rx, ry, large, sweep, rot, x, y);
  for (let seg of segs) {
    const bez = segmentToBezier(...seg);
    doc.bezierCurveTo(...bez);
  }
};
const arcToSegments = function (x, y, rx, ry, large, sweep, rotateX, ox, oy) {
  const th = rotateX * (Math.PI / 180);
  const sin_th = Math.sin(th);
  const cos_th = Math.cos(th);
  rx = Math.abs(rx);
  ry = Math.abs(ry);
  px = cos_th * (ox - x) * 0.5 + sin_th * (oy - y) * 0.5;
  py = cos_th * (oy - y) * 0.5 - sin_th * (ox - x) * 0.5;
  let pl = px * px / (rx * rx) + py * py / (ry * ry);
  if (pl > 1) {
    pl = Math.sqrt(pl);
    rx *= pl;
    ry *= pl;
  }
  const a00 = cos_th / rx;
  const a01 = sin_th / rx;
  const a10 = -sin_th / ry;
  const a11 = cos_th / ry;
  const x0 = a00 * ox + a01 * oy;
  const y0 = a10 * ox + a11 * oy;
  const x1 = a00 * x + a01 * y;
  const y1 = a10 * x + a11 * y;
  const d = (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0);
  let sfactor_sq = 1 / d - 0.25;
  if (sfactor_sq < 0) {
    sfactor_sq = 0;
  }
  let sfactor = Math.sqrt(sfactor_sq);
  if (sweep === large) {
    sfactor = -sfactor;
  }
  const xc = 0.5 * (x0 + x1) - sfactor * (y1 - y0);
  const yc = 0.5 * (y0 + y1) + sfactor * (x1 - x0);
  const th0 = Math.atan2(y0 - yc, x0 - xc);
  const th1 = Math.atan2(y1 - yc, x1 - xc);
  let th_arc = th1 - th0;
  if (th_arc < 0 && sweep === 1) {
    th_arc += 2 * Math.PI;
  } else if (th_arc > 0 && sweep === 0) {
    th_arc -= 2 * Math.PI;
  }
  const segments = Math.ceil(Math.abs(th_arc / (Math.PI * 0.5 + 0.001)));
  const result = [];
  for (let i = 0; i < segments; i++) {
    const th2 = th0 + i * th_arc / segments;
    const th3 = th0 + (i + 1) * th_arc / segments;
    result[i] = [xc, yc, th2, th3, rx, ry, sin_th, cos_th];
  }
  return result;
};
const segmentToBezier = function (cx, cy, th0, th1, rx, ry, sin_th, cos_th) {
  const a00 = cos_th * rx;
  const a01 = -sin_th * ry;
  const a10 = sin_th * rx;
  const a11 = cos_th * ry;
  const th_half = 0.5 * (th1 - th0);
  const t = 8 / 3 * Math.sin(th_half * 0.5) * Math.sin(th_half * 0.5) / Math.sin(th_half);
  const x1 = cx + Math.cos(th0) - t * Math.sin(th0);
  const y1 = cy + Math.sin(th0) + t * Math.cos(th0);
  const x3 = cx + Math.cos(th1);
  const y3 = cy + Math.sin(th1);
  const x2 = x3 + t * Math.sin(th1);
  const y2 = y3 - t * Math.cos(th1);
  return [a00 * x1 + a01 * y1, a10 * x1 + a11 * y1, a00 * x2 + a01 * y2, a10 * x2 + a11 * y2, a00 * x3 + a01 * y3, a10 * x3 + a11 * y3];
};
class SVGPath {
  static apply(doc, path) {
    const commands = parse(path);
    apply(commands, doc);
  }
}

const {
  number: number$1
} = PDFObject;
const KAPPA = 4.0 * ((Math.sqrt(2) - 1.0) / 3.0);
var VectorMixin = {
  initVector() {
    this._ctm = [1, 0, 0, 1, 0, 0];
    this._ctmStack = [];
  },
  save() {
    this._ctmStack.push(this._ctm.slice());
    return this.addContent('q');
  },
  restore() {
    this._ctm = this._ctmStack.pop() || [1, 0, 0, 1, 0, 0];
    return this.addContent('Q');
  },
  closePath() {
    return this.addContent('h');
  },
  lineWidth(w) {
    return this.addContent(`${number$1(w)} w`);
  },
  _CAP_STYLES: {
    BUTT: 0,
    ROUND: 1,
    SQUARE: 2
  },
  lineCap(c) {
    if (typeof c === 'string') {
      c = this._CAP_STYLES[c.toUpperCase()];
    }
    return this.addContent(`${c} J`);
  },
  _JOIN_STYLES: {
    MITER: 0,
    ROUND: 1,
    BEVEL: 2
  },
  lineJoin(j) {
    if (typeof j === 'string') {
      j = this._JOIN_STYLES[j.toUpperCase()];
    }
    return this.addContent(`${j} j`);
  },
  miterLimit(m) {
    return this.addContent(`${number$1(m)} M`);
  },
  dash(length, options = {}) {
    const originalLength = length;
    if (!Array.isArray(length)) {
      length = [length, options.space || length];
    }
    const valid = length.every(x => Number.isFinite(x) && x > 0);
    if (!valid) {
      throw new Error(`dash(${JSON.stringify(originalLength)}, ${JSON.stringify(options)}) invalid, lengths must be numeric and greater than zero`);
    }
    length = length.map(number$1).join(' ');
    return this.addContent(`[${length}] ${number$1(options.phase || 0)} d`);
  },
  undash() {
    return this.addContent('[] 0 d');
  },
  moveTo(x, y) {
    return this.addContent(`${number$1(x)} ${number$1(y)} m`);
  },
  lineTo(x, y) {
    return this.addContent(`${number$1(x)} ${number$1(y)} l`);
  },
  bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y) {
    return this.addContent(`${number$1(cp1x)} ${number$1(cp1y)} ${number$1(cp2x)} ${number$1(cp2y)} ${number$1(x)} ${number$1(y)} c`);
  },
  quadraticCurveTo(cpx, cpy, x, y) {
    return this.addContent(`${number$1(cpx)} ${number$1(cpy)} ${number$1(x)} ${number$1(y)} v`);
  },
  rect(x, y, w, h) {
    return this.addContent(`${number$1(x)} ${number$1(y)} ${number$1(w)} ${number$1(h)} re`);
  },
  roundedRect(x, y, w, h, r) {
    if (r == null) {
      r = 0;
    }
    r = Math.min(r, 0.5 * w, 0.5 * h);
    const c = r * (1.0 - KAPPA);
    this.moveTo(x + r, y);
    this.lineTo(x + w - r, y);
    this.bezierCurveTo(x + w - c, y, x + w, y + c, x + w, y + r);
    this.lineTo(x + w, y + h - r);
    this.bezierCurveTo(x + w, y + h - c, x + w - c, y + h, x + w - r, y + h);
    this.lineTo(x + r, y + h);
    this.bezierCurveTo(x + c, y + h, x, y + h - c, x, y + h - r);
    this.lineTo(x, y + r);
    this.bezierCurveTo(x, y + c, x + c, y, x + r, y);
    return this.closePath();
  },
  ellipse(x, y, r1, r2) {
    if (r2 == null) {
      r2 = r1;
    }
    x -= r1;
    y -= r2;
    const ox = r1 * KAPPA;
    const oy = r2 * KAPPA;
    const xe = x + r1 * 2;
    const ye = y + r2 * 2;
    const xm = x + r1;
    const ym = y + r2;
    this.moveTo(x, ym);
    this.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
    this.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);
    this.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
    this.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);
    return this.closePath();
  },
  circle(x, y, radius) {
    return this.ellipse(x, y, radius);
  },
  arc(x, y, radius, startAngle, endAngle, anticlockwise) {
    if (anticlockwise == null) {
      anticlockwise = false;
    }
    const TWO_PI = 2.0 * Math.PI;
    const HALF_PI = 0.5 * Math.PI;
    let deltaAng = endAngle - startAngle;
    if (Math.abs(deltaAng) > TWO_PI) {
      deltaAng = TWO_PI;
    } else if (deltaAng !== 0 && anticlockwise !== deltaAng < 0) {
      const dir = anticlockwise ? -1 : 1;
      deltaAng = dir * TWO_PI + deltaAng;
    }
    const numSegs = Math.ceil(Math.abs(deltaAng) / HALF_PI);
    const segAng = deltaAng / numSegs;
    const handleLen = segAng / HALF_PI * KAPPA * radius;
    let curAng = startAngle;
    let deltaCx = -Math.sin(curAng) * handleLen;
    let deltaCy = Math.cos(curAng) * handleLen;
    let ax = x + Math.cos(curAng) * radius;
    let ay = y + Math.sin(curAng) * radius;
    this.moveTo(ax, ay);
    for (let segIdx = 0; segIdx < numSegs; segIdx++) {
      const cp1x = ax + deltaCx;
      const cp1y = ay + deltaCy;
      curAng += segAng;
      ax = x + Math.cos(curAng) * radius;
      ay = y + Math.sin(curAng) * radius;
      deltaCx = -Math.sin(curAng) * handleLen;
      deltaCy = Math.cos(curAng) * handleLen;
      const cp2x = ax - deltaCx;
      const cp2y = ay - deltaCy;
      this.bezierCurveTo(cp1x, cp1y, cp2x, cp2y, ax, ay);
    }
    return this;
  },
  polygon(...points) {
    this.moveTo(...(points.shift() || []));
    for (let point of points) {
      this.lineTo(...(point || []));
    }
    return this.closePath();
  },
  path(path) {
    SVGPath.apply(this, path);
    return this;
  },
  _windingRule(rule) {
    if (/even-?odd/.test(rule)) {
      return '*';
    }
    return '';
  },
  fill(color, rule) {
    if (/(even-?odd)|(non-?zero)/.test(color)) {
      rule = color;
      color = null;
    }
    if (color) {
      this.fillColor(color);
    }
    return this.addContent(`f${this._windingRule(rule)}`);
  },
  stroke(color) {
    if (color) {
      this.strokeColor(color);
    }
    return this.addContent('S');
  },
  fillAndStroke(fillColor, strokeColor, rule) {
    if (strokeColor == null) {
      strokeColor = fillColor;
    }
    const isFillRule = /(even-?odd)|(non-?zero)/;
    if (isFillRule.test(fillColor)) {
      rule = fillColor;
      fillColor = null;
    }
    if (isFillRule.test(strokeColor)) {
      rule = strokeColor;
      strokeColor = fillColor;
    }
    if (fillColor) {
      this.fillColor(fillColor);
      this.strokeColor(strokeColor);
    }
    return this.addContent(`B${this._windingRule(rule)}`);
  },
  clip(rule) {
    return this.addContent(`W${this._windingRule(rule)} n`);
  },
  transform(m11, m12, m21, m22, dx, dy) {
    if (m11 === 1 && m12 === 0 && m21 === 0 && m22 === 1 && dx === 0 && dy === 0) {
      return this;
    }
    const m = this._ctm;
    const [m0, m1, m2, m3, m4, m5] = m;
    m[0] = m0 * m11 + m2 * m12;
    m[1] = m1 * m11 + m3 * m12;
    m[2] = m0 * m21 + m2 * m22;
    m[3] = m1 * m21 + m3 * m22;
    m[4] = m0 * dx + m2 * dy + m4;
    m[5] = m1 * dx + m3 * dy + m5;
    const values = [m11, m12, m21, m22, dx, dy].map(v => number$1(v)).join(' ');
    return this.addContent(`${values} cm`);
  },
  translate(x, y) {
    return this.transform(1, 0, 0, 1, x, y);
  },
  rotate(angle, options = {}) {
    let y;
    const rad = angle * Math.PI / 180;
    const cos = Math.cos(rad);
    const sin = Math.sin(rad);
    let x = y = 0;
    if (options.origin != null) {
      [x, y] = options.origin;
      const x1 = x * cos - y * sin;
      const y1 = x * sin + y * cos;
      x -= x1;
      y -= y1;
    }
    return this.transform(cos, sin, -sin, cos, x, y);
  },
  scale(xFactor, yFactor, options = {}) {
    let y;
    if (yFactor == null) {
      yFactor = xFactor;
    }
    if (typeof yFactor === 'object') {
      options = yFactor;
      yFactor = xFactor;
    }
    let x = y = 0;
    if (options.origin != null) {
      [x, y] = options.origin;
      x -= xFactor * x;
      y -= yFactor * y;
    }
    return this.transform(xFactor, 0, 0, yFactor, x, y);
  }
};

const WIN_ANSI_MAP = {
  402: 131,
  8211: 150,
  8212: 151,
  8216: 145,
  8217: 146,
  8218: 130,
  8220: 147,
  8221: 148,
  8222: 132,
  8224: 134,
  8225: 135,
  8226: 149,
  8230: 133,
  8364: 128,
  8240: 137,
  8249: 139,
  8250: 155,
  710: 136,
  8482: 153,
  338: 140,
  339: 156,
  732: 152,
  352: 138,
  353: 154,
  376: 159,
  381: 142,
  382: 158
};
const characters = `\
.notdef       .notdef        .notdef        .notdef
.notdef       .notdef        .notdef        .notdef
.notdef       .notdef        .notdef        .notdef
.notdef       .notdef        .notdef        .notdef
.notdef       .notdef        .notdef        .notdef
.notdef       .notdef        .notdef        .notdef
.notdef       .notdef        .notdef        .notdef
.notdef       .notdef        .notdef        .notdef
  
space         exclam         quotedbl       numbersign
dollar        percent        ampersand      quotesingle
parenleft     parenright     asterisk       plus
comma         hyphen         period         slash
zero          one            two            three
four          five           six            seven
eight         nine           colon          semicolon
less          equal          greater        question
  
at            A              B              C
D             E              F              G
H             I              J              K
L             M              N              O
P             Q              R              S
T             U              V              W
X             Y              Z              bracketleft
backslash     bracketright   asciicircum    underscore
  
grave         a              b              c
d             e              f              g
h             i              j              k
l             m              n              o
p             q              r              s
t             u              v              w
x             y              z              braceleft
bar           braceright     asciitilde     .notdef
  
Euro          .notdef        quotesinglbase florin
quotedblbase  ellipsis       dagger         daggerdbl
circumflex    perthousand    Scaron         guilsinglleft
OE            .notdef        Zcaron         .notdef
.notdef       quoteleft      quoteright     quotedblleft
quotedblright bullet         endash         emdash
tilde         trademark      scaron         guilsinglright
oe            .notdef        zcaron         ydieresis
  
space         exclamdown     cent           sterling
currency      yen            brokenbar      section
dieresis      copyright      ordfeminine    guillemotleft
logicalnot    hyphen         registered     macron
degree        plusminus      twosuperior    threesuperior
acute         mu             paragraph      periodcentered
cedilla       onesuperior    ordmasculine   guillemotright
onequarter    onehalf        threequarters  questiondown
  
Agrave        Aacute         Acircumflex    Atilde
Adieresis     Aring          AE             Ccedilla
Egrave        Eacute         Ecircumflex    Edieresis
Igrave        Iacute         Icircumflex    Idieresis
Eth           Ntilde         Ograve         Oacute
Ocircumflex   Otilde         Odieresis      multiply
Oslash        Ugrave         Uacute         Ucircumflex
Udieresis     Yacute         Thorn          germandbls
  
agrave        aacute         acircumflex    atilde
adieresis     aring          ae             ccedilla
egrave        eacute         ecircumflex    edieresis
igrave        iacute         icircumflex    idieresis
eth           ntilde         ograve         oacute
ocircumflex   otilde         odieresis      divide
oslash        ugrave         uacute         ucircumflex
udieresis     yacute         thorn          ydieresis\
`.split(/\s+/);
class AFMFont {
  constructor(contents) {
    this.attributes = {};
    this.glyphWidths = {};
    this.boundingBoxes = {};
    this.kernPairs = {};
    this.parse(contents);
    this.bbox = this.attributes['FontBBox'].split(/\s+/).map(e => +e);
    this.ascender = +(this.attributes['Ascender'] || 0);
    this.descender = +(this.attributes['Descender'] || 0);
    this.xHeight = +(this.attributes['XHeight'] || 0);
    this.capHeight = +(this.attributes['CapHeight'] || 0);
    this.lineGap = this.bbox[3] - this.bbox[1] - (this.ascender - this.descender);
  }
  parse(contents) {
    let section = '';
    for (let line of contents.split('\n')) {
      var match;
      var a;
      if (match = line.match(/^Start(\w+)/)) {
        section = match[1];
        continue;
      } else if (match = line.match(/^End(\w+)/)) {
        section = '';
        continue;
      }
      switch (section) {
        case 'FontMetrics':
          match = line.match(/(^\w+)\s+(.*)/);
          var key = match[1];
          var value = match[2];
          if (a = this.attributes[key]) {
            if (!Array.isArray(a)) {
              a = this.attributes[key] = [a];
            }
            a.push(value);
          } else {
            this.attributes[key] = value;
          }
          break;
        case 'CharMetrics':
          if (!/^CH?\s/.test(line)) {
            continue;
          }
          var name = line.match(/\bN\s+(\.?\w+)\s*;/)[1];
          this.glyphWidths[name] = +line.match(/\bWX\s+(\d+)\s*;/)[1];
          break;
        case 'KernPairs':
          match = line.match(/^KPX\s+(\.?\w+)\s+(\.?\w+)\s+(-?\d+)/);
          if (match) {
            this.kernPairs[match[1] + '\0' + match[2]] = parseInt(match[3]);
          }
          break;
      }
    }
  }
  encodeText(text) {
    const res = [];
    for (let i = 0, len = text.length; i < len; i++) {
      let char = text.charCodeAt(i);
      char = WIN_ANSI_MAP[char] || char;
      res.push(char.toString(16));
    }
    return res;
  }
  glyphsForString(string) {
    const glyphs = [];
    for (let i = 0, len = string.length; i < len; i++) {
      const charCode = string.charCodeAt(i);
      glyphs.push(this.characterToGlyph(charCode));
    }
    return glyphs;
  }
  characterToGlyph(character) {
    return characters[WIN_ANSI_MAP[character] || character] || '.notdef';
  }
  widthOfGlyph(glyph) {
    return this.glyphWidths[glyph] || 0;
  }
  getKernPair(left, right) {
    return this.kernPairs[left + '\0' + right] || 0;
  }
  advancesForGlyphs(glyphs) {
    const advances = [];
    for (let index = 0; index < glyphs.length; index++) {
      const left = glyphs[index];
      const right = glyphs[index + 1];
      advances.push(this.widthOfGlyph(left) + this.getKernPair(left, right));
    }
    return advances;
  }
}

class PDFFont {
  constructor() {}
  encode() {
    throw new Error('Must be implemented by subclasses');
  }
  widthOfString() {
    throw new Error('Must be implemented by subclasses');
  }
  ref() {
    return this.dictionary != null ? this.dictionary : this.dictionary = this.document.ref();
  }
  finalize() {
    if (this.embedded || this.dictionary == null) {
      return;
    }
    this.embed();
    this.embedded = true;
  }
  embed() {
    throw new Error('Must be implemented by subclasses');
  }
  lineHeight(size, includeGap = false) {
    const gap = includeGap ? this.lineGap : 0;
    return (this.ascender + gap - this.descender) / 1000 * size;
  }
}

const STANDARD_FONTS = {
  Courier() {
    return "StartFontMetrics 4.1\r\nComment Copyright (c) 1989, 1990, 1991, 1992, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.\r\nComment Creation Date: Thu May  1 17:27:09 1997\r\nComment UniqueID 43050\r\nComment VMusage 39754 50779\r\nFontName Courier\r\nFullName Courier\r\nFamilyName Courier\r\nWeight Medium\r\nItalicAngle 0\r\nIsFixedPitch true\r\nCharacterSet ExtendedRoman\r\nFontBBox -23 -250 715 805 \r\nUnderlinePosition -100\r\nUnderlineThickness 50\r\nVersion 003.000\r\nNotice Copyright (c) 1989, 1990, 1991, 1992, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.\r\nEncodingScheme AdobeStandardEncoding\r\nCapHeight 562\r\nXHeight 426\r\nAscender 629\r\nDescender -157\r\nStdHW 51\r\nStdVW 51\r\nStartCharMetrics 315\r\nC 32 ; WX 600 ; N space ; B 0 0 0 0 ;\r\nC 33 ; WX 600 ; N exclam ; B 236 -15 364 572 ;\r\nC 34 ; WX 600 ; N quotedbl ; B 187 328 413 562 ;\r\nC 35 ; WX 600 ; N numbersign ; B 93 -32 507 639 ;\r\nC 36 ; WX 600 ; N dollar ; B 105 -126 496 662 ;\r\nC 37 ; WX 600 ; N percent ; B 81 -15 518 622 ;\r\nC 38 ; WX 600 ; N ampersand ; B 63 -15 538 543 ;\r\nC 39 ; WX 600 ; N quoteright ; B 213 328 376 562 ;\r\nC 40 ; WX 600 ; N parenleft ; B 269 -108 440 622 ;\r\nC 41 ; WX 600 ; N parenright ; B 160 -108 331 622 ;\r\nC 42 ; WX 600 ; N asterisk ; B 116 257 484 607 ;\r\nC 43 ; WX 600 ; N plus ; B 80 44 520 470 ;\r\nC 44 ; WX 600 ; N comma ; B 181 -112 344 122 ;\r\nC 45 ; WX 600 ; N hyphen ; B 103 231 497 285 ;\r\nC 46 ; WX 600 ; N period ; B 229 -15 371 109 ;\r\nC 47 ; WX 600 ; N slash ; B 125 -80 475 629 ;\r\nC 48 ; WX 600 ; N zero ; B 106 -15 494 622 ;\r\nC 49 ; WX 600 ; N one ; B 96 0 505 622 ;\r\nC 50 ; WX 600 ; N two ; B 70 0 471 622 ;\r\nC 51 ; WX 600 ; N three ; B 75 -15 466 622 ;\r\nC 52 ; WX 600 ; N four ; B 78 0 500 622 ;\r\nC 53 ; WX 600 ; N five ; B 92 -15 497 607 ;\r\nC 54 ; WX 600 ; N six ; B 111 -15 497 622 ;\r\nC 55 ; WX 600 ; N seven ; B 82 0 483 607 ;\r\nC 56 ; WX 600 ; N eight ; B 102 -15 498 622 ;\r\nC 57 ; WX 600 ; N nine ; B 96 -15 489 622 ;\r\nC 58 ; WX 600 ; N colon ; B 229 -15 371 385 ;\r\nC 59 ; WX 600 ; N semicolon ; B 181 -112 371 385 ;\r\nC 60 ; WX 600 ; N less ; B 41 42 519 472 ;\r\nC 61 ; WX 600 ; N equal ; B 80 138 520 376 ;\r\nC 62 ; WX 600 ; N greater ; B 66 42 544 472 ;\r\nC 63 ; WX 600 ; N question ; B 129 -15 492 572 ;\r\nC 64 ; WX 600 ; N at ; B 77 -15 533 622 ;\r\nC 65 ; WX 600 ; N A ; B 3 0 597 562 ;\r\nC 66 ; WX 600 ; N B ; B 43 0 559 562 ;\r\nC 67 ; WX 600 ; N C ; B 41 -18 540 580 ;\r\nC 68 ; WX 600 ; N D ; B 43 0 574 562 ;\r\nC 69 ; WX 600 ; N E ; B 53 0 550 562 ;\r\nC 70 ; WX 600 ; N F ; B 53 0 545 562 ;\r\nC 71 ; WX 600 ; N G ; B 31 -18 575 580 ;\r\nC 72 ; WX 600 ; N H ; B 32 0 568 562 ;\r\nC 73 ; WX 600 ; N I ; B 96 0 504 562 ;\r\nC 74 ; WX 600 ; N J ; B 34 -18 566 562 ;\r\nC 75 ; WX 600 ; N K ; B 38 0 582 562 ;\r\nC 76 ; WX 600 ; N L ; B 47 0 554 562 ;\r\nC 77 ; WX 600 ; N M ; B 4 0 596 562 ;\r\nC 78 ; WX 600 ; N N ; B 7 -13 593 562 ;\r\nC 79 ; WX 600 ; N O ; B 43 -18 557 580 ;\r\nC 80 ; WX 600 ; N P ; B 79 0 558 562 ;\r\nC 81 ; WX 600 ; N Q ; B 43 -138 557 580 ;\r\nC 82 ; WX 600 ; N R ; B 38 0 588 562 ;\r\nC 83 ; WX 600 ; N S ; B 72 -20 529 580 ;\r\nC 84 ; WX 600 ; N T ; B 38 0 563 562 ;\r\nC 85 ; WX 600 ; N U ; B 17 -18 583 562 ;\r\nC 86 ; WX 600 ; N V ; B -4 -13 604 562 ;\r\nC 87 ; WX 600 ; N W ; B -3 -13 603 562 ;\r\nC 88 ; WX 600 ; N X ; B 23 0 577 562 ;\r\nC 89 ; WX 600 ; N Y ; B 24 0 576 562 ;\r\nC 90 ; WX 600 ; N Z ; B 86 0 514 562 ;\r\nC 91 ; WX 600 ; N bracketleft ; B 269 -108 442 622 ;\r\nC 92 ; WX 600 ; N backslash ; B 118 -80 482 629 ;\r\nC 93 ; WX 600 ; N bracketright ; B 158 -108 331 622 ;\r\nC 94 ; WX 600 ; N asciicircum ; B 94 354 506 622 ;\r\nC 95 ; WX 600 ; N underscore ; B 0 -125 600 -75 ;\r\nC 96 ; WX 600 ; N quoteleft ; B 224 328 387 562 ;\r\nC 97 ; WX 600 ; N a ; B 53 -15 559 441 ;\r\nC 98 ; WX 600 ; N b ; B 14 -15 575 629 ;\r\nC 99 ; WX 600 ; N c ; B 66 -15 529 441 ;\r\nC 100 ; WX 600 ; N d ; B 45 -15 591 629 ;\r\nC 101 ; WX 600 ; N e ; B 66 -15 548 441 ;\r\nC 102 ; WX 600 ; N f ; B 114 0 531 629 ; L i fi ; L l fl ;\r\nC 103 ; WX 600 ; N g ; B 45 -157 566 441 ;\r\nC 104 ; WX 600 ; N h ; B 18 0 582 629 ;\r\nC 105 ; WX 600 ; N i ; B 95 0 505 657 ;\r\nC 106 ; WX 600 ; N j ; B 82 -157 410 657 ;\r\nC 107 ; WX 600 ; N k ; B 43 0 580 629 ;\r\nC 108 ; WX 600 ; N l ; B 95 0 505 629 ;\r\nC 109 ; WX 600 ; N m ; B -5 0 605 441 ;\r\nC 110 ; WX 600 ; N n ; B 26 0 575 441 ;\r\nC 111 ; WX 600 ; N o ; B 62 -15 538 441 ;\r\nC 112 ; WX 600 ; N p ; B 9 -157 555 441 ;\r\nC 113 ; WX 600 ; N q ; B 45 -157 591 441 ;\r\nC 114 ; WX 600 ; N r ; B 60 0 559 441 ;\r\nC 115 ; WX 600 ; N s ; B 80 -15 513 441 ;\r\nC 116 ; WX 600 ; N t ; B 87 -15 530 561 ;\r\nC 117 ; WX 600 ; N u ; B 21 -15 562 426 ;\r\nC 118 ; WX 600 ; N v ; B 10 -10 590 426 ;\r\nC 119 ; WX 600 ; N w ; B -4 -10 604 426 ;\r\nC 120 ; WX 600 ; N x ; B 20 0 580 426 ;\r\nC 121 ; WX 600 ; N y ; B 7 -157 592 426 ;\r\nC 122 ; WX 600 ; N z ; B 99 0 502 426 ;\r\nC 123 ; WX 600 ; N braceleft ; B 182 -108 437 622 ;\r\nC 124 ; WX 600 ; N bar ; B 275 -250 326 750 ;\r\nC 125 ; WX 600 ; N braceright ; B 163 -108 418 622 ;\r\nC 126 ; WX 600 ; N asciitilde ; B 63 197 540 320 ;\r\nC 161 ; WX 600 ; N exclamdown ; B 236 -157 364 430 ;\r\nC 162 ; WX 600 ; N cent ; B 96 -49 500 614 ;\r\nC 163 ; WX 600 ; N sterling ; B 84 -21 521 611 ;\r\nC 164 ; WX 600 ; N fraction ; B 92 -57 509 665 ;\r\nC 165 ; WX 600 ; N yen ; B 26 0 574 562 ;\r\nC 166 ; WX 600 ; N florin ; B 4 -143 539 622 ;\r\nC 167 ; WX 600 ; N section ; B 113 -78 488 580 ;\r\nC 168 ; WX 600 ; N currency ; B 73 58 527 506 ;\r\nC 169 ; WX 600 ; N quotesingle ; B 259 328 341 562 ;\r\nC 170 ; WX 600 ; N quotedblleft ; B 143 328 471 562 ;\r\nC 171 ; WX 600 ; N guillemotleft ; B 37 70 563 446 ;\r\nC 172 ; WX 600 ; N guilsinglleft ; B 149 70 451 446 ;\r\nC 173 ; WX 600 ; N guilsinglright ; B 149 70 451 446 ;\r\nC 174 ; WX 600 ; N fi ; B 3 0 597 629 ;\r\nC 175 ; WX 600 ; N fl ; B 3 0 597 629 ;\r\nC 177 ; WX 600 ; N endash ; B 75 231 525 285 ;\r\nC 178 ; WX 600 ; N dagger ; B 141 -78 459 580 ;\r\nC 179 ; WX 600 ; N daggerdbl ; B 141 -78 459 580 ;\r\nC 180 ; WX 600 ; N periodcentered ; B 222 189 378 327 ;\r\nC 182 ; WX 600 ; N paragraph ; B 50 -78 511 562 ;\r\nC 183 ; WX 600 ; N bullet ; B 172 130 428 383 ;\r\nC 184 ; WX 600 ; N quotesinglbase ; B 213 -134 376 100 ;\r\nC 185 ; WX 600 ; N quotedblbase ; B 143 -134 457 100 ;\r\nC 186 ; WX 600 ; N quotedblright ; B 143 328 457 562 ;\r\nC 187 ; WX 600 ; N guillemotright ; B 37 70 563 446 ;\r\nC 188 ; WX 600 ; N ellipsis ; B 37 -15 563 111 ;\r\nC 189 ; WX 600 ; N perthousand ; B 3 -15 600 622 ;\r\nC 191 ; WX 600 ; N questiondown ; B 108 -157 471 430 ;\r\nC 193 ; WX 600 ; N grave ; B 151 497 378 672 ;\r\nC 194 ; WX 600 ; N acute ; B 242 497 469 672 ;\r\nC 195 ; WX 600 ; N circumflex ; B 124 477 476 654 ;\r\nC 196 ; WX 600 ; N tilde ; B 105 489 503 606 ;\r\nC 197 ; WX 600 ; N macron ; B 120 525 480 565 ;\r\nC 198 ; WX 600 ; N breve ; B 153 501 447 609 ;\r\nC 199 ; WX 600 ; N dotaccent ; B 249 537 352 640 ;\r\nC 200 ; WX 600 ; N dieresis ; B 148 537 453 640 ;\r\nC 202 ; WX 600 ; N ring ; B 218 463 382 627 ;\r\nC 203 ; WX 600 ; N cedilla ; B 224 -151 362 10 ;\r\nC 205 ; WX 600 ; N hungarumlaut ; B 133 497 540 672 ;\r\nC 206 ; WX 600 ; N ogonek ; B 211 -172 407 4 ;\r\nC 207 ; WX 600 ; N caron ; B 124 492 476 669 ;\r\nC 208 ; WX 600 ; N emdash ; B 0 231 600 285 ;\r\nC 225 ; WX 600 ; N AE ; B 3 0 550 562 ;\r\nC 227 ; WX 600 ; N ordfeminine ; B 156 249 442 580 ;\r\nC 232 ; WX 600 ; N Lslash ; B 47 0 554 562 ;\r\nC 233 ; WX 600 ; N Oslash ; B 43 -80 557 629 ;\r\nC 234 ; WX 600 ; N OE ; B 7 0 567 562 ;\r\nC 235 ; WX 600 ; N ordmasculine ; B 157 249 443 580 ;\r\nC 241 ; WX 600 ; N ae ; B 19 -15 570 441 ;\r\nC 245 ; WX 600 ; N dotlessi ; B 95 0 505 426 ;\r\nC 248 ; WX 600 ; N lslash ; B 95 0 505 629 ;\r\nC 249 ; WX 600 ; N oslash ; B 62 -80 538 506 ;\r\nC 250 ; WX 600 ; N oe ; B 19 -15 559 441 ;\r\nC 251 ; WX 600 ; N germandbls ; B 48 -15 588 629 ;\r\nC -1 ; WX 600 ; N Idieresis ; B 96 0 504 753 ;\r\nC -1 ; WX 600 ; N eacute ; B 66 -15 548 672 ;\r\nC -1 ; WX 600 ; N abreve ; B 53 -15 559 609 ;\r\nC -1 ; WX 600 ; N uhungarumlaut ; B 21 -15 580 672 ;\r\nC -1 ; WX 600 ; N ecaron ; B 66 -15 548 669 ;\r\nC -1 ; WX 600 ; N Ydieresis ; B 24 0 576 753 ;\r\nC -1 ; WX 600 ; N divide ; B 87 48 513 467 ;\r\nC -1 ; WX 600 ; N Yacute ; B 24 0 576 805 ;\r\nC -1 ; WX 600 ; N Acircumflex ; B 3 0 597 787 ;\r\nC -1 ; WX 600 ; N aacute ; B 53 -15 559 672 ;\r\nC -1 ; WX 600 ; N Ucircumflex ; B 17 -18 583 787 ;\r\nC -1 ; WX 600 ; N yacute ; B 7 -157 592 672 ;\r\nC -1 ; WX 600 ; N scommaaccent ; B 80 -250 513 441 ;\r\nC -1 ; WX 600 ; N ecircumflex ; B 66 -15 548 654 ;\r\nC -1 ; WX 600 ; N Uring ; B 17 -18 583 760 ;\r\nC -1 ; WX 600 ; N Udieresis ; B 17 -18 583 753 ;\r\nC -1 ; WX 600 ; N aogonek ; B 53 -172 587 441 ;\r\nC -1 ; WX 600 ; N Uacute ; B 17 -18 583 805 ;\r\nC -1 ; WX 600 ; N uogonek ; B 21 -172 590 426 ;\r\nC -1 ; WX 600 ; N Edieresis ; B 53 0 550 753 ;\r\nC -1 ; WX 600 ; N Dcroat ; B 30 0 574 562 ;\r\nC -1 ; WX 600 ; N commaaccent ; B 198 -250 335 -58 ;\r\nC -1 ; WX 600 ; N copyright ; B 0 -18 600 580 ;\r\nC -1 ; WX 600 ; N Emacron ; B 53 0 550 698 ;\r\nC -1 ; WX 600 ; N ccaron ; B 66 -15 529 669 ;\r\nC -1 ; WX 600 ; N aring ; B 53 -15 559 627 ;\r\nC -1 ; WX 600 ; N Ncommaaccent ; B 7 -250 593 562 ;\r\nC -1 ; WX 600 ; N lacute ; B 95 0 505 805 ;\r\nC -1 ; WX 600 ; N agrave ; B 53 -15 559 672 ;\r\nC -1 ; WX 600 ; N Tcommaaccent ; B 38 -250 563 562 ;\r\nC -1 ; WX 600 ; N Cacute ; B 41 -18 540 805 ;\r\nC -1 ; WX 600 ; N atilde ; B 53 -15 559 606 ;\r\nC -1 ; WX 600 ; N Edotaccent ; B 53 0 550 753 ;\r\nC -1 ; WX 600 ; N scaron ; B 80 -15 513 669 ;\r\nC -1 ; WX 600 ; N scedilla ; B 80 -151 513 441 ;\r\nC -1 ; WX 600 ; N iacute ; B 95 0 505 672 ;\r\nC -1 ; WX 600 ; N lozenge ; B 18 0 443 706 ;\r\nC -1 ; WX 600 ; N Rcaron ; B 38 0 588 802 ;\r\nC -1 ; WX 600 ; N Gcommaaccent ; B 31 -250 575 580 ;\r\nC -1 ; WX 600 ; N ucircumflex ; B 21 -15 562 654 ;\r\nC -1 ; WX 600 ; N acircumflex ; B 53 -15 559 654 ;\r\nC -1 ; WX 600 ; N Amacron ; B 3 0 597 698 ;\r\nC -1 ; WX 600 ; N rcaron ; B 60 0 559 669 ;\r\nC -1 ; WX 600 ; N ccedilla ; B 66 -151 529 441 ;\r\nC -1 ; WX 600 ; N Zdotaccent ; B 86 0 514 753 ;\r\nC -1 ; WX 600 ; N Thorn ; B 79 0 538 562 ;\r\nC -1 ; WX 600 ; N Omacron ; B 43 -18 557 698 ;\r\nC -1 ; WX 600 ; N Racute ; B 38 0 588 805 ;\r\nC -1 ; WX 600 ; N Sacute ; B 72 -20 529 805 ;\r\nC -1 ; WX 600 ; N dcaron ; B 45 -15 715 629 ;\r\nC -1 ; WX 600 ; N Umacron ; B 17 -18 583 698 ;\r\nC -1 ; WX 600 ; N uring ; B 21 -15 562 627 ;\r\nC -1 ; WX 600 ; N threesuperior ; B 155 240 406 622 ;\r\nC -1 ; WX 600 ; N Ograve ; B 43 -18 557 805 ;\r\nC -1 ; WX 600 ; N Agrave ; B 3 0 597 805 ;\r\nC -1 ; WX 600 ; N Abreve ; B 3 0 597 732 ;\r\nC -1 ; WX 600 ; N multiply ; B 87 43 515 470 ;\r\nC -1 ; WX 600 ; N uacute ; B 21 -15 562 672 ;\r\nC -1 ; WX 600 ; N Tcaron ; B 38 0 563 802 ;\r\nC -1 ; WX 600 ; N partialdiff ; B 17 -38 459 710 ;\r\nC -1 ; WX 600 ; N ydieresis ; B 7 -157 592 620 ;\r\nC -1 ; WX 600 ; N Nacute ; B 7 -13 593 805 ;\r\nC -1 ; WX 600 ; N icircumflex ; B 94 0 505 654 ;\r\nC -1 ; WX 600 ; N Ecircumflex ; B 53 0 550 787 ;\r\nC -1 ; WX 600 ; N adieresis ; B 53 -15 559 620 ;\r\nC -1 ; WX 600 ; N edieresis ; B 66 -15 548 620 ;\r\nC -1 ; WX 600 ; N cacute ; B 66 -15 529 672 ;\r\nC -1 ; WX 600 ; N nacute ; B 26 0 575 672 ;\r\nC -1 ; WX 600 ; N umacron ; B 21 -15 562 565 ;\r\nC -1 ; WX 600 ; N Ncaron ; B 7 -13 593 802 ;\r\nC -1 ; WX 600 ; N Iacute ; B 96 0 504 805 ;\r\nC -1 ; WX 600 ; N plusminus ; B 87 44 513 558 ;\r\nC -1 ; WX 600 ; N brokenbar ; B 275 -175 326 675 ;\r\nC -1 ; WX 600 ; N registered ; B 0 -18 600 580 ;\r\nC -1 ; WX 600 ; N Gbreve ; B 31 -18 575 732 ;\r\nC -1 ; WX 600 ; N Idotaccent ; B 96 0 504 753 ;\r\nC -1 ; WX 600 ; N summation ; B 15 -10 585 706 ;\r\nC -1 ; WX 600 ; N Egrave ; B 53 0 550 805 ;\r\nC -1 ; WX 600 ; N racute ; B 60 0 559 672 ;\r\nC -1 ; WX 600 ; N omacron ; B 62 -15 538 565 ;\r\nC -1 ; WX 600 ; N Zacute ; B 86 0 514 805 ;\r\nC -1 ; WX 600 ; N Zcaron ; B 86 0 514 802 ;\r\nC -1 ; WX 600 ; N greaterequal ; B 98 0 502 710 ;\r\nC -1 ; WX 600 ; N Eth ; B 30 0 574 562 ;\r\nC -1 ; WX 600 ; N Ccedilla ; B 41 -151 540 580 ;\r\nC -1 ; WX 600 ; N lcommaaccent ; B 95 -250 505 629 ;\r\nC -1 ; WX 600 ; N tcaron ; B 87 -15 530 717 ;\r\nC -1 ; WX 600 ; N eogonek ; B 66 -172 548 441 ;\r\nC -1 ; WX 600 ; N Uogonek ; B 17 -172 583 562 ;\r\nC -1 ; WX 600 ; N Aacute ; B 3 0 597 805 ;\r\nC -1 ; WX 600 ; N Adieresis ; B 3 0 597 753 ;\r\nC -1 ; WX 600 ; N egrave ; B 66 -15 548 672 ;\r\nC -1 ; WX 600 ; N zacute ; B 99 0 502 672 ;\r\nC -1 ; WX 600 ; N iogonek ; B 95 -172 505 657 ;\r\nC -1 ; WX 600 ; N Oacute ; B 43 -18 557 805 ;\r\nC -1 ; WX 600 ; N oacute ; B 62 -15 538 672 ;\r\nC -1 ; WX 600 ; N amacron ; B 53 -15 559 565 ;\r\nC -1 ; WX 600 ; N sacute ; B 80 -15 513 672 ;\r\nC -1 ; WX 600 ; N idieresis ; B 95 0 505 620 ;\r\nC -1 ; WX 600 ; N Ocircumflex ; B 43 -18 557 787 ;\r\nC -1 ; WX 600 ; N Ugrave ; B 17 -18 583 805 ;\r\nC -1 ; WX 600 ; N Delta ; B 6 0 598 688 ;\r\nC -1 ; WX 600 ; N thorn ; B -6 -157 555 629 ;\r\nC -1 ; WX 600 ; N twosuperior ; B 177 249 424 622 ;\r\nC -1 ; WX 600 ; N Odieresis ; B 43 -18 557 753 ;\r\nC -1 ; WX 600 ; N mu ; B 21 -157 562 426 ;\r\nC -1 ; WX 600 ; N igrave ; B 95 0 505 672 ;\r\nC -1 ; WX 600 ; N ohungarumlaut ; B 62 -15 580 672 ;\r\nC -1 ; WX 600 ; N Eogonek ; B 53 -172 561 562 ;\r\nC -1 ; WX 600 ; N dcroat ; B 45 -15 591 629 ;\r\nC -1 ; WX 600 ; N threequarters ; B 8 -56 593 666 ;\r\nC -1 ; WX 600 ; N Scedilla ; B 72 -151 529 580 ;\r\nC -1 ; WX 600 ; N lcaron ; B 95 0 533 629 ;\r\nC -1 ; WX 600 ; N Kcommaaccent ; B 38 -250 582 562 ;\r\nC -1 ; WX 600 ; N Lacute ; B 47 0 554 805 ;\r\nC -1 ; WX 600 ; N trademark ; B -23 263 623 562 ;\r\nC -1 ; WX 600 ; N edotaccent ; B 66 -15 548 620 ;\r\nC -1 ; WX 600 ; N Igrave ; B 96 0 504 805 ;\r\nC -1 ; WX 600 ; N Imacron ; B 96 0 504 698 ;\r\nC -1 ; WX 600 ; N Lcaron ; B 47 0 554 562 ;\r\nC -1 ; WX 600 ; N onehalf ; B 0 -57 611 665 ;\r\nC -1 ; WX 600 ; N lessequal ; B 98 0 502 710 ;\r\nC -1 ; WX 600 ; N ocircumflex ; B 62 -15 538 654 ;\r\nC -1 ; WX 600 ; N ntilde ; B 26 0 575 606 ;\r\nC -1 ; WX 600 ; N Uhungarumlaut ; B 17 -18 590 805 ;\r\nC -1 ; WX 600 ; N Eacute ; B 53 0 550 805 ;\r\nC -1 ; WX 600 ; N emacron ; B 66 -15 548 565 ;\r\nC -1 ; WX 600 ; N gbreve ; B 45 -157 566 609 ;\r\nC -1 ; WX 600 ; N onequarter ; B 0 -57 600 665 ;\r\nC -1 ; WX 600 ; N Scaron ; B 72 -20 529 802 ;\r\nC -1 ; WX 600 ; N Scommaaccent ; B 72 -250 529 580 ;\r\nC -1 ; WX 600 ; N Ohungarumlaut ; B 43 -18 580 805 ;\r\nC -1 ; WX 600 ; N degree ; B 123 269 477 622 ;\r\nC -1 ; WX 600 ; N ograve ; B 62 -15 538 672 ;\r\nC -1 ; WX 600 ; N Ccaron ; B 41 -18 540 802 ;\r\nC -1 ; WX 600 ; N ugrave ; B 21 -15 562 672 ;\r\nC -1 ; WX 600 ; N radical ; B 3 -15 597 792 ;\r\nC -1 ; WX 600 ; N Dcaron ; B 43 0 574 802 ;\r\nC -1 ; WX 600 ; N rcommaaccent ; B 60 -250 559 441 ;\r\nC -1 ; WX 600 ; N Ntilde ; B 7 -13 593 729 ;\r\nC -1 ; WX 600 ; N otilde ; B 62 -15 538 606 ;\r\nC -1 ; WX 600 ; N Rcommaaccent ; B 38 -250 588 562 ;\r\nC -1 ; WX 600 ; N Lcommaaccent ; B 47 -250 554 562 ;\r\nC -1 ; WX 600 ; N Atilde ; B 3 0 597 729 ;\r\nC -1 ; WX 600 ; N Aogonek ; B 3 -172 608 562 ;\r\nC -1 ; WX 600 ; N Aring ; B 3 0 597 750 ;\r\nC -1 ; WX 600 ; N Otilde ; B 43 -18 557 729 ;\r\nC -1 ; WX 600 ; N zdotaccent ; B 99 0 502 620 ;\r\nC -1 ; WX 600 ; N Ecaron ; B 53 0 550 802 ;\r\nC -1 ; WX 600 ; N Iogonek ; B 96 -172 504 562 ;\r\nC -1 ; WX 600 ; N kcommaaccent ; B 43 -250 580 629 ;\r\nC -1 ; WX 600 ; N minus ; B 80 232 520 283 ;\r\nC -1 ; WX 600 ; N Icircumflex ; B 96 0 504 787 ;\r\nC -1 ; WX 600 ; N ncaron ; B 26 0 575 669 ;\r\nC -1 ; WX 600 ; N tcommaaccent ; B 87 -250 530 561 ;\r\nC -1 ; WX 600 ; N logicalnot ; B 87 108 513 369 ;\r\nC -1 ; WX 600 ; N odieresis ; B 62 -15 538 620 ;\r\nC -1 ; WX 600 ; N udieresis ; B 21 -15 562 620 ;\r\nC -1 ; WX 600 ; N notequal ; B 15 -16 540 529 ;\r\nC -1 ; WX 600 ; N gcommaaccent ; B 45 -157 566 708 ;\r\nC -1 ; WX 600 ; N eth ; B 62 -15 538 629 ;\r\nC -1 ; WX 600 ; N zcaron ; B 99 0 502 669 ;\r\nC -1 ; WX 600 ; N ncommaaccent ; B 26 -250 575 441 ;\r\nC -1 ; WX 600 ; N onesuperior ; B 172 249 428 622 ;\r\nC -1 ; WX 600 ; N imacron ; B 95 0 505 565 ;\r\nC -1 ; WX 600 ; N Euro ; B 0 0 0 0 ;\r\nEndCharMetrics\r\nEndFontMetrics\r\n";
  },
  'Courier-Bold'() {
    return "StartFontMetrics 4.1\r\nComment Copyright (c) 1989, 1990, 1991, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.\r\nComment Creation Date: Mon Jun 23 16:28:00 1997\r\nComment UniqueID 43048\r\nComment VMusage 41139 52164\r\nFontName Courier-Bold\r\nFullName Courier Bold\r\nFamilyName Courier\r\nWeight Bold\r\nItalicAngle 0\r\nIsFixedPitch true\r\nCharacterSet ExtendedRoman\r\nFontBBox -113 -250 749 801 \r\nUnderlinePosition -100\r\nUnderlineThickness 50\r\nVersion 003.000\r\nNotice Copyright (c) 1989, 1990, 1991, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.\r\nEncodingScheme AdobeStandardEncoding\r\nCapHeight 562\r\nXHeight 439\r\nAscender 629\r\nDescender -157\r\nStdHW 84\r\nStdVW 106\r\nStartCharMetrics 315\r\nC 32 ; WX 600 ; N space ; B 0 0 0 0 ;\r\nC 33 ; WX 600 ; N exclam ; B 202 -15 398 572 ;\r\nC 34 ; WX 600 ; N quotedbl ; B 135 277 465 562 ;\r\nC 35 ; WX 600 ; N numbersign ; B 56 -45 544 651 ;\r\nC 36 ; WX 600 ; N dollar ; B 82 -126 519 666 ;\r\nC 37 ; WX 600 ; N percent ; B 5 -15 595 616 ;\r\nC 38 ; WX 600 ; N ampersand ; B 36 -15 546 543 ;\r\nC 39 ; WX 600 ; N quoteright ; B 171 277 423 562 ;\r\nC 40 ; WX 600 ; N parenleft ; B 219 -102 461 616 ;\r\nC 41 ; WX 600 ; N parenright ; B 139 -102 381 616 ;\r\nC 42 ; WX 600 ; N asterisk ; B 91 219 509 601 ;\r\nC 43 ; WX 600 ; N plus ; B 71 39 529 478 ;\r\nC 44 ; WX 600 ; N comma ; B 123 -111 393 174 ;\r\nC 45 ; WX 600 ; N hyphen ; B 100 203 500 313 ;\r\nC 46 ; WX 600 ; N period ; B 192 -15 408 171 ;\r\nC 47 ; WX 600 ; N slash ; B 98 -77 502 626 ;\r\nC 48 ; WX 600 ; N zero ; B 87 -15 513 616 ;\r\nC 49 ; WX 600 ; N one ; B 81 0 539 616 ;\r\nC 50 ; WX 600 ; N two ; B 61 0 499 616 ;\r\nC 51 ; WX 600 ; N three ; B 63 -15 501 616 ;\r\nC 52 ; WX 600 ; N four ; B 53 0 507 616 ;\r\nC 53 ; WX 600 ; N five ; B 70 -15 521 601 ;\r\nC 54 ; WX 600 ; N six ; B 90 -15 521 616 ;\r\nC 55 ; WX 600 ; N seven ; B 55 0 494 601 ;\r\nC 56 ; WX 600 ; N eight ; B 83 -15 517 616 ;\r\nC 57 ; WX 600 ; N nine ; B 79 -15 510 616 ;\r\nC 58 ; WX 600 ; N colon ; B 191 -15 407 425 ;\r\nC 59 ; WX 600 ; N semicolon ; B 123 -111 408 425 ;\r\nC 60 ; WX 600 ; N less ; B 66 15 523 501 ;\r\nC 61 ; WX 600 ; N equal ; B 71 118 529 398 ;\r\nC 62 ; WX 600 ; N greater ; B 77 15 534 501 ;\r\nC 63 ; WX 600 ; N question ; B 98 -14 501 580 ;\r\nC 64 ; WX 600 ; N at ; B 16 -15 584 616 ;\r\nC 65 ; WX 600 ; N A ; B -9 0 609 562 ;\r\nC 66 ; WX 600 ; N B ; B 30 0 573 562 ;\r\nC 67 ; WX 600 ; N C ; B 22 -18 560 580 ;\r\nC 68 ; WX 600 ; N D ; B 30 0 594 562 ;\r\nC 69 ; WX 600 ; N E ; B 25 0 560 562 ;\r\nC 70 ; WX 600 ; N F ; B 39 0 570 562 ;\r\nC 71 ; WX 600 ; N G ; B 22 -18 594 580 ;\r\nC 72 ; WX 600 ; N H ; B 20 0 580 562 ;\r\nC 73 ; WX 600 ; N I ; B 77 0 523 562 ;\r\nC 74 ; WX 600 ; N J ; B 37 -18 601 562 ;\r\nC 75 ; WX 600 ; N K ; B 21 0 599 562 ;\r\nC 76 ; WX 600 ; N L ; B 39 0 578 562 ;\r\nC 77 ; WX 600 ; N M ; B -2 0 602 562 ;\r\nC 78 ; WX 600 ; N N ; B 8 -12 610 562 ;\r\nC 79 ; WX 600 ; N O ; B 22 -18 578 580 ;\r\nC 80 ; WX 600 ; N P ; B 48 0 559 562 ;\r\nC 81 ; WX 600 ; N Q ; B 32 -138 578 580 ;\r\nC 82 ; WX 600 ; N R ; B 24 0 599 562 ;\r\nC 83 ; WX 600 ; N S ; B 47 -22 553 582 ;\r\nC 84 ; WX 600 ; N T ; B 21 0 579 562 ;\r\nC 85 ; WX 600 ; N U ; B 4 -18 596 562 ;\r\nC 86 ; WX 600 ; N V ; B -13 0 613 562 ;\r\nC 87 ; WX 600 ; N W ; B -18 0 618 562 ;\r\nC 88 ; WX 600 ; N X ; B 12 0 588 562 ;\r\nC 89 ; WX 600 ; N Y ; B 12 0 589 562 ;\r\nC 90 ; WX 600 ; N Z ; B 62 0 539 562 ;\r\nC 91 ; WX 600 ; N bracketleft ; B 245 -102 475 616 ;\r\nC 92 ; WX 600 ; N backslash ; B 99 -77 503 626 ;\r\nC 93 ; WX 600 ; N bracketright ; B 125 -102 355 616 ;\r\nC 94 ; WX 600 ; N asciicircum ; B 108 250 492 616 ;\r\nC 95 ; WX 600 ; N underscore ; B 0 -125 600 -75 ;\r\nC 96 ; WX 600 ; N quoteleft ; B 178 277 428 562 ;\r\nC 97 ; WX 600 ; N a ; B 35 -15 570 454 ;\r\nC 98 ; WX 600 ; N b ; B 0 -15 584 626 ;\r\nC 99 ; WX 600 ; N c ; B 40 -15 545 459 ;\r\nC 100 ; WX 600 ; N d ; B 20 -15 591 626 ;\r\nC 101 ; WX 600 ; N e ; B 40 -15 563 454 ;\r\nC 102 ; WX 600 ; N f ; B 83 0 547 626 ; L i fi ; L l fl ;\r\nC 103 ; WX 600 ; N g ; B 30 -146 580 454 ;\r\nC 104 ; WX 600 ; N h ; B 5 0 592 626 ;\r\nC 105 ; WX 600 ; N i ; B 77 0 523 658 ;\r\nC 106 ; WX 600 ; N j ; B 63 -146 440 658 ;\r\nC 107 ; WX 600 ; N k ; B 20 0 585 626 ;\r\nC 108 ; WX 600 ; N l ; B 77 0 523 626 ;\r\nC 109 ; WX 600 ; N m ; B -22 0 626 454 ;\r\nC 110 ; WX 600 ; N n ; B 18 0 592 454 ;\r\nC 111 ; WX 600 ; N o ; B 30 -15 570 454 ;\r\nC 112 ; WX 600 ; N p ; B -1 -142 570 454 ;\r\nC 113 ; WX 600 ; N q ; B 20 -142 591 454 ;\r\nC 114 ; WX 600 ; N r ; B 47 0 580 454 ;\r\nC 115 ; WX 600 ; N s ; B 68 -17 535 459 ;\r\nC 116 ; WX 600 ; N t ; B 47 -15 532 562 ;\r\nC 117 ; WX 600 ; N u ; B -1 -15 569 439 ;\r\nC 118 ; WX 600 ; N v ; B -1 0 601 439 ;\r\nC 119 ; WX 600 ; N w ; B -18 0 618 439 ;\r\nC 120 ; WX 600 ; N x ; B 6 0 594 439 ;\r\nC 121 ; WX 600 ; N y ; B -4 -142 601 439 ;\r\nC 122 ; WX 600 ; N z ; B 81 0 520 439 ;\r\nC 123 ; WX 600 ; N braceleft ; B 160 -102 464 616 ;\r\nC 124 ; WX 600 ; N bar ; B 255 -250 345 750 ;\r\nC 125 ; WX 600 ; N braceright ; B 136 -102 440 616 ;\r\nC 126 ; WX 600 ; N asciitilde ; B 71 153 530 356 ;\r\nC 161 ; WX 600 ; N exclamdown ; B 202 -146 398 449 ;\r\nC 162 ; WX 600 ; N cent ; B 66 -49 518 614 ;\r\nC 163 ; WX 600 ; N sterling ; B 72 -28 558 611 ;\r\nC 164 ; WX 600 ; N fraction ; B 25 -60 576 661 ;\r\nC 165 ; WX 600 ; N yen ; B 10 0 590 562 ;\r\nC 166 ; WX 600 ; N florin ; B -30 -131 572 616 ;\r\nC 167 ; WX 600 ; N section ; B 83 -70 517 580 ;\r\nC 168 ; WX 600 ; N currency ; B 54 49 546 517 ;\r\nC 169 ; WX 600 ; N quotesingle ; B 227 277 373 562 ;\r\nC 170 ; WX 600 ; N quotedblleft ; B 71 277 535 562 ;\r\nC 171 ; WX 600 ; N guillemotleft ; B 8 70 553 446 ;\r\nC 172 ; WX 600 ; N guilsinglleft ; B 141 70 459 446 ;\r\nC 173 ; WX 600 ; N guilsinglright ; B 141 70 459 446 ;\r\nC 174 ; WX 600 ; N fi ; B 12 0 593 626 ;\r\nC 175 ; WX 600 ; N fl ; B 12 0 593 626 ;\r\nC 177 ; WX 600 ; N endash ; B 65 203 535 313 ;\r\nC 178 ; WX 600 ; N dagger ; B 106 -70 494 580 ;\r\nC 179 ; WX 600 ; N daggerdbl ; B 106 -70 494 580 ;\r\nC 180 ; WX 600 ; N periodcentered ; B 196 165 404 351 ;\r\nC 182 ; WX 600 ; N paragraph ; B 6 -70 576 580 ;\r\nC 183 ; WX 600 ; N bullet ; B 140 132 460 430 ;\r\nC 184 ; WX 600 ; N quotesinglbase ; B 175 -142 427 143 ;\r\nC 185 ; WX 600 ; N quotedblbase ; B 65 -142 529 143 ;\r\nC 186 ; WX 600 ; N quotedblright ; B 61 277 525 562 ;\r\nC 187 ; WX 600 ; N guillemotright ; B 47 70 592 446 ;\r\nC 188 ; WX 600 ; N ellipsis ; B 26 -15 574 116 ;\r\nC 189 ; WX 600 ; N perthousand ; B -113 -15 713 616 ;\r\nC 191 ; WX 600 ; N questiondown ; B 99 -146 502 449 ;\r\nC 193 ; WX 600 ; N grave ; B 132 508 395 661 ;\r\nC 194 ; WX 600 ; N acute ; B 205 508 468 661 ;\r\nC 195 ; WX 600 ; N circumflex ; B 103 483 497 657 ;\r\nC 196 ; WX 600 ; N tilde ; B 89 493 512 636 ;\r\nC 197 ; WX 600 ; N macron ; B 88 505 512 585 ;\r\nC 198 ; WX 600 ; N breve ; B 83 468 517 631 ;\r\nC 199 ; WX 600 ; N dotaccent ; B 230 498 370 638 ;\r\nC 200 ; WX 600 ; N dieresis ; B 128 498 472 638 ;\r\nC 202 ; WX 600 ; N ring ; B 198 481 402 678 ;\r\nC 203 ; WX 600 ; N cedilla ; B 205 -206 387 0 ;\r\nC 205 ; WX 600 ; N hungarumlaut ; B 68 488 588 661 ;\r\nC 206 ; WX 600 ; N ogonek ; B 169 -199 400 0 ;\r\nC 207 ; WX 600 ; N caron ; B 103 493 497 667 ;\r\nC 208 ; WX 600 ; N emdash ; B -10 203 610 313 ;\r\nC 225 ; WX 600 ; N AE ; B -29 0 602 562 ;\r\nC 227 ; WX 600 ; N ordfeminine ; B 147 196 453 580 ;\r\nC 232 ; WX 600 ; N Lslash ; B 39 0 578 562 ;\r\nC 233 ; WX 600 ; N Oslash ; B 22 -22 578 584 ;\r\nC 234 ; WX 600 ; N OE ; B -25 0 595 562 ;\r\nC 235 ; WX 600 ; N ordmasculine ; B 147 196 453 580 ;\r\nC 241 ; WX 600 ; N ae ; B -4 -15 601 454 ;\r\nC 245 ; WX 600 ; N dotlessi ; B 77 0 523 439 ;\r\nC 248 ; WX 600 ; N lslash ; B 77 0 523 626 ;\r\nC 249 ; WX 600 ; N oslash ; B 30 -24 570 463 ;\r\nC 250 ; WX 600 ; N oe ; B -18 -15 611 454 ;\r\nC 251 ; WX 600 ; N germandbls ; B 22 -15 596 626 ;\r\nC -1 ; WX 600 ; N Idieresis ; B 77 0 523 761 ;\r\nC -1 ; WX 600 ; N eacute ; B 40 -15 563 661 ;\r\nC -1 ; WX 600 ; N abreve ; B 35 -15 570 661 ;\r\nC -1 ; WX 600 ; N uhungarumlaut ; B -1 -15 628 661 ;\r\nC -1 ; WX 600 ; N ecaron ; B 40 -15 563 667 ;\r\nC -1 ; WX 600 ; N Ydieresis ; B 12 0 589 761 ;\r\nC -1 ; WX 600 ; N divide ; B 71 16 529 500 ;\r\nC -1 ; WX 600 ; N Yacute ; B 12 0 589 784 ;\r\nC -1 ; WX 600 ; N Acircumflex ; B -9 0 609 780 ;\r\nC -1 ; WX 600 ; N aacute ; B 35 -15 570 661 ;\r\nC -1 ; WX 600 ; N Ucircumflex ; B 4 -18 596 780 ;\r\nC -1 ; WX 600 ; N yacute ; B -4 -142 601 661 ;\r\nC -1 ; WX 600 ; N scommaaccent ; B 68 -250 535 459 ;\r\nC -1 ; WX 600 ; N ecircumflex ; B 40 -15 563 657 ;\r\nC -1 ; WX 600 ; N Uring ; B 4 -18 596 801 ;\r\nC -1 ; WX 600 ; N Udieresis ; B 4 -18 596 761 ;\r\nC -1 ; WX 600 ; N aogonek ; B 35 -199 586 454 ;\r\nC -1 ; WX 600 ; N Uacute ; B 4 -18 596 784 ;\r\nC -1 ; WX 600 ; N uogonek ; B -1 -199 585 439 ;\r\nC -1 ; WX 600 ; N Edieresis ; B 25 0 560 761 ;\r\nC -1 ; WX 600 ; N Dcroat ; B 30 0 594 562 ;\r\nC -1 ; WX 600 ; N commaaccent ; B 205 -250 397 -57 ;\r\nC -1 ; WX 600 ; N copyright ; B 0 -18 600 580 ;\r\nC -1 ; WX 600 ; N Emacron ; B 25 0 560 708 ;\r\nC -1 ; WX 600 ; N ccaron ; B 40 -15 545 667 ;\r\nC -1 ; WX 600 ; N aring ; B 35 -15 570 678 ;\r\nC -1 ; WX 600 ; N Ncommaaccent ; B 8 -250 610 562 ;\r\nC -1 ; WX 600 ; N lacute ; B 77 0 523 801 ;\r\nC -1 ; WX 600 ; N agrave ; B 35 -15 570 661 ;\r\nC -1 ; WX 600 ; N Tcommaaccent ; B 21 -250 579 562 ;\r\nC -1 ; WX 600 ; N Cacute ; B 22 -18 560 784 ;\r\nC -1 ; WX 600 ; N atilde ; B 35 -15 570 636 ;\r\nC -1 ; WX 600 ; N Edotaccent ; B 25 0 560 761 ;\r\nC -1 ; WX 600 ; N scaron ; B 68 -17 535 667 ;\r\nC -1 ; WX 600 ; N scedilla ; B 68 -206 535 459 ;\r\nC -1 ; WX 600 ; N iacute ; B 77 0 523 661 ;\r\nC -1 ; WX 600 ; N lozenge ; B 66 0 534 740 ;\r\nC -1 ; WX 600 ; N Rcaron ; B 24 0 599 790 ;\r\nC -1 ; WX 600 ; N Gcommaaccent ; B 22 -250 594 580 ;\r\nC -1 ; WX 600 ; N ucircumflex ; B -1 -15 569 657 ;\r\nC -1 ; WX 600 ; N acircumflex ; B 35 -15 570 657 ;\r\nC -1 ; WX 600 ; N Amacron ; B -9 0 609 708 ;\r\nC -1 ; WX 600 ; N rcaron ; B 47 0 580 667 ;\r\nC -1 ; WX 600 ; N ccedilla ; B 40 -206 545 459 ;\r\nC -1 ; WX 600 ; N Zdotaccent ; B 62 0 539 761 ;\r\nC -1 ; WX 600 ; N Thorn ; B 48 0 557 562 ;\r\nC -1 ; WX 600 ; N Omacron ; B 22 -18 578 708 ;\r\nC -1 ; WX 600 ; N Racute ; B 24 0 599 784 ;\r\nC -1 ; WX 600 ; N Sacute ; B 47 -22 553 784 ;\r\nC -1 ; WX 600 ; N dcaron ; B 20 -15 727 626 ;\r\nC -1 ; WX 600 ; N Umacron ; B 4 -18 596 708 ;\r\nC -1 ; WX 600 ; N uring ; B -1 -15 569 678 ;\r\nC -1 ; WX 600 ; N threesuperior ; B 138 222 433 616 ;\r\nC -1 ; WX 600 ; N Ograve ; B 22 -18 578 784 ;\r\nC -1 ; WX 600 ; N Agrave ; B -9 0 609 784 ;\r\nC -1 ; WX 600 ; N Abreve ; B -9 0 609 784 ;\r\nC -1 ; WX 600 ; N multiply ; B 81 39 520 478 ;\r\nC -1 ; WX 600 ; N uacute ; B -1 -15 569 661 ;\r\nC -1 ; WX 600 ; N Tcaron ; B 21 0 579 790 ;\r\nC -1 ; WX 600 ; N partialdiff ; B 63 -38 537 728 ;\r\nC -1 ; WX 600 ; N ydieresis ; B -4 -142 601 638 ;\r\nC -1 ; WX 600 ; N Nacute ; B 8 -12 610 784 ;\r\nC -1 ; WX 600 ; N icircumflex ; B 73 0 523 657 ;\r\nC -1 ; WX 600 ; N Ecircumflex ; B 25 0 560 780 ;\r\nC -1 ; WX 600 ; N adieresis ; B 35 -15 570 638 ;\r\nC -1 ; WX 600 ; N edieresis ; B 40 -15 563 638 ;\r\nC -1 ; WX 600 ; N cacute ; B 40 -15 545 661 ;\r\nC -1 ; WX 600 ; N nacute ; B 18 0 592 661 ;\r\nC -1 ; WX 600 ; N umacron ; B -1 -15 569 585 ;\r\nC -1 ; WX 600 ; N Ncaron ; B 8 -12 610 790 ;\r\nC -1 ; WX 600 ; N Iacute ; B 77 0 523 784 ;\r\nC -1 ; WX 600 ; N plusminus ; B 71 24 529 515 ;\r\nC -1 ; WX 600 ; N brokenbar ; B 255 -175 345 675 ;\r\nC -1 ; WX 600 ; N registered ; B 0 -18 600 580 ;\r\nC -1 ; WX 600 ; N Gbreve ; B 22 -18 594 784 ;\r\nC -1 ; WX 600 ; N Idotaccent ; B 77 0 523 761 ;\r\nC -1 ; WX 600 ; N summation ; B 15 -10 586 706 ;\r\nC -1 ; WX 600 ; N Egrave ; B 25 0 560 784 ;\r\nC -1 ; WX 600 ; N racute ; B 47 0 580 661 ;\r\nC -1 ; WX 600 ; N omacron ; B 30 -15 570 585 ;\r\nC -1 ; WX 600 ; N Zacute ; B 62 0 539 784 ;\r\nC -1 ; WX 600 ; N Zcaron ; B 62 0 539 790 ;\r\nC -1 ; WX 600 ; N greaterequal ; B 26 0 523 696 ;\r\nC -1 ; WX 600 ; N Eth ; B 30 0 594 562 ;\r\nC -1 ; WX 600 ; N Ccedilla ; B 22 -206 560 580 ;\r\nC -1 ; WX 600 ; N lcommaaccent ; B 77 -250 523 626 ;\r\nC -1 ; WX 600 ; N tcaron ; B 47 -15 532 703 ;\r\nC -1 ; WX 600 ; N eogonek ; B 40 -199 563 454 ;\r\nC -1 ; WX 600 ; N Uogonek ; B 4 -199 596 562 ;\r\nC -1 ; WX 600 ; N Aacute ; B -9 0 609 784 ;\r\nC -1 ; WX 600 ; N Adieresis ; B -9 0 609 761 ;\r\nC -1 ; WX 600 ; N egrave ; B 40 -15 563 661 ;\r\nC -1 ; WX 600 ; N zacute ; B 81 0 520 661 ;\r\nC -1 ; WX 600 ; N iogonek ; B 77 -199 523 658 ;\r\nC -1 ; WX 600 ; N Oacute ; B 22 -18 578 784 ;\r\nC -1 ; WX 600 ; N oacute ; B 30 -15 570 661 ;\r\nC -1 ; WX 600 ; N amacron ; B 35 -15 570 585 ;\r\nC -1 ; WX 600 ; N sacute ; B 68 -17 535 661 ;\r\nC -1 ; WX 600 ; N idieresis ; B 77 0 523 618 ;\r\nC -1 ; WX 600 ; N Ocircumflex ; B 22 -18 578 780 ;\r\nC -1 ; WX 600 ; N Ugrave ; B 4 -18 596 784 ;\r\nC -1 ; WX 600 ; N Delta ; B 6 0 594 688 ;\r\nC -1 ; WX 600 ; N thorn ; B -14 -142 570 626 ;\r\nC -1 ; WX 600 ; N twosuperior ; B 143 230 436 616 ;\r\nC -1 ; WX 600 ; N Odieresis ; B 22 -18 578 761 ;\r\nC -1 ; WX 600 ; N mu ; B -1 -142 569 439 ;\r\nC -1 ; WX 600 ; N igrave ; B 77 0 523 661 ;\r\nC -1 ; WX 600 ; N ohungarumlaut ; B 30 -15 668 661 ;\r\nC -1 ; WX 600 ; N Eogonek ; B 25 -199 576 562 ;\r\nC -1 ; WX 600 ; N dcroat ; B 20 -15 591 626 ;\r\nC -1 ; WX 600 ; N threequarters ; B -47 -60 648 661 ;\r\nC -1 ; WX 600 ; N Scedilla ; B 47 -206 553 582 ;\r\nC -1 ; WX 600 ; N lcaron ; B 77 0 597 626 ;\r\nC -1 ; WX 600 ; N Kcommaaccent ; B 21 -250 599 562 ;\r\nC -1 ; WX 600 ; N Lacute ; B 39 0 578 784 ;\r\nC -1 ; WX 600 ; N trademark ; B -9 230 749 562 ;\r\nC -1 ; WX 600 ; N edotaccent ; B 40 -15 563 638 ;\r\nC -1 ; WX 600 ; N Igrave ; B 77 0 523 784 ;\r\nC -1 ; WX 600 ; N Imacron ; B 77 0 523 708 ;\r\nC -1 ; WX 600 ; N Lcaron ; B 39 0 637 562 ;\r\nC -1 ; WX 600 ; N onehalf ; B -47 -60 648 661 ;\r\nC -1 ; WX 600 ; N lessequal ; B 26 0 523 696 ;\r\nC -1 ; WX 600 ; N ocircumflex ; B 30 -15 570 657 ;\r\nC -1 ; WX 600 ; N ntilde ; B 18 0 592 636 ;\r\nC -1 ; WX 600 ; N Uhungarumlaut ; B 4 -18 638 784 ;\r\nC -1 ; WX 600 ; N Eacute ; B 25 0 560 784 ;\r\nC -1 ; WX 600 ; N emacron ; B 40 -15 563 585 ;\r\nC -1 ; WX 600 ; N gbreve ; B 30 -146 580 661 ;\r\nC -1 ; WX 600 ; N onequarter ; B -56 -60 656 661 ;\r\nC -1 ; WX 600 ; N Scaron ; B 47 -22 553 790 ;\r\nC -1 ; WX 600 ; N Scommaaccent ; B 47 -250 553 582 ;\r\nC -1 ; WX 600 ; N Ohungarumlaut ; B 22 -18 628 784 ;\r\nC -1 ; WX 600 ; N degree ; B 86 243 474 616 ;\r\nC -1 ; WX 600 ; N ograve ; B 30 -15 570 661 ;\r\nC -1 ; WX 600 ; N Ccaron ; B 22 -18 560 790 ;\r\nC -1 ; WX 600 ; N ugrave ; B -1 -15 569 661 ;\r\nC -1 ; WX 600 ; N radical ; B -19 -104 473 778 ;\r\nC -1 ; WX 600 ; N Dcaron ; B 30 0 594 790 ;\r\nC -1 ; WX 600 ; N rcommaaccent ; B 47 -250 580 454 ;\r\nC -1 ; WX 600 ; N Ntilde ; B 8 -12 610 759 ;\r\nC -1 ; WX 600 ; N otilde ; B 30 -15 570 636 ;\r\nC -1 ; WX 600 ; N Rcommaaccent ; B 24 -250 599 562 ;\r\nC -1 ; WX 600 ; N Lcommaaccent ; B 39 -250 578 562 ;\r\nC -1 ; WX 600 ; N Atilde ; B -9 0 609 759 ;\r\nC -1 ; WX 600 ; N Aogonek ; B -9 -199 625 562 ;\r\nC -1 ; WX 600 ; N Aring ; B -9 0 609 801 ;\r\nC -1 ; WX 600 ; N Otilde ; B 22 -18 578 759 ;\r\nC -1 ; WX 600 ; N zdotaccent ; B 81 0 520 638 ;\r\nC -1 ; WX 600 ; N Ecaron ; B 25 0 560 790 ;\r\nC -1 ; WX 600 ; N Iogonek ; B 77 -199 523 562 ;\r\nC -1 ; WX 600 ; N kcommaaccent ; B 20 -250 585 626 ;\r\nC -1 ; WX 600 ; N minus ; B 71 203 529 313 ;\r\nC -1 ; WX 600 ; N Icircumflex ; B 77 0 523 780 ;\r\nC -1 ; WX 600 ; N ncaron ; B 18 0 592 667 ;\r\nC -1 ; WX 600 ; N tcommaaccent ; B 47 -250 532 562 ;\r\nC -1 ; WX 600 ; N logicalnot ; B 71 103 529 413 ;\r\nC -1 ; WX 600 ; N odieresis ; B 30 -15 570 638 ;\r\nC -1 ; WX 600 ; N udieresis ; B -1 -15 569 638 ;\r\nC -1 ; WX 600 ; N notequal ; B 12 -47 537 563 ;\r\nC -1 ; WX 600 ; N gcommaaccent ; B 30 -146 580 714 ;\r\nC -1 ; WX 600 ; N eth ; B 58 -27 543 626 ;\r\nC -1 ; WX 600 ; N zcaron ; B 81 0 520 667 ;\r\nC -1 ; WX 600 ; N ncommaaccent ; B 18 -250 592 454 ;\r\nC -1 ; WX 600 ; N onesuperior ; B 153 230 447 616 ;\r\nC -1 ; WX 600 ; N imacron ; B 77 0 523 585 ;\r\nC -1 ; WX 600 ; N Euro ; B 0 0 0 0 ;\r\nEndCharMetrics\r\nEndFontMetrics\r\n";
  },
  'Courier-Oblique'() {
    return "StartFontMetrics 4.1\r\nComment Copyright (c) 1989, 1990, 1991, 1992, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.\r\nComment Creation Date: Thu May  1 17:37:52 1997\r\nComment UniqueID 43051\r\nComment VMusage 16248 75829\r\nFontName Courier-Oblique\r\nFullName Courier Oblique\r\nFamilyName Courier\r\nWeight Medium\r\nItalicAngle -12\r\nIsFixedPitch true\r\nCharacterSet ExtendedRoman\r\nFontBBox -27 -250 849 805 \r\nUnderlinePosition -100\r\nUnderlineThickness 50\r\nVersion 003.000\r\nNotice Copyright (c) 1989, 1990, 1991, 1992, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.\r\nEncodingScheme AdobeStandardEncoding\r\nCapHeight 562\r\nXHeight 426\r\nAscender 629\r\nDescender -157\r\nStdHW 51\r\nStdVW 51\r\nStartCharMetrics 315\r\nC 32 ; WX 600 ; N space ; B 0 0 0 0 ;\r\nC 33 ; WX 600 ; N exclam ; B 243 -15 464 572 ;\r\nC 34 ; WX 600 ; N quotedbl ; B 273 328 532 562 ;\r\nC 35 ; WX 600 ; N numbersign ; B 133 -32 596 639 ;\r\nC 36 ; WX 600 ; N dollar ; B 108 -126 596 662 ;\r\nC 37 ; WX 600 ; N percent ; B 134 -15 599 622 ;\r\nC 38 ; WX 600 ; N ampersand ; B 87 -15 580 543 ;\r\nC 39 ; WX 600 ; N quoteright ; B 283 328 495 562 ;\r\nC 40 ; WX 600 ; N parenleft ; B 313 -108 572 622 ;\r\nC 41 ; WX 600 ; N parenright ; B 137 -108 396 622 ;\r\nC 42 ; WX 600 ; N asterisk ; B 212 257 580 607 ;\r\nC 43 ; WX 600 ; N plus ; B 129 44 580 470 ;\r\nC 44 ; WX 600 ; N comma ; B 157 -112 370 122 ;\r\nC 45 ; WX 600 ; N hyphen ; B 152 231 558 285 ;\r\nC 46 ; WX 600 ; N period ; B 238 -15 382 109 ;\r\nC 47 ; WX 600 ; N slash ; B 112 -80 604 629 ;\r\nC 48 ; WX 600 ; N zero ; B 154 -15 575 622 ;\r\nC 49 ; WX 600 ; N one ; B 98 0 515 622 ;\r\nC 50 ; WX 600 ; N two ; B 70 0 568 622 ;\r\nC 51 ; WX 600 ; N three ; B 82 -15 538 622 ;\r\nC 52 ; WX 600 ; N four ; B 108 0 541 622 ;\r\nC 53 ; WX 600 ; N five ; B 99 -15 589 607 ;\r\nC 54 ; WX 600 ; N six ; B 155 -15 629 622 ;\r\nC 55 ; WX 600 ; N seven ; B 182 0 612 607 ;\r\nC 56 ; WX 600 ; N eight ; B 132 -15 588 622 ;\r\nC 57 ; WX 600 ; N nine ; B 93 -15 574 622 ;\r\nC 58 ; WX 600 ; N colon ; B 238 -15 441 385 ;\r\nC 59 ; WX 600 ; N semicolon ; B 157 -112 441 385 ;\r\nC 60 ; WX 600 ; N less ; B 96 42 610 472 ;\r\nC 61 ; WX 600 ; N equal ; B 109 138 600 376 ;\r\nC 62 ; WX 600 ; N greater ; B 85 42 599 472 ;\r\nC 63 ; WX 600 ; N question ; B 222 -15 583 572 ;\r\nC 64 ; WX 600 ; N at ; B 127 -15 582 622 ;\r\nC 65 ; WX 600 ; N A ; B 3 0 607 562 ;\r\nC 66 ; WX 600 ; N B ; B 43 0 616 562 ;\r\nC 67 ; WX 600 ; N C ; B 93 -18 655 580 ;\r\nC 68 ; WX 600 ; N D ; B 43 0 645 562 ;\r\nC 69 ; WX 600 ; N E ; B 53 0 660 562 ;\r\nC 70 ; WX 600 ; N F ; B 53 0 660 562 ;\r\nC 71 ; WX 600 ; N G ; B 83 -18 645 580 ;\r\nC 72 ; WX 600 ; N H ; B 32 0 687 562 ;\r\nC 73 ; WX 600 ; N I ; B 96 0 623 562 ;\r\nC 74 ; WX 600 ; N J ; B 52 -18 685 562 ;\r\nC 75 ; WX 600 ; N K ; B 38 0 671 562 ;\r\nC 76 ; WX 600 ; N L ; B 47 0 607 562 ;\r\nC 77 ; WX 600 ; N M ; B 4 0 715 562 ;\r\nC 78 ; WX 600 ; N N ; B 7 -13 712 562 ;\r\nC 79 ; WX 600 ; N O ; B 94 -18 625 580 ;\r\nC 80 ; WX 600 ; N P ; B 79 0 644 562 ;\r\nC 81 ; WX 600 ; N Q ; B 95 -138 625 580 ;\r\nC 82 ; WX 600 ; N R ; B 38 0 598 562 ;\r\nC 83 ; WX 600 ; N S ; B 76 -20 650 580 ;\r\nC 84 ; WX 600 ; N T ; B 108 0 665 562 ;\r\nC 85 ; WX 600 ; N U ; B 125 -18 702 562 ;\r\nC 86 ; WX 600 ; N V ; B 105 -13 723 562 ;\r\nC 87 ; WX 600 ; N W ; B 106 -13 722 562 ;\r\nC 88 ; WX 600 ; N X ; B 23 0 675 562 ;\r\nC 89 ; WX 600 ; N Y ; B 133 0 695 562 ;\r\nC 90 ; WX 600 ; N Z ; B 86 0 610 562 ;\r\nC 91 ; WX 600 ; N bracketleft ; B 246 -108 574 622 ;\r\nC 92 ; WX 600 ; N backslash ; B 249 -80 468 629 ;\r\nC 93 ; WX 600 ; N bracketright ; B 135 -108 463 622 ;\r\nC 94 ; WX 600 ; N asciicircum ; B 175 354 587 622 ;\r\nC 95 ; WX 600 ; N underscore ; B -27 -125 584 -75 ;\r\nC 96 ; WX 600 ; N quoteleft ; B 343 328 457 562 ;\r\nC 97 ; WX 600 ; N a ; B 76 -15 569 441 ;\r\nC 98 ; WX 600 ; N b ; B 29 -15 625 629 ;\r\nC 99 ; WX 600 ; N c ; B 106 -15 608 441 ;\r\nC 100 ; WX 600 ; N d ; B 85 -15 640 629 ;\r\nC 101 ; WX 600 ; N e ; B 106 -15 598 441 ;\r\nC 102 ; WX 600 ; N f ; B 114 0 662 629 ; L i fi ; L l fl ;\r\nC 103 ; WX 600 ; N g ; B 61 -157 657 441 ;\r\nC 104 ; WX 600 ; N h ; B 33 0 592 629 ;\r\nC 105 ; WX 600 ; N i ; B 95 0 515 657 ;\r\nC 106 ; WX 600 ; N j ; B 52 -157 550 657 ;\r\nC 107 ; WX 600 ; N k ; B 58 0 633 629 ;\r\nC 108 ; WX 600 ; N l ; B 95 0 515 629 ;\r\nC 109 ; WX 600 ; N m ; B -5 0 615 441 ;\r\nC 110 ; WX 600 ; N n ; B 26 0 585 441 ;\r\nC 111 ; WX 600 ; N o ; B 102 -15 588 441 ;\r\nC 112 ; WX 600 ; N p ; B -24 -157 605 441 ;\r\nC 113 ; WX 600 ; N q ; B 85 -157 682 441 ;\r\nC 114 ; WX 600 ; N r ; B 60 0 636 441 ;\r\nC 115 ; WX 600 ; N s ; B 78 -15 584 441 ;\r\nC 116 ; WX 600 ; N t ; B 167 -15 561 561 ;\r\nC 117 ; WX 600 ; N u ; B 101 -15 572 426 ;\r\nC 118 ; WX 600 ; N v ; B 90 -10 681 426 ;\r\nC 119 ; WX 600 ; N w ; B 76 -10 695 426 ;\r\nC 120 ; WX 600 ; N x ; B 20 0 655 426 ;\r\nC 121 ; WX 600 ; N y ; B -4 -157 683 426 ;\r\nC 122 ; WX 600 ; N z ; B 99 0 593 426 ;\r\nC 123 ; WX 600 ; N braceleft ; B 233 -108 569 622 ;\r\nC 124 ; WX 600 ; N bar ; B 222 -250 485 750 ;\r\nC 125 ; WX 600 ; N braceright ; B 140 -108 477 622 ;\r\nC 126 ; WX 600 ; N asciitilde ; B 116 197 600 320 ;\r\nC 161 ; WX 600 ; N exclamdown ; B 225 -157 445 430 ;\r\nC 162 ; WX 600 ; N cent ; B 151 -49 588 614 ;\r\nC 163 ; WX 600 ; N sterling ; B 124 -21 621 611 ;\r\nC 164 ; WX 600 ; N fraction ; B 84 -57 646 665 ;\r\nC 165 ; WX 600 ; N yen ; B 120 0 693 562 ;\r\nC 166 ; WX 600 ; N florin ; B -26 -143 671 622 ;\r\nC 167 ; WX 600 ; N section ; B 104 -78 590 580 ;\r\nC 168 ; WX 600 ; N currency ; B 94 58 628 506 ;\r\nC 169 ; WX 600 ; N quotesingle ; B 345 328 460 562 ;\r\nC 170 ; WX 600 ; N quotedblleft ; B 262 328 541 562 ;\r\nC 171 ; WX 600 ; N guillemotleft ; B 92 70 652 446 ;\r\nC 172 ; WX 600 ; N guilsinglleft ; B 204 70 540 446 ;\r\nC 173 ; WX 600 ; N guilsinglright ; B 170 70 506 446 ;\r\nC 174 ; WX 600 ; N fi ; B 3 0 619 629 ;\r\nC 175 ; WX 600 ; N fl ; B 3 0 619 629 ;\r\nC 177 ; WX 600 ; N endash ; B 124 231 586 285 ;\r\nC 178 ; WX 600 ; N dagger ; B 217 -78 546 580 ;\r\nC 179 ; WX 600 ; N daggerdbl ; B 163 -78 546 580 ;\r\nC 180 ; WX 600 ; N periodcentered ; B 275 189 434 327 ;\r\nC 182 ; WX 600 ; N paragraph ; B 100 -78 630 562 ;\r\nC 183 ; WX 600 ; N bullet ; B 224 130 485 383 ;\r\nC 184 ; WX 600 ; N quotesinglbase ; B 185 -134 397 100 ;\r\nC 185 ; WX 600 ; N quotedblbase ; B 115 -134 478 100 ;\r\nC 186 ; WX 600 ; N quotedblright ; B 213 328 576 562 ;\r\nC 187 ; WX 600 ; N guillemotright ; B 58 70 618 446 ;\r\nC 188 ; WX 600 ; N ellipsis ; B 46 -15 575 111 ;\r\nC 189 ; WX 600 ; N perthousand ; B 59 -15 627 622 ;\r\nC 191 ; WX 600 ; N questiondown ; B 105 -157 466 430 ;\r\nC 193 ; WX 600 ; N grave ; B 294 497 484 672 ;\r\nC 194 ; WX 600 ; N acute ; B 348 497 612 672 ;\r\nC 195 ; WX 600 ; N circumflex ; B 229 477 581 654 ;\r\nC 196 ; WX 600 ; N tilde ; B 212 489 629 606 ;\r\nC 197 ; WX 600 ; N macron ; B 232 525 600 565 ;\r\nC 198 ; WX 600 ; N breve ; B 279 501 576 609 ;\r\nC 199 ; WX 600 ; N dotaccent ; B 373 537 478 640 ;\r\nC 200 ; WX 600 ; N dieresis ; B 272 537 579 640 ;\r\nC 202 ; WX 600 ; N ring ; B 332 463 500 627 ;\r\nC 203 ; WX 600 ; N cedilla ; B 197 -151 344 10 ;\r\nC 205 ; WX 600 ; N hungarumlaut ; B 239 497 683 672 ;\r\nC 206 ; WX 600 ; N ogonek ; B 189 -172 377 4 ;\r\nC 207 ; WX 600 ; N caron ; B 262 492 614 669 ;\r\nC 208 ; WX 600 ; N emdash ; B 49 231 661 285 ;\r\nC 225 ; WX 600 ; N AE ; B 3 0 655 562 ;\r\nC 227 ; WX 600 ; N ordfeminine ; B 209 249 512 580 ;\r\nC 232 ; WX 600 ; N Lslash ; B 47 0 607 562 ;\r\nC 233 ; WX 600 ; N Oslash ; B 94 -80 625 629 ;\r\nC 234 ; WX 600 ; N OE ; B 59 0 672 562 ;\r\nC 235 ; WX 600 ; N ordmasculine ; B 210 249 535 580 ;\r\nC 241 ; WX 600 ; N ae ; B 41 -15 626 441 ;\r\nC 245 ; WX 600 ; N dotlessi ; B 95 0 515 426 ;\r\nC 248 ; WX 600 ; N lslash ; B 95 0 587 629 ;\r\nC 249 ; WX 600 ; N oslash ; B 102 -80 588 506 ;\r\nC 250 ; WX 600 ; N oe ; B 54 -15 615 441 ;\r\nC 251 ; WX 600 ; N germandbls ; B 48 -15 617 629 ;\r\nC -1 ; WX 600 ; N Idieresis ; B 96 0 623 753 ;\r\nC -1 ; WX 600 ; N eacute ; B 106 -15 612 672 ;\r\nC -1 ; WX 600 ; N abreve ; B 76 -15 576 609 ;\r\nC -1 ; WX 600 ; N uhungarumlaut ; B 101 -15 723 672 ;\r\nC -1 ; WX 600 ; N ecaron ; B 106 -15 614 669 ;\r\nC -1 ; WX 600 ; N Ydieresis ; B 133 0 695 753 ;\r\nC -1 ; WX 600 ; N divide ; B 136 48 573 467 ;\r\nC -1 ; WX 600 ; N Yacute ; B 133 0 695 805 ;\r\nC -1 ; WX 600 ; N Acircumflex ; B 3 0 607 787 ;\r\nC -1 ; WX 600 ; N aacute ; B 76 -15 612 672 ;\r\nC -1 ; WX 600 ; N Ucircumflex ; B 125 -18 702 787 ;\r\nC -1 ; WX 600 ; N yacute ; B -4 -157 683 672 ;\r\nC -1 ; WX 600 ; N scommaaccent ; B 78 -250 584 441 ;\r\nC -1 ; WX 600 ; N ecircumflex ; B 106 -15 598 654 ;\r\nC -1 ; WX 600 ; N Uring ; B 125 -18 702 760 ;\r\nC -1 ; WX 600 ; N Udieresis ; B 125 -18 702 753 ;\r\nC -1 ; WX 600 ; N aogonek ; B 76 -172 569 441 ;\r\nC -1 ; WX 600 ; N Uacute ; B 125 -18 702 805 ;\r\nC -1 ; WX 600 ; N uogonek ; B 101 -172 572 426 ;\r\nC -1 ; WX 600 ; N Edieresis ; B 53 0 660 753 ;\r\nC -1 ; WX 600 ; N Dcroat ; B 43 0 645 562 ;\r\nC -1 ; WX 600 ; N commaaccent ; B 145 -250 323 -58 ;\r\nC -1 ; WX 600 ; N copyright ; B 53 -18 667 580 ;\r\nC -1 ; WX 600 ; N Emacron ; B 53 0 660 698 ;\r\nC -1 ; WX 600 ; N ccaron ; B 106 -15 614 669 ;\r\nC -1 ; WX 600 ; N aring ; B 76 -15 569 627 ;\r\nC -1 ; WX 600 ; N Ncommaaccent ; B 7 -250 712 562 ;\r\nC -1 ; WX 600 ; N lacute ; B 95 0 640 805 ;\r\nC -1 ; WX 600 ; N agrave ; B 76 -15 569 672 ;\r\nC -1 ; WX 600 ; N Tcommaaccent ; B 108 -250 665 562 ;\r\nC -1 ; WX 600 ; N Cacute ; B 93 -18 655 805 ;\r\nC -1 ; WX 600 ; N atilde ; B 76 -15 629 606 ;\r\nC -1 ; WX 600 ; N Edotaccent ; B 53 0 660 753 ;\r\nC -1 ; WX 600 ; N scaron ; B 78 -15 614 669 ;\r\nC -1 ; WX 600 ; N scedilla ; B 78 -151 584 441 ;\r\nC -1 ; WX 600 ; N iacute ; B 95 0 612 672 ;\r\nC -1 ; WX 600 ; N lozenge ; B 94 0 519 706 ;\r\nC -1 ; WX 600 ; N Rcaron ; B 38 0 642 802 ;\r\nC -1 ; WX 600 ; N Gcommaaccent ; B 83 -250 645 580 ;\r\nC -1 ; WX 600 ; N ucircumflex ; B 101 -15 572 654 ;\r\nC -1 ; WX 600 ; N acircumflex ; B 76 -15 581 654 ;\r\nC -1 ; WX 600 ; N Amacron ; B 3 0 607 698 ;\r\nC -1 ; WX 600 ; N rcaron ; B 60 0 636 669 ;\r\nC -1 ; WX 600 ; N ccedilla ; B 106 -151 614 441 ;\r\nC -1 ; WX 600 ; N Zdotaccent ; B 86 0 610 753 ;\r\nC -1 ; WX 600 ; N Thorn ; B 79 0 606 562 ;\r\nC -1 ; WX 600 ; N Omacron ; B 94 -18 628 698 ;\r\nC -1 ; WX 600 ; N Racute ; B 38 0 670 805 ;\r\nC -1 ; WX 600 ; N Sacute ; B 76 -20 650 805 ;\r\nC -1 ; WX 600 ; N dcaron ; B 85 -15 849 629 ;\r\nC -1 ; WX 600 ; N Umacron ; B 125 -18 702 698 ;\r\nC -1 ; WX 600 ; N uring ; B 101 -15 572 627 ;\r\nC -1 ; WX 600 ; N threesuperior ; B 213 240 501 622 ;\r\nC -1 ; WX 600 ; N Ograve ; B 94 -18 625 805 ;\r\nC -1 ; WX 600 ; N Agrave ; B 3 0 607 805 ;\r\nC -1 ; WX 600 ; N Abreve ; B 3 0 607 732 ;\r\nC -1 ; WX 600 ; N multiply ; B 103 43 607 470 ;\r\nC -1 ; WX 600 ; N uacute ; B 101 -15 602 672 ;\r\nC -1 ; WX 600 ; N Tcaron ; B 108 0 665 802 ;\r\nC -1 ; WX 600 ; N partialdiff ; B 45 -38 546 710 ;\r\nC -1 ; WX 600 ; N ydieresis ; B -4 -157 683 620 ;\r\nC -1 ; WX 600 ; N Nacute ; B 7 -13 712 805 ;\r\nC -1 ; WX 600 ; N icircumflex ; B 95 0 551 654 ;\r\nC -1 ; WX 600 ; N Ecircumflex ; B 53 0 660 787 ;\r\nC -1 ; WX 600 ; N adieresis ; B 76 -15 575 620 ;\r\nC -1 ; WX 600 ; N edieresis ; B 106 -15 598 620 ;\r\nC -1 ; WX 600 ; N cacute ; B 106 -15 612 672 ;\r\nC -1 ; WX 600 ; N nacute ; B 26 0 602 672 ;\r\nC -1 ; WX 600 ; N umacron ; B 101 -15 600 565 ;\r\nC -1 ; WX 600 ; N Ncaron ; B 7 -13 712 802 ;\r\nC -1 ; WX 600 ; N Iacute ; B 96 0 640 805 ;\r\nC -1 ; WX 600 ; N plusminus ; B 96 44 594 558 ;\r\nC -1 ; WX 600 ; N brokenbar ; B 238 -175 469 675 ;\r\nC -1 ; WX 600 ; N registered ; B 53 -18 667 580 ;\r\nC -1 ; WX 600 ; N Gbreve ; B 83 -18 645 732 ;\r\nC -1 ; WX 600 ; N Idotaccent ; B 96 0 623 753 ;\r\nC -1 ; WX 600 ; N summation ; B 15 -10 670 706 ;\r\nC -1 ; WX 600 ; N Egrave ; B 53 0 660 805 ;\r\nC -1 ; WX 600 ; N racute ; B 60 0 636 672 ;\r\nC -1 ; WX 600 ; N omacron ; B 102 -15 600 565 ;\r\nC -1 ; WX 600 ; N Zacute ; B 86 0 670 805 ;\r\nC -1 ; WX 600 ; N Zcaron ; B 86 0 642 802 ;\r\nC -1 ; WX 600 ; N greaterequal ; B 98 0 594 710 ;\r\nC -1 ; WX 600 ; N Eth ; B 43 0 645 562 ;\r\nC -1 ; WX 600 ; N Ccedilla ; B 93 -151 658 580 ;\r\nC -1 ; WX 600 ; N lcommaaccent ; B 95 -250 515 629 ;\r\nC -1 ; WX 600 ; N tcaron ; B 167 -15 587 717 ;\r\nC -1 ; WX 600 ; N eogonek ; B 106 -172 598 441 ;\r\nC -1 ; WX 600 ; N Uogonek ; B 124 -172 702 562 ;\r\nC -1 ; WX 600 ; N Aacute ; B 3 0 660 805 ;\r\nC -1 ; WX 600 ; N Adieresis ; B 3 0 607 753 ;\r\nC -1 ; WX 600 ; N egrave ; B 106 -15 598 672 ;\r\nC -1 ; WX 600 ; N zacute ; B 99 0 612 672 ;\r\nC -1 ; WX 600 ; N iogonek ; B 95 -172 515 657 ;\r\nC -1 ; WX 600 ; N Oacute ; B 94 -18 640 805 ;\r\nC -1 ; WX 600 ; N oacute ; B 102 -15 612 672 ;\r\nC -1 ; WX 600 ; N amacron ; B 76 -15 600 565 ;\r\nC -1 ; WX 600 ; N sacute ; B 78 -15 612 672 ;\r\nC -1 ; WX 600 ; N idieresis ; B 95 0 545 620 ;\r\nC -1 ; WX 600 ; N Ocircumflex ; B 94 -18 625 787 ;\r\nC -1 ; WX 600 ; N Ugrave ; B 125 -18 702 805 ;\r\nC -1 ; WX 600 ; N Delta ; B 6 0 598 688 ;\r\nC -1 ; WX 600 ; N thorn ; B -24 -157 605 629 ;\r\nC -1 ; WX 600 ; N twosuperior ; B 230 249 535 622 ;\r\nC -1 ; WX 600 ; N Odieresis ; B 94 -18 625 753 ;\r\nC -1 ; WX 600 ; N mu ; B 72 -157 572 426 ;\r\nC -1 ; WX 600 ; N igrave ; B 95 0 515 672 ;\r\nC -1 ; WX 600 ; N ohungarumlaut ; B 102 -15 723 672 ;\r\nC -1 ; WX 600 ; N Eogonek ; B 53 -172 660 562 ;\r\nC -1 ; WX 600 ; N dcroat ; B 85 -15 704 629 ;\r\nC -1 ; WX 600 ; N threequarters ; B 73 -56 659 666 ;\r\nC -1 ; WX 600 ; N Scedilla ; B 76 -151 650 580 ;\r\nC -1 ; WX 600 ; N lcaron ; B 95 0 667 629 ;\r\nC -1 ; WX 600 ; N Kcommaaccent ; B 38 -250 671 562 ;\r\nC -1 ; WX 600 ; N Lacute ; B 47 0 607 805 ;\r\nC -1 ; WX 600 ; N trademark ; B 75 263 742 562 ;\r\nC -1 ; WX 600 ; N edotaccent ; B 106 -15 598 620 ;\r\nC -1 ; WX 600 ; N Igrave ; B 96 0 623 805 ;\r\nC -1 ; WX 600 ; N Imacron ; B 96 0 628 698 ;\r\nC -1 ; WX 600 ; N Lcaron ; B 47 0 632 562 ;\r\nC -1 ; WX 600 ; N onehalf ; B 65 -57 669 665 ;\r\nC -1 ; WX 600 ; N lessequal ; B 98 0 645 710 ;\r\nC -1 ; WX 600 ; N ocircumflex ; B 102 -15 588 654 ;\r\nC -1 ; WX 600 ; N ntilde ; B 26 0 629 606 ;\r\nC -1 ; WX 600 ; N Uhungarumlaut ; B 125 -18 761 805 ;\r\nC -1 ; WX 600 ; N Eacute ; B 53 0 670 805 ;\r\nC -1 ; WX 600 ; N emacron ; B 106 -15 600 565 ;\r\nC -1 ; WX 600 ; N gbreve ; B 61 -157 657 609 ;\r\nC -1 ; WX 600 ; N onequarter ; B 65 -57 674 665 ;\r\nC -1 ; WX 600 ; N Scaron ; B 76 -20 672 802 ;\r\nC -1 ; WX 600 ; N Scommaaccent ; B 76 -250 650 580 ;\r\nC -1 ; WX 600 ; N Ohungarumlaut ; B 94 -18 751 805 ;\r\nC -1 ; WX 600 ; N degree ; B 214 269 576 622 ;\r\nC -1 ; WX 600 ; N ograve ; B 102 -15 588 672 ;\r\nC -1 ; WX 600 ; N Ccaron ; B 93 -18 672 802 ;\r\nC -1 ; WX 600 ; N ugrave ; B 101 -15 572 672 ;\r\nC -1 ; WX 600 ; N radical ; B 85 -15 765 792 ;\r\nC -1 ; WX 600 ; N Dcaron ; B 43 0 645 802 ;\r\nC -1 ; WX 600 ; N rcommaaccent ; B 60 -250 636 441 ;\r\nC -1 ; WX 600 ; N Ntilde ; B 7 -13 712 729 ;\r\nC -1 ; WX 600 ; N otilde ; B 102 -15 629 606 ;\r\nC -1 ; WX 600 ; N Rcommaaccent ; B 38 -250 598 562 ;\r\nC -1 ; WX 600 ; N Lcommaaccent ; B 47 -250 607 562 ;\r\nC -1 ; WX 600 ; N Atilde ; B 3 0 655 729 ;\r\nC -1 ; WX 600 ; N Aogonek ; B 3 -172 607 562 ;\r\nC -1 ; WX 600 ; N Aring ; B 3 0 607 750 ;\r\nC -1 ; WX 600 ; N Otilde ; B 94 -18 655 729 ;\r\nC -1 ; WX 600 ; N zdotaccent ; B 99 0 593 620 ;\r\nC -1 ; WX 600 ; N Ecaron ; B 53 0 660 802 ;\r\nC -1 ; WX 600 ; N Iogonek ; B 96 -172 623 562 ;\r\nC -1 ; WX 600 ; N kcommaaccent ; B 58 -250 633 629 ;\r\nC -1 ; WX 600 ; N minus ; B 129 232 580 283 ;\r\nC -1 ; WX 600 ; N Icircumflex ; B 96 0 623 787 ;\r\nC -1 ; WX 600 ; N ncaron ; B 26 0 614 669 ;\r\nC -1 ; WX 600 ; N tcommaaccent ; B 165 -250 561 561 ;\r\nC -1 ; WX 600 ; N logicalnot ; B 155 108 591 369 ;\r\nC -1 ; WX 600 ; N odieresis ; B 102 -15 588 620 ;\r\nC -1 ; WX 600 ; N udieresis ; B 101 -15 575 620 ;\r\nC -1 ; WX 600 ; N notequal ; B 43 -16 621 529 ;\r\nC -1 ; WX 600 ; N gcommaaccent ; B 61 -157 657 708 ;\r\nC -1 ; WX 600 ; N eth ; B 102 -15 639 629 ;\r\nC -1 ; WX 600 ; N zcaron ; B 99 0 624 669 ;\r\nC -1 ; WX 600 ; N ncommaaccent ; B 26 -250 585 441 ;\r\nC -1 ; WX 600 ; N onesuperior ; B 231 249 491 622 ;\r\nC -1 ; WX 600 ; N imacron ; B 95 0 543 565 ;\r\nC -1 ; WX 600 ; N Euro ; B 0 0 0 0 ;\r\nEndCharMetrics\r\nEndFontMetrics\r\n";
  },
  'Courier-BoldOblique'() {
    return "StartFontMetrics 4.1\r\nComment Copyright (c) 1989, 1990, 1991, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.\r\nComment Creation Date: Mon Jun 23 16:28:46 1997\r\nComment UniqueID 43049\r\nComment VMusage 17529 79244\r\nFontName Courier-BoldOblique\r\nFullName Courier Bold Oblique\r\nFamilyName Courier\r\nWeight Bold\r\nItalicAngle -12\r\nIsFixedPitch true\r\nCharacterSet ExtendedRoman\r\nFontBBox -57 -250 869 801 \r\nUnderlinePosition -100\r\nUnderlineThickness 50\r\nVersion 003.000\r\nNotice Copyright (c) 1989, 1990, 1991, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.\r\nEncodingScheme AdobeStandardEncoding\r\nCapHeight 562\r\nXHeight 439\r\nAscender 629\r\nDescender -157\r\nStdHW 84\r\nStdVW 106\r\nStartCharMetrics 315\r\nC 32 ; WX 600 ; N space ; B 0 0 0 0 ;\r\nC 33 ; WX 600 ; N exclam ; B 215 -15 495 572 ;\r\nC 34 ; WX 600 ; N quotedbl ; B 211 277 585 562 ;\r\nC 35 ; WX 600 ; N numbersign ; B 88 -45 641 651 ;\r\nC 36 ; WX 600 ; N dollar ; B 87 -126 630 666 ;\r\nC 37 ; WX 600 ; N percent ; B 101 -15 625 616 ;\r\nC 38 ; WX 600 ; N ampersand ; B 61 -15 595 543 ;\r\nC 39 ; WX 600 ; N quoteright ; B 229 277 543 562 ;\r\nC 40 ; WX 600 ; N parenleft ; B 265 -102 592 616 ;\r\nC 41 ; WX 600 ; N parenright ; B 117 -102 444 616 ;\r\nC 42 ; WX 600 ; N asterisk ; B 179 219 598 601 ;\r\nC 43 ; WX 600 ; N plus ; B 114 39 596 478 ;\r\nC 44 ; WX 600 ; N comma ; B 99 -111 430 174 ;\r\nC 45 ; WX 600 ; N hyphen ; B 143 203 567 313 ;\r\nC 46 ; WX 600 ; N period ; B 206 -15 427 171 ;\r\nC 47 ; WX 600 ; N slash ; B 90 -77 626 626 ;\r\nC 48 ; WX 600 ; N zero ; B 135 -15 593 616 ;\r\nC 49 ; WX 600 ; N one ; B 93 0 562 616 ;\r\nC 50 ; WX 600 ; N two ; B 61 0 594 616 ;\r\nC 51 ; WX 600 ; N three ; B 71 -15 571 616 ;\r\nC 52 ; WX 600 ; N four ; B 81 0 559 616 ;\r\nC 53 ; WX 600 ; N five ; B 77 -15 621 601 ;\r\nC 54 ; WX 600 ; N six ; B 135 -15 652 616 ;\r\nC 55 ; WX 600 ; N seven ; B 147 0 622 601 ;\r\nC 56 ; WX 600 ; N eight ; B 115 -15 604 616 ;\r\nC 57 ; WX 600 ; N nine ; B 75 -15 592 616 ;\r\nC 58 ; WX 600 ; N colon ; B 205 -15 480 425 ;\r\nC 59 ; WX 600 ; N semicolon ; B 99 -111 481 425 ;\r\nC 60 ; WX 600 ; N less ; B 120 15 613 501 ;\r\nC 61 ; WX 600 ; N equal ; B 96 118 614 398 ;\r\nC 62 ; WX 600 ; N greater ; B 97 15 589 501 ;\r\nC 63 ; WX 600 ; N question ; B 183 -14 592 580 ;\r\nC 64 ; WX 600 ; N at ; B 65 -15 642 616 ;\r\nC 65 ; WX 600 ; N A ; B -9 0 632 562 ;\r\nC 66 ; WX 600 ; N B ; B 30 0 630 562 ;\r\nC 67 ; WX 600 ; N C ; B 74 -18 675 580 ;\r\nC 68 ; WX 600 ; N D ; B 30 0 664 562 ;\r\nC 69 ; WX 600 ; N E ; B 25 0 670 562 ;\r\nC 70 ; WX 600 ; N F ; B 39 0 684 562 ;\r\nC 71 ; WX 600 ; N G ; B 74 -18 675 580 ;\r\nC 72 ; WX 600 ; N H ; B 20 0 700 562 ;\r\nC 73 ; WX 600 ; N I ; B 77 0 643 562 ;\r\nC 74 ; WX 600 ; N J ; B 58 -18 721 562 ;\r\nC 75 ; WX 600 ; N K ; B 21 0 692 562 ;\r\nC 76 ; WX 600 ; N L ; B 39 0 636 562 ;\r\nC 77 ; WX 600 ; N M ; B -2 0 722 562 ;\r\nC 78 ; WX 600 ; N N ; B 8 -12 730 562 ;\r\nC 79 ; WX 600 ; N O ; B 74 -18 645 580 ;\r\nC 80 ; WX 600 ; N P ; B 48 0 643 562 ;\r\nC 81 ; WX 600 ; N Q ; B 83 -138 636 580 ;\r\nC 82 ; WX 600 ; N R ; B 24 0 617 562 ;\r\nC 83 ; WX 600 ; N S ; B 54 -22 673 582 ;\r\nC 84 ; WX 600 ; N T ; B 86 0 679 562 ;\r\nC 85 ; WX 600 ; N U ; B 101 -18 716 562 ;\r\nC 86 ; WX 600 ; N V ; B 84 0 733 562 ;\r\nC 87 ; WX 600 ; N W ; B 79 0 738 562 ;\r\nC 88 ; WX 600 ; N X ; B 12 0 690 562 ;\r\nC 89 ; WX 600 ; N Y ; B 109 0 709 562 ;\r\nC 90 ; WX 600 ; N Z ; B 62 0 637 562 ;\r\nC 91 ; WX 600 ; N bracketleft ; B 223 -102 606 616 ;\r\nC 92 ; WX 600 ; N backslash ; B 222 -77 496 626 ;\r\nC 93 ; WX 600 ; N bracketright ; B 103 -102 486 616 ;\r\nC 94 ; WX 600 ; N asciicircum ; B 171 250 556 616 ;\r\nC 95 ; WX 600 ; N underscore ; B -27 -125 585 -75 ;\r\nC 96 ; WX 600 ; N quoteleft ; B 297 277 487 562 ;\r\nC 97 ; WX 600 ; N a ; B 61 -15 593 454 ;\r\nC 98 ; WX 600 ; N b ; B 13 -15 636 626 ;\r\nC 99 ; WX 600 ; N c ; B 81 -15 631 459 ;\r\nC 100 ; WX 600 ; N d ; B 60 -15 645 626 ;\r\nC 101 ; WX 600 ; N e ; B 81 -15 605 454 ;\r\nC 102 ; WX 600 ; N f ; B 83 0 677 626 ; L i fi ; L l fl ;\r\nC 103 ; WX 600 ; N g ; B 40 -146 674 454 ;\r\nC 104 ; WX 600 ; N h ; B 18 0 615 626 ;\r\nC 105 ; WX 600 ; N i ; B 77 0 546 658 ;\r\nC 106 ; WX 600 ; N j ; B 36 -146 580 658 ;\r\nC 107 ; WX 600 ; N k ; B 33 0 643 626 ;\r\nC 108 ; WX 600 ; N l ; B 77 0 546 626 ;\r\nC 109 ; WX 600 ; N m ; B -22 0 649 454 ;\r\nC 110 ; WX 600 ; N n ; B 18 0 615 454 ;\r\nC 111 ; WX 600 ; N o ; B 71 -15 622 454 ;\r\nC 112 ; WX 600 ; N p ; B -32 -142 622 454 ;\r\nC 113 ; WX 600 ; N q ; B 60 -142 685 454 ;\r\nC 114 ; WX 600 ; N r ; B 47 0 655 454 ;\r\nC 115 ; WX 600 ; N s ; B 66 -17 608 459 ;\r\nC 116 ; WX 600 ; N t ; B 118 -15 567 562 ;\r\nC 117 ; WX 600 ; N u ; B 70 -15 592 439 ;\r\nC 118 ; WX 600 ; N v ; B 70 0 695 439 ;\r\nC 119 ; WX 600 ; N w ; B 53 0 712 439 ;\r\nC 120 ; WX 600 ; N x ; B 6 0 671 439 ;\r\nC 121 ; WX 600 ; N y ; B -21 -142 695 439 ;\r\nC 122 ; WX 600 ; N z ; B 81 0 614 439 ;\r\nC 123 ; WX 600 ; N braceleft ; B 203 -102 595 616 ;\r\nC 124 ; WX 600 ; N bar ; B 201 -250 505 750 ;\r\nC 125 ; WX 600 ; N braceright ; B 114 -102 506 616 ;\r\nC 126 ; WX 600 ; N asciitilde ; B 120 153 590 356 ;\r\nC 161 ; WX 600 ; N exclamdown ; B 196 -146 477 449 ;\r\nC 162 ; WX 600 ; N cent ; B 121 -49 605 614 ;\r\nC 163 ; WX 600 ; N sterling ; B 106 -28 650 611 ;\r\nC 164 ; WX 600 ; N fraction ; B 22 -60 708 661 ;\r\nC 165 ; WX 600 ; N yen ; B 98 0 710 562 ;\r\nC 166 ; WX 600 ; N florin ; B -57 -131 702 616 ;\r\nC 167 ; WX 600 ; N section ; B 74 -70 620 580 ;\r\nC 168 ; WX 600 ; N currency ; B 77 49 644 517 ;\r\nC 169 ; WX 600 ; N quotesingle ; B 303 277 493 562 ;\r\nC 170 ; WX 600 ; N quotedblleft ; B 190 277 594 562 ;\r\nC 171 ; WX 600 ; N guillemotleft ; B 62 70 639 446 ;\r\nC 172 ; WX 600 ; N guilsinglleft ; B 195 70 545 446 ;\r\nC 173 ; WX 600 ; N guilsinglright ; B 165 70 514 446 ;\r\nC 174 ; WX 600 ; N fi ; B 12 0 644 626 ;\r\nC 175 ; WX 600 ; N fl ; B 12 0 644 626 ;\r\nC 177 ; WX 600 ; N endash ; B 108 203 602 313 ;\r\nC 178 ; WX 600 ; N dagger ; B 175 -70 586 580 ;\r\nC 179 ; WX 600 ; N daggerdbl ; B 121 -70 587 580 ;\r\nC 180 ; WX 600 ; N periodcentered ; B 248 165 461 351 ;\r\nC 182 ; WX 600 ; N paragraph ; B 61 -70 700 580 ;\r\nC 183 ; WX 600 ; N bullet ; B 196 132 523 430 ;\r\nC 184 ; WX 600 ; N quotesinglbase ; B 144 -142 458 143 ;\r\nC 185 ; WX 600 ; N quotedblbase ; B 34 -142 560 143 ;\r\nC 186 ; WX 600 ; N quotedblright ; B 119 277 645 562 ;\r\nC 187 ; WX 600 ; N guillemotright ; B 71 70 647 446 ;\r\nC 188 ; WX 600 ; N ellipsis ; B 35 -15 587 116 ;\r\nC 189 ; WX 600 ; N perthousand ; B -45 -15 743 616 ;\r\nC 191 ; WX 600 ; N questiondown ; B 100 -146 509 449 ;\r\nC 193 ; WX 600 ; N grave ; B 272 508 503 661 ;\r\nC 194 ; WX 600 ; N acute ; B 312 508 609 661 ;\r\nC 195 ; WX 600 ; N circumflex ; B 212 483 607 657 ;\r\nC 196 ; WX 600 ; N tilde ; B 199 493 643 636 ;\r\nC 197 ; WX 600 ; N macron ; B 195 505 637 585 ;\r\nC 198 ; WX 600 ; N breve ; B 217 468 652 631 ;\r\nC 199 ; WX 600 ; N dotaccent ; B 348 498 493 638 ;\r\nC 200 ; WX 600 ; N dieresis ; B 246 498 595 638 ;\r\nC 202 ; WX 600 ; N ring ; B 319 481 528 678 ;\r\nC 203 ; WX 600 ; N cedilla ; B 168 -206 368 0 ;\r\nC 205 ; WX 600 ; N hungarumlaut ; B 171 488 729 661 ;\r\nC 206 ; WX 600 ; N ogonek ; B 143 -199 367 0 ;\r\nC 207 ; WX 600 ; N caron ; B 238 493 633 667 ;\r\nC 208 ; WX 600 ; N emdash ; B 33 203 677 313 ;\r\nC 225 ; WX 600 ; N AE ; B -29 0 708 562 ;\r\nC 227 ; WX 600 ; N ordfeminine ; B 188 196 526 580 ;\r\nC 232 ; WX 600 ; N Lslash ; B 39 0 636 562 ;\r\nC 233 ; WX 600 ; N Oslash ; B 48 -22 673 584 ;\r\nC 234 ; WX 600 ; N OE ; B 26 0 701 562 ;\r\nC 235 ; WX 600 ; N ordmasculine ; B 188 196 543 580 ;\r\nC 241 ; WX 600 ; N ae ; B 21 -15 652 454 ;\r\nC 245 ; WX 600 ; N dotlessi ; B 77 0 546 439 ;\r\nC 248 ; WX 600 ; N lslash ; B 77 0 587 626 ;\r\nC 249 ; WX 600 ; N oslash ; B 54 -24 638 463 ;\r\nC 250 ; WX 600 ; N oe ; B 18 -15 662 454 ;\r\nC 251 ; WX 600 ; N germandbls ; B 22 -15 629 626 ;\r\nC -1 ; WX 600 ; N Idieresis ; B 77 0 643 761 ;\r\nC -1 ; WX 600 ; N eacute ; B 81 -15 609 661 ;\r\nC -1 ; WX 600 ; N abreve ; B 61 -15 658 661 ;\r\nC -1 ; WX 600 ; N uhungarumlaut ; B 70 -15 769 661 ;\r\nC -1 ; WX 600 ; N ecaron ; B 81 -15 633 667 ;\r\nC -1 ; WX 600 ; N Ydieresis ; B 109 0 709 761 ;\r\nC -1 ; WX 600 ; N divide ; B 114 16 596 500 ;\r\nC -1 ; WX 600 ; N Yacute ; B 109 0 709 784 ;\r\nC -1 ; WX 600 ; N Acircumflex ; B -9 0 632 780 ;\r\nC -1 ; WX 600 ; N aacute ; B 61 -15 609 661 ;\r\nC -1 ; WX 600 ; N Ucircumflex ; B 101 -18 716 780 ;\r\nC -1 ; WX 600 ; N yacute ; B -21 -142 695 661 ;\r\nC -1 ; WX 600 ; N scommaaccent ; B 66 -250 608 459 ;\r\nC -1 ; WX 600 ; N ecircumflex ; B 81 -15 607 657 ;\r\nC -1 ; WX 600 ; N Uring ; B 101 -18 716 801 ;\r\nC -1 ; WX 600 ; N Udieresis ; B 101 -18 716 761 ;\r\nC -1 ; WX 600 ; N aogonek ; B 61 -199 593 454 ;\r\nC -1 ; WX 600 ; N Uacute ; B 101 -18 716 784 ;\r\nC -1 ; WX 600 ; N uogonek ; B 70 -199 592 439 ;\r\nC -1 ; WX 600 ; N Edieresis ; B 25 0 670 761 ;\r\nC -1 ; WX 600 ; N Dcroat ; B 30 0 664 562 ;\r\nC -1 ; WX 600 ; N commaaccent ; B 151 -250 385 -57 ;\r\nC -1 ; WX 600 ; N copyright ; B 53 -18 667 580 ;\r\nC -1 ; WX 600 ; N Emacron ; B 25 0 670 708 ;\r\nC -1 ; WX 600 ; N ccaron ; B 81 -15 633 667 ;\r\nC -1 ; WX 600 ; N aring ; B 61 -15 593 678 ;\r\nC -1 ; WX 600 ; N Ncommaaccent ; B 8 -250 730 562 ;\r\nC -1 ; WX 600 ; N lacute ; B 77 0 639 801 ;\r\nC -1 ; WX 600 ; N agrave ; B 61 -15 593 661 ;\r\nC -1 ; WX 600 ; N Tcommaaccent ; B 86 -250 679 562 ;\r\nC -1 ; WX 600 ; N Cacute ; B 74 -18 675 784 ;\r\nC -1 ; WX 600 ; N atilde ; B 61 -15 643 636 ;\r\nC -1 ; WX 600 ; N Edotaccent ; B 25 0 670 761 ;\r\nC -1 ; WX 600 ; N scaron ; B 66 -17 633 667 ;\r\nC -1 ; WX 600 ; N scedilla ; B 66 -206 608 459 ;\r\nC -1 ; WX 600 ; N iacute ; B 77 0 609 661 ;\r\nC -1 ; WX 600 ; N lozenge ; B 145 0 614 740 ;\r\nC -1 ; WX 600 ; N Rcaron ; B 24 0 659 790 ;\r\nC -1 ; WX 600 ; N Gcommaaccent ; B 74 -250 675 580 ;\r\nC -1 ; WX 600 ; N ucircumflex ; B 70 -15 597 657 ;\r\nC -1 ; WX 600 ; N acircumflex ; B 61 -15 607 657 ;\r\nC -1 ; WX 600 ; N Amacron ; B -9 0 633 708 ;\r\nC -1 ; WX 600 ; N rcaron ; B 47 0 655 667 ;\r\nC -1 ; WX 600 ; N ccedilla ; B 81 -206 631 459 ;\r\nC -1 ; WX 600 ; N Zdotaccent ; B 62 0 637 761 ;\r\nC -1 ; WX 600 ; N Thorn ; B 48 0 620 562 ;\r\nC -1 ; WX 600 ; N Omacron ; B 74 -18 663 708 ;\r\nC -1 ; WX 600 ; N Racute ; B 24 0 665 784 ;\r\nC -1 ; WX 600 ; N Sacute ; B 54 -22 673 784 ;\r\nC -1 ; WX 600 ; N dcaron ; B 60 -15 861 626 ;\r\nC -1 ; WX 600 ; N Umacron ; B 101 -18 716 708 ;\r\nC -1 ; WX 600 ; N uring ; B 70 -15 592 678 ;\r\nC -1 ; WX 600 ; N threesuperior ; B 193 222 526 616 ;\r\nC -1 ; WX 600 ; N Ograve ; B 74 -18 645 784 ;\r\nC -1 ; WX 600 ; N Agrave ; B -9 0 632 784 ;\r\nC -1 ; WX 600 ; N Abreve ; B -9 0 684 784 ;\r\nC -1 ; WX 600 ; N multiply ; B 104 39 606 478 ;\r\nC -1 ; WX 600 ; N uacute ; B 70 -15 599 661 ;\r\nC -1 ; WX 600 ; N Tcaron ; B 86 0 679 790 ;\r\nC -1 ; WX 600 ; N partialdiff ; B 91 -38 627 728 ;\r\nC -1 ; WX 600 ; N ydieresis ; B -21 -142 695 638 ;\r\nC -1 ; WX 600 ; N Nacute ; B 8 -12 730 784 ;\r\nC -1 ; WX 600 ; N icircumflex ; B 77 0 577 657 ;\r\nC -1 ; WX 600 ; N Ecircumflex ; B 25 0 670 780 ;\r\nC -1 ; WX 600 ; N adieresis ; B 61 -15 595 638 ;\r\nC -1 ; WX 600 ; N edieresis ; B 81 -15 605 638 ;\r\nC -1 ; WX 600 ; N cacute ; B 81 -15 649 661 ;\r\nC -1 ; WX 600 ; N nacute ; B 18 0 639 661 ;\r\nC -1 ; WX 600 ; N umacron ; B 70 -15 637 585 ;\r\nC -1 ; WX 600 ; N Ncaron ; B 8 -12 730 790 ;\r\nC -1 ; WX 600 ; N Iacute ; B 77 0 643 784 ;\r\nC -1 ; WX 600 ; N plusminus ; B 76 24 614 515 ;\r\nC -1 ; WX 600 ; N brokenbar ; B 217 -175 489 675 ;\r\nC -1 ; WX 600 ; N registered ; B 53 -18 667 580 ;\r\nC -1 ; WX 600 ; N Gbreve ; B 74 -18 684 784 ;\r\nC -1 ; WX 600 ; N Idotaccent ; B 77 0 643 761 ;\r\nC -1 ; WX 600 ; N summation ; B 15 -10 672 706 ;\r\nC -1 ; WX 600 ; N Egrave ; B 25 0 670 784 ;\r\nC -1 ; WX 600 ; N racute ; B 47 0 655 661 ;\r\nC -1 ; WX 600 ; N omacron ; B 71 -15 637 585 ;\r\nC -1 ; WX 600 ; N Zacute ; B 62 0 665 784 ;\r\nC -1 ; WX 600 ; N Zcaron ; B 62 0 659 790 ;\r\nC -1 ; WX 600 ; N greaterequal ; B 26 0 627 696 ;\r\nC -1 ; WX 600 ; N Eth ; B 30 0 664 562 ;\r\nC -1 ; WX 600 ; N Ccedilla ; B 74 -206 675 580 ;\r\nC -1 ; WX 600 ; N lcommaaccent ; B 77 -250 546 626 ;\r\nC -1 ; WX 600 ; N tcaron ; B 118 -15 627 703 ;\r\nC -1 ; WX 600 ; N eogonek ; B 81 -199 605 454 ;\r\nC -1 ; WX 600 ; N Uogonek ; B 101 -199 716 562 ;\r\nC -1 ; WX 600 ; N Aacute ; B -9 0 655 784 ;\r\nC -1 ; WX 600 ; N Adieresis ; B -9 0 632 761 ;\r\nC -1 ; WX 600 ; N egrave ; B 81 -15 605 661 ;\r\nC -1 ; WX 600 ; N zacute ; B 81 0 614 661 ;\r\nC -1 ; WX 600 ; N iogonek ; B 77 -199 546 658 ;\r\nC -1 ; WX 600 ; N Oacute ; B 74 -18 645 784 ;\r\nC -1 ; WX 600 ; N oacute ; B 71 -15 649 661 ;\r\nC -1 ; WX 600 ; N amacron ; B 61 -15 637 585 ;\r\nC -1 ; WX 600 ; N sacute ; B 66 -17 609 661 ;\r\nC -1 ; WX 600 ; N idieresis ; B 77 0 561 618 ;\r\nC -1 ; WX 600 ; N Ocircumflex ; B 74 -18 645 780 ;\r\nC -1 ; WX 600 ; N Ugrave ; B 101 -18 716 784 ;\r\nC -1 ; WX 600 ; N Delta ; B 6 0 594 688 ;\r\nC -1 ; WX 600 ; N thorn ; B -32 -142 622 626 ;\r\nC -1 ; WX 600 ; N twosuperior ; B 191 230 542 616 ;\r\nC -1 ; WX 600 ; N Odieresis ; B 74 -18 645 761 ;\r\nC -1 ; WX 600 ; N mu ; B 49 -142 592 439 ;\r\nC -1 ; WX 600 ; N igrave ; B 77 0 546 661 ;\r\nC -1 ; WX 600 ; N ohungarumlaut ; B 71 -15 809 661 ;\r\nC -1 ; WX 600 ; N Eogonek ; B 25 -199 670 562 ;\r\nC -1 ; WX 600 ; N dcroat ; B 60 -15 712 626 ;\r\nC -1 ; WX 600 ; N threequarters ; B 8 -60 699 661 ;\r\nC -1 ; WX 600 ; N Scedilla ; B 54 -206 673 582 ;\r\nC -1 ; WX 600 ; N lcaron ; B 77 0 731 626 ;\r\nC -1 ; WX 600 ; N Kcommaaccent ; B 21 -250 692 562 ;\r\nC -1 ; WX 600 ; N Lacute ; B 39 0 636 784 ;\r\nC -1 ; WX 600 ; N trademark ; B 86 230 869 562 ;\r\nC -1 ; WX 600 ; N edotaccent ; B 81 -15 605 638 ;\r\nC -1 ; WX 600 ; N Igrave ; B 77 0 643 784 ;\r\nC -1 ; WX 600 ; N Imacron ; B 77 0 663 708 ;\r\nC -1 ; WX 600 ; N Lcaron ; B 39 0 757 562 ;\r\nC -1 ; WX 600 ; N onehalf ; B 22 -60 716 661 ;\r\nC -1 ; WX 600 ; N lessequal ; B 26 0 671 696 ;\r\nC -1 ; WX 600 ; N ocircumflex ; B 71 -15 622 657 ;\r\nC -1 ; WX 600 ; N ntilde ; B 18 0 643 636 ;\r\nC -1 ; WX 600 ; N Uhungarumlaut ; B 101 -18 805 784 ;\r\nC -1 ; WX 600 ; N Eacute ; B 25 0 670 784 ;\r\nC -1 ; WX 600 ; N emacron ; B 81 -15 637 585 ;\r\nC -1 ; WX 600 ; N gbreve ; B 40 -146 674 661 ;\r\nC -1 ; WX 600 ; N onequarter ; B 13 -60 707 661 ;\r\nC -1 ; WX 600 ; N Scaron ; B 54 -22 689 790 ;\r\nC -1 ; WX 600 ; N Scommaaccent ; B 54 -250 673 582 ;\r\nC -1 ; WX 600 ; N Ohungarumlaut ; B 74 -18 795 784 ;\r\nC -1 ; WX 600 ; N degree ; B 173 243 570 616 ;\r\nC -1 ; WX 600 ; N ograve ; B 71 -15 622 661 ;\r\nC -1 ; WX 600 ; N Ccaron ; B 74 -18 689 790 ;\r\nC -1 ; WX 600 ; N ugrave ; B 70 -15 592 661 ;\r\nC -1 ; WX 600 ; N radical ; B 67 -104 635 778 ;\r\nC -1 ; WX 600 ; N Dcaron ; B 30 0 664 790 ;\r\nC -1 ; WX 600 ; N rcommaaccent ; B 47 -250 655 454 ;\r\nC -1 ; WX 600 ; N Ntilde ; B 8 -12 730 759 ;\r\nC -1 ; WX 600 ; N otilde ; B 71 -15 643 636 ;\r\nC -1 ; WX 600 ; N Rcommaaccent ; B 24 -250 617 562 ;\r\nC -1 ; WX 600 ; N Lcommaaccent ; B 39 -250 636 562 ;\r\nC -1 ; WX 600 ; N Atilde ; B -9 0 669 759 ;\r\nC -1 ; WX 600 ; N Aogonek ; B -9 -199 632 562 ;\r\nC -1 ; WX 600 ; N Aring ; B -9 0 632 801 ;\r\nC -1 ; WX 600 ; N Otilde ; B 74 -18 669 759 ;\r\nC -1 ; WX 600 ; N zdotaccent ; B 81 0 614 638 ;\r\nC -1 ; WX 600 ; N Ecaron ; B 25 0 670 790 ;\r\nC -1 ; WX 600 ; N Iogonek ; B 77 -199 643 562 ;\r\nC -1 ; WX 600 ; N kcommaaccent ; B 33 -250 643 626 ;\r\nC -1 ; WX 600 ; N minus ; B 114 203 596 313 ;\r\nC -1 ; WX 600 ; N Icircumflex ; B 77 0 643 780 ;\r\nC -1 ; WX 600 ; N ncaron ; B 18 0 633 667 ;\r\nC -1 ; WX 600 ; N tcommaaccent ; B 118 -250 567 562 ;\r\nC -1 ; WX 600 ; N logicalnot ; B 135 103 617 413 ;\r\nC -1 ; WX 600 ; N odieresis ; B 71 -15 622 638 ;\r\nC -1 ; WX 600 ; N udieresis ; B 70 -15 595 638 ;\r\nC -1 ; WX 600 ; N notequal ; B 30 -47 626 563 ;\r\nC -1 ; WX 600 ; N gcommaaccent ; B 40 -146 674 714 ;\r\nC -1 ; WX 600 ; N eth ; B 93 -27 661 626 ;\r\nC -1 ; WX 600 ; N zcaron ; B 81 0 643 667 ;\r\nC -1 ; WX 600 ; N ncommaaccent ; B 18 -250 615 454 ;\r\nC -1 ; WX 600 ; N onesuperior ; B 212 230 514 616 ;\r\nC -1 ; WX 600 ; N imacron ; B 77 0 575 585 ;\r\nC -1 ; WX 600 ; N Euro ; B 0 0 0 0 ;\r\nEndCharMetrics\r\nEndFontMetrics\r\n";
  },
  Helvetica() {
    return "StartFontMetrics 4.1\r\nComment Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.\r\nComment Creation Date: Thu May  1 12:38:23 1997\r\nComment UniqueID 43054\r\nComment VMusage 37069 48094\r\nFontName Helvetica\r\nFullName Helvetica\r\nFamilyName Helvetica\r\nWeight Medium\r\nItalicAngle 0\r\nIsFixedPitch false\r\nCharacterSet ExtendedRoman\r\nFontBBox -166 -225 1000 931 \r\nUnderlinePosition -100\r\nUnderlineThickness 50\r\nVersion 002.000\r\nNotice Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.Helvetica is a trademark of Linotype-Hell AG and/or its subsidiaries.\r\nEncodingScheme AdobeStandardEncoding\r\nCapHeight 718\r\nXHeight 523\r\nAscender 718\r\nDescender -207\r\nStdHW 76\r\nStdVW 88\r\nStartCharMetrics 315\r\nC 32 ; WX 278 ; N space ; B 0 0 0 0 ;\r\nC 33 ; WX 278 ; N exclam ; B 90 0 187 718 ;\r\nC 34 ; WX 355 ; N quotedbl ; B 70 463 285 718 ;\r\nC 35 ; WX 556 ; N numbersign ; B 28 0 529 688 ;\r\nC 36 ; WX 556 ; N dollar ; B 32 -115 520 775 ;\r\nC 37 ; WX 889 ; N percent ; B 39 -19 850 703 ;\r\nC 38 ; WX 667 ; N ampersand ; B 44 -15 645 718 ;\r\nC 39 ; WX 222 ; N quoteright ; B 53 463 157 718 ;\r\nC 40 ; WX 333 ; N parenleft ; B 68 -207 299 733 ;\r\nC 41 ; WX 333 ; N parenright ; B 34 -207 265 733 ;\r\nC 42 ; WX 389 ; N asterisk ; B 39 431 349 718 ;\r\nC 43 ; WX 584 ; N plus ; B 39 0 545 505 ;\r\nC 44 ; WX 278 ; N comma ; B 87 -147 191 106 ;\r\nC 45 ; WX 333 ; N hyphen ; B 44 232 289 322 ;\r\nC 46 ; WX 278 ; N period ; B 87 0 191 106 ;\r\nC 47 ; WX 278 ; N slash ; B -17 -19 295 737 ;\r\nC 48 ; WX 556 ; N zero ; B 37 -19 519 703 ;\r\nC 49 ; WX 556 ; N one ; B 101 0 359 703 ;\r\nC 50 ; WX 556 ; N two ; B 26 0 507 703 ;\r\nC 51 ; WX 556 ; N three ; B 34 -19 522 703 ;\r\nC 52 ; WX 556 ; N four ; B 25 0 523 703 ;\r\nC 53 ; WX 556 ; N five ; B 32 -19 514 688 ;\r\nC 54 ; WX 556 ; N six ; B 38 -19 518 703 ;\r\nC 55 ; WX 556 ; N seven ; B 37 0 523 688 ;\r\nC 56 ; WX 556 ; N eight ; B 38 -19 517 703 ;\r\nC 57 ; WX 556 ; N nine ; B 42 -19 514 703 ;\r\nC 58 ; WX 278 ; N colon ; B 87 0 191 516 ;\r\nC 59 ; WX 278 ; N semicolon ; B 87 -147 191 516 ;\r\nC 60 ; WX 584 ; N less ; B 48 11 536 495 ;\r\nC 61 ; WX 584 ; N equal ; B 39 115 545 390 ;\r\nC 62 ; WX 584 ; N greater ; B 48 11 536 495 ;\r\nC 63 ; WX 556 ; N question ; B 56 0 492 727 ;\r\nC 64 ; WX 1015 ; N at ; B 147 -19 868 737 ;\r\nC 65 ; WX 667 ; N A ; B 14 0 654 718 ;\r\nC 66 ; WX 667 ; N B ; B 74 0 627 718 ;\r\nC 67 ; WX 722 ; N C ; B 44 -19 681 737 ;\r\nC 68 ; WX 722 ; N D ; B 81 0 674 718 ;\r\nC 69 ; WX 667 ; N E ; B 86 0 616 718 ;\r\nC 70 ; WX 611 ; N F ; B 86 0 583 718 ;\r\nC 71 ; WX 778 ; N G ; B 48 -19 704 737 ;\r\nC 72 ; WX 722 ; N H ; B 77 0 646 718 ;\r\nC 73 ; WX 278 ; N I ; B 91 0 188 718 ;\r\nC 74 ; WX 500 ; N J ; B 17 -19 428 718 ;\r\nC 75 ; WX 667 ; N K ; B 76 0 663 718 ;\r\nC 76 ; WX 556 ; N L ; B 76 0 537 718 ;\r\nC 77 ; WX 833 ; N M ; B 73 0 761 718 ;\r\nC 78 ; WX 722 ; N N ; B 76 0 646 718 ;\r\nC 79 ; WX 778 ; N O ; B 39 -19 739 737 ;\r\nC 80 ; WX 667 ; N P ; B 86 0 622 718 ;\r\nC 81 ; WX 778 ; N Q ; B 39 -56 739 737 ;\r\nC 82 ; WX 722 ; N R ; B 88 0 684 718 ;\r\nC 83 ; WX 667 ; N S ; B 49 -19 620 737 ;\r\nC 84 ; WX 611 ; N T ; B 14 0 597 718 ;\r\nC 85 ; WX 722 ; N U ; B 79 -19 644 718 ;\r\nC 86 ; WX 667 ; N V ; B 20 0 647 718 ;\r\nC 87 ; WX 944 ; N W ; B 16 0 928 718 ;\r\nC 88 ; WX 667 ; N X ; B 19 0 648 718 ;\r\nC 89 ; WX 667 ; N Y ; B 14 0 653 718 ;\r\nC 90 ; WX 611 ; N Z ; B 23 0 588 718 ;\r\nC 91 ; WX 278 ; N bracketleft ; B 63 -196 250 722 ;\r\nC 92 ; WX 278 ; N backslash ; B -17 -19 295 737 ;\r\nC 93 ; WX 278 ; N bracketright ; B 28 -196 215 722 ;\r\nC 94 ; WX 469 ; N asciicircum ; B -14 264 483 688 ;\r\nC 95 ; WX 556 ; N underscore ; B 0 -125 556 -75 ;\r\nC 96 ; WX 222 ; N quoteleft ; B 65 470 169 725 ;\r\nC 97 ; WX 556 ; N a ; B 36 -15 530 538 ;\r\nC 98 ; WX 556 ; N b ; B 58 -15 517 718 ;\r\nC 99 ; WX 500 ; N c ; B 30 -15 477 538 ;\r\nC 100 ; WX 556 ; N d ; B 35 -15 499 718 ;\r\nC 101 ; WX 556 ; N e ; B 40 -15 516 538 ;\r\nC 102 ; WX 278 ; N f ; B 14 0 262 728 ; L i fi ; L l fl ;\r\nC 103 ; WX 556 ; N g ; B 40 -220 499 538 ;\r\nC 104 ; WX 556 ; N h ; B 65 0 491 718 ;\r\nC 105 ; WX 222 ; N i ; B 67 0 155 718 ;\r\nC 106 ; WX 222 ; N j ; B -16 -210 155 718 ;\r\nC 107 ; WX 500 ; N k ; B 67 0 501 718 ;\r\nC 108 ; WX 222 ; N l ; B 67 0 155 718 ;\r\nC 109 ; WX 833 ; N m ; B 65 0 769 538 ;\r\nC 110 ; WX 556 ; N n ; B 65 0 491 538 ;\r\nC 111 ; WX 556 ; N o ; B 35 -14 521 538 ;\r\nC 112 ; WX 556 ; N p ; B 58 -207 517 538 ;\r\nC 113 ; WX 556 ; N q ; B 35 -207 494 538 ;\r\nC 114 ; WX 333 ; N r ; B 77 0 332 538 ;\r\nC 115 ; WX 500 ; N s ; B 32 -15 464 538 ;\r\nC 116 ; WX 278 ; N t ; B 14 -7 257 669 ;\r\nC 117 ; WX 556 ; N u ; B 68 -15 489 523 ;\r\nC 118 ; WX 500 ; N v ; B 8 0 492 523 ;\r\nC 119 ; WX 722 ; N w ; B 14 0 709 523 ;\r\nC 120 ; WX 500 ; N x ; B 11 0 490 523 ;\r\nC 121 ; WX 500 ; N y ; B 11 -214 489 523 ;\r\nC 122 ; WX 500 ; N z ; B 31 0 469 523 ;\r\nC 123 ; WX 334 ; N braceleft ; B 42 -196 292 722 ;\r\nC 124 ; WX 260 ; N bar ; B 94 -225 167 775 ;\r\nC 125 ; WX 334 ; N braceright ; B 42 -196 292 722 ;\r\nC 126 ; WX 584 ; N asciitilde ; B 61 180 523 326 ;\r\nC 161 ; WX 333 ; N exclamdown ; B 118 -195 215 523 ;\r\nC 162 ; WX 556 ; N cent ; B 51 -115 513 623 ;\r\nC 163 ; WX 556 ; N sterling ; B 33 -16 539 718 ;\r\nC 164 ; WX 167 ; N fraction ; B -166 -19 333 703 ;\r\nC 165 ; WX 556 ; N yen ; B 3 0 553 688 ;\r\nC 166 ; WX 556 ; N florin ; B -11 -207 501 737 ;\r\nC 167 ; WX 556 ; N section ; B 43 -191 512 737 ;\r\nC 168 ; WX 556 ; N currency ; B 28 99 528 603 ;\r\nC 169 ; WX 191 ; N quotesingle ; B 59 463 132 718 ;\r\nC 170 ; WX 333 ; N quotedblleft ; B 38 470 307 725 ;\r\nC 171 ; WX 556 ; N guillemotleft ; B 97 108 459 446 ;\r\nC 172 ; WX 333 ; N guilsinglleft ; B 88 108 245 446 ;\r\nC 173 ; WX 333 ; N guilsinglright ; B 88 108 245 446 ;\r\nC 174 ; WX 500 ; N fi ; B 14 0 434 728 ;\r\nC 175 ; WX 500 ; N fl ; B 14 0 432 728 ;\r\nC 177 ; WX 556 ; N endash ; B 0 240 556 313 ;\r\nC 178 ; WX 556 ; N dagger ; B 43 -159 514 718 ;\r\nC 179 ; WX 556 ; N daggerdbl ; B 43 -159 514 718 ;\r\nC 180 ; WX 278 ; N periodcentered ; B 77 190 202 315 ;\r\nC 182 ; WX 537 ; N paragraph ; B 18 -173 497 718 ;\r\nC 183 ; WX 350 ; N bullet ; B 18 202 333 517 ;\r\nC 184 ; WX 222 ; N quotesinglbase ; B 53 -149 157 106 ;\r\nC 185 ; WX 333 ; N quotedblbase ; B 26 -149 295 106 ;\r\nC 186 ; WX 333 ; N quotedblright ; B 26 463 295 718 ;\r\nC 187 ; WX 556 ; N guillemotright ; B 97 108 459 446 ;\r\nC 188 ; WX 1000 ; N ellipsis ; B 115 0 885 106 ;\r\nC 189 ; WX 1000 ; N perthousand ; B 7 -19 994 703 ;\r\nC 191 ; WX 611 ; N questiondown ; B 91 -201 527 525 ;\r\nC 193 ; WX 333 ; N grave ; B 14 593 211 734 ;\r\nC 194 ; WX 333 ; N acute ; B 122 593 319 734 ;\r\nC 195 ; WX 333 ; N circumflex ; B 21 593 312 734 ;\r\nC 196 ; WX 333 ; N tilde ; B -4 606 337 722 ;\r\nC 197 ; WX 333 ; N macron ; B 10 627 323 684 ;\r\nC 198 ; WX 333 ; N breve ; B 13 595 321 731 ;\r\nC 199 ; WX 333 ; N dotaccent ; B 121 604 212 706 ;\r\nC 200 ; WX 333 ; N dieresis ; B 40 604 293 706 ;\r\nC 202 ; WX 333 ; N ring ; B 75 572 259 756 ;\r\nC 203 ; WX 333 ; N cedilla ; B 45 -225 259 0 ;\r\nC 205 ; WX 333 ; N hungarumlaut ; B 31 593 409 734 ;\r\nC 206 ; WX 333 ; N ogonek ; B 73 -225 287 0 ;\r\nC 207 ; WX 333 ; N caron ; B 21 593 312 734 ;\r\nC 208 ; WX 1000 ; N emdash ; B 0 240 1000 313 ;\r\nC 225 ; WX 1000 ; N AE ; B 8 0 951 718 ;\r\nC 227 ; WX 370 ; N ordfeminine ; B 24 405 346 737 ;\r\nC 232 ; WX 556 ; N Lslash ; B -20 0 537 718 ;\r\nC 233 ; WX 778 ; N Oslash ; B 39 -19 740 737 ;\r\nC 234 ; WX 1000 ; N OE ; B 36 -19 965 737 ;\r\nC 235 ; WX 365 ; N ordmasculine ; B 25 405 341 737 ;\r\nC 241 ; WX 889 ; N ae ; B 36 -15 847 538 ;\r\nC 245 ; WX 278 ; N dotlessi ; B 95 0 183 523 ;\r\nC 248 ; WX 222 ; N lslash ; B -20 0 242 718 ;\r\nC 249 ; WX 611 ; N oslash ; B 28 -22 537 545 ;\r\nC 250 ; WX 944 ; N oe ; B 35 -15 902 538 ;\r\nC 251 ; WX 611 ; N germandbls ; B 67 -15 571 728 ;\r\nC -1 ; WX 278 ; N Idieresis ; B 13 0 266 901 ;\r\nC -1 ; WX 556 ; N eacute ; B 40 -15 516 734 ;\r\nC -1 ; WX 556 ; N abreve ; B 36 -15 530 731 ;\r\nC -1 ; WX 556 ; N uhungarumlaut ; B 68 -15 521 734 ;\r\nC -1 ; WX 556 ; N ecaron ; B 40 -15 516 734 ;\r\nC -1 ; WX 667 ; N Ydieresis ; B 14 0 653 901 ;\r\nC -1 ; WX 584 ; N divide ; B 39 -19 545 524 ;\r\nC -1 ; WX 667 ; N Yacute ; B 14 0 653 929 ;\r\nC -1 ; WX 667 ; N Acircumflex ; B 14 0 654 929 ;\r\nC -1 ; WX 556 ; N aacute ; B 36 -15 530 734 ;\r\nC -1 ; WX 722 ; N Ucircumflex ; B 79 -19 644 929 ;\r\nC -1 ; WX 500 ; N yacute ; B 11 -214 489 734 ;\r\nC -1 ; WX 500 ; N scommaaccent ; B 32 -225 464 538 ;\r\nC -1 ; WX 556 ; N ecircumflex ; B 40 -15 516 734 ;\r\nC -1 ; WX 722 ; N Uring ; B 79 -19 644 931 ;\r\nC -1 ; WX 722 ; N Udieresis ; B 79 -19 644 901 ;\r\nC -1 ; WX 556 ; N aogonek ; B 36 -220 547 538 ;\r\nC -1 ; WX 722 ; N Uacute ; B 79 -19 644 929 ;\r\nC -1 ; WX 556 ; N uogonek ; B 68 -225 519 523 ;\r\nC -1 ; WX 667 ; N Edieresis ; B 86 0 616 901 ;\r\nC -1 ; WX 722 ; N Dcroat ; B 0 0 674 718 ;\r\nC -1 ; WX 250 ; N commaaccent ; B 87 -225 181 -40 ;\r\nC -1 ; WX 737 ; N copyright ; B -14 -19 752 737 ;\r\nC -1 ; WX 667 ; N Emacron ; B 86 0 616 879 ;\r\nC -1 ; WX 500 ; N ccaron ; B 30 -15 477 734 ;\r\nC -1 ; WX 556 ; N aring ; B 36 -15 530 756 ;\r\nC -1 ; WX 722 ; N Ncommaaccent ; B 76 -225 646 718 ;\r\nC -1 ; WX 222 ; N lacute ; B 67 0 264 929 ;\r\nC -1 ; WX 556 ; N agrave ; B 36 -15 530 734 ;\r\nC -1 ; WX 611 ; N Tcommaaccent ; B 14 -225 597 718 ;\r\nC -1 ; WX 722 ; N Cacute ; B 44 -19 681 929 ;\r\nC -1 ; WX 556 ; N atilde ; B 36 -15 530 722 ;\r\nC -1 ; WX 667 ; N Edotaccent ; B 86 0 616 901 ;\r\nC -1 ; WX 500 ; N scaron ; B 32 -15 464 734 ;\r\nC -1 ; WX 500 ; N scedilla ; B 32 -225 464 538 ;\r\nC -1 ; WX 278 ; N iacute ; B 95 0 292 734 ;\r\nC -1 ; WX 471 ; N lozenge ; B 10 0 462 728 ;\r\nC -1 ; WX 722 ; N Rcaron ; B 88 0 684 929 ;\r\nC -1 ; WX 778 ; N Gcommaaccent ; B 48 -225 704 737 ;\r\nC -1 ; WX 556 ; N ucircumflex ; B 68 -15 489 734 ;\r\nC -1 ; WX 556 ; N acircumflex ; B 36 -15 530 734 ;\r\nC -1 ; WX 667 ; N Amacron ; B 14 0 654 879 ;\r\nC -1 ; WX 333 ; N rcaron ; B 61 0 352 734 ;\r\nC -1 ; WX 500 ; N ccedilla ; B 30 -225 477 538 ;\r\nC -1 ; WX 611 ; N Zdotaccent ; B 23 0 588 901 ;\r\nC -1 ; WX 667 ; N Thorn ; B 86 0 622 718 ;\r\nC -1 ; WX 778 ; N Omacron ; B 39 -19 739 879 ;\r\nC -1 ; WX 722 ; N Racute ; B 88 0 684 929 ;\r\nC -1 ; WX 667 ; N Sacute ; B 49 -19 620 929 ;\r\nC -1 ; WX 643 ; N dcaron ; B 35 -15 655 718 ;\r\nC -1 ; WX 722 ; N Umacron ; B 79 -19 644 879 ;\r\nC -1 ; WX 556 ; N uring ; B 68 -15 489 756 ;\r\nC -1 ; WX 333 ; N threesuperior ; B 5 270 325 703 ;\r\nC -1 ; WX 778 ; N Ograve ; B 39 -19 739 929 ;\r\nC -1 ; WX 667 ; N Agrave ; B 14 0 654 929 ;\r\nC -1 ; WX 667 ; N Abreve ; B 14 0 654 926 ;\r\nC -1 ; WX 584 ; N multiply ; B 39 0 545 506 ;\r\nC -1 ; WX 556 ; N uacute ; B 68 -15 489 734 ;\r\nC -1 ; WX 611 ; N Tcaron ; B 14 0 597 929 ;\r\nC -1 ; WX 476 ; N partialdiff ; B 13 -38 463 714 ;\r\nC -1 ; WX 500 ; N ydieresis ; B 11 -214 489 706 ;\r\nC -1 ; WX 722 ; N Nacute ; B 76 0 646 929 ;\r\nC -1 ; WX 278 ; N icircumflex ; B -6 0 285 734 ;\r\nC -1 ; WX 667 ; N Ecircumflex ; B 86 0 616 929 ;\r\nC -1 ; WX 556 ; N adieresis ; B 36 -15 530 706 ;\r\nC -1 ; WX 556 ; N edieresis ; B 40 -15 516 706 ;\r\nC -1 ; WX 500 ; N cacute ; B 30 -15 477 734 ;\r\nC -1 ; WX 556 ; N nacute ; B 65 0 491 734 ;\r\nC -1 ; WX 556 ; N umacron ; B 68 -15 489 684 ;\r\nC -1 ; WX 722 ; N Ncaron ; B 76 0 646 929 ;\r\nC -1 ; WX 278 ; N Iacute ; B 91 0 292 929 ;\r\nC -1 ; WX 584 ; N plusminus ; B 39 0 545 506 ;\r\nC -1 ; WX 260 ; N brokenbar ; B 94 -150 167 700 ;\r\nC -1 ; WX 737 ; N registered ; B -14 -19 752 737 ;\r\nC -1 ; WX 778 ; N Gbreve ; B 48 -19 704 926 ;\r\nC -1 ; WX 278 ; N Idotaccent ; B 91 0 188 901 ;\r\nC -1 ; WX 600 ; N summation ; B 15 -10 586 706 ;\r\nC -1 ; WX 667 ; N Egrave ; B 86 0 616 929 ;\r\nC -1 ; WX 333 ; N racute ; B 77 0 332 734 ;\r\nC -1 ; WX 556 ; N omacron ; B 35 -14 521 684 ;\r\nC -1 ; WX 611 ; N Zacute ; B 23 0 588 929 ;\r\nC -1 ; WX 611 ; N Zcaron ; B 23 0 588 929 ;\r\nC -1 ; WX 549 ; N greaterequal ; B 26 0 523 674 ;\r\nC -1 ; WX 722 ; N Eth ; B 0 0 674 718 ;\r\nC -1 ; WX 722 ; N Ccedilla ; B 44 -225 681 737 ;\r\nC -1 ; WX 222 ; N lcommaaccent ; B 67 -225 167 718 ;\r\nC -1 ; WX 317 ; N tcaron ; B 14 -7 329 808 ;\r\nC -1 ; WX 556 ; N eogonek ; B 40 -225 516 538 ;\r\nC -1 ; WX 722 ; N Uogonek ; B 79 -225 644 718 ;\r\nC -1 ; WX 667 ; N Aacute ; B 14 0 654 929 ;\r\nC -1 ; WX 667 ; N Adieresis ; B 14 0 654 901 ;\r\nC -1 ; WX 556 ; N egrave ; B 40 -15 516 734 ;\r\nC -1 ; WX 500 ; N zacute ; B 31 0 469 734 ;\r\nC -1 ; WX 222 ; N iogonek ; B -31 -225 183 718 ;\r\nC -1 ; WX 778 ; N Oacute ; B 39 -19 739 929 ;\r\nC -1 ; WX 556 ; N oacute ; B 35 -14 521 734 ;\r\nC -1 ; WX 556 ; N amacron ; B 36 -15 530 684 ;\r\nC -1 ; WX 500 ; N sacute ; B 32 -15 464 734 ;\r\nC -1 ; WX 278 ; N idieresis ; B 13 0 266 706 ;\r\nC -1 ; WX 778 ; N Ocircumflex ; B 39 -19 739 929 ;\r\nC -1 ; WX 722 ; N Ugrave ; B 79 -19 644 929 ;\r\nC -1 ; WX 612 ; N Delta ; B 6 0 608 688 ;\r\nC -1 ; WX 556 ; N thorn ; B 58 -207 517 718 ;\r\nC -1 ; WX 333 ; N twosuperior ; B 4 281 323 703 ;\r\nC -1 ; WX 778 ; N Odieresis ; B 39 -19 739 901 ;\r\nC -1 ; WX 556 ; N mu ; B 68 -207 489 523 ;\r\nC -1 ; WX 278 ; N igrave ; B -13 0 184 734 ;\r\nC -1 ; WX 556 ; N ohungarumlaut ; B 35 -14 521 734 ;\r\nC -1 ; WX 667 ; N Eogonek ; B 86 -220 633 718 ;\r\nC -1 ; WX 556 ; N dcroat ; B 35 -15 550 718 ;\r\nC -1 ; WX 834 ; N threequarters ; B 45 -19 810 703 ;\r\nC -1 ; WX 667 ; N Scedilla ; B 49 -225 620 737 ;\r\nC -1 ; WX 299 ; N lcaron ; B 67 0 311 718 ;\r\nC -1 ; WX 667 ; N Kcommaaccent ; B 76 -225 663 718 ;\r\nC -1 ; WX 556 ; N Lacute ; B 76 0 537 929 ;\r\nC -1 ; WX 1000 ; N trademark ; B 46 306 903 718 ;\r\nC -1 ; WX 556 ; N edotaccent ; B 40 -15 516 706 ;\r\nC -1 ; WX 278 ; N Igrave ; B -13 0 188 929 ;\r\nC -1 ; WX 278 ; N Imacron ; B -17 0 296 879 ;\r\nC -1 ; WX 556 ; N Lcaron ; B 76 0 537 718 ;\r\nC -1 ; WX 834 ; N onehalf ; B 43 -19 773 703 ;\r\nC -1 ; WX 549 ; N lessequal ; B 26 0 523 674 ;\r\nC -1 ; WX 556 ; N ocircumflex ; B 35 -14 521 734 ;\r\nC -1 ; WX 556 ; N ntilde ; B 65 0 491 722 ;\r\nC -1 ; WX 722 ; N Uhungarumlaut ; B 79 -19 644 929 ;\r\nC -1 ; WX 667 ; N Eacute ; B 86 0 616 929 ;\r\nC -1 ; WX 556 ; N emacron ; B 40 -15 516 684 ;\r\nC -1 ; WX 556 ; N gbreve ; B 40 -220 499 731 ;\r\nC -1 ; WX 834 ; N onequarter ; B 73 -19 756 703 ;\r\nC -1 ; WX 667 ; N Scaron ; B 49 -19 620 929 ;\r\nC -1 ; WX 667 ; N Scommaaccent ; B 49 -225 620 737 ;\r\nC -1 ; WX 778 ; N Ohungarumlaut ; B 39 -19 739 929 ;\r\nC -1 ; WX 400 ; N degree ; B 54 411 346 703 ;\r\nC -1 ; WX 556 ; N ograve ; B 35 -14 521 734 ;\r\nC -1 ; WX 722 ; N Ccaron ; B 44 -19 681 929 ;\r\nC -1 ; WX 556 ; N ugrave ; B 68 -15 489 734 ;\r\nC -1 ; WX 453 ; N radical ; B -4 -80 458 762 ;\r\nC -1 ; WX 722 ; N Dcaron ; B 81 0 674 929 ;\r\nC -1 ; WX 333 ; N rcommaaccent ; B 77 -225 332 538 ;\r\nC -1 ; WX 722 ; N Ntilde ; B 76 0 646 917 ;\r\nC -1 ; WX 556 ; N otilde ; B 35 -14 521 722 ;\r\nC -1 ; WX 722 ; N Rcommaaccent ; B 88 -225 684 718 ;\r\nC -1 ; WX 556 ; N Lcommaaccent ; B 76 -225 537 718 ;\r\nC -1 ; WX 667 ; N Atilde ; B 14 0 654 917 ;\r\nC -1 ; WX 667 ; N Aogonek ; B 14 -225 654 718 ;\r\nC -1 ; WX 667 ; N Aring ; B 14 0 654 931 ;\r\nC -1 ; WX 778 ; N Otilde ; B 39 -19 739 917 ;\r\nC -1 ; WX 500 ; N zdotaccent ; B 31 0 469 706 ;\r\nC -1 ; WX 667 ; N Ecaron ; B 86 0 616 929 ;\r\nC -1 ; WX 278 ; N Iogonek ; B -3 -225 211 718 ;\r\nC -1 ; WX 500 ; N kcommaaccent ; B 67 -225 501 718 ;\r\nC -1 ; WX 584 ; N minus ; B 39 216 545 289 ;\r\nC -1 ; WX 278 ; N Icircumflex ; B -6 0 285 929 ;\r\nC -1 ; WX 556 ; N ncaron ; B 65 0 491 734 ;\r\nC -1 ; WX 278 ; N tcommaaccent ; B 14 -225 257 669 ;\r\nC -1 ; WX 584 ; N logicalnot ; B 39 108 545 390 ;\r\nC -1 ; WX 556 ; N odieresis ; B 35 -14 521 706 ;\r\nC -1 ; WX 556 ; N udieresis ; B 68 -15 489 706 ;\r\nC -1 ; WX 549 ; N notequal ; B 12 -35 537 551 ;\r\nC -1 ; WX 556 ; N gcommaaccent ; B 40 -220 499 822 ;\r\nC -1 ; WX 556 ; N eth ; B 35 -15 522 737 ;\r\nC -1 ; WX 500 ; N zcaron ; B 31 0 469 734 ;\r\nC -1 ; WX 556 ; N ncommaaccent ; B 65 -225 491 538 ;\r\nC -1 ; WX 333 ; N onesuperior ; B 43 281 222 703 ;\r\nC -1 ; WX 278 ; N imacron ; B 5 0 272 684 ;\r\nC -1 ; WX 556 ; N Euro ; B 0 0 0 0 ;\r\nEndCharMetrics\r\nStartKernData\r\nStartKernPairs 2705\r\nKPX A C -30\r\nKPX A Cacute -30\r\nKPX A Ccaron -30\r\nKPX A Ccedilla -30\r\nKPX A G -30\r\nKPX A Gbreve -30\r\nKPX A Gcommaaccent -30\r\nKPX A O -30\r\nKPX A Oacute -30\r\nKPX A Ocircumflex -30\r\nKPX A Odieresis -30\r\nKPX A Ograve -30\r\nKPX A Ohungarumlaut -30\r\nKPX A Omacron -30\r\nKPX A Oslash -30\r\nKPX A Otilde -30\r\nKPX A Q -30\r\nKPX A T -120\r\nKPX A Tcaron -120\r\nKPX A Tcommaaccent -120\r\nKPX A U -50\r\nKPX A Uacute -50\r\nKPX A Ucircumflex -50\r\nKPX A Udieresis -50\r\nKPX A Ugrave -50\r\nKPX A Uhungarumlaut -50\r\nKPX A Umacron -50\r\nKPX A Uogonek -50\r\nKPX A Uring -50\r\nKPX A V -70\r\nKPX A W -50\r\nKPX A Y -100\r\nKPX A Yacute -100\r\nKPX A Ydieresis -100\r\nKPX A u -30\r\nKPX A uacute -30\r\nKPX A ucircumflex -30\r\nKPX A udieresis -30\r\nKPX A ugrave -30\r\nKPX A uhungarumlaut -30\r\nKPX A umacron -30\r\nKPX A uogonek -30\r\nKPX A uring -30\r\nKPX A v -40\r\nKPX A w -40\r\nKPX A y -40\r\nKPX A yacute -40\r\nKPX A ydieresis -40\r\nKPX Aacute C -30\r\nKPX Aacute Cacute -30\r\nKPX Aacute Ccaron -30\r\nKPX Aacute Ccedilla -30\r\nKPX Aacute G -30\r\nKPX Aacute Gbreve -30\r\nKPX Aacute Gcommaaccent -30\r\nKPX Aacute O -30\r\nKPX Aacute Oacute -30\r\nKPX Aacute Ocircumflex -30\r\nKPX Aacute Odieresis -30\r\nKPX Aacute Ograve -30\r\nKPX Aacute Ohungarumlaut -30\r\nKPX Aacute Omacron -30\r\nKPX Aacute Oslash -30\r\nKPX Aacute Otilde -30\r\nKPX Aacute Q -30\r\nKPX Aacute T -120\r\nKPX Aacute Tcaron -120\r\nKPX Aacute Tcommaaccent -120\r\nKPX Aacute U -50\r\nKPX Aacute Uacute -50\r\nKPX Aacute Ucircumflex -50\r\nKPX Aacute Udieresis -50\r\nKPX Aacute Ugrave -50\r\nKPX Aacute Uhungarumlaut -50\r\nKPX Aacute Umacron -50\r\nKPX Aacute Uogonek -50\r\nKPX Aacute Uring -50\r\nKPX Aacute V -70\r\nKPX Aacute W -50\r\nKPX Aacute Y -100\r\nKPX Aacute Yacute -100\r\nKPX Aacute Ydieresis -100\r\nKPX Aacute u -30\r\nKPX Aacute uacute -30\r\nKPX Aacute ucircumflex -30\r\nKPX Aacute udieresis -30\r\nKPX Aacute ugrave -30\r\nKPX Aacute uhungarumlaut -30\r\nKPX Aacute umacron -30\r\nKPX Aacute uogonek -30\r\nKPX Aacute uring -30\r\nKPX Aacute v -40\r\nKPX Aacute w -40\r\nKPX Aacute y -40\r\nKPX Aacute yacute -40\r\nKPX Aacute ydieresis -40\r\nKPX Abreve C -30\r\nKPX Abreve Cacute -30\r\nKPX Abreve Ccaron -30\r\nKPX Abreve Ccedilla -30\r\nKPX Abreve G -30\r\nKPX Abreve Gbreve -30\r\nKPX Abreve Gcommaaccent -30\r\nKPX Abreve O -30\r\nKPX Abreve Oacute -30\r\nKPX Abreve Ocircumflex -30\r\nKPX Abreve Odieresis -30\r\nKPX Abreve Ograve -30\r\nKPX Abreve Ohungarumlaut -30\r\nKPX Abreve Omacron -30\r\nKPX Abreve Oslash -30\r\nKPX Abreve Otilde -30\r\nKPX Abreve Q -30\r\nKPX Abreve T -120\r\nKPX Abreve Tcaron -120\r\nKPX Abreve Tcommaaccent -120\r\nKPX Abreve U -50\r\nKPX Abreve Uacute -50\r\nKPX Abreve Ucircumflex -50\r\nKPX Abreve Udieresis -50\r\nKPX Abreve Ugrave -50\r\nKPX Abreve Uhungarumlaut -50\r\nKPX Abreve Umacron -50\r\nKPX Abreve Uogonek -50\r\nKPX Abreve Uring -50\r\nKPX Abreve V -70\r\nKPX Abreve W -50\r\nKPX Abreve Y -100\r\nKPX Abreve Yacute -100\r\nKPX Abreve Ydieresis -100\r\nKPX Abreve u -30\r\nKPX Abreve uacute -30\r\nKPX Abreve ucircumflex -30\r\nKPX Abreve udieresis -30\r\nKPX Abreve ugrave -30\r\nKPX Abreve uhungarumlaut -30\r\nKPX Abreve umacron -30\r\nKPX Abreve uogonek -30\r\nKPX Abreve uring -30\r\nKPX Abreve v -40\r\nKPX Abreve w -40\r\nKPX Abreve y -40\r\nKPX Abreve yacute -40\r\nKPX Abreve ydieresis -40\r\nKPX Acircumflex C -30\r\nKPX Acircumflex Cacute -30\r\nKPX Acircumflex Ccaron -30\r\nKPX Acircumflex Ccedilla -30\r\nKPX Acircumflex G -30\r\nKPX Acircumflex Gbreve -30\r\nKPX Acircumflex Gcommaaccent -30\r\nKPX Acircumflex O -30\r\nKPX Acircumflex Oacute -30\r\nKPX Acircumflex Ocircumflex -30\r\nKPX Acircumflex Odieresis -30\r\nKPX Acircumflex Ograve -30\r\nKPX Acircumflex Ohungarumlaut -30\r\nKPX Acircumflex Omacron -30\r\nKPX Acircumflex Oslash -30\r\nKPX Acircumflex Otilde -30\r\nKPX Acircumflex Q -30\r\nKPX Acircumflex T -120\r\nKPX Acircumflex Tcaron -120\r\nKPX Acircumflex Tcommaaccent -120\r\nKPX Acircumflex U -50\r\nKPX Acircumflex Uacute -50\r\nKPX Acircumflex Ucircumflex -50\r\nKPX Acircumflex Udieresis -50\r\nKPX Acircumflex Ugrave -50\r\nKPX Acircumflex Uhungarumlaut -50\r\nKPX Acircumflex Umacron -50\r\nKPX Acircumflex Uogonek -50\r\nKPX Acircumflex Uring -50\r\nKPX Acircumflex V -70\r\nKPX Acircumflex W -50\r\nKPX Acircumflex Y -100\r\nKPX Acircumflex Yacute -100\r\nKPX Acircumflex Ydieresis -100\r\nKPX Acircumflex u -30\r\nKPX Acircumflex uacute -30\r\nKPX Acircumflex ucircumflex -30\r\nKPX Acircumflex udieresis -30\r\nKPX Acircumflex ugrave -30\r\nKPX Acircumflex uhungarumlaut -30\r\nKPX Acircumflex umacron -30\r\nKPX Acircumflex uogonek -30\r\nKPX Acircumflex uring -30\r\nKPX Acircumflex v -40\r\nKPX Acircumflex w -40\r\nKPX Acircumflex y -40\r\nKPX Acircumflex yacute -40\r\nKPX Acircumflex ydieresis -40\r\nKPX Adieresis C -30\r\nKPX Adieresis Cacute -30\r\nKPX Adieresis Ccaron -30\r\nKPX Adieresis Ccedilla -30\r\nKPX Adieresis G -30\r\nKPX Adieresis Gbreve -30\r\nKPX Adieresis Gcommaaccent -30\r\nKPX Adieresis O -30\r\nKPX Adieresis Oacute -30\r\nKPX Adieresis Ocircumflex -30\r\nKPX Adieresis Odieresis -30\r\nKPX Adieresis Ograve -30\r\nKPX Adieresis Ohungarumlaut -30\r\nKPX Adieresis Omacron -30\r\nKPX Adieresis Oslash -30\r\nKPX Adieresis Otilde -30\r\nKPX Adieresis Q -30\r\nKPX Adieresis T -120\r\nKPX Adieresis Tcaron -120\r\nKPX Adieresis Tcommaaccent -120\r\nKPX Adieresis U -50\r\nKPX Adieresis Uacute -50\r\nKPX Adieresis Ucircumflex -50\r\nKPX Adieresis Udieresis -50\r\nKPX Adieresis Ugrave -50\r\nKPX Adieresis Uhungarumlaut -50\r\nKPX Adieresis Umacron -50\r\nKPX Adieresis Uogonek -50\r\nKPX Adieresis Uring -50\r\nKPX Adieresis V -70\r\nKPX Adieresis W -50\r\nKPX Adieresis Y -100\r\nKPX Adieresis Yacute -100\r\nKPX Adieresis Ydieresis -100\r\nKPX Adieresis u -30\r\nKPX Adieresis uacute -30\r\nKPX Adieresis ucircumflex -30\r\nKPX Adieresis udieresis -30\r\nKPX Adieresis ugrave -30\r\nKPX Adieresis uhungarumlaut -30\r\nKPX Adieresis umacron -30\r\nKPX Adieresis uogonek -30\r\nKPX Adieresis uring -30\r\nKPX Adieresis v -40\r\nKPX Adieresis w -40\r\nKPX Adieresis y -40\r\nKPX Adieresis yacute -40\r\nKPX Adieresis ydieresis -40\r\nKPX Agrave C -30\r\nKPX Agrave Cacute -30\r\nKPX Agrave Ccaron -30\r\nKPX Agrave Ccedilla -30\r\nKPX Agrave G -30\r\nKPX Agrave Gbreve -30\r\nKPX Agrave Gcommaaccent -30\r\nKPX Agrave O -30\r\nKPX Agrave Oacute -30\r\nKPX Agrave Ocircumflex -30\r\nKPX Agrave Odieresis -30\r\nKPX Agrave Ograve -30\r\nKPX Agrave Ohungarumlaut -30\r\nKPX Agrave Omacron -30\r\nKPX Agrave Oslash -30\r\nKPX Agrave Otilde -30\r\nKPX Agrave Q -30\r\nKPX Agrave T -120\r\nKPX Agrave Tcaron -120\r\nKPX Agrave Tcommaaccent -120\r\nKPX Agrave U -50\r\nKPX Agrave Uacute -50\r\nKPX Agrave Ucircumflex -50\r\nKPX Agrave Udieresis -50\r\nKPX Agrave Ugrave -50\r\nKPX Agrave Uhungarumlaut -50\r\nKPX Agrave Umacron -50\r\nKPX Agrave Uogonek -50\r\nKPX Agrave Uring -50\r\nKPX Agrave V -70\r\nKPX Agrave W -50\r\nKPX Agrave Y -100\r\nKPX Agrave Yacute -100\r\nKPX Agrave Ydieresis -100\r\nKPX Agrave u -30\r\nKPX Agrave uacute -30\r\nKPX Agrave ucircumflex -30\r\nKPX Agrave udieresis -30\r\nKPX Agrave ugrave -30\r\nKPX Agrave uhungarumlaut -30\r\nKPX Agrave umacron -30\r\nKPX Agrave uogonek -30\r\nKPX Agrave uring -30\r\nKPX Agrave v -40\r\nKPX Agrave w -40\r\nKPX Agrave y -40\r\nKPX Agrave yacute -40\r\nKPX Agrave ydieresis -40\r\nKPX Amacron C -30\r\nKPX Amacron Cacute -30\r\nKPX Amacron Ccaron -30\r\nKPX Amacron Ccedilla -30\r\nKPX Amacron G -30\r\nKPX Amacron Gbreve -30\r\nKPX Amacron Gcommaaccent -30\r\nKPX Amacron O -30\r\nKPX Amacron Oacute -30\r\nKPX Amacron Ocircumflex -30\r\nKPX Amacron Odieresis -30\r\nKPX Amacron Ograve -30\r\nKPX Amacron Ohungarumlaut -30\r\nKPX Amacron Omacron -30\r\nKPX Amacron Oslash -30\r\nKPX Amacron Otilde -30\r\nKPX Amacron Q -30\r\nKPX Amacron T -120\r\nKPX Amacron Tcaron -120\r\nKPX Amacron Tcommaaccent -120\r\nKPX Amacron U -50\r\nKPX Amacron Uacute -50\r\nKPX Amacron Ucircumflex -50\r\nKPX Amacron Udieresis -50\r\nKPX Amacron Ugrave -50\r\nKPX Amacron Uhungarumlaut -50\r\nKPX Amacron Umacron -50\r\nKPX Amacron Uogonek -50\r\nKPX Amacron Uring -50\r\nKPX Amacron V -70\r\nKPX Amacron W -50\r\nKPX Amacron Y -100\r\nKPX Amacron Yacute -100\r\nKPX Amacron Ydieresis -100\r\nKPX Amacron u -30\r\nKPX Amacron uacute -30\r\nKPX Amacron ucircumflex -30\r\nKPX Amacron udieresis -30\r\nKPX Amacron ugrave -30\r\nKPX Amacron uhungarumlaut -30\r\nKPX Amacron umacron -30\r\nKPX Amacron uogonek -30\r\nKPX Amacron uring -30\r\nKPX Amacron v -40\r\nKPX Amacron w -40\r\nKPX Amacron y -40\r\nKPX Amacron yacute -40\r\nKPX Amacron ydieresis -40\r\nKPX Aogonek C -30\r\nKPX Aogonek Cacute -30\r\nKPX Aogonek Ccaron -30\r\nKPX Aogonek Ccedilla -30\r\nKPX Aogonek G -30\r\nKPX Aogonek Gbreve -30\r\nKPX Aogonek Gcommaaccent -30\r\nKPX Aogonek O -30\r\nKPX Aogonek Oacute -30\r\nKPX Aogonek Ocircumflex -30\r\nKPX Aogonek Odieresis -30\r\nKPX Aogonek Ograve -30\r\nKPX Aogonek Ohungarumlaut -30\r\nKPX Aogonek Omacron -30\r\nKPX Aogonek Oslash -30\r\nKPX Aogonek Otilde -30\r\nKPX Aogonek Q -30\r\nKPX Aogonek T -120\r\nKPX Aogonek Tcaron -120\r\nKPX Aogonek Tcommaaccent -120\r\nKPX Aogonek U -50\r\nKPX Aogonek Uacute -50\r\nKPX Aogonek Ucircumflex -50\r\nKPX Aogonek Udieresis -50\r\nKPX Aogonek Ugrave -50\r\nKPX Aogonek Uhungarumlaut -50\r\nKPX Aogonek Umacron -50\r\nKPX Aogonek Uogonek -50\r\nKPX Aogonek Uring -50\r\nKPX Aogonek V -70\r\nKPX Aogonek W -50\r\nKPX Aogonek Y -100\r\nKPX Aogonek Yacute -100\r\nKPX Aogonek Ydieresis -100\r\nKPX Aogonek u -30\r\nKPX Aogonek uacute -30\r\nKPX Aogonek ucircumflex -30\r\nKPX Aogonek udieresis -30\r\nKPX Aogonek ugrave -30\r\nKPX Aogonek uhungarumlaut -30\r\nKPX Aogonek umacron -30\r\nKPX Aogonek uogonek -30\r\nKPX Aogonek uring -30\r\nKPX Aogonek v -40\r\nKPX Aogonek w -40\r\nKPX Aogonek y -40\r\nKPX Aogonek yacute -40\r\nKPX Aogonek ydieresis -40\r\nKPX Aring C -30\r\nKPX Aring Cacute -30\r\nKPX Aring Ccaron -30\r\nKPX Aring Ccedilla -30\r\nKPX Aring G -30\r\nKPX Aring Gbreve -30\r\nKPX Aring Gcommaaccent -30\r\nKPX Aring O -30\r\nKPX Aring Oacute -30\r\nKPX Aring Ocircumflex -30\r\nKPX Aring Odieresis -30\r\nKPX Aring Ograve -30\r\nKPX Aring Ohungarumlaut -30\r\nKPX Aring Omacron -30\r\nKPX Aring Oslash -30\r\nKPX Aring Otilde -30\r\nKPX Aring Q -30\r\nKPX Aring T -120\r\nKPX Aring Tcaron -120\r\nKPX Aring Tcommaaccent -120\r\nKPX Aring U -50\r\nKPX Aring Uacute -50\r\nKPX Aring Ucircumflex -50\r\nKPX Aring Udieresis -50\r\nKPX Aring Ugrave -50\r\nKPX Aring Uhungarumlaut -50\r\nKPX Aring Umacron -50\r\nKPX Aring Uogonek -50\r\nKPX Aring Uring -50\r\nKPX Aring V -70\r\nKPX Aring W -50\r\nKPX Aring Y -100\r\nKPX Aring Yacute -100\r\nKPX Aring Ydieresis -100\r\nKPX Aring u -30\r\nKPX Aring uacute -30\r\nKPX Aring ucircumflex -30\r\nKPX Aring udieresis -30\r\nKPX Aring ugrave -30\r\nKPX Aring uhungarumlaut -30\r\nKPX Aring umacron -30\r\nKPX Aring uogonek -30\r\nKPX Aring uring -30\r\nKPX Aring v -40\r\nKPX Aring w -40\r\nKPX Aring y -40\r\nKPX Aring yacute -40\r\nKPX Aring ydieresis -40\r\nKPX Atilde C -30\r\nKPX Atilde Cacute -30\r\nKPX Atilde Ccaron -30\r\nKPX Atilde Ccedilla -30\r\nKPX Atilde G -30\r\nKPX Atilde Gbreve -30\r\nKPX Atilde Gcommaaccent -30\r\nKPX Atilde O -30\r\nKPX Atilde Oacute -30\r\nKPX Atilde Ocircumflex -30\r\nKPX Atilde Odieresis -30\r\nKPX Atilde Ograve -30\r\nKPX Atilde Ohungarumlaut -30\r\nKPX Atilde Omacron -30\r\nKPX Atilde Oslash -30\r\nKPX Atilde Otilde -30\r\nKPX Atilde Q -30\r\nKPX Atilde T -120\r\nKPX Atilde Tcaron -120\r\nKPX Atilde Tcommaaccent -120\r\nKPX Atilde U -50\r\nKPX Atilde Uacute -50\r\nKPX Atilde Ucircumflex -50\r\nKPX Atilde Udieresis -50\r\nKPX Atilde Ugrave -50\r\nKPX Atilde Uhungarumlaut -50\r\nKPX Atilde Umacron -50\r\nKPX Atilde Uogonek -50\r\nKPX Atilde Uring -50\r\nKPX Atilde V -70\r\nKPX Atilde W -50\r\nKPX Atilde Y -100\r\nKPX Atilde Yacute -100\r\nKPX Atilde Ydieresis -100\r\nKPX Atilde u -30\r\nKPX Atilde uacute -30\r\nKPX Atilde ucircumflex -30\r\nKPX Atilde udieresis -30\r\nKPX Atilde ugrave -30\r\nKPX Atilde uhungarumlaut -30\r\nKPX Atilde umacron -30\r\nKPX Atilde uogonek -30\r\nKPX Atilde uring -30\r\nKPX Atilde v -40\r\nKPX Atilde w -40\r\nKPX Atilde y -40\r\nKPX Atilde yacute -40\r\nKPX Atilde ydieresis -40\r\nKPX B U -10\r\nKPX B Uacute -10\r\nKPX B Ucircumflex -10\r\nKPX B Udieresis -10\r\nKPX B Ugrave -10\r\nKPX B Uhungarumlaut -10\r\nKPX B Umacron -10\r\nKPX B Uogonek -10\r\nKPX B Uring -10\r\nKPX B comma -20\r\nKPX B period -20\r\nKPX C comma -30\r\nKPX C period -30\r\nKPX Cacute comma -30\r\nKPX Cacute period -30\r\nKPX Ccaron comma -30\r\nKPX Ccaron period -30\r\nKPX Ccedilla comma -30\r\nKPX Ccedilla period -30\r\nKPX D A -40\r\nKPX D Aacute -40\r\nKPX D Abreve -40\r\nKPX D Acircumflex -40\r\nKPX D Adieresis -40\r\nKPX D Agrave -40\r\nKPX D Amacron -40\r\nKPX D Aogonek -40\r\nKPX D Aring -40\r\nKPX D Atilde -40\r\nKPX D V -70\r\nKPX D W -40\r\nKPX D Y -90\r\nKPX D Yacute -90\r\nKPX D Ydieresis -90\r\nKPX D comma -70\r\nKPX D period -70\r\nKPX Dcaron A -40\r\nKPX Dcaron Aacute -40\r\nKPX Dcaron Abreve -40\r\nKPX Dcaron Acircumflex -40\r\nKPX Dcaron Adieresis -40\r\nKPX Dcaron Agrave -40\r\nKPX Dcaron Amacron -40\r\nKPX Dcaron Aogonek -40\r\nKPX Dcaron Aring -40\r\nKPX Dcaron Atilde -40\r\nKPX Dcaron V -70\r\nKPX Dcaron W -40\r\nKPX Dcaron Y -90\r\nKPX Dcaron Yacute -90\r\nKPX Dcaron Ydieresis -90\r\nKPX Dcaron comma -70\r\nKPX Dcaron period -70\r\nKPX Dcroat A -40\r\nKPX Dcroat Aacute -40\r\nKPX Dcroat Abreve -40\r\nKPX Dcroat Acircumflex -40\r\nKPX Dcroat Adieresis -40\r\nKPX Dcroat Agrave -40\r\nKPX Dcroat Amacron -40\r\nKPX Dcroat Aogonek -40\r\nKPX Dcroat Aring -40\r\nKPX Dcroat Atilde -40\r\nKPX Dcroat V -70\r\nKPX Dcroat W -40\r\nKPX Dcroat Y -90\r\nKPX Dcroat Yacute -90\r\nKPX Dcroat Ydieresis -90\r\nKPX Dcroat comma -70\r\nKPX Dcroat period -70\r\nKPX F A -80\r\nKPX F Aacute -80\r\nKPX F Abreve -80\r\nKPX F Acircumflex -80\r\nKPX F Adieresis -80\r\nKPX F Agrave -80\r\nKPX F Amacron -80\r\nKPX F Aogonek -80\r\nKPX F Aring -80\r\nKPX F Atilde -80\r\nKPX F a -50\r\nKPX F aacute -50\r\nKPX F abreve -50\r\nKPX F acircumflex -50\r\nKPX F adieresis -50\r\nKPX F agrave -50\r\nKPX F amacron -50\r\nKPX F aogonek -50\r\nKPX F aring -50\r\nKPX F atilde -50\r\nKPX F comma -150\r\nKPX F e -30\r\nKPX F eacute -30\r\nKPX F ecaron -30\r\nKPX F ecircumflex -30\r\nKPX F edieresis -30\r\nKPX F edotaccent -30\r\nKPX F egrave -30\r\nKPX F emacron -30\r\nKPX F eogonek -30\r\nKPX F o -30\r\nKPX F oacute -30\r\nKPX F ocircumflex -30\r\nKPX F odieresis -30\r\nKPX F ograve -30\r\nKPX F ohungarumlaut -30\r\nKPX F omacron -30\r\nKPX F oslash -30\r\nKPX F otilde -30\r\nKPX F period -150\r\nKPX F r -45\r\nKPX F racute -45\r\nKPX F rcaron -45\r\nKPX F rcommaaccent -45\r\nKPX J A -20\r\nKPX J Aacute -20\r\nKPX J Abreve -20\r\nKPX J Acircumflex -20\r\nKPX J Adieresis -20\r\nKPX J Agrave -20\r\nKPX J Amacron -20\r\nKPX J Aogonek -20\r\nKPX J Aring -20\r\nKPX J Atilde -20\r\nKPX J a -20\r\nKPX J aacute -20\r\nKPX J abreve -20\r\nKPX J acircumflex -20\r\nKPX J adieresis -20\r\nKPX J agrave -20\r\nKPX J amacron -20\r\nKPX J aogonek -20\r\nKPX J aring -20\r\nKPX J atilde -20\r\nKPX J comma -30\r\nKPX J period -30\r\nKPX J u -20\r\nKPX J uacute -20\r\nKPX J ucircumflex -20\r\nKPX J udieresis -20\r\nKPX J ugrave -20\r\nKPX J uhungarumlaut -20\r\nKPX J umacron -20\r\nKPX J uogonek -20\r\nKPX J uring -20\r\nKPX K O -50\r\nKPX K Oacute -50\r\nKPX K Ocircumflex -50\r\nKPX K Odieresis -50\r\nKPX K Ograve -50\r\nKPX K Ohungarumlaut -50\r\nKPX K Omacron -50\r\nKPX K Oslash -50\r\nKPX K Otilde -50\r\nKPX K e -40\r\nKPX K eacute -40\r\nKPX K ecaron -40\r\nKPX K ecircumflex -40\r\nKPX K edieresis -40\r\nKPX K edotaccent -40\r\nKPX K egrave -40\r\nKPX K emacron -40\r\nKPX K eogonek -40\r\nKPX K o -40\r\nKPX K oacute -40\r\nKPX K ocircumflex -40\r\nKPX K odieresis -40\r\nKPX K ograve -40\r\nKPX K ohungarumlaut -40\r\nKPX K omacron -40\r\nKPX K oslash -40\r\nKPX K otilde -40\r\nKPX K u -30\r\nKPX K uacute -30\r\nKPX K ucircumflex -30\r\nKPX K udieresis -30\r\nKPX K ugrave -30\r\nKPX K uhungarumlaut -30\r\nKPX K umacron -30\r\nKPX K uogonek -30\r\nKPX K uring -30\r\nKPX K y -50\r\nKPX K yacute -50\r\nKPX K ydieresis -50\r\nKPX Kcommaaccent O -50\r\nKPX Kcommaaccent Oacute -50\r\nKPX Kcommaaccent Ocircumflex -50\r\nKPX Kcommaaccent Odieresis -50\r\nKPX Kcommaaccent Ograve -50\r\nKPX Kcommaaccent Ohungarumlaut -50\r\nKPX Kcommaaccent Omacron -50\r\nKPX Kcommaaccent Oslash -50\r\nKPX Kcommaaccent Otilde -50\r\nKPX Kcommaaccent e -40\r\nKPX Kcommaaccent eacute -40\r\nKPX Kcommaaccent ecaron -40\r\nKPX Kcommaaccent ecircumflex -40\r\nKPX Kcommaaccent edieresis -40\r\nKPX Kcommaaccent edotaccent -40\r\nKPX Kcommaaccent egrave -40\r\nKPX Kcommaaccent emacron -40\r\nKPX Kcommaaccent eogonek -40\r\nKPX Kcommaaccent o -40\r\nKPX Kcommaaccent oacute -40\r\nKPX Kcommaaccent ocircumflex -40\r\nKPX Kcommaaccent odieresis -40\r\nKPX Kcommaaccent ograve -40\r\nKPX Kcommaaccent ohungarumlaut -40\r\nKPX Kcommaaccent omacron -40\r\nKPX Kcommaaccent oslash -40\r\nKPX Kcommaaccent otilde -40\r\nKPX Kcommaaccent u -30\r\nKPX Kcommaaccent uacute -30\r\nKPX Kcommaaccent ucircumflex -30\r\nKPX Kcommaaccent udieresis -30\r\nKPX Kcommaaccent ugrave -30\r\nKPX Kcommaaccent uhungarumlaut -30\r\nKPX Kcommaaccent umacron -30\r\nKPX Kcommaaccent uogonek -30\r\nKPX Kcommaaccent uring -30\r\nKPX Kcommaaccent y -50\r\nKPX Kcommaaccent yacute -50\r\nKPX Kcommaaccent ydieresis -50\r\nKPX L T -110\r\nKPX L Tcaron -110\r\nKPX L Tcommaaccent -110\r\nKPX L V -110\r\nKPX L W -70\r\nKPX L Y -140\r\nKPX L Yacute -140\r\nKPX L Ydieresis -140\r\nKPX L quotedblright -140\r\nKPX L quoteright -160\r\nKPX L y -30\r\nKPX L yacute -30\r\nKPX L ydieresis -30\r\nKPX Lacute T -110\r\nKPX Lacute Tcaron -110\r\nKPX Lacute Tcommaaccent -110\r\nKPX Lacute V -110\r\nKPX Lacute W -70\r\nKPX Lacute Y -140\r\nKPX Lacute Yacute -140\r\nKPX Lacute Ydieresis -140\r\nKPX Lacute quotedblright -140\r\nKPX Lacute quoteright -160\r\nKPX Lacute y -30\r\nKPX Lacute yacute -30\r\nKPX Lacute ydieresis -30\r\nKPX Lcaron T -110\r\nKPX Lcaron Tcaron -110\r\nKPX Lcaron Tcommaaccent -110\r\nKPX Lcaron V -110\r\nKPX Lcaron W -70\r\nKPX Lcaron Y -140\r\nKPX Lcaron Yacute -140\r\nKPX Lcaron Ydieresis -140\r\nKPX Lcaron quotedblright -140\r\nKPX Lcaron quoteright -160\r\nKPX Lcaron y -30\r\nKPX Lcaron yacute -30\r\nKPX Lcaron ydieresis -30\r\nKPX Lcommaaccent T -110\r\nKPX Lcommaaccent Tcaron -110\r\nKPX Lcommaaccent Tcommaaccent -110\r\nKPX Lcommaaccent V -110\r\nKPX Lcommaaccent W -70\r\nKPX Lcommaaccent Y -140\r\nKPX Lcommaaccent Yacute -140\r\nKPX Lcommaaccent Ydieresis -140\r\nKPX Lcommaaccent quotedblright -140\r\nKPX Lcommaaccent quoteright -160\r\nKPX Lcommaaccent y -30\r\nKPX Lcommaaccent yacute -30\r\nKPX Lcommaaccent ydieresis -30\r\nKPX Lslash T -110\r\nKPX Lslash Tcaron -110\r\nKPX Lslash Tcommaaccent -110\r\nKPX Lslash V -110\r\nKPX Lslash W -70\r\nKPX Lslash Y -140\r\nKPX Lslash Yacute -140\r\nKPX Lslash Ydieresis -140\r\nKPX Lslash quotedblright -140\r\nKPX Lslash quoteright -160\r\nKPX Lslash y -30\r\nKPX Lslash yacute -30\r\nKPX Lslash ydieresis -30\r\nKPX O A -20\r\nKPX O Aacute -20\r\nKPX O Abreve -20\r\nKPX O Acircumflex -20\r\nKPX O Adieresis -20\r\nKPX O Agrave -20\r\nKPX O Amacron -20\r\nKPX O Aogonek -20\r\nKPX O Aring -20\r\nKPX O Atilde -20\r\nKPX O T -40\r\nKPX O Tcaron -40\r\nKPX O Tcommaaccent -40\r\nKPX O V -50\r\nKPX O W -30\r\nKPX O X -60\r\nKPX O Y -70\r\nKPX O Yacute -70\r\nKPX O Ydieresis -70\r\nKPX O comma -40\r\nKPX O period -40\r\nKPX Oacute A -20\r\nKPX Oacute Aacute -20\r\nKPX Oacute Abreve -20\r\nKPX Oacute Acircumflex -20\r\nKPX Oacute Adieresis -20\r\nKPX Oacute Agrave -20\r\nKPX Oacute Amacron -20\r\nKPX Oacute Aogonek -20\r\nKPX Oacute Aring -20\r\nKPX Oacute Atilde -20\r\nKPX Oacute T -40\r\nKPX Oacute Tcaron -40\r\nKPX Oacute Tcommaaccent -40\r\nKPX Oacute V -50\r\nKPX Oacute W -30\r\nKPX Oacute X -60\r\nKPX Oacute Y -70\r\nKPX Oacute Yacute -70\r\nKPX Oacute Ydieresis -70\r\nKPX Oacute comma -40\r\nKPX Oacute period -40\r\nKPX Ocircumflex A -20\r\nKPX Ocircumflex Aacute -20\r\nKPX Ocircumflex Abreve -20\r\nKPX Ocircumflex Acircumflex -20\r\nKPX Ocircumflex Adieresis -20\r\nKPX Ocircumflex Agrave -20\r\nKPX Ocircumflex Amacron -20\r\nKPX Ocircumflex Aogonek -20\r\nKPX Ocircumflex Aring -20\r\nKPX Ocircumflex Atilde -20\r\nKPX Ocircumflex T -40\r\nKPX Ocircumflex Tcaron -40\r\nKPX Ocircumflex Tcommaaccent -40\r\nKPX Ocircumflex V -50\r\nKPX Ocircumflex W -30\r\nKPX Ocircumflex X -60\r\nKPX Ocircumflex Y -70\r\nKPX Ocircumflex Yacute -70\r\nKPX Ocircumflex Ydieresis -70\r\nKPX Ocircumflex comma -40\r\nKPX Ocircumflex period -40\r\nKPX Odieresis A -20\r\nKPX Odieresis Aacute -20\r\nKPX Odieresis Abreve -20\r\nKPX Odieresis Acircumflex -20\r\nKPX Odieresis Adieresis -20\r\nKPX Odieresis Agrave -20\r\nKPX Odieresis Amacron -20\r\nKPX Odieresis Aogonek -20\r\nKPX Odieresis Aring -20\r\nKPX Odieresis Atilde -20\r\nKPX Odieresis T -40\r\nKPX Odieresis Tcaron -40\r\nKPX Odieresis Tcommaaccent -40\r\nKPX Odieresis V -50\r\nKPX Odieresis W -30\r\nKPX Odieresis X -60\r\nKPX Odieresis Y -70\r\nKPX Odieresis Yacute -70\r\nKPX Odieresis Ydieresis -70\r\nKPX Odieresis comma -40\r\nKPX Odieresis period -40\r\nKPX Ograve A -20\r\nKPX Ograve Aacute -20\r\nKPX Ograve Abreve -20\r\nKPX Ograve Acircumflex -20\r\nKPX Ograve Adieresis -20\r\nKPX Ograve Agrave -20\r\nKPX Ograve Amacron -20\r\nKPX Ograve Aogonek -20\r\nKPX Ograve Aring -20\r\nKPX Ograve Atilde -20\r\nKPX Ograve T -40\r\nKPX Ograve Tcaron -40\r\nKPX Ograve Tcommaaccent -40\r\nKPX Ograve V -50\r\nKPX Ograve W -30\r\nKPX Ograve X -60\r\nKPX Ograve Y -70\r\nKPX Ograve Yacute -70\r\nKPX Ograve Ydieresis -70\r\nKPX Ograve comma -40\r\nKPX Ograve period -40\r\nKPX Ohungarumlaut A -20\r\nKPX Ohungarumlaut Aacute -20\r\nKPX Ohungarumlaut Abreve -20\r\nKPX Ohungarumlaut Acircumflex -20\r\nKPX Ohungarumlaut Adieresis -20\r\nKPX Ohungarumlaut Agrave -20\r\nKPX Ohungarumlaut Amacron -20\r\nKPX Ohungarumlaut Aogonek -20\r\nKPX Ohungarumlaut Aring -20\r\nKPX Ohungarumlaut Atilde -20\r\nKPX Ohungarumlaut T -40\r\nKPX Ohungarumlaut Tcaron -40\r\nKPX Ohungarumlaut Tcommaaccent -40\r\nKPX Ohungarumlaut V -50\r\nKPX Ohungarumlaut W -30\r\nKPX Ohungarumlaut X -60\r\nKPX Ohungarumlaut Y -70\r\nKPX Ohungarumlaut Yacute -70\r\nKPX Ohungarumlaut Ydieresis -70\r\nKPX Ohungarumlaut comma -40\r\nKPX Ohungarumlaut period -40\r\nKPX Omacron A -20\r\nKPX Omacron Aacute -20\r\nKPX Omacron Abreve -20\r\nKPX Omacron Acircumflex -20\r\nKPX Omacron Adieresis -20\r\nKPX Omacron Agrave -20\r\nKPX Omacron Amacron -20\r\nKPX Omacron Aogonek -20\r\nKPX Omacron Aring -20\r\nKPX Omacron Atilde -20\r\nKPX Omacron T -40\r\nKPX Omacron Tcaron -40\r\nKPX Omacron Tcommaaccent -40\r\nKPX Omacron V -50\r\nKPX Omacron W -30\r\nKPX Omacron X -60\r\nKPX Omacron Y -70\r\nKPX Omacron Yacute -70\r\nKPX Omacron Ydieresis -70\r\nKPX Omacron comma -40\r\nKPX Omacron period -40\r\nKPX Oslash A -20\r\nKPX Oslash Aacute -20\r\nKPX Oslash Abreve -20\r\nKPX Oslash Acircumflex -20\r\nKPX Oslash Adieresis -20\r\nKPX Oslash Agrave -20\r\nKPX Oslash Amacron -20\r\nKPX Oslash Aogonek -20\r\nKPX Oslash Aring -20\r\nKPX Oslash Atilde -20\r\nKPX Oslash T -40\r\nKPX Oslash Tcaron -40\r\nKPX Oslash Tcommaaccent -40\r\nKPX Oslash V -50\r\nKPX Oslash W -30\r\nKPX Oslash X -60\r\nKPX Oslash Y -70\r\nKPX Oslash Yacute -70\r\nKPX Oslash Ydieresis -70\r\nKPX Oslash comma -40\r\nKPX Oslash period -40\r\nKPX Otilde A -20\r\nKPX Otilde Aacute -20\r\nKPX Otilde Abreve -20\r\nKPX Otilde Acircumflex -20\r\nKPX Otilde Adieresis -20\r\nKPX Otilde Agrave -20\r\nKPX Otilde Amacron -20\r\nKPX Otilde Aogonek -20\r\nKPX Otilde Aring -20\r\nKPX Otilde Atilde -20\r\nKPX Otilde T -40\r\nKPX Otilde Tcaron -40\r\nKPX Otilde Tcommaaccent -40\r\nKPX Otilde V -50\r\nKPX Otilde W -30\r\nKPX Otilde X -60\r\nKPX Otilde Y -70\r\nKPX Otilde Yacute -70\r\nKPX Otilde Ydieresis -70\r\nKPX Otilde comma -40\r\nKPX Otilde period -40\r\nKPX P A -120\r\nKPX P Aacute -120\r\nKPX P Abreve -120\r\nKPX P Acircumflex -120\r\nKPX P Adieresis -120\r\nKPX P Agrave -120\r\nKPX P Amacron -120\r\nKPX P Aogonek -120\r\nKPX P Aring -120\r\nKPX P Atilde -120\r\nKPX P a -40\r\nKPX P aacute -40\r\nKPX P abreve -40\r\nKPX P acircumflex -40\r\nKPX P adieresis -40\r\nKPX P agrave -40\r\nKPX P amacron -40\r\nKPX P aogonek -40\r\nKPX P aring -40\r\nKPX P atilde -40\r\nKPX P comma -180\r\nKPX P e -50\r\nKPX P eacute -50\r\nKPX P ecaron -50\r\nKPX P ecircumflex -50\r\nKPX P edieresis -50\r\nKPX P edotaccent -50\r\nKPX P egrave -50\r\nKPX P emacron -50\r\nKPX P eogonek -50\r\nKPX P o -50\r\nKPX P oacute -50\r\nKPX P ocircumflex -50\r\nKPX P odieresis -50\r\nKPX P ograve -50\r\nKPX P ohungarumlaut -50\r\nKPX P omacron -50\r\nKPX P oslash -50\r\nKPX P otilde -50\r\nKPX P period -180\r\nKPX Q U -10\r\nKPX Q Uacute -10\r\nKPX Q Ucircumflex -10\r\nKPX Q Udieresis -10\r\nKPX Q Ugrave -10\r\nKPX Q Uhungarumlaut -10\r\nKPX Q Umacron -10\r\nKPX Q Uogonek -10\r\nKPX Q Uring -10\r\nKPX R O -20\r\nKPX R Oacute -20\r\nKPX R Ocircumflex -20\r\nKPX R Odieresis -20\r\nKPX R Ograve -20\r\nKPX R Ohungarumlaut -20\r\nKPX R Omacron -20\r\nKPX R Oslash -20\r\nKPX R Otilde -20\r\nKPX R T -30\r\nKPX R Tcaron -30\r\nKPX R Tcommaaccent -30\r\nKPX R U -40\r\nKPX R Uacute -40\r\nKPX R Ucircumflex -40\r\nKPX R Udieresis -40\r\nKPX R Ugrave -40\r\nKPX R Uhungarumlaut -40\r\nKPX R Umacron -40\r\nKPX R Uogonek -40\r\nKPX R Uring -40\r\nKPX R V -50\r\nKPX R W -30\r\nKPX R Y -50\r\nKPX R Yacute -50\r\nKPX R Ydieresis -50\r\nKPX Racute O -20\r\nKPX Racute Oacute -20\r\nKPX Racute Ocircumflex -20\r\nKPX Racute Odieresis -20\r\nKPX Racute Ograve -20\r\nKPX Racute Ohungarumlaut -20\r\nKPX Racute Omacron -20\r\nKPX Racute Oslash -20\r\nKPX Racute Otilde -20\r\nKPX Racute T -30\r\nKPX Racute Tcaron -30\r\nKPX Racute Tcommaaccent -30\r\nKPX Racute U -40\r\nKPX Racute Uacute -40\r\nKPX Racute Ucircumflex -40\r\nKPX Racute Udieresis -40\r\nKPX Racute Ugrave -40\r\nKPX Racute Uhungarumlaut -40\r\nKPX Racute Umacron -40\r\nKPX Racute Uogonek -40\r\nKPX Racute Uring -40\r\nKPX Racute V -50\r\nKPX Racute W -30\r\nKPX Racute Y -50\r\nKPX Racute Yacute -50\r\nKPX Racute Ydieresis -50\r\nKPX Rcaron O -20\r\nKPX Rcaron Oacute -20\r\nKPX Rcaron Ocircumflex -20\r\nKPX Rcaron Odieresis -20\r\nKPX Rcaron Ograve -20\r\nKPX Rcaron Ohungarumlaut -20\r\nKPX Rcaron Omacron -20\r\nKPX Rcaron Oslash -20\r\nKPX Rcaron Otilde -20\r\nKPX Rcaron T -30\r\nKPX Rcaron Tcaron -30\r\nKPX Rcaron Tcommaaccent -30\r\nKPX Rcaron U -40\r\nKPX Rcaron Uacute -40\r\nKPX Rcaron Ucircumflex -40\r\nKPX Rcaron Udieresis -40\r\nKPX Rcaron Ugrave -40\r\nKPX Rcaron Uhungarumlaut -40\r\nKPX Rcaron Umacron -40\r\nKPX Rcaron Uogonek -40\r\nKPX Rcaron Uring -40\r\nKPX Rcaron V -50\r\nKPX Rcaron W -30\r\nKPX Rcaron Y -50\r\nKPX Rcaron Yacute -50\r\nKPX Rcaron Ydieresis -50\r\nKPX Rcommaaccent O -20\r\nKPX Rcommaaccent Oacute -20\r\nKPX Rcommaaccent Ocircumflex -20\r\nKPX Rcommaaccent Odieresis -20\r\nKPX Rcommaaccent Ograve -20\r\nKPX Rcommaaccent Ohungarumlaut -20\r\nKPX Rcommaaccent Omacron -20\r\nKPX Rcommaaccent Oslash -20\r\nKPX Rcommaaccent Otilde -20\r\nKPX Rcommaaccent T -30\r\nKPX Rcommaaccent Tcaron -30\r\nKPX Rcommaaccent Tcommaaccent -30\r\nKPX Rcommaaccent U -40\r\nKPX Rcommaaccent Uacute -40\r\nKPX Rcommaaccent Ucircumflex -40\r\nKPX Rcommaaccent Udieresis -40\r\nKPX Rcommaaccent Ugrave -40\r\nKPX Rcommaaccent Uhungarumlaut -40\r\nKPX Rcommaaccent Umacron -40\r\nKPX Rcommaaccent Uogonek -40\r\nKPX Rcommaaccent Uring -40\r\nKPX Rcommaaccent V -50\r\nKPX Rcommaaccent W -30\r\nKPX Rcommaaccent Y -50\r\nKPX Rcommaaccent Yacute -50\r\nKPX Rcommaaccent Ydieresis -50\r\nKPX S comma -20\r\nKPX S period -20\r\nKPX Sacute comma -20\r\nKPX Sacute period -20\r\nKPX Scaron comma -20\r\nKPX Scaron period -20\r\nKPX Scedilla comma -20\r\nKPX Scedilla period -20\r\nKPX Scommaaccent comma -20\r\nKPX Scommaaccent period -20\r\nKPX T A -120\r\nKPX T Aacute -120\r\nKPX T Abreve -120\r\nKPX T Acircumflex -120\r\nKPX T Adieresis -120\r\nKPX T Agrave -120\r\nKPX T Amacron -120\r\nKPX T Aogonek -120\r\nKPX T Aring -120\r\nKPX T Atilde -120\r\nKPX T O -40\r\nKPX T Oacute -40\r\nKPX T Ocircumflex -40\r\nKPX T Odieresis -40\r\nKPX T Ograve -40\r\nKPX T Ohungarumlaut -40\r\nKPX T Omacron -40\r\nKPX T Oslash -40\r\nKPX T Otilde -40\r\nKPX T a -120\r\nKPX T aacute -120\r\nKPX T abreve -60\r\nKPX T acircumflex -120\r\nKPX T adieresis -120\r\nKPX T agrave -120\r\nKPX T amacron -60\r\nKPX T aogonek -120\r\nKPX T aring -120\r\nKPX T atilde -60\r\nKPX T colon -20\r\nKPX T comma -120\r\nKPX T e -120\r\nKPX T eacute -120\r\nKPX T ecaron -120\r\nKPX T ecircumflex -120\r\nKPX T edieresis -120\r\nKPX T edotaccent -120\r\nKPX T egrave -60\r\nKPX T emacron -60\r\nKPX T eogonek -120\r\nKPX T hyphen -140\r\nKPX T o -120\r\nKPX T oacute -120\r\nKPX T ocircumflex -120\r\nKPX T odieresis -120\r\nKPX T ograve -120\r\nKPX T ohungarumlaut -120\r\nKPX T omacron -60\r\nKPX T oslash -120\r\nKPX T otilde -60\r\nKPX T period -120\r\nKPX T r -120\r\nKPX T racute -120\r\nKPX T rcaron -120\r\nKPX T rcommaaccent -120\r\nKPX T semicolon -20\r\nKPX T u -120\r\nKPX T uacute -120\r\nKPX T ucircumflex -120\r\nKPX T udieresis -120\r\nKPX T ugrave -120\r\nKPX T uhungarumlaut -120\r\nKPX T umacron -60\r\nKPX T uogonek -120\r\nKPX T uring -120\r\nKPX T w -120\r\nKPX T y -120\r\nKPX T yacute -120\r\nKPX T ydieresis -60\r\nKPX Tcaron A -120\r\nKPX Tcaron Aacute -120\r\nKPX Tcaron Abreve -120\r\nKPX Tcaron Acircumflex -120\r\nKPX Tcaron Adieresis -120\r\nKPX Tcaron Agrave -120\r\nKPX Tcaron Amacron -120\r\nKPX Tcaron Aogonek -120\r\nKPX Tcaron Aring -120\r\nKPX Tcaron Atilde -120\r\nKPX Tcaron O -40\r\nKPX Tcaron Oacute -40\r\nKPX Tcaron Ocircumflex -40\r\nKPX Tcaron Odieresis -40\r\nKPX Tcaron Ograve -40\r\nKPX Tcaron Ohungarumlaut -40\r\nKPX Tcaron Omacron -40\r\nKPX Tcaron Oslash -40\r\nKPX Tcaron Otilde -40\r\nKPX Tcaron a -120\r\nKPX Tcaron aacute -120\r\nKPX Tcaron abreve -60\r\nKPX Tcaron acircumflex -120\r\nKPX Tcaron adieresis -120\r\nKPX Tcaron agrave -120\r\nKPX Tcaron amacron -60\r\nKPX Tcaron aogonek -120\r\nKPX Tcaron aring -120\r\nKPX Tcaron atilde -60\r\nKPX Tcaron colon -20\r\nKPX Tcaron comma -120\r\nKPX Tcaron e -120\r\nKPX Tcaron eacute -120\r\nKPX Tcaron ecaron -120\r\nKPX Tcaron ecircumflex -120\r\nKPX Tcaron edieresis -120\r\nKPX Tcaron edotaccent -120\r\nKPX Tcaron egrave -60\r\nKPX Tcaron emacron -60\r\nKPX Tcaron eogonek -120\r\nKPX Tcaron hyphen -140\r\nKPX Tcaron o -120\r\nKPX Tcaron oacute -120\r\nKPX Tcaron ocircumflex -120\r\nKPX Tcaron odieresis -120\r\nKPX Tcaron ograve -120\r\nKPX Tcaron ohungarumlaut -120\r\nKPX Tcaron omacron -60\r\nKPX Tcaron oslash -120\r\nKPX Tcaron otilde -60\r\nKPX Tcaron period -120\r\nKPX Tcaron r -120\r\nKPX Tcaron racute -120\r\nKPX Tcaron rcaron -120\r\nKPX Tcaron rcommaaccent -120\r\nKPX Tcaron semicolon -20\r\nKPX Tcaron u -120\r\nKPX Tcaron uacute -120\r\nKPX Tcaron ucircumflex -120\r\nKPX Tcaron udieresis -120\r\nKPX Tcaron ugrave -120\r\nKPX Tcaron uhungarumlaut -120\r\nKPX Tcaron umacron -60\r\nKPX Tcaron uogonek -120\r\nKPX Tcaron uring -120\r\nKPX Tcaron w -120\r\nKPX Tcaron y -120\r\nKPX Tcaron yacute -120\r\nKPX Tcaron ydieresis -60\r\nKPX Tcommaaccent A -120\r\nKPX Tcommaaccent Aacute -120\r\nKPX Tcommaaccent Abreve -120\r\nKPX Tcommaaccent Acircumflex -120\r\nKPX Tcommaaccent Adieresis -120\r\nKPX Tcommaaccent Agrave -120\r\nKPX Tcommaaccent Amacron -120\r\nKPX Tcommaaccent Aogonek -120\r\nKPX Tcommaaccent Aring -120\r\nKPX Tcommaaccent Atilde -120\r\nKPX Tcommaaccent O -40\r\nKPX Tcommaaccent Oacute -40\r\nKPX Tcommaaccent Ocircumflex -40\r\nKPX Tcommaaccent Odieresis -40\r\nKPX Tcommaaccent Ograve -40\r\nKPX Tcommaaccent Ohungarumlaut -40\r\nKPX Tcommaaccent Omacron -40\r\nKPX Tcommaaccent Oslash -40\r\nKPX Tcommaaccent Otilde -40\r\nKPX Tcommaaccent a -120\r\nKPX Tcommaaccent aacute -120\r\nKPX Tcommaaccent abreve -60\r\nKPX Tcommaaccent acircumflex -120\r\nKPX Tcommaaccent adieresis -120\r\nKPX Tcommaaccent agrave -120\r\nKPX Tcommaaccent amacron -60\r\nKPX Tcommaaccent aogonek -120\r\nKPX Tcommaaccent aring -120\r\nKPX Tcommaaccent atilde -60\r\nKPX Tcommaaccent colon -20\r\nKPX Tcommaaccent comma -120\r\nKPX Tcommaaccent e -120\r\nKPX Tcommaaccent eacute -120\r\nKPX Tcommaaccent ecaron -120\r\nKPX Tcommaaccent ecircumflex -120\r\nKPX Tcommaaccent edieresis -120\r\nKPX Tcommaaccent edotaccent -120\r\nKPX Tcommaaccent egrave -60\r\nKPX Tcommaaccent emacron -60\r\nKPX Tcommaaccent eogonek -120\r\nKPX Tcommaaccent hyphen -140\r\nKPX Tcommaaccent o -120\r\nKPX Tcommaaccent oacute -120\r\nKPX Tcommaaccent ocircumflex -120\r\nKPX Tcommaaccent odieresis -120\r\nKPX Tcommaaccent ograve -120\r\nKPX Tcommaaccent ohungarumlaut -120\r\nKPX Tcommaaccent omacron -60\r\nKPX Tcommaaccent oslash -120\r\nKPX Tcommaaccent otilde -60\r\nKPX Tcommaaccent period -120\r\nKPX Tcommaaccent r -120\r\nKPX Tcommaaccent racute -120\r\nKPX Tcommaaccent rcaron -120\r\nKPX Tcommaaccent rcommaaccent -120\r\nKPX Tcommaaccent semicolon -20\r\nKPX Tcommaaccent u -120\r\nKPX Tcommaaccent uacute -120\r\nKPX Tcommaaccent ucircumflex -120\r\nKPX Tcommaaccent udieresis -120\r\nKPX Tcommaaccent ugrave -120\r\nKPX Tcommaaccent uhungarumlaut -120\r\nKPX Tcommaaccent umacron -60\r\nKPX Tcommaaccent uogonek -120\r\nKPX Tcommaaccent uring -120\r\nKPX Tcommaaccent w -120\r\nKPX Tcommaaccent y -120\r\nKPX Tcommaaccent yacute -120\r\nKPX Tcommaaccent ydieresis -60\r\nKPX U A -40\r\nKPX U Aacute -40\r\nKPX U Abreve -40\r\nKPX U Acircumflex -40\r\nKPX U Adieresis -40\r\nKPX U Agrave -40\r\nKPX U Amacron -40\r\nKPX U Aogonek -40\r\nKPX U Aring -40\r\nKPX U Atilde -40\r\nKPX U comma -40\r\nKPX U period -40\r\nKPX Uacute A -40\r\nKPX Uacute Aacute -40\r\nKPX Uacute Abreve -40\r\nKPX Uacute Acircumflex -40\r\nKPX Uacute Adieresis -40\r\nKPX Uacute Agrave -40\r\nKPX Uacute Amacron -40\r\nKPX Uacute Aogonek -40\r\nKPX Uacute Aring -40\r\nKPX Uacute Atilde -40\r\nKPX Uacute comma -40\r\nKPX Uacute period -40\r\nKPX Ucircumflex A -40\r\nKPX Ucircumflex Aacute -40\r\nKPX Ucircumflex Abreve -40\r\nKPX Ucircumflex Acircumflex -40\r\nKPX Ucircumflex Adieresis -40\r\nKPX Ucircumflex Agrave -40\r\nKPX Ucircumflex Amacron -40\r\nKPX Ucircumflex Aogonek -40\r\nKPX Ucircumflex Aring -40\r\nKPX Ucircumflex Atilde -40\r\nKPX Ucircumflex comma -40\r\nKPX Ucircumflex period -40\r\nKPX Udieresis A -40\r\nKPX Udieresis Aacute -40\r\nKPX Udieresis Abreve -40\r\nKPX Udieresis Acircumflex -40\r\nKPX Udieresis Adieresis -40\r\nKPX Udieresis Agrave -40\r\nKPX Udieresis Amacron -40\r\nKPX Udieresis Aogonek -40\r\nKPX Udieresis Aring -40\r\nKPX Udieresis Atilde -40\r\nKPX Udieresis comma -40\r\nKPX Udieresis period -40\r\nKPX Ugrave A -40\r\nKPX Ugrave Aacute -40\r\nKPX Ugrave Abreve -40\r\nKPX Ugrave Acircumflex -40\r\nKPX Ugrave Adieresis -40\r\nKPX Ugrave Agrave -40\r\nKPX Ugrave Amacron -40\r\nKPX Ugrave Aogonek -40\r\nKPX Ugrave Aring -40\r\nKPX Ugrave Atilde -40\r\nKPX Ugrave comma -40\r\nKPX Ugrave period -40\r\nKPX Uhungarumlaut A -40\r\nKPX Uhungarumlaut Aacute -40\r\nKPX Uhungarumlaut Abreve -40\r\nKPX Uhungarumlaut Acircumflex -40\r\nKPX Uhungarumlaut Adieresis -40\r\nKPX Uhungarumlaut Agrave -40\r\nKPX Uhungarumlaut Amacron -40\r\nKPX Uhungarumlaut Aogonek -40\r\nKPX Uhungarumlaut Aring -40\r\nKPX Uhungarumlaut Atilde -40\r\nKPX Uhungarumlaut comma -40\r\nKPX Uhungarumlaut period -40\r\nKPX Umacron A -40\r\nKPX Umacron Aacute -40\r\nKPX Umacron Abreve -40\r\nKPX Umacron Acircumflex -40\r\nKPX Umacron Adieresis -40\r\nKPX Umacron Agrave -40\r\nKPX Umacron Amacron -40\r\nKPX Umacron Aogonek -40\r\nKPX Umacron Aring -40\r\nKPX Umacron Atilde -40\r\nKPX Umacron comma -40\r\nKPX Umacron period -40\r\nKPX Uogonek A -40\r\nKPX Uogonek Aacute -40\r\nKPX Uogonek Abreve -40\r\nKPX Uogonek Acircumflex -40\r\nKPX Uogonek Adieresis -40\r\nKPX Uogonek Agrave -40\r\nKPX Uogonek Amacron -40\r\nKPX Uogonek Aogonek -40\r\nKPX Uogonek Aring -40\r\nKPX Uogonek Atilde -40\r\nKPX Uogonek comma -40\r\nKPX Uogonek period -40\r\nKPX Uring A -40\r\nKPX Uring Aacute -40\r\nKPX Uring Abreve -40\r\nKPX Uring Acircumflex -40\r\nKPX Uring Adieresis -40\r\nKPX Uring Agrave -40\r\nKPX Uring Amacron -40\r\nKPX Uring Aogonek -40\r\nKPX Uring Aring -40\r\nKPX Uring Atilde -40\r\nKPX Uring comma -40\r\nKPX Uring period -40\r\nKPX V A -80\r\nKPX V Aacute -80\r\nKPX V Abreve -80\r\nKPX V Acircumflex -80\r\nKPX V Adieresis -80\r\nKPX V Agrave -80\r\nKPX V Amacron -80\r\nKPX V Aogonek -80\r\nKPX V Aring -80\r\nKPX V Atilde -80\r\nKPX V G -40\r\nKPX V Gbreve -40\r\nKPX V Gcommaaccent -40\r\nKPX V O -40\r\nKPX V Oacute -40\r\nKPX V Ocircumflex -40\r\nKPX V Odieresis -40\r\nKPX V Ograve -40\r\nKPX V Ohungarumlaut -40\r\nKPX V Omacron -40\r\nKPX V Oslash -40\r\nKPX V Otilde -40\r\nKPX V a -70\r\nKPX V aacute -70\r\nKPX V abreve -70\r\nKPX V acircumflex -70\r\nKPX V adieresis -70\r\nKPX V agrave -70\r\nKPX V amacron -70\r\nKPX V aogonek -70\r\nKPX V aring -70\r\nKPX V atilde -70\r\nKPX V colon -40\r\nKPX V comma -125\r\nKPX V e -80\r\nKPX V eacute -80\r\nKPX V ecaron -80\r\nKPX V ecircumflex -80\r\nKPX V edieresis -80\r\nKPX V edotaccent -80\r\nKPX V egrave -80\r\nKPX V emacron -80\r\nKPX V eogonek -80\r\nKPX V hyphen -80\r\nKPX V o -80\r\nKPX V oacute -80\r\nKPX V ocircumflex -80\r\nKPX V odieresis -80\r\nKPX V ograve -80\r\nKPX V ohungarumlaut -80\r\nKPX V omacron -80\r\nKPX V oslash -80\r\nKPX V otilde -80\r\nKPX V period -125\r\nKPX V semicolon -40\r\nKPX V u -70\r\nKPX V uacute -70\r\nKPX V ucircumflex -70\r\nKPX V udieresis -70\r\nKPX V ugrave -70\r\nKPX V uhungarumlaut -70\r\nKPX V umacron -70\r\nKPX V uogonek -70\r\nKPX V uring -70\r\nKPX W A -50\r\nKPX W Aacute -50\r\nKPX W Abreve -50\r\nKPX W Acircumflex -50\r\nKPX W Adieresis -50\r\nKPX W Agrave -50\r\nKPX W Amacron -50\r\nKPX W Aogonek -50\r\nKPX W Aring -50\r\nKPX W Atilde -50\r\nKPX W O -20\r\nKPX W Oacute -20\r\nKPX W Ocircumflex -20\r\nKPX W Odieresis -20\r\nKPX W Ograve -20\r\nKPX W Ohungarumlaut -20\r\nKPX W Omacron -20\r\nKPX W Oslash -20\r\nKPX W Otilde -20\r\nKPX W a -40\r\nKPX W aacute -40\r\nKPX W abreve -40\r\nKPX W acircumflex -40\r\nKPX W adieresis -40\r\nKPX W agrave -40\r\nKPX W amacron -40\r\nKPX W aogonek -40\r\nKPX W aring -40\r\nKPX W atilde -40\r\nKPX W comma -80\r\nKPX W e -30\r\nKPX W eacute -30\r\nKPX W ecaron -30\r\nKPX W ecircumflex -30\r\nKPX W edieresis -30\r\nKPX W edotaccent -30\r\nKPX W egrave -30\r\nKPX W emacron -30\r\nKPX W eogonek -30\r\nKPX W hyphen -40\r\nKPX W o -30\r\nKPX W oacute -30\r\nKPX W ocircumflex -30\r\nKPX W odieresis -30\r\nKPX W ograve -30\r\nKPX W ohungarumlaut -30\r\nKPX W omacron -30\r\nKPX W oslash -30\r\nKPX W otilde -30\r\nKPX W period -80\r\nKPX W u -30\r\nKPX W uacute -30\r\nKPX W ucircumflex -30\r\nKPX W udieresis -30\r\nKPX W ugrave -30\r\nKPX W uhungarumlaut -30\r\nKPX W umacron -30\r\nKPX W uogonek -30\r\nKPX W uring -30\r\nKPX W y -20\r\nKPX W yacute -20\r\nKPX W ydieresis -20\r\nKPX Y A -110\r\nKPX Y Aacute -110\r\nKPX Y Abreve -110\r\nKPX Y Acircumflex -110\r\nKPX Y Adieresis -110\r\nKPX Y Agrave -110\r\nKPX Y Amacron -110\r\nKPX Y Aogonek -110\r\nKPX Y Aring -110\r\nKPX Y Atilde -110\r\nKPX Y O -85\r\nKPX Y Oacute -85\r\nKPX Y Ocircumflex -85\r\nKPX Y Odieresis -85\r\nKPX Y Ograve -85\r\nKPX Y Ohungarumlaut -85\r\nKPX Y Omacron -85\r\nKPX Y Oslash -85\r\nKPX Y Otilde -85\r\nKPX Y a -140\r\nKPX Y aacute -140\r\nKPX Y abreve -70\r\nKPX Y acircumflex -140\r\nKPX Y adieresis -140\r\nKPX Y agrave -140\r\nKPX Y amacron -70\r\nKPX Y aogonek -140\r\nKPX Y aring -140\r\nKPX Y atilde -140\r\nKPX Y colon -60\r\nKPX Y comma -140\r\nKPX Y e -140\r\nKPX Y eacute -140\r\nKPX Y ecaron -140\r\nKPX Y ecircumflex -140\r\nKPX Y edieresis -140\r\nKPX Y edotaccent -140\r\nKPX Y egrave -140\r\nKPX Y emacron -70\r\nKPX Y eogonek -140\r\nKPX Y hyphen -140\r\nKPX Y i -20\r\nKPX Y iacute -20\r\nKPX Y iogonek -20\r\nKPX Y o -140\r\nKPX Y oacute -140\r\nKPX Y ocircumflex -140\r\nKPX Y odieresis -140\r\nKPX Y ograve -140\r\nKPX Y ohungarumlaut -140\r\nKPX Y omacron -140\r\nKPX Y oslash -140\r\nKPX Y otilde -140\r\nKPX Y period -140\r\nKPX Y semicolon -60\r\nKPX Y u -110\r\nKPX Y uacute -110\r\nKPX Y ucircumflex -110\r\nKPX Y udieresis -110\r\nKPX Y ugrave -110\r\nKPX Y uhungarumlaut -110\r\nKPX Y umacron -110\r\nKPX Y uogonek -110\r\nKPX Y uring -110\r\nKPX Yacute A -110\r\nKPX Yacute Aacute -110\r\nKPX Yacute Abreve -110\r\nKPX Yacute Acircumflex -110\r\nKPX Yacute Adieresis -110\r\nKPX Yacute Agrave -110\r\nKPX Yacute Amacron -110\r\nKPX Yacute Aogonek -110\r\nKPX Yacute Aring -110\r\nKPX Yacute Atilde -110\r\nKPX Yacute O -85\r\nKPX Yacute Oacute -85\r\nKPX Yacute Ocircumflex -85\r\nKPX Yacute Odieresis -85\r\nKPX Yacute Ograve -85\r\nKPX Yacute Ohungarumlaut -85\r\nKPX Yacute Omacron -85\r\nKPX Yacute Oslash -85\r\nKPX Yacute Otilde -85\r\nKPX Yacute a -140\r\nKPX Yacute aacute -140\r\nKPX Yacute abreve -70\r\nKPX Yacute acircumflex -140\r\nKPX Yacute adieresis -140\r\nKPX Yacute agrave -140\r\nKPX Yacute amacron -70\r\nKPX Yacute aogonek -140\r\nKPX Yacute aring -140\r\nKPX Yacute atilde -70\r\nKPX Yacute colon -60\r\nKPX Yacute comma -140\r\nKPX Yacute e -140\r\nKPX Yacute eacute -140\r\nKPX Yacute ecaron -140\r\nKPX Yacute ecircumflex -140\r\nKPX Yacute edieresis -140\r\nKPX Yacute edotaccent -140\r\nKPX Yacute egrave -140\r\nKPX Yacute emacron -70\r\nKPX Yacute eogonek -140\r\nKPX Yacute hyphen -140\r\nKPX Yacute i -20\r\nKPX Yacute iacute -20\r\nKPX Yacute iogonek -20\r\nKPX Yacute o -140\r\nKPX Yacute oacute -140\r\nKPX Yacute ocircumflex -140\r\nKPX Yacute odieresis -140\r\nKPX Yacute ograve -140\r\nKPX Yacute ohungarumlaut -140\r\nKPX Yacute omacron -70\r\nKPX Yacute oslash -140\r\nKPX Yacute otilde -140\r\nKPX Yacute period -140\r\nKPX Yacute semicolon -60\r\nKPX Yacute u -110\r\nKPX Yacute uacute -110\r\nKPX Yacute ucircumflex -110\r\nKPX Yacute udieresis -110\r\nKPX Yacute ugrave -110\r\nKPX Yacute uhungarumlaut -110\r\nKPX Yacute umacron -110\r\nKPX Yacute uogonek -110\r\nKPX Yacute uring -110\r\nKPX Ydieresis A -110\r\nKPX Ydieresis Aacute -110\r\nKPX Ydieresis Abreve -110\r\nKPX Ydieresis Acircumflex -110\r\nKPX Ydieresis Adieresis -110\r\nKPX Ydieresis Agrave -110\r\nKPX Ydieresis Amacron -110\r\nKPX Ydieresis Aogonek -110\r\nKPX Ydieresis Aring -110\r\nKPX Ydieresis Atilde -110\r\nKPX Ydieresis O -85\r\nKPX Ydieresis Oacute -85\r\nKPX Ydieresis Ocircumflex -85\r\nKPX Ydieresis Odieresis -85\r\nKPX Ydieresis Ograve -85\r\nKPX Ydieresis Ohungarumlaut -85\r\nKPX Ydieresis Omacron -85\r\nKPX Ydieresis Oslash -85\r\nKPX Ydieresis Otilde -85\r\nKPX Ydieresis a -140\r\nKPX Ydieresis aacute -140\r\nKPX Ydieresis abreve -70\r\nKPX Ydieresis acircumflex -140\r\nKPX Ydieresis adieresis -140\r\nKPX Ydieresis agrave -140\r\nKPX Ydieresis amacron -70\r\nKPX Ydieresis aogonek -140\r\nKPX Ydieresis aring -140\r\nKPX Ydieresis atilde -70\r\nKPX Ydieresis colon -60\r\nKPX Ydieresis comma -140\r\nKPX Ydieresis e -140\r\nKPX Ydieresis eacute -140\r\nKPX Ydieresis ecaron -140\r\nKPX Ydieresis ecircumflex -140\r\nKPX Ydieresis edieresis -140\r\nKPX Ydieresis edotaccent -140\r\nKPX Ydieresis egrave -140\r\nKPX Ydieresis emacron -70\r\nKPX Ydieresis eogonek -140\r\nKPX Ydieresis hyphen -140\r\nKPX Ydieresis i -20\r\nKPX Ydieresis iacute -20\r\nKPX Ydieresis iogonek -20\r\nKPX Ydieresis o -140\r\nKPX Ydieresis oacute -140\r\nKPX Ydieresis ocircumflex -140\r\nKPX Ydieresis odieresis -140\r\nKPX Ydieresis ograve -140\r\nKPX Ydieresis ohungarumlaut -140\r\nKPX Ydieresis omacron -140\r\nKPX Ydieresis oslash -140\r\nKPX Ydieresis otilde -140\r\nKPX Ydieresis period -140\r\nKPX Ydieresis semicolon -60\r\nKPX Ydieresis u -110\r\nKPX Ydieresis uacute -110\r\nKPX Ydieresis ucircumflex -110\r\nKPX Ydieresis udieresis -110\r\nKPX Ydieresis ugrave -110\r\nKPX Ydieresis uhungarumlaut -110\r\nKPX Ydieresis umacron -110\r\nKPX Ydieresis uogonek -110\r\nKPX Ydieresis uring -110\r\nKPX a v -20\r\nKPX a w -20\r\nKPX a y -30\r\nKPX a yacute -30\r\nKPX a ydieresis -30\r\nKPX aacute v -20\r\nKPX aacute w -20\r\nKPX aacute y -30\r\nKPX aacute yacute -30\r\nKPX aacute ydieresis -30\r\nKPX abreve v -20\r\nKPX abreve w -20\r\nKPX abreve y -30\r\nKPX abreve yacute -30\r\nKPX abreve ydieresis -30\r\nKPX acircumflex v -20\r\nKPX acircumflex w -20\r\nKPX acircumflex y -30\r\nKPX acircumflex yacute -30\r\nKPX acircumflex ydieresis -30\r\nKPX adieresis v -20\r\nKPX adieresis w -20\r\nKPX adieresis y -30\r\nKPX adieresis yacute -30\r\nKPX adieresis ydieresis -30\r\nKPX agrave v -20\r\nKPX agrave w -20\r\nKPX agrave y -30\r\nKPX agrave yacute -30\r\nKPX agrave ydieresis -30\r\nKPX amacron v -20\r\nKPX amacron w -20\r\nKPX amacron y -30\r\nKPX amacron yacute -30\r\nKPX amacron ydieresis -30\r\nKPX aogonek v -20\r\nKPX aogonek w -20\r\nKPX aogonek y -30\r\nKPX aogonek yacute -30\r\nKPX aogonek ydieresis -30\r\nKPX aring v -20\r\nKPX aring w -20\r\nKPX aring y -30\r\nKPX aring yacute -30\r\nKPX aring ydieresis -30\r\nKPX atilde v -20\r\nKPX atilde w -20\r\nKPX atilde y -30\r\nKPX atilde yacute -30\r\nKPX atilde ydieresis -30\r\nKPX b b -10\r\nKPX b comma -40\r\nKPX b l -20\r\nKPX b lacute -20\r\nKPX b lcommaaccent -20\r\nKPX b lslash -20\r\nKPX b period -40\r\nKPX b u -20\r\nKPX b uacute -20\r\nKPX b ucircumflex -20\r\nKPX b udieresis -20\r\nKPX b ugrave -20\r\nKPX b uhungarumlaut -20\r\nKPX b umacron -20\r\nKPX b uogonek -20\r\nKPX b uring -20\r\nKPX b v -20\r\nKPX b y -20\r\nKPX b yacute -20\r\nKPX b ydieresis -20\r\nKPX c comma -15\r\nKPX c k -20\r\nKPX c kcommaaccent -20\r\nKPX cacute comma -15\r\nKPX cacute k -20\r\nKPX cacute kcommaaccent -20\r\nKPX ccaron comma -15\r\nKPX ccaron k -20\r\nKPX ccaron kcommaaccent -20\r\nKPX ccedilla comma -15\r\nKPX ccedilla k -20\r\nKPX ccedilla kcommaaccent -20\r\nKPX colon space -50\r\nKPX comma quotedblright -100\r\nKPX comma quoteright -100\r\nKPX e comma -15\r\nKPX e period -15\r\nKPX e v -30\r\nKPX e w -20\r\nKPX e x -30\r\nKPX e y -20\r\nKPX e yacute -20\r\nKPX e ydieresis -20\r\nKPX eacute comma -15\r\nKPX eacute period -15\r\nKPX eacute v -30\r\nKPX eacute w -20\r\nKPX eacute x -30\r\nKPX eacute y -20\r\nKPX eacute yacute -20\r\nKPX eacute ydieresis -20\r\nKPX ecaron comma -15\r\nKPX ecaron period -15\r\nKPX ecaron v -30\r\nKPX ecaron w -20\r\nKPX ecaron x -30\r\nKPX ecaron y -20\r\nKPX ecaron yacute -20\r\nKPX ecaron ydieresis -20\r\nKPX ecircumflex comma -15\r\nKPX ecircumflex period -15\r\nKPX ecircumflex v -30\r\nKPX ecircumflex w -20\r\nKPX ecircumflex x -30\r\nKPX ecircumflex y -20\r\nKPX ecircumflex yacute -20\r\nKPX ecircumflex ydieresis -20\r\nKPX edieresis comma -15\r\nKPX edieresis period -15\r\nKPX edieresis v -30\r\nKPX edieresis w -20\r\nKPX edieresis x -30\r\nKPX edieresis y -20\r\nKPX edieresis yacute -20\r\nKPX edieresis ydieresis -20\r\nKPX edotaccent comma -15\r\nKPX edotaccent period -15\r\nKPX edotaccent v -30\r\nKPX edotaccent w -20\r\nKPX edotaccent x -30\r\nKPX edotaccent y -20\r\nKPX edotaccent yacute -20\r\nKPX edotaccent ydieresis -20\r\nKPX egrave comma -15\r\nKPX egrave period -15\r\nKPX egrave v -30\r\nKPX egrave w -20\r\nKPX egrave x -30\r\nKPX egrave y -20\r\nKPX egrave yacute -20\r\nKPX egrave ydieresis -20\r\nKPX emacron comma -15\r\nKPX emacron period -15\r\nKPX emacron v -30\r\nKPX emacron w -20\r\nKPX emacron x -30\r\nKPX emacron y -20\r\nKPX emacron yacute -20\r\nKPX emacron ydieresis -20\r\nKPX eogonek comma -15\r\nKPX eogonek period -15\r\nKPX eogonek v -30\r\nKPX eogonek w -20\r\nKPX eogonek x -30\r\nKPX eogonek y -20\r\nKPX eogonek yacute -20\r\nKPX eogonek ydieresis -20\r\nKPX f a -30\r\nKPX f aacute -30\r\nKPX f abreve -30\r\nKPX f acircumflex -30\r\nKPX f adieresis -30\r\nKPX f agrave -30\r\nKPX f amacron -30\r\nKPX f aogonek -30\r\nKPX f aring -30\r\nKPX f atilde -30\r\nKPX f comma -30\r\nKPX f dotlessi -28\r\nKPX f e -30\r\nKPX f eacute -30\r\nKPX f ecaron -30\r\nKPX f ecircumflex -30\r\nKPX f edieresis -30\r\nKPX f edotaccent -30\r\nKPX f egrave -30\r\nKPX f emacron -30\r\nKPX f eogonek -30\r\nKPX f o -30\r\nKPX f oacute -30\r\nKPX f ocircumflex -30\r\nKPX f odieresis -30\r\nKPX f ograve -30\r\nKPX f ohungarumlaut -30\r\nKPX f omacron -30\r\nKPX f oslash -30\r\nKPX f otilde -30\r\nKPX f period -30\r\nKPX f quotedblright 60\r\nKPX f quoteright 50\r\nKPX g r -10\r\nKPX g racute -10\r\nKPX g rcaron -10\r\nKPX g rcommaaccent -10\r\nKPX gbreve r -10\r\nKPX gbreve racute -10\r\nKPX gbreve rcaron -10\r\nKPX gbreve rcommaaccent -10\r\nKPX gcommaaccent r -10\r\nKPX gcommaaccent racute -10\r\nKPX gcommaaccent rcaron -10\r\nKPX gcommaaccent rcommaaccent -10\r\nKPX h y -30\r\nKPX h yacute -30\r\nKPX h ydieresis -30\r\nKPX k e -20\r\nKPX k eacute -20\r\nKPX k ecaron -20\r\nKPX k ecircumflex -20\r\nKPX k edieresis -20\r\nKPX k edotaccent -20\r\nKPX k egrave -20\r\nKPX k emacron -20\r\nKPX k eogonek -20\r\nKPX k o -20\r\nKPX k oacute -20\r\nKPX k ocircumflex -20\r\nKPX k odieresis -20\r\nKPX k ograve -20\r\nKPX k ohungarumlaut -20\r\nKPX k omacron -20\r\nKPX k oslash -20\r\nKPX k otilde -20\r\nKPX kcommaaccent e -20\r\nKPX kcommaaccent eacute -20\r\nKPX kcommaaccent ecaron -20\r\nKPX kcommaaccent ecircumflex -20\r\nKPX kcommaaccent edieresis -20\r\nKPX kcommaaccent edotaccent -20\r\nKPX kcommaaccent egrave -20\r\nKPX kcommaaccent emacron -20\r\nKPX kcommaaccent eogonek -20\r\nKPX kcommaaccent o -20\r\nKPX kcommaaccent oacute -20\r\nKPX kcommaaccent ocircumflex -20\r\nKPX kcommaaccent odieresis -20\r\nKPX kcommaaccent ograve -20\r\nKPX kcommaaccent ohungarumlaut -20\r\nKPX kcommaaccent omacron -20\r\nKPX kcommaaccent oslash -20\r\nKPX kcommaaccent otilde -20\r\nKPX m u -10\r\nKPX m uacute -10\r\nKPX m ucircumflex -10\r\nKPX m udieresis -10\r\nKPX m ugrave -10\r\nKPX m uhungarumlaut -10\r\nKPX m umacron -10\r\nKPX m uogonek -10\r\nKPX m uring -10\r\nKPX m y -15\r\nKPX m yacute -15\r\nKPX m ydieresis -15\r\nKPX n u -10\r\nKPX n uacute -10\r\nKPX n ucircumflex -10\r\nKPX n udieresis -10\r\nKPX n ugrave -10\r\nKPX n uhungarumlaut -10\r\nKPX n umacron -10\r\nKPX n uogonek -10\r\nKPX n uring -10\r\nKPX n v -20\r\nKPX n y -15\r\nKPX n yacute -15\r\nKPX n ydieresis -15\r\nKPX nacute u -10\r\nKPX nacute uacute -10\r\nKPX nacute ucircumflex -10\r\nKPX nacute udieresis -10\r\nKPX nacute ugrave -10\r\nKPX nacute uhungarumlaut -10\r\nKPX nacute umacron -10\r\nKPX nacute uogonek -10\r\nKPX nacute uring -10\r\nKPX nacute v -20\r\nKPX nacute y -15\r\nKPX nacute yacute -15\r\nKPX nacute ydieresis -15\r\nKPX ncaron u -10\r\nKPX ncaron uacute -10\r\nKPX ncaron ucircumflex -10\r\nKPX ncaron udieresis -10\r\nKPX ncaron ugrave -10\r\nKPX ncaron uhungarumlaut -10\r\nKPX ncaron umacron -10\r\nKPX ncaron uogonek -10\r\nKPX ncaron uring -10\r\nKPX ncaron v -20\r\nKPX ncaron y -15\r\nKPX ncaron yacute -15\r\nKPX ncaron ydieresis -15\r\nKPX ncommaaccent u -10\r\nKPX ncommaaccent uacute -10\r\nKPX ncommaaccent ucircumflex -10\r\nKPX ncommaaccent udieresis -10\r\nKPX ncommaaccent ugrave -10\r\nKPX ncommaaccent uhungarumlaut -10\r\nKPX ncommaaccent umacron -10\r\nKPX ncommaaccent uogonek -10\r\nKPX ncommaaccent uring -10\r\nKPX ncommaaccent v -20\r\nKPX ncommaaccent y -15\r\nKPX ncommaaccent yacute -15\r\nKPX ncommaaccent ydieresis -15\r\nKPX ntilde u -10\r\nKPX ntilde uacute -10\r\nKPX ntilde ucircumflex -10\r\nKPX ntilde udieresis -10\r\nKPX ntilde ugrave -10\r\nKPX ntilde uhungarumlaut -10\r\nKPX ntilde umacron -10\r\nKPX ntilde uogonek -10\r\nKPX ntilde uring -10\r\nKPX ntilde v -20\r\nKPX ntilde y -15\r\nKPX ntilde yacute -15\r\nKPX ntilde ydieresis -15\r\nKPX o comma -40\r\nKPX o period -40\r\nKPX o v -15\r\nKPX o w -15\r\nKPX o x -30\r\nKPX o y -30\r\nKPX o yacute -30\r\nKPX o ydieresis -30\r\nKPX oacute comma -40\r\nKPX oacute period -40\r\nKPX oacute v -15\r\nKPX oacute w -15\r\nKPX oacute x -30\r\nKPX oacute y -30\r\nKPX oacute yacute -30\r\nKPX oacute ydieresis -30\r\nKPX ocircumflex comma -40\r\nKPX ocircumflex period -40\r\nKPX ocircumflex v -15\r\nKPX ocircumflex w -15\r\nKPX ocircumflex x -30\r\nKPX ocircumflex y -30\r\nKPX ocircumflex yacute -30\r\nKPX ocircumflex ydieresis -30\r\nKPX odieresis comma -40\r\nKPX odieresis period -40\r\nKPX odieresis v -15\r\nKPX odieresis w -15\r\nKPX odieresis x -30\r\nKPX odieresis y -30\r\nKPX odieresis yacute -30\r\nKPX odieresis ydieresis -30\r\nKPX ograve comma -40\r\nKPX ograve period -40\r\nKPX ograve v -15\r\nKPX ograve w -15\r\nKPX ograve x -30\r\nKPX ograve y -30\r\nKPX ograve yacute -30\r\nKPX ograve ydieresis -30\r\nKPX ohungarumlaut comma -40\r\nKPX ohungarumlaut period -40\r\nKPX ohungarumlaut v -15\r\nKPX ohungarumlaut w -15\r\nKPX ohungarumlaut x -30\r\nKPX ohungarumlaut y -30\r\nKPX ohungarumlaut yacute -30\r\nKPX ohungarumlaut ydieresis -30\r\nKPX omacron comma -40\r\nKPX omacron period -40\r\nKPX omacron v -15\r\nKPX omacron w -15\r\nKPX omacron x -30\r\nKPX omacron y -30\r\nKPX omacron yacute -30\r\nKPX omacron ydieresis -30\r\nKPX oslash a -55\r\nKPX oslash aacute -55\r\nKPX oslash abreve -55\r\nKPX oslash acircumflex -55\r\nKPX oslash adieresis -55\r\nKPX oslash agrave -55\r\nKPX oslash amacron -55\r\nKPX oslash aogonek -55\r\nKPX oslash aring -55\r\nKPX oslash atilde -55\r\nKPX oslash b -55\r\nKPX oslash c -55\r\nKPX oslash cacute -55\r\nKPX oslash ccaron -55\r\nKPX oslash ccedilla -55\r\nKPX oslash comma -95\r\nKPX oslash d -55\r\nKPX oslash dcroat -55\r\nKPX oslash e -55\r\nKPX oslash eacute -55\r\nKPX oslash ecaron -55\r\nKPX oslash ecircumflex -55\r\nKPX oslash edieresis -55\r\nKPX oslash edotaccent -55\r\nKPX oslash egrave -55\r\nKPX oslash emacron -55\r\nKPX oslash eogonek -55\r\nKPX oslash f -55\r\nKPX oslash g -55\r\nKPX oslash gbreve -55\r\nKPX oslash gcommaaccent -55\r\nKPX oslash h -55\r\nKPX oslash i -55\r\nKPX oslash iacute -55\r\nKPX oslash icircumflex -55\r\nKPX oslash idieresis -55\r\nKPX oslash igrave -55\r\nKPX oslash imacron -55\r\nKPX oslash iogonek -55\r\nKPX oslash j -55\r\nKPX oslash k -55\r\nKPX oslash kcommaaccent -55\r\nKPX oslash l -55\r\nKPX oslash lacute -55\r\nKPX oslash lcommaaccent -55\r\nKPX oslash lslash -55\r\nKPX oslash m -55\r\nKPX oslash n -55\r\nKPX oslash nacute -55\r\nKPX oslash ncaron -55\r\nKPX oslash ncommaaccent -55\r\nKPX oslash ntilde -55\r\nKPX oslash o -55\r\nKPX oslash oacute -55\r\nKPX oslash ocircumflex -55\r\nKPX oslash odieresis -55\r\nKPX oslash ograve -55\r\nKPX oslash ohungarumlaut -55\r\nKPX oslash omacron -55\r\nKPX oslash oslash -55\r\nKPX oslash otilde -55\r\nKPX oslash p -55\r\nKPX oslash period -95\r\nKPX oslash q -55\r\nKPX oslash r -55\r\nKPX oslash racute -55\r\nKPX oslash rcaron -55\r\nKPX oslash rcommaaccent -55\r\nKPX oslash s -55\r\nKPX oslash sacute -55\r\nKPX oslash scaron -55\r\nKPX oslash scedilla -55\r\nKPX oslash scommaaccent -55\r\nKPX oslash t -55\r\nKPX oslash tcommaaccent -55\r\nKPX oslash u -55\r\nKPX oslash uacute -55\r\nKPX oslash ucircumflex -55\r\nKPX oslash udieresis -55\r\nKPX oslash ugrave -55\r\nKPX oslash uhungarumlaut -55\r\nKPX oslash umacron -55\r\nKPX oslash uogonek -55\r\nKPX oslash uring -55\r\nKPX oslash v -70\r\nKPX oslash w -70\r\nKPX oslash x -85\r\nKPX oslash y -70\r\nKPX oslash yacute -70\r\nKPX oslash ydieresis -70\r\nKPX oslash z -55\r\nKPX oslash zacute -55\r\nKPX oslash zcaron -55\r\nKPX oslash zdotaccent -55\r\nKPX otilde comma -40\r\nKPX otilde period -40\r\nKPX otilde v -15\r\nKPX otilde w -15\r\nKPX otilde x -30\r\nKPX otilde y -30\r\nKPX otilde yacute -30\r\nKPX otilde ydieresis -30\r\nKPX p comma -35\r\nKPX p period -35\r\nKPX p y -30\r\nKPX p yacute -30\r\nKPX p ydieresis -30\r\nKPX period quotedblright -100\r\nKPX period quoteright -100\r\nKPX period space -60\r\nKPX quotedblright space -40\r\nKPX quoteleft quoteleft -57\r\nKPX quoteright d -50\r\nKPX quoteright dcroat -50\r\nKPX quoteright quoteright -57\r\nKPX quoteright r -50\r\nKPX quoteright racute -50\r\nKPX quoteright rcaron -50\r\nKPX quoteright rcommaaccent -50\r\nKPX quoteright s -50\r\nKPX quoteright sacute -50\r\nKPX quoteright scaron -50\r\nKPX quoteright scedilla -50\r\nKPX quoteright scommaaccent -50\r\nKPX quoteright space -70\r\nKPX r a -10\r\nKPX r aacute -10\r\nKPX r abreve -10\r\nKPX r acircumflex -10\r\nKPX r adieresis -10\r\nKPX r agrave -10\r\nKPX r amacron -10\r\nKPX r aogonek -10\r\nKPX r aring -10\r\nKPX r atilde -10\r\nKPX r colon 30\r\nKPX r comma -50\r\nKPX r i 15\r\nKPX r iacute 15\r\nKPX r icircumflex 15\r\nKPX r idieresis 15\r\nKPX r igrave 15\r\nKPX r imacron 15\r\nKPX r iogonek 15\r\nKPX r k 15\r\nKPX r kcommaaccent 15\r\nKPX r l 15\r\nKPX r lacute 15\r\nKPX r lcommaaccent 15\r\nKPX r lslash 15\r\nKPX r m 25\r\nKPX r n 25\r\nKPX r nacute 25\r\nKPX r ncaron 25\r\nKPX r ncommaaccent 25\r\nKPX r ntilde 25\r\nKPX r p 30\r\nKPX r period -50\r\nKPX r semicolon 30\r\nKPX r t 40\r\nKPX r tcommaaccent 40\r\nKPX r u 15\r\nKPX r uacute 15\r\nKPX r ucircumflex 15\r\nKPX r udieresis 15\r\nKPX r ugrave 15\r\nKPX r uhungarumlaut 15\r\nKPX r umacron 15\r\nKPX r uogonek 15\r\nKPX r uring 15\r\nKPX r v 30\r\nKPX r y 30\r\nKPX r yacute 30\r\nKPX r ydieresis 30\r\nKPX racute a -10\r\nKPX racute aacute -10\r\nKPX racute abreve -10\r\nKPX racute acircumflex -10\r\nKPX racute adieresis -10\r\nKPX racute agrave -10\r\nKPX racute amacron -10\r\nKPX racute aogonek -10\r\nKPX racute aring -10\r\nKPX racute atilde -10\r\nKPX racute colon 30\r\nKPX racute comma -50\r\nKPX racute i 15\r\nKPX racute iacute 15\r\nKPX racute icircumflex 15\r\nKPX racute idieresis 15\r\nKPX racute igrave 15\r\nKPX racute imacron 15\r\nKPX racute iogonek 15\r\nKPX racute k 15\r\nKPX racute kcommaaccent 15\r\nKPX racute l 15\r\nKPX racute lacute 15\r\nKPX racute lcommaaccent 15\r\nKPX racute lslash 15\r\nKPX racute m 25\r\nKPX racute n 25\r\nKPX racute nacute 25\r\nKPX racute ncaron 25\r\nKPX racute ncommaaccent 25\r\nKPX racute ntilde 25\r\nKPX racute p 30\r\nKPX racute period -50\r\nKPX racute semicolon 30\r\nKPX racute t 40\r\nKPX racute tcommaaccent 40\r\nKPX racute u 15\r\nKPX racute uacute 15\r\nKPX racute ucircumflex 15\r\nKPX racute udieresis 15\r\nKPX racute ugrave 15\r\nKPX racute uhungarumlaut 15\r\nKPX racute umacron 15\r\nKPX racute uogonek 15\r\nKPX racute uring 15\r\nKPX racute v 30\r\nKPX racute y 30\r\nKPX racute yacute 30\r\nKPX racute ydieresis 30\r\nKPX rcaron a -10\r\nKPX rcaron aacute -10\r\nKPX rcaron abreve -10\r\nKPX rcaron acircumflex -10\r\nKPX rcaron adieresis -10\r\nKPX rcaron agrave -10\r\nKPX rcaron amacron -10\r\nKPX rcaron aogonek -10\r\nKPX rcaron aring -10\r\nKPX rcaron atilde -10\r\nKPX rcaron colon 30\r\nKPX rcaron comma -50\r\nKPX rcaron i 15\r\nKPX rcaron iacute 15\r\nKPX rcaron icircumflex 15\r\nKPX rcaron idieresis 15\r\nKPX rcaron igrave 15\r\nKPX rcaron imacron 15\r\nKPX rcaron iogonek 15\r\nKPX rcaron k 15\r\nKPX rcaron kcommaaccent 15\r\nKPX rcaron l 15\r\nKPX rcaron lacute 15\r\nKPX rcaron lcommaaccent 15\r\nKPX rcaron lslash 15\r\nKPX rcaron m 25\r\nKPX rcaron n 25\r\nKPX rcaron nacute 25\r\nKPX rcaron ncaron 25\r\nKPX rcaron ncommaaccent 25\r\nKPX rcaron ntilde 25\r\nKPX rcaron p 30\r\nKPX rcaron period -50\r\nKPX rcaron semicolon 30\r\nKPX rcaron t 40\r\nKPX rcaron tcommaaccent 40\r\nKPX rcaron u 15\r\nKPX rcaron uacute 15\r\nKPX rcaron ucircumflex 15\r\nKPX rcaron udieresis 15\r\nKPX rcaron ugrave 15\r\nKPX rcaron uhungarumlaut 15\r\nKPX rcaron umacron 15\r\nKPX rcaron uogonek 15\r\nKPX rcaron uring 15\r\nKPX rcaron v 30\r\nKPX rcaron y 30\r\nKPX rcaron yacute 30\r\nKPX rcaron ydieresis 30\r\nKPX rcommaaccent a -10\r\nKPX rcommaaccent aacute -10\r\nKPX rcommaaccent abreve -10\r\nKPX rcommaaccent acircumflex -10\r\nKPX rcommaaccent adieresis -10\r\nKPX rcommaaccent agrave -10\r\nKPX rcommaaccent amacron -10\r\nKPX rcommaaccent aogonek -10\r\nKPX rcommaaccent aring -10\r\nKPX rcommaaccent atilde -10\r\nKPX rcommaaccent colon 30\r\nKPX rcommaaccent comma -50\r\nKPX rcommaaccent i 15\r\nKPX rcommaaccent iacute 15\r\nKPX rcommaaccent icircumflex 15\r\nKPX rcommaaccent idieresis 15\r\nKPX rcommaaccent igrave 15\r\nKPX rcommaaccent imacron 15\r\nKPX rcommaaccent iogonek 15\r\nKPX rcommaaccent k 15\r\nKPX rcommaaccent kcommaaccent 15\r\nKPX rcommaaccent l 15\r\nKPX rcommaaccent lacute 15\r\nKPX rcommaaccent lcommaaccent 15\r\nKPX rcommaaccent lslash 15\r\nKPX rcommaaccent m 25\r\nKPX rcommaaccent n 25\r\nKPX rcommaaccent nacute 25\r\nKPX rcommaaccent ncaron 25\r\nKPX rcommaaccent ncommaaccent 25\r\nKPX rcommaaccent ntilde 25\r\nKPX rcommaaccent p 30\r\nKPX rcommaaccent period -50\r\nKPX rcommaaccent semicolon 30\r\nKPX rcommaaccent t 40\r\nKPX rcommaaccent tcommaaccent 40\r\nKPX rcommaaccent u 15\r\nKPX rcommaaccent uacute 15\r\nKPX rcommaaccent ucircumflex 15\r\nKPX rcommaaccent udieresis 15\r\nKPX rcommaaccent ugrave 15\r\nKPX rcommaaccent uhungarumlaut 15\r\nKPX rcommaaccent umacron 15\r\nKPX rcommaaccent uogonek 15\r\nKPX rcommaaccent uring 15\r\nKPX rcommaaccent v 30\r\nKPX rcommaaccent y 30\r\nKPX rcommaaccent yacute 30\r\nKPX rcommaaccent ydieresis 30\r\nKPX s comma -15\r\nKPX s period -15\r\nKPX s w -30\r\nKPX sacute comma -15\r\nKPX sacute period -15\r\nKPX sacute w -30\r\nKPX scaron comma -15\r\nKPX scaron period -15\r\nKPX scaron w -30\r\nKPX scedilla comma -15\r\nKPX scedilla period -15\r\nKPX scedilla w -30\r\nKPX scommaaccent comma -15\r\nKPX scommaaccent period -15\r\nKPX scommaaccent w -30\r\nKPX semicolon space -50\r\nKPX space T -50\r\nKPX space Tcaron -50\r\nKPX space Tcommaaccent -50\r\nKPX space V -50\r\nKPX space W -40\r\nKPX space Y -90\r\nKPX space Yacute -90\r\nKPX space Ydieresis -90\r\nKPX space quotedblleft -30\r\nKPX space quoteleft -60\r\nKPX v a -25\r\nKPX v aacute -25\r\nKPX v abreve -25\r\nKPX v acircumflex -25\r\nKPX v adieresis -25\r\nKPX v agrave -25\r\nKPX v amacron -25\r\nKPX v aogonek -25\r\nKPX v aring -25\r\nKPX v atilde -25\r\nKPX v comma -80\r\nKPX v e -25\r\nKPX v eacute -25\r\nKPX v ecaron -25\r\nKPX v ecircumflex -25\r\nKPX v edieresis -25\r\nKPX v edotaccent -25\r\nKPX v egrave -25\r\nKPX v emacron -25\r\nKPX v eogonek -25\r\nKPX v o -25\r\nKPX v oacute -25\r\nKPX v ocircumflex -25\r\nKPX v odieresis -25\r\nKPX v ograve -25\r\nKPX v ohungarumlaut -25\r\nKPX v omacron -25\r\nKPX v oslash -25\r\nKPX v otilde -25\r\nKPX v period -80\r\nKPX w a -15\r\nKPX w aacute -15\r\nKPX w abreve -15\r\nKPX w acircumflex -15\r\nKPX w adieresis -15\r\nKPX w agrave -15\r\nKPX w amacron -15\r\nKPX w aogonek -15\r\nKPX w aring -15\r\nKPX w atilde -15\r\nKPX w comma -60\r\nKPX w e -10\r\nKPX w eacute -10\r\nKPX w ecaron -10\r\nKPX w ecircumflex -10\r\nKPX w edieresis -10\r\nKPX w edotaccent -10\r\nKPX w egrave -10\r\nKPX w emacron -10\r\nKPX w eogonek -10\r\nKPX w o -10\r\nKPX w oacute -10\r\nKPX w ocircumflex -10\r\nKPX w odieresis -10\r\nKPX w ograve -10\r\nKPX w ohungarumlaut -10\r\nKPX w omacron -10\r\nKPX w oslash -10\r\nKPX w otilde -10\r\nKPX w period -60\r\nKPX x e -30\r\nKPX x eacute -30\r\nKPX x ecaron -30\r\nKPX x ecircumflex -30\r\nKPX x edieresis -30\r\nKPX x edotaccent -30\r\nKPX x egrave -30\r\nKPX x emacron -30\r\nKPX x eogonek -30\r\nKPX y a -20\r\nKPX y aacute -20\r\nKPX y abreve -20\r\nKPX y acircumflex -20\r\nKPX y adieresis -20\r\nKPX y agrave -20\r\nKPX y amacron -20\r\nKPX y aogonek -20\r\nKPX y aring -20\r\nKPX y atilde -20\r\nKPX y comma -100\r\nKPX y e -20\r\nKPX y eacute -20\r\nKPX y ecaron -20\r\nKPX y ecircumflex -20\r\nKPX y edieresis -20\r\nKPX y edotaccent -20\r\nKPX y egrave -20\r\nKPX y emacron -20\r\nKPX y eogonek -20\r\nKPX y o -20\r\nKPX y oacute -20\r\nKPX y ocircumflex -20\r\nKPX y odieresis -20\r\nKPX y ograve -20\r\nKPX y ohungarumlaut -20\r\nKPX y omacron -20\r\nKPX y oslash -20\r\nKPX y otilde -20\r\nKPX y period -100\r\nKPX yacute a -20\r\nKPX yacute aacute -20\r\nKPX yacute abreve -20\r\nKPX yacute acircumflex -20\r\nKPX yacute adieresis -20\r\nKPX yacute agrave -20\r\nKPX yacute amacron -20\r\nKPX yacute aogonek -20\r\nKPX yacute aring -20\r\nKPX yacute atilde -20\r\nKPX yacute comma -100\r\nKPX yacute e -20\r\nKPX yacute eacute -20\r\nKPX yacute ecaron -20\r\nKPX yacute ecircumflex -20\r\nKPX yacute edieresis -20\r\nKPX yacute edotaccent -20\r\nKPX yacute egrave -20\r\nKPX yacute emacron -20\r\nKPX yacute eogonek -20\r\nKPX yacute o -20\r\nKPX yacute oacute -20\r\nKPX yacute ocircumflex -20\r\nKPX yacute odieresis -20\r\nKPX yacute ograve -20\r\nKPX yacute ohungarumlaut -20\r\nKPX yacute omacron -20\r\nKPX yacute oslash -20\r\nKPX yacute otilde -20\r\nKPX yacute period -100\r\nKPX ydieresis a -20\r\nKPX ydieresis aacute -20\r\nKPX ydieresis abreve -20\r\nKPX ydieresis acircumflex -20\r\nKPX ydieresis adieresis -20\r\nKPX ydieresis agrave -20\r\nKPX ydieresis amacron -20\r\nKPX ydieresis aogonek -20\r\nKPX ydieresis aring -20\r\nKPX ydieresis atilde -20\r\nKPX ydieresis comma -100\r\nKPX ydieresis e -20\r\nKPX ydieresis eacute -20\r\nKPX ydieresis ecaron -20\r\nKPX ydieresis ecircumflex -20\r\nKPX ydieresis edieresis -20\r\nKPX ydieresis edotaccent -20\r\nKPX ydieresis egrave -20\r\nKPX ydieresis emacron -20\r\nKPX ydieresis eogonek -20\r\nKPX ydieresis o -20\r\nKPX ydieresis oacute -20\r\nKPX ydieresis ocircumflex -20\r\nKPX ydieresis odieresis -20\r\nKPX ydieresis ograve -20\r\nKPX ydieresis ohungarumlaut -20\r\nKPX ydieresis omacron -20\r\nKPX ydieresis oslash -20\r\nKPX ydieresis otilde -20\r\nKPX ydieresis period -100\r\nKPX z e -15\r\nKPX z eacute -15\r\nKPX z ecaron -15\r\nKPX z ecircumflex -15\r\nKPX z edieresis -15\r\nKPX z edotaccent -15\r\nKPX z egrave -15\r\nKPX z emacron -15\r\nKPX z eogonek -15\r\nKPX z o -15\r\nKPX z oacute -15\r\nKPX z ocircumflex -15\r\nKPX z odieresis -15\r\nKPX z ograve -15\r\nKPX z ohungarumlaut -15\r\nKPX z omacron -15\r\nKPX z oslash -15\r\nKPX z otilde -15\r\nKPX zacute e -15\r\nKPX zacute eacute -15\r\nKPX zacute ecaron -15\r\nKPX zacute ecircumflex -15\r\nKPX zacute edieresis -15\r\nKPX zacute edotaccent -15\r\nKPX zacute egrave -15\r\nKPX zacute emacron -15\r\nKPX zacute eogonek -15\r\nKPX zacute o -15\r\nKPX zacute oacute -15\r\nKPX zacute ocircumflex -15\r\nKPX zacute odieresis -15\r\nKPX zacute ograve -15\r\nKPX zacute ohungarumlaut -15\r\nKPX zacute omacron -15\r\nKPX zacute oslash -15\r\nKPX zacute otilde -15\r\nKPX zcaron e -15\r\nKPX zcaron eacute -15\r\nKPX zcaron ecaron -15\r\nKPX zcaron ecircumflex -15\r\nKPX zcaron edieresis -15\r\nKPX zcaron edotaccent -15\r\nKPX zcaron egrave -15\r\nKPX zcaron emacron -15\r\nKPX zcaron eogonek -15\r\nKPX zcaron o -15\r\nKPX zcaron oacute -15\r\nKPX zcaron ocircumflex -15\r\nKPX zcaron odieresis -15\r\nKPX zcaron ograve -15\r\nKPX zcaron ohungarumlaut -15\r\nKPX zcaron omacron -15\r\nKPX zcaron oslash -15\r\nKPX zcaron otilde -15\r\nKPX zdotaccent e -15\r\nKPX zdotaccent eacute -15\r\nKPX zdotaccent ecaron -15\r\nKPX zdotaccent ecircumflex -15\r\nKPX zdotaccent edieresis -15\r\nKPX zdotaccent edotaccent -15\r\nKPX zdotaccent egrave -15\r\nKPX zdotaccent emacron -15\r\nKPX zdotaccent eogonek -15\r\nKPX zdotaccent o -15\r\nKPX zdotaccent oacute -15\r\nKPX zdotaccent ocircumflex -15\r\nKPX zdotaccent odieresis -15\r\nKPX zdotaccent ograve -15\r\nKPX zdotaccent ohungarumlaut -15\r\nKPX zdotaccent omacron -15\r\nKPX zdotaccent oslash -15\r\nKPX zdotaccent otilde -15\r\nEndKernPairs\r\nEndKernData\r\nEndFontMetrics\r\n";
  },
  'Helvetica-Bold'() {
    return "StartFontMetrics 4.1\r\nComment Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.\r\nComment Creation Date: Thu May  1 12:43:52 1997\r\nComment UniqueID 43052\r\nComment VMusage 37169 48194\r\nFontName Helvetica-Bold\r\nFullName Helvetica Bold\r\nFamilyName Helvetica\r\nWeight Bold\r\nItalicAngle 0\r\nIsFixedPitch false\r\nCharacterSet ExtendedRoman\r\nFontBBox -170 -228 1003 962 \r\nUnderlinePosition -100\r\nUnderlineThickness 50\r\nVersion 002.000\r\nNotice Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.Helvetica is a trademark of Linotype-Hell AG and/or its subsidiaries.\r\nEncodingScheme AdobeStandardEncoding\r\nCapHeight 718\r\nXHeight 532\r\nAscender 718\r\nDescender -207\r\nStdHW 118\r\nStdVW 140\r\nStartCharMetrics 315\r\nC 32 ; WX 278 ; N space ; B 0 0 0 0 ;\r\nC 33 ; WX 333 ; N exclam ; B 90 0 244 718 ;\r\nC 34 ; WX 474 ; N quotedbl ; B 98 447 376 718 ;\r\nC 35 ; WX 556 ; N numbersign ; B 18 0 538 698 ;\r\nC 36 ; WX 556 ; N dollar ; B 30 -115 523 775 ;\r\nC 37 ; WX 889 ; N percent ; B 28 -19 861 710 ;\r\nC 38 ; WX 722 ; N ampersand ; B 54 -19 701 718 ;\r\nC 39 ; WX 278 ; N quoteright ; B 69 445 209 718 ;\r\nC 40 ; WX 333 ; N parenleft ; B 35 -208 314 734 ;\r\nC 41 ; WX 333 ; N parenright ; B 19 -208 298 734 ;\r\nC 42 ; WX 389 ; N asterisk ; B 27 387 362 718 ;\r\nC 43 ; WX 584 ; N plus ; B 40 0 544 506 ;\r\nC 44 ; WX 278 ; N comma ; B 64 -168 214 146 ;\r\nC 45 ; WX 333 ; N hyphen ; B 27 215 306 345 ;\r\nC 46 ; WX 278 ; N period ; B 64 0 214 146 ;\r\nC 47 ; WX 278 ; N slash ; B -33 -19 311 737 ;\r\nC 48 ; WX 556 ; N zero ; B 32 -19 524 710 ;\r\nC 49 ; WX 556 ; N one ; B 69 0 378 710 ;\r\nC 50 ; WX 556 ; N two ; B 26 0 511 710 ;\r\nC 51 ; WX 556 ; N three ; B 27 -19 516 710 ;\r\nC 52 ; WX 556 ; N four ; B 27 0 526 710 ;\r\nC 53 ; WX 556 ; N five ; B 27 -19 516 698 ;\r\nC 54 ; WX 556 ; N six ; B 31 -19 520 710 ;\r\nC 55 ; WX 556 ; N seven ; B 25 0 528 698 ;\r\nC 56 ; WX 556 ; N eight ; B 32 -19 524 710 ;\r\nC 57 ; WX 556 ; N nine ; B 30 -19 522 710 ;\r\nC 58 ; WX 333 ; N colon ; B 92 0 242 512 ;\r\nC 59 ; WX 333 ; N semicolon ; B 92 -168 242 512 ;\r\nC 60 ; WX 584 ; N less ; B 38 -8 546 514 ;\r\nC 61 ; WX 584 ; N equal ; B 40 87 544 419 ;\r\nC 62 ; WX 584 ; N greater ; B 38 -8 546 514 ;\r\nC 63 ; WX 611 ; N question ; B 60 0 556 727 ;\r\nC 64 ; WX 975 ; N at ; B 118 -19 856 737 ;\r\nC 65 ; WX 722 ; N A ; B 20 0 702 718 ;\r\nC 66 ; WX 722 ; N B ; B 76 0 669 718 ;\r\nC 67 ; WX 722 ; N C ; B 44 -19 684 737 ;\r\nC 68 ; WX 722 ; N D ; B 76 0 685 718 ;\r\nC 69 ; WX 667 ; N E ; B 76 0 621 718 ;\r\nC 70 ; WX 611 ; N F ; B 76 0 587 718 ;\r\nC 71 ; WX 778 ; N G ; B 44 -19 713 737 ;\r\nC 72 ; WX 722 ; N H ; B 71 0 651 718 ;\r\nC 73 ; WX 278 ; N I ; B 64 0 214 718 ;\r\nC 74 ; WX 556 ; N J ; B 22 -18 484 718 ;\r\nC 75 ; WX 722 ; N K ; B 87 0 722 718 ;\r\nC 76 ; WX 611 ; N L ; B 76 0 583 718 ;\r\nC 77 ; WX 833 ; N M ; B 69 0 765 718 ;\r\nC 78 ; WX 722 ; N N ; B 69 0 654 718 ;\r\nC 79 ; WX 778 ; N O ; B 44 -19 734 737 ;\r\nC 80 ; WX 667 ; N P ; B 76 0 627 718 ;\r\nC 81 ; WX 778 ; N Q ; B 44 -52 737 737 ;\r\nC 82 ; WX 722 ; N R ; B 76 0 677 718 ;\r\nC 83 ; WX 667 ; N S ; B 39 -19 629 737 ;\r\nC 84 ; WX 611 ; N T ; B 14 0 598 718 ;\r\nC 85 ; WX 722 ; N U ; B 72 -19 651 718 ;\r\nC 86 ; WX 667 ; N V ; B 19 0 648 718 ;\r\nC 87 ; WX 944 ; N W ; B 16 0 929 718 ;\r\nC 88 ; WX 667 ; N X ; B 14 0 653 718 ;\r\nC 89 ; WX 667 ; N Y ; B 15 0 653 718 ;\r\nC 90 ; WX 611 ; N Z ; B 25 0 586 718 ;\r\nC 91 ; WX 333 ; N bracketleft ; B 63 -196 309 722 ;\r\nC 92 ; WX 278 ; N backslash ; B -33 -19 311 737 ;\r\nC 93 ; WX 333 ; N bracketright ; B 24 -196 270 722 ;\r\nC 94 ; WX 584 ; N asciicircum ; B 62 323 522 698 ;\r\nC 95 ; WX 556 ; N underscore ; B 0 -125 556 -75 ;\r\nC 96 ; WX 278 ; N quoteleft ; B 69 454 209 727 ;\r\nC 97 ; WX 556 ; N a ; B 29 -14 527 546 ;\r\nC 98 ; WX 611 ; N b ; B 61 -14 578 718 ;\r\nC 99 ; WX 556 ; N c ; B 34 -14 524 546 ;\r\nC 100 ; WX 611 ; N d ; B 34 -14 551 718 ;\r\nC 101 ; WX 556 ; N e ; B 23 -14 528 546 ;\r\nC 102 ; WX 333 ; N f ; B 10 0 318 727 ; L i fi ; L l fl ;\r\nC 103 ; WX 611 ; N g ; B 40 -217 553 546 ;\r\nC 104 ; WX 611 ; N h ; B 65 0 546 718 ;\r\nC 105 ; WX 278 ; N i ; B 69 0 209 725 ;\r\nC 106 ; WX 278 ; N j ; B 3 -214 209 725 ;\r\nC 107 ; WX 556 ; N k ; B 69 0 562 718 ;\r\nC 108 ; WX 278 ; N l ; B 69 0 209 718 ;\r\nC 109 ; WX 889 ; N m ; B 64 0 826 546 ;\r\nC 110 ; WX 611 ; N n ; B 65 0 546 546 ;\r\nC 111 ; WX 611 ; N o ; B 34 -14 578 546 ;\r\nC 112 ; WX 611 ; N p ; B 62 -207 578 546 ;\r\nC 113 ; WX 611 ; N q ; B 34 -207 552 546 ;\r\nC 114 ; WX 389 ; N r ; B 64 0 373 546 ;\r\nC 115 ; WX 556 ; N s ; B 30 -14 519 546 ;\r\nC 116 ; WX 333 ; N t ; B 10 -6 309 676 ;\r\nC 117 ; WX 611 ; N u ; B 66 -14 545 532 ;\r\nC 118 ; WX 556 ; N v ; B 13 0 543 532 ;\r\nC 119 ; WX 778 ; N w ; B 10 0 769 532 ;\r\nC 120 ; WX 556 ; N x ; B 15 0 541 532 ;\r\nC 121 ; WX 556 ; N y ; B 10 -214 539 532 ;\r\nC 122 ; WX 500 ; N z ; B 20 0 480 532 ;\r\nC 123 ; WX 389 ; N braceleft ; B 48 -196 365 722 ;\r\nC 124 ; WX 280 ; N bar ; B 84 -225 196 775 ;\r\nC 125 ; WX 389 ; N braceright ; B 24 -196 341 722 ;\r\nC 126 ; WX 584 ; N asciitilde ; B 61 163 523 343 ;\r\nC 161 ; WX 333 ; N exclamdown ; B 90 -186 244 532 ;\r\nC 162 ; WX 556 ; N cent ; B 34 -118 524 628 ;\r\nC 163 ; WX 556 ; N sterling ; B 28 -16 541 718 ;\r\nC 164 ; WX 167 ; N fraction ; B -170 -19 336 710 ;\r\nC 165 ; WX 556 ; N yen ; B -9 0 565 698 ;\r\nC 166 ; WX 556 ; N florin ; B -10 -210 516 737 ;\r\nC 167 ; WX 556 ; N section ; B 34 -184 522 727 ;\r\nC 168 ; WX 556 ; N currency ; B -3 76 559 636 ;\r\nC 169 ; WX 238 ; N quotesingle ; B 70 447 168 718 ;\r\nC 170 ; WX 500 ; N quotedblleft ; B 64 454 436 727 ;\r\nC 171 ; WX 556 ; N guillemotleft ; B 88 76 468 484 ;\r\nC 172 ; WX 333 ; N guilsinglleft ; B 83 76 250 484 ;\r\nC 173 ; WX 333 ; N guilsinglright ; B 83 76 250 484 ;\r\nC 174 ; WX 611 ; N fi ; B 10 0 542 727 ;\r\nC 175 ; WX 611 ; N fl ; B 10 0 542 727 ;\r\nC 177 ; WX 556 ; N endash ; B 0 227 556 333 ;\r\nC 178 ; WX 556 ; N dagger ; B 36 -171 520 718 ;\r\nC 179 ; WX 556 ; N daggerdbl ; B 36 -171 520 718 ;\r\nC 180 ; WX 278 ; N periodcentered ; B 58 172 220 334 ;\r\nC 182 ; WX 556 ; N paragraph ; B -8 -191 539 700 ;\r\nC 183 ; WX 350 ; N bullet ; B 10 194 340 524 ;\r\nC 184 ; WX 278 ; N quotesinglbase ; B 69 -146 209 127 ;\r\nC 185 ; WX 500 ; N quotedblbase ; B 64 -146 436 127 ;\r\nC 186 ; WX 500 ; N quotedblright ; B 64 445 436 718 ;\r\nC 187 ; WX 556 ; N guillemotright ; B 88 76 468 484 ;\r\nC 188 ; WX 1000 ; N ellipsis ; B 92 0 908 146 ;\r\nC 189 ; WX 1000 ; N perthousand ; B -3 -19 1003 710 ;\r\nC 191 ; WX 611 ; N questiondown ; B 55 -195 551 532 ;\r\nC 193 ; WX 333 ; N grave ; B -23 604 225 750 ;\r\nC 194 ; WX 333 ; N acute ; B 108 604 356 750 ;\r\nC 195 ; WX 333 ; N circumflex ; B -10 604 343 750 ;\r\nC 196 ; WX 333 ; N tilde ; B -17 610 350 737 ;\r\nC 197 ; WX 333 ; N macron ; B -6 604 339 678 ;\r\nC 198 ; WX 333 ; N breve ; B -2 604 335 750 ;\r\nC 199 ; WX 333 ; N dotaccent ; B 104 614 230 729 ;\r\nC 200 ; WX 333 ; N dieresis ; B 6 614 327 729 ;\r\nC 202 ; WX 333 ; N ring ; B 59 568 275 776 ;\r\nC 203 ; WX 333 ; N cedilla ; B 6 -228 245 0 ;\r\nC 205 ; WX 333 ; N hungarumlaut ; B 9 604 486 750 ;\r\nC 206 ; WX 333 ; N ogonek ; B 71 -228 304 0 ;\r\nC 207 ; WX 333 ; N caron ; B -10 604 343 750 ;\r\nC 208 ; WX 1000 ; N emdash ; B 0 227 1000 333 ;\r\nC 225 ; WX 1000 ; N AE ; B 5 0 954 718 ;\r\nC 227 ; WX 370 ; N ordfeminine ; B 22 401 347 737 ;\r\nC 232 ; WX 611 ; N Lslash ; B -20 0 583 718 ;\r\nC 233 ; WX 778 ; N Oslash ; B 33 -27 744 745 ;\r\nC 234 ; WX 1000 ; N OE ; B 37 -19 961 737 ;\r\nC 235 ; WX 365 ; N ordmasculine ; B 6 401 360 737 ;\r\nC 241 ; WX 889 ; N ae ; B 29 -14 858 546 ;\r\nC 245 ; WX 278 ; N dotlessi ; B 69 0 209 532 ;\r\nC 248 ; WX 278 ; N lslash ; B -18 0 296 718 ;\r\nC 249 ; WX 611 ; N oslash ; B 22 -29 589 560 ;\r\nC 250 ; WX 944 ; N oe ; B 34 -14 912 546 ;\r\nC 251 ; WX 611 ; N germandbls ; B 69 -14 579 731 ;\r\nC -1 ; WX 278 ; N Idieresis ; B -21 0 300 915 ;\r\nC -1 ; WX 556 ; N eacute ; B 23 -14 528 750 ;\r\nC -1 ; WX 556 ; N abreve ; B 29 -14 527 750 ;\r\nC -1 ; WX 611 ; N uhungarumlaut ; B 66 -14 625 750 ;\r\nC -1 ; WX 556 ; N ecaron ; B 23 -14 528 750 ;\r\nC -1 ; WX 667 ; N Ydieresis ; B 15 0 653 915 ;\r\nC -1 ; WX 584 ; N divide ; B 40 -42 544 548 ;\r\nC -1 ; WX 667 ; N Yacute ; B 15 0 653 936 ;\r\nC -1 ; WX 722 ; N Acircumflex ; B 20 0 702 936 ;\r\nC -1 ; WX 556 ; N aacute ; B 29 -14 527 750 ;\r\nC -1 ; WX 722 ; N Ucircumflex ; B 72 -19 651 936 ;\r\nC -1 ; WX 556 ; N yacute ; B 10 -214 539 750 ;\r\nC -1 ; WX 556 ; N scommaaccent ; B 30 -228 519 546 ;\r\nC -1 ; WX 556 ; N ecircumflex ; B 23 -14 528 750 ;\r\nC -1 ; WX 722 ; N Uring ; B 72 -19 651 962 ;\r\nC -1 ; WX 722 ; N Udieresis ; B 72 -19 651 915 ;\r\nC -1 ; WX 556 ; N aogonek ; B 29 -224 545 546 ;\r\nC -1 ; WX 722 ; N Uacute ; B 72 -19 651 936 ;\r\nC -1 ; WX 611 ; N uogonek ; B 66 -228 545 532 ;\r\nC -1 ; WX 667 ; N Edieresis ; B 76 0 621 915 ;\r\nC -1 ; WX 722 ; N Dcroat ; B -5 0 685 718 ;\r\nC -1 ; WX 250 ; N commaaccent ; B 64 -228 199 -50 ;\r\nC -1 ; WX 737 ; N copyright ; B -11 -19 749 737 ;\r\nC -1 ; WX 667 ; N Emacron ; B 76 0 621 864 ;\r\nC -1 ; WX 556 ; N ccaron ; B 34 -14 524 750 ;\r\nC -1 ; WX 556 ; N aring ; B 29 -14 527 776 ;\r\nC -1 ; WX 722 ; N Ncommaaccent ; B 69 -228 654 718 ;\r\nC -1 ; WX 278 ; N lacute ; B 69 0 329 936 ;\r\nC -1 ; WX 556 ; N agrave ; B 29 -14 527 750 ;\r\nC -1 ; WX 611 ; N Tcommaaccent ; B 14 -228 598 718 ;\r\nC -1 ; WX 722 ; N Cacute ; B 44 -19 684 936 ;\r\nC -1 ; WX 556 ; N atilde ; B 29 -14 527 737 ;\r\nC -1 ; WX 667 ; N Edotaccent ; B 76 0 621 915 ;\r\nC -1 ; WX 556 ; N scaron ; B 30 -14 519 750 ;\r\nC -1 ; WX 556 ; N scedilla ; B 30 -228 519 546 ;\r\nC -1 ; WX 278 ; N iacute ; B 69 0 329 750 ;\r\nC -1 ; WX 494 ; N lozenge ; B 10 0 484 745 ;\r\nC -1 ; WX 722 ; N Rcaron ; B 76 0 677 936 ;\r\nC -1 ; WX 778 ; N Gcommaaccent ; B 44 -228 713 737 ;\r\nC -1 ; WX 611 ; N ucircumflex ; B 66 -14 545 750 ;\r\nC -1 ; WX 556 ; N acircumflex ; B 29 -14 527 750 ;\r\nC -1 ; WX 722 ; N Amacron ; B 20 0 702 864 ;\r\nC -1 ; WX 389 ; N rcaron ; B 18 0 373 750 ;\r\nC -1 ; WX 556 ; N ccedilla ; B 34 -228 524 546 ;\r\nC -1 ; WX 611 ; N Zdotaccent ; B 25 0 586 915 ;\r\nC -1 ; WX 667 ; N Thorn ; B 76 0 627 718 ;\r\nC -1 ; WX 778 ; N Omacron ; B 44 -19 734 864 ;\r\nC -1 ; WX 722 ; N Racute ; B 76 0 677 936 ;\r\nC -1 ; WX 667 ; N Sacute ; B 39 -19 629 936 ;\r\nC -1 ; WX 743 ; N dcaron ; B 34 -14 750 718 ;\r\nC -1 ; WX 722 ; N Umacron ; B 72 -19 651 864 ;\r\nC -1 ; WX 611 ; N uring ; B 66 -14 545 776 ;\r\nC -1 ; WX 333 ; N threesuperior ; B 8 271 326 710 ;\r\nC -1 ; WX 778 ; N Ograve ; B 44 -19 734 936 ;\r\nC -1 ; WX 722 ; N Agrave ; B 20 0 702 936 ;\r\nC -1 ; WX 722 ; N Abreve ; B 20 0 702 936 ;\r\nC -1 ; WX 584 ; N multiply ; B 40 1 545 505 ;\r\nC -1 ; WX 611 ; N uacute ; B 66 -14 545 750 ;\r\nC -1 ; WX 611 ; N Tcaron ; B 14 0 598 936 ;\r\nC -1 ; WX 494 ; N partialdiff ; B 11 -21 494 750 ;\r\nC -1 ; WX 556 ; N ydieresis ; B 10 -214 539 729 ;\r\nC -1 ; WX 722 ; N Nacute ; B 69 0 654 936 ;\r\nC -1 ; WX 278 ; N icircumflex ; B -37 0 316 750 ;\r\nC -1 ; WX 667 ; N Ecircumflex ; B 76 0 621 936 ;\r\nC -1 ; WX 556 ; N adieresis ; B 29 -14 527 729 ;\r\nC -1 ; WX 556 ; N edieresis ; B 23 -14 528 729 ;\r\nC -1 ; WX 556 ; N cacute ; B 34 -14 524 750 ;\r\nC -1 ; WX 611 ; N nacute ; B 65 0 546 750 ;\r\nC -1 ; WX 611 ; N umacron ; B 66 -14 545 678 ;\r\nC -1 ; WX 722 ; N Ncaron ; B 69 0 654 936 ;\r\nC -1 ; WX 278 ; N Iacute ; B 64 0 329 936 ;\r\nC -1 ; WX 584 ; N plusminus ; B 40 0 544 506 ;\r\nC -1 ; WX 280 ; N brokenbar ; B 84 -150 196 700 ;\r\nC -1 ; WX 737 ; N registered ; B -11 -19 748 737 ;\r\nC -1 ; WX 778 ; N Gbreve ; B 44 -19 713 936 ;\r\nC -1 ; WX 278 ; N Idotaccent ; B 64 0 214 915 ;\r\nC -1 ; WX 600 ; N summation ; B 14 -10 585 706 ;\r\nC -1 ; WX 667 ; N Egrave ; B 76 0 621 936 ;\r\nC -1 ; WX 389 ; N racute ; B 64 0 384 750 ;\r\nC -1 ; WX 611 ; N omacron ; B 34 -14 578 678 ;\r\nC -1 ; WX 611 ; N Zacute ; B 25 0 586 936 ;\r\nC -1 ; WX 611 ; N Zcaron ; B 25 0 586 936 ;\r\nC -1 ; WX 549 ; N greaterequal ; B 26 0 523 704 ;\r\nC -1 ; WX 722 ; N Eth ; B -5 0 685 718 ;\r\nC -1 ; WX 722 ; N Ccedilla ; B 44 -228 684 737 ;\r\nC -1 ; WX 278 ; N lcommaaccent ; B 69 -228 213 718 ;\r\nC -1 ; WX 389 ; N tcaron ; B 10 -6 421 878 ;\r\nC -1 ; WX 556 ; N eogonek ; B 23 -228 528 546 ;\r\nC -1 ; WX 722 ; N Uogonek ; B 72 -228 651 718 ;\r\nC -1 ; WX 722 ; N Aacute ; B 20 0 702 936 ;\r\nC -1 ; WX 722 ; N Adieresis ; B 20 0 702 915 ;\r\nC -1 ; WX 556 ; N egrave ; B 23 -14 528 750 ;\r\nC -1 ; WX 500 ; N zacute ; B 20 0 480 750 ;\r\nC -1 ; WX 278 ; N iogonek ; B 16 -224 249 725 ;\r\nC -1 ; WX 778 ; N Oacute ; B 44 -19 734 936 ;\r\nC -1 ; WX 611 ; N oacute ; B 34 -14 578 750 ;\r\nC -1 ; WX 556 ; N amacron ; B 29 -14 527 678 ;\r\nC -1 ; WX 556 ; N sacute ; B 30 -14 519 750 ;\r\nC -1 ; WX 278 ; N idieresis ; B -21 0 300 729 ;\r\nC -1 ; WX 778 ; N Ocircumflex ; B 44 -19 734 936 ;\r\nC -1 ; WX 722 ; N Ugrave ; B 72 -19 651 936 ;\r\nC -1 ; WX 612 ; N Delta ; B 6 0 608 688 ;\r\nC -1 ; WX 611 ; N thorn ; B 62 -208 578 718 ;\r\nC -1 ; WX 333 ; N twosuperior ; B 9 283 324 710 ;\r\nC -1 ; WX 778 ; N Odieresis ; B 44 -19 734 915 ;\r\nC -1 ; WX 611 ; N mu ; B 66 -207 545 532 ;\r\nC -1 ; WX 278 ; N igrave ; B -50 0 209 750 ;\r\nC -1 ; WX 611 ; N ohungarumlaut ; B 34 -14 625 750 ;\r\nC -1 ; WX 667 ; N Eogonek ; B 76 -224 639 718 ;\r\nC -1 ; WX 611 ; N dcroat ; B 34 -14 650 718 ;\r\nC -1 ; WX 834 ; N threequarters ; B 16 -19 799 710 ;\r\nC -1 ; WX 667 ; N Scedilla ; B 39 -228 629 737 ;\r\nC -1 ; WX 400 ; N lcaron ; B 69 0 408 718 ;\r\nC -1 ; WX 722 ; N Kcommaaccent ; B 87 -228 722 718 ;\r\nC -1 ; WX 611 ; N Lacute ; B 76 0 583 936 ;\r\nC -1 ; WX 1000 ; N trademark ; B 44 306 956 718 ;\r\nC -1 ; WX 556 ; N edotaccent ; B 23 -14 528 729 ;\r\nC -1 ; WX 278 ; N Igrave ; B -50 0 214 936 ;\r\nC -1 ; WX 278 ; N Imacron ; B -33 0 312 864 ;\r\nC -1 ; WX 611 ; N Lcaron ; B 76 0 583 718 ;\r\nC -1 ; WX 834 ; N onehalf ; B 26 -19 794 710 ;\r\nC -1 ; WX 549 ; N lessequal ; B 29 0 526 704 ;\r\nC -1 ; WX 611 ; N ocircumflex ; B 34 -14 578 750 ;\r\nC -1 ; WX 611 ; N ntilde ; B 65 0 546 737 ;\r\nC -1 ; WX 722 ; N Uhungarumlaut ; B 72 -19 681 936 ;\r\nC -1 ; WX 667 ; N Eacute ; B 76 0 621 936 ;\r\nC -1 ; WX 556 ; N emacron ; B 23 -14 528 678 ;\r\nC -1 ; WX 611 ; N gbreve ; B 40 -217 553 750 ;\r\nC -1 ; WX 834 ; N onequarter ; B 26 -19 766 710 ;\r\nC -1 ; WX 667 ; N Scaron ; B 39 -19 629 936 ;\r\nC -1 ; WX 667 ; N Scommaaccent ; B 39 -228 629 737 ;\r\nC -1 ; WX 778 ; N Ohungarumlaut ; B 44 -19 734 936 ;\r\nC -1 ; WX 400 ; N degree ; B 57 426 343 712 ;\r\nC -1 ; WX 611 ; N ograve ; B 34 -14 578 750 ;\r\nC -1 ; WX 722 ; N Ccaron ; B 44 -19 684 936 ;\r\nC -1 ; WX 611 ; N ugrave ; B 66 -14 545 750 ;\r\nC -1 ; WX 549 ; N radical ; B 10 -46 512 850 ;\r\nC -1 ; WX 722 ; N Dcaron ; B 76 0 685 936 ;\r\nC -1 ; WX 389 ; N rcommaaccent ; B 64 -228 373 546 ;\r\nC -1 ; WX 722 ; N Ntilde ; B 69 0 654 923 ;\r\nC -1 ; WX 611 ; N otilde ; B 34 -14 578 737 ;\r\nC -1 ; WX 722 ; N Rcommaaccent ; B 76 -228 677 718 ;\r\nC -1 ; WX 611 ; N Lcommaaccent ; B 76 -228 583 718 ;\r\nC -1 ; WX 722 ; N Atilde ; B 20 0 702 923 ;\r\nC -1 ; WX 722 ; N Aogonek ; B 20 -224 742 718 ;\r\nC -1 ; WX 722 ; N Aring ; B 20 0 702 962 ;\r\nC -1 ; WX 778 ; N Otilde ; B 44 -19 734 923 ;\r\nC -1 ; WX 500 ; N zdotaccent ; B 20 0 480 729 ;\r\nC -1 ; WX 667 ; N Ecaron ; B 76 0 621 936 ;\r\nC -1 ; WX 278 ; N Iogonek ; B -11 -228 222 718 ;\r\nC -1 ; WX 556 ; N kcommaaccent ; B 69 -228 562 718 ;\r\nC -1 ; WX 584 ; N minus ; B 40 197 544 309 ;\r\nC -1 ; WX 278 ; N Icircumflex ; B -37 0 316 936 ;\r\nC -1 ; WX 611 ; N ncaron ; B 65 0 546 750 ;\r\nC -1 ; WX 333 ; N tcommaaccent ; B 10 -228 309 676 ;\r\nC -1 ; WX 584 ; N logicalnot ; B 40 108 544 419 ;\r\nC -1 ; WX 611 ; N odieresis ; B 34 -14 578 729 ;\r\nC -1 ; WX 611 ; N udieresis ; B 66 -14 545 729 ;\r\nC -1 ; WX 549 ; N notequal ; B 15 -49 540 570 ;\r\nC -1 ; WX 611 ; N gcommaaccent ; B 40 -217 553 850 ;\r\nC -1 ; WX 611 ; N eth ; B 34 -14 578 737 ;\r\nC -1 ; WX 500 ; N zcaron ; B 20 0 480 750 ;\r\nC -1 ; WX 611 ; N ncommaaccent ; B 65 -228 546 546 ;\r\nC -1 ; WX 333 ; N onesuperior ; B 26 283 237 710 ;\r\nC -1 ; WX 278 ; N imacron ; B -8 0 285 678 ;\r\nC -1 ; WX 556 ; N Euro ; B 0 0 0 0 ;\r\nEndCharMetrics\r\nStartKernData\r\nStartKernPairs 2481\r\nKPX A C -40\r\nKPX A Cacute -40\r\nKPX A Ccaron -40\r\nKPX A Ccedilla -40\r\nKPX A G -50\r\nKPX A Gbreve -50\r\nKPX A Gcommaaccent -50\r\nKPX A O -40\r\nKPX A Oacute -40\r\nKPX A Ocircumflex -40\r\nKPX A Odieresis -40\r\nKPX A Ograve -40\r\nKPX A Ohungarumlaut -40\r\nKPX A Omacron -40\r\nKPX A Oslash -40\r\nKPX A Otilde -40\r\nKPX A Q -40\r\nKPX A T -90\r\nKPX A Tcaron -90\r\nKPX A Tcommaaccent -90\r\nKPX A U -50\r\nKPX A Uacute -50\r\nKPX A Ucircumflex -50\r\nKPX A Udieresis -50\r\nKPX A Ugrave -50\r\nKPX A Uhungarumlaut -50\r\nKPX A Umacron -50\r\nKPX A Uogonek -50\r\nKPX A Uring -50\r\nKPX A V -80\r\nKPX A W -60\r\nKPX A Y -110\r\nKPX A Yacute -110\r\nKPX A Ydieresis -110\r\nKPX A u -30\r\nKPX A uacute -30\r\nKPX A ucircumflex -30\r\nKPX A udieresis -30\r\nKPX A ugrave -30\r\nKPX A uhungarumlaut -30\r\nKPX A umacron -30\r\nKPX A uogonek -30\r\nKPX A uring -30\r\nKPX A v -40\r\nKPX A w -30\r\nKPX A y -30\r\nKPX A yacute -30\r\nKPX A ydieresis -30\r\nKPX Aacute C -40\r\nKPX Aacute Cacute -40\r\nKPX Aacute Ccaron -40\r\nKPX Aacute Ccedilla -40\r\nKPX Aacute G -50\r\nKPX Aacute Gbreve -50\r\nKPX Aacute Gcommaaccent -50\r\nKPX Aacute O -40\r\nKPX Aacute Oacute -40\r\nKPX Aacute Ocircumflex -40\r\nKPX Aacute Odieresis -40\r\nKPX Aacute Ograve -40\r\nKPX Aacute Ohungarumlaut -40\r\nKPX Aacute Omacron -40\r\nKPX Aacute Oslash -40\r\nKPX Aacute Otilde -40\r\nKPX Aacute Q -40\r\nKPX Aacute T -90\r\nKPX Aacute Tcaron -90\r\nKPX Aacute Tcommaaccent -90\r\nKPX Aacute U -50\r\nKPX Aacute Uacute -50\r\nKPX Aacute Ucircumflex -50\r\nKPX Aacute Udieresis -50\r\nKPX Aacute Ugrave -50\r\nKPX Aacute Uhungarumlaut -50\r\nKPX Aacute Umacron -50\r\nKPX Aacute Uogonek -50\r\nKPX Aacute Uring -50\r\nKPX Aacute V -80\r\nKPX Aacute W -60\r\nKPX Aacute Y -110\r\nKPX Aacute Yacute -110\r\nKPX Aacute Ydieresis -110\r\nKPX Aacute u -30\r\nKPX Aacute uacute -30\r\nKPX Aacute ucircumflex -30\r\nKPX Aacute udieresis -30\r\nKPX Aacute ugrave -30\r\nKPX Aacute uhungarumlaut -30\r\nKPX Aacute umacron -30\r\nKPX Aacute uogonek -30\r\nKPX Aacute uring -30\r\nKPX Aacute v -40\r\nKPX Aacute w -30\r\nKPX Aacute y -30\r\nKPX Aacute yacute -30\r\nKPX Aacute ydieresis -30\r\nKPX Abreve C -40\r\nKPX Abreve Cacute -40\r\nKPX Abreve Ccaron -40\r\nKPX Abreve Ccedilla -40\r\nKPX Abreve G -50\r\nKPX Abreve Gbreve -50\r\nKPX Abreve Gcommaaccent -50\r\nKPX Abreve O -40\r\nKPX Abreve Oacute -40\r\nKPX Abreve Ocircumflex -40\r\nKPX Abreve Odieresis -40\r\nKPX Abreve Ograve -40\r\nKPX Abreve Ohungarumlaut -40\r\nKPX Abreve Omacron -40\r\nKPX Abreve Oslash -40\r\nKPX Abreve Otilde -40\r\nKPX Abreve Q -40\r\nKPX Abreve T -90\r\nKPX Abreve Tcaron -90\r\nKPX Abreve Tcommaaccent -90\r\nKPX Abreve U -50\r\nKPX Abreve Uacute -50\r\nKPX Abreve Ucircumflex -50\r\nKPX Abreve Udieresis -50\r\nKPX Abreve Ugrave -50\r\nKPX Abreve Uhungarumlaut -50\r\nKPX Abreve Umacron -50\r\nKPX Abreve Uogonek -50\r\nKPX Abreve Uring -50\r\nKPX Abreve V -80\r\nKPX Abreve W -60\r\nKPX Abreve Y -110\r\nKPX Abreve Yacute -110\r\nKPX Abreve Ydieresis -110\r\nKPX Abreve u -30\r\nKPX Abreve uacute -30\r\nKPX Abreve ucircumflex -30\r\nKPX Abreve udieresis -30\r\nKPX Abreve ugrave -30\r\nKPX Abreve uhungarumlaut -30\r\nKPX Abreve umacron -30\r\nKPX Abreve uogonek -30\r\nKPX Abreve uring -30\r\nKPX Abreve v -40\r\nKPX Abreve w -30\r\nKPX Abreve y -30\r\nKPX Abreve yacute -30\r\nKPX Abreve ydieresis -30\r\nKPX Acircumflex C -40\r\nKPX Acircumflex Cacute -40\r\nKPX Acircumflex Ccaron -40\r\nKPX Acircumflex Ccedilla -40\r\nKPX Acircumflex G -50\r\nKPX Acircumflex Gbreve -50\r\nKPX Acircumflex Gcommaaccent -50\r\nKPX Acircumflex O -40\r\nKPX Acircumflex Oacute -40\r\nKPX Acircumflex Ocircumflex -40\r\nKPX Acircumflex Odieresis -40\r\nKPX Acircumflex Ograve -40\r\nKPX Acircumflex Ohungarumlaut -40\r\nKPX Acircumflex Omacron -40\r\nKPX Acircumflex Oslash -40\r\nKPX Acircumflex Otilde -40\r\nKPX Acircumflex Q -40\r\nKPX Acircumflex T -90\r\nKPX Acircumflex Tcaron -90\r\nKPX Acircumflex Tcommaaccent -90\r\nKPX Acircumflex U -50\r\nKPX Acircumflex Uacute -50\r\nKPX Acircumflex Ucircumflex -50\r\nKPX Acircumflex Udieresis -50\r\nKPX Acircumflex Ugrave -50\r\nKPX Acircumflex Uhungarumlaut -50\r\nKPX Acircumflex Umacron -50\r\nKPX Acircumflex Uogonek -50\r\nKPX Acircumflex Uring -50\r\nKPX Acircumflex V -80\r\nKPX Acircumflex W -60\r\nKPX Acircumflex Y -110\r\nKPX Acircumflex Yacute -110\r\nKPX Acircumflex Ydieresis -110\r\nKPX Acircumflex u -30\r\nKPX Acircumflex uacute -30\r\nKPX Acircumflex ucircumflex -30\r\nKPX Acircumflex udieresis -30\r\nKPX Acircumflex ugrave -30\r\nKPX Acircumflex uhungarumlaut -30\r\nKPX Acircumflex umacron -30\r\nKPX Acircumflex uogonek -30\r\nKPX Acircumflex uring -30\r\nKPX Acircumflex v -40\r\nKPX Acircumflex w -30\r\nKPX Acircumflex y -30\r\nKPX Acircumflex yacute -30\r\nKPX Acircumflex ydieresis -30\r\nKPX Adieresis C -40\r\nKPX Adieresis Cacute -40\r\nKPX Adieresis Ccaron -40\r\nKPX Adieresis Ccedilla -40\r\nKPX Adieresis G -50\r\nKPX Adieresis Gbreve -50\r\nKPX Adieresis Gcommaaccent -50\r\nKPX Adieresis O -40\r\nKPX Adieresis Oacute -40\r\nKPX Adieresis Ocircumflex -40\r\nKPX Adieresis Odieresis -40\r\nKPX Adieresis Ograve -40\r\nKPX Adieresis Ohungarumlaut -40\r\nKPX Adieresis Omacron -40\r\nKPX Adieresis Oslash -40\r\nKPX Adieresis Otilde -40\r\nKPX Adieresis Q -40\r\nKPX Adieresis T -90\r\nKPX Adieresis Tcaron -90\r\nKPX Adieresis Tcommaaccent -90\r\nKPX Adieresis U -50\r\nKPX Adieresis Uacute -50\r\nKPX Adieresis Ucircumflex -50\r\nKPX Adieresis Udieresis -50\r\nKPX Adieresis Ugrave -50\r\nKPX Adieresis Uhungarumlaut -50\r\nKPX Adieresis Umacron -50\r\nKPX Adieresis Uogonek -50\r\nKPX Adieresis Uring -50\r\nKPX Adieresis V -80\r\nKPX Adieresis W -60\r\nKPX Adieresis Y -110\r\nKPX Adieresis Yacute -110\r\nKPX Adieresis Ydieresis -110\r\nKPX Adieresis u -30\r\nKPX Adieresis uacute -30\r\nKPX Adieresis ucircumflex -30\r\nKPX Adieresis udieresis -30\r\nKPX Adieresis ugrave -30\r\nKPX Adieresis uhungarumlaut -30\r\nKPX Adieresis umacron -30\r\nKPX Adieresis uogonek -30\r\nKPX Adieresis uring -30\r\nKPX Adieresis v -40\r\nKPX Adieresis w -30\r\nKPX Adieresis y -30\r\nKPX Adieresis yacute -30\r\nKPX Adieresis ydieresis -30\r\nKPX Agrave C -40\r\nKPX Agrave Cacute -40\r\nKPX Agrave Ccaron -40\r\nKPX Agrave Ccedilla -40\r\nKPX Agrave G -50\r\nKPX Agrave Gbreve -50\r\nKPX Agrave Gcommaaccent -50\r\nKPX Agrave O -40\r\nKPX Agrave Oacute -40\r\nKPX Agrave Ocircumflex -40\r\nKPX Agrave Odieresis -40\r\nKPX Agrave Ograve -40\r\nKPX Agrave Ohungarumlaut -40\r\nKPX Agrave Omacron -40\r\nKPX Agrave Oslash -40\r\nKPX Agrave Otilde -40\r\nKPX Agrave Q -40\r\nKPX Agrave T -90\r\nKPX Agrave Tcaron -90\r\nKPX Agrave Tcommaaccent -90\r\nKPX Agrave U -50\r\nKPX Agrave Uacute -50\r\nKPX Agrave Ucircumflex -50\r\nKPX Agrave Udieresis -50\r\nKPX Agrave Ugrave -50\r\nKPX Agrave Uhungarumlaut -50\r\nKPX Agrave Umacron -50\r\nKPX Agrave Uogonek -50\r\nKPX Agrave Uring -50\r\nKPX Agrave V -80\r\nKPX Agrave W -60\r\nKPX Agrave Y -110\r\nKPX Agrave Yacute -110\r\nKPX Agrave Ydieresis -110\r\nKPX Agrave u -30\r\nKPX Agrave uacute -30\r\nKPX Agrave ucircumflex -30\r\nKPX Agrave udieresis -30\r\nKPX Agrave ugrave -30\r\nKPX Agrave uhungarumlaut -30\r\nKPX Agrave umacron -30\r\nKPX Agrave uogonek -30\r\nKPX Agrave uring -30\r\nKPX Agrave v -40\r\nKPX Agrave w -30\r\nKPX Agrave y -30\r\nKPX Agrave yacute -30\r\nKPX Agrave ydieresis -30\r\nKPX Amacron C -40\r\nKPX Amacron Cacute -40\r\nKPX Amacron Ccaron -40\r\nKPX Amacron Ccedilla -40\r\nKPX Amacron G -50\r\nKPX Amacron Gbreve -50\r\nKPX Amacron Gcommaaccent -50\r\nKPX Amacron O -40\r\nKPX Amacron Oacute -40\r\nKPX Amacron Ocircumflex -40\r\nKPX Amacron Odieresis -40\r\nKPX Amacron Ograve -40\r\nKPX Amacron Ohungarumlaut -40\r\nKPX Amacron Omacron -40\r\nKPX Amacron Oslash -40\r\nKPX Amacron Otilde -40\r\nKPX Amacron Q -40\r\nKPX Amacron T -90\r\nKPX Amacron Tcaron -90\r\nKPX Amacron Tcommaaccent -90\r\nKPX Amacron U -50\r\nKPX Amacron Uacute -50\r\nKPX Amacron Ucircumflex -50\r\nKPX Amacron Udieresis -50\r\nKPX Amacron Ugrave -50\r\nKPX Amacron Uhungarumlaut -50\r\nKPX Amacron Umacron -50\r\nKPX Amacron Uogonek -50\r\nKPX Amacron Uring -50\r\nKPX Amacron V -80\r\nKPX Amacron W -60\r\nKPX Amacron Y -110\r\nKPX Amacron Yacute -110\r\nKPX Amacron Ydieresis -110\r\nKPX Amacron u -30\r\nKPX Amacron uacute -30\r\nKPX Amacron ucircumflex -30\r\nKPX Amacron udieresis -30\r\nKPX Amacron ugrave -30\r\nKPX Amacron uhungarumlaut -30\r\nKPX Amacron umacron -30\r\nKPX Amacron uogonek -30\r\nKPX Amacron uring -30\r\nKPX Amacron v -40\r\nKPX Amacron w -30\r\nKPX Amacron y -30\r\nKPX Amacron yacute -30\r\nKPX Amacron ydieresis -30\r\nKPX Aogonek C -40\r\nKPX Aogonek Cacute -40\r\nKPX Aogonek Ccaron -40\r\nKPX Aogonek Ccedilla -40\r\nKPX Aogonek G -50\r\nKPX Aogonek Gbreve -50\r\nKPX Aogonek Gcommaaccent -50\r\nKPX Aogonek O -40\r\nKPX Aogonek Oacute -40\r\nKPX Aogonek Ocircumflex -40\r\nKPX Aogonek Odieresis -40\r\nKPX Aogonek Ograve -40\r\nKPX Aogonek Ohungarumlaut -40\r\nKPX Aogonek Omacron -40\r\nKPX Aogonek Oslash -40\r\nKPX Aogonek Otilde -40\r\nKPX Aogonek Q -40\r\nKPX Aogonek T -90\r\nKPX Aogonek Tcaron -90\r\nKPX Aogonek Tcommaaccent -90\r\nKPX Aogonek U -50\r\nKPX Aogonek Uacute -50\r\nKPX Aogonek Ucircumflex -50\r\nKPX Aogonek Udieresis -50\r\nKPX Aogonek Ugrave -50\r\nKPX Aogonek Uhungarumlaut -50\r\nKPX Aogonek Umacron -50\r\nKPX Aogonek Uogonek -50\r\nKPX Aogonek Uring -50\r\nKPX Aogonek V -80\r\nKPX Aogonek W -60\r\nKPX Aogonek Y -110\r\nKPX Aogonek Yacute -110\r\nKPX Aogonek Ydieresis -110\r\nKPX Aogonek u -30\r\nKPX Aogonek uacute -30\r\nKPX Aogonek ucircumflex -30\r\nKPX Aogonek udieresis -30\r\nKPX Aogonek ugrave -30\r\nKPX Aogonek uhungarumlaut -30\r\nKPX Aogonek umacron -30\r\nKPX Aogonek uogonek -30\r\nKPX Aogonek uring -30\r\nKPX Aogonek v -40\r\nKPX Aogonek w -30\r\nKPX Aogonek y -30\r\nKPX Aogonek yacute -30\r\nKPX Aogonek ydieresis -30\r\nKPX Aring C -40\r\nKPX Aring Cacute -40\r\nKPX Aring Ccaron -40\r\nKPX Aring Ccedilla -40\r\nKPX Aring G -50\r\nKPX Aring Gbreve -50\r\nKPX Aring Gcommaaccent -50\r\nKPX Aring O -40\r\nKPX Aring Oacute -40\r\nKPX Aring Ocircumflex -40\r\nKPX Aring Odieresis -40\r\nKPX Aring Ograve -40\r\nKPX Aring Ohungarumlaut -40\r\nKPX Aring Omacron -40\r\nKPX Aring Oslash -40\r\nKPX Aring Otilde -40\r\nKPX Aring Q -40\r\nKPX Aring T -90\r\nKPX Aring Tcaron -90\r\nKPX Aring Tcommaaccent -90\r\nKPX Aring U -50\r\nKPX Aring Uacute -50\r\nKPX Aring Ucircumflex -50\r\nKPX Aring Udieresis -50\r\nKPX Aring Ugrave -50\r\nKPX Aring Uhungarumlaut -50\r\nKPX Aring Umacron -50\r\nKPX Aring Uogonek -50\r\nKPX Aring Uring -50\r\nKPX Aring V -80\r\nKPX Aring W -60\r\nKPX Aring Y -110\r\nKPX Aring Yacute -110\r\nKPX Aring Ydieresis -110\r\nKPX Aring u -30\r\nKPX Aring uacute -30\r\nKPX Aring ucircumflex -30\r\nKPX Aring udieresis -30\r\nKPX Aring ugrave -30\r\nKPX Aring uhungarumlaut -30\r\nKPX Aring umacron -30\r\nKPX Aring uogonek -30\r\nKPX Aring uring -30\r\nKPX Aring v -40\r\nKPX Aring w -30\r\nKPX Aring y -30\r\nKPX Aring yacute -30\r\nKPX Aring ydieresis -30\r\nKPX Atilde C -40\r\nKPX Atilde Cacute -40\r\nKPX Atilde Ccaron -40\r\nKPX Atilde Ccedilla -40\r\nKPX Atilde G -50\r\nKPX Atilde Gbreve -50\r\nKPX Atilde Gcommaaccent -50\r\nKPX Atilde O -40\r\nKPX Atilde Oacute -40\r\nKPX Atilde Ocircumflex -40\r\nKPX Atilde Odieresis -40\r\nKPX Atilde Ograve -40\r\nKPX Atilde Ohungarumlaut -40\r\nKPX Atilde Omacron -40\r\nKPX Atilde Oslash -40\r\nKPX Atilde Otilde -40\r\nKPX Atilde Q -40\r\nKPX Atilde T -90\r\nKPX Atilde Tcaron -90\r\nKPX Atilde Tcommaaccent -90\r\nKPX Atilde U -50\r\nKPX Atilde Uacute -50\r\nKPX Atilde Ucircumflex -50\r\nKPX Atilde Udieresis -50\r\nKPX Atilde Ugrave -50\r\nKPX Atilde Uhungarumlaut -50\r\nKPX Atilde Umacron -50\r\nKPX Atilde Uogonek -50\r\nKPX Atilde Uring -50\r\nKPX Atilde V -80\r\nKPX Atilde W -60\r\nKPX Atilde Y -110\r\nKPX Atilde Yacute -110\r\nKPX Atilde Ydieresis -110\r\nKPX Atilde u -30\r\nKPX Atilde uacute -30\r\nKPX Atilde ucircumflex -30\r\nKPX Atilde udieresis -30\r\nKPX Atilde ugrave -30\r\nKPX Atilde uhungarumlaut -30\r\nKPX Atilde umacron -30\r\nKPX Atilde uogonek -30\r\nKPX Atilde uring -30\r\nKPX Atilde v -40\r\nKPX Atilde w -30\r\nKPX Atilde y -30\r\nKPX Atilde yacute -30\r\nKPX Atilde ydieresis -30\r\nKPX B A -30\r\nKPX B Aacute -30\r\nKPX B Abreve -30\r\nKPX B Acircumflex -30\r\nKPX B Adieresis -30\r\nKPX B Agrave -30\r\nKPX B Amacron -30\r\nKPX B Aogonek -30\r\nKPX B Aring -30\r\nKPX B Atilde -30\r\nKPX B U -10\r\nKPX B Uacute -10\r\nKPX B Ucircumflex -10\r\nKPX B Udieresis -10\r\nKPX B Ugrave -10\r\nKPX B Uhungarumlaut -10\r\nKPX B Umacron -10\r\nKPX B Uogonek -10\r\nKPX B Uring -10\r\nKPX D A -40\r\nKPX D Aacute -40\r\nKPX D Abreve -40\r\nKPX D Acircumflex -40\r\nKPX D Adieresis -40\r\nKPX D Agrave -40\r\nKPX D Amacron -40\r\nKPX D Aogonek -40\r\nKPX D Aring -40\r\nKPX D Atilde -40\r\nKPX D V -40\r\nKPX D W -40\r\nKPX D Y -70\r\nKPX D Yacute -70\r\nKPX D Ydieresis -70\r\nKPX D comma -30\r\nKPX D period -30\r\nKPX Dcaron A -40\r\nKPX Dcaron Aacute -40\r\nKPX Dcaron Abreve -40\r\nKPX Dcaron Acircumflex -40\r\nKPX Dcaron Adieresis -40\r\nKPX Dcaron Agrave -40\r\nKPX Dcaron Amacron -40\r\nKPX Dcaron Aogonek -40\r\nKPX Dcaron Aring -40\r\nKPX Dcaron Atilde -40\r\nKPX Dcaron V -40\r\nKPX Dcaron W -40\r\nKPX Dcaron Y -70\r\nKPX Dcaron Yacute -70\r\nKPX Dcaron Ydieresis -70\r\nKPX Dcaron comma -30\r\nKPX Dcaron period -30\r\nKPX Dcroat A -40\r\nKPX Dcroat Aacute -40\r\nKPX Dcroat Abreve -40\r\nKPX Dcroat Acircumflex -40\r\nKPX Dcroat Adieresis -40\r\nKPX Dcroat Agrave -40\r\nKPX Dcroat Amacron -40\r\nKPX Dcroat Aogonek -40\r\nKPX Dcroat Aring -40\r\nKPX Dcroat Atilde -40\r\nKPX Dcroat V -40\r\nKPX Dcroat W -40\r\nKPX Dcroat Y -70\r\nKPX Dcroat Yacute -70\r\nKPX Dcroat Ydieresis -70\r\nKPX Dcroat comma -30\r\nKPX Dcroat period -30\r\nKPX F A -80\r\nKPX F Aacute -80\r\nKPX F Abreve -80\r\nKPX F Acircumflex -80\r\nKPX F Adieresis -80\r\nKPX F Agrave -80\r\nKPX F Amacron -80\r\nKPX F Aogonek -80\r\nKPX F Aring -80\r\nKPX F Atilde -80\r\nKPX F a -20\r\nKPX F aacute -20\r\nKPX F abreve -20\r\nKPX F acircumflex -20\r\nKPX F adieresis -20\r\nKPX F agrave -20\r\nKPX F amacron -20\r\nKPX F aogonek -20\r\nKPX F aring -20\r\nKPX F atilde -20\r\nKPX F comma -100\r\nKPX F period -100\r\nKPX J A -20\r\nKPX J Aacute -20\r\nKPX J Abreve -20\r\nKPX J Acircumflex -20\r\nKPX J Adieresis -20\r\nKPX J Agrave -20\r\nKPX J Amacron -20\r\nKPX J Aogonek -20\r\nKPX J Aring -20\r\nKPX J Atilde -20\r\nKPX J comma -20\r\nKPX J period -20\r\nKPX J u -20\r\nKPX J uacute -20\r\nKPX J ucircumflex -20\r\nKPX J udieresis -20\r\nKPX J ugrave -20\r\nKPX J uhungarumlaut -20\r\nKPX J umacron -20\r\nKPX J uogonek -20\r\nKPX J uring -20\r\nKPX K O -30\r\nKPX K Oacute -30\r\nKPX K Ocircumflex -30\r\nKPX K Odieresis -30\r\nKPX K Ograve -30\r\nKPX K Ohungarumlaut -30\r\nKPX K Omacron -30\r\nKPX K Oslash -30\r\nKPX K Otilde -30\r\nKPX K e -15\r\nKPX K eacute -15\r\nKPX K ecaron -15\r\nKPX K ecircumflex -15\r\nKPX K edieresis -15\r\nKPX K edotaccent -15\r\nKPX K egrave -15\r\nKPX K emacron -15\r\nKPX K eogonek -15\r\nKPX K o -35\r\nKPX K oacute -35\r\nKPX K ocircumflex -35\r\nKPX K odieresis -35\r\nKPX K ograve -35\r\nKPX K ohungarumlaut -35\r\nKPX K omacron -35\r\nKPX K oslash -35\r\nKPX K otilde -35\r\nKPX K u -30\r\nKPX K uacute -30\r\nKPX K ucircumflex -30\r\nKPX K udieresis -30\r\nKPX K ugrave -30\r\nKPX K uhungarumlaut -30\r\nKPX K umacron -30\r\nKPX K uogonek -30\r\nKPX K uring -30\r\nKPX K y -40\r\nKPX K yacute -40\r\nKPX K ydieresis -40\r\nKPX Kcommaaccent O -30\r\nKPX Kcommaaccent Oacute -30\r\nKPX Kcommaaccent Ocircumflex -30\r\nKPX Kcommaaccent Odieresis -30\r\nKPX Kcommaaccent Ograve -30\r\nKPX Kcommaaccent Ohungarumlaut -30\r\nKPX Kcommaaccent Omacron -30\r\nKPX Kcommaaccent Oslash -30\r\nKPX Kcommaaccent Otilde -30\r\nKPX Kcommaaccent e -15\r\nKPX Kcommaaccent eacute -15\r\nKPX Kcommaaccent ecaron -15\r\nKPX Kcommaaccent ecircumflex -15\r\nKPX Kcommaaccent edieresis -15\r\nKPX Kcommaaccent edotaccent -15\r\nKPX Kcommaaccent egrave -15\r\nKPX Kcommaaccent emacron -15\r\nKPX Kcommaaccent eogonek -15\r\nKPX Kcommaaccent o -35\r\nKPX Kcommaaccent oacute -35\r\nKPX Kcommaaccent ocircumflex -35\r\nKPX Kcommaaccent odieresis -35\r\nKPX Kcommaaccent ograve -35\r\nKPX Kcommaaccent ohungarumlaut -35\r\nKPX Kcommaaccent omacron -35\r\nKPX Kcommaaccent oslash -35\r\nKPX Kcommaaccent otilde -35\r\nKPX Kcommaaccent u -30\r\nKPX Kcommaaccent uacute -30\r\nKPX Kcommaaccent ucircumflex -30\r\nKPX Kcommaaccent udieresis -30\r\nKPX Kcommaaccent ugrave -30\r\nKPX Kcommaaccent uhungarumlaut -30\r\nKPX Kcommaaccent umacron -30\r\nKPX Kcommaaccent uogonek -30\r\nKPX Kcommaaccent uring -30\r\nKPX Kcommaaccent y -40\r\nKPX Kcommaaccent yacute -40\r\nKPX Kcommaaccent ydieresis -40\r\nKPX L T -90\r\nKPX L Tcaron -90\r\nKPX L Tcommaaccent -90\r\nKPX L V -110\r\nKPX L W -80\r\nKPX L Y -120\r\nKPX L Yacute -120\r\nKPX L Ydieresis -120\r\nKPX L quotedblright -140\r\nKPX L quoteright -140\r\nKPX L y -30\r\nKPX L yacute -30\r\nKPX L ydieresis -30\r\nKPX Lacute T -90\r\nKPX Lacute Tcaron -90\r\nKPX Lacute Tcommaaccent -90\r\nKPX Lacute V -110\r\nKPX Lacute W -80\r\nKPX Lacute Y -120\r\nKPX Lacute Yacute -120\r\nKPX Lacute Ydieresis -120\r\nKPX Lacute quotedblright -140\r\nKPX Lacute quoteright -140\r\nKPX Lacute y -30\r\nKPX Lacute yacute -30\r\nKPX Lacute ydieresis -30\r\nKPX Lcommaaccent T -90\r\nKPX Lcommaaccent Tcaron -90\r\nKPX Lcommaaccent Tcommaaccent -90\r\nKPX Lcommaaccent V -110\r\nKPX Lcommaaccent W -80\r\nKPX Lcommaaccent Y -120\r\nKPX Lcommaaccent Yacute -120\r\nKPX Lcommaaccent Ydieresis -120\r\nKPX Lcommaaccent quotedblright -140\r\nKPX Lcommaaccent quoteright -140\r\nKPX Lcommaaccent y -30\r\nKPX Lcommaaccent yacute -30\r\nKPX Lcommaaccent ydieresis -30\r\nKPX Lslash T -90\r\nKPX Lslash Tcaron -90\r\nKPX Lslash Tcommaaccent -90\r\nKPX Lslash V -110\r\nKPX Lslash W -80\r\nKPX Lslash Y -120\r\nKPX Lslash Yacute -120\r\nKPX Lslash Ydieresis -120\r\nKPX Lslash quotedblright -140\r\nKPX Lslash quoteright -140\r\nKPX Lslash y -30\r\nKPX Lslash yacute -30\r\nKPX Lslash ydieresis -30\r\nKPX O A -50\r\nKPX O Aacute -50\r\nKPX O Abreve -50\r\nKPX O Acircumflex -50\r\nKPX O Adieresis -50\r\nKPX O Agrave -50\r\nKPX O Amacron -50\r\nKPX O Aogonek -50\r\nKPX O Aring -50\r\nKPX O Atilde -50\r\nKPX O T -40\r\nKPX O Tcaron -40\r\nKPX O Tcommaaccent -40\r\nKPX O V -50\r\nKPX O W -50\r\nKPX O X -50\r\nKPX O Y -70\r\nKPX O Yacute -70\r\nKPX O Ydieresis -70\r\nKPX O comma -40\r\nKPX O period -40\r\nKPX Oacute A -50\r\nKPX Oacute Aacute -50\r\nKPX Oacute Abreve -50\r\nKPX Oacute Acircumflex -50\r\nKPX Oacute Adieresis -50\r\nKPX Oacute Agrave -50\r\nKPX Oacute Amacron -50\r\nKPX Oacute Aogonek -50\r\nKPX Oacute Aring -50\r\nKPX Oacute Atilde -50\r\nKPX Oacute T -40\r\nKPX Oacute Tcaron -40\r\nKPX Oacute Tcommaaccent -40\r\nKPX Oacute V -50\r\nKPX Oacute W -50\r\nKPX Oacute X -50\r\nKPX Oacute Y -70\r\nKPX Oacute Yacute -70\r\nKPX Oacute Ydieresis -70\r\nKPX Oacute comma -40\r\nKPX Oacute period -40\r\nKPX Ocircumflex A -50\r\nKPX Ocircumflex Aacute -50\r\nKPX Ocircumflex Abreve -50\r\nKPX Ocircumflex Acircumflex -50\r\nKPX Ocircumflex Adieresis -50\r\nKPX Ocircumflex Agrave -50\r\nKPX Ocircumflex Amacron -50\r\nKPX Ocircumflex Aogonek -50\r\nKPX Ocircumflex Aring -50\r\nKPX Ocircumflex Atilde -50\r\nKPX Ocircumflex T -40\r\nKPX Ocircumflex Tcaron -40\r\nKPX Ocircumflex Tcommaaccent -40\r\nKPX Ocircumflex V -50\r\nKPX Ocircumflex W -50\r\nKPX Ocircumflex X -50\r\nKPX Ocircumflex Y -70\r\nKPX Ocircumflex Yacute -70\r\nKPX Ocircumflex Ydieresis -70\r\nKPX Ocircumflex comma -40\r\nKPX Ocircumflex period -40\r\nKPX Odieresis A -50\r\nKPX Odieresis Aacute -50\r\nKPX Odieresis Abreve -50\r\nKPX Odieresis Acircumflex -50\r\nKPX Odieresis Adieresis -50\r\nKPX Odieresis Agrave -50\r\nKPX Odieresis Amacron -50\r\nKPX Odieresis Aogonek -50\r\nKPX Odieresis Aring -50\r\nKPX Odieresis Atilde -50\r\nKPX Odieresis T -40\r\nKPX Odieresis Tcaron -40\r\nKPX Odieresis Tcommaaccent -40\r\nKPX Odieresis V -50\r\nKPX Odieresis W -50\r\nKPX Odieresis X -50\r\nKPX Odieresis Y -70\r\nKPX Odieresis Yacute -70\r\nKPX Odieresis Ydieresis -70\r\nKPX Odieresis comma -40\r\nKPX Odieresis period -40\r\nKPX Ograve A -50\r\nKPX Ograve Aacute -50\r\nKPX Ograve Abreve -50\r\nKPX Ograve Acircumflex -50\r\nKPX Ograve Adieresis -50\r\nKPX Ograve Agrave -50\r\nKPX Ograve Amacron -50\r\nKPX Ograve Aogonek -50\r\nKPX Ograve Aring -50\r\nKPX Ograve Atilde -50\r\nKPX Ograve T -40\r\nKPX Ograve Tcaron -40\r\nKPX Ograve Tcommaaccent -40\r\nKPX Ograve V -50\r\nKPX Ograve W -50\r\nKPX Ograve X -50\r\nKPX Ograve Y -70\r\nKPX Ograve Yacute -70\r\nKPX Ograve Ydieresis -70\r\nKPX Ograve comma -40\r\nKPX Ograve period -40\r\nKPX Ohungarumlaut A -50\r\nKPX Ohungarumlaut Aacute -50\r\nKPX Ohungarumlaut Abreve -50\r\nKPX Ohungarumlaut Acircumflex -50\r\nKPX Ohungarumlaut Adieresis -50\r\nKPX Ohungarumlaut Agrave -50\r\nKPX Ohungarumlaut Amacron -50\r\nKPX Ohungarumlaut Aogonek -50\r\nKPX Ohungarumlaut Aring -50\r\nKPX Ohungarumlaut Atilde -50\r\nKPX Ohungarumlaut T -40\r\nKPX Ohungarumlaut Tcaron -40\r\nKPX Ohungarumlaut Tcommaaccent -40\r\nKPX Ohungarumlaut V -50\r\nKPX Ohungarumlaut W -50\r\nKPX Ohungarumlaut X -50\r\nKPX Ohungarumlaut Y -70\r\nKPX Ohungarumlaut Yacute -70\r\nKPX Ohungarumlaut Ydieresis -70\r\nKPX Ohungarumlaut comma -40\r\nKPX Ohungarumlaut period -40\r\nKPX Omacron A -50\r\nKPX Omacron Aacute -50\r\nKPX Omacron Abreve -50\r\nKPX Omacron Acircumflex -50\r\nKPX Omacron Adieresis -50\r\nKPX Omacron Agrave -50\r\nKPX Omacron Amacron -50\r\nKPX Omacron Aogonek -50\r\nKPX Omacron Aring -50\r\nKPX Omacron Atilde -50\r\nKPX Omacron T -40\r\nKPX Omacron Tcaron -40\r\nKPX Omacron Tcommaaccent -40\r\nKPX Omacron V -50\r\nKPX Omacron W -50\r\nKPX Omacron X -50\r\nKPX Omacron Y -70\r\nKPX Omacron Yacute -70\r\nKPX Omacron Ydieresis -70\r\nKPX Omacron comma -40\r\nKPX Omacron period -40\r\nKPX Oslash A -50\r\nKPX Oslash Aacute -50\r\nKPX Oslash Abreve -50\r\nKPX Oslash Acircumflex -50\r\nKPX Oslash Adieresis -50\r\nKPX Oslash Agrave -50\r\nKPX Oslash Amacron -50\r\nKPX Oslash Aogonek -50\r\nKPX Oslash Aring -50\r\nKPX Oslash Atilde -50\r\nKPX Oslash T -40\r\nKPX Oslash Tcaron -40\r\nKPX Oslash Tcommaaccent -40\r\nKPX Oslash V -50\r\nKPX Oslash W -50\r\nKPX Oslash X -50\r\nKPX Oslash Y -70\r\nKPX Oslash Yacute -70\r\nKPX Oslash Ydieresis -70\r\nKPX Oslash comma -40\r\nKPX Oslash period -40\r\nKPX Otilde A -50\r\nKPX Otilde Aacute -50\r\nKPX Otilde Abreve -50\r\nKPX Otilde Acircumflex -50\r\nKPX Otilde Adieresis -50\r\nKPX Otilde Agrave -50\r\nKPX Otilde Amacron -50\r\nKPX Otilde Aogonek -50\r\nKPX Otilde Aring -50\r\nKPX Otilde Atilde -50\r\nKPX Otilde T -40\r\nKPX Otilde Tcaron -40\r\nKPX Otilde Tcommaaccent -40\r\nKPX Otilde V -50\r\nKPX Otilde W -50\r\nKPX Otilde X -50\r\nKPX Otilde Y -70\r\nKPX Otilde Yacute -70\r\nKPX Otilde Ydieresis -70\r\nKPX Otilde comma -40\r\nKPX Otilde period -40\r\nKPX P A -100\r\nKPX P Aacute -100\r\nKPX P Abreve -100\r\nKPX P Acircumflex -100\r\nKPX P Adieresis -100\r\nKPX P Agrave -100\r\nKPX P Amacron -100\r\nKPX P Aogonek -100\r\nKPX P Aring -100\r\nKPX P Atilde -100\r\nKPX P a -30\r\nKPX P aacute -30\r\nKPX P abreve -30\r\nKPX P acircumflex -30\r\nKPX P adieresis -30\r\nKPX P agrave -30\r\nKPX P amacron -30\r\nKPX P aogonek -30\r\nKPX P aring -30\r\nKPX P atilde -30\r\nKPX P comma -120\r\nKPX P e -30\r\nKPX P eacute -30\r\nKPX P ecaron -30\r\nKPX P ecircumflex -30\r\nKPX P edieresis -30\r\nKPX P edotaccent -30\r\nKPX P egrave -30\r\nKPX P emacron -30\r\nKPX P eogonek -30\r\nKPX P o -40\r\nKPX P oacute -40\r\nKPX P ocircumflex -40\r\nKPX P odieresis -40\r\nKPX P ograve -40\r\nKPX P ohungarumlaut -40\r\nKPX P omacron -40\r\nKPX P oslash -40\r\nKPX P otilde -40\r\nKPX P period -120\r\nKPX Q U -10\r\nKPX Q Uacute -10\r\nKPX Q Ucircumflex -10\r\nKPX Q Udieresis -10\r\nKPX Q Ugrave -10\r\nKPX Q Uhungarumlaut -10\r\nKPX Q Umacron -10\r\nKPX Q Uogonek -10\r\nKPX Q Uring -10\r\nKPX Q comma 20\r\nKPX Q period 20\r\nKPX R O -20\r\nKPX R Oacute -20\r\nKPX R Ocircumflex -20\r\nKPX R Odieresis -20\r\nKPX R Ograve -20\r\nKPX R Ohungarumlaut -20\r\nKPX R Omacron -20\r\nKPX R Oslash -20\r\nKPX R Otilde -20\r\nKPX R T -20\r\nKPX R Tcaron -20\r\nKPX R Tcommaaccent -20\r\nKPX R U -20\r\nKPX R Uacute -20\r\nKPX R Ucircumflex -20\r\nKPX R Udieresis -20\r\nKPX R Ugrave -20\r\nKPX R Uhungarumlaut -20\r\nKPX R Umacron -20\r\nKPX R Uogonek -20\r\nKPX R Uring -20\r\nKPX R V -50\r\nKPX R W -40\r\nKPX R Y -50\r\nKPX R Yacute -50\r\nKPX R Ydieresis -50\r\nKPX Racute O -20\r\nKPX Racute Oacute -20\r\nKPX Racute Ocircumflex -20\r\nKPX Racute Odieresis -20\r\nKPX Racute Ograve -20\r\nKPX Racute Ohungarumlaut -20\r\nKPX Racute Omacron -20\r\nKPX Racute Oslash -20\r\nKPX Racute Otilde -20\r\nKPX Racute T -20\r\nKPX Racute Tcaron -20\r\nKPX Racute Tcommaaccent -20\r\nKPX Racute U -20\r\nKPX Racute Uacute -20\r\nKPX Racute Ucircumflex -20\r\nKPX Racute Udieresis -20\r\nKPX Racute Ugrave -20\r\nKPX Racute Uhungarumlaut -20\r\nKPX Racute Umacron -20\r\nKPX Racute Uogonek -20\r\nKPX Racute Uring -20\r\nKPX Racute V -50\r\nKPX Racute W -40\r\nKPX Racute Y -50\r\nKPX Racute Yacute -50\r\nKPX Racute Ydieresis -50\r\nKPX Rcaron O -20\r\nKPX Rcaron Oacute -20\r\nKPX Rcaron Ocircumflex -20\r\nKPX Rcaron Odieresis -20\r\nKPX Rcaron Ograve -20\r\nKPX Rcaron Ohungarumlaut -20\r\nKPX Rcaron Omacron -20\r\nKPX Rcaron Oslash -20\r\nKPX Rcaron Otilde -20\r\nKPX Rcaron T -20\r\nKPX Rcaron Tcaron -20\r\nKPX Rcaron Tcommaaccent -20\r\nKPX Rcaron U -20\r\nKPX Rcaron Uacute -20\r\nKPX Rcaron Ucircumflex -20\r\nKPX Rcaron Udieresis -20\r\nKPX Rcaron Ugrave -20\r\nKPX Rcaron Uhungarumlaut -20\r\nKPX Rcaron Umacron -20\r\nKPX Rcaron Uogonek -20\r\nKPX Rcaron Uring -20\r\nKPX Rcaron V -50\r\nKPX Rcaron W -40\r\nKPX Rcaron Y -50\r\nKPX Rcaron Yacute -50\r\nKPX Rcaron Ydieresis -50\r\nKPX Rcommaaccent O -20\r\nKPX Rcommaaccent Oacute -20\r\nKPX Rcommaaccent Ocircumflex -20\r\nKPX Rcommaaccent Odieresis -20\r\nKPX Rcommaaccent Ograve -20\r\nKPX Rcommaaccent Ohungarumlaut -20\r\nKPX Rcommaaccent Omacron -20\r\nKPX Rcommaaccent Oslash -20\r\nKPX Rcommaaccent Otilde -20\r\nKPX Rcommaaccent T -20\r\nKPX Rcommaaccent Tcaron -20\r\nKPX Rcommaaccent Tcommaaccent -20\r\nKPX Rcommaaccent U -20\r\nKPX Rcommaaccent Uacute -20\r\nKPX Rcommaaccent Ucircumflex -20\r\nKPX Rcommaaccent Udieresis -20\r\nKPX Rcommaaccent Ugrave -20\r\nKPX Rcommaaccent Uhungarumlaut -20\r\nKPX Rcommaaccent Umacron -20\r\nKPX Rcommaaccent Uogonek -20\r\nKPX Rcommaaccent Uring -20\r\nKPX Rcommaaccent V -50\r\nKPX Rcommaaccent W -40\r\nKPX Rcommaaccent Y -50\r\nKPX Rcommaaccent Yacute -50\r\nKPX Rcommaaccent Ydieresis -50\r\nKPX T A -90\r\nKPX T Aacute -90\r\nKPX T Abreve -90\r\nKPX T Acircumflex -90\r\nKPX T Adieresis -90\r\nKPX T Agrave -90\r\nKPX T Amacron -90\r\nKPX T Aogonek -90\r\nKPX T Aring -90\r\nKPX T Atilde -90\r\nKPX T O -40\r\nKPX T Oacute -40\r\nKPX T Ocircumflex -40\r\nKPX T Odieresis -40\r\nKPX T Ograve -40\r\nKPX T Ohungarumlaut -40\r\nKPX T Omacron -40\r\nKPX T Oslash -40\r\nKPX T Otilde -40\r\nKPX T a -80\r\nKPX T aacute -80\r\nKPX T abreve -80\r\nKPX T acircumflex -80\r\nKPX T adieresis -80\r\nKPX T agrave -80\r\nKPX T amacron -80\r\nKPX T aogonek -80\r\nKPX T aring -80\r\nKPX T atilde -80\r\nKPX T colon -40\r\nKPX T comma -80\r\nKPX T e -60\r\nKPX T eacute -60\r\nKPX T ecaron -60\r\nKPX T ecircumflex -60\r\nKPX T edieresis -60\r\nKPX T edotaccent -60\r\nKPX T egrave -60\r\nKPX T emacron -60\r\nKPX T eogonek -60\r\nKPX T hyphen -120\r\nKPX T o -80\r\nKPX T oacute -80\r\nKPX T ocircumflex -80\r\nKPX T odieresis -80\r\nKPX T ograve -80\r\nKPX T ohungarumlaut -80\r\nKPX T omacron -80\r\nKPX T oslash -80\r\nKPX T otilde -80\r\nKPX T period -80\r\nKPX T r -80\r\nKPX T racute -80\r\nKPX T rcommaaccent -80\r\nKPX T semicolon -40\r\nKPX T u -90\r\nKPX T uacute -90\r\nKPX T ucircumflex -90\r\nKPX T udieresis -90\r\nKPX T ugrave -90\r\nKPX T uhungarumlaut -90\r\nKPX T umacron -90\r\nKPX T uogonek -90\r\nKPX T uring -90\r\nKPX T w -60\r\nKPX T y -60\r\nKPX T yacute -60\r\nKPX T ydieresis -60\r\nKPX Tcaron A -90\r\nKPX Tcaron Aacute -90\r\nKPX Tcaron Abreve -90\r\nKPX Tcaron Acircumflex -90\r\nKPX Tcaron Adieresis -90\r\nKPX Tcaron Agrave -90\r\nKPX Tcaron Amacron -90\r\nKPX Tcaron Aogonek -90\r\nKPX Tcaron Aring -90\r\nKPX Tcaron Atilde -90\r\nKPX Tcaron O -40\r\nKPX Tcaron Oacute -40\r\nKPX Tcaron Ocircumflex -40\r\nKPX Tcaron Odieresis -40\r\nKPX Tcaron Ograve -40\r\nKPX Tcaron Ohungarumlaut -40\r\nKPX Tcaron Omacron -40\r\nKPX Tcaron Oslash -40\r\nKPX Tcaron Otilde -40\r\nKPX Tcaron a -80\r\nKPX Tcaron aacute -80\r\nKPX Tcaron abreve -80\r\nKPX Tcaron acircumflex -80\r\nKPX Tcaron adieresis -80\r\nKPX Tcaron agrave -80\r\nKPX Tcaron amacron -80\r\nKPX Tcaron aogonek -80\r\nKPX Tcaron aring -80\r\nKPX Tcaron atilde -80\r\nKPX Tcaron colon -40\r\nKPX Tcaron comma -80\r\nKPX Tcaron e -60\r\nKPX Tcaron eacute -60\r\nKPX Tcaron ecaron -60\r\nKPX Tcaron ecircumflex -60\r\nKPX Tcaron edieresis -60\r\nKPX Tcaron edotaccent -60\r\nKPX Tcaron egrave -60\r\nKPX Tcaron emacron -60\r\nKPX Tcaron eogonek -60\r\nKPX Tcaron hyphen -120\r\nKPX Tcaron o -80\r\nKPX Tcaron oacute -80\r\nKPX Tcaron ocircumflex -80\r\nKPX Tcaron odieresis -80\r\nKPX Tcaron ograve -80\r\nKPX Tcaron ohungarumlaut -80\r\nKPX Tcaron omacron -80\r\nKPX Tcaron oslash -80\r\nKPX Tcaron otilde -80\r\nKPX Tcaron period -80\r\nKPX Tcaron r -80\r\nKPX Tcaron racute -80\r\nKPX Tcaron rcommaaccent -80\r\nKPX Tcaron semicolon -40\r\nKPX Tcaron u -90\r\nKPX Tcaron uacute -90\r\nKPX Tcaron ucircumflex -90\r\nKPX Tcaron udieresis -90\r\nKPX Tcaron ugrave -90\r\nKPX Tcaron uhungarumlaut -90\r\nKPX Tcaron umacron -90\r\nKPX Tcaron uogonek -90\r\nKPX Tcaron uring -90\r\nKPX Tcaron w -60\r\nKPX Tcaron y -60\r\nKPX Tcaron yacute -60\r\nKPX Tcaron ydieresis -60\r\nKPX Tcommaaccent A -90\r\nKPX Tcommaaccent Aacute -90\r\nKPX Tcommaaccent Abreve -90\r\nKPX Tcommaaccent Acircumflex -90\r\nKPX Tcommaaccent Adieresis -90\r\nKPX Tcommaaccent Agrave -90\r\nKPX Tcommaaccent Amacron -90\r\nKPX Tcommaaccent Aogonek -90\r\nKPX Tcommaaccent Aring -90\r\nKPX Tcommaaccent Atilde -90\r\nKPX Tcommaaccent O -40\r\nKPX Tcommaaccent Oacute -40\r\nKPX Tcommaaccent Ocircumflex -40\r\nKPX Tcommaaccent Odieresis -40\r\nKPX Tcommaaccent Ograve -40\r\nKPX Tcommaaccent Ohungarumlaut -40\r\nKPX Tcommaaccent Omacron -40\r\nKPX Tcommaaccent Oslash -40\r\nKPX Tcommaaccent Otilde -40\r\nKPX Tcommaaccent a -80\r\nKPX Tcommaaccent aacute -80\r\nKPX Tcommaaccent abreve -80\r\nKPX Tcommaaccent acircumflex -80\r\nKPX Tcommaaccent adieresis -80\r\nKPX Tcommaaccent agrave -80\r\nKPX Tcommaaccent amacron -80\r\nKPX Tcommaaccent aogonek -80\r\nKPX Tcommaaccent aring -80\r\nKPX Tcommaaccent atilde -80\r\nKPX Tcommaaccent colon -40\r\nKPX Tcommaaccent comma -80\r\nKPX Tcommaaccent e -60\r\nKPX Tcommaaccent eacute -60\r\nKPX Tcommaaccent ecaron -60\r\nKPX Tcommaaccent ecircumflex -60\r\nKPX Tcommaaccent edieresis -60\r\nKPX Tcommaaccent edotaccent -60\r\nKPX Tcommaaccent egrave -60\r\nKPX Tcommaaccent emacron -60\r\nKPX Tcommaaccent eogonek -60\r\nKPX Tcommaaccent hyphen -120\r\nKPX Tcommaaccent o -80\r\nKPX Tcommaaccent oacute -80\r\nKPX Tcommaaccent ocircumflex -80\r\nKPX Tcommaaccent odieresis -80\r\nKPX Tcommaaccent ograve -80\r\nKPX Tcommaaccent ohungarumlaut -80\r\nKPX Tcommaaccent omacron -80\r\nKPX Tcommaaccent oslash -80\r\nKPX Tcommaaccent otilde -80\r\nKPX Tcommaaccent period -80\r\nKPX Tcommaaccent r -80\r\nKPX Tcommaaccent racute -80\r\nKPX Tcommaaccent rcommaaccent -80\r\nKPX Tcommaaccent semicolon -40\r\nKPX Tcommaaccent u -90\r\nKPX Tcommaaccent uacute -90\r\nKPX Tcommaaccent ucircumflex -90\r\nKPX Tcommaaccent udieresis -90\r\nKPX Tcommaaccent ugrave -90\r\nKPX Tcommaaccent uhungarumlaut -90\r\nKPX Tcommaaccent umacron -90\r\nKPX Tcommaaccent uogonek -90\r\nKPX Tcommaaccent uring -90\r\nKPX Tcommaaccent w -60\r\nKPX Tcommaaccent y -60\r\nKPX Tcommaaccent yacute -60\r\nKPX Tcommaaccent ydieresis -60\r\nKPX U A -50\r\nKPX U Aacute -50\r\nKPX U Abreve -50\r\nKPX U Acircumflex -50\r\nKPX U Adieresis -50\r\nKPX U Agrave -50\r\nKPX U Amacron -50\r\nKPX U Aogonek -50\r\nKPX U Aring -50\r\nKPX U Atilde -50\r\nKPX U comma -30\r\nKPX U period -30\r\nKPX Uacute A -50\r\nKPX Uacute Aacute -50\r\nKPX Uacute Abreve -50\r\nKPX Uacute Acircumflex -50\r\nKPX Uacute Adieresis -50\r\nKPX Uacute Agrave -50\r\nKPX Uacute Amacron -50\r\nKPX Uacute Aogonek -50\r\nKPX Uacute Aring -50\r\nKPX Uacute Atilde -50\r\nKPX Uacute comma -30\r\nKPX Uacute period -30\r\nKPX Ucircumflex A -50\r\nKPX Ucircumflex Aacute -50\r\nKPX Ucircumflex Abreve -50\r\nKPX Ucircumflex Acircumflex -50\r\nKPX Ucircumflex Adieresis -50\r\nKPX Ucircumflex Agrave -50\r\nKPX Ucircumflex Amacron -50\r\nKPX Ucircumflex Aogonek -50\r\nKPX Ucircumflex Aring -50\r\nKPX Ucircumflex Atilde -50\r\nKPX Ucircumflex comma -30\r\nKPX Ucircumflex period -30\r\nKPX Udieresis A -50\r\nKPX Udieresis Aacute -50\r\nKPX Udieresis Abreve -50\r\nKPX Udieresis Acircumflex -50\r\nKPX Udieresis Adieresis -50\r\nKPX Udieresis Agrave -50\r\nKPX Udieresis Amacron -50\r\nKPX Udieresis Aogonek -50\r\nKPX Udieresis Aring -50\r\nKPX Udieresis Atilde -50\r\nKPX Udieresis comma -30\r\nKPX Udieresis period -30\r\nKPX Ugrave A -50\r\nKPX Ugrave Aacute -50\r\nKPX Ugrave Abreve -50\r\nKPX Ugrave Acircumflex -50\r\nKPX Ugrave Adieresis -50\r\nKPX Ugrave Agrave -50\r\nKPX Ugrave Amacron -50\r\nKPX Ugrave Aogonek -50\r\nKPX Ugrave Aring -50\r\nKPX Ugrave Atilde -50\r\nKPX Ugrave comma -30\r\nKPX Ugrave period -30\r\nKPX Uhungarumlaut A -50\r\nKPX Uhungarumlaut Aacute -50\r\nKPX Uhungarumlaut Abreve -50\r\nKPX Uhungarumlaut Acircumflex -50\r\nKPX Uhungarumlaut Adieresis -50\r\nKPX Uhungarumlaut Agrave -50\r\nKPX Uhungarumlaut Amacron -50\r\nKPX Uhungarumlaut Aogonek -50\r\nKPX Uhungarumlaut Aring -50\r\nKPX Uhungarumlaut Atilde -50\r\nKPX Uhungarumlaut comma -30\r\nKPX Uhungarumlaut period -30\r\nKPX Umacron A -50\r\nKPX Umacron Aacute -50\r\nKPX Umacron Abreve -50\r\nKPX Umacron Acircumflex -50\r\nKPX Umacron Adieresis -50\r\nKPX Umacron Agrave -50\r\nKPX Umacron Amacron -50\r\nKPX Umacron Aogonek -50\r\nKPX Umacron Aring -50\r\nKPX Umacron Atilde -50\r\nKPX Umacron comma -30\r\nKPX Umacron period -30\r\nKPX Uogonek A -50\r\nKPX Uogonek Aacute -50\r\nKPX Uogonek Abreve -50\r\nKPX Uogonek Acircumflex -50\r\nKPX Uogonek Adieresis -50\r\nKPX Uogonek Agrave -50\r\nKPX Uogonek Amacron -50\r\nKPX Uogonek Aogonek -50\r\nKPX Uogonek Aring -50\r\nKPX Uogonek Atilde -50\r\nKPX Uogonek comma -30\r\nKPX Uogonek period -30\r\nKPX Uring A -50\r\nKPX Uring Aacute -50\r\nKPX Uring Abreve -50\r\nKPX Uring Acircumflex -50\r\nKPX Uring Adieresis -50\r\nKPX Uring Agrave -50\r\nKPX Uring Amacron -50\r\nKPX Uring Aogonek -50\r\nKPX Uring Aring -50\r\nKPX Uring Atilde -50\r\nKPX Uring comma -30\r\nKPX Uring period -30\r\nKPX V A -80\r\nKPX V Aacute -80\r\nKPX V Abreve -80\r\nKPX V Acircumflex -80\r\nKPX V Adieresis -80\r\nKPX V Agrave -80\r\nKPX V Amacron -80\r\nKPX V Aogonek -80\r\nKPX V Aring -80\r\nKPX V Atilde -80\r\nKPX V G -50\r\nKPX V Gbreve -50\r\nKPX V Gcommaaccent -50\r\nKPX V O -50\r\nKPX V Oacute -50\r\nKPX V Ocircumflex -50\r\nKPX V Odieresis -50\r\nKPX V Ograve -50\r\nKPX V Ohungarumlaut -50\r\nKPX V Omacron -50\r\nKPX V Oslash -50\r\nKPX V Otilde -50\r\nKPX V a -60\r\nKPX V aacute -60\r\nKPX V abreve -60\r\nKPX V acircumflex -60\r\nKPX V adieresis -60\r\nKPX V agrave -60\r\nKPX V amacron -60\r\nKPX V aogonek -60\r\nKPX V aring -60\r\nKPX V atilde -60\r\nKPX V colon -40\r\nKPX V comma -120\r\nKPX V e -50\r\nKPX V eacute -50\r\nKPX V ecaron -50\r\nKPX V ecircumflex -50\r\nKPX V edieresis -50\r\nKPX V edotaccent -50\r\nKPX V egrave -50\r\nKPX V emacron -50\r\nKPX V eogonek -50\r\nKPX V hyphen -80\r\nKPX V o -90\r\nKPX V oacute -90\r\nKPX V ocircumflex -90\r\nKPX V odieresis -90\r\nKPX V ograve -90\r\nKPX V ohungarumlaut -90\r\nKPX V omacron -90\r\nKPX V oslash -90\r\nKPX V otilde -90\r\nKPX V period -120\r\nKPX V semicolon -40\r\nKPX V u -60\r\nKPX V uacute -60\r\nKPX V ucircumflex -60\r\nKPX V udieresis -60\r\nKPX V ugrave -60\r\nKPX V uhungarumlaut -60\r\nKPX V umacron -60\r\nKPX V uogonek -60\r\nKPX V uring -60\r\nKPX W A -60\r\nKPX W Aacute -60\r\nKPX W Abreve -60\r\nKPX W Acircumflex -60\r\nKPX W Adieresis -60\r\nKPX W Agrave -60\r\nKPX W Amacron -60\r\nKPX W Aogonek -60\r\nKPX W Aring -60\r\nKPX W Atilde -60\r\nKPX W O -20\r\nKPX W Oacute -20\r\nKPX W Ocircumflex -20\r\nKPX W Odieresis -20\r\nKPX W Ograve -20\r\nKPX W Ohungarumlaut -20\r\nKPX W Omacron -20\r\nKPX W Oslash -20\r\nKPX W Otilde -20\r\nKPX W a -40\r\nKPX W aacute -40\r\nKPX W abreve -40\r\nKPX W acircumflex -40\r\nKPX W adieresis -40\r\nKPX W agrave -40\r\nKPX W amacron -40\r\nKPX W aogonek -40\r\nKPX W aring -40\r\nKPX W atilde -40\r\nKPX W colon -10\r\nKPX W comma -80\r\nKPX W e -35\r\nKPX W eacute -35\r\nKPX W ecaron -35\r\nKPX W ecircumflex -35\r\nKPX W edieresis -35\r\nKPX W edotaccent -35\r\nKPX W egrave -35\r\nKPX W emacron -35\r\nKPX W eogonek -35\r\nKPX W hyphen -40\r\nKPX W o -60\r\nKPX W oacute -60\r\nKPX W ocircumflex -60\r\nKPX W odieresis -60\r\nKPX W ograve -60\r\nKPX W ohungarumlaut -60\r\nKPX W omacron -60\r\nKPX W oslash -60\r\nKPX W otilde -60\r\nKPX W period -80\r\nKPX W semicolon -10\r\nKPX W u -45\r\nKPX W uacute -45\r\nKPX W ucircumflex -45\r\nKPX W udieresis -45\r\nKPX W ugrave -45\r\nKPX W uhungarumlaut -45\r\nKPX W umacron -45\r\nKPX W uogonek -45\r\nKPX W uring -45\r\nKPX W y -20\r\nKPX W yacute -20\r\nKPX W ydieresis -20\r\nKPX Y A -110\r\nKPX Y Aacute -110\r\nKPX Y Abreve -110\r\nKPX Y Acircumflex -110\r\nKPX Y Adieresis -110\r\nKPX Y Agrave -110\r\nKPX Y Amacron -110\r\nKPX Y Aogonek -110\r\nKPX Y Aring -110\r\nKPX Y Atilde -110\r\nKPX Y O -70\r\nKPX Y Oacute -70\r\nKPX Y Ocircumflex -70\r\nKPX Y Odieresis -70\r\nKPX Y Ograve -70\r\nKPX Y Ohungarumlaut -70\r\nKPX Y Omacron -70\r\nKPX Y Oslash -70\r\nKPX Y Otilde -70\r\nKPX Y a -90\r\nKPX Y aacute -90\r\nKPX Y abreve -90\r\nKPX Y acircumflex -90\r\nKPX Y adieresis -90\r\nKPX Y agrave -90\r\nKPX Y amacron -90\r\nKPX Y aogonek -90\r\nKPX Y aring -90\r\nKPX Y atilde -90\r\nKPX Y colon -50\r\nKPX Y comma -100\r\nKPX Y e -80\r\nKPX Y eacute -80\r\nKPX Y ecaron -80\r\nKPX Y ecircumflex -80\r\nKPX Y edieresis -80\r\nKPX Y edotaccent -80\r\nKPX Y egrave -80\r\nKPX Y emacron -80\r\nKPX Y eogonek -80\r\nKPX Y o -100\r\nKPX Y oacute -100\r\nKPX Y ocircumflex -100\r\nKPX Y odieresis -100\r\nKPX Y ograve -100\r\nKPX Y ohungarumlaut -100\r\nKPX Y omacron -100\r\nKPX Y oslash -100\r\nKPX Y otilde -100\r\nKPX Y period -100\r\nKPX Y semicolon -50\r\nKPX Y u -100\r\nKPX Y uacute -100\r\nKPX Y ucircumflex -100\r\nKPX Y udieresis -100\r\nKPX Y ugrave -100\r\nKPX Y uhungarumlaut -100\r\nKPX Y umacron -100\r\nKPX Y uogonek -100\r\nKPX Y uring -100\r\nKPX Yacute A -110\r\nKPX Yacute Aacute -110\r\nKPX Yacute Abreve -110\r\nKPX Yacute Acircumflex -110\r\nKPX Yacute Adieresis -110\r\nKPX Yacute Agrave -110\r\nKPX Yacute Amacron -110\r\nKPX Yacute Aogonek -110\r\nKPX Yacute Aring -110\r\nKPX Yacute Atilde -110\r\nKPX Yacute O -70\r\nKPX Yacute Oacute -70\r\nKPX Yacute Ocircumflex -70\r\nKPX Yacute Odieresis -70\r\nKPX Yacute Ograve -70\r\nKPX Yacute Ohungarumlaut -70\r\nKPX Yacute Omacron -70\r\nKPX Yacute Oslash -70\r\nKPX Yacute Otilde -70\r\nKPX Yacute a -90\r\nKPX Yacute aacute -90\r\nKPX Yacute abreve -90\r\nKPX Yacute acircumflex -90\r\nKPX Yacute adieresis -90\r\nKPX Yacute agrave -90\r\nKPX Yacute amacron -90\r\nKPX Yacute aogonek -90\r\nKPX Yacute aring -90\r\nKPX Yacute atilde -90\r\nKPX Yacute colon -50\r\nKPX Yacute comma -100\r\nKPX Yacute e -80\r\nKPX Yacute eacute -80\r\nKPX Yacute ecaron -80\r\nKPX Yacute ecircumflex -80\r\nKPX Yacute edieresis -80\r\nKPX Yacute edotaccent -80\r\nKPX Yacute egrave -80\r\nKPX Yacute emacron -80\r\nKPX Yacute eogonek -80\r\nKPX Yacute o -100\r\nKPX Yacute oacute -100\r\nKPX Yacute ocircumflex -100\r\nKPX Yacute odieresis -100\r\nKPX Yacute ograve -100\r\nKPX Yacute ohungarumlaut -100\r\nKPX Yacute omacron -100\r\nKPX Yacute oslash -100\r\nKPX Yacute otilde -100\r\nKPX Yacute period -100\r\nKPX Yacute semicolon -50\r\nKPX Yacute u -100\r\nKPX Yacute uacute -100\r\nKPX Yacute ucircumflex -100\r\nKPX Yacute udieresis -100\r\nKPX Yacute ugrave -100\r\nKPX Yacute uhungarumlaut -100\r\nKPX Yacute umacron -100\r\nKPX Yacute uogonek -100\r\nKPX Yacute uring -100\r\nKPX Ydieresis A -110\r\nKPX Ydieresis Aacute -110\r\nKPX Ydieresis Abreve -110\r\nKPX Ydieresis Acircumflex -110\r\nKPX Ydieresis Adieresis -110\r\nKPX Ydieresis Agrave -110\r\nKPX Ydieresis Amacron -110\r\nKPX Ydieresis Aogonek -110\r\nKPX Ydieresis Aring -110\r\nKPX Ydieresis Atilde -110\r\nKPX Ydieresis O -70\r\nKPX Ydieresis Oacute -70\r\nKPX Ydieresis Ocircumflex -70\r\nKPX Ydieresis Odieresis -70\r\nKPX Ydieresis Ograve -70\r\nKPX Ydieresis Ohungarumlaut -70\r\nKPX Ydieresis Omacron -70\r\nKPX Ydieresis Oslash -70\r\nKPX Ydieresis Otilde -70\r\nKPX Ydieresis a -90\r\nKPX Ydieresis aacute -90\r\nKPX Ydieresis abreve -90\r\nKPX Ydieresis acircumflex -90\r\nKPX Ydieresis adieresis -90\r\nKPX Ydieresis agrave -90\r\nKPX Ydieresis amacron -90\r\nKPX Ydieresis aogonek -90\r\nKPX Ydieresis aring -90\r\nKPX Ydieresis atilde -90\r\nKPX Ydieresis colon -50\r\nKPX Ydieresis comma -100\r\nKPX Ydieresis e -80\r\nKPX Ydieresis eacute -80\r\nKPX Ydieresis ecaron -80\r\nKPX Ydieresis ecircumflex -80\r\nKPX Ydieresis edieresis -80\r\nKPX Ydieresis edotaccent -80\r\nKPX Ydieresis egrave -80\r\nKPX Ydieresis emacron -80\r\nKPX Ydieresis eogonek -80\r\nKPX Ydieresis o -100\r\nKPX Ydieresis oacute -100\r\nKPX Ydieresis ocircumflex -100\r\nKPX Ydieresis odieresis -100\r\nKPX Ydieresis ograve -100\r\nKPX Ydieresis ohungarumlaut -100\r\nKPX Ydieresis omacron -100\r\nKPX Ydieresis oslash -100\r\nKPX Ydieresis otilde -100\r\nKPX Ydieresis period -100\r\nKPX Ydieresis semicolon -50\r\nKPX Ydieresis u -100\r\nKPX Ydieresis uacute -100\r\nKPX Ydieresis ucircumflex -100\r\nKPX Ydieresis udieresis -100\r\nKPX Ydieresis ugrave -100\r\nKPX Ydieresis uhungarumlaut -100\r\nKPX Ydieresis umacron -100\r\nKPX Ydieresis uogonek -100\r\nKPX Ydieresis uring -100\r\nKPX a g -10\r\nKPX a gbreve -10\r\nKPX a gcommaaccent -10\r\nKPX a v -15\r\nKPX a w -15\r\nKPX a y -20\r\nKPX a yacute -20\r\nKPX a ydieresis -20\r\nKPX aacute g -10\r\nKPX aacute gbreve -10\r\nKPX aacute gcommaaccent -10\r\nKPX aacute v -15\r\nKPX aacute w -15\r\nKPX aacute y -20\r\nKPX aacute yacute -20\r\nKPX aacute ydieresis -20\r\nKPX abreve g -10\r\nKPX abreve gbreve -10\r\nKPX abreve gcommaaccent -10\r\nKPX abreve v -15\r\nKPX abreve w -15\r\nKPX abreve y -20\r\nKPX abreve yacute -20\r\nKPX abreve ydieresis -20\r\nKPX acircumflex g -10\r\nKPX acircumflex gbreve -10\r\nKPX acircumflex gcommaaccent -10\r\nKPX acircumflex v -15\r\nKPX acircumflex w -15\r\nKPX acircumflex y -20\r\nKPX acircumflex yacute -20\r\nKPX acircumflex ydieresis -20\r\nKPX adieresis g -10\r\nKPX adieresis gbreve -10\r\nKPX adieresis gcommaaccent -10\r\nKPX adieresis v -15\r\nKPX adieresis w -15\r\nKPX adieresis y -20\r\nKPX adieresis yacute -20\r\nKPX adieresis ydieresis -20\r\nKPX agrave g -10\r\nKPX agrave gbreve -10\r\nKPX agrave gcommaaccent -10\r\nKPX agrave v -15\r\nKPX agrave w -15\r\nKPX agrave y -20\r\nKPX agrave yacute -20\r\nKPX agrave ydieresis -20\r\nKPX amacron g -10\r\nKPX amacron gbreve -10\r\nKPX amacron gcommaaccent -10\r\nKPX amacron v -15\r\nKPX amacron w -15\r\nKPX amacron y -20\r\nKPX amacron yacute -20\r\nKPX amacron ydieresis -20\r\nKPX aogonek g -10\r\nKPX aogonek gbreve -10\r\nKPX aogonek gcommaaccent -10\r\nKPX aogonek v -15\r\nKPX aogonek w -15\r\nKPX aogonek y -20\r\nKPX aogonek yacute -20\r\nKPX aogonek ydieresis -20\r\nKPX aring g -10\r\nKPX aring gbreve -10\r\nKPX aring gcommaaccent -10\r\nKPX aring v -15\r\nKPX aring w -15\r\nKPX aring y -20\r\nKPX aring yacute -20\r\nKPX aring ydieresis -20\r\nKPX atilde g -10\r\nKPX atilde gbreve -10\r\nKPX atilde gcommaaccent -10\r\nKPX atilde v -15\r\nKPX atilde w -15\r\nKPX atilde y -20\r\nKPX atilde yacute -20\r\nKPX atilde ydieresis -20\r\nKPX b l -10\r\nKPX b lacute -10\r\nKPX b lcommaaccent -10\r\nKPX b lslash -10\r\nKPX b u -20\r\nKPX b uacute -20\r\nKPX b ucircumflex -20\r\nKPX b udieresis -20\r\nKPX b ugrave -20\r\nKPX b uhungarumlaut -20\r\nKPX b umacron -20\r\nKPX b uogonek -20\r\nKPX b uring -20\r\nKPX b v -20\r\nKPX b y -20\r\nKPX b yacute -20\r\nKPX b ydieresis -20\r\nKPX c h -10\r\nKPX c k -20\r\nKPX c kcommaaccent -20\r\nKPX c l -20\r\nKPX c lacute -20\r\nKPX c lcommaaccent -20\r\nKPX c lslash -20\r\nKPX c y -10\r\nKPX c yacute -10\r\nKPX c ydieresis -10\r\nKPX cacute h -10\r\nKPX cacute k -20\r\nKPX cacute kcommaaccent -20\r\nKPX cacute l -20\r\nKPX cacute lacute -20\r\nKPX cacute lcommaaccent -20\r\nKPX cacute lslash -20\r\nKPX cacute y -10\r\nKPX cacute yacute -10\r\nKPX cacute ydieresis -10\r\nKPX ccaron h -10\r\nKPX ccaron k -20\r\nKPX ccaron kcommaaccent -20\r\nKPX ccaron l -20\r\nKPX ccaron lacute -20\r\nKPX ccaron lcommaaccent -20\r\nKPX ccaron lslash -20\r\nKPX ccaron y -10\r\nKPX ccaron yacute -10\r\nKPX ccaron ydieresis -10\r\nKPX ccedilla h -10\r\nKPX ccedilla k -20\r\nKPX ccedilla kcommaaccent -20\r\nKPX ccedilla l -20\r\nKPX ccedilla lacute -20\r\nKPX ccedilla lcommaaccent -20\r\nKPX ccedilla lslash -20\r\nKPX ccedilla y -10\r\nKPX ccedilla yacute -10\r\nKPX ccedilla ydieresis -10\r\nKPX colon space -40\r\nKPX comma quotedblright -120\r\nKPX comma quoteright -120\r\nKPX comma space -40\r\nKPX d d -10\r\nKPX d dcroat -10\r\nKPX d v -15\r\nKPX d w -15\r\nKPX d y -15\r\nKPX d yacute -15\r\nKPX d ydieresis -15\r\nKPX dcroat d -10\r\nKPX dcroat dcroat -10\r\nKPX dcroat v -15\r\nKPX dcroat w -15\r\nKPX dcroat y -15\r\nKPX dcroat yacute -15\r\nKPX dcroat ydieresis -15\r\nKPX e comma 10\r\nKPX e period 20\r\nKPX e v -15\r\nKPX e w -15\r\nKPX e x -15\r\nKPX e y -15\r\nKPX e yacute -15\r\nKPX e ydieresis -15\r\nKPX eacute comma 10\r\nKPX eacute period 20\r\nKPX eacute v -15\r\nKPX eacute w -15\r\nKPX eacute x -15\r\nKPX eacute y -15\r\nKPX eacute yacute -15\r\nKPX eacute ydieresis -15\r\nKPX ecaron comma 10\r\nKPX ecaron period 20\r\nKPX ecaron v -15\r\nKPX ecaron w -15\r\nKPX ecaron x -15\r\nKPX ecaron y -15\r\nKPX ecaron yacute -15\r\nKPX ecaron ydieresis -15\r\nKPX ecircumflex comma 10\r\nKPX ecircumflex period 20\r\nKPX ecircumflex v -15\r\nKPX ecircumflex w -15\r\nKPX ecircumflex x -15\r\nKPX ecircumflex y -15\r\nKPX ecircumflex yacute -15\r\nKPX ecircumflex ydieresis -15\r\nKPX edieresis comma 10\r\nKPX edieresis period 20\r\nKPX edieresis v -15\r\nKPX edieresis w -15\r\nKPX edieresis x -15\r\nKPX edieresis y -15\r\nKPX edieresis yacute -15\r\nKPX edieresis ydieresis -15\r\nKPX edotaccent comma 10\r\nKPX edotaccent period 20\r\nKPX edotaccent v -15\r\nKPX edotaccent w -15\r\nKPX edotaccent x -15\r\nKPX edotaccent y -15\r\nKPX edotaccent yacute -15\r\nKPX edotaccent ydieresis -15\r\nKPX egrave comma 10\r\nKPX egrave period 20\r\nKPX egrave v -15\r\nKPX egrave w -15\r\nKPX egrave x -15\r\nKPX egrave y -15\r\nKPX egrave yacute -15\r\nKPX egrave ydieresis -15\r\nKPX emacron comma 10\r\nKPX emacron period 20\r\nKPX emacron v -15\r\nKPX emacron w -15\r\nKPX emacron x -15\r\nKPX emacron y -15\r\nKPX emacron yacute -15\r\nKPX emacron ydieresis -15\r\nKPX eogonek comma 10\r\nKPX eogonek period 20\r\nKPX eogonek v -15\r\nKPX eogonek w -15\r\nKPX eogonek x -15\r\nKPX eogonek y -15\r\nKPX eogonek yacute -15\r\nKPX eogonek ydieresis -15\r\nKPX f comma -10\r\nKPX f e -10\r\nKPX f eacute -10\r\nKPX f ecaron -10\r\nKPX f ecircumflex -10\r\nKPX f edieresis -10\r\nKPX f edotaccent -10\r\nKPX f egrave -10\r\nKPX f emacron -10\r\nKPX f eogonek -10\r\nKPX f o -20\r\nKPX f oacute -20\r\nKPX f ocircumflex -20\r\nKPX f odieresis -20\r\nKPX f ograve -20\r\nKPX f ohungarumlaut -20\r\nKPX f omacron -20\r\nKPX f oslash -20\r\nKPX f otilde -20\r\nKPX f period -10\r\nKPX f quotedblright 30\r\nKPX f quoteright 30\r\nKPX g e 10\r\nKPX g eacute 10\r\nKPX g ecaron 10\r\nKPX g ecircumflex 10\r\nKPX g edieresis 10\r\nKPX g edotaccent 10\r\nKPX g egrave 10\r\nKPX g emacron 10\r\nKPX g eogonek 10\r\nKPX g g -10\r\nKPX g gbreve -10\r\nKPX g gcommaaccent -10\r\nKPX gbreve e 10\r\nKPX gbreve eacute 10\r\nKPX gbreve ecaron 10\r\nKPX gbreve ecircumflex 10\r\nKPX gbreve edieresis 10\r\nKPX gbreve edotaccent 10\r\nKPX gbreve egrave 10\r\nKPX gbreve emacron 10\r\nKPX gbreve eogonek 10\r\nKPX gbreve g -10\r\nKPX gbreve gbreve -10\r\nKPX gbreve gcommaaccent -10\r\nKPX gcommaaccent e 10\r\nKPX gcommaaccent eacute 10\r\nKPX gcommaaccent ecaron 10\r\nKPX gcommaaccent ecircumflex 10\r\nKPX gcommaaccent edieresis 10\r\nKPX gcommaaccent edotaccent 10\r\nKPX gcommaaccent egrave 10\r\nKPX gcommaaccent emacron 10\r\nKPX gcommaaccent eogonek 10\r\nKPX gcommaaccent g -10\r\nKPX gcommaaccent gbreve -10\r\nKPX gcommaaccent gcommaaccent -10\r\nKPX h y -20\r\nKPX h yacute -20\r\nKPX h ydieresis -20\r\nKPX k o -15\r\nKPX k oacute -15\r\nKPX k ocircumflex -15\r\nKPX k odieresis -15\r\nKPX k ograve -15\r\nKPX k ohungarumlaut -15\r\nKPX k omacron -15\r\nKPX k oslash -15\r\nKPX k otilde -15\r\nKPX kcommaaccent o -15\r\nKPX kcommaaccent oacute -15\r\nKPX kcommaaccent ocircumflex -15\r\nKPX kcommaaccent odieresis -15\r\nKPX kcommaaccent ograve -15\r\nKPX kcommaaccent ohungarumlaut -15\r\nKPX kcommaaccent omacron -15\r\nKPX kcommaaccent oslash -15\r\nKPX kcommaaccent otilde -15\r\nKPX l w -15\r\nKPX l y -15\r\nKPX l yacute -15\r\nKPX l ydieresis -15\r\nKPX lacute w -15\r\nKPX lacute y -15\r\nKPX lacute yacute -15\r\nKPX lacute ydieresis -15\r\nKPX lcommaaccent w -15\r\nKPX lcommaaccent y -15\r\nKPX lcommaaccent yacute -15\r\nKPX lcommaaccent ydieresis -15\r\nKPX lslash w -15\r\nKPX lslash y -15\r\nKPX lslash yacute -15\r\nKPX lslash ydieresis -15\r\nKPX m u -20\r\nKPX m uacute -20\r\nKPX m ucircumflex -20\r\nKPX m udieresis -20\r\nKPX m ugrave -20\r\nKPX m uhungarumlaut -20\r\nKPX m umacron -20\r\nKPX m uogonek -20\r\nKPX m uring -20\r\nKPX m y -30\r\nKPX m yacute -30\r\nKPX m ydieresis -30\r\nKPX n u -10\r\nKPX n uacute -10\r\nKPX n ucircumflex -10\r\nKPX n udieresis -10\r\nKPX n ugrave -10\r\nKPX n uhungarumlaut -10\r\nKPX n umacron -10\r\nKPX n uogonek -10\r\nKPX n uring -10\r\nKPX n v -40\r\nKPX n y -20\r\nKPX n yacute -20\r\nKPX n ydieresis -20\r\nKPX nacute u -10\r\nKPX nacute uacute -10\r\nKPX nacute ucircumflex -10\r\nKPX nacute udieresis -10\r\nKPX nacute ugrave -10\r\nKPX nacute uhungarumlaut -10\r\nKPX nacute umacron -10\r\nKPX nacute uogonek -10\r\nKPX nacute uring -10\r\nKPX nacute v -40\r\nKPX nacute y -20\r\nKPX nacute yacute -20\r\nKPX nacute ydieresis -20\r\nKPX ncaron u -10\r\nKPX ncaron uacute -10\r\nKPX ncaron ucircumflex -10\r\nKPX ncaron udieresis -10\r\nKPX ncaron ugrave -10\r\nKPX ncaron uhungarumlaut -10\r\nKPX ncaron umacron -10\r\nKPX ncaron uogonek -10\r\nKPX ncaron uring -10\r\nKPX ncaron v -40\r\nKPX ncaron y -20\r\nKPX ncaron yacute -20\r\nKPX ncaron ydieresis -20\r\nKPX ncommaaccent u -10\r\nKPX ncommaaccent uacute -10\r\nKPX ncommaaccent ucircumflex -10\r\nKPX ncommaaccent udieresis -10\r\nKPX ncommaaccent ugrave -10\r\nKPX ncommaaccent uhungarumlaut -10\r\nKPX ncommaaccent umacron -10\r\nKPX ncommaaccent uogonek -10\r\nKPX ncommaaccent uring -10\r\nKPX ncommaaccent v -40\r\nKPX ncommaaccent y -20\r\nKPX ncommaaccent yacute -20\r\nKPX ncommaaccent ydieresis -20\r\nKPX ntilde u -10\r\nKPX ntilde uacute -10\r\nKPX ntilde ucircumflex -10\r\nKPX ntilde udieresis -10\r\nKPX ntilde ugrave -10\r\nKPX ntilde uhungarumlaut -10\r\nKPX ntilde umacron -10\r\nKPX ntilde uogonek -10\r\nKPX ntilde uring -10\r\nKPX ntilde v -40\r\nKPX ntilde y -20\r\nKPX ntilde yacute -20\r\nKPX ntilde ydieresis -20\r\nKPX o v -20\r\nKPX o w -15\r\nKPX o x -30\r\nKPX o y -20\r\nKPX o yacute -20\r\nKPX o ydieresis -20\r\nKPX oacute v -20\r\nKPX oacute w -15\r\nKPX oacute x -30\r\nKPX oacute y -20\r\nKPX oacute yacute -20\r\nKPX oacute ydieresis -20\r\nKPX ocircumflex v -20\r\nKPX ocircumflex w -15\r\nKPX ocircumflex x -30\r\nKPX ocircumflex y -20\r\nKPX ocircumflex yacute -20\r\nKPX ocircumflex ydieresis -20\r\nKPX odieresis v -20\r\nKPX odieresis w -15\r\nKPX odieresis x -30\r\nKPX odieresis y -20\r\nKPX odieresis yacute -20\r\nKPX odieresis ydieresis -20\r\nKPX ograve v -20\r\nKPX ograve w -15\r\nKPX ograve x -30\r\nKPX ograve y -20\r\nKPX ograve yacute -20\r\nKPX ograve ydieresis -20\r\nKPX ohungarumlaut v -20\r\nKPX ohungarumlaut w -15\r\nKPX ohungarumlaut x -30\r\nKPX ohungarumlaut y -20\r\nKPX ohungarumlaut yacute -20\r\nKPX ohungarumlaut ydieresis -20\r\nKPX omacron v -20\r\nKPX omacron w -15\r\nKPX omacron x -30\r\nKPX omacron y -20\r\nKPX omacron yacute -20\r\nKPX omacron ydieresis -20\r\nKPX oslash v -20\r\nKPX oslash w -15\r\nKPX oslash x -30\r\nKPX oslash y -20\r\nKPX oslash yacute -20\r\nKPX oslash ydieresis -20\r\nKPX otilde v -20\r\nKPX otilde w -15\r\nKPX otilde x -30\r\nKPX otilde y -20\r\nKPX otilde yacute -20\r\nKPX otilde ydieresis -20\r\nKPX p y -15\r\nKPX p yacute -15\r\nKPX p ydieresis -15\r\nKPX period quotedblright -120\r\nKPX period quoteright -120\r\nKPX period space -40\r\nKPX quotedblright space -80\r\nKPX quoteleft quoteleft -46\r\nKPX quoteright d -80\r\nKPX quoteright dcroat -80\r\nKPX quoteright l -20\r\nKPX quoteright lacute -20\r\nKPX quoteright lcommaaccent -20\r\nKPX quoteright lslash -20\r\nKPX quoteright quoteright -46\r\nKPX quoteright r -40\r\nKPX quoteright racute -40\r\nKPX quoteright rcaron -40\r\nKPX quoteright rcommaaccent -40\r\nKPX quoteright s -60\r\nKPX quoteright sacute -60\r\nKPX quoteright scaron -60\r\nKPX quoteright scedilla -60\r\nKPX quoteright scommaaccent -60\r\nKPX quoteright space -80\r\nKPX quoteright v -20\r\nKPX r c -20\r\nKPX r cacute -20\r\nKPX r ccaron -20\r\nKPX r ccedilla -20\r\nKPX r comma -60\r\nKPX r d -20\r\nKPX r dcroat -20\r\nKPX r g -15\r\nKPX r gbreve -15\r\nKPX r gcommaaccent -15\r\nKPX r hyphen -20\r\nKPX r o -20\r\nKPX r oacute -20\r\nKPX r ocircumflex -20\r\nKPX r odieresis -20\r\nKPX r ograve -20\r\nKPX r ohungarumlaut -20\r\nKPX r omacron -20\r\nKPX r oslash -20\r\nKPX r otilde -20\r\nKPX r period -60\r\nKPX r q -20\r\nKPX r s -15\r\nKPX r sacute -15\r\nKPX r scaron -15\r\nKPX r scedilla -15\r\nKPX r scommaaccent -15\r\nKPX r t 20\r\nKPX r tcommaaccent 20\r\nKPX r v 10\r\nKPX r y 10\r\nKPX r yacute 10\r\nKPX r ydieresis 10\r\nKPX racute c -20\r\nKPX racute cacute -20\r\nKPX racute ccaron -20\r\nKPX racute ccedilla -20\r\nKPX racute comma -60\r\nKPX racute d -20\r\nKPX racute dcroat -20\r\nKPX racute g -15\r\nKPX racute gbreve -15\r\nKPX racute gcommaaccent -15\r\nKPX racute hyphen -20\r\nKPX racute o -20\r\nKPX racute oacute -20\r\nKPX racute ocircumflex -20\r\nKPX racute odieresis -20\r\nKPX racute ograve -20\r\nKPX racute ohungarumlaut -20\r\nKPX racute omacron -20\r\nKPX racute oslash -20\r\nKPX racute otilde -20\r\nKPX racute period -60\r\nKPX racute q -20\r\nKPX racute s -15\r\nKPX racute sacute -15\r\nKPX racute scaron -15\r\nKPX racute scedilla -15\r\nKPX racute scommaaccent -15\r\nKPX racute t 20\r\nKPX racute tcommaaccent 20\r\nKPX racute v 10\r\nKPX racute y 10\r\nKPX racute yacute 10\r\nKPX racute ydieresis 10\r\nKPX rcaron c -20\r\nKPX rcaron cacute -20\r\nKPX rcaron ccaron -20\r\nKPX rcaron ccedilla -20\r\nKPX rcaron comma -60\r\nKPX rcaron d -20\r\nKPX rcaron dcroat -20\r\nKPX rcaron g -15\r\nKPX rcaron gbreve -15\r\nKPX rcaron gcommaaccent -15\r\nKPX rcaron hyphen -20\r\nKPX rcaron o -20\r\nKPX rcaron oacute -20\r\nKPX rcaron ocircumflex -20\r\nKPX rcaron odieresis -20\r\nKPX rcaron ograve -20\r\nKPX rcaron ohungarumlaut -20\r\nKPX rcaron omacron -20\r\nKPX rcaron oslash -20\r\nKPX rcaron otilde -20\r\nKPX rcaron period -60\r\nKPX rcaron q -20\r\nKPX rcaron s -15\r\nKPX rcaron sacute -15\r\nKPX rcaron scaron -15\r\nKPX rcaron scedilla -15\r\nKPX rcaron scommaaccent -15\r\nKPX rcaron t 20\r\nKPX rcaron tcommaaccent 20\r\nKPX rcaron v 10\r\nKPX rcaron y 10\r\nKPX rcaron yacute 10\r\nKPX rcaron ydieresis 10\r\nKPX rcommaaccent c -20\r\nKPX rcommaaccent cacute -20\r\nKPX rcommaaccent ccaron -20\r\nKPX rcommaaccent ccedilla -20\r\nKPX rcommaaccent comma -60\r\nKPX rcommaaccent d -20\r\nKPX rcommaaccent dcroat -20\r\nKPX rcommaaccent g -15\r\nKPX rcommaaccent gbreve -15\r\nKPX rcommaaccent gcommaaccent -15\r\nKPX rcommaaccent hyphen -20\r\nKPX rcommaaccent o -20\r\nKPX rcommaaccent oacute -20\r\nKPX rcommaaccent ocircumflex -20\r\nKPX rcommaaccent odieresis -20\r\nKPX rcommaaccent ograve -20\r\nKPX rcommaaccent ohungarumlaut -20\r\nKPX rcommaaccent omacron -20\r\nKPX rcommaaccent oslash -20\r\nKPX rcommaaccent otilde -20\r\nKPX rcommaaccent period -60\r\nKPX rcommaaccent q -20\r\nKPX rcommaaccent s -15\r\nKPX rcommaaccent sacute -15\r\nKPX rcommaaccent scaron -15\r\nKPX rcommaaccent scedilla -15\r\nKPX rcommaaccent scommaaccent -15\r\nKPX rcommaaccent t 20\r\nKPX rcommaaccent tcommaaccent 20\r\nKPX rcommaaccent v 10\r\nKPX rcommaaccent y 10\r\nKPX rcommaaccent yacute 10\r\nKPX rcommaaccent ydieresis 10\r\nKPX s w -15\r\nKPX sacute w -15\r\nKPX scaron w -15\r\nKPX scedilla w -15\r\nKPX scommaaccent w -15\r\nKPX semicolon space -40\r\nKPX space T -100\r\nKPX space Tcaron -100\r\nKPX space Tcommaaccent -100\r\nKPX space V -80\r\nKPX space W -80\r\nKPX space Y -120\r\nKPX space Yacute -120\r\nKPX space Ydieresis -120\r\nKPX space quotedblleft -80\r\nKPX space quoteleft -60\r\nKPX v a -20\r\nKPX v aacute -20\r\nKPX v abreve -20\r\nKPX v acircumflex -20\r\nKPX v adieresis -20\r\nKPX v agrave -20\r\nKPX v amacron -20\r\nKPX v aogonek -20\r\nKPX v aring -20\r\nKPX v atilde -20\r\nKPX v comma -80\r\nKPX v o -30\r\nKPX v oacute -30\r\nKPX v ocircumflex -30\r\nKPX v odieresis -30\r\nKPX v ograve -30\r\nKPX v ohungarumlaut -30\r\nKPX v omacron -30\r\nKPX v oslash -30\r\nKPX v otilde -30\r\nKPX v period -80\r\nKPX w comma -40\r\nKPX w o -20\r\nKPX w oacute -20\r\nKPX w ocircumflex -20\r\nKPX w odieresis -20\r\nKPX w ograve -20\r\nKPX w ohungarumlaut -20\r\nKPX w omacron -20\r\nKPX w oslash -20\r\nKPX w otilde -20\r\nKPX w period -40\r\nKPX x e -10\r\nKPX x eacute -10\r\nKPX x ecaron -10\r\nKPX x ecircumflex -10\r\nKPX x edieresis -10\r\nKPX x edotaccent -10\r\nKPX x egrave -10\r\nKPX x emacron -10\r\nKPX x eogonek -10\r\nKPX y a -30\r\nKPX y aacute -30\r\nKPX y abreve -30\r\nKPX y acircumflex -30\r\nKPX y adieresis -30\r\nKPX y agrave -30\r\nKPX y amacron -30\r\nKPX y aogonek -30\r\nKPX y aring -30\r\nKPX y atilde -30\r\nKPX y comma -80\r\nKPX y e -10\r\nKPX y eacute -10\r\nKPX y ecaron -10\r\nKPX y ecircumflex -10\r\nKPX y edieresis -10\r\nKPX y edotaccent -10\r\nKPX y egrave -10\r\nKPX y emacron -10\r\nKPX y eogonek -10\r\nKPX y o -25\r\nKPX y oacute -25\r\nKPX y ocircumflex -25\r\nKPX y odieresis -25\r\nKPX y ograve -25\r\nKPX y ohungarumlaut -25\r\nKPX y omacron -25\r\nKPX y oslash -25\r\nKPX y otilde -25\r\nKPX y period -80\r\nKPX yacute a -30\r\nKPX yacute aacute -30\r\nKPX yacute abreve -30\r\nKPX yacute acircumflex -30\r\nKPX yacute adieresis -30\r\nKPX yacute agrave -30\r\nKPX yacute amacron -30\r\nKPX yacute aogonek -30\r\nKPX yacute aring -30\r\nKPX yacute atilde -30\r\nKPX yacute comma -80\r\nKPX yacute e -10\r\nKPX yacute eacute -10\r\nKPX yacute ecaron -10\r\nKPX yacute ecircumflex -10\r\nKPX yacute edieresis -10\r\nKPX yacute edotaccent -10\r\nKPX yacute egrave -10\r\nKPX yacute emacron -10\r\nKPX yacute eogonek -10\r\nKPX yacute o -25\r\nKPX yacute oacute -25\r\nKPX yacute ocircumflex -25\r\nKPX yacute odieresis -25\r\nKPX yacute ograve -25\r\nKPX yacute ohungarumlaut -25\r\nKPX yacute omacron -25\r\nKPX yacute oslash -25\r\nKPX yacute otilde -25\r\nKPX yacute period -80\r\nKPX ydieresis a -30\r\nKPX ydieresis aacute -30\r\nKPX ydieresis abreve -30\r\nKPX ydieresis acircumflex -30\r\nKPX ydieresis adieresis -30\r\nKPX ydieresis agrave -30\r\nKPX ydieresis amacron -30\r\nKPX ydieresis aogonek -30\r\nKPX ydieresis aring -30\r\nKPX ydieresis atilde -30\r\nKPX ydieresis comma -80\r\nKPX ydieresis e -10\r\nKPX ydieresis eacute -10\r\nKPX ydieresis ecaron -10\r\nKPX ydieresis ecircumflex -10\r\nKPX ydieresis edieresis -10\r\nKPX ydieresis edotaccent -10\r\nKPX ydieresis egrave -10\r\nKPX ydieresis emacron -10\r\nKPX ydieresis eogonek -10\r\nKPX ydieresis o -25\r\nKPX ydieresis oacute -25\r\nKPX ydieresis ocircumflex -25\r\nKPX ydieresis odieresis -25\r\nKPX ydieresis ograve -25\r\nKPX ydieresis ohungarumlaut -25\r\nKPX ydieresis omacron -25\r\nKPX ydieresis oslash -25\r\nKPX ydieresis otilde -25\r\nKPX ydieresis period -80\r\nKPX z e 10\r\nKPX z eacute 10\r\nKPX z ecaron 10\r\nKPX z ecircumflex 10\r\nKPX z edieresis 10\r\nKPX z edotaccent 10\r\nKPX z egrave 10\r\nKPX z emacron 10\r\nKPX z eogonek 10\r\nKPX zacute e 10\r\nKPX zacute eacute 10\r\nKPX zacute ecaron 10\r\nKPX zacute ecircumflex 10\r\nKPX zacute edieresis 10\r\nKPX zacute edotaccent 10\r\nKPX zacute egrave 10\r\nKPX zacute emacron 10\r\nKPX zacute eogonek 10\r\nKPX zcaron e 10\r\nKPX zcaron eacute 10\r\nKPX zcaron ecaron 10\r\nKPX zcaron ecircumflex 10\r\nKPX zcaron edieresis 10\r\nKPX zcaron edotaccent 10\r\nKPX zcaron egrave 10\r\nKPX zcaron emacron 10\r\nKPX zcaron eogonek 10\r\nKPX zdotaccent e 10\r\nKPX zdotaccent eacute 10\r\nKPX zdotaccent ecaron 10\r\nKPX zdotaccent ecircumflex 10\r\nKPX zdotaccent edieresis 10\r\nKPX zdotaccent edotaccent 10\r\nKPX zdotaccent egrave 10\r\nKPX zdotaccent emacron 10\r\nKPX zdotaccent eogonek 10\r\nEndKernPairs\r\nEndKernData\r\nEndFontMetrics\r\n";
  },
  'Helvetica-Oblique'() {
    return "StartFontMetrics 4.1\r\nComment Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.\r\nComment Creation Date: Thu May  1 12:44:31 1997\r\nComment UniqueID 43055\r\nComment VMusage 14960 69346\r\nFontName Helvetica-Oblique\r\nFullName Helvetica Oblique\r\nFamilyName Helvetica\r\nWeight Medium\r\nItalicAngle -12\r\nIsFixedPitch false\r\nCharacterSet ExtendedRoman\r\nFontBBox -170 -225 1116 931 \r\nUnderlinePosition -100\r\nUnderlineThickness 50\r\nVersion 002.000\r\nNotice Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.Helvetica is a trademark of Linotype-Hell AG and/or its subsidiaries.\r\nEncodingScheme AdobeStandardEncoding\r\nCapHeight 718\r\nXHeight 523\r\nAscender 718\r\nDescender -207\r\nStdHW 76\r\nStdVW 88\r\nStartCharMetrics 315\r\nC 32 ; WX 278 ; N space ; B 0 0 0 0 ;\r\nC 33 ; WX 278 ; N exclam ; B 90 0 340 718 ;\r\nC 34 ; WX 355 ; N quotedbl ; B 168 463 438 718 ;\r\nC 35 ; WX 556 ; N numbersign ; B 73 0 631 688 ;\r\nC 36 ; WX 556 ; N dollar ; B 69 -115 617 775 ;\r\nC 37 ; WX 889 ; N percent ; B 147 -19 889 703 ;\r\nC 38 ; WX 667 ; N ampersand ; B 77 -15 647 718 ;\r\nC 39 ; WX 222 ; N quoteright ; B 151 463 310 718 ;\r\nC 40 ; WX 333 ; N parenleft ; B 108 -207 454 733 ;\r\nC 41 ; WX 333 ; N parenright ; B -9 -207 337 733 ;\r\nC 42 ; WX 389 ; N asterisk ; B 165 431 475 718 ;\r\nC 43 ; WX 584 ; N plus ; B 85 0 606 505 ;\r\nC 44 ; WX 278 ; N comma ; B 56 -147 214 106 ;\r\nC 45 ; WX 333 ; N hyphen ; B 93 232 357 322 ;\r\nC 46 ; WX 278 ; N period ; B 87 0 214 106 ;\r\nC 47 ; WX 278 ; N slash ; B -21 -19 452 737 ;\r\nC 48 ; WX 556 ; N zero ; B 93 -19 608 703 ;\r\nC 49 ; WX 556 ; N one ; B 207 0 508 703 ;\r\nC 50 ; WX 556 ; N two ; B 26 0 617 703 ;\r\nC 51 ; WX 556 ; N three ; B 75 -19 610 703 ;\r\nC 52 ; WX 556 ; N four ; B 61 0 576 703 ;\r\nC 53 ; WX 556 ; N five ; B 68 -19 621 688 ;\r\nC 54 ; WX 556 ; N six ; B 91 -19 615 703 ;\r\nC 55 ; WX 556 ; N seven ; B 137 0 669 688 ;\r\nC 56 ; WX 556 ; N eight ; B 74 -19 607 703 ;\r\nC 57 ; WX 556 ; N nine ; B 82 -19 609 703 ;\r\nC 58 ; WX 278 ; N colon ; B 87 0 301 516 ;\r\nC 59 ; WX 278 ; N semicolon ; B 56 -147 301 516 ;\r\nC 60 ; WX 584 ; N less ; B 94 11 641 495 ;\r\nC 61 ; WX 584 ; N equal ; B 63 115 628 390 ;\r\nC 62 ; WX 584 ; N greater ; B 50 11 597 495 ;\r\nC 63 ; WX 556 ; N question ; B 161 0 610 727 ;\r\nC 64 ; WX 1015 ; N at ; B 215 -19 965 737 ;\r\nC 65 ; WX 667 ; N A ; B 14 0 654 718 ;\r\nC 66 ; WX 667 ; N B ; B 74 0 712 718 ;\r\nC 67 ; WX 722 ; N C ; B 108 -19 782 737 ;\r\nC 68 ; WX 722 ; N D ; B 81 0 764 718 ;\r\nC 69 ; WX 667 ; N E ; B 86 0 762 718 ;\r\nC 70 ; WX 611 ; N F ; B 86 0 736 718 ;\r\nC 71 ; WX 778 ; N G ; B 111 -19 799 737 ;\r\nC 72 ; WX 722 ; N H ; B 77 0 799 718 ;\r\nC 73 ; WX 278 ; N I ; B 91 0 341 718 ;\r\nC 74 ; WX 500 ; N J ; B 47 -19 581 718 ;\r\nC 75 ; WX 667 ; N K ; B 76 0 808 718 ;\r\nC 76 ; WX 556 ; N L ; B 76 0 555 718 ;\r\nC 77 ; WX 833 ; N M ; B 73 0 914 718 ;\r\nC 78 ; WX 722 ; N N ; B 76 0 799 718 ;\r\nC 79 ; WX 778 ; N O ; B 105 -19 826 737 ;\r\nC 80 ; WX 667 ; N P ; B 86 0 737 718 ;\r\nC 81 ; WX 778 ; N Q ; B 105 -56 826 737 ;\r\nC 82 ; WX 722 ; N R ; B 88 0 773 718 ;\r\nC 83 ; WX 667 ; N S ; B 90 -19 713 737 ;\r\nC 84 ; WX 611 ; N T ; B 148 0 750 718 ;\r\nC 85 ; WX 722 ; N U ; B 123 -19 797 718 ;\r\nC 86 ; WX 667 ; N V ; B 173 0 800 718 ;\r\nC 87 ; WX 944 ; N W ; B 169 0 1081 718 ;\r\nC 88 ; WX 667 ; N X ; B 19 0 790 718 ;\r\nC 89 ; WX 667 ; N Y ; B 167 0 806 718 ;\r\nC 90 ; WX 611 ; N Z ; B 23 0 741 718 ;\r\nC 91 ; WX 278 ; N bracketleft ; B 21 -196 403 722 ;\r\nC 92 ; WX 278 ; N backslash ; B 140 -19 291 737 ;\r\nC 93 ; WX 278 ; N bracketright ; B -14 -196 368 722 ;\r\nC 94 ; WX 469 ; N asciicircum ; B 42 264 539 688 ;\r\nC 95 ; WX 556 ; N underscore ; B -27 -125 540 -75 ;\r\nC 96 ; WX 222 ; N quoteleft ; B 165 470 323 725 ;\r\nC 97 ; WX 556 ; N a ; B 61 -15 559 538 ;\r\nC 98 ; WX 556 ; N b ; B 58 -15 584 718 ;\r\nC 99 ; WX 500 ; N c ; B 74 -15 553 538 ;\r\nC 100 ; WX 556 ; N d ; B 84 -15 652 718 ;\r\nC 101 ; WX 556 ; N e ; B 84 -15 578 538 ;\r\nC 102 ; WX 278 ; N f ; B 86 0 416 728 ; L i fi ; L l fl ;\r\nC 103 ; WX 556 ; N g ; B 42 -220 610 538 ;\r\nC 104 ; WX 556 ; N h ; B 65 0 573 718 ;\r\nC 105 ; WX 222 ; N i ; B 67 0 308 718 ;\r\nC 106 ; WX 222 ; N j ; B -60 -210 308 718 ;\r\nC 107 ; WX 500 ; N k ; B 67 0 600 718 ;\r\nC 108 ; WX 222 ; N l ; B 67 0 308 718 ;\r\nC 109 ; WX 833 ; N m ; B 65 0 852 538 ;\r\nC 110 ; WX 556 ; N n ; B 65 0 573 538 ;\r\nC 111 ; WX 556 ; N o ; B 83 -14 585 538 ;\r\nC 112 ; WX 556 ; N p ; B 14 -207 584 538 ;\r\nC 113 ; WX 556 ; N q ; B 84 -207 605 538 ;\r\nC 114 ; WX 333 ; N r ; B 77 0 446 538 ;\r\nC 115 ; WX 500 ; N s ; B 63 -15 529 538 ;\r\nC 116 ; WX 278 ; N t ; B 102 -7 368 669 ;\r\nC 117 ; WX 556 ; N u ; B 94 -15 600 523 ;\r\nC 118 ; WX 500 ; N v ; B 119 0 603 523 ;\r\nC 119 ; WX 722 ; N w ; B 125 0 820 523 ;\r\nC 120 ; WX 500 ; N x ; B 11 0 594 523 ;\r\nC 121 ; WX 500 ; N y ; B 15 -214 600 523 ;\r\nC 122 ; WX 500 ; N z ; B 31 0 571 523 ;\r\nC 123 ; WX 334 ; N braceleft ; B 92 -196 445 722 ;\r\nC 124 ; WX 260 ; N bar ; B 46 -225 332 775 ;\r\nC 125 ; WX 334 ; N braceright ; B 0 -196 354 722 ;\r\nC 126 ; WX 584 ; N asciitilde ; B 111 180 580 326 ;\r\nC 161 ; WX 333 ; N exclamdown ; B 77 -195 326 523 ;\r\nC 162 ; WX 556 ; N cent ; B 95 -115 584 623 ;\r\nC 163 ; WX 556 ; N sterling ; B 49 -16 634 718 ;\r\nC 164 ; WX 167 ; N fraction ; B -170 -19 482 703 ;\r\nC 165 ; WX 556 ; N yen ; B 81 0 699 688 ;\r\nC 166 ; WX 556 ; N florin ; B -52 -207 654 737 ;\r\nC 167 ; WX 556 ; N section ; B 76 -191 584 737 ;\r\nC 168 ; WX 556 ; N currency ; B 60 99 646 603 ;\r\nC 169 ; WX 191 ; N quotesingle ; B 157 463 285 718 ;\r\nC 170 ; WX 333 ; N quotedblleft ; B 138 470 461 725 ;\r\nC 171 ; WX 556 ; N guillemotleft ; B 146 108 554 446 ;\r\nC 172 ; WX 333 ; N guilsinglleft ; B 137 108 340 446 ;\r\nC 173 ; WX 333 ; N guilsinglright ; B 111 108 314 446 ;\r\nC 174 ; WX 500 ; N fi ; B 86 0 587 728 ;\r\nC 175 ; WX 500 ; N fl ; B 86 0 585 728 ;\r\nC 177 ; WX 556 ; N endash ; B 51 240 623 313 ;\r\nC 178 ; WX 556 ; N dagger ; B 135 -159 622 718 ;\r\nC 179 ; WX 556 ; N daggerdbl ; B 52 -159 623 718 ;\r\nC 180 ; WX 278 ; N periodcentered ; B 129 190 257 315 ;\r\nC 182 ; WX 537 ; N paragraph ; B 126 -173 650 718 ;\r\nC 183 ; WX 350 ; N bullet ; B 91 202 413 517 ;\r\nC 184 ; WX 222 ; N quotesinglbase ; B 21 -149 180 106 ;\r\nC 185 ; WX 333 ; N quotedblbase ; B -6 -149 318 106 ;\r\nC 186 ; WX 333 ; N quotedblright ; B 124 463 448 718 ;\r\nC 187 ; WX 556 ; N guillemotright ; B 120 108 528 446 ;\r\nC 188 ; WX 1000 ; N ellipsis ; B 115 0 908 106 ;\r\nC 189 ; WX 1000 ; N perthousand ; B 88 -19 1029 703 ;\r\nC 191 ; WX 611 ; N questiondown ; B 85 -201 534 525 ;\r\nC 193 ; WX 333 ; N grave ; B 170 593 337 734 ;\r\nC 194 ; WX 333 ; N acute ; B 248 593 475 734 ;\r\nC 195 ; WX 333 ; N circumflex ; B 147 593 438 734 ;\r\nC 196 ; WX 333 ; N tilde ; B 125 606 490 722 ;\r\nC 197 ; WX 333 ; N macron ; B 143 627 468 684 ;\r\nC 198 ; WX 333 ; N breve ; B 167 595 476 731 ;\r\nC 199 ; WX 333 ; N dotaccent ; B 249 604 362 706 ;\r\nC 200 ; WX 333 ; N dieresis ; B 168 604 443 706 ;\r\nC 202 ; WX 333 ; N ring ; B 214 572 402 756 ;\r\nC 203 ; WX 333 ; N cedilla ; B 2 -225 232 0 ;\r\nC 205 ; WX 333 ; N hungarumlaut ; B 157 593 565 734 ;\r\nC 206 ; WX 333 ; N ogonek ; B 43 -225 249 0 ;\r\nC 207 ; WX 333 ; N caron ; B 177 593 468 734 ;\r\nC 208 ; WX 1000 ; N emdash ; B 51 240 1067 313 ;\r\nC 225 ; WX 1000 ; N AE ; B 8 0 1097 718 ;\r\nC 227 ; WX 370 ; N ordfeminine ; B 127 405 449 737 ;\r\nC 232 ; WX 556 ; N Lslash ; B 41 0 555 718 ;\r\nC 233 ; WX 778 ; N Oslash ; B 43 -19 890 737 ;\r\nC 234 ; WX 1000 ; N OE ; B 98 -19 1116 737 ;\r\nC 235 ; WX 365 ; N ordmasculine ; B 141 405 468 737 ;\r\nC 241 ; WX 889 ; N ae ; B 61 -15 909 538 ;\r\nC 245 ; WX 278 ; N dotlessi ; B 95 0 294 523 ;\r\nC 248 ; WX 222 ; N lslash ; B 41 0 347 718 ;\r\nC 249 ; WX 611 ; N oslash ; B 29 -22 647 545 ;\r\nC 250 ; WX 944 ; N oe ; B 83 -15 964 538 ;\r\nC 251 ; WX 611 ; N germandbls ; B 67 -15 658 728 ;\r\nC -1 ; WX 278 ; N Idieresis ; B 91 0 458 901 ;\r\nC -1 ; WX 556 ; N eacute ; B 84 -15 587 734 ;\r\nC -1 ; WX 556 ; N abreve ; B 61 -15 578 731 ;\r\nC -1 ; WX 556 ; N uhungarumlaut ; B 94 -15 677 734 ;\r\nC -1 ; WX 556 ; N ecaron ; B 84 -15 580 734 ;\r\nC -1 ; WX 667 ; N Ydieresis ; B 167 0 806 901 ;\r\nC -1 ; WX 584 ; N divide ; B 85 -19 606 524 ;\r\nC -1 ; WX 667 ; N Yacute ; B 167 0 806 929 ;\r\nC -1 ; WX 667 ; N Acircumflex ; B 14 0 654 929 ;\r\nC -1 ; WX 556 ; N aacute ; B 61 -15 587 734 ;\r\nC -1 ; WX 722 ; N Ucircumflex ; B 123 -19 797 929 ;\r\nC -1 ; WX 500 ; N yacute ; B 15 -214 600 734 ;\r\nC -1 ; WX 500 ; N scommaaccent ; B 63 -225 529 538 ;\r\nC -1 ; WX 556 ; N ecircumflex ; B 84 -15 578 734 ;\r\nC -1 ; WX 722 ; N Uring ; B 123 -19 797 931 ;\r\nC -1 ; WX 722 ; N Udieresis ; B 123 -19 797 901 ;\r\nC -1 ; WX 556 ; N aogonek ; B 61 -220 559 538 ;\r\nC -1 ; WX 722 ; N Uacute ; B 123 -19 797 929 ;\r\nC -1 ; WX 556 ; N uogonek ; B 94 -225 600 523 ;\r\nC -1 ; WX 667 ; N Edieresis ; B 86 0 762 901 ;\r\nC -1 ; WX 722 ; N Dcroat ; B 69 0 764 718 ;\r\nC -1 ; WX 250 ; N commaaccent ; B 39 -225 172 -40 ;\r\nC -1 ; WX 737 ; N copyright ; B 54 -19 837 737 ;\r\nC -1 ; WX 667 ; N Emacron ; B 86 0 762 879 ;\r\nC -1 ; WX 500 ; N ccaron ; B 74 -15 553 734 ;\r\nC -1 ; WX 556 ; N aring ; B 61 -15 559 756 ;\r\nC -1 ; WX 722 ; N Ncommaaccent ; B 76 -225 799 718 ;\r\nC -1 ; WX 222 ; N lacute ; B 67 0 461 929 ;\r\nC -1 ; WX 556 ; N agrave ; B 61 -15 559 734 ;\r\nC -1 ; WX 611 ; N Tcommaaccent ; B 148 -225 750 718 ;\r\nC -1 ; WX 722 ; N Cacute ; B 108 -19 782 929 ;\r\nC -1 ; WX 556 ; N atilde ; B 61 -15 592 722 ;\r\nC -1 ; WX 667 ; N Edotaccent ; B 86 0 762 901 ;\r\nC -1 ; WX 500 ; N scaron ; B 63 -15 552 734 ;\r\nC -1 ; WX 500 ; N scedilla ; B 63 -225 529 538 ;\r\nC -1 ; WX 278 ; N iacute ; B 95 0 448 734 ;\r\nC -1 ; WX 471 ; N lozenge ; B 88 0 540 728 ;\r\nC -1 ; WX 722 ; N Rcaron ; B 88 0 773 929 ;\r\nC -1 ; WX 778 ; N Gcommaaccent ; B 111 -225 799 737 ;\r\nC -1 ; WX 556 ; N ucircumflex ; B 94 -15 600 734 ;\r\nC -1 ; WX 556 ; N acircumflex ; B 61 -15 559 734 ;\r\nC -1 ; WX 667 ; N Amacron ; B 14 0 677 879 ;\r\nC -1 ; WX 333 ; N rcaron ; B 77 0 508 734 ;\r\nC -1 ; WX 500 ; N ccedilla ; B 74 -225 553 538 ;\r\nC -1 ; WX 611 ; N Zdotaccent ; B 23 0 741 901 ;\r\nC -1 ; WX 667 ; N Thorn ; B 86 0 712 718 ;\r\nC -1 ; WX 778 ; N Omacron ; B 105 -19 826 879 ;\r\nC -1 ; WX 722 ; N Racute ; B 88 0 773 929 ;\r\nC -1 ; WX 667 ; N Sacute ; B 90 -19 713 929 ;\r\nC -1 ; WX 643 ; N dcaron ; B 84 -15 808 718 ;\r\nC -1 ; WX 722 ; N Umacron ; B 123 -19 797 879 ;\r\nC -1 ; WX 556 ; N uring ; B 94 -15 600 756 ;\r\nC -1 ; WX 333 ; N threesuperior ; B 90 270 436 703 ;\r\nC -1 ; WX 778 ; N Ograve ; B 105 -19 826 929 ;\r\nC -1 ; WX 667 ; N Agrave ; B 14 0 654 929 ;\r\nC -1 ; WX 667 ; N Abreve ; B 14 0 685 926 ;\r\nC -1 ; WX 584 ; N multiply ; B 50 0 642 506 ;\r\nC -1 ; WX 556 ; N uacute ; B 94 -15 600 734 ;\r\nC -1 ; WX 611 ; N Tcaron ; B 148 0 750 929 ;\r\nC -1 ; WX 476 ; N partialdiff ; B 41 -38 550 714 ;\r\nC -1 ; WX 500 ; N ydieresis ; B 15 -214 600 706 ;\r\nC -1 ; WX 722 ; N Nacute ; B 76 0 799 929 ;\r\nC -1 ; WX 278 ; N icircumflex ; B 95 0 411 734 ;\r\nC -1 ; WX 667 ; N Ecircumflex ; B 86 0 762 929 ;\r\nC -1 ; WX 556 ; N adieresis ; B 61 -15 559 706 ;\r\nC -1 ; WX 556 ; N edieresis ; B 84 -15 578 706 ;\r\nC -1 ; WX 500 ; N cacute ; B 74 -15 559 734 ;\r\nC -1 ; WX 556 ; N nacute ; B 65 0 587 734 ;\r\nC -1 ; WX 556 ; N umacron ; B 94 -15 600 684 ;\r\nC -1 ; WX 722 ; N Ncaron ; B 76 0 799 929 ;\r\nC -1 ; WX 278 ; N Iacute ; B 91 0 489 929 ;\r\nC -1 ; WX 584 ; N plusminus ; B 39 0 618 506 ;\r\nC -1 ; WX 260 ; N brokenbar ; B 62 -150 316 700 ;\r\nC -1 ; WX 737 ; N registered ; B 54 -19 837 737 ;\r\nC -1 ; WX 778 ; N Gbreve ; B 111 -19 799 926 ;\r\nC -1 ; WX 278 ; N Idotaccent ; B 91 0 377 901 ;\r\nC -1 ; WX 600 ; N summation ; B 15 -10 671 706 ;\r\nC -1 ; WX 667 ; N Egrave ; B 86 0 762 929 ;\r\nC -1 ; WX 333 ; N racute ; B 77 0 475 734 ;\r\nC -1 ; WX 556 ; N omacron ; B 83 -14 585 684 ;\r\nC -1 ; WX 611 ; N Zacute ; B 23 0 741 929 ;\r\nC -1 ; WX 611 ; N Zcaron ; B 23 0 741 929 ;\r\nC -1 ; WX 549 ; N greaterequal ; B 26 0 620 674 ;\r\nC -1 ; WX 722 ; N Eth ; B 69 0 764 718 ;\r\nC -1 ; WX 722 ; N Ccedilla ; B 108 -225 782 737 ;\r\nC -1 ; WX 222 ; N lcommaaccent ; B 25 -225 308 718 ;\r\nC -1 ; WX 317 ; N tcaron ; B 102 -7 501 808 ;\r\nC -1 ; WX 556 ; N eogonek ; B 84 -225 578 538 ;\r\nC -1 ; WX 722 ; N Uogonek ; B 123 -225 797 718 ;\r\nC -1 ; WX 667 ; N Aacute ; B 14 0 683 929 ;\r\nC -1 ; WX 667 ; N Adieresis ; B 14 0 654 901 ;\r\nC -1 ; WX 556 ; N egrave ; B 84 -15 578 734 ;\r\nC -1 ; WX 500 ; N zacute ; B 31 0 571 734 ;\r\nC -1 ; WX 222 ; N iogonek ; B -61 -225 308 718 ;\r\nC -1 ; WX 778 ; N Oacute ; B 105 -19 826 929 ;\r\nC -1 ; WX 556 ; N oacute ; B 83 -14 587 734 ;\r\nC -1 ; WX 556 ; N amacron ; B 61 -15 580 684 ;\r\nC -1 ; WX 500 ; N sacute ; B 63 -15 559 734 ;\r\nC -1 ; WX 278 ; N idieresis ; B 95 0 416 706 ;\r\nC -1 ; WX 778 ; N Ocircumflex ; B 105 -19 826 929 ;\r\nC -1 ; WX 722 ; N Ugrave ; B 123 -19 797 929 ;\r\nC -1 ; WX 612 ; N Delta ; B 6 0 608 688 ;\r\nC -1 ; WX 556 ; N thorn ; B 14 -207 584 718 ;\r\nC -1 ; WX 333 ; N twosuperior ; B 64 281 449 703 ;\r\nC -1 ; WX 778 ; N Odieresis ; B 105 -19 826 901 ;\r\nC -1 ; WX 556 ; N mu ; B 24 -207 600 523 ;\r\nC -1 ; WX 278 ; N igrave ; B 95 0 310 734 ;\r\nC -1 ; WX 556 ; N ohungarumlaut ; B 83 -14 677 734 ;\r\nC -1 ; WX 667 ; N Eogonek ; B 86 -220 762 718 ;\r\nC -1 ; WX 556 ; N dcroat ; B 84 -15 689 718 ;\r\nC -1 ; WX 834 ; N threequarters ; B 130 -19 861 703 ;\r\nC -1 ; WX 667 ; N Scedilla ; B 90 -225 713 737 ;\r\nC -1 ; WX 299 ; N lcaron ; B 67 0 464 718 ;\r\nC -1 ; WX 667 ; N Kcommaaccent ; B 76 -225 808 718 ;\r\nC -1 ; WX 556 ; N Lacute ; B 76 0 555 929 ;\r\nC -1 ; WX 1000 ; N trademark ; B 186 306 1056 718 ;\r\nC -1 ; WX 556 ; N edotaccent ; B 84 -15 578 706 ;\r\nC -1 ; WX 278 ; N Igrave ; B 91 0 351 929 ;\r\nC -1 ; WX 278 ; N Imacron ; B 91 0 483 879 ;\r\nC -1 ; WX 556 ; N Lcaron ; B 76 0 570 718 ;\r\nC -1 ; WX 834 ; N onehalf ; B 114 -19 839 703 ;\r\nC -1 ; WX 549 ; N lessequal ; B 26 0 666 674 ;\r\nC -1 ; WX 556 ; N ocircumflex ; B 83 -14 585 734 ;\r\nC -1 ; WX 556 ; N ntilde ; B 65 0 592 722 ;\r\nC -1 ; WX 722 ; N Uhungarumlaut ; B 123 -19 801 929 ;\r\nC -1 ; WX 667 ; N Eacute ; B 86 0 762 929 ;\r\nC -1 ; WX 556 ; N emacron ; B 84 -15 580 684 ;\r\nC -1 ; WX 556 ; N gbreve ; B 42 -220 610 731 ;\r\nC -1 ; WX 834 ; N onequarter ; B 150 -19 802 703 ;\r\nC -1 ; WX 667 ; N Scaron ; B 90 -19 713 929 ;\r\nC -1 ; WX 667 ; N Scommaaccent ; B 90 -225 713 737 ;\r\nC -1 ; WX 778 ; N Ohungarumlaut ; B 105 -19 829 929 ;\r\nC -1 ; WX 400 ; N degree ; B 169 411 468 703 ;\r\nC -1 ; WX 556 ; N ograve ; B 83 -14 585 734 ;\r\nC -1 ; WX 722 ; N Ccaron ; B 108 -19 782 929 ;\r\nC -1 ; WX 556 ; N ugrave ; B 94 -15 600 734 ;\r\nC -1 ; WX 453 ; N radical ; B 79 -80 617 762 ;\r\nC -1 ; WX 722 ; N Dcaron ; B 81 0 764 929 ;\r\nC -1 ; WX 333 ; N rcommaaccent ; B 30 -225 446 538 ;\r\nC -1 ; WX 722 ; N Ntilde ; B 76 0 799 917 ;\r\nC -1 ; WX 556 ; N otilde ; B 83 -14 602 722 ;\r\nC -1 ; WX 722 ; N Rcommaaccent ; B 88 -225 773 718 ;\r\nC -1 ; WX 556 ; N Lcommaaccent ; B 76 -225 555 718 ;\r\nC -1 ; WX 667 ; N Atilde ; B 14 0 699 917 ;\r\nC -1 ; WX 667 ; N Aogonek ; B 14 -225 654 718 ;\r\nC -1 ; WX 667 ; N Aring ; B 14 0 654 931 ;\r\nC -1 ; WX 778 ; N Otilde ; B 105 -19 826 917 ;\r\nC -1 ; WX 500 ; N zdotaccent ; B 31 0 571 706 ;\r\nC -1 ; WX 667 ; N Ecaron ; B 86 0 762 929 ;\r\nC -1 ; WX 278 ; N Iogonek ; B -33 -225 341 718 ;\r\nC -1 ; WX 500 ; N kcommaaccent ; B 67 -225 600 718 ;\r\nC -1 ; WX 584 ; N minus ; B 85 216 606 289 ;\r\nC -1 ; WX 278 ; N Icircumflex ; B 91 0 452 929 ;\r\nC -1 ; WX 556 ; N ncaron ; B 65 0 580 734 ;\r\nC -1 ; WX 278 ; N tcommaaccent ; B 63 -225 368 669 ;\r\nC -1 ; WX 584 ; N logicalnot ; B 106 108 628 390 ;\r\nC -1 ; WX 556 ; N odieresis ; B 83 -14 585 706 ;\r\nC -1 ; WX 556 ; N udieresis ; B 94 -15 600 706 ;\r\nC -1 ; WX 549 ; N notequal ; B 34 -35 623 551 ;\r\nC -1 ; WX 556 ; N gcommaaccent ; B 42 -220 610 822 ;\r\nC -1 ; WX 556 ; N eth ; B 81 -15 617 737 ;\r\nC -1 ; WX 500 ; N zcaron ; B 31 0 571 734 ;\r\nC -1 ; WX 556 ; N ncommaaccent ; B 65 -225 573 538 ;\r\nC -1 ; WX 333 ; N onesuperior ; B 166 281 371 703 ;\r\nC -1 ; WX 278 ; N imacron ; B 95 0 417 684 ;\r\nC -1 ; WX 556 ; N Euro ; B 0 0 0 0 ;\r\nEndCharMetrics\r\nStartKernData\r\nStartKernPairs 2705\r\nKPX A C -30\r\nKPX A Cacute -30\r\nKPX A Ccaron -30\r\nKPX A Ccedilla -30\r\nKPX A G -30\r\nKPX A Gbreve -30\r\nKPX A Gcommaaccent -30\r\nKPX A O -30\r\nKPX A Oacute -30\r\nKPX A Ocircumflex -30\r\nKPX A Odieresis -30\r\nKPX A Ograve -30\r\nKPX A Ohungarumlaut -30\r\nKPX A Omacron -30\r\nKPX A Oslash -30\r\nKPX A Otilde -30\r\nKPX A Q -30\r\nKPX A T -120\r\nKPX A Tcaron -120\r\nKPX A Tcommaaccent -120\r\nKPX A U -50\r\nKPX A Uacute -50\r\nKPX A Ucircumflex -50\r\nKPX A Udieresis -50\r\nKPX A Ugrave -50\r\nKPX A Uhungarumlaut -50\r\nKPX A Umacron -50\r\nKPX A Uogonek -50\r\nKPX A Uring -50\r\nKPX A V -70\r\nKPX A W -50\r\nKPX A Y -100\r\nKPX A Yacute -100\r\nKPX A Ydieresis -100\r\nKPX A u -30\r\nKPX A uacute -30\r\nKPX A ucircumflex -30\r\nKPX A udieresis -30\r\nKPX A ugrave -30\r\nKPX A uhungarumlaut -30\r\nKPX A umacron -30\r\nKPX A uogonek -30\r\nKPX A uring -30\r\nKPX A v -40\r\nKPX A w -40\r\nKPX A y -40\r\nKPX A yacute -40\r\nKPX A ydieresis -40\r\nKPX Aacute C -30\r\nKPX Aacute Cacute -30\r\nKPX Aacute Ccaron -30\r\nKPX Aacute Ccedilla -30\r\nKPX Aacute G -30\r\nKPX Aacute Gbreve -30\r\nKPX Aacute Gcommaaccent -30\r\nKPX Aacute O -30\r\nKPX Aacute Oacute -30\r\nKPX Aacute Ocircumflex -30\r\nKPX Aacute Odieresis -30\r\nKPX Aacute Ograve -30\r\nKPX Aacute Ohungarumlaut -30\r\nKPX Aacute Omacron -30\r\nKPX Aacute Oslash -30\r\nKPX Aacute Otilde -30\r\nKPX Aacute Q -30\r\nKPX Aacute T -120\r\nKPX Aacute Tcaron -120\r\nKPX Aacute Tcommaaccent -120\r\nKPX Aacute U -50\r\nKPX Aacute Uacute -50\r\nKPX Aacute Ucircumflex -50\r\nKPX Aacute Udieresis -50\r\nKPX Aacute Ugrave -50\r\nKPX Aacute Uhungarumlaut -50\r\nKPX Aacute Umacron -50\r\nKPX Aacute Uogonek -50\r\nKPX Aacute Uring -50\r\nKPX Aacute V -70\r\nKPX Aacute W -50\r\nKPX Aacute Y -100\r\nKPX Aacute Yacute -100\r\nKPX Aacute Ydieresis -100\r\nKPX Aacute u -30\r\nKPX Aacute uacute -30\r\nKPX Aacute ucircumflex -30\r\nKPX Aacute udieresis -30\r\nKPX Aacute ugrave -30\r\nKPX Aacute uhungarumlaut -30\r\nKPX Aacute umacron -30\r\nKPX Aacute uogonek -30\r\nKPX Aacute uring -30\r\nKPX Aacute v -40\r\nKPX Aacute w -40\r\nKPX Aacute y -40\r\nKPX Aacute yacute -40\r\nKPX Aacute ydieresis -40\r\nKPX Abreve C -30\r\nKPX Abreve Cacute -30\r\nKPX Abreve Ccaron -30\r\nKPX Abreve Ccedilla -30\r\nKPX Abreve G -30\r\nKPX Abreve Gbreve -30\r\nKPX Abreve Gcommaaccent -30\r\nKPX Abreve O -30\r\nKPX Abreve Oacute -30\r\nKPX Abreve Ocircumflex -30\r\nKPX Abreve Odieresis -30\r\nKPX Abreve Ograve -30\r\nKPX Abreve Ohungarumlaut -30\r\nKPX Abreve Omacron -30\r\nKPX Abreve Oslash -30\r\nKPX Abreve Otilde -30\r\nKPX Abreve Q -30\r\nKPX Abreve T -120\r\nKPX Abreve Tcaron -120\r\nKPX Abreve Tcommaaccent -120\r\nKPX Abreve U -50\r\nKPX Abreve Uacute -50\r\nKPX Abreve Ucircumflex -50\r\nKPX Abreve Udieresis -50\r\nKPX Abreve Ugrave -50\r\nKPX Abreve Uhungarumlaut -50\r\nKPX Abreve Umacron -50\r\nKPX Abreve Uogonek -50\r\nKPX Abreve Uring -50\r\nKPX Abreve V -70\r\nKPX Abreve W -50\r\nKPX Abreve Y -100\r\nKPX Abreve Yacute -100\r\nKPX Abreve Ydieresis -100\r\nKPX Abreve u -30\r\nKPX Abreve uacute -30\r\nKPX Abreve ucircumflex -30\r\nKPX Abreve udieresis -30\r\nKPX Abreve ugrave -30\r\nKPX Abreve uhungarumlaut -30\r\nKPX Abreve umacron -30\r\nKPX Abreve uogonek -30\r\nKPX Abreve uring -30\r\nKPX Abreve v -40\r\nKPX Abreve w -40\r\nKPX Abreve y -40\r\nKPX Abreve yacute -40\r\nKPX Abreve ydieresis -40\r\nKPX Acircumflex C -30\r\nKPX Acircumflex Cacute -30\r\nKPX Acircumflex Ccaron -30\r\nKPX Acircumflex Ccedilla -30\r\nKPX Acircumflex G -30\r\nKPX Acircumflex Gbreve -30\r\nKPX Acircumflex Gcommaaccent -30\r\nKPX Acircumflex O -30\r\nKPX Acircumflex Oacute -30\r\nKPX Acircumflex Ocircumflex -30\r\nKPX Acircumflex Odieresis -30\r\nKPX Acircumflex Ograve -30\r\nKPX Acircumflex Ohungarumlaut -30\r\nKPX Acircumflex Omacron -30\r\nKPX Acircumflex Oslash -30\r\nKPX Acircumflex Otilde -30\r\nKPX Acircumflex Q -30\r\nKPX Acircumflex T -120\r\nKPX Acircumflex Tcaron -120\r\nKPX Acircumflex Tcommaaccent -120\r\nKPX Acircumflex U -50\r\nKPX Acircumflex Uacute -50\r\nKPX Acircumflex Ucircumflex -50\r\nKPX Acircumflex Udieresis -50\r\nKPX Acircumflex Ugrave -50\r\nKPX Acircumflex Uhungarumlaut -50\r\nKPX Acircumflex Umacron -50\r\nKPX Acircumflex Uogonek -50\r\nKPX Acircumflex Uring -50\r\nKPX Acircumflex V -70\r\nKPX Acircumflex W -50\r\nKPX Acircumflex Y -100\r\nKPX Acircumflex Yacute -100\r\nKPX Acircumflex Ydieresis -100\r\nKPX Acircumflex u -30\r\nKPX Acircumflex uacute -30\r\nKPX Acircumflex ucircumflex -30\r\nKPX Acircumflex udieresis -30\r\nKPX Acircumflex ugrave -30\r\nKPX Acircumflex uhungarumlaut -30\r\nKPX Acircumflex umacron -30\r\nKPX Acircumflex uogonek -30\r\nKPX Acircumflex uring -30\r\nKPX Acircumflex v -40\r\nKPX Acircumflex w -40\r\nKPX Acircumflex y -40\r\nKPX Acircumflex yacute -40\r\nKPX Acircumflex ydieresis -40\r\nKPX Adieresis C -30\r\nKPX Adieresis Cacute -30\r\nKPX Adieresis Ccaron -30\r\nKPX Adieresis Ccedilla -30\r\nKPX Adieresis G -30\r\nKPX Adieresis Gbreve -30\r\nKPX Adieresis Gcommaaccent -30\r\nKPX Adieresis O -30\r\nKPX Adieresis Oacute -30\r\nKPX Adieresis Ocircumflex -30\r\nKPX Adieresis Odieresis -30\r\nKPX Adieresis Ograve -30\r\nKPX Adieresis Ohungarumlaut -30\r\nKPX Adieresis Omacron -30\r\nKPX Adieresis Oslash -30\r\nKPX Adieresis Otilde -30\r\nKPX Adieresis Q -30\r\nKPX Adieresis T -120\r\nKPX Adieresis Tcaron -120\r\nKPX Adieresis Tcommaaccent -120\r\nKPX Adieresis U -50\r\nKPX Adieresis Uacute -50\r\nKPX Adieresis Ucircumflex -50\r\nKPX Adieresis Udieresis -50\r\nKPX Adieresis Ugrave -50\r\nKPX Adieresis Uhungarumlaut -50\r\nKPX Adieresis Umacron -50\r\nKPX Adieresis Uogonek -50\r\nKPX Adieresis Uring -50\r\nKPX Adieresis V -70\r\nKPX Adieresis W -50\r\nKPX Adieresis Y -100\r\nKPX Adieresis Yacute -100\r\nKPX Adieresis Ydieresis -100\r\nKPX Adieresis u -30\r\nKPX Adieresis uacute -30\r\nKPX Adieresis ucircumflex -30\r\nKPX Adieresis udieresis -30\r\nKPX Adieresis ugrave -30\r\nKPX Adieresis uhungarumlaut -30\r\nKPX Adieresis umacron -30\r\nKPX Adieresis uogonek -30\r\nKPX Adieresis uring -30\r\nKPX Adieresis v -40\r\nKPX Adieresis w -40\r\nKPX Adieresis y -40\r\nKPX Adieresis yacute -40\r\nKPX Adieresis ydieresis -40\r\nKPX Agrave C -30\r\nKPX Agrave Cacute -30\r\nKPX Agrave Ccaron -30\r\nKPX Agrave Ccedilla -30\r\nKPX Agrave G -30\r\nKPX Agrave Gbreve -30\r\nKPX Agrave Gcommaaccent -30\r\nKPX Agrave O -30\r\nKPX Agrave Oacute -30\r\nKPX Agrave Ocircumflex -30\r\nKPX Agrave Odieresis -30\r\nKPX Agrave Ograve -30\r\nKPX Agrave Ohungarumlaut -30\r\nKPX Agrave Omacron -30\r\nKPX Agrave Oslash -30\r\nKPX Agrave Otilde -30\r\nKPX Agrave Q -30\r\nKPX Agrave T -120\r\nKPX Agrave Tcaron -120\r\nKPX Agrave Tcommaaccent -120\r\nKPX Agrave U -50\r\nKPX Agrave Uacute -50\r\nKPX Agrave Ucircumflex -50\r\nKPX Agrave Udieresis -50\r\nKPX Agrave Ugrave -50\r\nKPX Agrave Uhungarumlaut -50\r\nKPX Agrave Umacron -50\r\nKPX Agrave Uogonek -50\r\nKPX Agrave Uring -50\r\nKPX Agrave V -70\r\nKPX Agrave W -50\r\nKPX Agrave Y -100\r\nKPX Agrave Yacute -100\r\nKPX Agrave Ydieresis -100\r\nKPX Agrave u -30\r\nKPX Agrave uacute -30\r\nKPX Agrave ucircumflex -30\r\nKPX Agrave udieresis -30\r\nKPX Agrave ugrave -30\r\nKPX Agrave uhungarumlaut -30\r\nKPX Agrave umacron -30\r\nKPX Agrave uogonek -30\r\nKPX Agrave uring -30\r\nKPX Agrave v -40\r\nKPX Agrave w -40\r\nKPX Agrave y -40\r\nKPX Agrave yacute -40\r\nKPX Agrave ydieresis -40\r\nKPX Amacron C -30\r\nKPX Amacron Cacute -30\r\nKPX Amacron Ccaron -30\r\nKPX Amacron Ccedilla -30\r\nKPX Amacron G -30\r\nKPX Amacron Gbreve -30\r\nKPX Amacron Gcommaaccent -30\r\nKPX Amacron O -30\r\nKPX Amacron Oacute -30\r\nKPX Amacron Ocircumflex -30\r\nKPX Amacron Odieresis -30\r\nKPX Amacron Ograve -30\r\nKPX Amacron Ohungarumlaut -30\r\nKPX Amacron Omacron -30\r\nKPX Amacron Oslash -30\r\nKPX Amacron Otilde -30\r\nKPX Amacron Q -30\r\nKPX Amacron T -120\r\nKPX Amacron Tcaron -120\r\nKPX Amacron Tcommaaccent -120\r\nKPX Amacron U -50\r\nKPX Amacron Uacute -50\r\nKPX Amacron Ucircumflex -50\r\nKPX Amacron Udieresis -50\r\nKPX Amacron Ugrave -50\r\nKPX Amacron Uhungarumlaut -50\r\nKPX Amacron Umacron -50\r\nKPX Amacron Uogonek -50\r\nKPX Amacron Uring -50\r\nKPX Amacron V -70\r\nKPX Amacron W -50\r\nKPX Amacron Y -100\r\nKPX Amacron Yacute -100\r\nKPX Amacron Ydieresis -100\r\nKPX Amacron u -30\r\nKPX Amacron uacute -30\r\nKPX Amacron ucircumflex -30\r\nKPX Amacron udieresis -30\r\nKPX Amacron ugrave -30\r\nKPX Amacron uhungarumlaut -30\r\nKPX Amacron umacron -30\r\nKPX Amacron uogonek -30\r\nKPX Amacron uring -30\r\nKPX Amacron v -40\r\nKPX Amacron w -40\r\nKPX Amacron y -40\r\nKPX Amacron yacute -40\r\nKPX Amacron ydieresis -40\r\nKPX Aogonek C -30\r\nKPX Aogonek Cacute -30\r\nKPX Aogonek Ccaron -30\r\nKPX Aogonek Ccedilla -30\r\nKPX Aogonek G -30\r\nKPX Aogonek Gbreve -30\r\nKPX Aogonek Gcommaaccent -30\r\nKPX Aogonek O -30\r\nKPX Aogonek Oacute -30\r\nKPX Aogonek Ocircumflex -30\r\nKPX Aogonek Odieresis -30\r\nKPX Aogonek Ograve -30\r\nKPX Aogonek Ohungarumlaut -30\r\nKPX Aogonek Omacron -30\r\nKPX Aogonek Oslash -30\r\nKPX Aogonek Otilde -30\r\nKPX Aogonek Q -30\r\nKPX Aogonek T -120\r\nKPX Aogonek Tcaron -120\r\nKPX Aogonek Tcommaaccent -120\r\nKPX Aogonek U -50\r\nKPX Aogonek Uacute -50\r\nKPX Aogonek Ucircumflex -50\r\nKPX Aogonek Udieresis -50\r\nKPX Aogonek Ugrave -50\r\nKPX Aogonek Uhungarumlaut -50\r\nKPX Aogonek Umacron -50\r\nKPX Aogonek Uogonek -50\r\nKPX Aogonek Uring -50\r\nKPX Aogonek V -70\r\nKPX Aogonek W -50\r\nKPX Aogonek Y -100\r\nKPX Aogonek Yacute -100\r\nKPX Aogonek Ydieresis -100\r\nKPX Aogonek u -30\r\nKPX Aogonek uacute -30\r\nKPX Aogonek ucircumflex -30\r\nKPX Aogonek udieresis -30\r\nKPX Aogonek ugrave -30\r\nKPX Aogonek uhungarumlaut -30\r\nKPX Aogonek umacron -30\r\nKPX Aogonek uogonek -30\r\nKPX Aogonek uring -30\r\nKPX Aogonek v -40\r\nKPX Aogonek w -40\r\nKPX Aogonek y -40\r\nKPX Aogonek yacute -40\r\nKPX Aogonek ydieresis -40\r\nKPX Aring C -30\r\nKPX Aring Cacute -30\r\nKPX Aring Ccaron -30\r\nKPX Aring Ccedilla -30\r\nKPX Aring G -30\r\nKPX Aring Gbreve -30\r\nKPX Aring Gcommaaccent -30\r\nKPX Aring O -30\r\nKPX Aring Oacute -30\r\nKPX Aring Ocircumflex -30\r\nKPX Aring Odieresis -30\r\nKPX Aring Ograve -30\r\nKPX Aring Ohungarumlaut -30\r\nKPX Aring Omacron -30\r\nKPX Aring Oslash -30\r\nKPX Aring Otilde -30\r\nKPX Aring Q -30\r\nKPX Aring T -120\r\nKPX Aring Tcaron -120\r\nKPX Aring Tcommaaccent -120\r\nKPX Aring U -50\r\nKPX Aring Uacute -50\r\nKPX Aring Ucircumflex -50\r\nKPX Aring Udieresis -50\r\nKPX Aring Ugrave -50\r\nKPX Aring Uhungarumlaut -50\r\nKPX Aring Umacron -50\r\nKPX Aring Uogonek -50\r\nKPX Aring Uring -50\r\nKPX Aring V -70\r\nKPX Aring W -50\r\nKPX Aring Y -100\r\nKPX Aring Yacute -100\r\nKPX Aring Ydieresis -100\r\nKPX Aring u -30\r\nKPX Aring uacute -30\r\nKPX Aring ucircumflex -30\r\nKPX Aring udieresis -30\r\nKPX Aring ugrave -30\r\nKPX Aring uhungarumlaut -30\r\nKPX Aring umacron -30\r\nKPX Aring uogonek -30\r\nKPX Aring uring -30\r\nKPX Aring v -40\r\nKPX Aring w -40\r\nKPX Aring y -40\r\nKPX Aring yacute -40\r\nKPX Aring ydieresis -40\r\nKPX Atilde C -30\r\nKPX Atilde Cacute -30\r\nKPX Atilde Ccaron -30\r\nKPX Atilde Ccedilla -30\r\nKPX Atilde G -30\r\nKPX Atilde Gbreve -30\r\nKPX Atilde Gcommaaccent -30\r\nKPX Atilde O -30\r\nKPX Atilde Oacute -30\r\nKPX Atilde Ocircumflex -30\r\nKPX Atilde Odieresis -30\r\nKPX Atilde Ograve -30\r\nKPX Atilde Ohungarumlaut -30\r\nKPX Atilde Omacron -30\r\nKPX Atilde Oslash -30\r\nKPX Atilde Otilde -30\r\nKPX Atilde Q -30\r\nKPX Atilde T -120\r\nKPX Atilde Tcaron -120\r\nKPX Atilde Tcommaaccent -120\r\nKPX Atilde U -50\r\nKPX Atilde Uacute -50\r\nKPX Atilde Ucircumflex -50\r\nKPX Atilde Udieresis -50\r\nKPX Atilde Ugrave -50\r\nKPX Atilde Uhungarumlaut -50\r\nKPX Atilde Umacron -50\r\nKPX Atilde Uogonek -50\r\nKPX Atilde Uring -50\r\nKPX Atilde V -70\r\nKPX Atilde W -50\r\nKPX Atilde Y -100\r\nKPX Atilde Yacute -100\r\nKPX Atilde Ydieresis -100\r\nKPX Atilde u -30\r\nKPX Atilde uacute -30\r\nKPX Atilde ucircumflex -30\r\nKPX Atilde udieresis -30\r\nKPX Atilde ugrave -30\r\nKPX Atilde uhungarumlaut -30\r\nKPX Atilde umacron -30\r\nKPX Atilde uogonek -30\r\nKPX Atilde uring -30\r\nKPX Atilde v -40\r\nKPX Atilde w -40\r\nKPX Atilde y -40\r\nKPX Atilde yacute -40\r\nKPX Atilde ydieresis -40\r\nKPX B U -10\r\nKPX B Uacute -10\r\nKPX B Ucircumflex -10\r\nKPX B Udieresis -10\r\nKPX B Ugrave -10\r\nKPX B Uhungarumlaut -10\r\nKPX B Umacron -10\r\nKPX B Uogonek -10\r\nKPX B Uring -10\r\nKPX B comma -20\r\nKPX B period -20\r\nKPX C comma -30\r\nKPX C period -30\r\nKPX Cacute comma -30\r\nKPX Cacute period -30\r\nKPX Ccaron comma -30\r\nKPX Ccaron period -30\r\nKPX Ccedilla comma -30\r\nKPX Ccedilla period -30\r\nKPX D A -40\r\nKPX D Aacute -40\r\nKPX D Abreve -40\r\nKPX D Acircumflex -40\r\nKPX D Adieresis -40\r\nKPX D Agrave -40\r\nKPX D Amacron -40\r\nKPX D Aogonek -40\r\nKPX D Aring -40\r\nKPX D Atilde -40\r\nKPX D V -70\r\nKPX D W -40\r\nKPX D Y -90\r\nKPX D Yacute -90\r\nKPX D Ydieresis -90\r\nKPX D comma -70\r\nKPX D period -70\r\nKPX Dcaron A -40\r\nKPX Dcaron Aacute -40\r\nKPX Dcaron Abreve -40\r\nKPX Dcaron Acircumflex -40\r\nKPX Dcaron Adieresis -40\r\nKPX Dcaron Agrave -40\r\nKPX Dcaron Amacron -40\r\nKPX Dcaron Aogonek -40\r\nKPX Dcaron Aring -40\r\nKPX Dcaron Atilde -40\r\nKPX Dcaron V -70\r\nKPX Dcaron W -40\r\nKPX Dcaron Y -90\r\nKPX Dcaron Yacute -90\r\nKPX Dcaron Ydieresis -90\r\nKPX Dcaron comma -70\r\nKPX Dcaron period -70\r\nKPX Dcroat A -40\r\nKPX Dcroat Aacute -40\r\nKPX Dcroat Abreve -40\r\nKPX Dcroat Acircumflex -40\r\nKPX Dcroat Adieresis -40\r\nKPX Dcroat Agrave -40\r\nKPX Dcroat Amacron -40\r\nKPX Dcroat Aogonek -40\r\nKPX Dcroat Aring -40\r\nKPX Dcroat Atilde -40\r\nKPX Dcroat V -70\r\nKPX Dcroat W -40\r\nKPX Dcroat Y -90\r\nKPX Dcroat Yacute -90\r\nKPX Dcroat Ydieresis -90\r\nKPX Dcroat comma -70\r\nKPX Dcroat period -70\r\nKPX F A -80\r\nKPX F Aacute -80\r\nKPX F Abreve -80\r\nKPX F Acircumflex -80\r\nKPX F Adieresis -80\r\nKPX F Agrave -80\r\nKPX F Amacron -80\r\nKPX F Aogonek -80\r\nKPX F Aring -80\r\nKPX F Atilde -80\r\nKPX F a -50\r\nKPX F aacute -50\r\nKPX F abreve -50\r\nKPX F acircumflex -50\r\nKPX F adieresis -50\r\nKPX F agrave -50\r\nKPX F amacron -50\r\nKPX F aogonek -50\r\nKPX F aring -50\r\nKPX F atilde -50\r\nKPX F comma -150\r\nKPX F e -30\r\nKPX F eacute -30\r\nKPX F ecaron -30\r\nKPX F ecircumflex -30\r\nKPX F edieresis -30\r\nKPX F edotaccent -30\r\nKPX F egrave -30\r\nKPX F emacron -30\r\nKPX F eogonek -30\r\nKPX F o -30\r\nKPX F oacute -30\r\nKPX F ocircumflex -30\r\nKPX F odieresis -30\r\nKPX F ograve -30\r\nKPX F ohungarumlaut -30\r\nKPX F omacron -30\r\nKPX F oslash -30\r\nKPX F otilde -30\r\nKPX F period -150\r\nKPX F r -45\r\nKPX F racute -45\r\nKPX F rcaron -45\r\nKPX F rcommaaccent -45\r\nKPX J A -20\r\nKPX J Aacute -20\r\nKPX J Abreve -20\r\nKPX J Acircumflex -20\r\nKPX J Adieresis -20\r\nKPX J Agrave -20\r\nKPX J Amacron -20\r\nKPX J Aogonek -20\r\nKPX J Aring -20\r\nKPX J Atilde -20\r\nKPX J a -20\r\nKPX J aacute -20\r\nKPX J abreve -20\r\nKPX J acircumflex -20\r\nKPX J adieresis -20\r\nKPX J agrave -20\r\nKPX J amacron -20\r\nKPX J aogonek -20\r\nKPX J aring -20\r\nKPX J atilde -20\r\nKPX J comma -30\r\nKPX J period -30\r\nKPX J u -20\r\nKPX J uacute -20\r\nKPX J ucircumflex -20\r\nKPX J udieresis -20\r\nKPX J ugrave -20\r\nKPX J uhungarumlaut -20\r\nKPX J umacron -20\r\nKPX J uogonek -20\r\nKPX J uring -20\r\nKPX K O -50\r\nKPX K Oacute -50\r\nKPX K Ocircumflex -50\r\nKPX K Odieresis -50\r\nKPX K Ograve -50\r\nKPX K Ohungarumlaut -50\r\nKPX K Omacron -50\r\nKPX K Oslash -50\r\nKPX K Otilde -50\r\nKPX K e -40\r\nKPX K eacute -40\r\nKPX K ecaron -40\r\nKPX K ecircumflex -40\r\nKPX K edieresis -40\r\nKPX K edotaccent -40\r\nKPX K egrave -40\r\nKPX K emacron -40\r\nKPX K eogonek -40\r\nKPX K o -40\r\nKPX K oacute -40\r\nKPX K ocircumflex -40\r\nKPX K odieresis -40\r\nKPX K ograve -40\r\nKPX K ohungarumlaut -40\r\nKPX K omacron -40\r\nKPX K oslash -40\r\nKPX K otilde -40\r\nKPX K u -30\r\nKPX K uacute -30\r\nKPX K ucircumflex -30\r\nKPX K udieresis -30\r\nKPX K ugrave -30\r\nKPX K uhungarumlaut -30\r\nKPX K umacron -30\r\nKPX K uogonek -30\r\nKPX K uring -30\r\nKPX K y -50\r\nKPX K yacute -50\r\nKPX K ydieresis -50\r\nKPX Kcommaaccent O -50\r\nKPX Kcommaaccent Oacute -50\r\nKPX Kcommaaccent Ocircumflex -50\r\nKPX Kcommaaccent Odieresis -50\r\nKPX Kcommaaccent Ograve -50\r\nKPX Kcommaaccent Ohungarumlaut -50\r\nKPX Kcommaaccent Omacron -50\r\nKPX Kcommaaccent Oslash -50\r\nKPX Kcommaaccent Otilde -50\r\nKPX Kcommaaccent e -40\r\nKPX Kcommaaccent eacute -40\r\nKPX Kcommaaccent ecaron -40\r\nKPX Kcommaaccent ecircumflex -40\r\nKPX Kcommaaccent edieresis -40\r\nKPX Kcommaaccent edotaccent -40\r\nKPX Kcommaaccent egrave -40\r\nKPX Kcommaaccent emacron -40\r\nKPX Kcommaaccent eogonek -40\r\nKPX Kcommaaccent o -40\r\nKPX Kcommaaccent oacute -40\r\nKPX Kcommaaccent ocircumflex -40\r\nKPX Kcommaaccent odieresis -40\r\nKPX Kcommaaccent ograve -40\r\nKPX Kcommaaccent ohungarumlaut -40\r\nKPX Kcommaaccent omacron -40\r\nKPX Kcommaaccent oslash -40\r\nKPX Kcommaaccent otilde -40\r\nKPX Kcommaaccent u -30\r\nKPX Kcommaaccent uacute -30\r\nKPX Kcommaaccent ucircumflex -30\r\nKPX Kcommaaccent udieresis -30\r\nKPX Kcommaaccent ugrave -30\r\nKPX Kcommaaccent uhungarumlaut -30\r\nKPX Kcommaaccent umacron -30\r\nKPX Kcommaaccent uogonek -30\r\nKPX Kcommaaccent uring -30\r\nKPX Kcommaaccent y -50\r\nKPX Kcommaaccent yacute -50\r\nKPX Kcommaaccent ydieresis -50\r\nKPX L T -110\r\nKPX L Tcaron -110\r\nKPX L Tcommaaccent -110\r\nKPX L V -110\r\nKPX L W -70\r\nKPX L Y -140\r\nKPX L Yacute -140\r\nKPX L Ydieresis -140\r\nKPX L quotedblright -140\r\nKPX L quoteright -160\r\nKPX L y -30\r\nKPX L yacute -30\r\nKPX L ydieresis -30\r\nKPX Lacute T -110\r\nKPX Lacute Tcaron -110\r\nKPX Lacute Tcommaaccent -110\r\nKPX Lacute V -110\r\nKPX Lacute W -70\r\nKPX Lacute Y -140\r\nKPX Lacute Yacute -140\r\nKPX Lacute Ydieresis -140\r\nKPX Lacute quotedblright -140\r\nKPX Lacute quoteright -160\r\nKPX Lacute y -30\r\nKPX Lacute yacute -30\r\nKPX Lacute ydieresis -30\r\nKPX Lcaron T -110\r\nKPX Lcaron Tcaron -110\r\nKPX Lcaron Tcommaaccent -110\r\nKPX Lcaron V -110\r\nKPX Lcaron W -70\r\nKPX Lcaron Y -140\r\nKPX Lcaron Yacute -140\r\nKPX Lcaron Ydieresis -140\r\nKPX Lcaron quotedblright -140\r\nKPX Lcaron quoteright -160\r\nKPX Lcaron y -30\r\nKPX Lcaron yacute -30\r\nKPX Lcaron ydieresis -30\r\nKPX Lcommaaccent T -110\r\nKPX Lcommaaccent Tcaron -110\r\nKPX Lcommaaccent Tcommaaccent -110\r\nKPX Lcommaaccent V -110\r\nKPX Lcommaaccent W -70\r\nKPX Lcommaaccent Y -140\r\nKPX Lcommaaccent Yacute -140\r\nKPX Lcommaaccent Ydieresis -140\r\nKPX Lcommaaccent quotedblright -140\r\nKPX Lcommaaccent quoteright -160\r\nKPX Lcommaaccent y -30\r\nKPX Lcommaaccent yacute -30\r\nKPX Lcommaaccent ydieresis -30\r\nKPX Lslash T -110\r\nKPX Lslash Tcaron -110\r\nKPX Lslash Tcommaaccent -110\r\nKPX Lslash V -110\r\nKPX Lslash W -70\r\nKPX Lslash Y -140\r\nKPX Lslash Yacute -140\r\nKPX Lslash Ydieresis -140\r\nKPX Lslash quotedblright -140\r\nKPX Lslash quoteright -160\r\nKPX Lslash y -30\r\nKPX Lslash yacute -30\r\nKPX Lslash ydieresis -30\r\nKPX O A -20\r\nKPX O Aacute -20\r\nKPX O Abreve -20\r\nKPX O Acircumflex -20\r\nKPX O Adieresis -20\r\nKPX O Agrave -20\r\nKPX O Amacron -20\r\nKPX O Aogonek -20\r\nKPX O Aring -20\r\nKPX O Atilde -20\r\nKPX O T -40\r\nKPX O Tcaron -40\r\nKPX O Tcommaaccent -40\r\nKPX O V -50\r\nKPX O W -30\r\nKPX O X -60\r\nKPX O Y -70\r\nKPX O Yacute -70\r\nKPX O Ydieresis -70\r\nKPX O comma -40\r\nKPX O period -40\r\nKPX Oacute A -20\r\nKPX Oacute Aacute -20\r\nKPX Oacute Abreve -20\r\nKPX Oacute Acircumflex -20\r\nKPX Oacute Adieresis -20\r\nKPX Oacute Agrave -20\r\nKPX Oacute Amacron -20\r\nKPX Oacute Aogonek -20\r\nKPX Oacute Aring -20\r\nKPX Oacute Atilde -20\r\nKPX Oacute T -40\r\nKPX Oacute Tcaron -40\r\nKPX Oacute Tcommaaccent -40\r\nKPX Oacute V -50\r\nKPX Oacute W -30\r\nKPX Oacute X -60\r\nKPX Oacute Y -70\r\nKPX Oacute Yacute -70\r\nKPX Oacute Ydieresis -70\r\nKPX Oacute comma -40\r\nKPX Oacute period -40\r\nKPX Ocircumflex A -20\r\nKPX Ocircumflex Aacute -20\r\nKPX Ocircumflex Abreve -20\r\nKPX Ocircumflex Acircumflex -20\r\nKPX Ocircumflex Adieresis -20\r\nKPX Ocircumflex Agrave -20\r\nKPX Ocircumflex Amacron -20\r\nKPX Ocircumflex Aogonek -20\r\nKPX Ocircumflex Aring -20\r\nKPX Ocircumflex Atilde -20\r\nKPX Ocircumflex T -40\r\nKPX Ocircumflex Tcaron -40\r\nKPX Ocircumflex Tcommaaccent -40\r\nKPX Ocircumflex V -50\r\nKPX Ocircumflex W -30\r\nKPX Ocircumflex X -60\r\nKPX Ocircumflex Y -70\r\nKPX Ocircumflex Yacute -70\r\nKPX Ocircumflex Ydieresis -70\r\nKPX Ocircumflex comma -40\r\nKPX Ocircumflex period -40\r\nKPX Odieresis A -20\r\nKPX Odieresis Aacute -20\r\nKPX Odieresis Abreve -20\r\nKPX Odieresis Acircumflex -20\r\nKPX Odieresis Adieresis -20\r\nKPX Odieresis Agrave -20\r\nKPX Odieresis Amacron -20\r\nKPX Odieresis Aogonek -20\r\nKPX Odieresis Aring -20\r\nKPX Odieresis Atilde -20\r\nKPX Odieresis T -40\r\nKPX Odieresis Tcaron -40\r\nKPX Odieresis Tcommaaccent -40\r\nKPX Odieresis V -50\r\nKPX Odieresis W -30\r\nKPX Odieresis X -60\r\nKPX Odieresis Y -70\r\nKPX Odieresis Yacute -70\r\nKPX Odieresis Ydieresis -70\r\nKPX Odieresis comma -40\r\nKPX Odieresis period -40\r\nKPX Ograve A -20\r\nKPX Ograve Aacute -20\r\nKPX Ograve Abreve -20\r\nKPX Ograve Acircumflex -20\r\nKPX Ograve Adieresis -20\r\nKPX Ograve Agrave -20\r\nKPX Ograve Amacron -20\r\nKPX Ograve Aogonek -20\r\nKPX Ograve Aring -20\r\nKPX Ograve Atilde -20\r\nKPX Ograve T -40\r\nKPX Ograve Tcaron -40\r\nKPX Ograve Tcommaaccent -40\r\nKPX Ograve V -50\r\nKPX Ograve W -30\r\nKPX Ograve X -60\r\nKPX Ograve Y -70\r\nKPX Ograve Yacute -70\r\nKPX Ograve Ydieresis -70\r\nKPX Ograve comma -40\r\nKPX Ograve period -40\r\nKPX Ohungarumlaut A -20\r\nKPX Ohungarumlaut Aacute -20\r\nKPX Ohungarumlaut Abreve -20\r\nKPX Ohungarumlaut Acircumflex -20\r\nKPX Ohungarumlaut Adieresis -20\r\nKPX Ohungarumlaut Agrave -20\r\nKPX Ohungarumlaut Amacron -20\r\nKPX Ohungarumlaut Aogonek -20\r\nKPX Ohungarumlaut Aring -20\r\nKPX Ohungarumlaut Atilde -20\r\nKPX Ohungarumlaut T -40\r\nKPX Ohungarumlaut Tcaron -40\r\nKPX Ohungarumlaut Tcommaaccent -40\r\nKPX Ohungarumlaut V -50\r\nKPX Ohungarumlaut W -30\r\nKPX Ohungarumlaut X -60\r\nKPX Ohungarumlaut Y -70\r\nKPX Ohungarumlaut Yacute -70\r\nKPX Ohungarumlaut Ydieresis -70\r\nKPX Ohungarumlaut comma -40\r\nKPX Ohungarumlaut period -40\r\nKPX Omacron A -20\r\nKPX Omacron Aacute -20\r\nKPX Omacron Abreve -20\r\nKPX Omacron Acircumflex -20\r\nKPX Omacron Adieresis -20\r\nKPX Omacron Agrave -20\r\nKPX Omacron Amacron -20\r\nKPX Omacron Aogonek -20\r\nKPX Omacron Aring -20\r\nKPX Omacron Atilde -20\r\nKPX Omacron T -40\r\nKPX Omacron Tcaron -40\r\nKPX Omacron Tcommaaccent -40\r\nKPX Omacron V -50\r\nKPX Omacron W -30\r\nKPX Omacron X -60\r\nKPX Omacron Y -70\r\nKPX Omacron Yacute -70\r\nKPX Omacron Ydieresis -70\r\nKPX Omacron comma -40\r\nKPX Omacron period -40\r\nKPX Oslash A -20\r\nKPX Oslash Aacute -20\r\nKPX Oslash Abreve -20\r\nKPX Oslash Acircumflex -20\r\nKPX Oslash Adieresis -20\r\nKPX Oslash Agrave -20\r\nKPX Oslash Amacron -20\r\nKPX Oslash Aogonek -20\r\nKPX Oslash Aring -20\r\nKPX Oslash Atilde -20\r\nKPX Oslash T -40\r\nKPX Oslash Tcaron -40\r\nKPX Oslash Tcommaaccent -40\r\nKPX Oslash V -50\r\nKPX Oslash W -30\r\nKPX Oslash X -60\r\nKPX Oslash Y -70\r\nKPX Oslash Yacute -70\r\nKPX Oslash Ydieresis -70\r\nKPX Oslash comma -40\r\nKPX Oslash period -40\r\nKPX Otilde A -20\r\nKPX Otilde Aacute -20\r\nKPX Otilde Abreve -20\r\nKPX Otilde Acircumflex -20\r\nKPX Otilde Adieresis -20\r\nKPX Otilde Agrave -20\r\nKPX Otilde Amacron -20\r\nKPX Otilde Aogonek -20\r\nKPX Otilde Aring -20\r\nKPX Otilde Atilde -20\r\nKPX Otilde T -40\r\nKPX Otilde Tcaron -40\r\nKPX Otilde Tcommaaccent -40\r\nKPX Otilde V -50\r\nKPX Otilde W -30\r\nKPX Otilde X -60\r\nKPX Otilde Y -70\r\nKPX Otilde Yacute -70\r\nKPX Otilde Ydieresis -70\r\nKPX Otilde comma -40\r\nKPX Otilde period -40\r\nKPX P A -120\r\nKPX P Aacute -120\r\nKPX P Abreve -120\r\nKPX P Acircumflex -120\r\nKPX P Adieresis -120\r\nKPX P Agrave -120\r\nKPX P Amacron -120\r\nKPX P Aogonek -120\r\nKPX P Aring -120\r\nKPX P Atilde -120\r\nKPX P a -40\r\nKPX P aacute -40\r\nKPX P abreve -40\r\nKPX P acircumflex -40\r\nKPX P adieresis -40\r\nKPX P agrave -40\r\nKPX P amacron -40\r\nKPX P aogonek -40\r\nKPX P aring -40\r\nKPX P atilde -40\r\nKPX P comma -180\r\nKPX P e -50\r\nKPX P eacute -50\r\nKPX P ecaron -50\r\nKPX P ecircumflex -50\r\nKPX P edieresis -50\r\nKPX P edotaccent -50\r\nKPX P egrave -50\r\nKPX P emacron -50\r\nKPX P eogonek -50\r\nKPX P o -50\r\nKPX P oacute -50\r\nKPX P ocircumflex -50\r\nKPX P odieresis -50\r\nKPX P ograve -50\r\nKPX P ohungarumlaut -50\r\nKPX P omacron -50\r\nKPX P oslash -50\r\nKPX P otilde -50\r\nKPX P period -180\r\nKPX Q U -10\r\nKPX Q Uacute -10\r\nKPX Q Ucircumflex -10\r\nKPX Q Udieresis -10\r\nKPX Q Ugrave -10\r\nKPX Q Uhungarumlaut -10\r\nKPX Q Umacron -10\r\nKPX Q Uogonek -10\r\nKPX Q Uring -10\r\nKPX R O -20\r\nKPX R Oacute -20\r\nKPX R Ocircumflex -20\r\nKPX R Odieresis -20\r\nKPX R Ograve -20\r\nKPX R Ohungarumlaut -20\r\nKPX R Omacron -20\r\nKPX R Oslash -20\r\nKPX R Otilde -20\r\nKPX R T -30\r\nKPX R Tcaron -30\r\nKPX R Tcommaaccent -30\r\nKPX R U -40\r\nKPX R Uacute -40\r\nKPX R Ucircumflex -40\r\nKPX R Udieresis -40\r\nKPX R Ugrave -40\r\nKPX R Uhungarumlaut -40\r\nKPX R Umacron -40\r\nKPX R Uogonek -40\r\nKPX R Uring -40\r\nKPX R V -50\r\nKPX R W -30\r\nKPX R Y -50\r\nKPX R Yacute -50\r\nKPX R Ydieresis -50\r\nKPX Racute O -20\r\nKPX Racute Oacute -20\r\nKPX Racute Ocircumflex -20\r\nKPX Racute Odieresis -20\r\nKPX Racute Ograve -20\r\nKPX Racute Ohungarumlaut -20\r\nKPX Racute Omacron -20\r\nKPX Racute Oslash -20\r\nKPX Racute Otilde -20\r\nKPX Racute T -30\r\nKPX Racute Tcaron -30\r\nKPX Racute Tcommaaccent -30\r\nKPX Racute U -40\r\nKPX Racute Uacute -40\r\nKPX Racute Ucircumflex -40\r\nKPX Racute Udieresis -40\r\nKPX Racute Ugrave -40\r\nKPX Racute Uhungarumlaut -40\r\nKPX Racute Umacron -40\r\nKPX Racute Uogonek -40\r\nKPX Racute Uring -40\r\nKPX Racute V -50\r\nKPX Racute W -30\r\nKPX Racute Y -50\r\nKPX Racute Yacute -50\r\nKPX Racute Ydieresis -50\r\nKPX Rcaron O -20\r\nKPX Rcaron Oacute -20\r\nKPX Rcaron Ocircumflex -20\r\nKPX Rcaron Odieresis -20\r\nKPX Rcaron Ograve -20\r\nKPX Rcaron Ohungarumlaut -20\r\nKPX Rcaron Omacron -20\r\nKPX Rcaron Oslash -20\r\nKPX Rcaron Otilde -20\r\nKPX Rcaron T -30\r\nKPX Rcaron Tcaron -30\r\nKPX Rcaron Tcommaaccent -30\r\nKPX Rcaron U -40\r\nKPX Rcaron Uacute -40\r\nKPX Rcaron Ucircumflex -40\r\nKPX Rcaron Udieresis -40\r\nKPX Rcaron Ugrave -40\r\nKPX Rcaron Uhungarumlaut -40\r\nKPX Rcaron Umacron -40\r\nKPX Rcaron Uogonek -40\r\nKPX Rcaron Uring -40\r\nKPX Rcaron V -50\r\nKPX Rcaron W -30\r\nKPX Rcaron Y -50\r\nKPX Rcaron Yacute -50\r\nKPX Rcaron Ydieresis -50\r\nKPX Rcommaaccent O -20\r\nKPX Rcommaaccent Oacute -20\r\nKPX Rcommaaccent Ocircumflex -20\r\nKPX Rcommaaccent Odieresis -20\r\nKPX Rcommaaccent Ograve -20\r\nKPX Rcommaaccent Ohungarumlaut -20\r\nKPX Rcommaaccent Omacron -20\r\nKPX Rcommaaccent Oslash -20\r\nKPX Rcommaaccent Otilde -20\r\nKPX Rcommaaccent T -30\r\nKPX Rcommaaccent Tcaron -30\r\nKPX Rcommaaccent Tcommaaccent -30\r\nKPX Rcommaaccent U -40\r\nKPX Rcommaaccent Uacute -40\r\nKPX Rcommaaccent Ucircumflex -40\r\nKPX Rcommaaccent Udieresis -40\r\nKPX Rcommaaccent Ugrave -40\r\nKPX Rcommaaccent Uhungarumlaut -40\r\nKPX Rcommaaccent Umacron -40\r\nKPX Rcommaaccent Uogonek -40\r\nKPX Rcommaaccent Uring -40\r\nKPX Rcommaaccent V -50\r\nKPX Rcommaaccent W -30\r\nKPX Rcommaaccent Y -50\r\nKPX Rcommaaccent Yacute -50\r\nKPX Rcommaaccent Ydieresis -50\r\nKPX S comma -20\r\nKPX S period -20\r\nKPX Sacute comma -20\r\nKPX Sacute period -20\r\nKPX Scaron comma -20\r\nKPX Scaron period -20\r\nKPX Scedilla comma -20\r\nKPX Scedilla period -20\r\nKPX Scommaaccent comma -20\r\nKPX Scommaaccent period -20\r\nKPX T A -120\r\nKPX T Aacute -120\r\nKPX T Abreve -120\r\nKPX T Acircumflex -120\r\nKPX T Adieresis -120\r\nKPX T Agrave -120\r\nKPX T Amacron -120\r\nKPX T Aogonek -120\r\nKPX T Aring -120\r\nKPX T Atilde -120\r\nKPX T O -40\r\nKPX T Oacute -40\r\nKPX T Ocircumflex -40\r\nKPX T Odieresis -40\r\nKPX T Ograve -40\r\nKPX T Ohungarumlaut -40\r\nKPX T Omacron -40\r\nKPX T Oslash -40\r\nKPX T Otilde -40\r\nKPX T a -120\r\nKPX T aacute -120\r\nKPX T abreve -60\r\nKPX T acircumflex -120\r\nKPX T adieresis -120\r\nKPX T agrave -120\r\nKPX T amacron -60\r\nKPX T aogonek -120\r\nKPX T aring -120\r\nKPX T atilde -60\r\nKPX T colon -20\r\nKPX T comma -120\r\nKPX T e -120\r\nKPX T eacute -120\r\nKPX T ecaron -120\r\nKPX T ecircumflex -120\r\nKPX T edieresis -120\r\nKPX T edotaccent -120\r\nKPX T egrave -60\r\nKPX T emacron -60\r\nKPX T eogonek -120\r\nKPX T hyphen -140\r\nKPX T o -120\r\nKPX T oacute -120\r\nKPX T ocircumflex -120\r\nKPX T odieresis -120\r\nKPX T ograve -120\r\nKPX T ohungarumlaut -120\r\nKPX T omacron -60\r\nKPX T oslash -120\r\nKPX T otilde -60\r\nKPX T period -120\r\nKPX T r -120\r\nKPX T racute -120\r\nKPX T rcaron -120\r\nKPX T rcommaaccent -120\r\nKPX T semicolon -20\r\nKPX T u -120\r\nKPX T uacute -120\r\nKPX T ucircumflex -120\r\nKPX T udieresis -120\r\nKPX T ugrave -120\r\nKPX T uhungarumlaut -120\r\nKPX T umacron -60\r\nKPX T uogonek -120\r\nKPX T uring -120\r\nKPX T w -120\r\nKPX T y -120\r\nKPX T yacute -120\r\nKPX T ydieresis -60\r\nKPX Tcaron A -120\r\nKPX Tcaron Aacute -120\r\nKPX Tcaron Abreve -120\r\nKPX Tcaron Acircumflex -120\r\nKPX Tcaron Adieresis -120\r\nKPX Tcaron Agrave -120\r\nKPX Tcaron Amacron -120\r\nKPX Tcaron Aogonek -120\r\nKPX Tcaron Aring -120\r\nKPX Tcaron Atilde -120\r\nKPX Tcaron O -40\r\nKPX Tcaron Oacute -40\r\nKPX Tcaron Ocircumflex -40\r\nKPX Tcaron Odieresis -40\r\nKPX Tcaron Ograve -40\r\nKPX Tcaron Ohungarumlaut -40\r\nKPX Tcaron Omacron -40\r\nKPX Tcaron Oslash -40\r\nKPX Tcaron Otilde -40\r\nKPX Tcaron a -120\r\nKPX Tcaron aacute -120\r\nKPX Tcaron abreve -60\r\nKPX Tcaron acircumflex -120\r\nKPX Tcaron adieresis -120\r\nKPX Tcaron agrave -120\r\nKPX Tcaron amacron -60\r\nKPX Tcaron aogonek -120\r\nKPX Tcaron aring -120\r\nKPX Tcaron atilde -60\r\nKPX Tcaron colon -20\r\nKPX Tcaron comma -120\r\nKPX Tcaron e -120\r\nKPX Tcaron eacute -120\r\nKPX Tcaron ecaron -120\r\nKPX Tcaron ecircumflex -120\r\nKPX Tcaron edieresis -120\r\nKPX Tcaron edotaccent -120\r\nKPX Tcaron egrave -60\r\nKPX Tcaron emacron -60\r\nKPX Tcaron eogonek -120\r\nKPX Tcaron hyphen -140\r\nKPX Tcaron o -120\r\nKPX Tcaron oacute -120\r\nKPX Tcaron ocircumflex -120\r\nKPX Tcaron odieresis -120\r\nKPX Tcaron ograve -120\r\nKPX Tcaron ohungarumlaut -120\r\nKPX Tcaron omacron -60\r\nKPX Tcaron oslash -120\r\nKPX Tcaron otilde -60\r\nKPX Tcaron period -120\r\nKPX Tcaron r -120\r\nKPX Tcaron racute -120\r\nKPX Tcaron rcaron -120\r\nKPX Tcaron rcommaaccent -120\r\nKPX Tcaron semicolon -20\r\nKPX Tcaron u -120\r\nKPX Tcaron uacute -120\r\nKPX Tcaron ucircumflex -120\r\nKPX Tcaron udieresis -120\r\nKPX Tcaron ugrave -120\r\nKPX Tcaron uhungarumlaut -120\r\nKPX Tcaron umacron -60\r\nKPX Tcaron uogonek -120\r\nKPX Tcaron uring -120\r\nKPX Tcaron w -120\r\nKPX Tcaron y -120\r\nKPX Tcaron yacute -120\r\nKPX Tcaron ydieresis -60\r\nKPX Tcommaaccent A -120\r\nKPX Tcommaaccent Aacute -120\r\nKPX Tcommaaccent Abreve -120\r\nKPX Tcommaaccent Acircumflex -120\r\nKPX Tcommaaccent Adieresis -120\r\nKPX Tcommaaccent Agrave -120\r\nKPX Tcommaaccent Amacron -120\r\nKPX Tcommaaccent Aogonek -120\r\nKPX Tcommaaccent Aring -120\r\nKPX Tcommaaccent Atilde -120\r\nKPX Tcommaaccent O -40\r\nKPX Tcommaaccent Oacute -40\r\nKPX Tcommaaccent Ocircumflex -40\r\nKPX Tcommaaccent Odieresis -40\r\nKPX Tcommaaccent Ograve -40\r\nKPX Tcommaaccent Ohungarumlaut -40\r\nKPX Tcommaaccent Omacron -40\r\nKPX Tcommaaccent Oslash -40\r\nKPX Tcommaaccent Otilde -40\r\nKPX Tcommaaccent a -120\r\nKPX Tcommaaccent aacute -120\r\nKPX Tcommaaccent abreve -60\r\nKPX Tcommaaccent acircumflex -120\r\nKPX Tcommaaccent adieresis -120\r\nKPX Tcommaaccent agrave -120\r\nKPX Tcommaaccent amacron -60\r\nKPX Tcommaaccent aogonek -120\r\nKPX Tcommaaccent aring -120\r\nKPX Tcommaaccent atilde -60\r\nKPX Tcommaaccent colon -20\r\nKPX Tcommaaccent comma -120\r\nKPX Tcommaaccent e -120\r\nKPX Tcommaaccent eacute -120\r\nKPX Tcommaaccent ecaron -120\r\nKPX Tcommaaccent ecircumflex -120\r\nKPX Tcommaaccent edieresis -120\r\nKPX Tcommaaccent edotaccent -120\r\nKPX Tcommaaccent egrave -60\r\nKPX Tcommaaccent emacron -60\r\nKPX Tcommaaccent eogonek -120\r\nKPX Tcommaaccent hyphen -140\r\nKPX Tcommaaccent o -120\r\nKPX Tcommaaccent oacute -120\r\nKPX Tcommaaccent ocircumflex -120\r\nKPX Tcommaaccent odieresis -120\r\nKPX Tcommaaccent ograve -120\r\nKPX Tcommaaccent ohungarumlaut -120\r\nKPX Tcommaaccent omacron -60\r\nKPX Tcommaaccent oslash -120\r\nKPX Tcommaaccent otilde -60\r\nKPX Tcommaaccent period -120\r\nKPX Tcommaaccent r -120\r\nKPX Tcommaaccent racute -120\r\nKPX Tcommaaccent rcaron -120\r\nKPX Tcommaaccent rcommaaccent -120\r\nKPX Tcommaaccent semicolon -20\r\nKPX Tcommaaccent u -120\r\nKPX Tcommaaccent uacute -120\r\nKPX Tcommaaccent ucircumflex -120\r\nKPX Tcommaaccent udieresis -120\r\nKPX Tcommaaccent ugrave -120\r\nKPX Tcommaaccent uhungarumlaut -120\r\nKPX Tcommaaccent umacron -60\r\nKPX Tcommaaccent uogonek -120\r\nKPX Tcommaaccent uring -120\r\nKPX Tcommaaccent w -120\r\nKPX Tcommaaccent y -120\r\nKPX Tcommaaccent yacute -120\r\nKPX Tcommaaccent ydieresis -60\r\nKPX U A -40\r\nKPX U Aacute -40\r\nKPX U Abreve -40\r\nKPX U Acircumflex -40\r\nKPX U Adieresis -40\r\nKPX U Agrave -40\r\nKPX U Amacron -40\r\nKPX U Aogonek -40\r\nKPX U Aring -40\r\nKPX U Atilde -40\r\nKPX U comma -40\r\nKPX U period -40\r\nKPX Uacute A -40\r\nKPX Uacute Aacute -40\r\nKPX Uacute Abreve -40\r\nKPX Uacute Acircumflex -40\r\nKPX Uacute Adieresis -40\r\nKPX Uacute Agrave -40\r\nKPX Uacute Amacron -40\r\nKPX Uacute Aogonek -40\r\nKPX Uacute Aring -40\r\nKPX Uacute Atilde -40\r\nKPX Uacute comma -40\r\nKPX Uacute period -40\r\nKPX Ucircumflex A -40\r\nKPX Ucircumflex Aacute -40\r\nKPX Ucircumflex Abreve -40\r\nKPX Ucircumflex Acircumflex -40\r\nKPX Ucircumflex Adieresis -40\r\nKPX Ucircumflex Agrave -40\r\nKPX Ucircumflex Amacron -40\r\nKPX Ucircumflex Aogonek -40\r\nKPX Ucircumflex Aring -40\r\nKPX Ucircumflex Atilde -40\r\nKPX Ucircumflex comma -40\r\nKPX Ucircumflex period -40\r\nKPX Udieresis A -40\r\nKPX Udieresis Aacute -40\r\nKPX Udieresis Abreve -40\r\nKPX Udieresis Acircumflex -40\r\nKPX Udieresis Adieresis -40\r\nKPX Udieresis Agrave -40\r\nKPX Udieresis Amacron -40\r\nKPX Udieresis Aogonek -40\r\nKPX Udieresis Aring -40\r\nKPX Udieresis Atilde -40\r\nKPX Udieresis comma -40\r\nKPX Udieresis period -40\r\nKPX Ugrave A -40\r\nKPX Ugrave Aacute -40\r\nKPX Ugrave Abreve -40\r\nKPX Ugrave Acircumflex -40\r\nKPX Ugrave Adieresis -40\r\nKPX Ugrave Agrave -40\r\nKPX Ugrave Amacron -40\r\nKPX Ugrave Aogonek -40\r\nKPX Ugrave Aring -40\r\nKPX Ugrave Atilde -40\r\nKPX Ugrave comma -40\r\nKPX Ugrave period -40\r\nKPX Uhungarumlaut A -40\r\nKPX Uhungarumlaut Aacute -40\r\nKPX Uhungarumlaut Abreve -40\r\nKPX Uhungarumlaut Acircumflex -40\r\nKPX Uhungarumlaut Adieresis -40\r\nKPX Uhungarumlaut Agrave -40\r\nKPX Uhungarumlaut Amacron -40\r\nKPX Uhungarumlaut Aogonek -40\r\nKPX Uhungarumlaut Aring -40\r\nKPX Uhungarumlaut Atilde -40\r\nKPX Uhungarumlaut comma -40\r\nKPX Uhungarumlaut period -40\r\nKPX Umacron A -40\r\nKPX Umacron Aacute -40\r\nKPX Umacron Abreve -40\r\nKPX Umacron Acircumflex -40\r\nKPX Umacron Adieresis -40\r\nKPX Umacron Agrave -40\r\nKPX Umacron Amacron -40\r\nKPX Umacron Aogonek -40\r\nKPX Umacron Aring -40\r\nKPX Umacron Atilde -40\r\nKPX Umacron comma -40\r\nKPX Umacron period -40\r\nKPX Uogonek A -40\r\nKPX Uogonek Aacute -40\r\nKPX Uogonek Abreve -40\r\nKPX Uogonek Acircumflex -40\r\nKPX Uogonek Adieresis -40\r\nKPX Uogonek Agrave -40\r\nKPX Uogonek Amacron -40\r\nKPX Uogonek Aogonek -40\r\nKPX Uogonek Aring -40\r\nKPX Uogonek Atilde -40\r\nKPX Uogonek comma -40\r\nKPX Uogonek period -40\r\nKPX Uring A -40\r\nKPX Uring Aacute -40\r\nKPX Uring Abreve -40\r\nKPX Uring Acircumflex -40\r\nKPX Uring Adieresis -40\r\nKPX Uring Agrave -40\r\nKPX Uring Amacron -40\r\nKPX Uring Aogonek -40\r\nKPX Uring Aring -40\r\nKPX Uring Atilde -40\r\nKPX Uring comma -40\r\nKPX Uring period -40\r\nKPX V A -80\r\nKPX V Aacute -80\r\nKPX V Abreve -80\r\nKPX V Acircumflex -80\r\nKPX V Adieresis -80\r\nKPX V Agrave -80\r\nKPX V Amacron -80\r\nKPX V Aogonek -80\r\nKPX V Aring -80\r\nKPX V Atilde -80\r\nKPX V G -40\r\nKPX V Gbreve -40\r\nKPX V Gcommaaccent -40\r\nKPX V O -40\r\nKPX V Oacute -40\r\nKPX V Ocircumflex -40\r\nKPX V Odieresis -40\r\nKPX V Ograve -40\r\nKPX V Ohungarumlaut -40\r\nKPX V Omacron -40\r\nKPX V Oslash -40\r\nKPX V Otilde -40\r\nKPX V a -70\r\nKPX V aacute -70\r\nKPX V abreve -70\r\nKPX V acircumflex -70\r\nKPX V adieresis -70\r\nKPX V agrave -70\r\nKPX V amacron -70\r\nKPX V aogonek -70\r\nKPX V aring -70\r\nKPX V atilde -70\r\nKPX V colon -40\r\nKPX V comma -125\r\nKPX V e -80\r\nKPX V eacute -80\r\nKPX V ecaron -80\r\nKPX V ecircumflex -80\r\nKPX V edieresis -80\r\nKPX V edotaccent -80\r\nKPX V egrave -80\r\nKPX V emacron -80\r\nKPX V eogonek -80\r\nKPX V hyphen -80\r\nKPX V o -80\r\nKPX V oacute -80\r\nKPX V ocircumflex -80\r\nKPX V odieresis -80\r\nKPX V ograve -80\r\nKPX V ohungarumlaut -80\r\nKPX V omacron -80\r\nKPX V oslash -80\r\nKPX V otilde -80\r\nKPX V period -125\r\nKPX V semicolon -40\r\nKPX V u -70\r\nKPX V uacute -70\r\nKPX V ucircumflex -70\r\nKPX V udieresis -70\r\nKPX V ugrave -70\r\nKPX V uhungarumlaut -70\r\nKPX V umacron -70\r\nKPX V uogonek -70\r\nKPX V uring -70\r\nKPX W A -50\r\nKPX W Aacute -50\r\nKPX W Abreve -50\r\nKPX W Acircumflex -50\r\nKPX W Adieresis -50\r\nKPX W Agrave -50\r\nKPX W Amacron -50\r\nKPX W Aogonek -50\r\nKPX W Aring -50\r\nKPX W Atilde -50\r\nKPX W O -20\r\nKPX W Oacute -20\r\nKPX W Ocircumflex -20\r\nKPX W Odieresis -20\r\nKPX W Ograve -20\r\nKPX W Ohungarumlaut -20\r\nKPX W Omacron -20\r\nKPX W Oslash -20\r\nKPX W Otilde -20\r\nKPX W a -40\r\nKPX W aacute -40\r\nKPX W abreve -40\r\nKPX W acircumflex -40\r\nKPX W adieresis -40\r\nKPX W agrave -40\r\nKPX W amacron -40\r\nKPX W aogonek -40\r\nKPX W aring -40\r\nKPX W atilde -40\r\nKPX W comma -80\r\nKPX W e -30\r\nKPX W eacute -30\r\nKPX W ecaron -30\r\nKPX W ecircumflex -30\r\nKPX W edieresis -30\r\nKPX W edotaccent -30\r\nKPX W egrave -30\r\nKPX W emacron -30\r\nKPX W eogonek -30\r\nKPX W hyphen -40\r\nKPX W o -30\r\nKPX W oacute -30\r\nKPX W ocircumflex -30\r\nKPX W odieresis -30\r\nKPX W ograve -30\r\nKPX W ohungarumlaut -30\r\nKPX W omacron -30\r\nKPX W oslash -30\r\nKPX W otilde -30\r\nKPX W period -80\r\nKPX W u -30\r\nKPX W uacute -30\r\nKPX W ucircumflex -30\r\nKPX W udieresis -30\r\nKPX W ugrave -30\r\nKPX W uhungarumlaut -30\r\nKPX W umacron -30\r\nKPX W uogonek -30\r\nKPX W uring -30\r\nKPX W y -20\r\nKPX W yacute -20\r\nKPX W ydieresis -20\r\nKPX Y A -110\r\nKPX Y Aacute -110\r\nKPX Y Abreve -110\r\nKPX Y Acircumflex -110\r\nKPX Y Adieresis -110\r\nKPX Y Agrave -110\r\nKPX Y Amacron -110\r\nKPX Y Aogonek -110\r\nKPX Y Aring -110\r\nKPX Y Atilde -110\r\nKPX Y O -85\r\nKPX Y Oacute -85\r\nKPX Y Ocircumflex -85\r\nKPX Y Odieresis -85\r\nKPX Y Ograve -85\r\nKPX Y Ohungarumlaut -85\r\nKPX Y Omacron -85\r\nKPX Y Oslash -85\r\nKPX Y Otilde -85\r\nKPX Y a -140\r\nKPX Y aacute -140\r\nKPX Y abreve -70\r\nKPX Y acircumflex -140\r\nKPX Y adieresis -140\r\nKPX Y agrave -140\r\nKPX Y amacron -70\r\nKPX Y aogonek -140\r\nKPX Y aring -140\r\nKPX Y atilde -140\r\nKPX Y colon -60\r\nKPX Y comma -140\r\nKPX Y e -140\r\nKPX Y eacute -140\r\nKPX Y ecaron -140\r\nKPX Y ecircumflex -140\r\nKPX Y edieresis -140\r\nKPX Y edotaccent -140\r\nKPX Y egrave -140\r\nKPX Y emacron -70\r\nKPX Y eogonek -140\r\nKPX Y hyphen -140\r\nKPX Y i -20\r\nKPX Y iacute -20\r\nKPX Y iogonek -20\r\nKPX Y o -140\r\nKPX Y oacute -140\r\nKPX Y ocircumflex -140\r\nKPX Y odieresis -140\r\nKPX Y ograve -140\r\nKPX Y ohungarumlaut -140\r\nKPX Y omacron -140\r\nKPX Y oslash -140\r\nKPX Y otilde -140\r\nKPX Y period -140\r\nKPX Y semicolon -60\r\nKPX Y u -110\r\nKPX Y uacute -110\r\nKPX Y ucircumflex -110\r\nKPX Y udieresis -110\r\nKPX Y ugrave -110\r\nKPX Y uhungarumlaut -110\r\nKPX Y umacron -110\r\nKPX Y uogonek -110\r\nKPX Y uring -110\r\nKPX Yacute A -110\r\nKPX Yacute Aacute -110\r\nKPX Yacute Abreve -110\r\nKPX Yacute Acircumflex -110\r\nKPX Yacute Adieresis -110\r\nKPX Yacute Agrave -110\r\nKPX Yacute Amacron -110\r\nKPX Yacute Aogonek -110\r\nKPX Yacute Aring -110\r\nKPX Yacute Atilde -110\r\nKPX Yacute O -85\r\nKPX Yacute Oacute -85\r\nKPX Yacute Ocircumflex -85\r\nKPX Yacute Odieresis -85\r\nKPX Yacute Ograve -85\r\nKPX Yacute Ohungarumlaut -85\r\nKPX Yacute Omacron -85\r\nKPX Yacute Oslash -85\r\nKPX Yacute Otilde -85\r\nKPX Yacute a -140\r\nKPX Yacute aacute -140\r\nKPX Yacute abreve -70\r\nKPX Yacute acircumflex -140\r\nKPX Yacute adieresis -140\r\nKPX Yacute agrave -140\r\nKPX Yacute amacron -70\r\nKPX Yacute aogonek -140\r\nKPX Yacute aring -140\r\nKPX Yacute atilde -70\r\nKPX Yacute colon -60\r\nKPX Yacute comma -140\r\nKPX Yacute e -140\r\nKPX Yacute eacute -140\r\nKPX Yacute ecaron -140\r\nKPX Yacute ecircumflex -140\r\nKPX Yacute edieresis -140\r\nKPX Yacute edotaccent -140\r\nKPX Yacute egrave -140\r\nKPX Yacute emacron -70\r\nKPX Yacute eogonek -140\r\nKPX Yacute hyphen -140\r\nKPX Yacute i -20\r\nKPX Yacute iacute -20\r\nKPX Yacute iogonek -20\r\nKPX Yacute o -140\r\nKPX Yacute oacute -140\r\nKPX Yacute ocircumflex -140\r\nKPX Yacute odieresis -140\r\nKPX Yacute ograve -140\r\nKPX Yacute ohungarumlaut -140\r\nKPX Yacute omacron -70\r\nKPX Yacute oslash -140\r\nKPX Yacute otilde -140\r\nKPX Yacute period -140\r\nKPX Yacute semicolon -60\r\nKPX Yacute u -110\r\nKPX Yacute uacute -110\r\nKPX Yacute ucircumflex -110\r\nKPX Yacute udieresis -110\r\nKPX Yacute ugrave -110\r\nKPX Yacute uhungarumlaut -110\r\nKPX Yacute umacron -110\r\nKPX Yacute uogonek -110\r\nKPX Yacute uring -110\r\nKPX Ydieresis A -110\r\nKPX Ydieresis Aacute -110\r\nKPX Ydieresis Abreve -110\r\nKPX Ydieresis Acircumflex -110\r\nKPX Ydieresis Adieresis -110\r\nKPX Ydieresis Agrave -110\r\nKPX Ydieresis Amacron -110\r\nKPX Ydieresis Aogonek -110\r\nKPX Ydieresis Aring -110\r\nKPX Ydieresis Atilde -110\r\nKPX Ydieresis O -85\r\nKPX Ydieresis Oacute -85\r\nKPX Ydieresis Ocircumflex -85\r\nKPX Ydieresis Odieresis -85\r\nKPX Ydieresis Ograve -85\r\nKPX Ydieresis Ohungarumlaut -85\r\nKPX Ydieresis Omacron -85\r\nKPX Ydieresis Oslash -85\r\nKPX Ydieresis Otilde -85\r\nKPX Ydieresis a -140\r\nKPX Ydieresis aacute -140\r\nKPX Ydieresis abreve -70\r\nKPX Ydieresis acircumflex -140\r\nKPX Ydieresis adieresis -140\r\nKPX Ydieresis agrave -140\r\nKPX Ydieresis amacron -70\r\nKPX Ydieresis aogonek -140\r\nKPX Ydieresis aring -140\r\nKPX Ydieresis atilde -70\r\nKPX Ydieresis colon -60\r\nKPX Ydieresis comma -140\r\nKPX Ydieresis e -140\r\nKPX Ydieresis eacute -140\r\nKPX Ydieresis ecaron -140\r\nKPX Ydieresis ecircumflex -140\r\nKPX Ydieresis edieresis -140\r\nKPX Ydieresis edotaccent -140\r\nKPX Ydieresis egrave -140\r\nKPX Ydieresis emacron -70\r\nKPX Ydieresis eogonek -140\r\nKPX Ydieresis hyphen -140\r\nKPX Ydieresis i -20\r\nKPX Ydieresis iacute -20\r\nKPX Ydieresis iogonek -20\r\nKPX Ydieresis o -140\r\nKPX Ydieresis oacute -140\r\nKPX Ydieresis ocircumflex -140\r\nKPX Ydieresis odieresis -140\r\nKPX Ydieresis ograve -140\r\nKPX Ydieresis ohungarumlaut -140\r\nKPX Ydieresis omacron -140\r\nKPX Ydieresis oslash -140\r\nKPX Ydieresis otilde -140\r\nKPX Ydieresis period -140\r\nKPX Ydieresis semicolon -60\r\nKPX Ydieresis u -110\r\nKPX Ydieresis uacute -110\r\nKPX Ydieresis ucircumflex -110\r\nKPX Ydieresis udieresis -110\r\nKPX Ydieresis ugrave -110\r\nKPX Ydieresis uhungarumlaut -110\r\nKPX Ydieresis umacron -110\r\nKPX Ydieresis uogonek -110\r\nKPX Ydieresis uring -110\r\nKPX a v -20\r\nKPX a w -20\r\nKPX a y -30\r\nKPX a yacute -30\r\nKPX a ydieresis -30\r\nKPX aacute v -20\r\nKPX aacute w -20\r\nKPX aacute y -30\r\nKPX aacute yacute -30\r\nKPX aacute ydieresis -30\r\nKPX abreve v -20\r\nKPX abreve w -20\r\nKPX abreve y -30\r\nKPX abreve yacute -30\r\nKPX abreve ydieresis -30\r\nKPX acircumflex v -20\r\nKPX acircumflex w -20\r\nKPX acircumflex y -30\r\nKPX acircumflex yacute -30\r\nKPX acircumflex ydieresis -30\r\nKPX adieresis v -20\r\nKPX adieresis w -20\r\nKPX adieresis y -30\r\nKPX adieresis yacute -30\r\nKPX adieresis ydieresis -30\r\nKPX agrave v -20\r\nKPX agrave w -20\r\nKPX agrave y -30\r\nKPX agrave yacute -30\r\nKPX agrave ydieresis -30\r\nKPX amacron v -20\r\nKPX amacron w -20\r\nKPX amacron y -30\r\nKPX amacron yacute -30\r\nKPX amacron ydieresis -30\r\nKPX aogonek v -20\r\nKPX aogonek w -20\r\nKPX aogonek y -30\r\nKPX aogonek yacute -30\r\nKPX aogonek ydieresis -30\r\nKPX aring v -20\r\nKPX aring w -20\r\nKPX aring y -30\r\nKPX aring yacute -30\r\nKPX aring ydieresis -30\r\nKPX atilde v -20\r\nKPX atilde w -20\r\nKPX atilde y -30\r\nKPX atilde yacute -30\r\nKPX atilde ydieresis -30\r\nKPX b b -10\r\nKPX b comma -40\r\nKPX b l -20\r\nKPX b lacute -20\r\nKPX b lcommaaccent -20\r\nKPX b lslash -20\r\nKPX b period -40\r\nKPX b u -20\r\nKPX b uacute -20\r\nKPX b ucircumflex -20\r\nKPX b udieresis -20\r\nKPX b ugrave -20\r\nKPX b uhungarumlaut -20\r\nKPX b umacron -20\r\nKPX b uogonek -20\r\nKPX b uring -20\r\nKPX b v -20\r\nKPX b y -20\r\nKPX b yacute -20\r\nKPX b ydieresis -20\r\nKPX c comma -15\r\nKPX c k -20\r\nKPX c kcommaaccent -20\r\nKPX cacute comma -15\r\nKPX cacute k -20\r\nKPX cacute kcommaaccent -20\r\nKPX ccaron comma -15\r\nKPX ccaron k -20\r\nKPX ccaron kcommaaccent -20\r\nKPX ccedilla comma -15\r\nKPX ccedilla k -20\r\nKPX ccedilla kcommaaccent -20\r\nKPX colon space -50\r\nKPX comma quotedblright -100\r\nKPX comma quoteright -100\r\nKPX e comma -15\r\nKPX e period -15\r\nKPX e v -30\r\nKPX e w -20\r\nKPX e x -30\r\nKPX e y -20\r\nKPX e yacute -20\r\nKPX e ydieresis -20\r\nKPX eacute comma -15\r\nKPX eacute period -15\r\nKPX eacute v -30\r\nKPX eacute w -20\r\nKPX eacute x -30\r\nKPX eacute y -20\r\nKPX eacute yacute -20\r\nKPX eacute ydieresis -20\r\nKPX ecaron comma -15\r\nKPX ecaron period -15\r\nKPX ecaron v -30\r\nKPX ecaron w -20\r\nKPX ecaron x -30\r\nKPX ecaron y -20\r\nKPX ecaron yacute -20\r\nKPX ecaron ydieresis -20\r\nKPX ecircumflex comma -15\r\nKPX ecircumflex period -15\r\nKPX ecircumflex v -30\r\nKPX ecircumflex w -20\r\nKPX ecircumflex x -30\r\nKPX ecircumflex y -20\r\nKPX ecircumflex yacute -20\r\nKPX ecircumflex ydieresis -20\r\nKPX edieresis comma -15\r\nKPX edieresis period -15\r\nKPX edieresis v -30\r\nKPX edieresis w -20\r\nKPX edieresis x -30\r\nKPX edieresis y -20\r\nKPX edieresis yacute -20\r\nKPX edieresis ydieresis -20\r\nKPX edotaccent comma -15\r\nKPX edotaccent period -15\r\nKPX edotaccent v -30\r\nKPX edotaccent w -20\r\nKPX edotaccent x -30\r\nKPX edotaccent y -20\r\nKPX edotaccent yacute -20\r\nKPX edotaccent ydieresis -20\r\nKPX egrave comma -15\r\nKPX egrave period -15\r\nKPX egrave v -30\r\nKPX egrave w -20\r\nKPX egrave x -30\r\nKPX egrave y -20\r\nKPX egrave yacute -20\r\nKPX egrave ydieresis -20\r\nKPX emacron comma -15\r\nKPX emacron period -15\r\nKPX emacron v -30\r\nKPX emacron w -20\r\nKPX emacron x -30\r\nKPX emacron y -20\r\nKPX emacron yacute -20\r\nKPX emacron ydieresis -20\r\nKPX eogonek comma -15\r\nKPX eogonek period -15\r\nKPX eogonek v -30\r\nKPX eogonek w -20\r\nKPX eogonek x -30\r\nKPX eogonek y -20\r\nKPX eogonek yacute -20\r\nKPX eogonek ydieresis -20\r\nKPX f a -30\r\nKPX f aacute -30\r\nKPX f abreve -30\r\nKPX f acircumflex -30\r\nKPX f adieresis -30\r\nKPX f agrave -30\r\nKPX f amacron -30\r\nKPX f aogonek -30\r\nKPX f aring -30\r\nKPX f atilde -30\r\nKPX f comma -30\r\nKPX f dotlessi -28\r\nKPX f e -30\r\nKPX f eacute -30\r\nKPX f ecaron -30\r\nKPX f ecircumflex -30\r\nKPX f edieresis -30\r\nKPX f edotaccent -30\r\nKPX f egrave -30\r\nKPX f emacron -30\r\nKPX f eogonek -30\r\nKPX f o -30\r\nKPX f oacute -30\r\nKPX f ocircumflex -30\r\nKPX f odieresis -30\r\nKPX f ograve -30\r\nKPX f ohungarumlaut -30\r\nKPX f omacron -30\r\nKPX f oslash -30\r\nKPX f otilde -30\r\nKPX f period -30\r\nKPX f quotedblright 60\r\nKPX f quoteright 50\r\nKPX g r -10\r\nKPX g racute -10\r\nKPX g rcaron -10\r\nKPX g rcommaaccent -10\r\nKPX gbreve r -10\r\nKPX gbreve racute -10\r\nKPX gbreve rcaron -10\r\nKPX gbreve rcommaaccent -10\r\nKPX gcommaaccent r -10\r\nKPX gcommaaccent racute -10\r\nKPX gcommaaccent rcaron -10\r\nKPX gcommaaccent rcommaaccent -10\r\nKPX h y -30\r\nKPX h yacute -30\r\nKPX h ydieresis -30\r\nKPX k e -20\r\nKPX k eacute -20\r\nKPX k ecaron -20\r\nKPX k ecircumflex -20\r\nKPX k edieresis -20\r\nKPX k edotaccent -20\r\nKPX k egrave -20\r\nKPX k emacron -20\r\nKPX k eogonek -20\r\nKPX k o -20\r\nKPX k oacute -20\r\nKPX k ocircumflex -20\r\nKPX k odieresis -20\r\nKPX k ograve -20\r\nKPX k ohungarumlaut -20\r\nKPX k omacron -20\r\nKPX k oslash -20\r\nKPX k otilde -20\r\nKPX kcommaaccent e -20\r\nKPX kcommaaccent eacute -20\r\nKPX kcommaaccent ecaron -20\r\nKPX kcommaaccent ecircumflex -20\r\nKPX kcommaaccent edieresis -20\r\nKPX kcommaaccent edotaccent -20\r\nKPX kcommaaccent egrave -20\r\nKPX kcommaaccent emacron -20\r\nKPX kcommaaccent eogonek -20\r\nKPX kcommaaccent o -20\r\nKPX kcommaaccent oacute -20\r\nKPX kcommaaccent ocircumflex -20\r\nKPX kcommaaccent odieresis -20\r\nKPX kcommaaccent ograve -20\r\nKPX kcommaaccent ohungarumlaut -20\r\nKPX kcommaaccent omacron -20\r\nKPX kcommaaccent oslash -20\r\nKPX kcommaaccent otilde -20\r\nKPX m u -10\r\nKPX m uacute -10\r\nKPX m ucircumflex -10\r\nKPX m udieresis -10\r\nKPX m ugrave -10\r\nKPX m uhungarumlaut -10\r\nKPX m umacron -10\r\nKPX m uogonek -10\r\nKPX m uring -10\r\nKPX m y -15\r\nKPX m yacute -15\r\nKPX m ydieresis -15\r\nKPX n u -10\r\nKPX n uacute -10\r\nKPX n ucircumflex -10\r\nKPX n udieresis -10\r\nKPX n ugrave -10\r\nKPX n uhungarumlaut -10\r\nKPX n umacron -10\r\nKPX n uogonek -10\r\nKPX n uring -10\r\nKPX n v -20\r\nKPX n y -15\r\nKPX n yacute -15\r\nKPX n ydieresis -15\r\nKPX nacute u -10\r\nKPX nacute uacute -10\r\nKPX nacute ucircumflex -10\r\nKPX nacute udieresis -10\r\nKPX nacute ugrave -10\r\nKPX nacute uhungarumlaut -10\r\nKPX nacute umacron -10\r\nKPX nacute uogonek -10\r\nKPX nacute uring -10\r\nKPX nacute v -20\r\nKPX nacute y -15\r\nKPX nacute yacute -15\r\nKPX nacute ydieresis -15\r\nKPX ncaron u -10\r\nKPX ncaron uacute -10\r\nKPX ncaron ucircumflex -10\r\nKPX ncaron udieresis -10\r\nKPX ncaron ugrave -10\r\nKPX ncaron uhungarumlaut -10\r\nKPX ncaron umacron -10\r\nKPX ncaron uogonek -10\r\nKPX ncaron uring -10\r\nKPX ncaron v -20\r\nKPX ncaron y -15\r\nKPX ncaron yacute -15\r\nKPX ncaron ydieresis -15\r\nKPX ncommaaccent u -10\r\nKPX ncommaaccent uacute -10\r\nKPX ncommaaccent ucircumflex -10\r\nKPX ncommaaccent udieresis -10\r\nKPX ncommaaccent ugrave -10\r\nKPX ncommaaccent uhungarumlaut -10\r\nKPX ncommaaccent umacron -10\r\nKPX ncommaaccent uogonek -10\r\nKPX ncommaaccent uring -10\r\nKPX ncommaaccent v -20\r\nKPX ncommaaccent y -15\r\nKPX ncommaaccent yacute -15\r\nKPX ncommaaccent ydieresis -15\r\nKPX ntilde u -10\r\nKPX ntilde uacute -10\r\nKPX ntilde ucircumflex -10\r\nKPX ntilde udieresis -10\r\nKPX ntilde ugrave -10\r\nKPX ntilde uhungarumlaut -10\r\nKPX ntilde umacron -10\r\nKPX ntilde uogonek -10\r\nKPX ntilde uring -10\r\nKPX ntilde v -20\r\nKPX ntilde y -15\r\nKPX ntilde yacute -15\r\nKPX ntilde ydieresis -15\r\nKPX o comma -40\r\nKPX o period -40\r\nKPX o v -15\r\nKPX o w -15\r\nKPX o x -30\r\nKPX o y -30\r\nKPX o yacute -30\r\nKPX o ydieresis -30\r\nKPX oacute comma -40\r\nKPX oacute period -40\r\nKPX oacute v -15\r\nKPX oacute w -15\r\nKPX oacute x -30\r\nKPX oacute y -30\r\nKPX oacute yacute -30\r\nKPX oacute ydieresis -30\r\nKPX ocircumflex comma -40\r\nKPX ocircumflex period -40\r\nKPX ocircumflex v -15\r\nKPX ocircumflex w -15\r\nKPX ocircumflex x -30\r\nKPX ocircumflex y -30\r\nKPX ocircumflex yacute -30\r\nKPX ocircumflex ydieresis -30\r\nKPX odieresis comma -40\r\nKPX odieresis period -40\r\nKPX odieresis v -15\r\nKPX odieresis w -15\r\nKPX odieresis x -30\r\nKPX odieresis y -30\r\nKPX odieresis yacute -30\r\nKPX odieresis ydieresis -30\r\nKPX ograve comma -40\r\nKPX ograve period -40\r\nKPX ograve v -15\r\nKPX ograve w -15\r\nKPX ograve x -30\r\nKPX ograve y -30\r\nKPX ograve yacute -30\r\nKPX ograve ydieresis -30\r\nKPX ohungarumlaut comma -40\r\nKPX ohungarumlaut period -40\r\nKPX ohungarumlaut v -15\r\nKPX ohungarumlaut w -15\r\nKPX ohungarumlaut x -30\r\nKPX ohungarumlaut y -30\r\nKPX ohungarumlaut yacute -30\r\nKPX ohungarumlaut ydieresis -30\r\nKPX omacron comma -40\r\nKPX omacron period -40\r\nKPX omacron v -15\r\nKPX omacron w -15\r\nKPX omacron x -30\r\nKPX omacron y -30\r\nKPX omacron yacute -30\r\nKPX omacron ydieresis -30\r\nKPX oslash a -55\r\nKPX oslash aacute -55\r\nKPX oslash abreve -55\r\nKPX oslash acircumflex -55\r\nKPX oslash adieresis -55\r\nKPX oslash agrave -55\r\nKPX oslash amacron -55\r\nKPX oslash aogonek -55\r\nKPX oslash aring -55\r\nKPX oslash atilde -55\r\nKPX oslash b -55\r\nKPX oslash c -55\r\nKPX oslash cacute -55\r\nKPX oslash ccaron -55\r\nKPX oslash ccedilla -55\r\nKPX oslash comma -95\r\nKPX oslash d -55\r\nKPX oslash dcroat -55\r\nKPX oslash e -55\r\nKPX oslash eacute -55\r\nKPX oslash ecaron -55\r\nKPX oslash ecircumflex -55\r\nKPX oslash edieresis -55\r\nKPX oslash edotaccent -55\r\nKPX oslash egrave -55\r\nKPX oslash emacron -55\r\nKPX oslash eogonek -55\r\nKPX oslash f -55\r\nKPX oslash g -55\r\nKPX oslash gbreve -55\r\nKPX oslash gcommaaccent -55\r\nKPX oslash h -55\r\nKPX oslash i -55\r\nKPX oslash iacute -55\r\nKPX oslash icircumflex -55\r\nKPX oslash idieresis -55\r\nKPX oslash igrave -55\r\nKPX oslash imacron -55\r\nKPX oslash iogonek -55\r\nKPX oslash j -55\r\nKPX oslash k -55\r\nKPX oslash kcommaaccent -55\r\nKPX oslash l -55\r\nKPX oslash lacute -55\r\nKPX oslash lcommaaccent -55\r\nKPX oslash lslash -55\r\nKPX oslash m -55\r\nKPX oslash n -55\r\nKPX oslash nacute -55\r\nKPX oslash ncaron -55\r\nKPX oslash ncommaaccent -55\r\nKPX oslash ntilde -55\r\nKPX oslash o -55\r\nKPX oslash oacute -55\r\nKPX oslash ocircumflex -55\r\nKPX oslash odieresis -55\r\nKPX oslash ograve -55\r\nKPX oslash ohungarumlaut -55\r\nKPX oslash omacron -55\r\nKPX oslash oslash -55\r\nKPX oslash otilde -55\r\nKPX oslash p -55\r\nKPX oslash period -95\r\nKPX oslash q -55\r\nKPX oslash r -55\r\nKPX oslash racute -55\r\nKPX oslash rcaron -55\r\nKPX oslash rcommaaccent -55\r\nKPX oslash s -55\r\nKPX oslash sacute -55\r\nKPX oslash scaron -55\r\nKPX oslash scedilla -55\r\nKPX oslash scommaaccent -55\r\nKPX oslash t -55\r\nKPX oslash tcommaaccent -55\r\nKPX oslash u -55\r\nKPX oslash uacute -55\r\nKPX oslash ucircumflex -55\r\nKPX oslash udieresis -55\r\nKPX oslash ugrave -55\r\nKPX oslash uhungarumlaut -55\r\nKPX oslash umacron -55\r\nKPX oslash uogonek -55\r\nKPX oslash uring -55\r\nKPX oslash v -70\r\nKPX oslash w -70\r\nKPX oslash x -85\r\nKPX oslash y -70\r\nKPX oslash yacute -70\r\nKPX oslash ydieresis -70\r\nKPX oslash z -55\r\nKPX oslash zacute -55\r\nKPX oslash zcaron -55\r\nKPX oslash zdotaccent -55\r\nKPX otilde comma -40\r\nKPX otilde period -40\r\nKPX otilde v -15\r\nKPX otilde w -15\r\nKPX otilde x -30\r\nKPX otilde y -30\r\nKPX otilde yacute -30\r\nKPX otilde ydieresis -30\r\nKPX p comma -35\r\nKPX p period -35\r\nKPX p y -30\r\nKPX p yacute -30\r\nKPX p ydieresis -30\r\nKPX period quotedblright -100\r\nKPX period quoteright -100\r\nKPX period space -60\r\nKPX quotedblright space -40\r\nKPX quoteleft quoteleft -57\r\nKPX quoteright d -50\r\nKPX quoteright dcroat -50\r\nKPX quoteright quoteright -57\r\nKPX quoteright r -50\r\nKPX quoteright racute -50\r\nKPX quoteright rcaron -50\r\nKPX quoteright rcommaaccent -50\r\nKPX quoteright s -50\r\nKPX quoteright sacute -50\r\nKPX quoteright scaron -50\r\nKPX quoteright scedilla -50\r\nKPX quoteright scommaaccent -50\r\nKPX quoteright space -70\r\nKPX r a -10\r\nKPX r aacute -10\r\nKPX r abreve -10\r\nKPX r acircumflex -10\r\nKPX r adieresis -10\r\nKPX r agrave -10\r\nKPX r amacron -10\r\nKPX r aogonek -10\r\nKPX r aring -10\r\nKPX r atilde -10\r\nKPX r colon 30\r\nKPX r comma -50\r\nKPX r i 15\r\nKPX r iacute 15\r\nKPX r icircumflex 15\r\nKPX r idieresis 15\r\nKPX r igrave 15\r\nKPX r imacron 15\r\nKPX r iogonek 15\r\nKPX r k 15\r\nKPX r kcommaaccent 15\r\nKPX r l 15\r\nKPX r lacute 15\r\nKPX r lcommaaccent 15\r\nKPX r lslash 15\r\nKPX r m 25\r\nKPX r n 25\r\nKPX r nacute 25\r\nKPX r ncaron 25\r\nKPX r ncommaaccent 25\r\nKPX r ntilde 25\r\nKPX r p 30\r\nKPX r period -50\r\nKPX r semicolon 30\r\nKPX r t 40\r\nKPX r tcommaaccent 40\r\nKPX r u 15\r\nKPX r uacute 15\r\nKPX r ucircumflex 15\r\nKPX r udieresis 15\r\nKPX r ugrave 15\r\nKPX r uhungarumlaut 15\r\nKPX r umacron 15\r\nKPX r uogonek 15\r\nKPX r uring 15\r\nKPX r v 30\r\nKPX r y 30\r\nKPX r yacute 30\r\nKPX r ydieresis 30\r\nKPX racute a -10\r\nKPX racute aacute -10\r\nKPX racute abreve -10\r\nKPX racute acircumflex -10\r\nKPX racute adieresis -10\r\nKPX racute agrave -10\r\nKPX racute amacron -10\r\nKPX racute aogonek -10\r\nKPX racute aring -10\r\nKPX racute atilde -10\r\nKPX racute colon 30\r\nKPX racute comma -50\r\nKPX racute i 15\r\nKPX racute iacute 15\r\nKPX racute icircumflex 15\r\nKPX racute idieresis 15\r\nKPX racute igrave 15\r\nKPX racute imacron 15\r\nKPX racute iogonek 15\r\nKPX racute k 15\r\nKPX racute kcommaaccent 15\r\nKPX racute l 15\r\nKPX racute lacute 15\r\nKPX racute lcommaaccent 15\r\nKPX racute lslash 15\r\nKPX racute m 25\r\nKPX racute n 25\r\nKPX racute nacute 25\r\nKPX racute ncaron 25\r\nKPX racute ncommaaccent 25\r\nKPX racute ntilde 25\r\nKPX racute p 30\r\nKPX racute period -50\r\nKPX racute semicolon 30\r\nKPX racute t 40\r\nKPX racute tcommaaccent 40\r\nKPX racute u 15\r\nKPX racute uacute 15\r\nKPX racute ucircumflex 15\r\nKPX racute udieresis 15\r\nKPX racute ugrave 15\r\nKPX racute uhungarumlaut 15\r\nKPX racute umacron 15\r\nKPX racute uogonek 15\r\nKPX racute uring 15\r\nKPX racute v 30\r\nKPX racute y 30\r\nKPX racute yacute 30\r\nKPX racute ydieresis 30\r\nKPX rcaron a -10\r\nKPX rcaron aacute -10\r\nKPX rcaron abreve -10\r\nKPX rcaron acircumflex -10\r\nKPX rcaron adieresis -10\r\nKPX rcaron agrave -10\r\nKPX rcaron amacron -10\r\nKPX rcaron aogonek -10\r\nKPX rcaron aring -10\r\nKPX rcaron atilde -10\r\nKPX rcaron colon 30\r\nKPX rcaron comma -50\r\nKPX rcaron i 15\r\nKPX rcaron iacute 15\r\nKPX rcaron icircumflex 15\r\nKPX rcaron idieresis 15\r\nKPX rcaron igrave 15\r\nKPX rcaron imacron 15\r\nKPX rcaron iogonek 15\r\nKPX rcaron k 15\r\nKPX rcaron kcommaaccent 15\r\nKPX rcaron l 15\r\nKPX rcaron lacute 15\r\nKPX rcaron lcommaaccent 15\r\nKPX rcaron lslash 15\r\nKPX rcaron m 25\r\nKPX rcaron n 25\r\nKPX rcaron nacute 25\r\nKPX rcaron ncaron 25\r\nKPX rcaron ncommaaccent 25\r\nKPX rcaron ntilde 25\r\nKPX rcaron p 30\r\nKPX rcaron period -50\r\nKPX rcaron semicolon 30\r\nKPX rcaron t 40\r\nKPX rcaron tcommaaccent 40\r\nKPX rcaron u 15\r\nKPX rcaron uacute 15\r\nKPX rcaron ucircumflex 15\r\nKPX rcaron udieresis 15\r\nKPX rcaron ugrave 15\r\nKPX rcaron uhungarumlaut 15\r\nKPX rcaron umacron 15\r\nKPX rcaron uogonek 15\r\nKPX rcaron uring 15\r\nKPX rcaron v 30\r\nKPX rcaron y 30\r\nKPX rcaron yacute 30\r\nKPX rcaron ydieresis 30\r\nKPX rcommaaccent a -10\r\nKPX rcommaaccent aacute -10\r\nKPX rcommaaccent abreve -10\r\nKPX rcommaaccent acircumflex -10\r\nKPX rcommaaccent adieresis -10\r\nKPX rcommaaccent agrave -10\r\nKPX rcommaaccent amacron -10\r\nKPX rcommaaccent aogonek -10\r\nKPX rcommaaccent aring -10\r\nKPX rcommaaccent atilde -10\r\nKPX rcommaaccent colon 30\r\nKPX rcommaaccent comma -50\r\nKPX rcommaaccent i 15\r\nKPX rcommaaccent iacute 15\r\nKPX rcommaaccent icircumflex 15\r\nKPX rcommaaccent idieresis 15\r\nKPX rcommaaccent igrave 15\r\nKPX rcommaaccent imacron 15\r\nKPX rcommaaccent iogonek 15\r\nKPX rcommaaccent k 15\r\nKPX rcommaaccent kcommaaccent 15\r\nKPX rcommaaccent l 15\r\nKPX rcommaaccent lacute 15\r\nKPX rcommaaccent lcommaaccent 15\r\nKPX rcommaaccent lslash 15\r\nKPX rcommaaccent m 25\r\nKPX rcommaaccent n 25\r\nKPX rcommaaccent nacute 25\r\nKPX rcommaaccent ncaron 25\r\nKPX rcommaaccent ncommaaccent 25\r\nKPX rcommaaccent ntilde 25\r\nKPX rcommaaccent p 30\r\nKPX rcommaaccent period -50\r\nKPX rcommaaccent semicolon 30\r\nKPX rcommaaccent t 40\r\nKPX rcommaaccent tcommaaccent 40\r\nKPX rcommaaccent u 15\r\nKPX rcommaaccent uacute 15\r\nKPX rcommaaccent ucircumflex 15\r\nKPX rcommaaccent udieresis 15\r\nKPX rcommaaccent ugrave 15\r\nKPX rcommaaccent uhungarumlaut 15\r\nKPX rcommaaccent umacron 15\r\nKPX rcommaaccent uogonek 15\r\nKPX rcommaaccent uring 15\r\nKPX rcommaaccent v 30\r\nKPX rcommaaccent y 30\r\nKPX rcommaaccent yacute 30\r\nKPX rcommaaccent ydieresis 30\r\nKPX s comma -15\r\nKPX s period -15\r\nKPX s w -30\r\nKPX sacute comma -15\r\nKPX sacute period -15\r\nKPX sacute w -30\r\nKPX scaron comma -15\r\nKPX scaron period -15\r\nKPX scaron w -30\r\nKPX scedilla comma -15\r\nKPX scedilla period -15\r\nKPX scedilla w -30\r\nKPX scommaaccent comma -15\r\nKPX scommaaccent period -15\r\nKPX scommaaccent w -30\r\nKPX semicolon space -50\r\nKPX space T -50\r\nKPX space Tcaron -50\r\nKPX space Tcommaaccent -50\r\nKPX space V -50\r\nKPX space W -40\r\nKPX space Y -90\r\nKPX space Yacute -90\r\nKPX space Ydieresis -90\r\nKPX space quotedblleft -30\r\nKPX space quoteleft -60\r\nKPX v a -25\r\nKPX v aacute -25\r\nKPX v abreve -25\r\nKPX v acircumflex -25\r\nKPX v adieresis -25\r\nKPX v agrave -25\r\nKPX v amacron -25\r\nKPX v aogonek -25\r\nKPX v aring -25\r\nKPX v atilde -25\r\nKPX v comma -80\r\nKPX v e -25\r\nKPX v eacute -25\r\nKPX v ecaron -25\r\nKPX v ecircumflex -25\r\nKPX v edieresis -25\r\nKPX v edotaccent -25\r\nKPX v egrave -25\r\nKPX v emacron -25\r\nKPX v eogonek -25\r\nKPX v o -25\r\nKPX v oacute -25\r\nKPX v ocircumflex -25\r\nKPX v odieresis -25\r\nKPX v ograve -25\r\nKPX v ohungarumlaut -25\r\nKPX v omacron -25\r\nKPX v oslash -25\r\nKPX v otilde -25\r\nKPX v period -80\r\nKPX w a -15\r\nKPX w aacute -15\r\nKPX w abreve -15\r\nKPX w acircumflex -15\r\nKPX w adieresis -15\r\nKPX w agrave -15\r\nKPX w amacron -15\r\nKPX w aogonek -15\r\nKPX w aring -15\r\nKPX w atilde -15\r\nKPX w comma -60\r\nKPX w e -10\r\nKPX w eacute -10\r\nKPX w ecaron -10\r\nKPX w ecircumflex -10\r\nKPX w edieresis -10\r\nKPX w edotaccent -10\r\nKPX w egrave -10\r\nKPX w emacron -10\r\nKPX w eogonek -10\r\nKPX w o -10\r\nKPX w oacute -10\r\nKPX w ocircumflex -10\r\nKPX w odieresis -10\r\nKPX w ograve -10\r\nKPX w ohungarumlaut -10\r\nKPX w omacron -10\r\nKPX w oslash -10\r\nKPX w otilde -10\r\nKPX w period -60\r\nKPX x e -30\r\nKPX x eacute -30\r\nKPX x ecaron -30\r\nKPX x ecircumflex -30\r\nKPX x edieresis -30\r\nKPX x edotaccent -30\r\nKPX x egrave -30\r\nKPX x emacron -30\r\nKPX x eogonek -30\r\nKPX y a -20\r\nKPX y aacute -20\r\nKPX y abreve -20\r\nKPX y acircumflex -20\r\nKPX y adieresis -20\r\nKPX y agrave -20\r\nKPX y amacron -20\r\nKPX y aogonek -20\r\nKPX y aring -20\r\nKPX y atilde -20\r\nKPX y comma -100\r\nKPX y e -20\r\nKPX y eacute -20\r\nKPX y ecaron -20\r\nKPX y ecircumflex -20\r\nKPX y edieresis -20\r\nKPX y edotaccent -20\r\nKPX y egrave -20\r\nKPX y emacron -20\r\nKPX y eogonek -20\r\nKPX y o -20\r\nKPX y oacute -20\r\nKPX y ocircumflex -20\r\nKPX y odieresis -20\r\nKPX y ograve -20\r\nKPX y ohungarumlaut -20\r\nKPX y omacron -20\r\nKPX y oslash -20\r\nKPX y otilde -20\r\nKPX y period -100\r\nKPX yacute a -20\r\nKPX yacute aacute -20\r\nKPX yacute abreve -20\r\nKPX yacute acircumflex -20\r\nKPX yacute adieresis -20\r\nKPX yacute agrave -20\r\nKPX yacute amacron -20\r\nKPX yacute aogonek -20\r\nKPX yacute aring -20\r\nKPX yacute atilde -20\r\nKPX yacute comma -100\r\nKPX yacute e -20\r\nKPX yacute eacute -20\r\nKPX yacute ecaron -20\r\nKPX yacute ecircumflex -20\r\nKPX yacute edieresis -20\r\nKPX yacute edotaccent -20\r\nKPX yacute egrave -20\r\nKPX yacute emacron -20\r\nKPX yacute eogonek -20\r\nKPX yacute o -20\r\nKPX yacute oacute -20\r\nKPX yacute ocircumflex -20\r\nKPX yacute odieresis -20\r\nKPX yacute ograve -20\r\nKPX yacute ohungarumlaut -20\r\nKPX yacute omacron -20\r\nKPX yacute oslash -20\r\nKPX yacute otilde -20\r\nKPX yacute period -100\r\nKPX ydieresis a -20\r\nKPX ydieresis aacute -20\r\nKPX ydieresis abreve -20\r\nKPX ydieresis acircumflex -20\r\nKPX ydieresis adieresis -20\r\nKPX ydieresis agrave -20\r\nKPX ydieresis amacron -20\r\nKPX ydieresis aogonek -20\r\nKPX ydieresis aring -20\r\nKPX ydieresis atilde -20\r\nKPX ydieresis comma -100\r\nKPX ydieresis e -20\r\nKPX ydieresis eacute -20\r\nKPX ydieresis ecaron -20\r\nKPX ydieresis ecircumflex -20\r\nKPX ydieresis edieresis -20\r\nKPX ydieresis edotaccent -20\r\nKPX ydieresis egrave -20\r\nKPX ydieresis emacron -20\r\nKPX ydieresis eogonek -20\r\nKPX ydieresis o -20\r\nKPX ydieresis oacute -20\r\nKPX ydieresis ocircumflex -20\r\nKPX ydieresis odieresis -20\r\nKPX ydieresis ograve -20\r\nKPX ydieresis ohungarumlaut -20\r\nKPX ydieresis omacron -20\r\nKPX ydieresis oslash -20\r\nKPX ydieresis otilde -20\r\nKPX ydieresis period -100\r\nKPX z e -15\r\nKPX z eacute -15\r\nKPX z ecaron -15\r\nKPX z ecircumflex -15\r\nKPX z edieresis -15\r\nKPX z edotaccent -15\r\nKPX z egrave -15\r\nKPX z emacron -15\r\nKPX z eogonek -15\r\nKPX z o -15\r\nKPX z oacute -15\r\nKPX z ocircumflex -15\r\nKPX z odieresis -15\r\nKPX z ograve -15\r\nKPX z ohungarumlaut -15\r\nKPX z omacron -15\r\nKPX z oslash -15\r\nKPX z otilde -15\r\nKPX zacute e -15\r\nKPX zacute eacute -15\r\nKPX zacute ecaron -15\r\nKPX zacute ecircumflex -15\r\nKPX zacute edieresis -15\r\nKPX zacute edotaccent -15\r\nKPX zacute egrave -15\r\nKPX zacute emacron -15\r\nKPX zacute eogonek -15\r\nKPX zacute o -15\r\nKPX zacute oacute -15\r\nKPX zacute ocircumflex -15\r\nKPX zacute odieresis -15\r\nKPX zacute ograve -15\r\nKPX zacute ohungarumlaut -15\r\nKPX zacute omacron -15\r\nKPX zacute oslash -15\r\nKPX zacute otilde -15\r\nKPX zcaron e -15\r\nKPX zcaron eacute -15\r\nKPX zcaron ecaron -15\r\nKPX zcaron ecircumflex -15\r\nKPX zcaron edieresis -15\r\nKPX zcaron edotaccent -15\r\nKPX zcaron egrave -15\r\nKPX zcaron emacron -15\r\nKPX zcaron eogonek -15\r\nKPX zcaron o -15\r\nKPX zcaron oacute -15\r\nKPX zcaron ocircumflex -15\r\nKPX zcaron odieresis -15\r\nKPX zcaron ograve -15\r\nKPX zcaron ohungarumlaut -15\r\nKPX zcaron omacron -15\r\nKPX zcaron oslash -15\r\nKPX zcaron otilde -15\r\nKPX zdotaccent e -15\r\nKPX zdotaccent eacute -15\r\nKPX zdotaccent ecaron -15\r\nKPX zdotaccent ecircumflex -15\r\nKPX zdotaccent edieresis -15\r\nKPX zdotaccent edotaccent -15\r\nKPX zdotaccent egrave -15\r\nKPX zdotaccent emacron -15\r\nKPX zdotaccent eogonek -15\r\nKPX zdotaccent o -15\r\nKPX zdotaccent oacute -15\r\nKPX zdotaccent ocircumflex -15\r\nKPX zdotaccent odieresis -15\r\nKPX zdotaccent ograve -15\r\nKPX zdotaccent ohungarumlaut -15\r\nKPX zdotaccent omacron -15\r\nKPX zdotaccent oslash -15\r\nKPX zdotaccent otilde -15\r\nEndKernPairs\r\nEndKernData\r\nEndFontMetrics\r\n";
  },
  'Helvetica-BoldOblique'() {
    return "StartFontMetrics 4.1\r\nComment Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.\r\nComment Creation Date: Thu May  1 12:45:12 1997\r\nComment UniqueID 43053\r\nComment VMusage 14482 68586\r\nFontName Helvetica-BoldOblique\r\nFullName Helvetica Bold Oblique\r\nFamilyName Helvetica\r\nWeight Bold\r\nItalicAngle -12\r\nIsFixedPitch false\r\nCharacterSet ExtendedRoman\r\nFontBBox -174 -228 1114 962 \r\nUnderlinePosition -100\r\nUnderlineThickness 50\r\nVersion 002.000\r\nNotice Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.Helvetica is a trademark of Linotype-Hell AG and/or its subsidiaries.\r\nEncodingScheme AdobeStandardEncoding\r\nCapHeight 718\r\nXHeight 532\r\nAscender 718\r\nDescender -207\r\nStdHW 118\r\nStdVW 140\r\nStartCharMetrics 315\r\nC 32 ; WX 278 ; N space ; B 0 0 0 0 ;\r\nC 33 ; WX 333 ; N exclam ; B 94 0 397 718 ;\r\nC 34 ; WX 474 ; N quotedbl ; B 193 447 529 718 ;\r\nC 35 ; WX 556 ; N numbersign ; B 60 0 644 698 ;\r\nC 36 ; WX 556 ; N dollar ; B 67 -115 622 775 ;\r\nC 37 ; WX 889 ; N percent ; B 136 -19 901 710 ;\r\nC 38 ; WX 722 ; N ampersand ; B 89 -19 732 718 ;\r\nC 39 ; WX 278 ; N quoteright ; B 167 445 362 718 ;\r\nC 40 ; WX 333 ; N parenleft ; B 76 -208 470 734 ;\r\nC 41 ; WX 333 ; N parenright ; B -25 -208 369 734 ;\r\nC 42 ; WX 389 ; N asterisk ; B 146 387 481 718 ;\r\nC 43 ; WX 584 ; N plus ; B 82 0 610 506 ;\r\nC 44 ; WX 278 ; N comma ; B 28 -168 245 146 ;\r\nC 45 ; WX 333 ; N hyphen ; B 73 215 379 345 ;\r\nC 46 ; WX 278 ; N period ; B 64 0 245 146 ;\r\nC 47 ; WX 278 ; N slash ; B -37 -19 468 737 ;\r\nC 48 ; WX 556 ; N zero ; B 86 -19 617 710 ;\r\nC 49 ; WX 556 ; N one ; B 173 0 529 710 ;\r\nC 50 ; WX 556 ; N two ; B 26 0 619 710 ;\r\nC 51 ; WX 556 ; N three ; B 65 -19 608 710 ;\r\nC 52 ; WX 556 ; N four ; B 60 0 598 710 ;\r\nC 53 ; WX 556 ; N five ; B 64 -19 636 698 ;\r\nC 54 ; WX 556 ; N six ; B 85 -19 619 710 ;\r\nC 55 ; WX 556 ; N seven ; B 125 0 676 698 ;\r\nC 56 ; WX 556 ; N eight ; B 69 -19 616 710 ;\r\nC 57 ; WX 556 ; N nine ; B 78 -19 615 710 ;\r\nC 58 ; WX 333 ; N colon ; B 92 0 351 512 ;\r\nC 59 ; WX 333 ; N semicolon ; B 56 -168 351 512 ;\r\nC 60 ; WX 584 ; N less ; B 82 -8 655 514 ;\r\nC 61 ; WX 584 ; N equal ; B 58 87 633 419 ;\r\nC 62 ; WX 584 ; N greater ; B 36 -8 609 514 ;\r\nC 63 ; WX 611 ; N question ; B 165 0 671 727 ;\r\nC 64 ; WX 975 ; N at ; B 186 -19 954 737 ;\r\nC 65 ; WX 722 ; N A ; B 20 0 702 718 ;\r\nC 66 ; WX 722 ; N B ; B 76 0 764 718 ;\r\nC 67 ; WX 722 ; N C ; B 107 -19 789 737 ;\r\nC 68 ; WX 722 ; N D ; B 76 0 777 718 ;\r\nC 69 ; WX 667 ; N E ; B 76 0 757 718 ;\r\nC 70 ; WX 611 ; N F ; B 76 0 740 718 ;\r\nC 71 ; WX 778 ; N G ; B 108 -19 817 737 ;\r\nC 72 ; WX 722 ; N H ; B 71 0 804 718 ;\r\nC 73 ; WX 278 ; N I ; B 64 0 367 718 ;\r\nC 74 ; WX 556 ; N J ; B 60 -18 637 718 ;\r\nC 75 ; WX 722 ; N K ; B 87 0 858 718 ;\r\nC 76 ; WX 611 ; N L ; B 76 0 611 718 ;\r\nC 77 ; WX 833 ; N M ; B 69 0 918 718 ;\r\nC 78 ; WX 722 ; N N ; B 69 0 807 718 ;\r\nC 79 ; WX 778 ; N O ; B 107 -19 823 737 ;\r\nC 80 ; WX 667 ; N P ; B 76 0 738 718 ;\r\nC 81 ; WX 778 ; N Q ; B 107 -52 823 737 ;\r\nC 82 ; WX 722 ; N R ; B 76 0 778 718 ;\r\nC 83 ; WX 667 ; N S ; B 81 -19 718 737 ;\r\nC 84 ; WX 611 ; N T ; B 140 0 751 718 ;\r\nC 85 ; WX 722 ; N U ; B 116 -19 804 718 ;\r\nC 86 ; WX 667 ; N V ; B 172 0 801 718 ;\r\nC 87 ; WX 944 ; N W ; B 169 0 1082 718 ;\r\nC 88 ; WX 667 ; N X ; B 14 0 791 718 ;\r\nC 89 ; WX 667 ; N Y ; B 168 0 806 718 ;\r\nC 90 ; WX 611 ; N Z ; B 25 0 737 718 ;\r\nC 91 ; WX 333 ; N bracketleft ; B 21 -196 462 722 ;\r\nC 92 ; WX 278 ; N backslash ; B 124 -19 307 737 ;\r\nC 93 ; WX 333 ; N bracketright ; B -18 -196 423 722 ;\r\nC 94 ; WX 584 ; N asciicircum ; B 131 323 591 698 ;\r\nC 95 ; WX 556 ; N underscore ; B -27 -125 540 -75 ;\r\nC 96 ; WX 278 ; N quoteleft ; B 165 454 361 727 ;\r\nC 97 ; WX 556 ; N a ; B 55 -14 583 546 ;\r\nC 98 ; WX 611 ; N b ; B 61 -14 645 718 ;\r\nC 99 ; WX 556 ; N c ; B 79 -14 599 546 ;\r\nC 100 ; WX 611 ; N d ; B 82 -14 704 718 ;\r\nC 101 ; WX 556 ; N e ; B 70 -14 593 546 ;\r\nC 102 ; WX 333 ; N f ; B 87 0 469 727 ; L i fi ; L l fl ;\r\nC 103 ; WX 611 ; N g ; B 38 -217 666 546 ;\r\nC 104 ; WX 611 ; N h ; B 65 0 629 718 ;\r\nC 105 ; WX 278 ; N i ; B 69 0 363 725 ;\r\nC 106 ; WX 278 ; N j ; B -42 -214 363 725 ;\r\nC 107 ; WX 556 ; N k ; B 69 0 670 718 ;\r\nC 108 ; WX 278 ; N l ; B 69 0 362 718 ;\r\nC 109 ; WX 889 ; N m ; B 64 0 909 546 ;\r\nC 110 ; WX 611 ; N n ; B 65 0 629 546 ;\r\nC 111 ; WX 611 ; N o ; B 82 -14 643 546 ;\r\nC 112 ; WX 611 ; N p ; B 18 -207 645 546 ;\r\nC 113 ; WX 611 ; N q ; B 80 -207 665 546 ;\r\nC 114 ; WX 389 ; N r ; B 64 0 489 546 ;\r\nC 115 ; WX 556 ; N s ; B 63 -14 584 546 ;\r\nC 116 ; WX 333 ; N t ; B 100 -6 422 676 ;\r\nC 117 ; WX 611 ; N u ; B 98 -14 658 532 ;\r\nC 118 ; WX 556 ; N v ; B 126 0 656 532 ;\r\nC 119 ; WX 778 ; N w ; B 123 0 882 532 ;\r\nC 120 ; WX 556 ; N x ; B 15 0 648 532 ;\r\nC 121 ; WX 556 ; N y ; B 42 -214 652 532 ;\r\nC 122 ; WX 500 ; N z ; B 20 0 583 532 ;\r\nC 123 ; WX 389 ; N braceleft ; B 94 -196 518 722 ;\r\nC 124 ; WX 280 ; N bar ; B 36 -225 361 775 ;\r\nC 125 ; WX 389 ; N braceright ; B -18 -196 407 722 ;\r\nC 126 ; WX 584 ; N asciitilde ; B 115 163 577 343 ;\r\nC 161 ; WX 333 ; N exclamdown ; B 50 -186 353 532 ;\r\nC 162 ; WX 556 ; N cent ; B 79 -118 599 628 ;\r\nC 163 ; WX 556 ; N sterling ; B 50 -16 635 718 ;\r\nC 164 ; WX 167 ; N fraction ; B -174 -19 487 710 ;\r\nC 165 ; WX 556 ; N yen ; B 60 0 713 698 ;\r\nC 166 ; WX 556 ; N florin ; B -50 -210 669 737 ;\r\nC 167 ; WX 556 ; N section ; B 61 -184 598 727 ;\r\nC 168 ; WX 556 ; N currency ; B 27 76 680 636 ;\r\nC 169 ; WX 238 ; N quotesingle ; B 165 447 321 718 ;\r\nC 170 ; WX 500 ; N quotedblleft ; B 160 454 588 727 ;\r\nC 171 ; WX 556 ; N guillemotleft ; B 135 76 571 484 ;\r\nC 172 ; WX 333 ; N guilsinglleft ; B 130 76 353 484 ;\r\nC 173 ; WX 333 ; N guilsinglright ; B 99 76 322 484 ;\r\nC 174 ; WX 611 ; N fi ; B 87 0 696 727 ;\r\nC 175 ; WX 611 ; N fl ; B 87 0 695 727 ;\r\nC 177 ; WX 556 ; N endash ; B 48 227 627 333 ;\r\nC 178 ; WX 556 ; N dagger ; B 118 -171 626 718 ;\r\nC 179 ; WX 556 ; N daggerdbl ; B 46 -171 628 718 ;\r\nC 180 ; WX 278 ; N periodcentered ; B 110 172 276 334 ;\r\nC 182 ; WX 556 ; N paragraph ; B 98 -191 688 700 ;\r\nC 183 ; WX 350 ; N bullet ; B 83 194 420 524 ;\r\nC 184 ; WX 278 ; N quotesinglbase ; B 41 -146 236 127 ;\r\nC 185 ; WX 500 ; N quotedblbase ; B 36 -146 463 127 ;\r\nC 186 ; WX 500 ; N quotedblright ; B 162 445 589 718 ;\r\nC 187 ; WX 556 ; N guillemotright ; B 104 76 540 484 ;\r\nC 188 ; WX 1000 ; N ellipsis ; B 92 0 939 146 ;\r\nC 189 ; WX 1000 ; N perthousand ; B 76 -19 1038 710 ;\r\nC 191 ; WX 611 ; N questiondown ; B 53 -195 559 532 ;\r\nC 193 ; WX 333 ; N grave ; B 136 604 353 750 ;\r\nC 194 ; WX 333 ; N acute ; B 236 604 515 750 ;\r\nC 195 ; WX 333 ; N circumflex ; B 118 604 471 750 ;\r\nC 196 ; WX 333 ; N tilde ; B 113 610 507 737 ;\r\nC 197 ; WX 333 ; N macron ; B 122 604 483 678 ;\r\nC 198 ; WX 333 ; N breve ; B 156 604 494 750 ;\r\nC 199 ; WX 333 ; N dotaccent ; B 235 614 385 729 ;\r\nC 200 ; WX 333 ; N dieresis ; B 137 614 482 729 ;\r\nC 202 ; WX 333 ; N ring ; B 200 568 420 776 ;\r\nC 203 ; WX 333 ; N cedilla ; B -37 -228 220 0 ;\r\nC 205 ; WX 333 ; N hungarumlaut ; B 137 604 645 750 ;\r\nC 206 ; WX 333 ; N ogonek ; B 41 -228 264 0 ;\r\nC 207 ; WX 333 ; N caron ; B 149 604 502 750 ;\r\nC 208 ; WX 1000 ; N emdash ; B 48 227 1071 333 ;\r\nC 225 ; WX 1000 ; N AE ; B 5 0 1100 718 ;\r\nC 227 ; WX 370 ; N ordfeminine ; B 125 401 465 737 ;\r\nC 232 ; WX 611 ; N Lslash ; B 34 0 611 718 ;\r\nC 233 ; WX 778 ; N Oslash ; B 35 -27 894 745 ;\r\nC 234 ; WX 1000 ; N OE ; B 99 -19 1114 737 ;\r\nC 235 ; WX 365 ; N ordmasculine ; B 123 401 485 737 ;\r\nC 241 ; WX 889 ; N ae ; B 56 -14 923 546 ;\r\nC 245 ; WX 278 ; N dotlessi ; B 69 0 322 532 ;\r\nC 248 ; WX 278 ; N lslash ; B 40 0 407 718 ;\r\nC 249 ; WX 611 ; N oslash ; B 22 -29 701 560 ;\r\nC 250 ; WX 944 ; N oe ; B 82 -14 977 546 ;\r\nC 251 ; WX 611 ; N germandbls ; B 69 -14 657 731 ;\r\nC -1 ; WX 278 ; N Idieresis ; B 64 0 494 915 ;\r\nC -1 ; WX 556 ; N eacute ; B 70 -14 627 750 ;\r\nC -1 ; WX 556 ; N abreve ; B 55 -14 606 750 ;\r\nC -1 ; WX 611 ; N uhungarumlaut ; B 98 -14 784 750 ;\r\nC -1 ; WX 556 ; N ecaron ; B 70 -14 614 750 ;\r\nC -1 ; WX 667 ; N Ydieresis ; B 168 0 806 915 ;\r\nC -1 ; WX 584 ; N divide ; B 82 -42 610 548 ;\r\nC -1 ; WX 667 ; N Yacute ; B 168 0 806 936 ;\r\nC -1 ; WX 722 ; N Acircumflex ; B 20 0 706 936 ;\r\nC -1 ; WX 556 ; N aacute ; B 55 -14 627 750 ;\r\nC -1 ; WX 722 ; N Ucircumflex ; B 116 -19 804 936 ;\r\nC -1 ; WX 556 ; N yacute ; B 42 -214 652 750 ;\r\nC -1 ; WX 556 ; N scommaaccent ; B 63 -228 584 546 ;\r\nC -1 ; WX 556 ; N ecircumflex ; B 70 -14 593 750 ;\r\nC -1 ; WX 722 ; N Uring ; B 116 -19 804 962 ;\r\nC -1 ; WX 722 ; N Udieresis ; B 116 -19 804 915 ;\r\nC -1 ; WX 556 ; N aogonek ; B 55 -224 583 546 ;\r\nC -1 ; WX 722 ; N Uacute ; B 116 -19 804 936 ;\r\nC -1 ; WX 611 ; N uogonek ; B 98 -228 658 532 ;\r\nC -1 ; WX 667 ; N Edieresis ; B 76 0 757 915 ;\r\nC -1 ; WX 722 ; N Dcroat ; B 62 0 777 718 ;\r\nC -1 ; WX 250 ; N commaaccent ; B 16 -228 188 -50 ;\r\nC -1 ; WX 737 ; N copyright ; B 56 -19 835 737 ;\r\nC -1 ; WX 667 ; N Emacron ; B 76 0 757 864 ;\r\nC -1 ; WX 556 ; N ccaron ; B 79 -14 614 750 ;\r\nC -1 ; WX 556 ; N aring ; B 55 -14 583 776 ;\r\nC -1 ; WX 722 ; N Ncommaaccent ; B 69 -228 807 718 ;\r\nC -1 ; WX 278 ; N lacute ; B 69 0 528 936 ;\r\nC -1 ; WX 556 ; N agrave ; B 55 -14 583 750 ;\r\nC -1 ; WX 611 ; N Tcommaaccent ; B 140 -228 751 718 ;\r\nC -1 ; WX 722 ; N Cacute ; B 107 -19 789 936 ;\r\nC -1 ; WX 556 ; N atilde ; B 55 -14 619 737 ;\r\nC -1 ; WX 667 ; N Edotaccent ; B 76 0 757 915 ;\r\nC -1 ; WX 556 ; N scaron ; B 63 -14 614 750 ;\r\nC -1 ; WX 556 ; N scedilla ; B 63 -228 584 546 ;\r\nC -1 ; WX 278 ; N iacute ; B 69 0 488 750 ;\r\nC -1 ; WX 494 ; N lozenge ; B 90 0 564 745 ;\r\nC -1 ; WX 722 ; N Rcaron ; B 76 0 778 936 ;\r\nC -1 ; WX 778 ; N Gcommaaccent ; B 108 -228 817 737 ;\r\nC -1 ; WX 611 ; N ucircumflex ; B 98 -14 658 750 ;\r\nC -1 ; WX 556 ; N acircumflex ; B 55 -14 583 750 ;\r\nC -1 ; WX 722 ; N Amacron ; B 20 0 718 864 ;\r\nC -1 ; WX 389 ; N rcaron ; B 64 0 530 750 ;\r\nC -1 ; WX 556 ; N ccedilla ; B 79 -228 599 546 ;\r\nC -1 ; WX 611 ; N Zdotaccent ; B 25 0 737 915 ;\r\nC -1 ; WX 667 ; N Thorn ; B 76 0 716 718 ;\r\nC -1 ; WX 778 ; N Omacron ; B 107 -19 823 864 ;\r\nC -1 ; WX 722 ; N Racute ; B 76 0 778 936 ;\r\nC -1 ; WX 667 ; N Sacute ; B 81 -19 722 936 ;\r\nC -1 ; WX 743 ; N dcaron ; B 82 -14 903 718 ;\r\nC -1 ; WX 722 ; N Umacron ; B 116 -19 804 864 ;\r\nC -1 ; WX 611 ; N uring ; B 98 -14 658 776 ;\r\nC -1 ; WX 333 ; N threesuperior ; B 91 271 441 710 ;\r\nC -1 ; WX 778 ; N Ograve ; B 107 -19 823 936 ;\r\nC -1 ; WX 722 ; N Agrave ; B 20 0 702 936 ;\r\nC -1 ; WX 722 ; N Abreve ; B 20 0 729 936 ;\r\nC -1 ; WX 584 ; N multiply ; B 57 1 635 505 ;\r\nC -1 ; WX 611 ; N uacute ; B 98 -14 658 750 ;\r\nC -1 ; WX 611 ; N Tcaron ; B 140 0 751 936 ;\r\nC -1 ; WX 494 ; N partialdiff ; B 43 -21 585 750 ;\r\nC -1 ; WX 556 ; N ydieresis ; B 42 -214 652 729 ;\r\nC -1 ; WX 722 ; N Nacute ; B 69 0 807 936 ;\r\nC -1 ; WX 278 ; N icircumflex ; B 69 0 444 750 ;\r\nC -1 ; WX 667 ; N Ecircumflex ; B 76 0 757 936 ;\r\nC -1 ; WX 556 ; N adieresis ; B 55 -14 594 729 ;\r\nC -1 ; WX 556 ; N edieresis ; B 70 -14 594 729 ;\r\nC -1 ; WX 556 ; N cacute ; B 79 -14 627 750 ;\r\nC -1 ; WX 611 ; N nacute ; B 65 0 654 750 ;\r\nC -1 ; WX 611 ; N umacron ; B 98 -14 658 678 ;\r\nC -1 ; WX 722 ; N Ncaron ; B 69 0 807 936 ;\r\nC -1 ; WX 278 ; N Iacute ; B 64 0 528 936 ;\r\nC -1 ; WX 584 ; N plusminus ; B 40 0 625 506 ;\r\nC -1 ; WX 280 ; N brokenbar ; B 52 -150 345 700 ;\r\nC -1 ; WX 737 ; N registered ; B 55 -19 834 737 ;\r\nC -1 ; WX 778 ; N Gbreve ; B 108 -19 817 936 ;\r\nC -1 ; WX 278 ; N Idotaccent ; B 64 0 397 915 ;\r\nC -1 ; WX 600 ; N summation ; B 14 -10 670 706 ;\r\nC -1 ; WX 667 ; N Egrave ; B 76 0 757 936 ;\r\nC -1 ; WX 389 ; N racute ; B 64 0 543 750 ;\r\nC -1 ; WX 611 ; N omacron ; B 82 -14 643 678 ;\r\nC -1 ; WX 611 ; N Zacute ; B 25 0 737 936 ;\r\nC -1 ; WX 611 ; N Zcaron ; B 25 0 737 936 ;\r\nC -1 ; WX 549 ; N greaterequal ; B 26 0 629 704 ;\r\nC -1 ; WX 722 ; N Eth ; B 62 0 777 718 ;\r\nC -1 ; WX 722 ; N Ccedilla ; B 107 -228 789 737 ;\r\nC -1 ; WX 278 ; N lcommaaccent ; B 30 -228 362 718 ;\r\nC -1 ; WX 389 ; N tcaron ; B 100 -6 608 878 ;\r\nC -1 ; WX 556 ; N eogonek ; B 70 -228 593 546 ;\r\nC -1 ; WX 722 ; N Uogonek ; B 116 -228 804 718 ;\r\nC -1 ; WX 722 ; N Aacute ; B 20 0 750 936 ;\r\nC -1 ; WX 722 ; N Adieresis ; B 20 0 716 915 ;\r\nC -1 ; WX 556 ; N egrave ; B 70 -14 593 750 ;\r\nC -1 ; WX 500 ; N zacute ; B 20 0 599 750 ;\r\nC -1 ; WX 278 ; N iogonek ; B -14 -224 363 725 ;\r\nC -1 ; WX 778 ; N Oacute ; B 107 -19 823 936 ;\r\nC -1 ; WX 611 ; N oacute ; B 82 -14 654 750 ;\r\nC -1 ; WX 556 ; N amacron ; B 55 -14 595 678 ;\r\nC -1 ; WX 556 ; N sacute ; B 63 -14 627 750 ;\r\nC -1 ; WX 278 ; N idieresis ; B 69 0 455 729 ;\r\nC -1 ; WX 778 ; N Ocircumflex ; B 107 -19 823 936 ;\r\nC -1 ; WX 722 ; N Ugrave ; B 116 -19 804 936 ;\r\nC -1 ; WX 612 ; N Delta ; B 6 0 608 688 ;\r\nC -1 ; WX 611 ; N thorn ; B 18 -208 645 718 ;\r\nC -1 ; WX 333 ; N twosuperior ; B 69 283 449 710 ;\r\nC -1 ; WX 778 ; N Odieresis ; B 107 -19 823 915 ;\r\nC -1 ; WX 611 ; N mu ; B 22 -207 658 532 ;\r\nC -1 ; WX 278 ; N igrave ; B 69 0 326 750 ;\r\nC -1 ; WX 611 ; N ohungarumlaut ; B 82 -14 784 750 ;\r\nC -1 ; WX 667 ; N Eogonek ; B 76 -224 757 718 ;\r\nC -1 ; WX 611 ; N dcroat ; B 82 -14 789 718 ;\r\nC -1 ; WX 834 ; N threequarters ; B 99 -19 839 710 ;\r\nC -1 ; WX 667 ; N Scedilla ; B 81 -228 718 737 ;\r\nC -1 ; WX 400 ; N lcaron ; B 69 0 561 718 ;\r\nC -1 ; WX 722 ; N Kcommaaccent ; B 87 -228 858 718 ;\r\nC -1 ; WX 611 ; N Lacute ; B 76 0 611 936 ;\r\nC -1 ; WX 1000 ; N trademark ; B 179 306 1109 718 ;\r\nC -1 ; WX 556 ; N edotaccent ; B 70 -14 593 729 ;\r\nC -1 ; WX 278 ; N Igrave ; B 64 0 367 936 ;\r\nC -1 ; WX 278 ; N Imacron ; B 64 0 496 864 ;\r\nC -1 ; WX 611 ; N Lcaron ; B 76 0 643 718 ;\r\nC -1 ; WX 834 ; N onehalf ; B 132 -19 858 710 ;\r\nC -1 ; WX 549 ; N lessequal ; B 29 0 676 704 ;\r\nC -1 ; WX 611 ; N ocircumflex ; B 82 -14 643 750 ;\r\nC -1 ; WX 611 ; N ntilde ; B 65 0 646 737 ;\r\nC -1 ; WX 722 ; N Uhungarumlaut ; B 116 -19 880 936 ;\r\nC -1 ; WX 667 ; N Eacute ; B 76 0 757 936 ;\r\nC -1 ; WX 556 ; N emacron ; B 70 -14 595 678 ;\r\nC -1 ; WX 611 ; N gbreve ; B 38 -217 666 750 ;\r\nC -1 ; WX 834 ; N onequarter ; B 132 -19 806 710 ;\r\nC -1 ; WX 667 ; N Scaron ; B 81 -19 718 936 ;\r\nC -1 ; WX 667 ; N Scommaaccent ; B 81 -228 718 737 ;\r\nC -1 ; WX 778 ; N Ohungarumlaut ; B 107 -19 908 936 ;\r\nC -1 ; WX 400 ; N degree ; B 175 426 467 712 ;\r\nC -1 ; WX 611 ; N ograve ; B 82 -14 643 750 ;\r\nC -1 ; WX 722 ; N Ccaron ; B 107 -19 789 936 ;\r\nC -1 ; WX 611 ; N ugrave ; B 98 -14 658 750 ;\r\nC -1 ; WX 549 ; N radical ; B 112 -46 689 850 ;\r\nC -1 ; WX 722 ; N Dcaron ; B 76 0 777 936 ;\r\nC -1 ; WX 389 ; N rcommaaccent ; B 26 -228 489 546 ;\r\nC -1 ; WX 722 ; N Ntilde ; B 69 0 807 923 ;\r\nC -1 ; WX 611 ; N otilde ; B 82 -14 646 737 ;\r\nC -1 ; WX 722 ; N Rcommaaccent ; B 76 -228 778 718 ;\r\nC -1 ; WX 611 ; N Lcommaaccent ; B 76 -228 611 718 ;\r\nC -1 ; WX 722 ; N Atilde ; B 20 0 741 923 ;\r\nC -1 ; WX 722 ; N Aogonek ; B 20 -224 702 718 ;\r\nC -1 ; WX 722 ; N Aring ; B 20 0 702 962 ;\r\nC -1 ; WX 778 ; N Otilde ; B 107 -19 823 923 ;\r\nC -1 ; WX 500 ; N zdotaccent ; B 20 0 583 729 ;\r\nC -1 ; WX 667 ; N Ecaron ; B 76 0 757 936 ;\r\nC -1 ; WX 278 ; N Iogonek ; B -41 -228 367 718 ;\r\nC -1 ; WX 556 ; N kcommaaccent ; B 69 -228 670 718 ;\r\nC -1 ; WX 584 ; N minus ; B 82 197 610 309 ;\r\nC -1 ; WX 278 ; N Icircumflex ; B 64 0 484 936 ;\r\nC -1 ; WX 611 ; N ncaron ; B 65 0 641 750 ;\r\nC -1 ; WX 333 ; N tcommaaccent ; B 58 -228 422 676 ;\r\nC -1 ; WX 584 ; N logicalnot ; B 105 108 633 419 ;\r\nC -1 ; WX 611 ; N odieresis ; B 82 -14 643 729 ;\r\nC -1 ; WX 611 ; N udieresis ; B 98 -14 658 729 ;\r\nC -1 ; WX 549 ; N notequal ; B 32 -49 630 570 ;\r\nC -1 ; WX 611 ; N gcommaaccent ; B 38 -217 666 850 ;\r\nC -1 ; WX 611 ; N eth ; B 82 -14 670 737 ;\r\nC -1 ; WX 500 ; N zcaron ; B 20 0 586 750 ;\r\nC -1 ; WX 611 ; N ncommaaccent ; B 65 -228 629 546 ;\r\nC -1 ; WX 333 ; N onesuperior ; B 148 283 388 710 ;\r\nC -1 ; WX 278 ; N imacron ; B 69 0 429 678 ;\r\nC -1 ; WX 556 ; N Euro ; B 0 0 0 0 ;\r\nEndCharMetrics\r\nStartKernData\r\nStartKernPairs 2481\r\nKPX A C -40\r\nKPX A Cacute -40\r\nKPX A Ccaron -40\r\nKPX A Ccedilla -40\r\nKPX A G -50\r\nKPX A Gbreve -50\r\nKPX A Gcommaaccent -50\r\nKPX A O -40\r\nKPX A Oacute -40\r\nKPX A Ocircumflex -40\r\nKPX A Odieresis -40\r\nKPX A Ograve -40\r\nKPX A Ohungarumlaut -40\r\nKPX A Omacron -40\r\nKPX A Oslash -40\r\nKPX A Otilde -40\r\nKPX A Q -40\r\nKPX A T -90\r\nKPX A Tcaron -90\r\nKPX A Tcommaaccent -90\r\nKPX A U -50\r\nKPX A Uacute -50\r\nKPX A Ucircumflex -50\r\nKPX A Udieresis -50\r\nKPX A Ugrave -50\r\nKPX A Uhungarumlaut -50\r\nKPX A Umacron -50\r\nKPX A Uogonek -50\r\nKPX A Uring -50\r\nKPX A V -80\r\nKPX A W -60\r\nKPX A Y -110\r\nKPX A Yacute -110\r\nKPX A Ydieresis -110\r\nKPX A u -30\r\nKPX A uacute -30\r\nKPX A ucircumflex -30\r\nKPX A udieresis -30\r\nKPX A ugrave -30\r\nKPX A uhungarumlaut -30\r\nKPX A umacron -30\r\nKPX A uogonek -30\r\nKPX A uring -30\r\nKPX A v -40\r\nKPX A w -30\r\nKPX A y -30\r\nKPX A yacute -30\r\nKPX A ydieresis -30\r\nKPX Aacute C -40\r\nKPX Aacute Cacute -40\r\nKPX Aacute Ccaron -40\r\nKPX Aacute Ccedilla -40\r\nKPX Aacute G -50\r\nKPX Aacute Gbreve -50\r\nKPX Aacute Gcommaaccent -50\r\nKPX Aacute O -40\r\nKPX Aacute Oacute -40\r\nKPX Aacute Ocircumflex -40\r\nKPX Aacute Odieresis -40\r\nKPX Aacute Ograve -40\r\nKPX Aacute Ohungarumlaut -40\r\nKPX Aacute Omacron -40\r\nKPX Aacute Oslash -40\r\nKPX Aacute Otilde -40\r\nKPX Aacute Q -40\r\nKPX Aacute T -90\r\nKPX Aacute Tcaron -90\r\nKPX Aacute Tcommaaccent -90\r\nKPX Aacute U -50\r\nKPX Aacute Uacute -50\r\nKPX Aacute Ucircumflex -50\r\nKPX Aacute Udieresis -50\r\nKPX Aacute Ugrave -50\r\nKPX Aacute Uhungarumlaut -50\r\nKPX Aacute Umacron -50\r\nKPX Aacute Uogonek -50\r\nKPX Aacute Uring -50\r\nKPX Aacute V -80\r\nKPX Aacute W -60\r\nKPX Aacute Y -110\r\nKPX Aacute Yacute -110\r\nKPX Aacute Ydieresis -110\r\nKPX Aacute u -30\r\nKPX Aacute uacute -30\r\nKPX Aacute ucircumflex -30\r\nKPX Aacute udieresis -30\r\nKPX Aacute ugrave -30\r\nKPX Aacute uhungarumlaut -30\r\nKPX Aacute umacron -30\r\nKPX Aacute uogonek -30\r\nKPX Aacute uring -30\r\nKPX Aacute v -40\r\nKPX Aacute w -30\r\nKPX Aacute y -30\r\nKPX Aacute yacute -30\r\nKPX Aacute ydieresis -30\r\nKPX Abreve C -40\r\nKPX Abreve Cacute -40\r\nKPX Abreve Ccaron -40\r\nKPX Abreve Ccedilla -40\r\nKPX Abreve G -50\r\nKPX Abreve Gbreve -50\r\nKPX Abreve Gcommaaccent -50\r\nKPX Abreve O -40\r\nKPX Abreve Oacute -40\r\nKPX Abreve Ocircumflex -40\r\nKPX Abreve Odieresis -40\r\nKPX Abreve Ograve -40\r\nKPX Abreve Ohungarumlaut -40\r\nKPX Abreve Omacron -40\r\nKPX Abreve Oslash -40\r\nKPX Abreve Otilde -40\r\nKPX Abreve Q -40\r\nKPX Abreve T -90\r\nKPX Abreve Tcaron -90\r\nKPX Abreve Tcommaaccent -90\r\nKPX Abreve U -50\r\nKPX Abreve Uacute -50\r\nKPX Abreve Ucircumflex -50\r\nKPX Abreve Udieresis -50\r\nKPX Abreve Ugrave -50\r\nKPX Abreve Uhungarumlaut -50\r\nKPX Abreve Umacron -50\r\nKPX Abreve Uogonek -50\r\nKPX Abreve Uring -50\r\nKPX Abreve V -80\r\nKPX Abreve W -60\r\nKPX Abreve Y -110\r\nKPX Abreve Yacute -110\r\nKPX Abreve Ydieresis -110\r\nKPX Abreve u -30\r\nKPX Abreve uacute -30\r\nKPX Abreve ucircumflex -30\r\nKPX Abreve udieresis -30\r\nKPX Abreve ugrave -30\r\nKPX Abreve uhungarumlaut -30\r\nKPX Abreve umacron -30\r\nKPX Abreve uogonek -30\r\nKPX Abreve uring -30\r\nKPX Abreve v -40\r\nKPX Abreve w -30\r\nKPX Abreve y -30\r\nKPX Abreve yacute -30\r\nKPX Abreve ydieresis -30\r\nKPX Acircumflex C -40\r\nKPX Acircumflex Cacute -40\r\nKPX Acircumflex Ccaron -40\r\nKPX Acircumflex Ccedilla -40\r\nKPX Acircumflex G -50\r\nKPX Acircumflex Gbreve -50\r\nKPX Acircumflex Gcommaaccent -50\r\nKPX Acircumflex O -40\r\nKPX Acircumflex Oacute -40\r\nKPX Acircumflex Ocircumflex -40\r\nKPX Acircumflex Odieresis -40\r\nKPX Acircumflex Ograve -40\r\nKPX Acircumflex Ohungarumlaut -40\r\nKPX Acircumflex Omacron -40\r\nKPX Acircumflex Oslash -40\r\nKPX Acircumflex Otilde -40\r\nKPX Acircumflex Q -40\r\nKPX Acircumflex T -90\r\nKPX Acircumflex Tcaron -90\r\nKPX Acircumflex Tcommaaccent -90\r\nKPX Acircumflex U -50\r\nKPX Acircumflex Uacute -50\r\nKPX Acircumflex Ucircumflex -50\r\nKPX Acircumflex Udieresis -50\r\nKPX Acircumflex Ugrave -50\r\nKPX Acircumflex Uhungarumlaut -50\r\nKPX Acircumflex Umacron -50\r\nKPX Acircumflex Uogonek -50\r\nKPX Acircumflex Uring -50\r\nKPX Acircumflex V -80\r\nKPX Acircumflex W -60\r\nKPX Acircumflex Y -110\r\nKPX Acircumflex Yacute -110\r\nKPX Acircumflex Ydieresis -110\r\nKPX Acircumflex u -30\r\nKPX Acircumflex uacute -30\r\nKPX Acircumflex ucircumflex -30\r\nKPX Acircumflex udieresis -30\r\nKPX Acircumflex ugrave -30\r\nKPX Acircumflex uhungarumlaut -30\r\nKPX Acircumflex umacron -30\r\nKPX Acircumflex uogonek -30\r\nKPX Acircumflex uring -30\r\nKPX Acircumflex v -40\r\nKPX Acircumflex w -30\r\nKPX Acircumflex y -30\r\nKPX Acircumflex yacute -30\r\nKPX Acircumflex ydieresis -30\r\nKPX Adieresis C -40\r\nKPX Adieresis Cacute -40\r\nKPX Adieresis Ccaron -40\r\nKPX Adieresis Ccedilla -40\r\nKPX Adieresis G -50\r\nKPX Adieresis Gbreve -50\r\nKPX Adieresis Gcommaaccent -50\r\nKPX Adieresis O -40\r\nKPX Adieresis Oacute -40\r\nKPX Adieresis Ocircumflex -40\r\nKPX Adieresis Odieresis -40\r\nKPX Adieresis Ograve -40\r\nKPX Adieresis Ohungarumlaut -40\r\nKPX Adieresis Omacron -40\r\nKPX Adieresis Oslash -40\r\nKPX Adieresis Otilde -40\r\nKPX Adieresis Q -40\r\nKPX Adieresis T -90\r\nKPX Adieresis Tcaron -90\r\nKPX Adieresis Tcommaaccent -90\r\nKPX Adieresis U -50\r\nKPX Adieresis Uacute -50\r\nKPX Adieresis Ucircumflex -50\r\nKPX Adieresis Udieresis -50\r\nKPX Adieresis Ugrave -50\r\nKPX Adieresis Uhungarumlaut -50\r\nKPX Adieresis Umacron -50\r\nKPX Adieresis Uogonek -50\r\nKPX Adieresis Uring -50\r\nKPX Adieresis V -80\r\nKPX Adieresis W -60\r\nKPX Adieresis Y -110\r\nKPX Adieresis Yacute -110\r\nKPX Adieresis Ydieresis -110\r\nKPX Adieresis u -30\r\nKPX Adieresis uacute -30\r\nKPX Adieresis ucircumflex -30\r\nKPX Adieresis udieresis -30\r\nKPX Adieresis ugrave -30\r\nKPX Adieresis uhungarumlaut -30\r\nKPX Adieresis umacron -30\r\nKPX Adieresis uogonek -30\r\nKPX Adieresis uring -30\r\nKPX Adieresis v -40\r\nKPX Adieresis w -30\r\nKPX Adieresis y -30\r\nKPX Adieresis yacute -30\r\nKPX Adieresis ydieresis -30\r\nKPX Agrave C -40\r\nKPX Agrave Cacute -40\r\nKPX Agrave Ccaron -40\r\nKPX Agrave Ccedilla -40\r\nKPX Agrave G -50\r\nKPX Agrave Gbreve -50\r\nKPX Agrave Gcommaaccent -50\r\nKPX Agrave O -40\r\nKPX Agrave Oacute -40\r\nKPX Agrave Ocircumflex -40\r\nKPX Agrave Odieresis -40\r\nKPX Agrave Ograve -40\r\nKPX Agrave Ohungarumlaut -40\r\nKPX Agrave Omacron -40\r\nKPX Agrave Oslash -40\r\nKPX Agrave Otilde -40\r\nKPX Agrave Q -40\r\nKPX Agrave T -90\r\nKPX Agrave Tcaron -90\r\nKPX Agrave Tcommaaccent -90\r\nKPX Agrave U -50\r\nKPX Agrave Uacute -50\r\nKPX Agrave Ucircumflex -50\r\nKPX Agrave Udieresis -50\r\nKPX Agrave Ugrave -50\r\nKPX Agrave Uhungarumlaut -50\r\nKPX Agrave Umacron -50\r\nKPX Agrave Uogonek -50\r\nKPX Agrave Uring -50\r\nKPX Agrave V -80\r\nKPX Agrave W -60\r\nKPX Agrave Y -110\r\nKPX Agrave Yacute -110\r\nKPX Agrave Ydieresis -110\r\nKPX Agrave u -30\r\nKPX Agrave uacute -30\r\nKPX Agrave ucircumflex -30\r\nKPX Agrave udieresis -30\r\nKPX Agrave ugrave -30\r\nKPX Agrave uhungarumlaut -30\r\nKPX Agrave umacron -30\r\nKPX Agrave uogonek -30\r\nKPX Agrave uring -30\r\nKPX Agrave v -40\r\nKPX Agrave w -30\r\nKPX Agrave y -30\r\nKPX Agrave yacute -30\r\nKPX Agrave ydieresis -30\r\nKPX Amacron C -40\r\nKPX Amacron Cacute -40\r\nKPX Amacron Ccaron -40\r\nKPX Amacron Ccedilla -40\r\nKPX Amacron G -50\r\nKPX Amacron Gbreve -50\r\nKPX Amacron Gcommaaccent -50\r\nKPX Amacron O -40\r\nKPX Amacron Oacute -40\r\nKPX Amacron Ocircumflex -40\r\nKPX Amacron Odieresis -40\r\nKPX Amacron Ograve -40\r\nKPX Amacron Ohungarumlaut -40\r\nKPX Amacron Omacron -40\r\nKPX Amacron Oslash -40\r\nKPX Amacron Otilde -40\r\nKPX Amacron Q -40\r\nKPX Amacron T -90\r\nKPX Amacron Tcaron -90\r\nKPX Amacron Tcommaaccent -90\r\nKPX Amacron U -50\r\nKPX Amacron Uacute -50\r\nKPX Amacron Ucircumflex -50\r\nKPX Amacron Udieresis -50\r\nKPX Amacron Ugrave -50\r\nKPX Amacron Uhungarumlaut -50\r\nKPX Amacron Umacron -50\r\nKPX Amacron Uogonek -50\r\nKPX Amacron Uring -50\r\nKPX Amacron V -80\r\nKPX Amacron W -60\r\nKPX Amacron Y -110\r\nKPX Amacron Yacute -110\r\nKPX Amacron Ydieresis -110\r\nKPX Amacron u -30\r\nKPX Amacron uacute -30\r\nKPX Amacron ucircumflex -30\r\nKPX Amacron udieresis -30\r\nKPX Amacron ugrave -30\r\nKPX Amacron uhungarumlaut -30\r\nKPX Amacron umacron -30\r\nKPX Amacron uogonek -30\r\nKPX Amacron uring -30\r\nKPX Amacron v -40\r\nKPX Amacron w -30\r\nKPX Amacron y -30\r\nKPX Amacron yacute -30\r\nKPX Amacron ydieresis -30\r\nKPX Aogonek C -40\r\nKPX Aogonek Cacute -40\r\nKPX Aogonek Ccaron -40\r\nKPX Aogonek Ccedilla -40\r\nKPX Aogonek G -50\r\nKPX Aogonek Gbreve -50\r\nKPX Aogonek Gcommaaccent -50\r\nKPX Aogonek O -40\r\nKPX Aogonek Oacute -40\r\nKPX Aogonek Ocircumflex -40\r\nKPX Aogonek Odieresis -40\r\nKPX Aogonek Ograve -40\r\nKPX Aogonek Ohungarumlaut -40\r\nKPX Aogonek Omacron -40\r\nKPX Aogonek Oslash -40\r\nKPX Aogonek Otilde -40\r\nKPX Aogonek Q -40\r\nKPX Aogonek T -90\r\nKPX Aogonek Tcaron -90\r\nKPX Aogonek Tcommaaccent -90\r\nKPX Aogonek U -50\r\nKPX Aogonek Uacute -50\r\nKPX Aogonek Ucircumflex -50\r\nKPX Aogonek Udieresis -50\r\nKPX Aogonek Ugrave -50\r\nKPX Aogonek Uhungarumlaut -50\r\nKPX Aogonek Umacron -50\r\nKPX Aogonek Uogonek -50\r\nKPX Aogonek Uring -50\r\nKPX Aogonek V -80\r\nKPX Aogonek W -60\r\nKPX Aogonek Y -110\r\nKPX Aogonek Yacute -110\r\nKPX Aogonek Ydieresis -110\r\nKPX Aogonek u -30\r\nKPX Aogonek uacute -30\r\nKPX Aogonek ucircumflex -30\r\nKPX Aogonek udieresis -30\r\nKPX Aogonek ugrave -30\r\nKPX Aogonek uhungarumlaut -30\r\nKPX Aogonek umacron -30\r\nKPX Aogonek uogonek -30\r\nKPX Aogonek uring -30\r\nKPX Aogonek v -40\r\nKPX Aogonek w -30\r\nKPX Aogonek y -30\r\nKPX Aogonek yacute -30\r\nKPX Aogonek ydieresis -30\r\nKPX Aring C -40\r\nKPX Aring Cacute -40\r\nKPX Aring Ccaron -40\r\nKPX Aring Ccedilla -40\r\nKPX Aring G -50\r\nKPX Aring Gbreve -50\r\nKPX Aring Gcommaaccent -50\r\nKPX Aring O -40\r\nKPX Aring Oacute -40\r\nKPX Aring Ocircumflex -40\r\nKPX Aring Odieresis -40\r\nKPX Aring Ograve -40\r\nKPX Aring Ohungarumlaut -40\r\nKPX Aring Omacron -40\r\nKPX Aring Oslash -40\r\nKPX Aring Otilde -40\r\nKPX Aring Q -40\r\nKPX Aring T -90\r\nKPX Aring Tcaron -90\r\nKPX Aring Tcommaaccent -90\r\nKPX Aring U -50\r\nKPX Aring Uacute -50\r\nKPX Aring Ucircumflex -50\r\nKPX Aring Udieresis -50\r\nKPX Aring Ugrave -50\r\nKPX Aring Uhungarumlaut -50\r\nKPX Aring Umacron -50\r\nKPX Aring Uogonek -50\r\nKPX Aring Uring -50\r\nKPX Aring V -80\r\nKPX Aring W -60\r\nKPX Aring Y -110\r\nKPX Aring Yacute -110\r\nKPX Aring Ydieresis -110\r\nKPX Aring u -30\r\nKPX Aring uacute -30\r\nKPX Aring ucircumflex -30\r\nKPX Aring udieresis -30\r\nKPX Aring ugrave -30\r\nKPX Aring uhungarumlaut -30\r\nKPX Aring umacron -30\r\nKPX Aring uogonek -30\r\nKPX Aring uring -30\r\nKPX Aring v -40\r\nKPX Aring w -30\r\nKPX Aring y -30\r\nKPX Aring yacute -30\r\nKPX Aring ydieresis -30\r\nKPX Atilde C -40\r\nKPX Atilde Cacute -40\r\nKPX Atilde Ccaron -40\r\nKPX Atilde Ccedilla -40\r\nKPX Atilde G -50\r\nKPX Atilde Gbreve -50\r\nKPX Atilde Gcommaaccent -50\r\nKPX Atilde O -40\r\nKPX Atilde Oacute -40\r\nKPX Atilde Ocircumflex -40\r\nKPX Atilde Odieresis -40\r\nKPX Atilde Ograve -40\r\nKPX Atilde Ohungarumlaut -40\r\nKPX Atilde Omacron -40\r\nKPX Atilde Oslash -40\r\nKPX Atilde Otilde -40\r\nKPX Atilde Q -40\r\nKPX Atilde T -90\r\nKPX Atilde Tcaron -90\r\nKPX Atilde Tcommaaccent -90\r\nKPX Atilde U -50\r\nKPX Atilde Uacute -50\r\nKPX Atilde Ucircumflex -50\r\nKPX Atilde Udieresis -50\r\nKPX Atilde Ugrave -50\r\nKPX Atilde Uhungarumlaut -50\r\nKPX Atilde Umacron -50\r\nKPX Atilde Uogonek -50\r\nKPX Atilde Uring -50\r\nKPX Atilde V -80\r\nKPX Atilde W -60\r\nKPX Atilde Y -110\r\nKPX Atilde Yacute -110\r\nKPX Atilde Ydieresis -110\r\nKPX Atilde u -30\r\nKPX Atilde uacute -30\r\nKPX Atilde ucircumflex -30\r\nKPX Atilde udieresis -30\r\nKPX Atilde ugrave -30\r\nKPX Atilde uhungarumlaut -30\r\nKPX Atilde umacron -30\r\nKPX Atilde uogonek -30\r\nKPX Atilde uring -30\r\nKPX Atilde v -40\r\nKPX Atilde w -30\r\nKPX Atilde y -30\r\nKPX Atilde yacute -30\r\nKPX Atilde ydieresis -30\r\nKPX B A -30\r\nKPX B Aacute -30\r\nKPX B Abreve -30\r\nKPX B Acircumflex -30\r\nKPX B Adieresis -30\r\nKPX B Agrave -30\r\nKPX B Amacron -30\r\nKPX B Aogonek -30\r\nKPX B Aring -30\r\nKPX B Atilde -30\r\nKPX B U -10\r\nKPX B Uacute -10\r\nKPX B Ucircumflex -10\r\nKPX B Udieresis -10\r\nKPX B Ugrave -10\r\nKPX B Uhungarumlaut -10\r\nKPX B Umacron -10\r\nKPX B Uogonek -10\r\nKPX B Uring -10\r\nKPX D A -40\r\nKPX D Aacute -40\r\nKPX D Abreve -40\r\nKPX D Acircumflex -40\r\nKPX D Adieresis -40\r\nKPX D Agrave -40\r\nKPX D Amacron -40\r\nKPX D Aogonek -40\r\nKPX D Aring -40\r\nKPX D Atilde -40\r\nKPX D V -40\r\nKPX D W -40\r\nKPX D Y -70\r\nKPX D Yacute -70\r\nKPX D Ydieresis -70\r\nKPX D comma -30\r\nKPX D period -30\r\nKPX Dcaron A -40\r\nKPX Dcaron Aacute -40\r\nKPX Dcaron Abreve -40\r\nKPX Dcaron Acircumflex -40\r\nKPX Dcaron Adieresis -40\r\nKPX Dcaron Agrave -40\r\nKPX Dcaron Amacron -40\r\nKPX Dcaron Aogonek -40\r\nKPX Dcaron Aring -40\r\nKPX Dcaron Atilde -40\r\nKPX Dcaron V -40\r\nKPX Dcaron W -40\r\nKPX Dcaron Y -70\r\nKPX Dcaron Yacute -70\r\nKPX Dcaron Ydieresis -70\r\nKPX Dcaron comma -30\r\nKPX Dcaron period -30\r\nKPX Dcroat A -40\r\nKPX Dcroat Aacute -40\r\nKPX Dcroat Abreve -40\r\nKPX Dcroat Acircumflex -40\r\nKPX Dcroat Adieresis -40\r\nKPX Dcroat Agrave -40\r\nKPX Dcroat Amacron -40\r\nKPX Dcroat Aogonek -40\r\nKPX Dcroat Aring -40\r\nKPX Dcroat Atilde -40\r\nKPX Dcroat V -40\r\nKPX Dcroat W -40\r\nKPX Dcroat Y -70\r\nKPX Dcroat Yacute -70\r\nKPX Dcroat Ydieresis -70\r\nKPX Dcroat comma -30\r\nKPX Dcroat period -30\r\nKPX F A -80\r\nKPX F Aacute -80\r\nKPX F Abreve -80\r\nKPX F Acircumflex -80\r\nKPX F Adieresis -80\r\nKPX F Agrave -80\r\nKPX F Amacron -80\r\nKPX F Aogonek -80\r\nKPX F Aring -80\r\nKPX F Atilde -80\r\nKPX F a -20\r\nKPX F aacute -20\r\nKPX F abreve -20\r\nKPX F acircumflex -20\r\nKPX F adieresis -20\r\nKPX F agrave -20\r\nKPX F amacron -20\r\nKPX F aogonek -20\r\nKPX F aring -20\r\nKPX F atilde -20\r\nKPX F comma -100\r\nKPX F period -100\r\nKPX J A -20\r\nKPX J Aacute -20\r\nKPX J Abreve -20\r\nKPX J Acircumflex -20\r\nKPX J Adieresis -20\r\nKPX J Agrave -20\r\nKPX J Amacron -20\r\nKPX J Aogonek -20\r\nKPX J Aring -20\r\nKPX J Atilde -20\r\nKPX J comma -20\r\nKPX J period -20\r\nKPX J u -20\r\nKPX J uacute -20\r\nKPX J ucircumflex -20\r\nKPX J udieresis -20\r\nKPX J ugrave -20\r\nKPX J uhungarumlaut -20\r\nKPX J umacron -20\r\nKPX J uogonek -20\r\nKPX J uring -20\r\nKPX K O -30\r\nKPX K Oacute -30\r\nKPX K Ocircumflex -30\r\nKPX K Odieresis -30\r\nKPX K Ograve -30\r\nKPX K Ohungarumlaut -30\r\nKPX K Omacron -30\r\nKPX K Oslash -30\r\nKPX K Otilde -30\r\nKPX K e -15\r\nKPX K eacute -15\r\nKPX K ecaron -15\r\nKPX K ecircumflex -15\r\nKPX K edieresis -15\r\nKPX K edotaccent -15\r\nKPX K egrave -15\r\nKPX K emacron -15\r\nKPX K eogonek -15\r\nKPX K o -35\r\nKPX K oacute -35\r\nKPX K ocircumflex -35\r\nKPX K odieresis -35\r\nKPX K ograve -35\r\nKPX K ohungarumlaut -35\r\nKPX K omacron -35\r\nKPX K oslash -35\r\nKPX K otilde -35\r\nKPX K u -30\r\nKPX K uacute -30\r\nKPX K ucircumflex -30\r\nKPX K udieresis -30\r\nKPX K ugrave -30\r\nKPX K uhungarumlaut -30\r\nKPX K umacron -30\r\nKPX K uogonek -30\r\nKPX K uring -30\r\nKPX K y -40\r\nKPX K yacute -40\r\nKPX K ydieresis -40\r\nKPX Kcommaaccent O -30\r\nKPX Kcommaaccent Oacute -30\r\nKPX Kcommaaccent Ocircumflex -30\r\nKPX Kcommaaccent Odieresis -30\r\nKPX Kcommaaccent Ograve -30\r\nKPX Kcommaaccent Ohungarumlaut -30\r\nKPX Kcommaaccent Omacron -30\r\nKPX Kcommaaccent Oslash -30\r\nKPX Kcommaaccent Otilde -30\r\nKPX Kcommaaccent e -15\r\nKPX Kcommaaccent eacute -15\r\nKPX Kcommaaccent ecaron -15\r\nKPX Kcommaaccent ecircumflex -15\r\nKPX Kcommaaccent edieresis -15\r\nKPX Kcommaaccent edotaccent -15\r\nKPX Kcommaaccent egrave -15\r\nKPX Kcommaaccent emacron -15\r\nKPX Kcommaaccent eogonek -15\r\nKPX Kcommaaccent o -35\r\nKPX Kcommaaccent oacute -35\r\nKPX Kcommaaccent ocircumflex -35\r\nKPX Kcommaaccent odieresis -35\r\nKPX Kcommaaccent ograve -35\r\nKPX Kcommaaccent ohungarumlaut -35\r\nKPX Kcommaaccent omacron -35\r\nKPX Kcommaaccent oslash -35\r\nKPX Kcommaaccent otilde -35\r\nKPX Kcommaaccent u -30\r\nKPX Kcommaaccent uacute -30\r\nKPX Kcommaaccent ucircumflex -30\r\nKPX Kcommaaccent udieresis -30\r\nKPX Kcommaaccent ugrave -30\r\nKPX Kcommaaccent uhungarumlaut -30\r\nKPX Kcommaaccent umacron -30\r\nKPX Kcommaaccent uogonek -30\r\nKPX Kcommaaccent uring -30\r\nKPX Kcommaaccent y -40\r\nKPX Kcommaaccent yacute -40\r\nKPX Kcommaaccent ydieresis -40\r\nKPX L T -90\r\nKPX L Tcaron -90\r\nKPX L Tcommaaccent -90\r\nKPX L V -110\r\nKPX L W -80\r\nKPX L Y -120\r\nKPX L Yacute -120\r\nKPX L Ydieresis -120\r\nKPX L quotedblright -140\r\nKPX L quoteright -140\r\nKPX L y -30\r\nKPX L yacute -30\r\nKPX L ydieresis -30\r\nKPX Lacute T -90\r\nKPX Lacute Tcaron -90\r\nKPX Lacute Tcommaaccent -90\r\nKPX Lacute V -110\r\nKPX Lacute W -80\r\nKPX Lacute Y -120\r\nKPX Lacute Yacute -120\r\nKPX Lacute Ydieresis -120\r\nKPX Lacute quotedblright -140\r\nKPX Lacute quoteright -140\r\nKPX Lacute y -30\r\nKPX Lacute yacute -30\r\nKPX Lacute ydieresis -30\r\nKPX Lcommaaccent T -90\r\nKPX Lcommaaccent Tcaron -90\r\nKPX Lcommaaccent Tcommaaccent -90\r\nKPX Lcommaaccent V -110\r\nKPX Lcommaaccent W -80\r\nKPX Lcommaaccent Y -120\r\nKPX Lcommaaccent Yacute -120\r\nKPX Lcommaaccent Ydieresis -120\r\nKPX Lcommaaccent quotedblright -140\r\nKPX Lcommaaccent quoteright -140\r\nKPX Lcommaaccent y -30\r\nKPX Lcommaaccent yacute -30\r\nKPX Lcommaaccent ydieresis -30\r\nKPX Lslash T -90\r\nKPX Lslash Tcaron -90\r\nKPX Lslash Tcommaaccent -90\r\nKPX Lslash V -110\r\nKPX Lslash W -80\r\nKPX Lslash Y -120\r\nKPX Lslash Yacute -120\r\nKPX Lslash Ydieresis -120\r\nKPX Lslash quotedblright -140\r\nKPX Lslash quoteright -140\r\nKPX Lslash y -30\r\nKPX Lslash yacute -30\r\nKPX Lslash ydieresis -30\r\nKPX O A -50\r\nKPX O Aacute -50\r\nKPX O Abreve -50\r\nKPX O Acircumflex -50\r\nKPX O Adieresis -50\r\nKPX O Agrave -50\r\nKPX O Amacron -50\r\nKPX O Aogonek -50\r\nKPX O Aring -50\r\nKPX O Atilde -50\r\nKPX O T -40\r\nKPX O Tcaron -40\r\nKPX O Tcommaaccent -40\r\nKPX O V -50\r\nKPX O W -50\r\nKPX O X -50\r\nKPX O Y -70\r\nKPX O Yacute -70\r\nKPX O Ydieresis -70\r\nKPX O comma -40\r\nKPX O period -40\r\nKPX Oacute A -50\r\nKPX Oacute Aacute -50\r\nKPX Oacute Abreve -50\r\nKPX Oacute Acircumflex -50\r\nKPX Oacute Adieresis -50\r\nKPX Oacute Agrave -50\r\nKPX Oacute Amacron -50\r\nKPX Oacute Aogonek -50\r\nKPX Oacute Aring -50\r\nKPX Oacute Atilde -50\r\nKPX Oacute T -40\r\nKPX Oacute Tcaron -40\r\nKPX Oacute Tcommaaccent -40\r\nKPX Oacute V -50\r\nKPX Oacute W -50\r\nKPX Oacute X -50\r\nKPX Oacute Y -70\r\nKPX Oacute Yacute -70\r\nKPX Oacute Ydieresis -70\r\nKPX Oacute comma -40\r\nKPX Oacute period -40\r\nKPX Ocircumflex A -50\r\nKPX Ocircumflex Aacute -50\r\nKPX Ocircumflex Abreve -50\r\nKPX Ocircumflex Acircumflex -50\r\nKPX Ocircumflex Adieresis -50\r\nKPX Ocircumflex Agrave -50\r\nKPX Ocircumflex Amacron -50\r\nKPX Ocircumflex Aogonek -50\r\nKPX Ocircumflex Aring -50\r\nKPX Ocircumflex Atilde -50\r\nKPX Ocircumflex T -40\r\nKPX Ocircumflex Tcaron -40\r\nKPX Ocircumflex Tcommaaccent -40\r\nKPX Ocircumflex V -50\r\nKPX Ocircumflex W -50\r\nKPX Ocircumflex X -50\r\nKPX Ocircumflex Y -70\r\nKPX Ocircumflex Yacute -70\r\nKPX Ocircumflex Ydieresis -70\r\nKPX Ocircumflex comma -40\r\nKPX Ocircumflex period -40\r\nKPX Odieresis A -50\r\nKPX Odieresis Aacute -50\r\nKPX Odieresis Abreve -50\r\nKPX Odieresis Acircumflex -50\r\nKPX Odieresis Adieresis -50\r\nKPX Odieresis Agrave -50\r\nKPX Odieresis Amacron -50\r\nKPX Odieresis Aogonek -50\r\nKPX Odieresis Aring -50\r\nKPX Odieresis Atilde -50\r\nKPX Odieresis T -40\r\nKPX Odieresis Tcaron -40\r\nKPX Odieresis Tcommaaccent -40\r\nKPX Odieresis V -50\r\nKPX Odieresis W -50\r\nKPX Odieresis X -50\r\nKPX Odieresis Y -70\r\nKPX Odieresis Yacute -70\r\nKPX Odieresis Ydieresis -70\r\nKPX Odieresis comma -40\r\nKPX Odieresis period -40\r\nKPX Ograve A -50\r\nKPX Ograve Aacute -50\r\nKPX Ograve Abreve -50\r\nKPX Ograve Acircumflex -50\r\nKPX Ograve Adieresis -50\r\nKPX Ograve Agrave -50\r\nKPX Ograve Amacron -50\r\nKPX Ograve Aogonek -50\r\nKPX Ograve Aring -50\r\nKPX Ograve Atilde -50\r\nKPX Ograve T -40\r\nKPX Ograve Tcaron -40\r\nKPX Ograve Tcommaaccent -40\r\nKPX Ograve V -50\r\nKPX Ograve W -50\r\nKPX Ograve X -50\r\nKPX Ograve Y -70\r\nKPX Ograve Yacute -70\r\nKPX Ograve Ydieresis -70\r\nKPX Ograve comma -40\r\nKPX Ograve period -40\r\nKPX Ohungarumlaut A -50\r\nKPX Ohungarumlaut Aacute -50\r\nKPX Ohungarumlaut Abreve -50\r\nKPX Ohungarumlaut Acircumflex -50\r\nKPX Ohungarumlaut Adieresis -50\r\nKPX Ohungarumlaut Agrave -50\r\nKPX Ohungarumlaut Amacron -50\r\nKPX Ohungarumlaut Aogonek -50\r\nKPX Ohungarumlaut Aring -50\r\nKPX Ohungarumlaut Atilde -50\r\nKPX Ohungarumlaut T -40\r\nKPX Ohungarumlaut Tcaron -40\r\nKPX Ohungarumlaut Tcommaaccent -40\r\nKPX Ohungarumlaut V -50\r\nKPX Ohungarumlaut W -50\r\nKPX Ohungarumlaut X -50\r\nKPX Ohungarumlaut Y -70\r\nKPX Ohungarumlaut Yacute -70\r\nKPX Ohungarumlaut Ydieresis -70\r\nKPX Ohungarumlaut comma -40\r\nKPX Ohungarumlaut period -40\r\nKPX Omacron A -50\r\nKPX Omacron Aacute -50\r\nKPX Omacron Abreve -50\r\nKPX Omacron Acircumflex -50\r\nKPX Omacron Adieresis -50\r\nKPX Omacron Agrave -50\r\nKPX Omacron Amacron -50\r\nKPX Omacron Aogonek -50\r\nKPX Omacron Aring -50\r\nKPX Omacron Atilde -50\r\nKPX Omacron T -40\r\nKPX Omacron Tcaron -40\r\nKPX Omacron Tcommaaccent -40\r\nKPX Omacron V -50\r\nKPX Omacron W -50\r\nKPX Omacron X -50\r\nKPX Omacron Y -70\r\nKPX Omacron Yacute -70\r\nKPX Omacron Ydieresis -70\r\nKPX Omacron comma -40\r\nKPX Omacron period -40\r\nKPX Oslash A -50\r\nKPX Oslash Aacute -50\r\nKPX Oslash Abreve -50\r\nKPX Oslash Acircumflex -50\r\nKPX Oslash Adieresis -50\r\nKPX Oslash Agrave -50\r\nKPX Oslash Amacron -50\r\nKPX Oslash Aogonek -50\r\nKPX Oslash Aring -50\r\nKPX Oslash Atilde -50\r\nKPX Oslash T -40\r\nKPX Oslash Tcaron -40\r\nKPX Oslash Tcommaaccent -40\r\nKPX Oslash V -50\r\nKPX Oslash W -50\r\nKPX Oslash X -50\r\nKPX Oslash Y -70\r\nKPX Oslash Yacute -70\r\nKPX Oslash Ydieresis -70\r\nKPX Oslash comma -40\r\nKPX Oslash period -40\r\nKPX Otilde A -50\r\nKPX Otilde Aacute -50\r\nKPX Otilde Abreve -50\r\nKPX Otilde Acircumflex -50\r\nKPX Otilde Adieresis -50\r\nKPX Otilde Agrave -50\r\nKPX Otilde Amacron -50\r\nKPX Otilde Aogonek -50\r\nKPX Otilde Aring -50\r\nKPX Otilde Atilde -50\r\nKPX Otilde T -40\r\nKPX Otilde Tcaron -40\r\nKPX Otilde Tcommaaccent -40\r\nKPX Otilde V -50\r\nKPX Otilde W -50\r\nKPX Otilde X -50\r\nKPX Otilde Y -70\r\nKPX Otilde Yacute -70\r\nKPX Otilde Ydieresis -70\r\nKPX Otilde comma -40\r\nKPX Otilde period -40\r\nKPX P A -100\r\nKPX P Aacute -100\r\nKPX P Abreve -100\r\nKPX P Acircumflex -100\r\nKPX P Adieresis -100\r\nKPX P Agrave -100\r\nKPX P Amacron -100\r\nKPX P Aogonek -100\r\nKPX P Aring -100\r\nKPX P Atilde -100\r\nKPX P a -30\r\nKPX P aacute -30\r\nKPX P abreve -30\r\nKPX P acircumflex -30\r\nKPX P adieresis -30\r\nKPX P agrave -30\r\nKPX P amacron -30\r\nKPX P aogonek -30\r\nKPX P aring -30\r\nKPX P atilde -30\r\nKPX P comma -120\r\nKPX P e -30\r\nKPX P eacute -30\r\nKPX P ecaron -30\r\nKPX P ecircumflex -30\r\nKPX P edieresis -30\r\nKPX P edotaccent -30\r\nKPX P egrave -30\r\nKPX P emacron -30\r\nKPX P eogonek -30\r\nKPX P o -40\r\nKPX P oacute -40\r\nKPX P ocircumflex -40\r\nKPX P odieresis -40\r\nKPX P ograve -40\r\nKPX P ohungarumlaut -40\r\nKPX P omacron -40\r\nKPX P oslash -40\r\nKPX P otilde -40\r\nKPX P period -120\r\nKPX Q U -10\r\nKPX Q Uacute -10\r\nKPX Q Ucircumflex -10\r\nKPX Q Udieresis -10\r\nKPX Q Ugrave -10\r\nKPX Q Uhungarumlaut -10\r\nKPX Q Umacron -10\r\nKPX Q Uogonek -10\r\nKPX Q Uring -10\r\nKPX Q comma 20\r\nKPX Q period 20\r\nKPX R O -20\r\nKPX R Oacute -20\r\nKPX R Ocircumflex -20\r\nKPX R Odieresis -20\r\nKPX R Ograve -20\r\nKPX R Ohungarumlaut -20\r\nKPX R Omacron -20\r\nKPX R Oslash -20\r\nKPX R Otilde -20\r\nKPX R T -20\r\nKPX R Tcaron -20\r\nKPX R Tcommaaccent -20\r\nKPX R U -20\r\nKPX R Uacute -20\r\nKPX R Ucircumflex -20\r\nKPX R Udieresis -20\r\nKPX R Ugrave -20\r\nKPX R Uhungarumlaut -20\r\nKPX R Umacron -20\r\nKPX R Uogonek -20\r\nKPX R Uring -20\r\nKPX R V -50\r\nKPX R W -40\r\nKPX R Y -50\r\nKPX R Yacute -50\r\nKPX R Ydieresis -50\r\nKPX Racute O -20\r\nKPX Racute Oacute -20\r\nKPX Racute Ocircumflex -20\r\nKPX Racute Odieresis -20\r\nKPX Racute Ograve -20\r\nKPX Racute Ohungarumlaut -20\r\nKPX Racute Omacron -20\r\nKPX Racute Oslash -20\r\nKPX Racute Otilde -20\r\nKPX Racute T -20\r\nKPX Racute Tcaron -20\r\nKPX Racute Tcommaaccent -20\r\nKPX Racute U -20\r\nKPX Racute Uacute -20\r\nKPX Racute Ucircumflex -20\r\nKPX Racute Udieresis -20\r\nKPX Racute Ugrave -20\r\nKPX Racute Uhungarumlaut -20\r\nKPX Racute Umacron -20\r\nKPX Racute Uogonek -20\r\nKPX Racute Uring -20\r\nKPX Racute V -50\r\nKPX Racute W -40\r\nKPX Racute Y -50\r\nKPX Racute Yacute -50\r\nKPX Racute Ydieresis -50\r\nKPX Rcaron O -20\r\nKPX Rcaron Oacute -20\r\nKPX Rcaron Ocircumflex -20\r\nKPX Rcaron Odieresis -20\r\nKPX Rcaron Ograve -20\r\nKPX Rcaron Ohungarumlaut -20\r\nKPX Rcaron Omacron -20\r\nKPX Rcaron Oslash -20\r\nKPX Rcaron Otilde -20\r\nKPX Rcaron T -20\r\nKPX Rcaron Tcaron -20\r\nKPX Rcaron Tcommaaccent -20\r\nKPX Rcaron U -20\r\nKPX Rcaron Uacute -20\r\nKPX Rcaron Ucircumflex -20\r\nKPX Rcaron Udieresis -20\r\nKPX Rcaron Ugrave -20\r\nKPX Rcaron Uhungarumlaut -20\r\nKPX Rcaron Umacron -20\r\nKPX Rcaron Uogonek -20\r\nKPX Rcaron Uring -20\r\nKPX Rcaron V -50\r\nKPX Rcaron W -40\r\nKPX Rcaron Y -50\r\nKPX Rcaron Yacute -50\r\nKPX Rcaron Ydieresis -50\r\nKPX Rcommaaccent O -20\r\nKPX Rcommaaccent Oacute -20\r\nKPX Rcommaaccent Ocircumflex -20\r\nKPX Rcommaaccent Odieresis -20\r\nKPX Rcommaaccent Ograve -20\r\nKPX Rcommaaccent Ohungarumlaut -20\r\nKPX Rcommaaccent Omacron -20\r\nKPX Rcommaaccent Oslash -20\r\nKPX Rcommaaccent Otilde -20\r\nKPX Rcommaaccent T -20\r\nKPX Rcommaaccent Tcaron -20\r\nKPX Rcommaaccent Tcommaaccent -20\r\nKPX Rcommaaccent U -20\r\nKPX Rcommaaccent Uacute -20\r\nKPX Rcommaaccent Ucircumflex -20\r\nKPX Rcommaaccent Udieresis -20\r\nKPX Rcommaaccent Ugrave -20\r\nKPX Rcommaaccent Uhungarumlaut -20\r\nKPX Rcommaaccent Umacron -20\r\nKPX Rcommaaccent Uogonek -20\r\nKPX Rcommaaccent Uring -20\r\nKPX Rcommaaccent V -50\r\nKPX Rcommaaccent W -40\r\nKPX Rcommaaccent Y -50\r\nKPX Rcommaaccent Yacute -50\r\nKPX Rcommaaccent Ydieresis -50\r\nKPX T A -90\r\nKPX T Aacute -90\r\nKPX T Abreve -90\r\nKPX T Acircumflex -90\r\nKPX T Adieresis -90\r\nKPX T Agrave -90\r\nKPX T Amacron -90\r\nKPX T Aogonek -90\r\nKPX T Aring -90\r\nKPX T Atilde -90\r\nKPX T O -40\r\nKPX T Oacute -40\r\nKPX T Ocircumflex -40\r\nKPX T Odieresis -40\r\nKPX T Ograve -40\r\nKPX T Ohungarumlaut -40\r\nKPX T Omacron -40\r\nKPX T Oslash -40\r\nKPX T Otilde -40\r\nKPX T a -80\r\nKPX T aacute -80\r\nKPX T abreve -80\r\nKPX T acircumflex -80\r\nKPX T adieresis -80\r\nKPX T agrave -80\r\nKPX T amacron -80\r\nKPX T aogonek -80\r\nKPX T aring -80\r\nKPX T atilde -80\r\nKPX T colon -40\r\nKPX T comma -80\r\nKPX T e -60\r\nKPX T eacute -60\r\nKPX T ecaron -60\r\nKPX T ecircumflex -60\r\nKPX T edieresis -60\r\nKPX T edotaccent -60\r\nKPX T egrave -60\r\nKPX T emacron -60\r\nKPX T eogonek -60\r\nKPX T hyphen -120\r\nKPX T o -80\r\nKPX T oacute -80\r\nKPX T ocircumflex -80\r\nKPX T odieresis -80\r\nKPX T ograve -80\r\nKPX T ohungarumlaut -80\r\nKPX T omacron -80\r\nKPX T oslash -80\r\nKPX T otilde -80\r\nKPX T period -80\r\nKPX T r -80\r\nKPX T racute -80\r\nKPX T rcommaaccent -80\r\nKPX T semicolon -40\r\nKPX T u -90\r\nKPX T uacute -90\r\nKPX T ucircumflex -90\r\nKPX T udieresis -90\r\nKPX T ugrave -90\r\nKPX T uhungarumlaut -90\r\nKPX T umacron -90\r\nKPX T uogonek -90\r\nKPX T uring -90\r\nKPX T w -60\r\nKPX T y -60\r\nKPX T yacute -60\r\nKPX T ydieresis -60\r\nKPX Tcaron A -90\r\nKPX Tcaron Aacute -90\r\nKPX Tcaron Abreve -90\r\nKPX Tcaron Acircumflex -90\r\nKPX Tcaron Adieresis -90\r\nKPX Tcaron Agrave -90\r\nKPX Tcaron Amacron -90\r\nKPX Tcaron Aogonek -90\r\nKPX Tcaron Aring -90\r\nKPX Tcaron Atilde -90\r\nKPX Tcaron O -40\r\nKPX Tcaron Oacute -40\r\nKPX Tcaron Ocircumflex -40\r\nKPX Tcaron Odieresis -40\r\nKPX Tcaron Ograve -40\r\nKPX Tcaron Ohungarumlaut -40\r\nKPX Tcaron Omacron -40\r\nKPX Tcaron Oslash -40\r\nKPX Tcaron Otilde -40\r\nKPX Tcaron a -80\r\nKPX Tcaron aacute -80\r\nKPX Tcaron abreve -80\r\nKPX Tcaron acircumflex -80\r\nKPX Tcaron adieresis -80\r\nKPX Tcaron agrave -80\r\nKPX Tcaron amacron -80\r\nKPX Tcaron aogonek -80\r\nKPX Tcaron aring -80\r\nKPX Tcaron atilde -80\r\nKPX Tcaron colon -40\r\nKPX Tcaron comma -80\r\nKPX Tcaron e -60\r\nKPX Tcaron eacute -60\r\nKPX Tcaron ecaron -60\r\nKPX Tcaron ecircumflex -60\r\nKPX Tcaron edieresis -60\r\nKPX Tcaron edotaccent -60\r\nKPX Tcaron egrave -60\r\nKPX Tcaron emacron -60\r\nKPX Tcaron eogonek -60\r\nKPX Tcaron hyphen -120\r\nKPX Tcaron o -80\r\nKPX Tcaron oacute -80\r\nKPX Tcaron ocircumflex -80\r\nKPX Tcaron odieresis -80\r\nKPX Tcaron ograve -80\r\nKPX Tcaron ohungarumlaut -80\r\nKPX Tcaron omacron -80\r\nKPX Tcaron oslash -80\r\nKPX Tcaron otilde -80\r\nKPX Tcaron period -80\r\nKPX Tcaron r -80\r\nKPX Tcaron racute -80\r\nKPX Tcaron rcommaaccent -80\r\nKPX Tcaron semicolon -40\r\nKPX Tcaron u -90\r\nKPX Tcaron uacute -90\r\nKPX Tcaron ucircumflex -90\r\nKPX Tcaron udieresis -90\r\nKPX Tcaron ugrave -90\r\nKPX Tcaron uhungarumlaut -90\r\nKPX Tcaron umacron -90\r\nKPX Tcaron uogonek -90\r\nKPX Tcaron uring -90\r\nKPX Tcaron w -60\r\nKPX Tcaron y -60\r\nKPX Tcaron yacute -60\r\nKPX Tcaron ydieresis -60\r\nKPX Tcommaaccent A -90\r\nKPX Tcommaaccent Aacute -90\r\nKPX Tcommaaccent Abreve -90\r\nKPX Tcommaaccent Acircumflex -90\r\nKPX Tcommaaccent Adieresis -90\r\nKPX Tcommaaccent Agrave -90\r\nKPX Tcommaaccent Amacron -90\r\nKPX Tcommaaccent Aogonek -90\r\nKPX Tcommaaccent Aring -90\r\nKPX Tcommaaccent Atilde -90\r\nKPX Tcommaaccent O -40\r\nKPX Tcommaaccent Oacute -40\r\nKPX Tcommaaccent Ocircumflex -40\r\nKPX Tcommaaccent Odieresis -40\r\nKPX Tcommaaccent Ograve -40\r\nKPX Tcommaaccent Ohungarumlaut -40\r\nKPX Tcommaaccent Omacron -40\r\nKPX Tcommaaccent Oslash -40\r\nKPX Tcommaaccent Otilde -40\r\nKPX Tcommaaccent a -80\r\nKPX Tcommaaccent aacute -80\r\nKPX Tcommaaccent abreve -80\r\nKPX Tcommaaccent acircumflex -80\r\nKPX Tcommaaccent adieresis -80\r\nKPX Tcommaaccent agrave -80\r\nKPX Tcommaaccent amacron -80\r\nKPX Tcommaaccent aogonek -80\r\nKPX Tcommaaccent aring -80\r\nKPX Tcommaaccent atilde -80\r\nKPX Tcommaaccent colon -40\r\nKPX Tcommaaccent comma -80\r\nKPX Tcommaaccent e -60\r\nKPX Tcommaaccent eacute -60\r\nKPX Tcommaaccent ecaron -60\r\nKPX Tcommaaccent ecircumflex -60\r\nKPX Tcommaaccent edieresis -60\r\nKPX Tcommaaccent edotaccent -60\r\nKPX Tcommaaccent egrave -60\r\nKPX Tcommaaccent emacron -60\r\nKPX Tcommaaccent eogonek -60\r\nKPX Tcommaaccent hyphen -120\r\nKPX Tcommaaccent o -80\r\nKPX Tcommaaccent oacute -80\r\nKPX Tcommaaccent ocircumflex -80\r\nKPX Tcommaaccent odieresis -80\r\nKPX Tcommaaccent ograve -80\r\nKPX Tcommaaccent ohungarumlaut -80\r\nKPX Tcommaaccent omacron -80\r\nKPX Tcommaaccent oslash -80\r\nKPX Tcommaaccent otilde -80\r\nKPX Tcommaaccent period -80\r\nKPX Tcommaaccent r -80\r\nKPX Tcommaaccent racute -80\r\nKPX Tcommaaccent rcommaaccent -80\r\nKPX Tcommaaccent semicolon -40\r\nKPX Tcommaaccent u -90\r\nKPX Tcommaaccent uacute -90\r\nKPX Tcommaaccent ucircumflex -90\r\nKPX Tcommaaccent udieresis -90\r\nKPX Tcommaaccent ugrave -90\r\nKPX Tcommaaccent uhungarumlaut -90\r\nKPX Tcommaaccent umacron -90\r\nKPX Tcommaaccent uogonek -90\r\nKPX Tcommaaccent uring -90\r\nKPX Tcommaaccent w -60\r\nKPX Tcommaaccent y -60\r\nKPX Tcommaaccent yacute -60\r\nKPX Tcommaaccent ydieresis -60\r\nKPX U A -50\r\nKPX U Aacute -50\r\nKPX U Abreve -50\r\nKPX U Acircumflex -50\r\nKPX U Adieresis -50\r\nKPX U Agrave -50\r\nKPX U Amacron -50\r\nKPX U Aogonek -50\r\nKPX U Aring -50\r\nKPX U Atilde -50\r\nKPX U comma -30\r\nKPX U period -30\r\nKPX Uacute A -50\r\nKPX Uacute Aacute -50\r\nKPX Uacute Abreve -50\r\nKPX Uacute Acircumflex -50\r\nKPX Uacute Adieresis -50\r\nKPX Uacute Agrave -50\r\nKPX Uacute Amacron -50\r\nKPX Uacute Aogonek -50\r\nKPX Uacute Aring -50\r\nKPX Uacute Atilde -50\r\nKPX Uacute comma -30\r\nKPX Uacute period -30\r\nKPX Ucircumflex A -50\r\nKPX Ucircumflex Aacute -50\r\nKPX Ucircumflex Abreve -50\r\nKPX Ucircumflex Acircumflex -50\r\nKPX Ucircumflex Adieresis -50\r\nKPX Ucircumflex Agrave -50\r\nKPX Ucircumflex Amacron -50\r\nKPX Ucircumflex Aogonek -50\r\nKPX Ucircumflex Aring -50\r\nKPX Ucircumflex Atilde -50\r\nKPX Ucircumflex comma -30\r\nKPX Ucircumflex period -30\r\nKPX Udieresis A -50\r\nKPX Udieresis Aacute -50\r\nKPX Udieresis Abreve -50\r\nKPX Udieresis Acircumflex -50\r\nKPX Udieresis Adieresis -50\r\nKPX Udieresis Agrave -50\r\nKPX Udieresis Amacron -50\r\nKPX Udieresis Aogonek -50\r\nKPX Udieresis Aring -50\r\nKPX Udieresis Atilde -50\r\nKPX Udieresis comma -30\r\nKPX Udieresis period -30\r\nKPX Ugrave A -50\r\nKPX Ugrave Aacute -50\r\nKPX Ugrave Abreve -50\r\nKPX Ugrave Acircumflex -50\r\nKPX Ugrave Adieresis -50\r\nKPX Ugrave Agrave -50\r\nKPX Ugrave Amacron -50\r\nKPX Ugrave Aogonek -50\r\nKPX Ugrave Aring -50\r\nKPX Ugrave Atilde -50\r\nKPX Ugrave comma -30\r\nKPX Ugrave period -30\r\nKPX Uhungarumlaut A -50\r\nKPX Uhungarumlaut Aacute -50\r\nKPX Uhungarumlaut Abreve -50\r\nKPX Uhungarumlaut Acircumflex -50\r\nKPX Uhungarumlaut Adieresis -50\r\nKPX Uhungarumlaut Agrave -50\r\nKPX Uhungarumlaut Amacron -50\r\nKPX Uhungarumlaut Aogonek -50\r\nKPX Uhungarumlaut Aring -50\r\nKPX Uhungarumlaut Atilde -50\r\nKPX Uhungarumlaut comma -30\r\nKPX Uhungarumlaut period -30\r\nKPX Umacron A -50\r\nKPX Umacron Aacute -50\r\nKPX Umacron Abreve -50\r\nKPX Umacron Acircumflex -50\r\nKPX Umacron Adieresis -50\r\nKPX Umacron Agrave -50\r\nKPX Umacron Amacron -50\r\nKPX Umacron Aogonek -50\r\nKPX Umacron Aring -50\r\nKPX Umacron Atilde -50\r\nKPX Umacron comma -30\r\nKPX Umacron period -30\r\nKPX Uogonek A -50\r\nKPX Uogonek Aacute -50\r\nKPX Uogonek Abreve -50\r\nKPX Uogonek Acircumflex -50\r\nKPX Uogonek Adieresis -50\r\nKPX Uogonek Agrave -50\r\nKPX Uogonek Amacron -50\r\nKPX Uogonek Aogonek -50\r\nKPX Uogonek Aring -50\r\nKPX Uogonek Atilde -50\r\nKPX Uogonek comma -30\r\nKPX Uogonek period -30\r\nKPX Uring A -50\r\nKPX Uring Aacute -50\r\nKPX Uring Abreve -50\r\nKPX Uring Acircumflex -50\r\nKPX Uring Adieresis -50\r\nKPX Uring Agrave -50\r\nKPX Uring Amacron -50\r\nKPX Uring Aogonek -50\r\nKPX Uring Aring -50\r\nKPX Uring Atilde -50\r\nKPX Uring comma -30\r\nKPX Uring period -30\r\nKPX V A -80\r\nKPX V Aacute -80\r\nKPX V Abreve -80\r\nKPX V Acircumflex -80\r\nKPX V Adieresis -80\r\nKPX V Agrave -80\r\nKPX V Amacron -80\r\nKPX V Aogonek -80\r\nKPX V Aring -80\r\nKPX V Atilde -80\r\nKPX V G -50\r\nKPX V Gbreve -50\r\nKPX V Gcommaaccent -50\r\nKPX V O -50\r\nKPX V Oacute -50\r\nKPX V Ocircumflex -50\r\nKPX V Odieresis -50\r\nKPX V Ograve -50\r\nKPX V Ohungarumlaut -50\r\nKPX V Omacron -50\r\nKPX V Oslash -50\r\nKPX V Otilde -50\r\nKPX V a -60\r\nKPX V aacute -60\r\nKPX V abreve -60\r\nKPX V acircumflex -60\r\nKPX V adieresis -60\r\nKPX V agrave -60\r\nKPX V amacron -60\r\nKPX V aogonek -60\r\nKPX V aring -60\r\nKPX V atilde -60\r\nKPX V colon -40\r\nKPX V comma -120\r\nKPX V e -50\r\nKPX V eacute -50\r\nKPX V ecaron -50\r\nKPX V ecircumflex -50\r\nKPX V edieresis -50\r\nKPX V edotaccent -50\r\nKPX V egrave -50\r\nKPX V emacron -50\r\nKPX V eogonek -50\r\nKPX V hyphen -80\r\nKPX V o -90\r\nKPX V oacute -90\r\nKPX V ocircumflex -90\r\nKPX V odieresis -90\r\nKPX V ograve -90\r\nKPX V ohungarumlaut -90\r\nKPX V omacron -90\r\nKPX V oslash -90\r\nKPX V otilde -90\r\nKPX V period -120\r\nKPX V semicolon -40\r\nKPX V u -60\r\nKPX V uacute -60\r\nKPX V ucircumflex -60\r\nKPX V udieresis -60\r\nKPX V ugrave -60\r\nKPX V uhungarumlaut -60\r\nKPX V umacron -60\r\nKPX V uogonek -60\r\nKPX V uring -60\r\nKPX W A -60\r\nKPX W Aacute -60\r\nKPX W Abreve -60\r\nKPX W Acircumflex -60\r\nKPX W Adieresis -60\r\nKPX W Agrave -60\r\nKPX W Amacron -60\r\nKPX W Aogonek -60\r\nKPX W Aring -60\r\nKPX W Atilde -60\r\nKPX W O -20\r\nKPX W Oacute -20\r\nKPX W Ocircumflex -20\r\nKPX W Odieresis -20\r\nKPX W Ograve -20\r\nKPX W Ohungarumlaut -20\r\nKPX W Omacron -20\r\nKPX W Oslash -20\r\nKPX W Otilde -20\r\nKPX W a -40\r\nKPX W aacute -40\r\nKPX W abreve -40\r\nKPX W acircumflex -40\r\nKPX W adieresis -40\r\nKPX W agrave -40\r\nKPX W amacron -40\r\nKPX W aogonek -40\r\nKPX W aring -40\r\nKPX W atilde -40\r\nKPX W colon -10\r\nKPX W comma -80\r\nKPX W e -35\r\nKPX W eacute -35\r\nKPX W ecaron -35\r\nKPX W ecircumflex -35\r\nKPX W edieresis -35\r\nKPX W edotaccent -35\r\nKPX W egrave -35\r\nKPX W emacron -35\r\nKPX W eogonek -35\r\nKPX W hyphen -40\r\nKPX W o -60\r\nKPX W oacute -60\r\nKPX W ocircumflex -60\r\nKPX W odieresis -60\r\nKPX W ograve -60\r\nKPX W ohungarumlaut -60\r\nKPX W omacron -60\r\nKPX W oslash -60\r\nKPX W otilde -60\r\nKPX W period -80\r\nKPX W semicolon -10\r\nKPX W u -45\r\nKPX W uacute -45\r\nKPX W ucircumflex -45\r\nKPX W udieresis -45\r\nKPX W ugrave -45\r\nKPX W uhungarumlaut -45\r\nKPX W umacron -45\r\nKPX W uogonek -45\r\nKPX W uring -45\r\nKPX W y -20\r\nKPX W yacute -20\r\nKPX W ydieresis -20\r\nKPX Y A -110\r\nKPX Y Aacute -110\r\nKPX Y Abreve -110\r\nKPX Y Acircumflex -110\r\nKPX Y Adieresis -110\r\nKPX Y Agrave -110\r\nKPX Y Amacron -110\r\nKPX Y Aogonek -110\r\nKPX Y Aring -110\r\nKPX Y Atilde -110\r\nKPX Y O -70\r\nKPX Y Oacute -70\r\nKPX Y Ocircumflex -70\r\nKPX Y Odieresis -70\r\nKPX Y Ograve -70\r\nKPX Y Ohungarumlaut -70\r\nKPX Y Omacron -70\r\nKPX Y Oslash -70\r\nKPX Y Otilde -70\r\nKPX Y a -90\r\nKPX Y aacute -90\r\nKPX Y abreve -90\r\nKPX Y acircumflex -90\r\nKPX Y adieresis -90\r\nKPX Y agrave -90\r\nKPX Y amacron -90\r\nKPX Y aogonek -90\r\nKPX Y aring -90\r\nKPX Y atilde -90\r\nKPX Y colon -50\r\nKPX Y comma -100\r\nKPX Y e -80\r\nKPX Y eacute -80\r\nKPX Y ecaron -80\r\nKPX Y ecircumflex -80\r\nKPX Y edieresis -80\r\nKPX Y edotaccent -80\r\nKPX Y egrave -80\r\nKPX Y emacron -80\r\nKPX Y eogonek -80\r\nKPX Y o -100\r\nKPX Y oacute -100\r\nKPX Y ocircumflex -100\r\nKPX Y odieresis -100\r\nKPX Y ograve -100\r\nKPX Y ohungarumlaut -100\r\nKPX Y omacron -100\r\nKPX Y oslash -100\r\nKPX Y otilde -100\r\nKPX Y period -100\r\nKPX Y semicolon -50\r\nKPX Y u -100\r\nKPX Y uacute -100\r\nKPX Y ucircumflex -100\r\nKPX Y udieresis -100\r\nKPX Y ugrave -100\r\nKPX Y uhungarumlaut -100\r\nKPX Y umacron -100\r\nKPX Y uogonek -100\r\nKPX Y uring -100\r\nKPX Yacute A -110\r\nKPX Yacute Aacute -110\r\nKPX Yacute Abreve -110\r\nKPX Yacute Acircumflex -110\r\nKPX Yacute Adieresis -110\r\nKPX Yacute Agrave -110\r\nKPX Yacute Amacron -110\r\nKPX Yacute Aogonek -110\r\nKPX Yacute Aring -110\r\nKPX Yacute Atilde -110\r\nKPX Yacute O -70\r\nKPX Yacute Oacute -70\r\nKPX Yacute Ocircumflex -70\r\nKPX Yacute Odieresis -70\r\nKPX Yacute Ograve -70\r\nKPX Yacute Ohungarumlaut -70\r\nKPX Yacute Omacron -70\r\nKPX Yacute Oslash -70\r\nKPX Yacute Otilde -70\r\nKPX Yacute a -90\r\nKPX Yacute aacute -90\r\nKPX Yacute abreve -90\r\nKPX Yacute acircumflex -90\r\nKPX Yacute adieresis -90\r\nKPX Yacute agrave -90\r\nKPX Yacute amacron -90\r\nKPX Yacute aogonek -90\r\nKPX Yacute aring -90\r\nKPX Yacute atilde -90\r\nKPX Yacute colon -50\r\nKPX Yacute comma -100\r\nKPX Yacute e -80\r\nKPX Yacute eacute -80\r\nKPX Yacute ecaron -80\r\nKPX Yacute ecircumflex -80\r\nKPX Yacute edieresis -80\r\nKPX Yacute edotaccent -80\r\nKPX Yacute egrave -80\r\nKPX Yacute emacron -80\r\nKPX Yacute eogonek -80\r\nKPX Yacute o -100\r\nKPX Yacute oacute -100\r\nKPX Yacute ocircumflex -100\r\nKPX Yacute odieresis -100\r\nKPX Yacute ograve -100\r\nKPX Yacute ohungarumlaut -100\r\nKPX Yacute omacron -100\r\nKPX Yacute oslash -100\r\nKPX Yacute otilde -100\r\nKPX Yacute period -100\r\nKPX Yacute semicolon -50\r\nKPX Yacute u -100\r\nKPX Yacute uacute -100\r\nKPX Yacute ucircumflex -100\r\nKPX Yacute udieresis -100\r\nKPX Yacute ugrave -100\r\nKPX Yacute uhungarumlaut -100\r\nKPX Yacute umacron -100\r\nKPX Yacute uogonek -100\r\nKPX Yacute uring -100\r\nKPX Ydieresis A -110\r\nKPX Ydieresis Aacute -110\r\nKPX Ydieresis Abreve -110\r\nKPX Ydieresis Acircumflex -110\r\nKPX Ydieresis Adieresis -110\r\nKPX Ydieresis Agrave -110\r\nKPX Ydieresis Amacron -110\r\nKPX Ydieresis Aogonek -110\r\nKPX Ydieresis Aring -110\r\nKPX Ydieresis Atilde -110\r\nKPX Ydieresis O -70\r\nKPX Ydieresis Oacute -70\r\nKPX Ydieresis Ocircumflex -70\r\nKPX Ydieresis Odieresis -70\r\nKPX Ydieresis Ograve -70\r\nKPX Ydieresis Ohungarumlaut -70\r\nKPX Ydieresis Omacron -70\r\nKPX Ydieresis Oslash -70\r\nKPX Ydieresis Otilde -70\r\nKPX Ydieresis a -90\r\nKPX Ydieresis aacute -90\r\nKPX Ydieresis abreve -90\r\nKPX Ydieresis acircumflex -90\r\nKPX Ydieresis adieresis -90\r\nKPX Ydieresis agrave -90\r\nKPX Ydieresis amacron -90\r\nKPX Ydieresis aogonek -90\r\nKPX Ydieresis aring -90\r\nKPX Ydieresis atilde -90\r\nKPX Ydieresis colon -50\r\nKPX Ydieresis comma -100\r\nKPX Ydieresis e -80\r\nKPX Ydieresis eacute -80\r\nKPX Ydieresis ecaron -80\r\nKPX Ydieresis ecircumflex -80\r\nKPX Ydieresis edieresis -80\r\nKPX Ydieresis edotaccent -80\r\nKPX Ydieresis egrave -80\r\nKPX Ydieresis emacron -80\r\nKPX Ydieresis eogonek -80\r\nKPX Ydieresis o -100\r\nKPX Ydieresis oacute -100\r\nKPX Ydieresis ocircumflex -100\r\nKPX Ydieresis odieresis -100\r\nKPX Ydieresis ograve -100\r\nKPX Ydieresis ohungarumlaut -100\r\nKPX Ydieresis omacron -100\r\nKPX Ydieresis oslash -100\r\nKPX Ydieresis otilde -100\r\nKPX Ydieresis period -100\r\nKPX Ydieresis semicolon -50\r\nKPX Ydieresis u -100\r\nKPX Ydieresis uacute -100\r\nKPX Ydieresis ucircumflex -100\r\nKPX Ydieresis udieresis -100\r\nKPX Ydieresis ugrave -100\r\nKPX Ydieresis uhungarumlaut -100\r\nKPX Ydieresis umacron -100\r\nKPX Ydieresis uogonek -100\r\nKPX Ydieresis uring -100\r\nKPX a g -10\r\nKPX a gbreve -10\r\nKPX a gcommaaccent -10\r\nKPX a v -15\r\nKPX a w -15\r\nKPX a y -20\r\nKPX a yacute -20\r\nKPX a ydieresis -20\r\nKPX aacute g -10\r\nKPX aacute gbreve -10\r\nKPX aacute gcommaaccent -10\r\nKPX aacute v -15\r\nKPX aacute w -15\r\nKPX aacute y -20\r\nKPX aacute yacute -20\r\nKPX aacute ydieresis -20\r\nKPX abreve g -10\r\nKPX abreve gbreve -10\r\nKPX abreve gcommaaccent -10\r\nKPX abreve v -15\r\nKPX abreve w -15\r\nKPX abreve y -20\r\nKPX abreve yacute -20\r\nKPX abreve ydieresis -20\r\nKPX acircumflex g -10\r\nKPX acircumflex gbreve -10\r\nKPX acircumflex gcommaaccent -10\r\nKPX acircumflex v -15\r\nKPX acircumflex w -15\r\nKPX acircumflex y -20\r\nKPX acircumflex yacute -20\r\nKPX acircumflex ydieresis -20\r\nKPX adieresis g -10\r\nKPX adieresis gbreve -10\r\nKPX adieresis gcommaaccent -10\r\nKPX adieresis v -15\r\nKPX adieresis w -15\r\nKPX adieresis y -20\r\nKPX adieresis yacute -20\r\nKPX adieresis ydieresis -20\r\nKPX agrave g -10\r\nKPX agrave gbreve -10\r\nKPX agrave gcommaaccent -10\r\nKPX agrave v -15\r\nKPX agrave w -15\r\nKPX agrave y -20\r\nKPX agrave yacute -20\r\nKPX agrave ydieresis -20\r\nKPX amacron g -10\r\nKPX amacron gbreve -10\r\nKPX amacron gcommaaccent -10\r\nKPX amacron v -15\r\nKPX amacron w -15\r\nKPX amacron y -20\r\nKPX amacron yacute -20\r\nKPX amacron ydieresis -20\r\nKPX aogonek g -10\r\nKPX aogonek gbreve -10\r\nKPX aogonek gcommaaccent -10\r\nKPX aogonek v -15\r\nKPX aogonek w -15\r\nKPX aogonek y -20\r\nKPX aogonek yacute -20\r\nKPX aogonek ydieresis -20\r\nKPX aring g -10\r\nKPX aring gbreve -10\r\nKPX aring gcommaaccent -10\r\nKPX aring v -15\r\nKPX aring w -15\r\nKPX aring y -20\r\nKPX aring yacute -20\r\nKPX aring ydieresis -20\r\nKPX atilde g -10\r\nKPX atilde gbreve -10\r\nKPX atilde gcommaaccent -10\r\nKPX atilde v -15\r\nKPX atilde w -15\r\nKPX atilde y -20\r\nKPX atilde yacute -20\r\nKPX atilde ydieresis -20\r\nKPX b l -10\r\nKPX b lacute -10\r\nKPX b lcommaaccent -10\r\nKPX b lslash -10\r\nKPX b u -20\r\nKPX b uacute -20\r\nKPX b ucircumflex -20\r\nKPX b udieresis -20\r\nKPX b ugrave -20\r\nKPX b uhungarumlaut -20\r\nKPX b umacron -20\r\nKPX b uogonek -20\r\nKPX b uring -20\r\nKPX b v -20\r\nKPX b y -20\r\nKPX b yacute -20\r\nKPX b ydieresis -20\r\nKPX c h -10\r\nKPX c k -20\r\nKPX c kcommaaccent -20\r\nKPX c l -20\r\nKPX c lacute -20\r\nKPX c lcommaaccent -20\r\nKPX c lslash -20\r\nKPX c y -10\r\nKPX c yacute -10\r\nKPX c ydieresis -10\r\nKPX cacute h -10\r\nKPX cacute k -20\r\nKPX cacute kcommaaccent -20\r\nKPX cacute l -20\r\nKPX cacute lacute -20\r\nKPX cacute lcommaaccent -20\r\nKPX cacute lslash -20\r\nKPX cacute y -10\r\nKPX cacute yacute -10\r\nKPX cacute ydieresis -10\r\nKPX ccaron h -10\r\nKPX ccaron k -20\r\nKPX ccaron kcommaaccent -20\r\nKPX ccaron l -20\r\nKPX ccaron lacute -20\r\nKPX ccaron lcommaaccent -20\r\nKPX ccaron lslash -20\r\nKPX ccaron y -10\r\nKPX ccaron yacute -10\r\nKPX ccaron ydieresis -10\r\nKPX ccedilla h -10\r\nKPX ccedilla k -20\r\nKPX ccedilla kcommaaccent -20\r\nKPX ccedilla l -20\r\nKPX ccedilla lacute -20\r\nKPX ccedilla lcommaaccent -20\r\nKPX ccedilla lslash -20\r\nKPX ccedilla y -10\r\nKPX ccedilla yacute -10\r\nKPX ccedilla ydieresis -10\r\nKPX colon space -40\r\nKPX comma quotedblright -120\r\nKPX comma quoteright -120\r\nKPX comma space -40\r\nKPX d d -10\r\nKPX d dcroat -10\r\nKPX d v -15\r\nKPX d w -15\r\nKPX d y -15\r\nKPX d yacute -15\r\nKPX d ydieresis -15\r\nKPX dcroat d -10\r\nKPX dcroat dcroat -10\r\nKPX dcroat v -15\r\nKPX dcroat w -15\r\nKPX dcroat y -15\r\nKPX dcroat yacute -15\r\nKPX dcroat ydieresis -15\r\nKPX e comma 10\r\nKPX e period 20\r\nKPX e v -15\r\nKPX e w -15\r\nKPX e x -15\r\nKPX e y -15\r\nKPX e yacute -15\r\nKPX e ydieresis -15\r\nKPX eacute comma 10\r\nKPX eacute period 20\r\nKPX eacute v -15\r\nKPX eacute w -15\r\nKPX eacute x -15\r\nKPX eacute y -15\r\nKPX eacute yacute -15\r\nKPX eacute ydieresis -15\r\nKPX ecaron comma 10\r\nKPX ecaron period 20\r\nKPX ecaron v -15\r\nKPX ecaron w -15\r\nKPX ecaron x -15\r\nKPX ecaron y -15\r\nKPX ecaron yacute -15\r\nKPX ecaron ydieresis -15\r\nKPX ecircumflex comma 10\r\nKPX ecircumflex period 20\r\nKPX ecircumflex v -15\r\nKPX ecircumflex w -15\r\nKPX ecircumflex x -15\r\nKPX ecircumflex y -15\r\nKPX ecircumflex yacute -15\r\nKPX ecircumflex ydieresis -15\r\nKPX edieresis comma 10\r\nKPX edieresis period 20\r\nKPX edieresis v -15\r\nKPX edieresis w -15\r\nKPX edieresis x -15\r\nKPX edieresis y -15\r\nKPX edieresis yacute -15\r\nKPX edieresis ydieresis -15\r\nKPX edotaccent comma 10\r\nKPX edotaccent period 20\r\nKPX edotaccent v -15\r\nKPX edotaccent w -15\r\nKPX edotaccent x -15\r\nKPX edotaccent y -15\r\nKPX edotaccent yacute -15\r\nKPX edotaccent ydieresis -15\r\nKPX egrave comma 10\r\nKPX egrave period 20\r\nKPX egrave v -15\r\nKPX egrave w -15\r\nKPX egrave x -15\r\nKPX egrave y -15\r\nKPX egrave yacute -15\r\nKPX egrave ydieresis -15\r\nKPX emacron comma 10\r\nKPX emacron period 20\r\nKPX emacron v -15\r\nKPX emacron w -15\r\nKPX emacron x -15\r\nKPX emacron y -15\r\nKPX emacron yacute -15\r\nKPX emacron ydieresis -15\r\nKPX eogonek comma 10\r\nKPX eogonek period 20\r\nKPX eogonek v -15\r\nKPX eogonek w -15\r\nKPX eogonek x -15\r\nKPX eogonek y -15\r\nKPX eogonek yacute -15\r\nKPX eogonek ydieresis -15\r\nKPX f comma -10\r\nKPX f e -10\r\nKPX f eacute -10\r\nKPX f ecaron -10\r\nKPX f ecircumflex -10\r\nKPX f edieresis -10\r\nKPX f edotaccent -10\r\nKPX f egrave -10\r\nKPX f emacron -10\r\nKPX f eogonek -10\r\nKPX f o -20\r\nKPX f oacute -20\r\nKPX f ocircumflex -20\r\nKPX f odieresis -20\r\nKPX f ograve -20\r\nKPX f ohungarumlaut -20\r\nKPX f omacron -20\r\nKPX f oslash -20\r\nKPX f otilde -20\r\nKPX f period -10\r\nKPX f quotedblright 30\r\nKPX f quoteright 30\r\nKPX g e 10\r\nKPX g eacute 10\r\nKPX g ecaron 10\r\nKPX g ecircumflex 10\r\nKPX g edieresis 10\r\nKPX g edotaccent 10\r\nKPX g egrave 10\r\nKPX g emacron 10\r\nKPX g eogonek 10\r\nKPX g g -10\r\nKPX g gbreve -10\r\nKPX g gcommaaccent -10\r\nKPX gbreve e 10\r\nKPX gbreve eacute 10\r\nKPX gbreve ecaron 10\r\nKPX gbreve ecircumflex 10\r\nKPX gbreve edieresis 10\r\nKPX gbreve edotaccent 10\r\nKPX gbreve egrave 10\r\nKPX gbreve emacron 10\r\nKPX gbreve eogonek 10\r\nKPX gbreve g -10\r\nKPX gbreve gbreve -10\r\nKPX gbreve gcommaaccent -10\r\nKPX gcommaaccent e 10\r\nKPX gcommaaccent eacute 10\r\nKPX gcommaaccent ecaron 10\r\nKPX gcommaaccent ecircumflex 10\r\nKPX gcommaaccent edieresis 10\r\nKPX gcommaaccent edotaccent 10\r\nKPX gcommaaccent egrave 10\r\nKPX gcommaaccent emacron 10\r\nKPX gcommaaccent eogonek 10\r\nKPX gcommaaccent g -10\r\nKPX gcommaaccent gbreve -10\r\nKPX gcommaaccent gcommaaccent -10\r\nKPX h y -20\r\nKPX h yacute -20\r\nKPX h ydieresis -20\r\nKPX k o -15\r\nKPX k oacute -15\r\nKPX k ocircumflex -15\r\nKPX k odieresis -15\r\nKPX k ograve -15\r\nKPX k ohungarumlaut -15\r\nKPX k omacron -15\r\nKPX k oslash -15\r\nKPX k otilde -15\r\nKPX kcommaaccent o -15\r\nKPX kcommaaccent oacute -15\r\nKPX kcommaaccent ocircumflex -15\r\nKPX kcommaaccent odieresis -15\r\nKPX kcommaaccent ograve -15\r\nKPX kcommaaccent ohungarumlaut -15\r\nKPX kcommaaccent omacron -15\r\nKPX kcommaaccent oslash -15\r\nKPX kcommaaccent otilde -15\r\nKPX l w -15\r\nKPX l y -15\r\nKPX l yacute -15\r\nKPX l ydieresis -15\r\nKPX lacute w -15\r\nKPX lacute y -15\r\nKPX lacute yacute -15\r\nKPX lacute ydieresis -15\r\nKPX lcommaaccent w -15\r\nKPX lcommaaccent y -15\r\nKPX lcommaaccent yacute -15\r\nKPX lcommaaccent ydieresis -15\r\nKPX lslash w -15\r\nKPX lslash y -15\r\nKPX lslash yacute -15\r\nKPX lslash ydieresis -15\r\nKPX m u -20\r\nKPX m uacute -20\r\nKPX m ucircumflex -20\r\nKPX m udieresis -20\r\nKPX m ugrave -20\r\nKPX m uhungarumlaut -20\r\nKPX m umacron -20\r\nKPX m uogonek -20\r\nKPX m uring -20\r\nKPX m y -30\r\nKPX m yacute -30\r\nKPX m ydieresis -30\r\nKPX n u -10\r\nKPX n uacute -10\r\nKPX n ucircumflex -10\r\nKPX n udieresis -10\r\nKPX n ugrave -10\r\nKPX n uhungarumlaut -10\r\nKPX n umacron -10\r\nKPX n uogonek -10\r\nKPX n uring -10\r\nKPX n v -40\r\nKPX n y -20\r\nKPX n yacute -20\r\nKPX n ydieresis -20\r\nKPX nacute u -10\r\nKPX nacute uacute -10\r\nKPX nacute ucircumflex -10\r\nKPX nacute udieresis -10\r\nKPX nacute ugrave -10\r\nKPX nacute uhungarumlaut -10\r\nKPX nacute umacron -10\r\nKPX nacute uogonek -10\r\nKPX nacute uring -10\r\nKPX nacute v -40\r\nKPX nacute y -20\r\nKPX nacute yacute -20\r\nKPX nacute ydieresis -20\r\nKPX ncaron u -10\r\nKPX ncaron uacute -10\r\nKPX ncaron ucircumflex -10\r\nKPX ncaron udieresis -10\r\nKPX ncaron ugrave -10\r\nKPX ncaron uhungarumlaut -10\r\nKPX ncaron umacron -10\r\nKPX ncaron uogonek -10\r\nKPX ncaron uring -10\r\nKPX ncaron v -40\r\nKPX ncaron y -20\r\nKPX ncaron yacute -20\r\nKPX ncaron ydieresis -20\r\nKPX ncommaaccent u -10\r\nKPX ncommaaccent uacute -10\r\nKPX ncommaaccent ucircumflex -10\r\nKPX ncommaaccent udieresis -10\r\nKPX ncommaaccent ugrave -10\r\nKPX ncommaaccent uhungarumlaut -10\r\nKPX ncommaaccent umacron -10\r\nKPX ncommaaccent uogonek -10\r\nKPX ncommaaccent uring -10\r\nKPX ncommaaccent v -40\r\nKPX ncommaaccent y -20\r\nKPX ncommaaccent yacute -20\r\nKPX ncommaaccent ydieresis -20\r\nKPX ntilde u -10\r\nKPX ntilde uacute -10\r\nKPX ntilde ucircumflex -10\r\nKPX ntilde udieresis -10\r\nKPX ntilde ugrave -10\r\nKPX ntilde uhungarumlaut -10\r\nKPX ntilde umacron -10\r\nKPX ntilde uogonek -10\r\nKPX ntilde uring -10\r\nKPX ntilde v -40\r\nKPX ntilde y -20\r\nKPX ntilde yacute -20\r\nKPX ntilde ydieresis -20\r\nKPX o v -20\r\nKPX o w -15\r\nKPX o x -30\r\nKPX o y -20\r\nKPX o yacute -20\r\nKPX o ydieresis -20\r\nKPX oacute v -20\r\nKPX oacute w -15\r\nKPX oacute x -30\r\nKPX oacute y -20\r\nKPX oacute yacute -20\r\nKPX oacute ydieresis -20\r\nKPX ocircumflex v -20\r\nKPX ocircumflex w -15\r\nKPX ocircumflex x -30\r\nKPX ocircumflex y -20\r\nKPX ocircumflex yacute -20\r\nKPX ocircumflex ydieresis -20\r\nKPX odieresis v -20\r\nKPX odieresis w -15\r\nKPX odieresis x -30\r\nKPX odieresis y -20\r\nKPX odieresis yacute -20\r\nKPX odieresis ydieresis -20\r\nKPX ograve v -20\r\nKPX ograve w -15\r\nKPX ograve x -30\r\nKPX ograve y -20\r\nKPX ograve yacute -20\r\nKPX ograve ydieresis -20\r\nKPX ohungarumlaut v -20\r\nKPX ohungarumlaut w -15\r\nKPX ohungarumlaut x -30\r\nKPX ohungarumlaut y -20\r\nKPX ohungarumlaut yacute -20\r\nKPX ohungarumlaut ydieresis -20\r\nKPX omacron v -20\r\nKPX omacron w -15\r\nKPX omacron x -30\r\nKPX omacron y -20\r\nKPX omacron yacute -20\r\nKPX omacron ydieresis -20\r\nKPX oslash v -20\r\nKPX oslash w -15\r\nKPX oslash x -30\r\nKPX oslash y -20\r\nKPX oslash yacute -20\r\nKPX oslash ydieresis -20\r\nKPX otilde v -20\r\nKPX otilde w -15\r\nKPX otilde x -30\r\nKPX otilde y -20\r\nKPX otilde yacute -20\r\nKPX otilde ydieresis -20\r\nKPX p y -15\r\nKPX p yacute -15\r\nKPX p ydieresis -15\r\nKPX period quotedblright -120\r\nKPX period quoteright -120\r\nKPX period space -40\r\nKPX quotedblright space -80\r\nKPX quoteleft quoteleft -46\r\nKPX quoteright d -80\r\nKPX quoteright dcroat -80\r\nKPX quoteright l -20\r\nKPX quoteright lacute -20\r\nKPX quoteright lcommaaccent -20\r\nKPX quoteright lslash -20\r\nKPX quoteright quoteright -46\r\nKPX quoteright r -40\r\nKPX quoteright racute -40\r\nKPX quoteright rcaron -40\r\nKPX quoteright rcommaaccent -40\r\nKPX quoteright s -60\r\nKPX quoteright sacute -60\r\nKPX quoteright scaron -60\r\nKPX quoteright scedilla -60\r\nKPX quoteright scommaaccent -60\r\nKPX quoteright space -80\r\nKPX quoteright v -20\r\nKPX r c -20\r\nKPX r cacute -20\r\nKPX r ccaron -20\r\nKPX r ccedilla -20\r\nKPX r comma -60\r\nKPX r d -20\r\nKPX r dcroat -20\r\nKPX r g -15\r\nKPX r gbreve -15\r\nKPX r gcommaaccent -15\r\nKPX r hyphen -20\r\nKPX r o -20\r\nKPX r oacute -20\r\nKPX r ocircumflex -20\r\nKPX r odieresis -20\r\nKPX r ograve -20\r\nKPX r ohungarumlaut -20\r\nKPX r omacron -20\r\nKPX r oslash -20\r\nKPX r otilde -20\r\nKPX r period -60\r\nKPX r q -20\r\nKPX r s -15\r\nKPX r sacute -15\r\nKPX r scaron -15\r\nKPX r scedilla -15\r\nKPX r scommaaccent -15\r\nKPX r t 20\r\nKPX r tcommaaccent 20\r\nKPX r v 10\r\nKPX r y 10\r\nKPX r yacute 10\r\nKPX r ydieresis 10\r\nKPX racute c -20\r\nKPX racute cacute -20\r\nKPX racute ccaron -20\r\nKPX racute ccedilla -20\r\nKPX racute comma -60\r\nKPX racute d -20\r\nKPX racute dcroat -20\r\nKPX racute g -15\r\nKPX racute gbreve -15\r\nKPX racute gcommaaccent -15\r\nKPX racute hyphen -20\r\nKPX racute o -20\r\nKPX racute oacute -20\r\nKPX racute ocircumflex -20\r\nKPX racute odieresis -20\r\nKPX racute ograve -20\r\nKPX racute ohungarumlaut -20\r\nKPX racute omacron -20\r\nKPX racute oslash -20\r\nKPX racute otilde -20\r\nKPX racute period -60\r\nKPX racute q -20\r\nKPX racute s -15\r\nKPX racute sacute -15\r\nKPX racute scaron -15\r\nKPX racute scedilla -15\r\nKPX racute scommaaccent -15\r\nKPX racute t 20\r\nKPX racute tcommaaccent 20\r\nKPX racute v 10\r\nKPX racute y 10\r\nKPX racute yacute 10\r\nKPX racute ydieresis 10\r\nKPX rcaron c -20\r\nKPX rcaron cacute -20\r\nKPX rcaron ccaron -20\r\nKPX rcaron ccedilla -20\r\nKPX rcaron comma -60\r\nKPX rcaron d -20\r\nKPX rcaron dcroat -20\r\nKPX rcaron g -15\r\nKPX rcaron gbreve -15\r\nKPX rcaron gcommaaccent -15\r\nKPX rcaron hyphen -20\r\nKPX rcaron o -20\r\nKPX rcaron oacute -20\r\nKPX rcaron ocircumflex -20\r\nKPX rcaron odieresis -20\r\nKPX rcaron ograve -20\r\nKPX rcaron ohungarumlaut -20\r\nKPX rcaron omacron -20\r\nKPX rcaron oslash -20\r\nKPX rcaron otilde -20\r\nKPX rcaron period -60\r\nKPX rcaron q -20\r\nKPX rcaron s -15\r\nKPX rcaron sacute -15\r\nKPX rcaron scaron -15\r\nKPX rcaron scedilla -15\r\nKPX rcaron scommaaccent -15\r\nKPX rcaron t 20\r\nKPX rcaron tcommaaccent 20\r\nKPX rcaron v 10\r\nKPX rcaron y 10\r\nKPX rcaron yacute 10\r\nKPX rcaron ydieresis 10\r\nKPX rcommaaccent c -20\r\nKPX rcommaaccent cacute -20\r\nKPX rcommaaccent ccaron -20\r\nKPX rcommaaccent ccedilla -20\r\nKPX rcommaaccent comma -60\r\nKPX rcommaaccent d -20\r\nKPX rcommaaccent dcroat -20\r\nKPX rcommaaccent g -15\r\nKPX rcommaaccent gbreve -15\r\nKPX rcommaaccent gcommaaccent -15\r\nKPX rcommaaccent hyphen -20\r\nKPX rcommaaccent o -20\r\nKPX rcommaaccent oacute -20\r\nKPX rcommaaccent ocircumflex -20\r\nKPX rcommaaccent odieresis -20\r\nKPX rcommaaccent ograve -20\r\nKPX rcommaaccent ohungarumlaut -20\r\nKPX rcommaaccent omacron -20\r\nKPX rcommaaccent oslash -20\r\nKPX rcommaaccent otilde -20\r\nKPX rcommaaccent period -60\r\nKPX rcommaaccent q -20\r\nKPX rcommaaccent s -15\r\nKPX rcommaaccent sacute -15\r\nKPX rcommaaccent scaron -15\r\nKPX rcommaaccent scedilla -15\r\nKPX rcommaaccent scommaaccent -15\r\nKPX rcommaaccent t 20\r\nKPX rcommaaccent tcommaaccent 20\r\nKPX rcommaaccent v 10\r\nKPX rcommaaccent y 10\r\nKPX rcommaaccent yacute 10\r\nKPX rcommaaccent ydieresis 10\r\nKPX s w -15\r\nKPX sacute w -15\r\nKPX scaron w -15\r\nKPX scedilla w -15\r\nKPX scommaaccent w -15\r\nKPX semicolon space -40\r\nKPX space T -100\r\nKPX space Tcaron -100\r\nKPX space Tcommaaccent -100\r\nKPX space V -80\r\nKPX space W -80\r\nKPX space Y -120\r\nKPX space Yacute -120\r\nKPX space Ydieresis -120\r\nKPX space quotedblleft -80\r\nKPX space quoteleft -60\r\nKPX v a -20\r\nKPX v aacute -20\r\nKPX v abreve -20\r\nKPX v acircumflex -20\r\nKPX v adieresis -20\r\nKPX v agrave -20\r\nKPX v amacron -20\r\nKPX v aogonek -20\r\nKPX v aring -20\r\nKPX v atilde -20\r\nKPX v comma -80\r\nKPX v o -30\r\nKPX v oacute -30\r\nKPX v ocircumflex -30\r\nKPX v odieresis -30\r\nKPX v ograve -30\r\nKPX v ohungarumlaut -30\r\nKPX v omacron -30\r\nKPX v oslash -30\r\nKPX v otilde -30\r\nKPX v period -80\r\nKPX w comma -40\r\nKPX w o -20\r\nKPX w oacute -20\r\nKPX w ocircumflex -20\r\nKPX w odieresis -20\r\nKPX w ograve -20\r\nKPX w ohungarumlaut -20\r\nKPX w omacron -20\r\nKPX w oslash -20\r\nKPX w otilde -20\r\nKPX w period -40\r\nKPX x e -10\r\nKPX x eacute -10\r\nKPX x ecaron -10\r\nKPX x ecircumflex -10\r\nKPX x edieresis -10\r\nKPX x edotaccent -10\r\nKPX x egrave -10\r\nKPX x emacron -10\r\nKPX x eogonek -10\r\nKPX y a -30\r\nKPX y aacute -30\r\nKPX y abreve -30\r\nKPX y acircumflex -30\r\nKPX y adieresis -30\r\nKPX y agrave -30\r\nKPX y amacron -30\r\nKPX y aogonek -30\r\nKPX y aring -30\r\nKPX y atilde -30\r\nKPX y comma -80\r\nKPX y e -10\r\nKPX y eacute -10\r\nKPX y ecaron -10\r\nKPX y ecircumflex -10\r\nKPX y edieresis -10\r\nKPX y edotaccent -10\r\nKPX y egrave -10\r\nKPX y emacron -10\r\nKPX y eogonek -10\r\nKPX y o -25\r\nKPX y oacute -25\r\nKPX y ocircumflex -25\r\nKPX y odieresis -25\r\nKPX y ograve -25\r\nKPX y ohungarumlaut -25\r\nKPX y omacron -25\r\nKPX y oslash -25\r\nKPX y otilde -25\r\nKPX y period -80\r\nKPX yacute a -30\r\nKPX yacute aacute -30\r\nKPX yacute abreve -30\r\nKPX yacute acircumflex -30\r\nKPX yacute adieresis -30\r\nKPX yacute agrave -30\r\nKPX yacute amacron -30\r\nKPX yacute aogonek -30\r\nKPX yacute aring -30\r\nKPX yacute atilde -30\r\nKPX yacute comma -80\r\nKPX yacute e -10\r\nKPX yacute eacute -10\r\nKPX yacute ecaron -10\r\nKPX yacute ecircumflex -10\r\nKPX yacute edieresis -10\r\nKPX yacute edotaccent -10\r\nKPX yacute egrave -10\r\nKPX yacute emacron -10\r\nKPX yacute eogonek -10\r\nKPX yacute o -25\r\nKPX yacute oacute -25\r\nKPX yacute ocircumflex -25\r\nKPX yacute odieresis -25\r\nKPX yacute ograve -25\r\nKPX yacute ohungarumlaut -25\r\nKPX yacute omacron -25\r\nKPX yacute oslash -25\r\nKPX yacute otilde -25\r\nKPX yacute period -80\r\nKPX ydieresis a -30\r\nKPX ydieresis aacute -30\r\nKPX ydieresis abreve -30\r\nKPX ydieresis acircumflex -30\r\nKPX ydieresis adieresis -30\r\nKPX ydieresis agrave -30\r\nKPX ydieresis amacron -30\r\nKPX ydieresis aogonek -30\r\nKPX ydieresis aring -30\r\nKPX ydieresis atilde -30\r\nKPX ydieresis comma -80\r\nKPX ydieresis e -10\r\nKPX ydieresis eacute -10\r\nKPX ydieresis ecaron -10\r\nKPX ydieresis ecircumflex -10\r\nKPX ydieresis edieresis -10\r\nKPX ydieresis edotaccent -10\r\nKPX ydieresis egrave -10\r\nKPX ydieresis emacron -10\r\nKPX ydieresis eogonek -10\r\nKPX ydieresis o -25\r\nKPX ydieresis oacute -25\r\nKPX ydieresis ocircumflex -25\r\nKPX ydieresis odieresis -25\r\nKPX ydieresis ograve -25\r\nKPX ydieresis ohungarumlaut -25\r\nKPX ydieresis omacron -25\r\nKPX ydieresis oslash -25\r\nKPX ydieresis otilde -25\r\nKPX ydieresis period -80\r\nKPX z e 10\r\nKPX z eacute 10\r\nKPX z ecaron 10\r\nKPX z ecircumflex 10\r\nKPX z edieresis 10\r\nKPX z edotaccent 10\r\nKPX z egrave 10\r\nKPX z emacron 10\r\nKPX z eogonek 10\r\nKPX zacute e 10\r\nKPX zacute eacute 10\r\nKPX zacute ecaron 10\r\nKPX zacute ecircumflex 10\r\nKPX zacute edieresis 10\r\nKPX zacute edotaccent 10\r\nKPX zacute egrave 10\r\nKPX zacute emacron 10\r\nKPX zacute eogonek 10\r\nKPX zcaron e 10\r\nKPX zcaron eacute 10\r\nKPX zcaron ecaron 10\r\nKPX zcaron ecircumflex 10\r\nKPX zcaron edieresis 10\r\nKPX zcaron edotaccent 10\r\nKPX zcaron egrave 10\r\nKPX zcaron emacron 10\r\nKPX zcaron eogonek 10\r\nKPX zdotaccent e 10\r\nKPX zdotaccent eacute 10\r\nKPX zdotaccent ecaron 10\r\nKPX zdotaccent ecircumflex 10\r\nKPX zdotaccent edieresis 10\r\nKPX zdotaccent edotaccent 10\r\nKPX zdotaccent egrave 10\r\nKPX zdotaccent emacron 10\r\nKPX zdotaccent eogonek 10\r\nEndKernPairs\r\nEndKernData\r\nEndFontMetrics\r\n";
  },
  'Times-Roman'() {
    return "StartFontMetrics 4.1\r\nComment Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.\r\nComment Creation Date: Thu May  1 12:49:17 1997\r\nComment UniqueID 43068\r\nComment VMusage 43909 54934\r\nFontName Times-Roman\r\nFullName Times Roman\r\nFamilyName Times\r\nWeight Roman\r\nItalicAngle 0\r\nIsFixedPitch false\r\nCharacterSet ExtendedRoman\r\nFontBBox -168 -218 1000 898 \r\nUnderlinePosition -100\r\nUnderlineThickness 50\r\nVersion 002.000\r\nNotice Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.Times is a trademark of Linotype-Hell AG and/or its subsidiaries.\r\nEncodingScheme AdobeStandardEncoding\r\nCapHeight 662\r\nXHeight 450\r\nAscender 683\r\nDescender -217\r\nStdHW 28\r\nStdVW 84\r\nStartCharMetrics 315\r\nC 32 ; WX 250 ; N space ; B 0 0 0 0 ;\r\nC 33 ; WX 333 ; N exclam ; B 130 -9 238 676 ;\r\nC 34 ; WX 408 ; N quotedbl ; B 77 431 331 676 ;\r\nC 35 ; WX 500 ; N numbersign ; B 5 0 496 662 ;\r\nC 36 ; WX 500 ; N dollar ; B 44 -87 457 727 ;\r\nC 37 ; WX 833 ; N percent ; B 61 -13 772 676 ;\r\nC 38 ; WX 778 ; N ampersand ; B 42 -13 750 676 ;\r\nC 39 ; WX 333 ; N quoteright ; B 79 433 218 676 ;\r\nC 40 ; WX 333 ; N parenleft ; B 48 -177 304 676 ;\r\nC 41 ; WX 333 ; N parenright ; B 29 -177 285 676 ;\r\nC 42 ; WX 500 ; N asterisk ; B 69 265 432 676 ;\r\nC 43 ; WX 564 ; N plus ; B 30 0 534 506 ;\r\nC 44 ; WX 250 ; N comma ; B 56 -141 195 102 ;\r\nC 45 ; WX 333 ; N hyphen ; B 39 194 285 257 ;\r\nC 46 ; WX 250 ; N period ; B 70 -11 181 100 ;\r\nC 47 ; WX 278 ; N slash ; B -9 -14 287 676 ;\r\nC 48 ; WX 500 ; N zero ; B 24 -14 476 676 ;\r\nC 49 ; WX 500 ; N one ; B 111 0 394 676 ;\r\nC 50 ; WX 500 ; N two ; B 30 0 475 676 ;\r\nC 51 ; WX 500 ; N three ; B 43 -14 431 676 ;\r\nC 52 ; WX 500 ; N four ; B 12 0 472 676 ;\r\nC 53 ; WX 500 ; N five ; B 32 -14 438 688 ;\r\nC 54 ; WX 500 ; N six ; B 34 -14 468 684 ;\r\nC 55 ; WX 500 ; N seven ; B 20 -8 449 662 ;\r\nC 56 ; WX 500 ; N eight ; B 56 -14 445 676 ;\r\nC 57 ; WX 500 ; N nine ; B 30 -22 459 676 ;\r\nC 58 ; WX 278 ; N colon ; B 81 -11 192 459 ;\r\nC 59 ; WX 278 ; N semicolon ; B 80 -141 219 459 ;\r\nC 60 ; WX 564 ; N less ; B 28 -8 536 514 ;\r\nC 61 ; WX 564 ; N equal ; B 30 120 534 386 ;\r\nC 62 ; WX 564 ; N greater ; B 28 -8 536 514 ;\r\nC 63 ; WX 444 ; N question ; B 68 -8 414 676 ;\r\nC 64 ; WX 921 ; N at ; B 116 -14 809 676 ;\r\nC 65 ; WX 722 ; N A ; B 15 0 706 674 ;\r\nC 66 ; WX 667 ; N B ; B 17 0 593 662 ;\r\nC 67 ; WX 667 ; N C ; B 28 -14 633 676 ;\r\nC 68 ; WX 722 ; N D ; B 16 0 685 662 ;\r\nC 69 ; WX 611 ; N E ; B 12 0 597 662 ;\r\nC 70 ; WX 556 ; N F ; B 12 0 546 662 ;\r\nC 71 ; WX 722 ; N G ; B 32 -14 709 676 ;\r\nC 72 ; WX 722 ; N H ; B 19 0 702 662 ;\r\nC 73 ; WX 333 ; N I ; B 18 0 315 662 ;\r\nC 74 ; WX 389 ; N J ; B 10 -14 370 662 ;\r\nC 75 ; WX 722 ; N K ; B 34 0 723 662 ;\r\nC 76 ; WX 611 ; N L ; B 12 0 598 662 ;\r\nC 77 ; WX 889 ; N M ; B 12 0 863 662 ;\r\nC 78 ; WX 722 ; N N ; B 12 -11 707 662 ;\r\nC 79 ; WX 722 ; N O ; B 34 -14 688 676 ;\r\nC 80 ; WX 556 ; N P ; B 16 0 542 662 ;\r\nC 81 ; WX 722 ; N Q ; B 34 -178 701 676 ;\r\nC 82 ; WX 667 ; N R ; B 17 0 659 662 ;\r\nC 83 ; WX 556 ; N S ; B 42 -14 491 676 ;\r\nC 84 ; WX 611 ; N T ; B 17 0 593 662 ;\r\nC 85 ; WX 722 ; N U ; B 14 -14 705 662 ;\r\nC 86 ; WX 722 ; N V ; B 16 -11 697 662 ;\r\nC 87 ; WX 944 ; N W ; B 5 -11 932 662 ;\r\nC 88 ; WX 722 ; N X ; B 10 0 704 662 ;\r\nC 89 ; WX 722 ; N Y ; B 22 0 703 662 ;\r\nC 90 ; WX 611 ; N Z ; B 9 0 597 662 ;\r\nC 91 ; WX 333 ; N bracketleft ; B 88 -156 299 662 ;\r\nC 92 ; WX 278 ; N backslash ; B -9 -14 287 676 ;\r\nC 93 ; WX 333 ; N bracketright ; B 34 -156 245 662 ;\r\nC 94 ; WX 469 ; N asciicircum ; B 24 297 446 662 ;\r\nC 95 ; WX 500 ; N underscore ; B 0 -125 500 -75 ;\r\nC 96 ; WX 333 ; N quoteleft ; B 115 433 254 676 ;\r\nC 97 ; WX 444 ; N a ; B 37 -10 442 460 ;\r\nC 98 ; WX 500 ; N b ; B 3 -10 468 683 ;\r\nC 99 ; WX 444 ; N c ; B 25 -10 412 460 ;\r\nC 100 ; WX 500 ; N d ; B 27 -10 491 683 ;\r\nC 101 ; WX 444 ; N e ; B 25 -10 424 460 ;\r\nC 102 ; WX 333 ; N f ; B 20 0 383 683 ; L i fi ; L l fl ;\r\nC 103 ; WX 500 ; N g ; B 28 -218 470 460 ;\r\nC 104 ; WX 500 ; N h ; B 9 0 487 683 ;\r\nC 105 ; WX 278 ; N i ; B 16 0 253 683 ;\r\nC 106 ; WX 278 ; N j ; B -70 -218 194 683 ;\r\nC 107 ; WX 500 ; N k ; B 7 0 505 683 ;\r\nC 108 ; WX 278 ; N l ; B 19 0 257 683 ;\r\nC 109 ; WX 778 ; N m ; B 16 0 775 460 ;\r\nC 110 ; WX 500 ; N n ; B 16 0 485 460 ;\r\nC 111 ; WX 500 ; N o ; B 29 -10 470 460 ;\r\nC 112 ; WX 500 ; N p ; B 5 -217 470 460 ;\r\nC 113 ; WX 500 ; N q ; B 24 -217 488 460 ;\r\nC 114 ; WX 333 ; N r ; B 5 0 335 460 ;\r\nC 115 ; WX 389 ; N s ; B 51 -10 348 460 ;\r\nC 116 ; WX 278 ; N t ; B 13 -10 279 579 ;\r\nC 117 ; WX 500 ; N u ; B 9 -10 479 450 ;\r\nC 118 ; WX 500 ; N v ; B 19 -14 477 450 ;\r\nC 119 ; WX 722 ; N w ; B 21 -14 694 450 ;\r\nC 120 ; WX 500 ; N x ; B 17 0 479 450 ;\r\nC 121 ; WX 500 ; N y ; B 14 -218 475 450 ;\r\nC 122 ; WX 444 ; N z ; B 27 0 418 450 ;\r\nC 123 ; WX 480 ; N braceleft ; B 100 -181 350 680 ;\r\nC 124 ; WX 200 ; N bar ; B 67 -218 133 782 ;\r\nC 125 ; WX 480 ; N braceright ; B 130 -181 380 680 ;\r\nC 126 ; WX 541 ; N asciitilde ; B 40 183 502 323 ;\r\nC 161 ; WX 333 ; N exclamdown ; B 97 -218 205 467 ;\r\nC 162 ; WX 500 ; N cent ; B 53 -138 448 579 ;\r\nC 163 ; WX 500 ; N sterling ; B 12 -8 490 676 ;\r\nC 164 ; WX 167 ; N fraction ; B -168 -14 331 676 ;\r\nC 165 ; WX 500 ; N yen ; B -53 0 512 662 ;\r\nC 166 ; WX 500 ; N florin ; B 7 -189 490 676 ;\r\nC 167 ; WX 500 ; N section ; B 70 -148 426 676 ;\r\nC 168 ; WX 500 ; N currency ; B -22 58 522 602 ;\r\nC 169 ; WX 180 ; N quotesingle ; B 48 431 133 676 ;\r\nC 170 ; WX 444 ; N quotedblleft ; B 43 433 414 676 ;\r\nC 171 ; WX 500 ; N guillemotleft ; B 42 33 456 416 ;\r\nC 172 ; WX 333 ; N guilsinglleft ; B 63 33 285 416 ;\r\nC 173 ; WX 333 ; N guilsinglright ; B 48 33 270 416 ;\r\nC 174 ; WX 556 ; N fi ; B 31 0 521 683 ;\r\nC 175 ; WX 556 ; N fl ; B 32 0 521 683 ;\r\nC 177 ; WX 500 ; N endash ; B 0 201 500 250 ;\r\nC 178 ; WX 500 ; N dagger ; B 59 -149 442 676 ;\r\nC 179 ; WX 500 ; N daggerdbl ; B 58 -153 442 676 ;\r\nC 180 ; WX 250 ; N periodcentered ; B 70 199 181 310 ;\r\nC 182 ; WX 453 ; N paragraph ; B -22 -154 450 662 ;\r\nC 183 ; WX 350 ; N bullet ; B 40 196 310 466 ;\r\nC 184 ; WX 333 ; N quotesinglbase ; B 79 -141 218 102 ;\r\nC 185 ; WX 444 ; N quotedblbase ; B 45 -141 416 102 ;\r\nC 186 ; WX 444 ; N quotedblright ; B 30 433 401 676 ;\r\nC 187 ; WX 500 ; N guillemotright ; B 44 33 458 416 ;\r\nC 188 ; WX 1000 ; N ellipsis ; B 111 -11 888 100 ;\r\nC 189 ; WX 1000 ; N perthousand ; B 7 -19 994 706 ;\r\nC 191 ; WX 444 ; N questiondown ; B 30 -218 376 466 ;\r\nC 193 ; WX 333 ; N grave ; B 19 507 242 678 ;\r\nC 194 ; WX 333 ; N acute ; B 93 507 317 678 ;\r\nC 195 ; WX 333 ; N circumflex ; B 11 507 322 674 ;\r\nC 196 ; WX 333 ; N tilde ; B 1 532 331 638 ;\r\nC 197 ; WX 333 ; N macron ; B 11 547 322 601 ;\r\nC 198 ; WX 333 ; N breve ; B 26 507 307 664 ;\r\nC 199 ; WX 333 ; N dotaccent ; B 118 581 216 681 ;\r\nC 200 ; WX 333 ; N dieresis ; B 18 581 315 681 ;\r\nC 202 ; WX 333 ; N ring ; B 67 512 266 711 ;\r\nC 203 ; WX 333 ; N cedilla ; B 52 -215 261 0 ;\r\nC 205 ; WX 333 ; N hungarumlaut ; B -3 507 377 678 ;\r\nC 206 ; WX 333 ; N ogonek ; B 62 -165 243 0 ;\r\nC 207 ; WX 333 ; N caron ; B 11 507 322 674 ;\r\nC 208 ; WX 1000 ; N emdash ; B 0 201 1000 250 ;\r\nC 225 ; WX 889 ; N AE ; B 0 0 863 662 ;\r\nC 227 ; WX 276 ; N ordfeminine ; B 4 394 270 676 ;\r\nC 232 ; WX 611 ; N Lslash ; B 12 0 598 662 ;\r\nC 233 ; WX 722 ; N Oslash ; B 34 -80 688 734 ;\r\nC 234 ; WX 889 ; N OE ; B 30 -6 885 668 ;\r\nC 235 ; WX 310 ; N ordmasculine ; B 6 394 304 676 ;\r\nC 241 ; WX 667 ; N ae ; B 38 -10 632 460 ;\r\nC 245 ; WX 278 ; N dotlessi ; B 16 0 253 460 ;\r\nC 248 ; WX 278 ; N lslash ; B 19 0 259 683 ;\r\nC 249 ; WX 500 ; N oslash ; B 29 -112 470 551 ;\r\nC 250 ; WX 722 ; N oe ; B 30 -10 690 460 ;\r\nC 251 ; WX 500 ; N germandbls ; B 12 -9 468 683 ;\r\nC -1 ; WX 333 ; N Idieresis ; B 18 0 315 835 ;\r\nC -1 ; WX 444 ; N eacute ; B 25 -10 424 678 ;\r\nC -1 ; WX 444 ; N abreve ; B 37 -10 442 664 ;\r\nC -1 ; WX 500 ; N uhungarumlaut ; B 9 -10 501 678 ;\r\nC -1 ; WX 444 ; N ecaron ; B 25 -10 424 674 ;\r\nC -1 ; WX 722 ; N Ydieresis ; B 22 0 703 835 ;\r\nC -1 ; WX 564 ; N divide ; B 30 -10 534 516 ;\r\nC -1 ; WX 722 ; N Yacute ; B 22 0 703 890 ;\r\nC -1 ; WX 722 ; N Acircumflex ; B 15 0 706 886 ;\r\nC -1 ; WX 444 ; N aacute ; B 37 -10 442 678 ;\r\nC -1 ; WX 722 ; N Ucircumflex ; B 14 -14 705 886 ;\r\nC -1 ; WX 500 ; N yacute ; B 14 -218 475 678 ;\r\nC -1 ; WX 389 ; N scommaaccent ; B 51 -218 348 460 ;\r\nC -1 ; WX 444 ; N ecircumflex ; B 25 -10 424 674 ;\r\nC -1 ; WX 722 ; N Uring ; B 14 -14 705 898 ;\r\nC -1 ; WX 722 ; N Udieresis ; B 14 -14 705 835 ;\r\nC -1 ; WX 444 ; N aogonek ; B 37 -165 469 460 ;\r\nC -1 ; WX 722 ; N Uacute ; B 14 -14 705 890 ;\r\nC -1 ; WX 500 ; N uogonek ; B 9 -155 487 450 ;\r\nC -1 ; WX 611 ; N Edieresis ; B 12 0 597 835 ;\r\nC -1 ; WX 722 ; N Dcroat ; B 16 0 685 662 ;\r\nC -1 ; WX 250 ; N commaaccent ; B 59 -218 184 -50 ;\r\nC -1 ; WX 760 ; N copyright ; B 38 -14 722 676 ;\r\nC -1 ; WX 611 ; N Emacron ; B 12 0 597 813 ;\r\nC -1 ; WX 444 ; N ccaron ; B 25 -10 412 674 ;\r\nC -1 ; WX 444 ; N aring ; B 37 -10 442 711 ;\r\nC -1 ; WX 722 ; N Ncommaaccent ; B 12 -198 707 662 ;\r\nC -1 ; WX 278 ; N lacute ; B 19 0 290 890 ;\r\nC -1 ; WX 444 ; N agrave ; B 37 -10 442 678 ;\r\nC -1 ; WX 611 ; N Tcommaaccent ; B 17 -218 593 662 ;\r\nC -1 ; WX 667 ; N Cacute ; B 28 -14 633 890 ;\r\nC -1 ; WX 444 ; N atilde ; B 37 -10 442 638 ;\r\nC -1 ; WX 611 ; N Edotaccent ; B 12 0 597 835 ;\r\nC -1 ; WX 389 ; N scaron ; B 39 -10 350 674 ;\r\nC -1 ; WX 389 ; N scedilla ; B 51 -215 348 460 ;\r\nC -1 ; WX 278 ; N iacute ; B 16 0 290 678 ;\r\nC -1 ; WX 471 ; N lozenge ; B 13 0 459 724 ;\r\nC -1 ; WX 667 ; N Rcaron ; B 17 0 659 886 ;\r\nC -1 ; WX 722 ; N Gcommaaccent ; B 32 -218 709 676 ;\r\nC -1 ; WX 500 ; N ucircumflex ; B 9 -10 479 674 ;\r\nC -1 ; WX 444 ; N acircumflex ; B 37 -10 442 674 ;\r\nC -1 ; WX 722 ; N Amacron ; B 15 0 706 813 ;\r\nC -1 ; WX 333 ; N rcaron ; B 5 0 335 674 ;\r\nC -1 ; WX 444 ; N ccedilla ; B 25 -215 412 460 ;\r\nC -1 ; WX 611 ; N Zdotaccent ; B 9 0 597 835 ;\r\nC -1 ; WX 556 ; N Thorn ; B 16 0 542 662 ;\r\nC -1 ; WX 722 ; N Omacron ; B 34 -14 688 813 ;\r\nC -1 ; WX 667 ; N Racute ; B 17 0 659 890 ;\r\nC -1 ; WX 556 ; N Sacute ; B 42 -14 491 890 ;\r\nC -1 ; WX 588 ; N dcaron ; B 27 -10 589 695 ;\r\nC -1 ; WX 722 ; N Umacron ; B 14 -14 705 813 ;\r\nC -1 ; WX 500 ; N uring ; B 9 -10 479 711 ;\r\nC -1 ; WX 300 ; N threesuperior ; B 15 262 291 676 ;\r\nC -1 ; WX 722 ; N Ograve ; B 34 -14 688 890 ;\r\nC -1 ; WX 722 ; N Agrave ; B 15 0 706 890 ;\r\nC -1 ; WX 722 ; N Abreve ; B 15 0 706 876 ;\r\nC -1 ; WX 564 ; N multiply ; B 38 8 527 497 ;\r\nC -1 ; WX 500 ; N uacute ; B 9 -10 479 678 ;\r\nC -1 ; WX 611 ; N Tcaron ; B 17 0 593 886 ;\r\nC -1 ; WX 476 ; N partialdiff ; B 17 -38 459 710 ;\r\nC -1 ; WX 500 ; N ydieresis ; B 14 -218 475 623 ;\r\nC -1 ; WX 722 ; N Nacute ; B 12 -11 707 890 ;\r\nC -1 ; WX 278 ; N icircumflex ; B -16 0 295 674 ;\r\nC -1 ; WX 611 ; N Ecircumflex ; B 12 0 597 886 ;\r\nC -1 ; WX 444 ; N adieresis ; B 37 -10 442 623 ;\r\nC -1 ; WX 444 ; N edieresis ; B 25 -10 424 623 ;\r\nC -1 ; WX 444 ; N cacute ; B 25 -10 413 678 ;\r\nC -1 ; WX 500 ; N nacute ; B 16 0 485 678 ;\r\nC -1 ; WX 500 ; N umacron ; B 9 -10 479 601 ;\r\nC -1 ; WX 722 ; N Ncaron ; B 12 -11 707 886 ;\r\nC -1 ; WX 333 ; N Iacute ; B 18 0 317 890 ;\r\nC -1 ; WX 564 ; N plusminus ; B 30 0 534 506 ;\r\nC -1 ; WX 200 ; N brokenbar ; B 67 -143 133 707 ;\r\nC -1 ; WX 760 ; N registered ; B 38 -14 722 676 ;\r\nC -1 ; WX 722 ; N Gbreve ; B 32 -14 709 876 ;\r\nC -1 ; WX 333 ; N Idotaccent ; B 18 0 315 835 ;\r\nC -1 ; WX 600 ; N summation ; B 15 -10 585 706 ;\r\nC -1 ; WX 611 ; N Egrave ; B 12 0 597 890 ;\r\nC -1 ; WX 333 ; N racute ; B 5 0 335 678 ;\r\nC -1 ; WX 500 ; N omacron ; B 29 -10 470 601 ;\r\nC -1 ; WX 611 ; N Zacute ; B 9 0 597 890 ;\r\nC -1 ; WX 611 ; N Zcaron ; B 9 0 597 886 ;\r\nC -1 ; WX 549 ; N greaterequal ; B 26 0 523 666 ;\r\nC -1 ; WX 722 ; N Eth ; B 16 0 685 662 ;\r\nC -1 ; WX 667 ; N Ccedilla ; B 28 -215 633 676 ;\r\nC -1 ; WX 278 ; N lcommaaccent ; B 19 -218 257 683 ;\r\nC -1 ; WX 326 ; N tcaron ; B 13 -10 318 722 ;\r\nC -1 ; WX 444 ; N eogonek ; B 25 -165 424 460 ;\r\nC -1 ; WX 722 ; N Uogonek ; B 14 -165 705 662 ;\r\nC -1 ; WX 722 ; N Aacute ; B 15 0 706 890 ;\r\nC -1 ; WX 722 ; N Adieresis ; B 15 0 706 835 ;\r\nC -1 ; WX 444 ; N egrave ; B 25 -10 424 678 ;\r\nC -1 ; WX 444 ; N zacute ; B 27 0 418 678 ;\r\nC -1 ; WX 278 ; N iogonek ; B 16 -165 265 683 ;\r\nC -1 ; WX 722 ; N Oacute ; B 34 -14 688 890 ;\r\nC -1 ; WX 500 ; N oacute ; B 29 -10 470 678 ;\r\nC -1 ; WX 444 ; N amacron ; B 37 -10 442 601 ;\r\nC -1 ; WX 389 ; N sacute ; B 51 -10 348 678 ;\r\nC -1 ; WX 278 ; N idieresis ; B -9 0 288 623 ;\r\nC -1 ; WX 722 ; N Ocircumflex ; B 34 -14 688 886 ;\r\nC -1 ; WX 722 ; N Ugrave ; B 14 -14 705 890 ;\r\nC -1 ; WX 612 ; N Delta ; B 6 0 608 688 ;\r\nC -1 ; WX 500 ; N thorn ; B 5 -217 470 683 ;\r\nC -1 ; WX 300 ; N twosuperior ; B 1 270 296 676 ;\r\nC -1 ; WX 722 ; N Odieresis ; B 34 -14 688 835 ;\r\nC -1 ; WX 500 ; N mu ; B 36 -218 512 450 ;\r\nC -1 ; WX 278 ; N igrave ; B -8 0 253 678 ;\r\nC -1 ; WX 500 ; N ohungarumlaut ; B 29 -10 491 678 ;\r\nC -1 ; WX 611 ; N Eogonek ; B 12 -165 597 662 ;\r\nC -1 ; WX 500 ; N dcroat ; B 27 -10 500 683 ;\r\nC -1 ; WX 750 ; N threequarters ; B 15 -14 718 676 ;\r\nC -1 ; WX 556 ; N Scedilla ; B 42 -215 491 676 ;\r\nC -1 ; WX 344 ; N lcaron ; B 19 0 347 695 ;\r\nC -1 ; WX 722 ; N Kcommaaccent ; B 34 -198 723 662 ;\r\nC -1 ; WX 611 ; N Lacute ; B 12 0 598 890 ;\r\nC -1 ; WX 980 ; N trademark ; B 30 256 957 662 ;\r\nC -1 ; WX 444 ; N edotaccent ; B 25 -10 424 623 ;\r\nC -1 ; WX 333 ; N Igrave ; B 18 0 315 890 ;\r\nC -1 ; WX 333 ; N Imacron ; B 11 0 322 813 ;\r\nC -1 ; WX 611 ; N Lcaron ; B 12 0 598 676 ;\r\nC -1 ; WX 750 ; N onehalf ; B 31 -14 746 676 ;\r\nC -1 ; WX 549 ; N lessequal ; B 26 0 523 666 ;\r\nC -1 ; WX 500 ; N ocircumflex ; B 29 -10 470 674 ;\r\nC -1 ; WX 500 ; N ntilde ; B 16 0 485 638 ;\r\nC -1 ; WX 722 ; N Uhungarumlaut ; B 14 -14 705 890 ;\r\nC -1 ; WX 611 ; N Eacute ; B 12 0 597 890 ;\r\nC -1 ; WX 444 ; N emacron ; B 25 -10 424 601 ;\r\nC -1 ; WX 500 ; N gbreve ; B 28 -218 470 664 ;\r\nC -1 ; WX 750 ; N onequarter ; B 37 -14 718 676 ;\r\nC -1 ; WX 556 ; N Scaron ; B 42 -14 491 886 ;\r\nC -1 ; WX 556 ; N Scommaaccent ; B 42 -218 491 676 ;\r\nC -1 ; WX 722 ; N Ohungarumlaut ; B 34 -14 688 890 ;\r\nC -1 ; WX 400 ; N degree ; B 57 390 343 676 ;\r\nC -1 ; WX 500 ; N ograve ; B 29 -10 470 678 ;\r\nC -1 ; WX 667 ; N Ccaron ; B 28 -14 633 886 ;\r\nC -1 ; WX 500 ; N ugrave ; B 9 -10 479 678 ;\r\nC -1 ; WX 453 ; N radical ; B 2 -60 452 768 ;\r\nC -1 ; WX 722 ; N Dcaron ; B 16 0 685 886 ;\r\nC -1 ; WX 333 ; N rcommaaccent ; B 5 -218 335 460 ;\r\nC -1 ; WX 722 ; N Ntilde ; B 12 -11 707 850 ;\r\nC -1 ; WX 500 ; N otilde ; B 29 -10 470 638 ;\r\nC -1 ; WX 667 ; N Rcommaaccent ; B 17 -198 659 662 ;\r\nC -1 ; WX 611 ; N Lcommaaccent ; B 12 -218 598 662 ;\r\nC -1 ; WX 722 ; N Atilde ; B 15 0 706 850 ;\r\nC -1 ; WX 722 ; N Aogonek ; B 15 -165 738 674 ;\r\nC -1 ; WX 722 ; N Aring ; B 15 0 706 898 ;\r\nC -1 ; WX 722 ; N Otilde ; B 34 -14 688 850 ;\r\nC -1 ; WX 444 ; N zdotaccent ; B 27 0 418 623 ;\r\nC -1 ; WX 611 ; N Ecaron ; B 12 0 597 886 ;\r\nC -1 ; WX 333 ; N Iogonek ; B 18 -165 315 662 ;\r\nC -1 ; WX 500 ; N kcommaaccent ; B 7 -218 505 683 ;\r\nC -1 ; WX 564 ; N minus ; B 30 220 534 286 ;\r\nC -1 ; WX 333 ; N Icircumflex ; B 11 0 322 886 ;\r\nC -1 ; WX 500 ; N ncaron ; B 16 0 485 674 ;\r\nC -1 ; WX 278 ; N tcommaaccent ; B 13 -218 279 579 ;\r\nC -1 ; WX 564 ; N logicalnot ; B 30 108 534 386 ;\r\nC -1 ; WX 500 ; N odieresis ; B 29 -10 470 623 ;\r\nC -1 ; WX 500 ; N udieresis ; B 9 -10 479 623 ;\r\nC -1 ; WX 549 ; N notequal ; B 12 -31 537 547 ;\r\nC -1 ; WX 500 ; N gcommaaccent ; B 28 -218 470 749 ;\r\nC -1 ; WX 500 ; N eth ; B 29 -10 471 686 ;\r\nC -1 ; WX 444 ; N zcaron ; B 27 0 418 674 ;\r\nC -1 ; WX 500 ; N ncommaaccent ; B 16 -218 485 460 ;\r\nC -1 ; WX 300 ; N onesuperior ; B 57 270 248 676 ;\r\nC -1 ; WX 278 ; N imacron ; B 6 0 271 601 ;\r\nC -1 ; WX 500 ; N Euro ; B 0 0 0 0 ;\r\nEndCharMetrics\r\nStartKernData\r\nStartKernPairs 2073\r\nKPX A C -40\r\nKPX A Cacute -40\r\nKPX A Ccaron -40\r\nKPX A Ccedilla -40\r\nKPX A G -40\r\nKPX A Gbreve -40\r\nKPX A Gcommaaccent -40\r\nKPX A O -55\r\nKPX A Oacute -55\r\nKPX A Ocircumflex -55\r\nKPX A Odieresis -55\r\nKPX A Ograve -55\r\nKPX A Ohungarumlaut -55\r\nKPX A Omacron -55\r\nKPX A Oslash -55\r\nKPX A Otilde -55\r\nKPX A Q -55\r\nKPX A T -111\r\nKPX A Tcaron -111\r\nKPX A Tcommaaccent -111\r\nKPX A U -55\r\nKPX A Uacute -55\r\nKPX A Ucircumflex -55\r\nKPX A Udieresis -55\r\nKPX A Ugrave -55\r\nKPX A Uhungarumlaut -55\r\nKPX A Umacron -55\r\nKPX A Uogonek -55\r\nKPX A Uring -55\r\nKPX A V -135\r\nKPX A W -90\r\nKPX A Y -105\r\nKPX A Yacute -105\r\nKPX A Ydieresis -105\r\nKPX A quoteright -111\r\nKPX A v -74\r\nKPX A w -92\r\nKPX A y -92\r\nKPX A yacute -92\r\nKPX A ydieresis -92\r\nKPX Aacute C -40\r\nKPX Aacute Cacute -40\r\nKPX Aacute Ccaron -40\r\nKPX Aacute Ccedilla -40\r\nKPX Aacute G -40\r\nKPX Aacute Gbreve -40\r\nKPX Aacute Gcommaaccent -40\r\nKPX Aacute O -55\r\nKPX Aacute Oacute -55\r\nKPX Aacute Ocircumflex -55\r\nKPX Aacute Odieresis -55\r\nKPX Aacute Ograve -55\r\nKPX Aacute Ohungarumlaut -55\r\nKPX Aacute Omacron -55\r\nKPX Aacute Oslash -55\r\nKPX Aacute Otilde -55\r\nKPX Aacute Q -55\r\nKPX Aacute T -111\r\nKPX Aacute Tcaron -111\r\nKPX Aacute Tcommaaccent -111\r\nKPX Aacute U -55\r\nKPX Aacute Uacute -55\r\nKPX Aacute Ucircumflex -55\r\nKPX Aacute Udieresis -55\r\nKPX Aacute Ugrave -55\r\nKPX Aacute Uhungarumlaut -55\r\nKPX Aacute Umacron -55\r\nKPX Aacute Uogonek -55\r\nKPX Aacute Uring -55\r\nKPX Aacute V -135\r\nKPX Aacute W -90\r\nKPX Aacute Y -105\r\nKPX Aacute Yacute -105\r\nKPX Aacute Ydieresis -105\r\nKPX Aacute quoteright -111\r\nKPX Aacute v -74\r\nKPX Aacute w -92\r\nKPX Aacute y -92\r\nKPX Aacute yacute -92\r\nKPX Aacute ydieresis -92\r\nKPX Abreve C -40\r\nKPX Abreve Cacute -40\r\nKPX Abreve Ccaron -40\r\nKPX Abreve Ccedilla -40\r\nKPX Abreve G -40\r\nKPX Abreve Gbreve -40\r\nKPX Abreve Gcommaaccent -40\r\nKPX Abreve O -55\r\nKPX Abreve Oacute -55\r\nKPX Abreve Ocircumflex -55\r\nKPX Abreve Odieresis -55\r\nKPX Abreve Ograve -55\r\nKPX Abreve Ohungarumlaut -55\r\nKPX Abreve Omacron -55\r\nKPX Abreve Oslash -55\r\nKPX Abreve Otilde -55\r\nKPX Abreve Q -55\r\nKPX Abreve T -111\r\nKPX Abreve Tcaron -111\r\nKPX Abreve Tcommaaccent -111\r\nKPX Abreve U -55\r\nKPX Abreve Uacute -55\r\nKPX Abreve Ucircumflex -55\r\nKPX Abreve Udieresis -55\r\nKPX Abreve Ugrave -55\r\nKPX Abreve Uhungarumlaut -55\r\nKPX Abreve Umacron -55\r\nKPX Abreve Uogonek -55\r\nKPX Abreve Uring -55\r\nKPX Abreve V -135\r\nKPX Abreve W -90\r\nKPX Abreve Y -105\r\nKPX Abreve Yacute -105\r\nKPX Abreve Ydieresis -105\r\nKPX Abreve quoteright -111\r\nKPX Abreve v -74\r\nKPX Abreve w -92\r\nKPX Abreve y -92\r\nKPX Abreve yacute -92\r\nKPX Abreve ydieresis -92\r\nKPX Acircumflex C -40\r\nKPX Acircumflex Cacute -40\r\nKPX Acircumflex Ccaron -40\r\nKPX Acircumflex Ccedilla -40\r\nKPX Acircumflex G -40\r\nKPX Acircumflex Gbreve -40\r\nKPX Acircumflex Gcommaaccent -40\r\nKPX Acircumflex O -55\r\nKPX Acircumflex Oacute -55\r\nKPX Acircumflex Ocircumflex -55\r\nKPX Acircumflex Odieresis -55\r\nKPX Acircumflex Ograve -55\r\nKPX Acircumflex Ohungarumlaut -55\r\nKPX Acircumflex Omacron -55\r\nKPX Acircumflex Oslash -55\r\nKPX Acircumflex Otilde -55\r\nKPX Acircumflex Q -55\r\nKPX Acircumflex T -111\r\nKPX Acircumflex Tcaron -111\r\nKPX Acircumflex Tcommaaccent -111\r\nKPX Acircumflex U -55\r\nKPX Acircumflex Uacute -55\r\nKPX Acircumflex Ucircumflex -55\r\nKPX Acircumflex Udieresis -55\r\nKPX Acircumflex Ugrave -55\r\nKPX Acircumflex Uhungarumlaut -55\r\nKPX Acircumflex Umacron -55\r\nKPX Acircumflex Uogonek -55\r\nKPX Acircumflex Uring -55\r\nKPX Acircumflex V -135\r\nKPX Acircumflex W -90\r\nKPX Acircumflex Y -105\r\nKPX Acircumflex Yacute -105\r\nKPX Acircumflex Ydieresis -105\r\nKPX Acircumflex quoteright -111\r\nKPX Acircumflex v -74\r\nKPX Acircumflex w -92\r\nKPX Acircumflex y -92\r\nKPX Acircumflex yacute -92\r\nKPX Acircumflex ydieresis -92\r\nKPX Adieresis C -40\r\nKPX Adieresis Cacute -40\r\nKPX Adieresis Ccaron -40\r\nKPX Adieresis Ccedilla -40\r\nKPX Adieresis G -40\r\nKPX Adieresis Gbreve -40\r\nKPX Adieresis Gcommaaccent -40\r\nKPX Adieresis O -55\r\nKPX Adieresis Oacute -55\r\nKPX Adieresis Ocircumflex -55\r\nKPX Adieresis Odieresis -55\r\nKPX Adieresis Ograve -55\r\nKPX Adieresis Ohungarumlaut -55\r\nKPX Adieresis Omacron -55\r\nKPX Adieresis Oslash -55\r\nKPX Adieresis Otilde -55\r\nKPX Adieresis Q -55\r\nKPX Adieresis T -111\r\nKPX Adieresis Tcaron -111\r\nKPX Adieresis Tcommaaccent -111\r\nKPX Adieresis U -55\r\nKPX Adieresis Uacute -55\r\nKPX Adieresis Ucircumflex -55\r\nKPX Adieresis Udieresis -55\r\nKPX Adieresis Ugrave -55\r\nKPX Adieresis Uhungarumlaut -55\r\nKPX Adieresis Umacron -55\r\nKPX Adieresis Uogonek -55\r\nKPX Adieresis Uring -55\r\nKPX Adieresis V -135\r\nKPX Adieresis W -90\r\nKPX Adieresis Y -105\r\nKPX Adieresis Yacute -105\r\nKPX Adieresis Ydieresis -105\r\nKPX Adieresis quoteright -111\r\nKPX Adieresis v -74\r\nKPX Adieresis w -92\r\nKPX Adieresis y -92\r\nKPX Adieresis yacute -92\r\nKPX Adieresis ydieresis -92\r\nKPX Agrave C -40\r\nKPX Agrave Cacute -40\r\nKPX Agrave Ccaron -40\r\nKPX Agrave Ccedilla -40\r\nKPX Agrave G -40\r\nKPX Agrave Gbreve -40\r\nKPX Agrave Gcommaaccent -40\r\nKPX Agrave O -55\r\nKPX Agrave Oacute -55\r\nKPX Agrave Ocircumflex -55\r\nKPX Agrave Odieresis -55\r\nKPX Agrave Ograve -55\r\nKPX Agrave Ohungarumlaut -55\r\nKPX Agrave Omacron -55\r\nKPX Agrave Oslash -55\r\nKPX Agrave Otilde -55\r\nKPX Agrave Q -55\r\nKPX Agrave T -111\r\nKPX Agrave Tcaron -111\r\nKPX Agrave Tcommaaccent -111\r\nKPX Agrave U -55\r\nKPX Agrave Uacute -55\r\nKPX Agrave Ucircumflex -55\r\nKPX Agrave Udieresis -55\r\nKPX Agrave Ugrave -55\r\nKPX Agrave Uhungarumlaut -55\r\nKPX Agrave Umacron -55\r\nKPX Agrave Uogonek -55\r\nKPX Agrave Uring -55\r\nKPX Agrave V -135\r\nKPX Agrave W -90\r\nKPX Agrave Y -105\r\nKPX Agrave Yacute -105\r\nKPX Agrave Ydieresis -105\r\nKPX Agrave quoteright -111\r\nKPX Agrave v -74\r\nKPX Agrave w -92\r\nKPX Agrave y -92\r\nKPX Agrave yacute -92\r\nKPX Agrave ydieresis -92\r\nKPX Amacron C -40\r\nKPX Amacron Cacute -40\r\nKPX Amacron Ccaron -40\r\nKPX Amacron Ccedilla -40\r\nKPX Amacron G -40\r\nKPX Amacron Gbreve -40\r\nKPX Amacron Gcommaaccent -40\r\nKPX Amacron O -55\r\nKPX Amacron Oacute -55\r\nKPX Amacron Ocircumflex -55\r\nKPX Amacron Odieresis -55\r\nKPX Amacron Ograve -55\r\nKPX Amacron Ohungarumlaut -55\r\nKPX Amacron Omacron -55\r\nKPX Amacron Oslash -55\r\nKPX Amacron Otilde -55\r\nKPX Amacron Q -55\r\nKPX Amacron T -111\r\nKPX Amacron Tcaron -111\r\nKPX Amacron Tcommaaccent -111\r\nKPX Amacron U -55\r\nKPX Amacron Uacute -55\r\nKPX Amacron Ucircumflex -55\r\nKPX Amacron Udieresis -55\r\nKPX Amacron Ugrave -55\r\nKPX Amacron Uhungarumlaut -55\r\nKPX Amacron Umacron -55\r\nKPX Amacron Uogonek -55\r\nKPX Amacron Uring -55\r\nKPX Amacron V -135\r\nKPX Amacron W -90\r\nKPX Amacron Y -105\r\nKPX Amacron Yacute -105\r\nKPX Amacron Ydieresis -105\r\nKPX Amacron quoteright -111\r\nKPX Amacron v -74\r\nKPX Amacron w -92\r\nKPX Amacron y -92\r\nKPX Amacron yacute -92\r\nKPX Amacron ydieresis -92\r\nKPX Aogonek C -40\r\nKPX Aogonek Cacute -40\r\nKPX Aogonek Ccaron -40\r\nKPX Aogonek Ccedilla -40\r\nKPX Aogonek G -40\r\nKPX Aogonek Gbreve -40\r\nKPX Aogonek Gcommaaccent -40\r\nKPX Aogonek O -55\r\nKPX Aogonek Oacute -55\r\nKPX Aogonek Ocircumflex -55\r\nKPX Aogonek Odieresis -55\r\nKPX Aogonek Ograve -55\r\nKPX Aogonek Ohungarumlaut -55\r\nKPX Aogonek Omacron -55\r\nKPX Aogonek Oslash -55\r\nKPX Aogonek Otilde -55\r\nKPX Aogonek Q -55\r\nKPX Aogonek T -111\r\nKPX Aogonek Tcaron -111\r\nKPX Aogonek Tcommaaccent -111\r\nKPX Aogonek U -55\r\nKPX Aogonek Uacute -55\r\nKPX Aogonek Ucircumflex -55\r\nKPX Aogonek Udieresis -55\r\nKPX Aogonek Ugrave -55\r\nKPX Aogonek Uhungarumlaut -55\r\nKPX Aogonek Umacron -55\r\nKPX Aogonek Uogonek -55\r\nKPX Aogonek Uring -55\r\nKPX Aogonek V -135\r\nKPX Aogonek W -90\r\nKPX Aogonek Y -105\r\nKPX Aogonek Yacute -105\r\nKPX Aogonek Ydieresis -105\r\nKPX Aogonek quoteright -111\r\nKPX Aogonek v -74\r\nKPX Aogonek w -52\r\nKPX Aogonek y -52\r\nKPX Aogonek yacute -52\r\nKPX Aogonek ydieresis -52\r\nKPX Aring C -40\r\nKPX Aring Cacute -40\r\nKPX Aring Ccaron -40\r\nKPX Aring Ccedilla -40\r\nKPX Aring G -40\r\nKPX Aring Gbreve -40\r\nKPX Aring Gcommaaccent -40\r\nKPX Aring O -55\r\nKPX Aring Oacute -55\r\nKPX Aring Ocircumflex -55\r\nKPX Aring Odieresis -55\r\nKPX Aring Ograve -55\r\nKPX Aring Ohungarumlaut -55\r\nKPX Aring Omacron -55\r\nKPX Aring Oslash -55\r\nKPX Aring Otilde -55\r\nKPX Aring Q -55\r\nKPX Aring T -111\r\nKPX Aring Tcaron -111\r\nKPX Aring Tcommaaccent -111\r\nKPX Aring U -55\r\nKPX Aring Uacute -55\r\nKPX Aring Ucircumflex -55\r\nKPX Aring Udieresis -55\r\nKPX Aring Ugrave -55\r\nKPX Aring Uhungarumlaut -55\r\nKPX Aring Umacron -55\r\nKPX Aring Uogonek -55\r\nKPX Aring Uring -55\r\nKPX Aring V -135\r\nKPX Aring W -90\r\nKPX Aring Y -105\r\nKPX Aring Yacute -105\r\nKPX Aring Ydieresis -105\r\nKPX Aring quoteright -111\r\nKPX Aring v -74\r\nKPX Aring w -92\r\nKPX Aring y -92\r\nKPX Aring yacute -92\r\nKPX Aring ydieresis -92\r\nKPX Atilde C -40\r\nKPX Atilde Cacute -40\r\nKPX Atilde Ccaron -40\r\nKPX Atilde Ccedilla -40\r\nKPX Atilde G -40\r\nKPX Atilde Gbreve -40\r\nKPX Atilde Gcommaaccent -40\r\nKPX Atilde O -55\r\nKPX Atilde Oacute -55\r\nKPX Atilde Ocircumflex -55\r\nKPX Atilde Odieresis -55\r\nKPX Atilde Ograve -55\r\nKPX Atilde Ohungarumlaut -55\r\nKPX Atilde Omacron -55\r\nKPX Atilde Oslash -55\r\nKPX Atilde Otilde -55\r\nKPX Atilde Q -55\r\nKPX Atilde T -111\r\nKPX Atilde Tcaron -111\r\nKPX Atilde Tcommaaccent -111\r\nKPX Atilde U -55\r\nKPX Atilde Uacute -55\r\nKPX Atilde Ucircumflex -55\r\nKPX Atilde Udieresis -55\r\nKPX Atilde Ugrave -55\r\nKPX Atilde Uhungarumlaut -55\r\nKPX Atilde Umacron -55\r\nKPX Atilde Uogonek -55\r\nKPX Atilde Uring -55\r\nKPX Atilde V -135\r\nKPX Atilde W -90\r\nKPX Atilde Y -105\r\nKPX Atilde Yacute -105\r\nKPX Atilde Ydieresis -105\r\nKPX Atilde quoteright -111\r\nKPX Atilde v -74\r\nKPX Atilde w -92\r\nKPX Atilde y -92\r\nKPX Atilde yacute -92\r\nKPX Atilde ydieresis -92\r\nKPX B A -35\r\nKPX B Aacute -35\r\nKPX B Abreve -35\r\nKPX B Acircumflex -35\r\nKPX B Adieresis -35\r\nKPX B Agrave -35\r\nKPX B Amacron -35\r\nKPX B Aogonek -35\r\nKPX B Aring -35\r\nKPX B Atilde -35\r\nKPX B U -10\r\nKPX B Uacute -10\r\nKPX B Ucircumflex -10\r\nKPX B Udieresis -10\r\nKPX B Ugrave -10\r\nKPX B Uhungarumlaut -10\r\nKPX B Umacron -10\r\nKPX B Uogonek -10\r\nKPX B Uring -10\r\nKPX D A -40\r\nKPX D Aacute -40\r\nKPX D Abreve -40\r\nKPX D Acircumflex -40\r\nKPX D Adieresis -40\r\nKPX D Agrave -40\r\nKPX D Amacron -40\r\nKPX D Aogonek -40\r\nKPX D Aring -40\r\nKPX D Atilde -40\r\nKPX D V -40\r\nKPX D W -30\r\nKPX D Y -55\r\nKPX D Yacute -55\r\nKPX D Ydieresis -55\r\nKPX Dcaron A -40\r\nKPX Dcaron Aacute -40\r\nKPX Dcaron Abreve -40\r\nKPX Dcaron Acircumflex -40\r\nKPX Dcaron Adieresis -40\r\nKPX Dcaron Agrave -40\r\nKPX Dcaron Amacron -40\r\nKPX Dcaron Aogonek -40\r\nKPX Dcaron Aring -40\r\nKPX Dcaron Atilde -40\r\nKPX Dcaron V -40\r\nKPX Dcaron W -30\r\nKPX Dcaron Y -55\r\nKPX Dcaron Yacute -55\r\nKPX Dcaron Ydieresis -55\r\nKPX Dcroat A -40\r\nKPX Dcroat Aacute -40\r\nKPX Dcroat Abreve -40\r\nKPX Dcroat Acircumflex -40\r\nKPX Dcroat Adieresis -40\r\nKPX Dcroat Agrave -40\r\nKPX Dcroat Amacron -40\r\nKPX Dcroat Aogonek -40\r\nKPX Dcroat Aring -40\r\nKPX Dcroat Atilde -40\r\nKPX Dcroat V -40\r\nKPX Dcroat W -30\r\nKPX Dcroat Y -55\r\nKPX Dcroat Yacute -55\r\nKPX Dcroat Ydieresis -55\r\nKPX F A -74\r\nKPX F Aacute -74\r\nKPX F Abreve -74\r\nKPX F Acircumflex -74\r\nKPX F Adieresis -74\r\nKPX F Agrave -74\r\nKPX F Amacron -74\r\nKPX F Aogonek -74\r\nKPX F Aring -74\r\nKPX F Atilde -74\r\nKPX F a -15\r\nKPX F aacute -15\r\nKPX F abreve -15\r\nKPX F acircumflex -15\r\nKPX F adieresis -15\r\nKPX F agrave -15\r\nKPX F amacron -15\r\nKPX F aogonek -15\r\nKPX F aring -15\r\nKPX F atilde -15\r\nKPX F comma -80\r\nKPX F o -15\r\nKPX F oacute -15\r\nKPX F ocircumflex -15\r\nKPX F odieresis -15\r\nKPX F ograve -15\r\nKPX F ohungarumlaut -15\r\nKPX F omacron -15\r\nKPX F oslash -15\r\nKPX F otilde -15\r\nKPX F period -80\r\nKPX J A -60\r\nKPX J Aacute -60\r\nKPX J Abreve -60\r\nKPX J Acircumflex -60\r\nKPX J Adieresis -60\r\nKPX J Agrave -60\r\nKPX J Amacron -60\r\nKPX J Aogonek -60\r\nKPX J Aring -60\r\nKPX J Atilde -60\r\nKPX K O -30\r\nKPX K Oacute -30\r\nKPX K Ocircumflex -30\r\nKPX K Odieresis -30\r\nKPX K Ograve -30\r\nKPX K Ohungarumlaut -30\r\nKPX K Omacron -30\r\nKPX K Oslash -30\r\nKPX K Otilde -30\r\nKPX K e -25\r\nKPX K eacute -25\r\nKPX K ecaron -25\r\nKPX K ecircumflex -25\r\nKPX K edieresis -25\r\nKPX K edotaccent -25\r\nKPX K egrave -25\r\nKPX K emacron -25\r\nKPX K eogonek -25\r\nKPX K o -35\r\nKPX K oacute -35\r\nKPX K ocircumflex -35\r\nKPX K odieresis -35\r\nKPX K ograve -35\r\nKPX K ohungarumlaut -35\r\nKPX K omacron -35\r\nKPX K oslash -35\r\nKPX K otilde -35\r\nKPX K u -15\r\nKPX K uacute -15\r\nKPX K ucircumflex -15\r\nKPX K udieresis -15\r\nKPX K ugrave -15\r\nKPX K uhungarumlaut -15\r\nKPX K umacron -15\r\nKPX K uogonek -15\r\nKPX K uring -15\r\nKPX K y -25\r\nKPX K yacute -25\r\nKPX K ydieresis -25\r\nKPX Kcommaaccent O -30\r\nKPX Kcommaaccent Oacute -30\r\nKPX Kcommaaccent Ocircumflex -30\r\nKPX Kcommaaccent Odieresis -30\r\nKPX Kcommaaccent Ograve -30\r\nKPX Kcommaaccent Ohungarumlaut -30\r\nKPX Kcommaaccent Omacron -30\r\nKPX Kcommaaccent Oslash -30\r\nKPX Kcommaaccent Otilde -30\r\nKPX Kcommaaccent e -25\r\nKPX Kcommaaccent eacute -25\r\nKPX Kcommaaccent ecaron -25\r\nKPX Kcommaaccent ecircumflex -25\r\nKPX Kcommaaccent edieresis -25\r\nKPX Kcommaaccent edotaccent -25\r\nKPX Kcommaaccent egrave -25\r\nKPX Kcommaaccent emacron -25\r\nKPX Kcommaaccent eogonek -25\r\nKPX Kcommaaccent o -35\r\nKPX Kcommaaccent oacute -35\r\nKPX Kcommaaccent ocircumflex -35\r\nKPX Kcommaaccent odieresis -35\r\nKPX Kcommaaccent ograve -35\r\nKPX Kcommaaccent ohungarumlaut -35\r\nKPX Kcommaaccent omacron -35\r\nKPX Kcommaaccent oslash -35\r\nKPX Kcommaaccent otilde -35\r\nKPX Kcommaaccent u -15\r\nKPX Kcommaaccent uacute -15\r\nKPX Kcommaaccent ucircumflex -15\r\nKPX Kcommaaccent udieresis -15\r\nKPX Kcommaaccent ugrave -15\r\nKPX Kcommaaccent uhungarumlaut -15\r\nKPX Kcommaaccent umacron -15\r\nKPX Kcommaaccent uogonek -15\r\nKPX Kcommaaccent uring -15\r\nKPX Kcommaaccent y -25\r\nKPX Kcommaaccent yacute -25\r\nKPX Kcommaaccent ydieresis -25\r\nKPX L T -92\r\nKPX L Tcaron -92\r\nKPX L Tcommaaccent -92\r\nKPX L V -100\r\nKPX L W -74\r\nKPX L Y -100\r\nKPX L Yacute -100\r\nKPX L Ydieresis -100\r\nKPX L quoteright -92\r\nKPX L y -55\r\nKPX L yacute -55\r\nKPX L ydieresis -55\r\nKPX Lacute T -92\r\nKPX Lacute Tcaron -92\r\nKPX Lacute Tcommaaccent -92\r\nKPX Lacute V -100\r\nKPX Lacute W -74\r\nKPX Lacute Y -100\r\nKPX Lacute Yacute -100\r\nKPX Lacute Ydieresis -100\r\nKPX Lacute quoteright -92\r\nKPX Lacute y -55\r\nKPX Lacute yacute -55\r\nKPX Lacute ydieresis -55\r\nKPX Lcaron quoteright -92\r\nKPX Lcaron y -55\r\nKPX Lcaron yacute -55\r\nKPX Lcaron ydieresis -55\r\nKPX Lcommaaccent T -92\r\nKPX Lcommaaccent Tcaron -92\r\nKPX Lcommaaccent Tcommaaccent -92\r\nKPX Lcommaaccent V -100\r\nKPX Lcommaaccent W -74\r\nKPX Lcommaaccent Y -100\r\nKPX Lcommaaccent Yacute -100\r\nKPX Lcommaaccent Ydieresis -100\r\nKPX Lcommaaccent quoteright -92\r\nKPX Lcommaaccent y -55\r\nKPX Lcommaaccent yacute -55\r\nKPX Lcommaaccent ydieresis -55\r\nKPX Lslash T -92\r\nKPX Lslash Tcaron -92\r\nKPX Lslash Tcommaaccent -92\r\nKPX Lslash V -100\r\nKPX Lslash W -74\r\nKPX Lslash Y -100\r\nKPX Lslash Yacute -100\r\nKPX Lslash Ydieresis -100\r\nKPX Lslash quoteright -92\r\nKPX Lslash y -55\r\nKPX Lslash yacute -55\r\nKPX Lslash ydieresis -55\r\nKPX N A -35\r\nKPX N Aacute -35\r\nKPX N Abreve -35\r\nKPX N Acircumflex -35\r\nKPX N Adieresis -35\r\nKPX N Agrave -35\r\nKPX N Amacron -35\r\nKPX N Aogonek -35\r\nKPX N Aring -35\r\nKPX N Atilde -35\r\nKPX Nacute A -35\r\nKPX Nacute Aacute -35\r\nKPX Nacute Abreve -35\r\nKPX Nacute Acircumflex -35\r\nKPX Nacute Adieresis -35\r\nKPX Nacute Agrave -35\r\nKPX Nacute Amacron -35\r\nKPX Nacute Aogonek -35\r\nKPX Nacute Aring -35\r\nKPX Nacute Atilde -35\r\nKPX Ncaron A -35\r\nKPX Ncaron Aacute -35\r\nKPX Ncaron Abreve -35\r\nKPX Ncaron Acircumflex -35\r\nKPX Ncaron Adieresis -35\r\nKPX Ncaron Agrave -35\r\nKPX Ncaron Amacron -35\r\nKPX Ncaron Aogonek -35\r\nKPX Ncaron Aring -35\r\nKPX Ncaron Atilde -35\r\nKPX Ncommaaccent A -35\r\nKPX Ncommaaccent Aacute -35\r\nKPX Ncommaaccent Abreve -35\r\nKPX Ncommaaccent Acircumflex -35\r\nKPX Ncommaaccent Adieresis -35\r\nKPX Ncommaaccent Agrave -35\r\nKPX Ncommaaccent Amacron -35\r\nKPX Ncommaaccent Aogonek -35\r\nKPX Ncommaaccent Aring -35\r\nKPX Ncommaaccent Atilde -35\r\nKPX Ntilde A -35\r\nKPX Ntilde Aacute -35\r\nKPX Ntilde Abreve -35\r\nKPX Ntilde Acircumflex -35\r\nKPX Ntilde Adieresis -35\r\nKPX Ntilde Agrave -35\r\nKPX Ntilde Amacron -35\r\nKPX Ntilde Aogonek -35\r\nKPX Ntilde Aring -35\r\nKPX Ntilde Atilde -35\r\nKPX O A -35\r\nKPX O Aacute -35\r\nKPX O Abreve -35\r\nKPX O Acircumflex -35\r\nKPX O Adieresis -35\r\nKPX O Agrave -35\r\nKPX O Amacron -35\r\nKPX O Aogonek -35\r\nKPX O Aring -35\r\nKPX O Atilde -35\r\nKPX O T -40\r\nKPX O Tcaron -40\r\nKPX O Tcommaaccent -40\r\nKPX O V -50\r\nKPX O W -35\r\nKPX O X -40\r\nKPX O Y -50\r\nKPX O Yacute -50\r\nKPX O Ydieresis -50\r\nKPX Oacute A -35\r\nKPX Oacute Aacute -35\r\nKPX Oacute Abreve -35\r\nKPX Oacute Acircumflex -35\r\nKPX Oacute Adieresis -35\r\nKPX Oacute Agrave -35\r\nKPX Oacute Amacron -35\r\nKPX Oacute Aogonek -35\r\nKPX Oacute Aring -35\r\nKPX Oacute Atilde -35\r\nKPX Oacute T -40\r\nKPX Oacute Tcaron -40\r\nKPX Oacute Tcommaaccent -40\r\nKPX Oacute V -50\r\nKPX Oacute W -35\r\nKPX Oacute X -40\r\nKPX Oacute Y -50\r\nKPX Oacute Yacute -50\r\nKPX Oacute Ydieresis -50\r\nKPX Ocircumflex A -35\r\nKPX Ocircumflex Aacute -35\r\nKPX Ocircumflex Abreve -35\r\nKPX Ocircumflex Acircumflex -35\r\nKPX Ocircumflex Adieresis -35\r\nKPX Ocircumflex Agrave -35\r\nKPX Ocircumflex Amacron -35\r\nKPX Ocircumflex Aogonek -35\r\nKPX Ocircumflex Aring -35\r\nKPX Ocircumflex Atilde -35\r\nKPX Ocircumflex T -40\r\nKPX Ocircumflex Tcaron -40\r\nKPX Ocircumflex Tcommaaccent -40\r\nKPX Ocircumflex V -50\r\nKPX Ocircumflex W -35\r\nKPX Ocircumflex X -40\r\nKPX Ocircumflex Y -50\r\nKPX Ocircumflex Yacute -50\r\nKPX Ocircumflex Ydieresis -50\r\nKPX Odieresis A -35\r\nKPX Odieresis Aacute -35\r\nKPX Odieresis Abreve -35\r\nKPX Odieresis Acircumflex -35\r\nKPX Odieresis Adieresis -35\r\nKPX Odieresis Agrave -35\r\nKPX Odieresis Amacron -35\r\nKPX Odieresis Aogonek -35\r\nKPX Odieresis Aring -35\r\nKPX Odieresis Atilde -35\r\nKPX Odieresis T -40\r\nKPX Odieresis Tcaron -40\r\nKPX Odieresis Tcommaaccent -40\r\nKPX Odieresis V -50\r\nKPX Odieresis W -35\r\nKPX Odieresis X -40\r\nKPX Odieresis Y -50\r\nKPX Odieresis Yacute -50\r\nKPX Odieresis Ydieresis -50\r\nKPX Ograve A -35\r\nKPX Ograve Aacute -35\r\nKPX Ograve Abreve -35\r\nKPX Ograve Acircumflex -35\r\nKPX Ograve Adieresis -35\r\nKPX Ograve Agrave -35\r\nKPX Ograve Amacron -35\r\nKPX Ograve Aogonek -35\r\nKPX Ograve Aring -35\r\nKPX Ograve Atilde -35\r\nKPX Ograve T -40\r\nKPX Ograve Tcaron -40\r\nKPX Ograve Tcommaaccent -40\r\nKPX Ograve V -50\r\nKPX Ograve W -35\r\nKPX Ograve X -40\r\nKPX Ograve Y -50\r\nKPX Ograve Yacute -50\r\nKPX Ograve Ydieresis -50\r\nKPX Ohungarumlaut A -35\r\nKPX Ohungarumlaut Aacute -35\r\nKPX Ohungarumlaut Abreve -35\r\nKPX Ohungarumlaut Acircumflex -35\r\nKPX Ohungarumlaut Adieresis -35\r\nKPX Ohungarumlaut Agrave -35\r\nKPX Ohungarumlaut Amacron -35\r\nKPX Ohungarumlaut Aogonek -35\r\nKPX Ohungarumlaut Aring -35\r\nKPX Ohungarumlaut Atilde -35\r\nKPX Ohungarumlaut T -40\r\nKPX Ohungarumlaut Tcaron -40\r\nKPX Ohungarumlaut Tcommaaccent -40\r\nKPX Ohungarumlaut V -50\r\nKPX Ohungarumlaut W -35\r\nKPX Ohungarumlaut X -40\r\nKPX Ohungarumlaut Y -50\r\nKPX Ohungarumlaut Yacute -50\r\nKPX Ohungarumlaut Ydieresis -50\r\nKPX Omacron A -35\r\nKPX Omacron Aacute -35\r\nKPX Omacron Abreve -35\r\nKPX Omacron Acircumflex -35\r\nKPX Omacron Adieresis -35\r\nKPX Omacron Agrave -35\r\nKPX Omacron Amacron -35\r\nKPX Omacron Aogonek -35\r\nKPX Omacron Aring -35\r\nKPX Omacron Atilde -35\r\nKPX Omacron T -40\r\nKPX Omacron Tcaron -40\r\nKPX Omacron Tcommaaccent -40\r\nKPX Omacron V -50\r\nKPX Omacron W -35\r\nKPX Omacron X -40\r\nKPX Omacron Y -50\r\nKPX Omacron Yacute -50\r\nKPX Omacron Ydieresis -50\r\nKPX Oslash A -35\r\nKPX Oslash Aacute -35\r\nKPX Oslash Abreve -35\r\nKPX Oslash Acircumflex -35\r\nKPX Oslash Adieresis -35\r\nKPX Oslash Agrave -35\r\nKPX Oslash Amacron -35\r\nKPX Oslash Aogonek -35\r\nKPX Oslash Aring -35\r\nKPX Oslash Atilde -35\r\nKPX Oslash T -40\r\nKPX Oslash Tcaron -40\r\nKPX Oslash Tcommaaccent -40\r\nKPX Oslash V -50\r\nKPX Oslash W -35\r\nKPX Oslash X -40\r\nKPX Oslash Y -50\r\nKPX Oslash Yacute -50\r\nKPX Oslash Ydieresis -50\r\nKPX Otilde A -35\r\nKPX Otilde Aacute -35\r\nKPX Otilde Abreve -35\r\nKPX Otilde Acircumflex -35\r\nKPX Otilde Adieresis -35\r\nKPX Otilde Agrave -35\r\nKPX Otilde Amacron -35\r\nKPX Otilde Aogonek -35\r\nKPX Otilde Aring -35\r\nKPX Otilde Atilde -35\r\nKPX Otilde T -40\r\nKPX Otilde Tcaron -40\r\nKPX Otilde Tcommaaccent -40\r\nKPX Otilde V -50\r\nKPX Otilde W -35\r\nKPX Otilde X -40\r\nKPX Otilde Y -50\r\nKPX Otilde Yacute -50\r\nKPX Otilde Ydieresis -50\r\nKPX P A -92\r\nKPX P Aacute -92\r\nKPX P Abreve -92\r\nKPX P Acircumflex -92\r\nKPX P Adieresis -92\r\nKPX P Agrave -92\r\nKPX P Amacron -92\r\nKPX P Aogonek -92\r\nKPX P Aring -92\r\nKPX P Atilde -92\r\nKPX P a -15\r\nKPX P aacute -15\r\nKPX P abreve -15\r\nKPX P acircumflex -15\r\nKPX P adieresis -15\r\nKPX P agrave -15\r\nKPX P amacron -15\r\nKPX P aogonek -15\r\nKPX P aring -15\r\nKPX P atilde -15\r\nKPX P comma -111\r\nKPX P period -111\r\nKPX Q U -10\r\nKPX Q Uacute -10\r\nKPX Q Ucircumflex -10\r\nKPX Q Udieresis -10\r\nKPX Q Ugrave -10\r\nKPX Q Uhungarumlaut -10\r\nKPX Q Umacron -10\r\nKPX Q Uogonek -10\r\nKPX Q Uring -10\r\nKPX R O -40\r\nKPX R Oacute -40\r\nKPX R Ocircumflex -40\r\nKPX R Odieresis -40\r\nKPX R Ograve -40\r\nKPX R Ohungarumlaut -40\r\nKPX R Omacron -40\r\nKPX R Oslash -40\r\nKPX R Otilde -40\r\nKPX R T -60\r\nKPX R Tcaron -60\r\nKPX R Tcommaaccent -60\r\nKPX R U -40\r\nKPX R Uacute -40\r\nKPX R Ucircumflex -40\r\nKPX R Udieresis -40\r\nKPX R Ugrave -40\r\nKPX R Uhungarumlaut -40\r\nKPX R Umacron -40\r\nKPX R Uogonek -40\r\nKPX R Uring -40\r\nKPX R V -80\r\nKPX R W -55\r\nKPX R Y -65\r\nKPX R Yacute -65\r\nKPX R Ydieresis -65\r\nKPX Racute O -40\r\nKPX Racute Oacute -40\r\nKPX Racute Ocircumflex -40\r\nKPX Racute Odieresis -40\r\nKPX Racute Ograve -40\r\nKPX Racute Ohungarumlaut -40\r\nKPX Racute Omacron -40\r\nKPX Racute Oslash -40\r\nKPX Racute Otilde -40\r\nKPX Racute T -60\r\nKPX Racute Tcaron -60\r\nKPX Racute Tcommaaccent -60\r\nKPX Racute U -40\r\nKPX Racute Uacute -40\r\nKPX Racute Ucircumflex -40\r\nKPX Racute Udieresis -40\r\nKPX Racute Ugrave -40\r\nKPX Racute Uhungarumlaut -40\r\nKPX Racute Umacron -40\r\nKPX Racute Uogonek -40\r\nKPX Racute Uring -40\r\nKPX Racute V -80\r\nKPX Racute W -55\r\nKPX Racute Y -65\r\nKPX Racute Yacute -65\r\nKPX Racute Ydieresis -65\r\nKPX Rcaron O -40\r\nKPX Rcaron Oacute -40\r\nKPX Rcaron Ocircumflex -40\r\nKPX Rcaron Odieresis -40\r\nKPX Rcaron Ograve -40\r\nKPX Rcaron Ohungarumlaut -40\r\nKPX Rcaron Omacron -40\r\nKPX Rcaron Oslash -40\r\nKPX Rcaron Otilde -40\r\nKPX Rcaron T -60\r\nKPX Rcaron Tcaron -60\r\nKPX Rcaron Tcommaaccent -60\r\nKPX Rcaron U -40\r\nKPX Rcaron Uacute -40\r\nKPX Rcaron Ucircumflex -40\r\nKPX Rcaron Udieresis -40\r\nKPX Rcaron Ugrave -40\r\nKPX Rcaron Uhungarumlaut -40\r\nKPX Rcaron Umacron -40\r\nKPX Rcaron Uogonek -40\r\nKPX Rcaron Uring -40\r\nKPX Rcaron V -80\r\nKPX Rcaron W -55\r\nKPX Rcaron Y -65\r\nKPX Rcaron Yacute -65\r\nKPX Rcaron Ydieresis -65\r\nKPX Rcommaaccent O -40\r\nKPX Rcommaaccent Oacute -40\r\nKPX Rcommaaccent Ocircumflex -40\r\nKPX Rcommaaccent Odieresis -40\r\nKPX Rcommaaccent Ograve -40\r\nKPX Rcommaaccent Ohungarumlaut -40\r\nKPX Rcommaaccent Omacron -40\r\nKPX Rcommaaccent Oslash -40\r\nKPX Rcommaaccent Otilde -40\r\nKPX Rcommaaccent T -60\r\nKPX Rcommaaccent Tcaron -60\r\nKPX Rcommaaccent Tcommaaccent -60\r\nKPX Rcommaaccent U -40\r\nKPX Rcommaaccent Uacute -40\r\nKPX Rcommaaccent Ucircumflex -40\r\nKPX Rcommaaccent Udieresis -40\r\nKPX Rcommaaccent Ugrave -40\r\nKPX Rcommaaccent Uhungarumlaut -40\r\nKPX Rcommaaccent Umacron -40\r\nKPX Rcommaaccent Uogonek -40\r\nKPX Rcommaaccent Uring -40\r\nKPX Rcommaaccent V -80\r\nKPX Rcommaaccent W -55\r\nKPX Rcommaaccent Y -65\r\nKPX Rcommaaccent Yacute -65\r\nKPX Rcommaaccent Ydieresis -65\r\nKPX T A -93\r\nKPX T Aacute -93\r\nKPX T Abreve -93\r\nKPX T Acircumflex -93\r\nKPX T Adieresis -93\r\nKPX T Agrave -93\r\nKPX T Amacron -93\r\nKPX T Aogonek -93\r\nKPX T Aring -93\r\nKPX T Atilde -93\r\nKPX T O -18\r\nKPX T Oacute -18\r\nKPX T Ocircumflex -18\r\nKPX T Odieresis -18\r\nKPX T Ograve -18\r\nKPX T Ohungarumlaut -18\r\nKPX T Omacron -18\r\nKPX T Oslash -18\r\nKPX T Otilde -18\r\nKPX T a -80\r\nKPX T aacute -80\r\nKPX T abreve -80\r\nKPX T acircumflex -80\r\nKPX T adieresis -40\r\nKPX T agrave -40\r\nKPX T amacron -40\r\nKPX T aogonek -80\r\nKPX T aring -80\r\nKPX T atilde -40\r\nKPX T colon -50\r\nKPX T comma -74\r\nKPX T e -70\r\nKPX T eacute -70\r\nKPX T ecaron -70\r\nKPX T ecircumflex -70\r\nKPX T edieresis -30\r\nKPX T edotaccent -70\r\nKPX T egrave -70\r\nKPX T emacron -30\r\nKPX T eogonek -70\r\nKPX T hyphen -92\r\nKPX T i -35\r\nKPX T iacute -35\r\nKPX T iogonek -35\r\nKPX T o -80\r\nKPX T oacute -80\r\nKPX T ocircumflex -80\r\nKPX T odieresis -80\r\nKPX T ograve -80\r\nKPX T ohungarumlaut -80\r\nKPX T omacron -80\r\nKPX T oslash -80\r\nKPX T otilde -80\r\nKPX T period -74\r\nKPX T r -35\r\nKPX T racute -35\r\nKPX T rcaron -35\r\nKPX T rcommaaccent -35\r\nKPX T semicolon -55\r\nKPX T u -45\r\nKPX T uacute -45\r\nKPX T ucircumflex -45\r\nKPX T udieresis -45\r\nKPX T ugrave -45\r\nKPX T uhungarumlaut -45\r\nKPX T umacron -45\r\nKPX T uogonek -45\r\nKPX T uring -45\r\nKPX T w -80\r\nKPX T y -80\r\nKPX T yacute -80\r\nKPX T ydieresis -80\r\nKPX Tcaron A -93\r\nKPX Tcaron Aacute -93\r\nKPX Tcaron Abreve -93\r\nKPX Tcaron Acircumflex -93\r\nKPX Tcaron Adieresis -93\r\nKPX Tcaron Agrave -93\r\nKPX Tcaron Amacron -93\r\nKPX Tcaron Aogonek -93\r\nKPX Tcaron Aring -93\r\nKPX Tcaron Atilde -93\r\nKPX Tcaron O -18\r\nKPX Tcaron Oacute -18\r\nKPX Tcaron Ocircumflex -18\r\nKPX Tcaron Odieresis -18\r\nKPX Tcaron Ograve -18\r\nKPX Tcaron Ohungarumlaut -18\r\nKPX Tcaron Omacron -18\r\nKPX Tcaron Oslash -18\r\nKPX Tcaron Otilde -18\r\nKPX Tcaron a -80\r\nKPX Tcaron aacute -80\r\nKPX Tcaron abreve -80\r\nKPX Tcaron acircumflex -80\r\nKPX Tcaron adieresis -40\r\nKPX Tcaron agrave -40\r\nKPX Tcaron amacron -40\r\nKPX Tcaron aogonek -80\r\nKPX Tcaron aring -80\r\nKPX Tcaron atilde -40\r\nKPX Tcaron colon -50\r\nKPX Tcaron comma -74\r\nKPX Tcaron e -70\r\nKPX Tcaron eacute -70\r\nKPX Tcaron ecaron -70\r\nKPX Tcaron ecircumflex -30\r\nKPX Tcaron edieresis -30\r\nKPX Tcaron edotaccent -70\r\nKPX Tcaron egrave -70\r\nKPX Tcaron emacron -30\r\nKPX Tcaron eogonek -70\r\nKPX Tcaron hyphen -92\r\nKPX Tcaron i -35\r\nKPX Tcaron iacute -35\r\nKPX Tcaron iogonek -35\r\nKPX Tcaron o -80\r\nKPX Tcaron oacute -80\r\nKPX Tcaron ocircumflex -80\r\nKPX Tcaron odieresis -80\r\nKPX Tcaron ograve -80\r\nKPX Tcaron ohungarumlaut -80\r\nKPX Tcaron omacron -80\r\nKPX Tcaron oslash -80\r\nKPX Tcaron otilde -80\r\nKPX Tcaron period -74\r\nKPX Tcaron r -35\r\nKPX Tcaron racute -35\r\nKPX Tcaron rcaron -35\r\nKPX Tcaron rcommaaccent -35\r\nKPX Tcaron semicolon -55\r\nKPX Tcaron u -45\r\nKPX Tcaron uacute -45\r\nKPX Tcaron ucircumflex -45\r\nKPX Tcaron udieresis -45\r\nKPX Tcaron ugrave -45\r\nKPX Tcaron uhungarumlaut -45\r\nKPX Tcaron umacron -45\r\nKPX Tcaron uogonek -45\r\nKPX Tcaron uring -45\r\nKPX Tcaron w -80\r\nKPX Tcaron y -80\r\nKPX Tcaron yacute -80\r\nKPX Tcaron ydieresis -80\r\nKPX Tcommaaccent A -93\r\nKPX Tcommaaccent Aacute -93\r\nKPX Tcommaaccent Abreve -93\r\nKPX Tcommaaccent Acircumflex -93\r\nKPX Tcommaaccent Adieresis -93\r\nKPX Tcommaaccent Agrave -93\r\nKPX Tcommaaccent Amacron -93\r\nKPX Tcommaaccent Aogonek -93\r\nKPX Tcommaaccent Aring -93\r\nKPX Tcommaaccent Atilde -93\r\nKPX Tcommaaccent O -18\r\nKPX Tcommaaccent Oacute -18\r\nKPX Tcommaaccent Ocircumflex -18\r\nKPX Tcommaaccent Odieresis -18\r\nKPX Tcommaaccent Ograve -18\r\nKPX Tcommaaccent Ohungarumlaut -18\r\nKPX Tcommaaccent Omacron -18\r\nKPX Tcommaaccent Oslash -18\r\nKPX Tcommaaccent Otilde -18\r\nKPX Tcommaaccent a -80\r\nKPX Tcommaaccent aacute -80\r\nKPX Tcommaaccent abreve -80\r\nKPX Tcommaaccent acircumflex -80\r\nKPX Tcommaaccent adieresis -40\r\nKPX Tcommaaccent agrave -40\r\nKPX Tcommaaccent amacron -40\r\nKPX Tcommaaccent aogonek -80\r\nKPX Tcommaaccent aring -80\r\nKPX Tcommaaccent atilde -40\r\nKPX Tcommaaccent colon -50\r\nKPX Tcommaaccent comma -74\r\nKPX Tcommaaccent e -70\r\nKPX Tcommaaccent eacute -70\r\nKPX Tcommaaccent ecaron -70\r\nKPX Tcommaaccent ecircumflex -30\r\nKPX Tcommaaccent edieresis -30\r\nKPX Tcommaaccent edotaccent -70\r\nKPX Tcommaaccent egrave -30\r\nKPX Tcommaaccent emacron -70\r\nKPX Tcommaaccent eogonek -70\r\nKPX Tcommaaccent hyphen -92\r\nKPX Tcommaaccent i -35\r\nKPX Tcommaaccent iacute -35\r\nKPX Tcommaaccent iogonek -35\r\nKPX Tcommaaccent o -80\r\nKPX Tcommaaccent oacute -80\r\nKPX Tcommaaccent ocircumflex -80\r\nKPX Tcommaaccent odieresis -80\r\nKPX Tcommaaccent ograve -80\r\nKPX Tcommaaccent ohungarumlaut -80\r\nKPX Tcommaaccent omacron -80\r\nKPX Tcommaaccent oslash -80\r\nKPX Tcommaaccent otilde -80\r\nKPX Tcommaaccent period -74\r\nKPX Tcommaaccent r -35\r\nKPX Tcommaaccent racute -35\r\nKPX Tcommaaccent rcaron -35\r\nKPX Tcommaaccent rcommaaccent -35\r\nKPX Tcommaaccent semicolon -55\r\nKPX Tcommaaccent u -45\r\nKPX Tcommaaccent uacute -45\r\nKPX Tcommaaccent ucircumflex -45\r\nKPX Tcommaaccent udieresis -45\r\nKPX Tcommaaccent ugrave -45\r\nKPX Tcommaaccent uhungarumlaut -45\r\nKPX Tcommaaccent umacron -45\r\nKPX Tcommaaccent uogonek -45\r\nKPX Tcommaaccent uring -45\r\nKPX Tcommaaccent w -80\r\nKPX Tcommaaccent y -80\r\nKPX Tcommaaccent yacute -80\r\nKPX Tcommaaccent ydieresis -80\r\nKPX U A -40\r\nKPX U Aacute -40\r\nKPX U Abreve -40\r\nKPX U Acircumflex -40\r\nKPX U Adieresis -40\r\nKPX U Agrave -40\r\nKPX U Amacron -40\r\nKPX U Aogonek -40\r\nKPX U Aring -40\r\nKPX U Atilde -40\r\nKPX Uacute A -40\r\nKPX Uacute Aacute -40\r\nKPX Uacute Abreve -40\r\nKPX Uacute Acircumflex -40\r\nKPX Uacute Adieresis -40\r\nKPX Uacute Agrave -40\r\nKPX Uacute Amacron -40\r\nKPX Uacute Aogonek -40\r\nKPX Uacute Aring -40\r\nKPX Uacute Atilde -40\r\nKPX Ucircumflex A -40\r\nKPX Ucircumflex Aacute -40\r\nKPX Ucircumflex Abreve -40\r\nKPX Ucircumflex Acircumflex -40\r\nKPX Ucircumflex Adieresis -40\r\nKPX Ucircumflex Agrave -40\r\nKPX Ucircumflex Amacron -40\r\nKPX Ucircumflex Aogonek -40\r\nKPX Ucircumflex Aring -40\r\nKPX Ucircumflex Atilde -40\r\nKPX Udieresis A -40\r\nKPX Udieresis Aacute -40\r\nKPX Udieresis Abreve -40\r\nKPX Udieresis Acircumflex -40\r\nKPX Udieresis Adieresis -40\r\nKPX Udieresis Agrave -40\r\nKPX Udieresis Amacron -40\r\nKPX Udieresis Aogonek -40\r\nKPX Udieresis Aring -40\r\nKPX Udieresis Atilde -40\r\nKPX Ugrave A -40\r\nKPX Ugrave Aacute -40\r\nKPX Ugrave Abreve -40\r\nKPX Ugrave Acircumflex -40\r\nKPX Ugrave Adieresis -40\r\nKPX Ugrave Agrave -40\r\nKPX Ugrave Amacron -40\r\nKPX Ugrave Aogonek -40\r\nKPX Ugrave Aring -40\r\nKPX Ugrave Atilde -40\r\nKPX Uhungarumlaut A -40\r\nKPX Uhungarumlaut Aacute -40\r\nKPX Uhungarumlaut Abreve -40\r\nKPX Uhungarumlaut Acircumflex -40\r\nKPX Uhungarumlaut Adieresis -40\r\nKPX Uhungarumlaut Agrave -40\r\nKPX Uhungarumlaut Amacron -40\r\nKPX Uhungarumlaut Aogonek -40\r\nKPX Uhungarumlaut Aring -40\r\nKPX Uhungarumlaut Atilde -40\r\nKPX Umacron A -40\r\nKPX Umacron Aacute -40\r\nKPX Umacron Abreve -40\r\nKPX Umacron Acircumflex -40\r\nKPX Umacron Adieresis -40\r\nKPX Umacron Agrave -40\r\nKPX Umacron Amacron -40\r\nKPX Umacron Aogonek -40\r\nKPX Umacron Aring -40\r\nKPX Umacron Atilde -40\r\nKPX Uogonek A -40\r\nKPX Uogonek Aacute -40\r\nKPX Uogonek Abreve -40\r\nKPX Uogonek Acircumflex -40\r\nKPX Uogonek Adieresis -40\r\nKPX Uogonek Agrave -40\r\nKPX Uogonek Amacron -40\r\nKPX Uogonek Aogonek -40\r\nKPX Uogonek Aring -40\r\nKPX Uogonek Atilde -40\r\nKPX Uring A -40\r\nKPX Uring Aacute -40\r\nKPX Uring Abreve -40\r\nKPX Uring Acircumflex -40\r\nKPX Uring Adieresis -40\r\nKPX Uring Agrave -40\r\nKPX Uring Amacron -40\r\nKPX Uring Aogonek -40\r\nKPX Uring Aring -40\r\nKPX Uring Atilde -40\r\nKPX V A -135\r\nKPX V Aacute -135\r\nKPX V Abreve -135\r\nKPX V Acircumflex -135\r\nKPX V Adieresis -135\r\nKPX V Agrave -135\r\nKPX V Amacron -135\r\nKPX V Aogonek -135\r\nKPX V Aring -135\r\nKPX V Atilde -135\r\nKPX V G -15\r\nKPX V Gbreve -15\r\nKPX V Gcommaaccent -15\r\nKPX V O -40\r\nKPX V Oacute -40\r\nKPX V Ocircumflex -40\r\nKPX V Odieresis -40\r\nKPX V Ograve -40\r\nKPX V Ohungarumlaut -40\r\nKPX V Omacron -40\r\nKPX V Oslash -40\r\nKPX V Otilde -40\r\nKPX V a -111\r\nKPX V aacute -111\r\nKPX V abreve -111\r\nKPX V acircumflex -71\r\nKPX V adieresis -71\r\nKPX V agrave -71\r\nKPX V amacron -71\r\nKPX V aogonek -111\r\nKPX V aring -111\r\nKPX V atilde -71\r\nKPX V colon -74\r\nKPX V comma -129\r\nKPX V e -111\r\nKPX V eacute -111\r\nKPX V ecaron -71\r\nKPX V ecircumflex -71\r\nKPX V edieresis -71\r\nKPX V edotaccent -111\r\nKPX V egrave -71\r\nKPX V emacron -71\r\nKPX V eogonek -111\r\nKPX V hyphen -100\r\nKPX V i -60\r\nKPX V iacute -60\r\nKPX V icircumflex -20\r\nKPX V idieresis -20\r\nKPX V igrave -20\r\nKPX V imacron -20\r\nKPX V iogonek -60\r\nKPX V o -129\r\nKPX V oacute -129\r\nKPX V ocircumflex -129\r\nKPX V odieresis -89\r\nKPX V ograve -89\r\nKPX V ohungarumlaut -129\r\nKPX V omacron -89\r\nKPX V oslash -129\r\nKPX V otilde -89\r\nKPX V period -129\r\nKPX V semicolon -74\r\nKPX V u -75\r\nKPX V uacute -75\r\nKPX V ucircumflex -75\r\nKPX V udieresis -75\r\nKPX V ugrave -75\r\nKPX V uhungarumlaut -75\r\nKPX V umacron -75\r\nKPX V uogonek -75\r\nKPX V uring -75\r\nKPX W A -120\r\nKPX W Aacute -120\r\nKPX W Abreve -120\r\nKPX W Acircumflex -120\r\nKPX W Adieresis -120\r\nKPX W Agrave -120\r\nKPX W Amacron -120\r\nKPX W Aogonek -120\r\nKPX W Aring -120\r\nKPX W Atilde -120\r\nKPX W O -10\r\nKPX W Oacute -10\r\nKPX W Ocircumflex -10\r\nKPX W Odieresis -10\r\nKPX W Ograve -10\r\nKPX W Ohungarumlaut -10\r\nKPX W Omacron -10\r\nKPX W Oslash -10\r\nKPX W Otilde -10\r\nKPX W a -80\r\nKPX W aacute -80\r\nKPX W abreve -80\r\nKPX W acircumflex -80\r\nKPX W adieresis -80\r\nKPX W agrave -80\r\nKPX W amacron -80\r\nKPX W aogonek -80\r\nKPX W aring -80\r\nKPX W atilde -80\r\nKPX W colon -37\r\nKPX W comma -92\r\nKPX W e -80\r\nKPX W eacute -80\r\nKPX W ecaron -80\r\nKPX W ecircumflex -80\r\nKPX W edieresis -40\r\nKPX W edotaccent -80\r\nKPX W egrave -40\r\nKPX W emacron -40\r\nKPX W eogonek -80\r\nKPX W hyphen -65\r\nKPX W i -40\r\nKPX W iacute -40\r\nKPX W iogonek -40\r\nKPX W o -80\r\nKPX W oacute -80\r\nKPX W ocircumflex -80\r\nKPX W odieresis -80\r\nKPX W ograve -80\r\nKPX W ohungarumlaut -80\r\nKPX W omacron -80\r\nKPX W oslash -80\r\nKPX W otilde -80\r\nKPX W period -92\r\nKPX W semicolon -37\r\nKPX W u -50\r\nKPX W uacute -50\r\nKPX W ucircumflex -50\r\nKPX W udieresis -50\r\nKPX W ugrave -50\r\nKPX W uhungarumlaut -50\r\nKPX W umacron -50\r\nKPX W uogonek -50\r\nKPX W uring -50\r\nKPX W y -73\r\nKPX W yacute -73\r\nKPX W ydieresis -73\r\nKPX Y A -120\r\nKPX Y Aacute -120\r\nKPX Y Abreve -120\r\nKPX Y Acircumflex -120\r\nKPX Y Adieresis -120\r\nKPX Y Agrave -120\r\nKPX Y Amacron -120\r\nKPX Y Aogonek -120\r\nKPX Y Aring -120\r\nKPX Y Atilde -120\r\nKPX Y O -30\r\nKPX Y Oacute -30\r\nKPX Y Ocircumflex -30\r\nKPX Y Odieresis -30\r\nKPX Y Ograve -30\r\nKPX Y Ohungarumlaut -30\r\nKPX Y Omacron -30\r\nKPX Y Oslash -30\r\nKPX Y Otilde -30\r\nKPX Y a -100\r\nKPX Y aacute -100\r\nKPX Y abreve -100\r\nKPX Y acircumflex -100\r\nKPX Y adieresis -60\r\nKPX Y agrave -60\r\nKPX Y amacron -60\r\nKPX Y aogonek -100\r\nKPX Y aring -100\r\nKPX Y atilde -60\r\nKPX Y colon -92\r\nKPX Y comma -129\r\nKPX Y e -100\r\nKPX Y eacute -100\r\nKPX Y ecaron -100\r\nKPX Y ecircumflex -100\r\nKPX Y edieresis -60\r\nKPX Y edotaccent -100\r\nKPX Y egrave -60\r\nKPX Y emacron -60\r\nKPX Y eogonek -100\r\nKPX Y hyphen -111\r\nKPX Y i -55\r\nKPX Y iacute -55\r\nKPX Y iogonek -55\r\nKPX Y o -110\r\nKPX Y oacute -110\r\nKPX Y ocircumflex -110\r\nKPX Y odieresis -70\r\nKPX Y ograve -70\r\nKPX Y ohungarumlaut -110\r\nKPX Y omacron -70\r\nKPX Y oslash -110\r\nKPX Y otilde -70\r\nKPX Y period -129\r\nKPX Y semicolon -92\r\nKPX Y u -111\r\nKPX Y uacute -111\r\nKPX Y ucircumflex -111\r\nKPX Y udieresis -71\r\nKPX Y ugrave -71\r\nKPX Y uhungarumlaut -111\r\nKPX Y umacron -71\r\nKPX Y uogonek -111\r\nKPX Y uring -111\r\nKPX Yacute A -120\r\nKPX Yacute Aacute -120\r\nKPX Yacute Abreve -120\r\nKPX Yacute Acircumflex -120\r\nKPX Yacute Adieresis -120\r\nKPX Yacute Agrave -120\r\nKPX Yacute Amacron -120\r\nKPX Yacute Aogonek -120\r\nKPX Yacute Aring -120\r\nKPX Yacute Atilde -120\r\nKPX Yacute O -30\r\nKPX Yacute Oacute -30\r\nKPX Yacute Ocircumflex -30\r\nKPX Yacute Odieresis -30\r\nKPX Yacute Ograve -30\r\nKPX Yacute Ohungarumlaut -30\r\nKPX Yacute Omacron -30\r\nKPX Yacute Oslash -30\r\nKPX Yacute Otilde -30\r\nKPX Yacute a -100\r\nKPX Yacute aacute -100\r\nKPX Yacute abreve -100\r\nKPX Yacute acircumflex -100\r\nKPX Yacute adieresis -60\r\nKPX Yacute agrave -60\r\nKPX Yacute amacron -60\r\nKPX Yacute aogonek -100\r\nKPX Yacute aring -100\r\nKPX Yacute atilde -60\r\nKPX Yacute colon -92\r\nKPX Yacute comma -129\r\nKPX Yacute e -100\r\nKPX Yacute eacute -100\r\nKPX Yacute ecaron -100\r\nKPX Yacute ecircumflex -100\r\nKPX Yacute edieresis -60\r\nKPX Yacute edotaccent -100\r\nKPX Yacute egrave -60\r\nKPX Yacute emacron -60\r\nKPX Yacute eogonek -100\r\nKPX Yacute hyphen -111\r\nKPX Yacute i -55\r\nKPX Yacute iacute -55\r\nKPX Yacute iogonek -55\r\nKPX Yacute o -110\r\nKPX Yacute oacute -110\r\nKPX Yacute ocircumflex -110\r\nKPX Yacute odieresis -70\r\nKPX Yacute ograve -70\r\nKPX Yacute ohungarumlaut -110\r\nKPX Yacute omacron -70\r\nKPX Yacute oslash -110\r\nKPX Yacute otilde -70\r\nKPX Yacute period -129\r\nKPX Yacute semicolon -92\r\nKPX Yacute u -111\r\nKPX Yacute uacute -111\r\nKPX Yacute ucircumflex -111\r\nKPX Yacute udieresis -71\r\nKPX Yacute ugrave -71\r\nKPX Yacute uhungarumlaut -111\r\nKPX Yacute umacron -71\r\nKPX Yacute uogonek -111\r\nKPX Yacute uring -111\r\nKPX Ydieresis A -120\r\nKPX Ydieresis Aacute -120\r\nKPX Ydieresis Abreve -120\r\nKPX Ydieresis Acircumflex -120\r\nKPX Ydieresis Adieresis -120\r\nKPX Ydieresis Agrave -120\r\nKPX Ydieresis Amacron -120\r\nKPX Ydieresis Aogonek -120\r\nKPX Ydieresis Aring -120\r\nKPX Ydieresis Atilde -120\r\nKPX Ydieresis O -30\r\nKPX Ydieresis Oacute -30\r\nKPX Ydieresis Ocircumflex -30\r\nKPX Ydieresis Odieresis -30\r\nKPX Ydieresis Ograve -30\r\nKPX Ydieresis Ohungarumlaut -30\r\nKPX Ydieresis Omacron -30\r\nKPX Ydieresis Oslash -30\r\nKPX Ydieresis Otilde -30\r\nKPX Ydieresis a -100\r\nKPX Ydieresis aacute -100\r\nKPX Ydieresis abreve -100\r\nKPX Ydieresis acircumflex -100\r\nKPX Ydieresis adieresis -60\r\nKPX Ydieresis agrave -60\r\nKPX Ydieresis amacron -60\r\nKPX Ydieresis aogonek -100\r\nKPX Ydieresis aring -100\r\nKPX Ydieresis atilde -100\r\nKPX Ydieresis colon -92\r\nKPX Ydieresis comma -129\r\nKPX Ydieresis e -100\r\nKPX Ydieresis eacute -100\r\nKPX Ydieresis ecaron -100\r\nKPX Ydieresis ecircumflex -100\r\nKPX Ydieresis edieresis -60\r\nKPX Ydieresis edotaccent -100\r\nKPX Ydieresis egrave -60\r\nKPX Ydieresis emacron -60\r\nKPX Ydieresis eogonek -100\r\nKPX Ydieresis hyphen -111\r\nKPX Ydieresis i -55\r\nKPX Ydieresis iacute -55\r\nKPX Ydieresis iogonek -55\r\nKPX Ydieresis o -110\r\nKPX Ydieresis oacute -110\r\nKPX Ydieresis ocircumflex -110\r\nKPX Ydieresis odieresis -70\r\nKPX Ydieresis ograve -70\r\nKPX Ydieresis ohungarumlaut -110\r\nKPX Ydieresis omacron -70\r\nKPX Ydieresis oslash -110\r\nKPX Ydieresis otilde -70\r\nKPX Ydieresis period -129\r\nKPX Ydieresis semicolon -92\r\nKPX Ydieresis u -111\r\nKPX Ydieresis uacute -111\r\nKPX Ydieresis ucircumflex -111\r\nKPX Ydieresis udieresis -71\r\nKPX Ydieresis ugrave -71\r\nKPX Ydieresis uhungarumlaut -111\r\nKPX Ydieresis umacron -71\r\nKPX Ydieresis uogonek -111\r\nKPX Ydieresis uring -111\r\nKPX a v -20\r\nKPX a w -15\r\nKPX aacute v -20\r\nKPX aacute w -15\r\nKPX abreve v -20\r\nKPX abreve w -15\r\nKPX acircumflex v -20\r\nKPX acircumflex w -15\r\nKPX adieresis v -20\r\nKPX adieresis w -15\r\nKPX agrave v -20\r\nKPX agrave w -15\r\nKPX amacron v -20\r\nKPX amacron w -15\r\nKPX aogonek v -20\r\nKPX aogonek w -15\r\nKPX aring v -20\r\nKPX aring w -15\r\nKPX atilde v -20\r\nKPX atilde w -15\r\nKPX b period -40\r\nKPX b u -20\r\nKPX b uacute -20\r\nKPX b ucircumflex -20\r\nKPX b udieresis -20\r\nKPX b ugrave -20\r\nKPX b uhungarumlaut -20\r\nKPX b umacron -20\r\nKPX b uogonek -20\r\nKPX b uring -20\r\nKPX b v -15\r\nKPX c y -15\r\nKPX c yacute -15\r\nKPX c ydieresis -15\r\nKPX cacute y -15\r\nKPX cacute yacute -15\r\nKPX cacute ydieresis -15\r\nKPX ccaron y -15\r\nKPX ccaron yacute -15\r\nKPX ccaron ydieresis -15\r\nKPX ccedilla y -15\r\nKPX ccedilla yacute -15\r\nKPX ccedilla ydieresis -15\r\nKPX comma quotedblright -70\r\nKPX comma quoteright -70\r\nKPX e g -15\r\nKPX e gbreve -15\r\nKPX e gcommaaccent -15\r\nKPX e v -25\r\nKPX e w -25\r\nKPX e x -15\r\nKPX e y -15\r\nKPX e yacute -15\r\nKPX e ydieresis -15\r\nKPX eacute g -15\r\nKPX eacute gbreve -15\r\nKPX eacute gcommaaccent -15\r\nKPX eacute v -25\r\nKPX eacute w -25\r\nKPX eacute x -15\r\nKPX eacute y -15\r\nKPX eacute yacute -15\r\nKPX eacute ydieresis -15\r\nKPX ecaron g -15\r\nKPX ecaron gbreve -15\r\nKPX ecaron gcommaaccent -15\r\nKPX ecaron v -25\r\nKPX ecaron w -25\r\nKPX ecaron x -15\r\nKPX ecaron y -15\r\nKPX ecaron yacute -15\r\nKPX ecaron ydieresis -15\r\nKPX ecircumflex g -15\r\nKPX ecircumflex gbreve -15\r\nKPX ecircumflex gcommaaccent -15\r\nKPX ecircumflex v -25\r\nKPX ecircumflex w -25\r\nKPX ecircumflex x -15\r\nKPX ecircumflex y -15\r\nKPX ecircumflex yacute -15\r\nKPX ecircumflex ydieresis -15\r\nKPX edieresis g -15\r\nKPX edieresis gbreve -15\r\nKPX edieresis gcommaaccent -15\r\nKPX edieresis v -25\r\nKPX edieresis w -25\r\nKPX edieresis x -15\r\nKPX edieresis y -15\r\nKPX edieresis yacute -15\r\nKPX edieresis ydieresis -15\r\nKPX edotaccent g -15\r\nKPX edotaccent gbreve -15\r\nKPX edotaccent gcommaaccent -15\r\nKPX edotaccent v -25\r\nKPX edotaccent w -25\r\nKPX edotaccent x -15\r\nKPX edotaccent y -15\r\nKPX edotaccent yacute -15\r\nKPX edotaccent ydieresis -15\r\nKPX egrave g -15\r\nKPX egrave gbreve -15\r\nKPX egrave gcommaaccent -15\r\nKPX egrave v -25\r\nKPX egrave w -25\r\nKPX egrave x -15\r\nKPX egrave y -15\r\nKPX egrave yacute -15\r\nKPX egrave ydieresis -15\r\nKPX emacron g -15\r\nKPX emacron gbreve -15\r\nKPX emacron gcommaaccent -15\r\nKPX emacron v -25\r\nKPX emacron w -25\r\nKPX emacron x -15\r\nKPX emacron y -15\r\nKPX emacron yacute -15\r\nKPX emacron ydieresis -15\r\nKPX eogonek g -15\r\nKPX eogonek gbreve -15\r\nKPX eogonek gcommaaccent -15\r\nKPX eogonek v -25\r\nKPX eogonek w -25\r\nKPX eogonek x -15\r\nKPX eogonek y -15\r\nKPX eogonek yacute -15\r\nKPX eogonek ydieresis -15\r\nKPX f a -10\r\nKPX f aacute -10\r\nKPX f abreve -10\r\nKPX f acircumflex -10\r\nKPX f adieresis -10\r\nKPX f agrave -10\r\nKPX f amacron -10\r\nKPX f aogonek -10\r\nKPX f aring -10\r\nKPX f atilde -10\r\nKPX f dotlessi -50\r\nKPX f f -25\r\nKPX f i -20\r\nKPX f iacute -20\r\nKPX f quoteright 55\r\nKPX g a -5\r\nKPX g aacute -5\r\nKPX g abreve -5\r\nKPX g acircumflex -5\r\nKPX g adieresis -5\r\nKPX g agrave -5\r\nKPX g amacron -5\r\nKPX g aogonek -5\r\nKPX g aring -5\r\nKPX g atilde -5\r\nKPX gbreve a -5\r\nKPX gbreve aacute -5\r\nKPX gbreve abreve -5\r\nKPX gbreve acircumflex -5\r\nKPX gbreve adieresis -5\r\nKPX gbreve agrave -5\r\nKPX gbreve amacron -5\r\nKPX gbreve aogonek -5\r\nKPX gbreve aring -5\r\nKPX gbreve atilde -5\r\nKPX gcommaaccent a -5\r\nKPX gcommaaccent aacute -5\r\nKPX gcommaaccent abreve -5\r\nKPX gcommaaccent acircumflex -5\r\nKPX gcommaaccent adieresis -5\r\nKPX gcommaaccent agrave -5\r\nKPX gcommaaccent amacron -5\r\nKPX gcommaaccent aogonek -5\r\nKPX gcommaaccent aring -5\r\nKPX gcommaaccent atilde -5\r\nKPX h y -5\r\nKPX h yacute -5\r\nKPX h ydieresis -5\r\nKPX i v -25\r\nKPX iacute v -25\r\nKPX icircumflex v -25\r\nKPX idieresis v -25\r\nKPX igrave v -25\r\nKPX imacron v -25\r\nKPX iogonek v -25\r\nKPX k e -10\r\nKPX k eacute -10\r\nKPX k ecaron -10\r\nKPX k ecircumflex -10\r\nKPX k edieresis -10\r\nKPX k edotaccent -10\r\nKPX k egrave -10\r\nKPX k emacron -10\r\nKPX k eogonek -10\r\nKPX k o -10\r\nKPX k oacute -10\r\nKPX k ocircumflex -10\r\nKPX k odieresis -10\r\nKPX k ograve -10\r\nKPX k ohungarumlaut -10\r\nKPX k omacron -10\r\nKPX k oslash -10\r\nKPX k otilde -10\r\nKPX k y -15\r\nKPX k yacute -15\r\nKPX k ydieresis -15\r\nKPX kcommaaccent e -10\r\nKPX kcommaaccent eacute -10\r\nKPX kcommaaccent ecaron -10\r\nKPX kcommaaccent ecircumflex -10\r\nKPX kcommaaccent edieresis -10\r\nKPX kcommaaccent edotaccent -10\r\nKPX kcommaaccent egrave -10\r\nKPX kcommaaccent emacron -10\r\nKPX kcommaaccent eogonek -10\r\nKPX kcommaaccent o -10\r\nKPX kcommaaccent oacute -10\r\nKPX kcommaaccent ocircumflex -10\r\nKPX kcommaaccent odieresis -10\r\nKPX kcommaaccent ograve -10\r\nKPX kcommaaccent ohungarumlaut -10\r\nKPX kcommaaccent omacron -10\r\nKPX kcommaaccent oslash -10\r\nKPX kcommaaccent otilde -10\r\nKPX kcommaaccent y -15\r\nKPX kcommaaccent yacute -15\r\nKPX kcommaaccent ydieresis -15\r\nKPX l w -10\r\nKPX lacute w -10\r\nKPX lcommaaccent w -10\r\nKPX lslash w -10\r\nKPX n v -40\r\nKPX n y -15\r\nKPX n yacute -15\r\nKPX n ydieresis -15\r\nKPX nacute v -40\r\nKPX nacute y -15\r\nKPX nacute yacute -15\r\nKPX nacute ydieresis -15\r\nKPX ncaron v -40\r\nKPX ncaron y -15\r\nKPX ncaron yacute -15\r\nKPX ncaron ydieresis -15\r\nKPX ncommaaccent v -40\r\nKPX ncommaaccent y -15\r\nKPX ncommaaccent yacute -15\r\nKPX ncommaaccent ydieresis -15\r\nKPX ntilde v -40\r\nKPX ntilde y -15\r\nKPX ntilde yacute -15\r\nKPX ntilde ydieresis -15\r\nKPX o v -15\r\nKPX o w -25\r\nKPX o y -10\r\nKPX o yacute -10\r\nKPX o ydieresis -10\r\nKPX oacute v -15\r\nKPX oacute w -25\r\nKPX oacute y -10\r\nKPX oacute yacute -10\r\nKPX oacute ydieresis -10\r\nKPX ocircumflex v -15\r\nKPX ocircumflex w -25\r\nKPX ocircumflex y -10\r\nKPX ocircumflex yacute -10\r\nKPX ocircumflex ydieresis -10\r\nKPX odieresis v -15\r\nKPX odieresis w -25\r\nKPX odieresis y -10\r\nKPX odieresis yacute -10\r\nKPX odieresis ydieresis -10\r\nKPX ograve v -15\r\nKPX ograve w -25\r\nKPX ograve y -10\r\nKPX ograve yacute -10\r\nKPX ograve ydieresis -10\r\nKPX ohungarumlaut v -15\r\nKPX ohungarumlaut w -25\r\nKPX ohungarumlaut y -10\r\nKPX ohungarumlaut yacute -10\r\nKPX ohungarumlaut ydieresis -10\r\nKPX omacron v -15\r\nKPX omacron w -25\r\nKPX omacron y -10\r\nKPX omacron yacute -10\r\nKPX omacron ydieresis -10\r\nKPX oslash v -15\r\nKPX oslash w -25\r\nKPX oslash y -10\r\nKPX oslash yacute -10\r\nKPX oslash ydieresis -10\r\nKPX otilde v -15\r\nKPX otilde w -25\r\nKPX otilde y -10\r\nKPX otilde yacute -10\r\nKPX otilde ydieresis -10\r\nKPX p y -10\r\nKPX p yacute -10\r\nKPX p ydieresis -10\r\nKPX period quotedblright -70\r\nKPX period quoteright -70\r\nKPX quotedblleft A -80\r\nKPX quotedblleft Aacute -80\r\nKPX quotedblleft Abreve -80\r\nKPX quotedblleft Acircumflex -80\r\nKPX quotedblleft Adieresis -80\r\nKPX quotedblleft Agrave -80\r\nKPX quotedblleft Amacron -80\r\nKPX quotedblleft Aogonek -80\r\nKPX quotedblleft Aring -80\r\nKPX quotedblleft Atilde -80\r\nKPX quoteleft A -80\r\nKPX quoteleft Aacute -80\r\nKPX quoteleft Abreve -80\r\nKPX quoteleft Acircumflex -80\r\nKPX quoteleft Adieresis -80\r\nKPX quoteleft Agrave -80\r\nKPX quoteleft Amacron -80\r\nKPX quoteleft Aogonek -80\r\nKPX quoteleft Aring -80\r\nKPX quoteleft Atilde -80\r\nKPX quoteleft quoteleft -74\r\nKPX quoteright d -50\r\nKPX quoteright dcroat -50\r\nKPX quoteright l -10\r\nKPX quoteright lacute -10\r\nKPX quoteright lcommaaccent -10\r\nKPX quoteright lslash -10\r\nKPX quoteright quoteright -74\r\nKPX quoteright r -50\r\nKPX quoteright racute -50\r\nKPX quoteright rcaron -50\r\nKPX quoteright rcommaaccent -50\r\nKPX quoteright s -55\r\nKPX quoteright sacute -55\r\nKPX quoteright scaron -55\r\nKPX quoteright scedilla -55\r\nKPX quoteright scommaaccent -55\r\nKPX quoteright space -74\r\nKPX quoteright t -18\r\nKPX quoteright tcommaaccent -18\r\nKPX quoteright v -50\r\nKPX r comma -40\r\nKPX r g -18\r\nKPX r gbreve -18\r\nKPX r gcommaaccent -18\r\nKPX r hyphen -20\r\nKPX r period -55\r\nKPX racute comma -40\r\nKPX racute g -18\r\nKPX racute gbreve -18\r\nKPX racute gcommaaccent -18\r\nKPX racute hyphen -20\r\nKPX racute period -55\r\nKPX rcaron comma -40\r\nKPX rcaron g -18\r\nKPX rcaron gbreve -18\r\nKPX rcaron gcommaaccent -18\r\nKPX rcaron hyphen -20\r\nKPX rcaron period -55\r\nKPX rcommaaccent comma -40\r\nKPX rcommaaccent g -18\r\nKPX rcommaaccent gbreve -18\r\nKPX rcommaaccent gcommaaccent -18\r\nKPX rcommaaccent hyphen -20\r\nKPX rcommaaccent period -55\r\nKPX space A -55\r\nKPX space Aacute -55\r\nKPX space Abreve -55\r\nKPX space Acircumflex -55\r\nKPX space Adieresis -55\r\nKPX space Agrave -55\r\nKPX space Amacron -55\r\nKPX space Aogonek -55\r\nKPX space Aring -55\r\nKPX space Atilde -55\r\nKPX space T -18\r\nKPX space Tcaron -18\r\nKPX space Tcommaaccent -18\r\nKPX space V -50\r\nKPX space W -30\r\nKPX space Y -90\r\nKPX space Yacute -90\r\nKPX space Ydieresis -90\r\nKPX v a -25\r\nKPX v aacute -25\r\nKPX v abreve -25\r\nKPX v acircumflex -25\r\nKPX v adieresis -25\r\nKPX v agrave -25\r\nKPX v amacron -25\r\nKPX v aogonek -25\r\nKPX v aring -25\r\nKPX v atilde -25\r\nKPX v comma -65\r\nKPX v e -15\r\nKPX v eacute -15\r\nKPX v ecaron -15\r\nKPX v ecircumflex -15\r\nKPX v edieresis -15\r\nKPX v edotaccent -15\r\nKPX v egrave -15\r\nKPX v emacron -15\r\nKPX v eogonek -15\r\nKPX v o -20\r\nKPX v oacute -20\r\nKPX v ocircumflex -20\r\nKPX v odieresis -20\r\nKPX v ograve -20\r\nKPX v ohungarumlaut -20\r\nKPX v omacron -20\r\nKPX v oslash -20\r\nKPX v otilde -20\r\nKPX v period -65\r\nKPX w a -10\r\nKPX w aacute -10\r\nKPX w abreve -10\r\nKPX w acircumflex -10\r\nKPX w adieresis -10\r\nKPX w agrave -10\r\nKPX w amacron -10\r\nKPX w aogonek -10\r\nKPX w aring -10\r\nKPX w atilde -10\r\nKPX w comma -65\r\nKPX w o -10\r\nKPX w oacute -10\r\nKPX w ocircumflex -10\r\nKPX w odieresis -10\r\nKPX w ograve -10\r\nKPX w ohungarumlaut -10\r\nKPX w omacron -10\r\nKPX w oslash -10\r\nKPX w otilde -10\r\nKPX w period -65\r\nKPX x e -15\r\nKPX x eacute -15\r\nKPX x ecaron -15\r\nKPX x ecircumflex -15\r\nKPX x edieresis -15\r\nKPX x edotaccent -15\r\nKPX x egrave -15\r\nKPX x emacron -15\r\nKPX x eogonek -15\r\nKPX y comma -65\r\nKPX y period -65\r\nKPX yacute comma -65\r\nKPX yacute period -65\r\nKPX ydieresis comma -65\r\nKPX ydieresis period -65\r\nEndKernPairs\r\nEndKernData\r\nEndFontMetrics\r\n";
  },
  'Times-Bold'() {
    return "StartFontMetrics 4.1\r\nComment Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.\r\nComment Creation Date: Thu May  1 12:52:56 1997\r\nComment UniqueID 43065\r\nComment VMusage 41636 52661\r\nFontName Times-Bold\r\nFullName Times Bold\r\nFamilyName Times\r\nWeight Bold\r\nItalicAngle 0\r\nIsFixedPitch false\r\nCharacterSet ExtendedRoman\r\nFontBBox -168 -218 1000 935 \r\nUnderlinePosition -100\r\nUnderlineThickness 50\r\nVersion 002.000\r\nNotice Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.Times is a trademark of Linotype-Hell AG and/or its subsidiaries.\r\nEncodingScheme AdobeStandardEncoding\r\nCapHeight 676\r\nXHeight 461\r\nAscender 683\r\nDescender -217\r\nStdHW 44\r\nStdVW 139\r\nStartCharMetrics 315\r\nC 32 ; WX 250 ; N space ; B 0 0 0 0 ;\r\nC 33 ; WX 333 ; N exclam ; B 81 -13 251 691 ;\r\nC 34 ; WX 555 ; N quotedbl ; B 83 404 472 691 ;\r\nC 35 ; WX 500 ; N numbersign ; B 4 0 496 700 ;\r\nC 36 ; WX 500 ; N dollar ; B 29 -99 472 750 ;\r\nC 37 ; WX 1000 ; N percent ; B 124 -14 877 692 ;\r\nC 38 ; WX 833 ; N ampersand ; B 62 -16 787 691 ;\r\nC 39 ; WX 333 ; N quoteright ; B 79 356 263 691 ;\r\nC 40 ; WX 333 ; N parenleft ; B 46 -168 306 694 ;\r\nC 41 ; WX 333 ; N parenright ; B 27 -168 287 694 ;\r\nC 42 ; WX 500 ; N asterisk ; B 56 255 447 691 ;\r\nC 43 ; WX 570 ; N plus ; B 33 0 537 506 ;\r\nC 44 ; WX 250 ; N comma ; B 39 -180 223 155 ;\r\nC 45 ; WX 333 ; N hyphen ; B 44 171 287 287 ;\r\nC 46 ; WX 250 ; N period ; B 41 -13 210 156 ;\r\nC 47 ; WX 278 ; N slash ; B -24 -19 302 691 ;\r\nC 48 ; WX 500 ; N zero ; B 24 -13 476 688 ;\r\nC 49 ; WX 500 ; N one ; B 65 0 442 688 ;\r\nC 50 ; WX 500 ; N two ; B 17 0 478 688 ;\r\nC 51 ; WX 500 ; N three ; B 16 -14 468 688 ;\r\nC 52 ; WX 500 ; N four ; B 19 0 475 688 ;\r\nC 53 ; WX 500 ; N five ; B 22 -8 470 676 ;\r\nC 54 ; WX 500 ; N six ; B 28 -13 475 688 ;\r\nC 55 ; WX 500 ; N seven ; B 17 0 477 676 ;\r\nC 56 ; WX 500 ; N eight ; B 28 -13 472 688 ;\r\nC 57 ; WX 500 ; N nine ; B 26 -13 473 688 ;\r\nC 58 ; WX 333 ; N colon ; B 82 -13 251 472 ;\r\nC 59 ; WX 333 ; N semicolon ; B 82 -180 266 472 ;\r\nC 60 ; WX 570 ; N less ; B 31 -8 539 514 ;\r\nC 61 ; WX 570 ; N equal ; B 33 107 537 399 ;\r\nC 62 ; WX 570 ; N greater ; B 31 -8 539 514 ;\r\nC 63 ; WX 500 ; N question ; B 57 -13 445 689 ;\r\nC 64 ; WX 930 ; N at ; B 108 -19 822 691 ;\r\nC 65 ; WX 722 ; N A ; B 9 0 689 690 ;\r\nC 66 ; WX 667 ; N B ; B 16 0 619 676 ;\r\nC 67 ; WX 722 ; N C ; B 49 -19 687 691 ;\r\nC 68 ; WX 722 ; N D ; B 14 0 690 676 ;\r\nC 69 ; WX 667 ; N E ; B 16 0 641 676 ;\r\nC 70 ; WX 611 ; N F ; B 16 0 583 676 ;\r\nC 71 ; WX 778 ; N G ; B 37 -19 755 691 ;\r\nC 72 ; WX 778 ; N H ; B 21 0 759 676 ;\r\nC 73 ; WX 389 ; N I ; B 20 0 370 676 ;\r\nC 74 ; WX 500 ; N J ; B 3 -96 479 676 ;\r\nC 75 ; WX 778 ; N K ; B 30 0 769 676 ;\r\nC 76 ; WX 667 ; N L ; B 19 0 638 676 ;\r\nC 77 ; WX 944 ; N M ; B 14 0 921 676 ;\r\nC 78 ; WX 722 ; N N ; B 16 -18 701 676 ;\r\nC 79 ; WX 778 ; N O ; B 35 -19 743 691 ;\r\nC 80 ; WX 611 ; N P ; B 16 0 600 676 ;\r\nC 81 ; WX 778 ; N Q ; B 35 -176 743 691 ;\r\nC 82 ; WX 722 ; N R ; B 26 0 715 676 ;\r\nC 83 ; WX 556 ; N S ; B 35 -19 513 692 ;\r\nC 84 ; WX 667 ; N T ; B 31 0 636 676 ;\r\nC 85 ; WX 722 ; N U ; B 16 -19 701 676 ;\r\nC 86 ; WX 722 ; N V ; B 16 -18 701 676 ;\r\nC 87 ; WX 1000 ; N W ; B 19 -15 981 676 ;\r\nC 88 ; WX 722 ; N X ; B 16 0 699 676 ;\r\nC 89 ; WX 722 ; N Y ; B 15 0 699 676 ;\r\nC 90 ; WX 667 ; N Z ; B 28 0 634 676 ;\r\nC 91 ; WX 333 ; N bracketleft ; B 67 -149 301 678 ;\r\nC 92 ; WX 278 ; N backslash ; B -25 -19 303 691 ;\r\nC 93 ; WX 333 ; N bracketright ; B 32 -149 266 678 ;\r\nC 94 ; WX 581 ; N asciicircum ; B 73 311 509 676 ;\r\nC 95 ; WX 500 ; N underscore ; B 0 -125 500 -75 ;\r\nC 96 ; WX 333 ; N quoteleft ; B 70 356 254 691 ;\r\nC 97 ; WX 500 ; N a ; B 25 -14 488 473 ;\r\nC 98 ; WX 556 ; N b ; B 17 -14 521 676 ;\r\nC 99 ; WX 444 ; N c ; B 25 -14 430 473 ;\r\nC 100 ; WX 556 ; N d ; B 25 -14 534 676 ;\r\nC 101 ; WX 444 ; N e ; B 25 -14 426 473 ;\r\nC 102 ; WX 333 ; N f ; B 14 0 389 691 ; L i fi ; L l fl ;\r\nC 103 ; WX 500 ; N g ; B 28 -206 483 473 ;\r\nC 104 ; WX 556 ; N h ; B 16 0 534 676 ;\r\nC 105 ; WX 278 ; N i ; B 16 0 255 691 ;\r\nC 106 ; WX 333 ; N j ; B -57 -203 263 691 ;\r\nC 107 ; WX 556 ; N k ; B 22 0 543 676 ;\r\nC 108 ; WX 278 ; N l ; B 16 0 255 676 ;\r\nC 109 ; WX 833 ; N m ; B 16 0 814 473 ;\r\nC 110 ; WX 556 ; N n ; B 21 0 539 473 ;\r\nC 111 ; WX 500 ; N o ; B 25 -14 476 473 ;\r\nC 112 ; WX 556 ; N p ; B 19 -205 524 473 ;\r\nC 113 ; WX 556 ; N q ; B 34 -205 536 473 ;\r\nC 114 ; WX 444 ; N r ; B 29 0 434 473 ;\r\nC 115 ; WX 389 ; N s ; B 25 -14 361 473 ;\r\nC 116 ; WX 333 ; N t ; B 20 -12 332 630 ;\r\nC 117 ; WX 556 ; N u ; B 16 -14 537 461 ;\r\nC 118 ; WX 500 ; N v ; B 21 -14 485 461 ;\r\nC 119 ; WX 722 ; N w ; B 23 -14 707 461 ;\r\nC 120 ; WX 500 ; N x ; B 12 0 484 461 ;\r\nC 121 ; WX 500 ; N y ; B 16 -205 480 461 ;\r\nC 122 ; WX 444 ; N z ; B 21 0 420 461 ;\r\nC 123 ; WX 394 ; N braceleft ; B 22 -175 340 698 ;\r\nC 124 ; WX 220 ; N bar ; B 66 -218 154 782 ;\r\nC 125 ; WX 394 ; N braceright ; B 54 -175 372 698 ;\r\nC 126 ; WX 520 ; N asciitilde ; B 29 173 491 333 ;\r\nC 161 ; WX 333 ; N exclamdown ; B 82 -203 252 501 ;\r\nC 162 ; WX 500 ; N cent ; B 53 -140 458 588 ;\r\nC 163 ; WX 500 ; N sterling ; B 21 -14 477 684 ;\r\nC 164 ; WX 167 ; N fraction ; B -168 -12 329 688 ;\r\nC 165 ; WX 500 ; N yen ; B -64 0 547 676 ;\r\nC 166 ; WX 500 ; N florin ; B 0 -155 498 706 ;\r\nC 167 ; WX 500 ; N section ; B 57 -132 443 691 ;\r\nC 168 ; WX 500 ; N currency ; B -26 61 526 613 ;\r\nC 169 ; WX 278 ; N quotesingle ; B 75 404 204 691 ;\r\nC 170 ; WX 500 ; N quotedblleft ; B 32 356 486 691 ;\r\nC 171 ; WX 500 ; N guillemotleft ; B 23 36 473 415 ;\r\nC 172 ; WX 333 ; N guilsinglleft ; B 51 36 305 415 ;\r\nC 173 ; WX 333 ; N guilsinglright ; B 28 36 282 415 ;\r\nC 174 ; WX 556 ; N fi ; B 14 0 536 691 ;\r\nC 175 ; WX 556 ; N fl ; B 14 0 536 691 ;\r\nC 177 ; WX 500 ; N endash ; B 0 181 500 271 ;\r\nC 178 ; WX 500 ; N dagger ; B 47 -134 453 691 ;\r\nC 179 ; WX 500 ; N daggerdbl ; B 45 -132 456 691 ;\r\nC 180 ; WX 250 ; N periodcentered ; B 41 248 210 417 ;\r\nC 182 ; WX 540 ; N paragraph ; B 0 -186 519 676 ;\r\nC 183 ; WX 350 ; N bullet ; B 35 198 315 478 ;\r\nC 184 ; WX 333 ; N quotesinglbase ; B 79 -180 263 155 ;\r\nC 185 ; WX 500 ; N quotedblbase ; B 14 -180 468 155 ;\r\nC 186 ; WX 500 ; N quotedblright ; B 14 356 468 691 ;\r\nC 187 ; WX 500 ; N guillemotright ; B 27 36 477 415 ;\r\nC 188 ; WX 1000 ; N ellipsis ; B 82 -13 917 156 ;\r\nC 189 ; WX 1000 ; N perthousand ; B 7 -29 995 706 ;\r\nC 191 ; WX 500 ; N questiondown ; B 55 -201 443 501 ;\r\nC 193 ; WX 333 ; N grave ; B 8 528 246 713 ;\r\nC 194 ; WX 333 ; N acute ; B 86 528 324 713 ;\r\nC 195 ; WX 333 ; N circumflex ; B -2 528 335 704 ;\r\nC 196 ; WX 333 ; N tilde ; B -16 547 349 674 ;\r\nC 197 ; WX 333 ; N macron ; B 1 565 331 637 ;\r\nC 198 ; WX 333 ; N breve ; B 15 528 318 691 ;\r\nC 199 ; WX 333 ; N dotaccent ; B 103 536 258 691 ;\r\nC 200 ; WX 333 ; N dieresis ; B -2 537 335 667 ;\r\nC 202 ; WX 333 ; N ring ; B 60 527 273 740 ;\r\nC 203 ; WX 333 ; N cedilla ; B 68 -218 294 0 ;\r\nC 205 ; WX 333 ; N hungarumlaut ; B -13 528 425 713 ;\r\nC 206 ; WX 333 ; N ogonek ; B 90 -193 319 24 ;\r\nC 207 ; WX 333 ; N caron ; B -2 528 335 704 ;\r\nC 208 ; WX 1000 ; N emdash ; B 0 181 1000 271 ;\r\nC 225 ; WX 1000 ; N AE ; B 4 0 951 676 ;\r\nC 227 ; WX 300 ; N ordfeminine ; B -1 397 301 688 ;\r\nC 232 ; WX 667 ; N Lslash ; B 19 0 638 676 ;\r\nC 233 ; WX 778 ; N Oslash ; B 35 -74 743 737 ;\r\nC 234 ; WX 1000 ; N OE ; B 22 -5 981 684 ;\r\nC 235 ; WX 330 ; N ordmasculine ; B 18 397 312 688 ;\r\nC 241 ; WX 722 ; N ae ; B 33 -14 693 473 ;\r\nC 245 ; WX 278 ; N dotlessi ; B 16 0 255 461 ;\r\nC 248 ; WX 278 ; N lslash ; B -22 0 303 676 ;\r\nC 249 ; WX 500 ; N oslash ; B 25 -92 476 549 ;\r\nC 250 ; WX 722 ; N oe ; B 22 -14 696 473 ;\r\nC 251 ; WX 556 ; N germandbls ; B 19 -12 517 691 ;\r\nC -1 ; WX 389 ; N Idieresis ; B 20 0 370 877 ;\r\nC -1 ; WX 444 ; N eacute ; B 25 -14 426 713 ;\r\nC -1 ; WX 500 ; N abreve ; B 25 -14 488 691 ;\r\nC -1 ; WX 556 ; N uhungarumlaut ; B 16 -14 557 713 ;\r\nC -1 ; WX 444 ; N ecaron ; B 25 -14 426 704 ;\r\nC -1 ; WX 722 ; N Ydieresis ; B 15 0 699 877 ;\r\nC -1 ; WX 570 ; N divide ; B 33 -31 537 537 ;\r\nC -1 ; WX 722 ; N Yacute ; B 15 0 699 923 ;\r\nC -1 ; WX 722 ; N Acircumflex ; B 9 0 689 914 ;\r\nC -1 ; WX 500 ; N aacute ; B 25 -14 488 713 ;\r\nC -1 ; WX 722 ; N Ucircumflex ; B 16 -19 701 914 ;\r\nC -1 ; WX 500 ; N yacute ; B 16 -205 480 713 ;\r\nC -1 ; WX 389 ; N scommaaccent ; B 25 -218 361 473 ;\r\nC -1 ; WX 444 ; N ecircumflex ; B 25 -14 426 704 ;\r\nC -1 ; WX 722 ; N Uring ; B 16 -19 701 935 ;\r\nC -1 ; WX 722 ; N Udieresis ; B 16 -19 701 877 ;\r\nC -1 ; WX 500 ; N aogonek ; B 25 -193 504 473 ;\r\nC -1 ; WX 722 ; N Uacute ; B 16 -19 701 923 ;\r\nC -1 ; WX 556 ; N uogonek ; B 16 -193 539 461 ;\r\nC -1 ; WX 667 ; N Edieresis ; B 16 0 641 877 ;\r\nC -1 ; WX 722 ; N Dcroat ; B 6 0 690 676 ;\r\nC -1 ; WX 250 ; N commaaccent ; B 47 -218 203 -50 ;\r\nC -1 ; WX 747 ; N copyright ; B 26 -19 721 691 ;\r\nC -1 ; WX 667 ; N Emacron ; B 16 0 641 847 ;\r\nC -1 ; WX 444 ; N ccaron ; B 25 -14 430 704 ;\r\nC -1 ; WX 500 ; N aring ; B 25 -14 488 740 ;\r\nC -1 ; WX 722 ; N Ncommaaccent ; B 16 -188 701 676 ;\r\nC -1 ; WX 278 ; N lacute ; B 16 0 297 923 ;\r\nC -1 ; WX 500 ; N agrave ; B 25 -14 488 713 ;\r\nC -1 ; WX 667 ; N Tcommaaccent ; B 31 -218 636 676 ;\r\nC -1 ; WX 722 ; N Cacute ; B 49 -19 687 923 ;\r\nC -1 ; WX 500 ; N atilde ; B 25 -14 488 674 ;\r\nC -1 ; WX 667 ; N Edotaccent ; B 16 0 641 901 ;\r\nC -1 ; WX 389 ; N scaron ; B 25 -14 363 704 ;\r\nC -1 ; WX 389 ; N scedilla ; B 25 -218 361 473 ;\r\nC -1 ; WX 278 ; N iacute ; B 16 0 289 713 ;\r\nC -1 ; WX 494 ; N lozenge ; B 10 0 484 745 ;\r\nC -1 ; WX 722 ; N Rcaron ; B 26 0 715 914 ;\r\nC -1 ; WX 778 ; N Gcommaaccent ; B 37 -218 755 691 ;\r\nC -1 ; WX 556 ; N ucircumflex ; B 16 -14 537 704 ;\r\nC -1 ; WX 500 ; N acircumflex ; B 25 -14 488 704 ;\r\nC -1 ; WX 722 ; N Amacron ; B 9 0 689 847 ;\r\nC -1 ; WX 444 ; N rcaron ; B 29 0 434 704 ;\r\nC -1 ; WX 444 ; N ccedilla ; B 25 -218 430 473 ;\r\nC -1 ; WX 667 ; N Zdotaccent ; B 28 0 634 901 ;\r\nC -1 ; WX 611 ; N Thorn ; B 16 0 600 676 ;\r\nC -1 ; WX 778 ; N Omacron ; B 35 -19 743 847 ;\r\nC -1 ; WX 722 ; N Racute ; B 26 0 715 923 ;\r\nC -1 ; WX 556 ; N Sacute ; B 35 -19 513 923 ;\r\nC -1 ; WX 672 ; N dcaron ; B 25 -14 681 682 ;\r\nC -1 ; WX 722 ; N Umacron ; B 16 -19 701 847 ;\r\nC -1 ; WX 556 ; N uring ; B 16 -14 537 740 ;\r\nC -1 ; WX 300 ; N threesuperior ; B 3 268 297 688 ;\r\nC -1 ; WX 778 ; N Ograve ; B 35 -19 743 923 ;\r\nC -1 ; WX 722 ; N Agrave ; B 9 0 689 923 ;\r\nC -1 ; WX 722 ; N Abreve ; B 9 0 689 901 ;\r\nC -1 ; WX 570 ; N multiply ; B 48 16 522 490 ;\r\nC -1 ; WX 556 ; N uacute ; B 16 -14 537 713 ;\r\nC -1 ; WX 667 ; N Tcaron ; B 31 0 636 914 ;\r\nC -1 ; WX 494 ; N partialdiff ; B 11 -21 494 750 ;\r\nC -1 ; WX 500 ; N ydieresis ; B 16 -205 480 667 ;\r\nC -1 ; WX 722 ; N Nacute ; B 16 -18 701 923 ;\r\nC -1 ; WX 278 ; N icircumflex ; B -37 0 300 704 ;\r\nC -1 ; WX 667 ; N Ecircumflex ; B 16 0 641 914 ;\r\nC -1 ; WX 500 ; N adieresis ; B 25 -14 488 667 ;\r\nC -1 ; WX 444 ; N edieresis ; B 25 -14 426 667 ;\r\nC -1 ; WX 444 ; N cacute ; B 25 -14 430 713 ;\r\nC -1 ; WX 556 ; N nacute ; B 21 0 539 713 ;\r\nC -1 ; WX 556 ; N umacron ; B 16 -14 537 637 ;\r\nC -1 ; WX 722 ; N Ncaron ; B 16 -18 701 914 ;\r\nC -1 ; WX 389 ; N Iacute ; B 20 0 370 923 ;\r\nC -1 ; WX 570 ; N plusminus ; B 33 0 537 506 ;\r\nC -1 ; WX 220 ; N brokenbar ; B 66 -143 154 707 ;\r\nC -1 ; WX 747 ; N registered ; B 26 -19 721 691 ;\r\nC -1 ; WX 778 ; N Gbreve ; B 37 -19 755 901 ;\r\nC -1 ; WX 389 ; N Idotaccent ; B 20 0 370 901 ;\r\nC -1 ; WX 600 ; N summation ; B 14 -10 585 706 ;\r\nC -1 ; WX 667 ; N Egrave ; B 16 0 641 923 ;\r\nC -1 ; WX 444 ; N racute ; B 29 0 434 713 ;\r\nC -1 ; WX 500 ; N omacron ; B 25 -14 476 637 ;\r\nC -1 ; WX 667 ; N Zacute ; B 28 0 634 923 ;\r\nC -1 ; WX 667 ; N Zcaron ; B 28 0 634 914 ;\r\nC -1 ; WX 549 ; N greaterequal ; B 26 0 523 704 ;\r\nC -1 ; WX 722 ; N Eth ; B 6 0 690 676 ;\r\nC -1 ; WX 722 ; N Ccedilla ; B 49 -218 687 691 ;\r\nC -1 ; WX 278 ; N lcommaaccent ; B 16 -218 255 676 ;\r\nC -1 ; WX 416 ; N tcaron ; B 20 -12 425 815 ;\r\nC -1 ; WX 444 ; N eogonek ; B 25 -193 426 473 ;\r\nC -1 ; WX 722 ; N Uogonek ; B 16 -193 701 676 ;\r\nC -1 ; WX 722 ; N Aacute ; B 9 0 689 923 ;\r\nC -1 ; WX 722 ; N Adieresis ; B 9 0 689 877 ;\r\nC -1 ; WX 444 ; N egrave ; B 25 -14 426 713 ;\r\nC -1 ; WX 444 ; N zacute ; B 21 0 420 713 ;\r\nC -1 ; WX 278 ; N iogonek ; B 16 -193 274 691 ;\r\nC -1 ; WX 778 ; N Oacute ; B 35 -19 743 923 ;\r\nC -1 ; WX 500 ; N oacute ; B 25 -14 476 713 ;\r\nC -1 ; WX 500 ; N amacron ; B 25 -14 488 637 ;\r\nC -1 ; WX 389 ; N sacute ; B 25 -14 361 713 ;\r\nC -1 ; WX 278 ; N idieresis ; B -37 0 300 667 ;\r\nC -1 ; WX 778 ; N Ocircumflex ; B 35 -19 743 914 ;\r\nC -1 ; WX 722 ; N Ugrave ; B 16 -19 701 923 ;\r\nC -1 ; WX 612 ; N Delta ; B 6 0 608 688 ;\r\nC -1 ; WX 556 ; N thorn ; B 19 -205 524 676 ;\r\nC -1 ; WX 300 ; N twosuperior ; B 0 275 300 688 ;\r\nC -1 ; WX 778 ; N Odieresis ; B 35 -19 743 877 ;\r\nC -1 ; WX 556 ; N mu ; B 33 -206 536 461 ;\r\nC -1 ; WX 278 ; N igrave ; B -27 0 255 713 ;\r\nC -1 ; WX 500 ; N ohungarumlaut ; B 25 -14 529 713 ;\r\nC -1 ; WX 667 ; N Eogonek ; B 16 -193 644 676 ;\r\nC -1 ; WX 556 ; N dcroat ; B 25 -14 534 676 ;\r\nC -1 ; WX 750 ; N threequarters ; B 23 -12 733 688 ;\r\nC -1 ; WX 556 ; N Scedilla ; B 35 -218 513 692 ;\r\nC -1 ; WX 394 ; N lcaron ; B 16 0 412 682 ;\r\nC -1 ; WX 778 ; N Kcommaaccent ; B 30 -218 769 676 ;\r\nC -1 ; WX 667 ; N Lacute ; B 19 0 638 923 ;\r\nC -1 ; WX 1000 ; N trademark ; B 24 271 977 676 ;\r\nC -1 ; WX 444 ; N edotaccent ; B 25 -14 426 691 ;\r\nC -1 ; WX 389 ; N Igrave ; B 20 0 370 923 ;\r\nC -1 ; WX 389 ; N Imacron ; B 20 0 370 847 ;\r\nC -1 ; WX 667 ; N Lcaron ; B 19 0 652 682 ;\r\nC -1 ; WX 750 ; N onehalf ; B -7 -12 775 688 ;\r\nC -1 ; WX 549 ; N lessequal ; B 29 0 526 704 ;\r\nC -1 ; WX 500 ; N ocircumflex ; B 25 -14 476 704 ;\r\nC -1 ; WX 556 ; N ntilde ; B 21 0 539 674 ;\r\nC -1 ; WX 722 ; N Uhungarumlaut ; B 16 -19 701 923 ;\r\nC -1 ; WX 667 ; N Eacute ; B 16 0 641 923 ;\r\nC -1 ; WX 444 ; N emacron ; B 25 -14 426 637 ;\r\nC -1 ; WX 500 ; N gbreve ; B 28 -206 483 691 ;\r\nC -1 ; WX 750 ; N onequarter ; B 28 -12 743 688 ;\r\nC -1 ; WX 556 ; N Scaron ; B 35 -19 513 914 ;\r\nC -1 ; WX 556 ; N Scommaaccent ; B 35 -218 513 692 ;\r\nC -1 ; WX 778 ; N Ohungarumlaut ; B 35 -19 743 923 ;\r\nC -1 ; WX 400 ; N degree ; B 57 402 343 688 ;\r\nC -1 ; WX 500 ; N ograve ; B 25 -14 476 713 ;\r\nC -1 ; WX 722 ; N Ccaron ; B 49 -19 687 914 ;\r\nC -1 ; WX 556 ; N ugrave ; B 16 -14 537 713 ;\r\nC -1 ; WX 549 ; N radical ; B 10 -46 512 850 ;\r\nC -1 ; WX 722 ; N Dcaron ; B 14 0 690 914 ;\r\nC -1 ; WX 444 ; N rcommaaccent ; B 29 -218 434 473 ;\r\nC -1 ; WX 722 ; N Ntilde ; B 16 -18 701 884 ;\r\nC -1 ; WX 500 ; N otilde ; B 25 -14 476 674 ;\r\nC -1 ; WX 722 ; N Rcommaaccent ; B 26 -218 715 676 ;\r\nC -1 ; WX 667 ; N Lcommaaccent ; B 19 -218 638 676 ;\r\nC -1 ; WX 722 ; N Atilde ; B 9 0 689 884 ;\r\nC -1 ; WX 722 ; N Aogonek ; B 9 -193 699 690 ;\r\nC -1 ; WX 722 ; N Aring ; B 9 0 689 935 ;\r\nC -1 ; WX 778 ; N Otilde ; B 35 -19 743 884 ;\r\nC -1 ; WX 444 ; N zdotaccent ; B 21 0 420 691 ;\r\nC -1 ; WX 667 ; N Ecaron ; B 16 0 641 914 ;\r\nC -1 ; WX 389 ; N Iogonek ; B 20 -193 370 676 ;\r\nC -1 ; WX 556 ; N kcommaaccent ; B 22 -218 543 676 ;\r\nC -1 ; WX 570 ; N minus ; B 33 209 537 297 ;\r\nC -1 ; WX 389 ; N Icircumflex ; B 20 0 370 914 ;\r\nC -1 ; WX 556 ; N ncaron ; B 21 0 539 704 ;\r\nC -1 ; WX 333 ; N tcommaaccent ; B 20 -218 332 630 ;\r\nC -1 ; WX 570 ; N logicalnot ; B 33 108 537 399 ;\r\nC -1 ; WX 500 ; N odieresis ; B 25 -14 476 667 ;\r\nC -1 ; WX 556 ; N udieresis ; B 16 -14 537 667 ;\r\nC -1 ; WX 549 ; N notequal ; B 15 -49 540 570 ;\r\nC -1 ; WX 500 ; N gcommaaccent ; B 28 -206 483 829 ;\r\nC -1 ; WX 500 ; N eth ; B 25 -14 476 691 ;\r\nC -1 ; WX 444 ; N zcaron ; B 21 0 420 704 ;\r\nC -1 ; WX 556 ; N ncommaaccent ; B 21 -218 539 473 ;\r\nC -1 ; WX 300 ; N onesuperior ; B 28 275 273 688 ;\r\nC -1 ; WX 278 ; N imacron ; B -8 0 272 637 ;\r\nC -1 ; WX 500 ; N Euro ; B 0 0 0 0 ;\r\nEndCharMetrics\r\nStartKernData\r\nStartKernPairs 2242\r\nKPX A C -55\r\nKPX A Cacute -55\r\nKPX A Ccaron -55\r\nKPX A Ccedilla -55\r\nKPX A G -55\r\nKPX A Gbreve -55\r\nKPX A Gcommaaccent -55\r\nKPX A O -45\r\nKPX A Oacute -45\r\nKPX A Ocircumflex -45\r\nKPX A Odieresis -45\r\nKPX A Ograve -45\r\nKPX A Ohungarumlaut -45\r\nKPX A Omacron -45\r\nKPX A Oslash -45\r\nKPX A Otilde -45\r\nKPX A Q -45\r\nKPX A T -95\r\nKPX A Tcaron -95\r\nKPX A Tcommaaccent -95\r\nKPX A U -50\r\nKPX A Uacute -50\r\nKPX A Ucircumflex -50\r\nKPX A Udieresis -50\r\nKPX A Ugrave -50\r\nKPX A Uhungarumlaut -50\r\nKPX A Umacron -50\r\nKPX A Uogonek -50\r\nKPX A Uring -50\r\nKPX A V -145\r\nKPX A W -130\r\nKPX A Y -100\r\nKPX A Yacute -100\r\nKPX A Ydieresis -100\r\nKPX A p -25\r\nKPX A quoteright -74\r\nKPX A u -50\r\nKPX A uacute -50\r\nKPX A ucircumflex -50\r\nKPX A udieresis -50\r\nKPX A ugrave -50\r\nKPX A uhungarumlaut -50\r\nKPX A umacron -50\r\nKPX A uogonek -50\r\nKPX A uring -50\r\nKPX A v -100\r\nKPX A w -90\r\nKPX A y -74\r\nKPX A yacute -74\r\nKPX A ydieresis -74\r\nKPX Aacute C -55\r\nKPX Aacute Cacute -55\r\nKPX Aacute Ccaron -55\r\nKPX Aacute Ccedilla -55\r\nKPX Aacute G -55\r\nKPX Aacute Gbreve -55\r\nKPX Aacute Gcommaaccent -55\r\nKPX Aacute O -45\r\nKPX Aacute Oacute -45\r\nKPX Aacute Ocircumflex -45\r\nKPX Aacute Odieresis -45\r\nKPX Aacute Ograve -45\r\nKPX Aacute Ohungarumlaut -45\r\nKPX Aacute Omacron -45\r\nKPX Aacute Oslash -45\r\nKPX Aacute Otilde -45\r\nKPX Aacute Q -45\r\nKPX Aacute T -95\r\nKPX Aacute Tcaron -95\r\nKPX Aacute Tcommaaccent -95\r\nKPX Aacute U -50\r\nKPX Aacute Uacute -50\r\nKPX Aacute Ucircumflex -50\r\nKPX Aacute Udieresis -50\r\nKPX Aacute Ugrave -50\r\nKPX Aacute Uhungarumlaut -50\r\nKPX Aacute Umacron -50\r\nKPX Aacute Uogonek -50\r\nKPX Aacute Uring -50\r\nKPX Aacute V -145\r\nKPX Aacute W -130\r\nKPX Aacute Y -100\r\nKPX Aacute Yacute -100\r\nKPX Aacute Ydieresis -100\r\nKPX Aacute p -25\r\nKPX Aacute quoteright -74\r\nKPX Aacute u -50\r\nKPX Aacute uacute -50\r\nKPX Aacute ucircumflex -50\r\nKPX Aacute udieresis -50\r\nKPX Aacute ugrave -50\r\nKPX Aacute uhungarumlaut -50\r\nKPX Aacute umacron -50\r\nKPX Aacute uogonek -50\r\nKPX Aacute uring -50\r\nKPX Aacute v -100\r\nKPX Aacute w -90\r\nKPX Aacute y -74\r\nKPX Aacute yacute -74\r\nKPX Aacute ydieresis -74\r\nKPX Abreve C -55\r\nKPX Abreve Cacute -55\r\nKPX Abreve Ccaron -55\r\nKPX Abreve Ccedilla -55\r\nKPX Abreve G -55\r\nKPX Abreve Gbreve -55\r\nKPX Abreve Gcommaaccent -55\r\nKPX Abreve O -45\r\nKPX Abreve Oacute -45\r\nKPX Abreve Ocircumflex -45\r\nKPX Abreve Odieresis -45\r\nKPX Abreve Ograve -45\r\nKPX Abreve Ohungarumlaut -45\r\nKPX Abreve Omacron -45\r\nKPX Abreve Oslash -45\r\nKPX Abreve Otilde -45\r\nKPX Abreve Q -45\r\nKPX Abreve T -95\r\nKPX Abreve Tcaron -95\r\nKPX Abreve Tcommaaccent -95\r\nKPX Abreve U -50\r\nKPX Abreve Uacute -50\r\nKPX Abreve Ucircumflex -50\r\nKPX Abreve Udieresis -50\r\nKPX Abreve Ugrave -50\r\nKPX Abreve Uhungarumlaut -50\r\nKPX Abreve Umacron -50\r\nKPX Abreve Uogonek -50\r\nKPX Abreve Uring -50\r\nKPX Abreve V -145\r\nKPX Abreve W -130\r\nKPX Abreve Y -100\r\nKPX Abreve Yacute -100\r\nKPX Abreve Ydieresis -100\r\nKPX Abreve p -25\r\nKPX Abreve quoteright -74\r\nKPX Abreve u -50\r\nKPX Abreve uacute -50\r\nKPX Abreve ucircumflex -50\r\nKPX Abreve udieresis -50\r\nKPX Abreve ugrave -50\r\nKPX Abreve uhungarumlaut -50\r\nKPX Abreve umacron -50\r\nKPX Abreve uogonek -50\r\nKPX Abreve uring -50\r\nKPX Abreve v -100\r\nKPX Abreve w -90\r\nKPX Abreve y -74\r\nKPX Abreve yacute -74\r\nKPX Abreve ydieresis -74\r\nKPX Acircumflex C -55\r\nKPX Acircumflex Cacute -55\r\nKPX Acircumflex Ccaron -55\r\nKPX Acircumflex Ccedilla -55\r\nKPX Acircumflex G -55\r\nKPX Acircumflex Gbreve -55\r\nKPX Acircumflex Gcommaaccent -55\r\nKPX Acircumflex O -45\r\nKPX Acircumflex Oacute -45\r\nKPX Acircumflex Ocircumflex -45\r\nKPX Acircumflex Odieresis -45\r\nKPX Acircumflex Ograve -45\r\nKPX Acircumflex Ohungarumlaut -45\r\nKPX Acircumflex Omacron -45\r\nKPX Acircumflex Oslash -45\r\nKPX Acircumflex Otilde -45\r\nKPX Acircumflex Q -45\r\nKPX Acircumflex T -95\r\nKPX Acircumflex Tcaron -95\r\nKPX Acircumflex Tcommaaccent -95\r\nKPX Acircumflex U -50\r\nKPX Acircumflex Uacute -50\r\nKPX Acircumflex Ucircumflex -50\r\nKPX Acircumflex Udieresis -50\r\nKPX Acircumflex Ugrave -50\r\nKPX Acircumflex Uhungarumlaut -50\r\nKPX Acircumflex Umacron -50\r\nKPX Acircumflex Uogonek -50\r\nKPX Acircumflex Uring -50\r\nKPX Acircumflex V -145\r\nKPX Acircumflex W -130\r\nKPX Acircumflex Y -100\r\nKPX Acircumflex Yacute -100\r\nKPX Acircumflex Ydieresis -100\r\nKPX Acircumflex p -25\r\nKPX Acircumflex quoteright -74\r\nKPX Acircumflex u -50\r\nKPX Acircumflex uacute -50\r\nKPX Acircumflex ucircumflex -50\r\nKPX Acircumflex udieresis -50\r\nKPX Acircumflex ugrave -50\r\nKPX Acircumflex uhungarumlaut -50\r\nKPX Acircumflex umacron -50\r\nKPX Acircumflex uogonek -50\r\nKPX Acircumflex uring -50\r\nKPX Acircumflex v -100\r\nKPX Acircumflex w -90\r\nKPX Acircumflex y -74\r\nKPX Acircumflex yacute -74\r\nKPX Acircumflex ydieresis -74\r\nKPX Adieresis C -55\r\nKPX Adieresis Cacute -55\r\nKPX Adieresis Ccaron -55\r\nKPX Adieresis Ccedilla -55\r\nKPX Adieresis G -55\r\nKPX Adieresis Gbreve -55\r\nKPX Adieresis Gcommaaccent -55\r\nKPX Adieresis O -45\r\nKPX Adieresis Oacute -45\r\nKPX Adieresis Ocircumflex -45\r\nKPX Adieresis Odieresis -45\r\nKPX Adieresis Ograve -45\r\nKPX Adieresis Ohungarumlaut -45\r\nKPX Adieresis Omacron -45\r\nKPX Adieresis Oslash -45\r\nKPX Adieresis Otilde -45\r\nKPX Adieresis Q -45\r\nKPX Adieresis T -95\r\nKPX Adieresis Tcaron -95\r\nKPX Adieresis Tcommaaccent -95\r\nKPX Adieresis U -50\r\nKPX Adieresis Uacute -50\r\nKPX Adieresis Ucircumflex -50\r\nKPX Adieresis Udieresis -50\r\nKPX Adieresis Ugrave -50\r\nKPX Adieresis Uhungarumlaut -50\r\nKPX Adieresis Umacron -50\r\nKPX Adieresis Uogonek -50\r\nKPX Adieresis Uring -50\r\nKPX Adieresis V -145\r\nKPX Adieresis W -130\r\nKPX Adieresis Y -100\r\nKPX Adieresis Yacute -100\r\nKPX Adieresis Ydieresis -100\r\nKPX Adieresis p -25\r\nKPX Adieresis quoteright -74\r\nKPX Adieresis u -50\r\nKPX Adieresis uacute -50\r\nKPX Adieresis ucircumflex -50\r\nKPX Adieresis udieresis -50\r\nKPX Adieresis ugrave -50\r\nKPX Adieresis uhungarumlaut -50\r\nKPX Adieresis umacron -50\r\nKPX Adieresis uogonek -50\r\nKPX Adieresis uring -50\r\nKPX Adieresis v -100\r\nKPX Adieresis w -90\r\nKPX Adieresis y -74\r\nKPX Adieresis yacute -74\r\nKPX Adieresis ydieresis -74\r\nKPX Agrave C -55\r\nKPX Agrave Cacute -55\r\nKPX Agrave Ccaron -55\r\nKPX Agrave Ccedilla -55\r\nKPX Agrave G -55\r\nKPX Agrave Gbreve -55\r\nKPX Agrave Gcommaaccent -55\r\nKPX Agrave O -45\r\nKPX Agrave Oacute -45\r\nKPX Agrave Ocircumflex -45\r\nKPX Agrave Odieresis -45\r\nKPX Agrave Ograve -45\r\nKPX Agrave Ohungarumlaut -45\r\nKPX Agrave Omacron -45\r\nKPX Agrave Oslash -45\r\nKPX Agrave Otilde -45\r\nKPX Agrave Q -45\r\nKPX Agrave T -95\r\nKPX Agrave Tcaron -95\r\nKPX Agrave Tcommaaccent -95\r\nKPX Agrave U -50\r\nKPX Agrave Uacute -50\r\nKPX Agrave Ucircumflex -50\r\nKPX Agrave Udieresis -50\r\nKPX Agrave Ugrave -50\r\nKPX Agrave Uhungarumlaut -50\r\nKPX Agrave Umacron -50\r\nKPX Agrave Uogonek -50\r\nKPX Agrave Uring -50\r\nKPX Agrave V -145\r\nKPX Agrave W -130\r\nKPX Agrave Y -100\r\nKPX Agrave Yacute -100\r\nKPX Agrave Ydieresis -100\r\nKPX Agrave p -25\r\nKPX Agrave quoteright -74\r\nKPX Agrave u -50\r\nKPX Agrave uacute -50\r\nKPX Agrave ucircumflex -50\r\nKPX Agrave udieresis -50\r\nKPX Agrave ugrave -50\r\nKPX Agrave uhungarumlaut -50\r\nKPX Agrave umacron -50\r\nKPX Agrave uogonek -50\r\nKPX Agrave uring -50\r\nKPX Agrave v -100\r\nKPX Agrave w -90\r\nKPX Agrave y -74\r\nKPX Agrave yacute -74\r\nKPX Agrave ydieresis -74\r\nKPX Amacron C -55\r\nKPX Amacron Cacute -55\r\nKPX Amacron Ccaron -55\r\nKPX Amacron Ccedilla -55\r\nKPX Amacron G -55\r\nKPX Amacron Gbreve -55\r\nKPX Amacron Gcommaaccent -55\r\nKPX Amacron O -45\r\nKPX Amacron Oacute -45\r\nKPX Amacron Ocircumflex -45\r\nKPX Amacron Odieresis -45\r\nKPX Amacron Ograve -45\r\nKPX Amacron Ohungarumlaut -45\r\nKPX Amacron Omacron -45\r\nKPX Amacron Oslash -45\r\nKPX Amacron Otilde -45\r\nKPX Amacron Q -45\r\nKPX Amacron T -95\r\nKPX Amacron Tcaron -95\r\nKPX Amacron Tcommaaccent -95\r\nKPX Amacron U -50\r\nKPX Amacron Uacute -50\r\nKPX Amacron Ucircumflex -50\r\nKPX Amacron Udieresis -50\r\nKPX Amacron Ugrave -50\r\nKPX Amacron Uhungarumlaut -50\r\nKPX Amacron Umacron -50\r\nKPX Amacron Uogonek -50\r\nKPX Amacron Uring -50\r\nKPX Amacron V -145\r\nKPX Amacron W -130\r\nKPX Amacron Y -100\r\nKPX Amacron Yacute -100\r\nKPX Amacron Ydieresis -100\r\nKPX Amacron p -25\r\nKPX Amacron quoteright -74\r\nKPX Amacron u -50\r\nKPX Amacron uacute -50\r\nKPX Amacron ucircumflex -50\r\nKPX Amacron udieresis -50\r\nKPX Amacron ugrave -50\r\nKPX Amacron uhungarumlaut -50\r\nKPX Amacron umacron -50\r\nKPX Amacron uogonek -50\r\nKPX Amacron uring -50\r\nKPX Amacron v -100\r\nKPX Amacron w -90\r\nKPX Amacron y -74\r\nKPX Amacron yacute -74\r\nKPX Amacron ydieresis -74\r\nKPX Aogonek C -55\r\nKPX Aogonek Cacute -55\r\nKPX Aogonek Ccaron -55\r\nKPX Aogonek Ccedilla -55\r\nKPX Aogonek G -55\r\nKPX Aogonek Gbreve -55\r\nKPX Aogonek Gcommaaccent -55\r\nKPX Aogonek O -45\r\nKPX Aogonek Oacute -45\r\nKPX Aogonek Ocircumflex -45\r\nKPX Aogonek Odieresis -45\r\nKPX Aogonek Ograve -45\r\nKPX Aogonek Ohungarumlaut -45\r\nKPX Aogonek Omacron -45\r\nKPX Aogonek Oslash -45\r\nKPX Aogonek Otilde -45\r\nKPX Aogonek Q -45\r\nKPX Aogonek T -95\r\nKPX Aogonek Tcaron -95\r\nKPX Aogonek Tcommaaccent -95\r\nKPX Aogonek U -50\r\nKPX Aogonek Uacute -50\r\nKPX Aogonek Ucircumflex -50\r\nKPX Aogonek Udieresis -50\r\nKPX Aogonek Ugrave -50\r\nKPX Aogonek Uhungarumlaut -50\r\nKPX Aogonek Umacron -50\r\nKPX Aogonek Uogonek -50\r\nKPX Aogonek Uring -50\r\nKPX Aogonek V -145\r\nKPX Aogonek W -130\r\nKPX Aogonek Y -100\r\nKPX Aogonek Yacute -100\r\nKPX Aogonek Ydieresis -100\r\nKPX Aogonek p -25\r\nKPX Aogonek quoteright -74\r\nKPX Aogonek u -50\r\nKPX Aogonek uacute -50\r\nKPX Aogonek ucircumflex -50\r\nKPX Aogonek udieresis -50\r\nKPX Aogonek ugrave -50\r\nKPX Aogonek uhungarumlaut -50\r\nKPX Aogonek umacron -50\r\nKPX Aogonek uogonek -50\r\nKPX Aogonek uring -50\r\nKPX Aogonek v -100\r\nKPX Aogonek w -90\r\nKPX Aogonek y -34\r\nKPX Aogonek yacute -34\r\nKPX Aogonek ydieresis -34\r\nKPX Aring C -55\r\nKPX Aring Cacute -55\r\nKPX Aring Ccaron -55\r\nKPX Aring Ccedilla -55\r\nKPX Aring G -55\r\nKPX Aring Gbreve -55\r\nKPX Aring Gcommaaccent -55\r\nKPX Aring O -45\r\nKPX Aring Oacute -45\r\nKPX Aring Ocircumflex -45\r\nKPX Aring Odieresis -45\r\nKPX Aring Ograve -45\r\nKPX Aring Ohungarumlaut -45\r\nKPX Aring Omacron -45\r\nKPX Aring Oslash -45\r\nKPX Aring Otilde -45\r\nKPX Aring Q -45\r\nKPX Aring T -95\r\nKPX Aring Tcaron -95\r\nKPX Aring Tcommaaccent -95\r\nKPX Aring U -50\r\nKPX Aring Uacute -50\r\nKPX Aring Ucircumflex -50\r\nKPX Aring Udieresis -50\r\nKPX Aring Ugrave -50\r\nKPX Aring Uhungarumlaut -50\r\nKPX Aring Umacron -50\r\nKPX Aring Uogonek -50\r\nKPX Aring Uring -50\r\nKPX Aring V -145\r\nKPX Aring W -130\r\nKPX Aring Y -100\r\nKPX Aring Yacute -100\r\nKPX Aring Ydieresis -100\r\nKPX Aring p -25\r\nKPX Aring quoteright -74\r\nKPX Aring u -50\r\nKPX Aring uacute -50\r\nKPX Aring ucircumflex -50\r\nKPX Aring udieresis -50\r\nKPX Aring ugrave -50\r\nKPX Aring uhungarumlaut -50\r\nKPX Aring umacron -50\r\nKPX Aring uogonek -50\r\nKPX Aring uring -50\r\nKPX Aring v -100\r\nKPX Aring w -90\r\nKPX Aring y -74\r\nKPX Aring yacute -74\r\nKPX Aring ydieresis -74\r\nKPX Atilde C -55\r\nKPX Atilde Cacute -55\r\nKPX Atilde Ccaron -55\r\nKPX Atilde Ccedilla -55\r\nKPX Atilde G -55\r\nKPX Atilde Gbreve -55\r\nKPX Atilde Gcommaaccent -55\r\nKPX Atilde O -45\r\nKPX Atilde Oacute -45\r\nKPX Atilde Ocircumflex -45\r\nKPX Atilde Odieresis -45\r\nKPX Atilde Ograve -45\r\nKPX Atilde Ohungarumlaut -45\r\nKPX Atilde Omacron -45\r\nKPX Atilde Oslash -45\r\nKPX Atilde Otilde -45\r\nKPX Atilde Q -45\r\nKPX Atilde T -95\r\nKPX Atilde Tcaron -95\r\nKPX Atilde Tcommaaccent -95\r\nKPX Atilde U -50\r\nKPX Atilde Uacute -50\r\nKPX Atilde Ucircumflex -50\r\nKPX Atilde Udieresis -50\r\nKPX Atilde Ugrave -50\r\nKPX Atilde Uhungarumlaut -50\r\nKPX Atilde Umacron -50\r\nKPX Atilde Uogonek -50\r\nKPX Atilde Uring -50\r\nKPX Atilde V -145\r\nKPX Atilde W -130\r\nKPX Atilde Y -100\r\nKPX Atilde Yacute -100\r\nKPX Atilde Ydieresis -100\r\nKPX Atilde p -25\r\nKPX Atilde quoteright -74\r\nKPX Atilde u -50\r\nKPX Atilde uacute -50\r\nKPX Atilde ucircumflex -50\r\nKPX Atilde udieresis -50\r\nKPX Atilde ugrave -50\r\nKPX Atilde uhungarumlaut -50\r\nKPX Atilde umacron -50\r\nKPX Atilde uogonek -50\r\nKPX Atilde uring -50\r\nKPX Atilde v -100\r\nKPX Atilde w -90\r\nKPX Atilde y -74\r\nKPX Atilde yacute -74\r\nKPX Atilde ydieresis -74\r\nKPX B A -30\r\nKPX B Aacute -30\r\nKPX B Abreve -30\r\nKPX B Acircumflex -30\r\nKPX B Adieresis -30\r\nKPX B Agrave -30\r\nKPX B Amacron -30\r\nKPX B Aogonek -30\r\nKPX B Aring -30\r\nKPX B Atilde -30\r\nKPX B U -10\r\nKPX B Uacute -10\r\nKPX B Ucircumflex -10\r\nKPX B Udieresis -10\r\nKPX B Ugrave -10\r\nKPX B Uhungarumlaut -10\r\nKPX B Umacron -10\r\nKPX B Uogonek -10\r\nKPX B Uring -10\r\nKPX D A -35\r\nKPX D Aacute -35\r\nKPX D Abreve -35\r\nKPX D Acircumflex -35\r\nKPX D Adieresis -35\r\nKPX D Agrave -35\r\nKPX D Amacron -35\r\nKPX D Aogonek -35\r\nKPX D Aring -35\r\nKPX D Atilde -35\r\nKPX D V -40\r\nKPX D W -40\r\nKPX D Y -40\r\nKPX D Yacute -40\r\nKPX D Ydieresis -40\r\nKPX D period -20\r\nKPX Dcaron A -35\r\nKPX Dcaron Aacute -35\r\nKPX Dcaron Abreve -35\r\nKPX Dcaron Acircumflex -35\r\nKPX Dcaron Adieresis -35\r\nKPX Dcaron Agrave -35\r\nKPX Dcaron Amacron -35\r\nKPX Dcaron Aogonek -35\r\nKPX Dcaron Aring -35\r\nKPX Dcaron Atilde -35\r\nKPX Dcaron V -40\r\nKPX Dcaron W -40\r\nKPX Dcaron Y -40\r\nKPX Dcaron Yacute -40\r\nKPX Dcaron Ydieresis -40\r\nKPX Dcaron period -20\r\nKPX Dcroat A -35\r\nKPX Dcroat Aacute -35\r\nKPX Dcroat Abreve -35\r\nKPX Dcroat Acircumflex -35\r\nKPX Dcroat Adieresis -35\r\nKPX Dcroat Agrave -35\r\nKPX Dcroat Amacron -35\r\nKPX Dcroat Aogonek -35\r\nKPX Dcroat Aring -35\r\nKPX Dcroat Atilde -35\r\nKPX Dcroat V -40\r\nKPX Dcroat W -40\r\nKPX Dcroat Y -40\r\nKPX Dcroat Yacute -40\r\nKPX Dcroat Ydieresis -40\r\nKPX Dcroat period -20\r\nKPX F A -90\r\nKPX F Aacute -90\r\nKPX F Abreve -90\r\nKPX F Acircumflex -90\r\nKPX F Adieresis -90\r\nKPX F Agrave -90\r\nKPX F Amacron -90\r\nKPX F Aogonek -90\r\nKPX F Aring -90\r\nKPX F Atilde -90\r\nKPX F a -25\r\nKPX F aacute -25\r\nKPX F abreve -25\r\nKPX F acircumflex -25\r\nKPX F adieresis -25\r\nKPX F agrave -25\r\nKPX F amacron -25\r\nKPX F aogonek -25\r\nKPX F aring -25\r\nKPX F atilde -25\r\nKPX F comma -92\r\nKPX F e -25\r\nKPX F eacute -25\r\nKPX F ecaron -25\r\nKPX F ecircumflex -25\r\nKPX F edieresis -25\r\nKPX F edotaccent -25\r\nKPX F egrave -25\r\nKPX F emacron -25\r\nKPX F eogonek -25\r\nKPX F o -25\r\nKPX F oacute -25\r\nKPX F ocircumflex -25\r\nKPX F odieresis -25\r\nKPX F ograve -25\r\nKPX F ohungarumlaut -25\r\nKPX F omacron -25\r\nKPX F oslash -25\r\nKPX F otilde -25\r\nKPX F period -110\r\nKPX J A -30\r\nKPX J Aacute -30\r\nKPX J Abreve -30\r\nKPX J Acircumflex -30\r\nKPX J Adieresis -30\r\nKPX J Agrave -30\r\nKPX J Amacron -30\r\nKPX J Aogonek -30\r\nKPX J Aring -30\r\nKPX J Atilde -30\r\nKPX J a -15\r\nKPX J aacute -15\r\nKPX J abreve -15\r\nKPX J acircumflex -15\r\nKPX J adieresis -15\r\nKPX J agrave -15\r\nKPX J amacron -15\r\nKPX J aogonek -15\r\nKPX J aring -15\r\nKPX J atilde -15\r\nKPX J e -15\r\nKPX J eacute -15\r\nKPX J ecaron -15\r\nKPX J ecircumflex -15\r\nKPX J edieresis -15\r\nKPX J edotaccent -15\r\nKPX J egrave -15\r\nKPX J emacron -15\r\nKPX J eogonek -15\r\nKPX J o -15\r\nKPX J oacute -15\r\nKPX J ocircumflex -15\r\nKPX J odieresis -15\r\nKPX J ograve -15\r\nKPX J ohungarumlaut -15\r\nKPX J omacron -15\r\nKPX J oslash -15\r\nKPX J otilde -15\r\nKPX J period -20\r\nKPX J u -15\r\nKPX J uacute -15\r\nKPX J ucircumflex -15\r\nKPX J udieresis -15\r\nKPX J ugrave -15\r\nKPX J uhungarumlaut -15\r\nKPX J umacron -15\r\nKPX J uogonek -15\r\nKPX J uring -15\r\nKPX K O -30\r\nKPX K Oacute -30\r\nKPX K Ocircumflex -30\r\nKPX K Odieresis -30\r\nKPX K Ograve -30\r\nKPX K Ohungarumlaut -30\r\nKPX K Omacron -30\r\nKPX K Oslash -30\r\nKPX K Otilde -30\r\nKPX K e -25\r\nKPX K eacute -25\r\nKPX K ecaron -25\r\nKPX K ecircumflex -25\r\nKPX K edieresis -25\r\nKPX K edotaccent -25\r\nKPX K egrave -25\r\nKPX K emacron -25\r\nKPX K eogonek -25\r\nKPX K o -25\r\nKPX K oacute -25\r\nKPX K ocircumflex -25\r\nKPX K odieresis -25\r\nKPX K ograve -25\r\nKPX K ohungarumlaut -25\r\nKPX K omacron -25\r\nKPX K oslash -25\r\nKPX K otilde -25\r\nKPX K u -15\r\nKPX K uacute -15\r\nKPX K ucircumflex -15\r\nKPX K udieresis -15\r\nKPX K ugrave -15\r\nKPX K uhungarumlaut -15\r\nKPX K umacron -15\r\nKPX K uogonek -15\r\nKPX K uring -15\r\nKPX K y -45\r\nKPX K yacute -45\r\nKPX K ydieresis -45\r\nKPX Kcommaaccent O -30\r\nKPX Kcommaaccent Oacute -30\r\nKPX Kcommaaccent Ocircumflex -30\r\nKPX Kcommaaccent Odieresis -30\r\nKPX Kcommaaccent Ograve -30\r\nKPX Kcommaaccent Ohungarumlaut -30\r\nKPX Kcommaaccent Omacron -30\r\nKPX Kcommaaccent Oslash -30\r\nKPX Kcommaaccent Otilde -30\r\nKPX Kcommaaccent e -25\r\nKPX Kcommaaccent eacute -25\r\nKPX Kcommaaccent ecaron -25\r\nKPX Kcommaaccent ecircumflex -25\r\nKPX Kcommaaccent edieresis -25\r\nKPX Kcommaaccent edotaccent -25\r\nKPX Kcommaaccent egrave -25\r\nKPX Kcommaaccent emacron -25\r\nKPX Kcommaaccent eogonek -25\r\nKPX Kcommaaccent o -25\r\nKPX Kcommaaccent oacute -25\r\nKPX Kcommaaccent ocircumflex -25\r\nKPX Kcommaaccent odieresis -25\r\nKPX Kcommaaccent ograve -25\r\nKPX Kcommaaccent ohungarumlaut -25\r\nKPX Kcommaaccent omacron -25\r\nKPX Kcommaaccent oslash -25\r\nKPX Kcommaaccent otilde -25\r\nKPX Kcommaaccent u -15\r\nKPX Kcommaaccent uacute -15\r\nKPX Kcommaaccent ucircumflex -15\r\nKPX Kcommaaccent udieresis -15\r\nKPX Kcommaaccent ugrave -15\r\nKPX Kcommaaccent uhungarumlaut -15\r\nKPX Kcommaaccent umacron -15\r\nKPX Kcommaaccent uogonek -15\r\nKPX Kcommaaccent uring -15\r\nKPX Kcommaaccent y -45\r\nKPX Kcommaaccent yacute -45\r\nKPX Kcommaaccent ydieresis -45\r\nKPX L T -92\r\nKPX L Tcaron -92\r\nKPX L Tcommaaccent -92\r\nKPX L V -92\r\nKPX L W -92\r\nKPX L Y -92\r\nKPX L Yacute -92\r\nKPX L Ydieresis -92\r\nKPX L quotedblright -20\r\nKPX L quoteright -110\r\nKPX L y -55\r\nKPX L yacute -55\r\nKPX L ydieresis -55\r\nKPX Lacute T -92\r\nKPX Lacute Tcaron -92\r\nKPX Lacute Tcommaaccent -92\r\nKPX Lacute V -92\r\nKPX Lacute W -92\r\nKPX Lacute Y -92\r\nKPX Lacute Yacute -92\r\nKPX Lacute Ydieresis -92\r\nKPX Lacute quotedblright -20\r\nKPX Lacute quoteright -110\r\nKPX Lacute y -55\r\nKPX Lacute yacute -55\r\nKPX Lacute ydieresis -55\r\nKPX Lcommaaccent T -92\r\nKPX Lcommaaccent Tcaron -92\r\nKPX Lcommaaccent Tcommaaccent -92\r\nKPX Lcommaaccent V -92\r\nKPX Lcommaaccent W -92\r\nKPX Lcommaaccent Y -92\r\nKPX Lcommaaccent Yacute -92\r\nKPX Lcommaaccent Ydieresis -92\r\nKPX Lcommaaccent quotedblright -20\r\nKPX Lcommaaccent quoteright -110\r\nKPX Lcommaaccent y -55\r\nKPX Lcommaaccent yacute -55\r\nKPX Lcommaaccent ydieresis -55\r\nKPX Lslash T -92\r\nKPX Lslash Tcaron -92\r\nKPX Lslash Tcommaaccent -92\r\nKPX Lslash V -92\r\nKPX Lslash W -92\r\nKPX Lslash Y -92\r\nKPX Lslash Yacute -92\r\nKPX Lslash Ydieresis -92\r\nKPX Lslash quotedblright -20\r\nKPX Lslash quoteright -110\r\nKPX Lslash y -55\r\nKPX Lslash yacute -55\r\nKPX Lslash ydieresis -55\r\nKPX N A -20\r\nKPX N Aacute -20\r\nKPX N Abreve -20\r\nKPX N Acircumflex -20\r\nKPX N Adieresis -20\r\nKPX N Agrave -20\r\nKPX N Amacron -20\r\nKPX N Aogonek -20\r\nKPX N Aring -20\r\nKPX N Atilde -20\r\nKPX Nacute A -20\r\nKPX Nacute Aacute -20\r\nKPX Nacute Abreve -20\r\nKPX Nacute Acircumflex -20\r\nKPX Nacute Adieresis -20\r\nKPX Nacute Agrave -20\r\nKPX Nacute Amacron -20\r\nKPX Nacute Aogonek -20\r\nKPX Nacute Aring -20\r\nKPX Nacute Atilde -20\r\nKPX Ncaron A -20\r\nKPX Ncaron Aacute -20\r\nKPX Ncaron Abreve -20\r\nKPX Ncaron Acircumflex -20\r\nKPX Ncaron Adieresis -20\r\nKPX Ncaron Agrave -20\r\nKPX Ncaron Amacron -20\r\nKPX Ncaron Aogonek -20\r\nKPX Ncaron Aring -20\r\nKPX Ncaron Atilde -20\r\nKPX Ncommaaccent A -20\r\nKPX Ncommaaccent Aacute -20\r\nKPX Ncommaaccent Abreve -20\r\nKPX Ncommaaccent Acircumflex -20\r\nKPX Ncommaaccent Adieresis -20\r\nKPX Ncommaaccent Agrave -20\r\nKPX Ncommaaccent Amacron -20\r\nKPX Ncommaaccent Aogonek -20\r\nKPX Ncommaaccent Aring -20\r\nKPX Ncommaaccent Atilde -20\r\nKPX Ntilde A -20\r\nKPX Ntilde Aacute -20\r\nKPX Ntilde Abreve -20\r\nKPX Ntilde Acircumflex -20\r\nKPX Ntilde Adieresis -20\r\nKPX Ntilde Agrave -20\r\nKPX Ntilde Amacron -20\r\nKPX Ntilde Aogonek -20\r\nKPX Ntilde Aring -20\r\nKPX Ntilde Atilde -20\r\nKPX O A -40\r\nKPX O Aacute -40\r\nKPX O Abreve -40\r\nKPX O Acircumflex -40\r\nKPX O Adieresis -40\r\nKPX O Agrave -40\r\nKPX O Amacron -40\r\nKPX O Aogonek -40\r\nKPX O Aring -40\r\nKPX O Atilde -40\r\nKPX O T -40\r\nKPX O Tcaron -40\r\nKPX O Tcommaaccent -40\r\nKPX O V -50\r\nKPX O W -50\r\nKPX O X -40\r\nKPX O Y -50\r\nKPX O Yacute -50\r\nKPX O Ydieresis -50\r\nKPX Oacute A -40\r\nKPX Oacute Aacute -40\r\nKPX Oacute Abreve -40\r\nKPX Oacute Acircumflex -40\r\nKPX Oacute Adieresis -40\r\nKPX Oacute Agrave -40\r\nKPX Oacute Amacron -40\r\nKPX Oacute Aogonek -40\r\nKPX Oacute Aring -40\r\nKPX Oacute Atilde -40\r\nKPX Oacute T -40\r\nKPX Oacute Tcaron -40\r\nKPX Oacute Tcommaaccent -40\r\nKPX Oacute V -50\r\nKPX Oacute W -50\r\nKPX Oacute X -40\r\nKPX Oacute Y -50\r\nKPX Oacute Yacute -50\r\nKPX Oacute Ydieresis -50\r\nKPX Ocircumflex A -40\r\nKPX Ocircumflex Aacute -40\r\nKPX Ocircumflex Abreve -40\r\nKPX Ocircumflex Acircumflex -40\r\nKPX Ocircumflex Adieresis -40\r\nKPX Ocircumflex Agrave -40\r\nKPX Ocircumflex Amacron -40\r\nKPX Ocircumflex Aogonek -40\r\nKPX Ocircumflex Aring -40\r\nKPX Ocircumflex Atilde -40\r\nKPX Ocircumflex T -40\r\nKPX Ocircumflex Tcaron -40\r\nKPX Ocircumflex Tcommaaccent -40\r\nKPX Ocircumflex V -50\r\nKPX Ocircumflex W -50\r\nKPX Ocircumflex X -40\r\nKPX Ocircumflex Y -50\r\nKPX Ocircumflex Yacute -50\r\nKPX Ocircumflex Ydieresis -50\r\nKPX Odieresis A -40\r\nKPX Odieresis Aacute -40\r\nKPX Odieresis Abreve -40\r\nKPX Odieresis Acircumflex -40\r\nKPX Odieresis Adieresis -40\r\nKPX Odieresis Agrave -40\r\nKPX Odieresis Amacron -40\r\nKPX Odieresis Aogonek -40\r\nKPX Odieresis Aring -40\r\nKPX Odieresis Atilde -40\r\nKPX Odieresis T -40\r\nKPX Odieresis Tcaron -40\r\nKPX Odieresis Tcommaaccent -40\r\nKPX Odieresis V -50\r\nKPX Odieresis W -50\r\nKPX Odieresis X -40\r\nKPX Odieresis Y -50\r\nKPX Odieresis Yacute -50\r\nKPX Odieresis Ydieresis -50\r\nKPX Ograve A -40\r\nKPX Ograve Aacute -40\r\nKPX Ograve Abreve -40\r\nKPX Ograve Acircumflex -40\r\nKPX Ograve Adieresis -40\r\nKPX Ograve Agrave -40\r\nKPX Ograve Amacron -40\r\nKPX Ograve Aogonek -40\r\nKPX Ograve Aring -40\r\nKPX Ograve Atilde -40\r\nKPX Ograve T -40\r\nKPX Ograve Tcaron -40\r\nKPX Ograve Tcommaaccent -40\r\nKPX Ograve V -50\r\nKPX Ograve W -50\r\nKPX Ograve X -40\r\nKPX Ograve Y -50\r\nKPX Ograve Yacute -50\r\nKPX Ograve Ydieresis -50\r\nKPX Ohungarumlaut A -40\r\nKPX Ohungarumlaut Aacute -40\r\nKPX Ohungarumlaut Abreve -40\r\nKPX Ohungarumlaut Acircumflex -40\r\nKPX Ohungarumlaut Adieresis -40\r\nKPX Ohungarumlaut Agrave -40\r\nKPX Ohungarumlaut Amacron -40\r\nKPX Ohungarumlaut Aogonek -40\r\nKPX Ohungarumlaut Aring -40\r\nKPX Ohungarumlaut Atilde -40\r\nKPX Ohungarumlaut T -40\r\nKPX Ohungarumlaut Tcaron -40\r\nKPX Ohungarumlaut Tcommaaccent -40\r\nKPX Ohungarumlaut V -50\r\nKPX Ohungarumlaut W -50\r\nKPX Ohungarumlaut X -40\r\nKPX Ohungarumlaut Y -50\r\nKPX Ohungarumlaut Yacute -50\r\nKPX Ohungarumlaut Ydieresis -50\r\nKPX Omacron A -40\r\nKPX Omacron Aacute -40\r\nKPX Omacron Abreve -40\r\nKPX Omacron Acircumflex -40\r\nKPX Omacron Adieresis -40\r\nKPX Omacron Agrave -40\r\nKPX Omacron Amacron -40\r\nKPX Omacron Aogonek -40\r\nKPX Omacron Aring -40\r\nKPX Omacron Atilde -40\r\nKPX Omacron T -40\r\nKPX Omacron Tcaron -40\r\nKPX Omacron Tcommaaccent -40\r\nKPX Omacron V -50\r\nKPX Omacron W -50\r\nKPX Omacron X -40\r\nKPX Omacron Y -50\r\nKPX Omacron Yacute -50\r\nKPX Omacron Ydieresis -50\r\nKPX Oslash A -40\r\nKPX Oslash Aacute -40\r\nKPX Oslash Abreve -40\r\nKPX Oslash Acircumflex -40\r\nKPX Oslash Adieresis -40\r\nKPX Oslash Agrave -40\r\nKPX Oslash Amacron -40\r\nKPX Oslash Aogonek -40\r\nKPX Oslash Aring -40\r\nKPX Oslash Atilde -40\r\nKPX Oslash T -40\r\nKPX Oslash Tcaron -40\r\nKPX Oslash Tcommaaccent -40\r\nKPX Oslash V -50\r\nKPX Oslash W -50\r\nKPX Oslash X -40\r\nKPX Oslash Y -50\r\nKPX Oslash Yacute -50\r\nKPX Oslash Ydieresis -50\r\nKPX Otilde A -40\r\nKPX Otilde Aacute -40\r\nKPX Otilde Abreve -40\r\nKPX Otilde Acircumflex -40\r\nKPX Otilde Adieresis -40\r\nKPX Otilde Agrave -40\r\nKPX Otilde Amacron -40\r\nKPX Otilde Aogonek -40\r\nKPX Otilde Aring -40\r\nKPX Otilde Atilde -40\r\nKPX Otilde T -40\r\nKPX Otilde Tcaron -40\r\nKPX Otilde Tcommaaccent -40\r\nKPX Otilde V -50\r\nKPX Otilde W -50\r\nKPX Otilde X -40\r\nKPX Otilde Y -50\r\nKPX Otilde Yacute -50\r\nKPX Otilde Ydieresis -50\r\nKPX P A -74\r\nKPX P Aacute -74\r\nKPX P Abreve -74\r\nKPX P Acircumflex -74\r\nKPX P Adieresis -74\r\nKPX P Agrave -74\r\nKPX P Amacron -74\r\nKPX P Aogonek -74\r\nKPX P Aring -74\r\nKPX P Atilde -74\r\nKPX P a -10\r\nKPX P aacute -10\r\nKPX P abreve -10\r\nKPX P acircumflex -10\r\nKPX P adieresis -10\r\nKPX P agrave -10\r\nKPX P amacron -10\r\nKPX P aogonek -10\r\nKPX P aring -10\r\nKPX P atilde -10\r\nKPX P comma -92\r\nKPX P e -20\r\nKPX P eacute -20\r\nKPX P ecaron -20\r\nKPX P ecircumflex -20\r\nKPX P edieresis -20\r\nKPX P edotaccent -20\r\nKPX P egrave -20\r\nKPX P emacron -20\r\nKPX P eogonek -20\r\nKPX P o -20\r\nKPX P oacute -20\r\nKPX P ocircumflex -20\r\nKPX P odieresis -20\r\nKPX P ograve -20\r\nKPX P ohungarumlaut -20\r\nKPX P omacron -20\r\nKPX P oslash -20\r\nKPX P otilde -20\r\nKPX P period -110\r\nKPX Q U -10\r\nKPX Q Uacute -10\r\nKPX Q Ucircumflex -10\r\nKPX Q Udieresis -10\r\nKPX Q Ugrave -10\r\nKPX Q Uhungarumlaut -10\r\nKPX Q Umacron -10\r\nKPX Q Uogonek -10\r\nKPX Q Uring -10\r\nKPX Q period -20\r\nKPX R O -30\r\nKPX R Oacute -30\r\nKPX R Ocircumflex -30\r\nKPX R Odieresis -30\r\nKPX R Ograve -30\r\nKPX R Ohungarumlaut -30\r\nKPX R Omacron -30\r\nKPX R Oslash -30\r\nKPX R Otilde -30\r\nKPX R T -40\r\nKPX R Tcaron -40\r\nKPX R Tcommaaccent -40\r\nKPX R U -30\r\nKPX R Uacute -30\r\nKPX R Ucircumflex -30\r\nKPX R Udieresis -30\r\nKPX R Ugrave -30\r\nKPX R Uhungarumlaut -30\r\nKPX R Umacron -30\r\nKPX R Uogonek -30\r\nKPX R Uring -30\r\nKPX R V -55\r\nKPX R W -35\r\nKPX R Y -35\r\nKPX R Yacute -35\r\nKPX R Ydieresis -35\r\nKPX Racute O -30\r\nKPX Racute Oacute -30\r\nKPX Racute Ocircumflex -30\r\nKPX Racute Odieresis -30\r\nKPX Racute Ograve -30\r\nKPX Racute Ohungarumlaut -30\r\nKPX Racute Omacron -30\r\nKPX Racute Oslash -30\r\nKPX Racute Otilde -30\r\nKPX Racute T -40\r\nKPX Racute Tcaron -40\r\nKPX Racute Tcommaaccent -40\r\nKPX Racute U -30\r\nKPX Racute Uacute -30\r\nKPX Racute Ucircumflex -30\r\nKPX Racute Udieresis -30\r\nKPX Racute Ugrave -30\r\nKPX Racute Uhungarumlaut -30\r\nKPX Racute Umacron -30\r\nKPX Racute Uogonek -30\r\nKPX Racute Uring -30\r\nKPX Racute V -55\r\nKPX Racute W -35\r\nKPX Racute Y -35\r\nKPX Racute Yacute -35\r\nKPX Racute Ydieresis -35\r\nKPX Rcaron O -30\r\nKPX Rcaron Oacute -30\r\nKPX Rcaron Ocircumflex -30\r\nKPX Rcaron Odieresis -30\r\nKPX Rcaron Ograve -30\r\nKPX Rcaron Ohungarumlaut -30\r\nKPX Rcaron Omacron -30\r\nKPX Rcaron Oslash -30\r\nKPX Rcaron Otilde -30\r\nKPX Rcaron T -40\r\nKPX Rcaron Tcaron -40\r\nKPX Rcaron Tcommaaccent -40\r\nKPX Rcaron U -30\r\nKPX Rcaron Uacute -30\r\nKPX Rcaron Ucircumflex -30\r\nKPX Rcaron Udieresis -30\r\nKPX Rcaron Ugrave -30\r\nKPX Rcaron Uhungarumlaut -30\r\nKPX Rcaron Umacron -30\r\nKPX Rcaron Uogonek -30\r\nKPX Rcaron Uring -30\r\nKPX Rcaron V -55\r\nKPX Rcaron W -35\r\nKPX Rcaron Y -35\r\nKPX Rcaron Yacute -35\r\nKPX Rcaron Ydieresis -35\r\nKPX Rcommaaccent O -30\r\nKPX Rcommaaccent Oacute -30\r\nKPX Rcommaaccent Ocircumflex -30\r\nKPX Rcommaaccent Odieresis -30\r\nKPX Rcommaaccent Ograve -30\r\nKPX Rcommaaccent Ohungarumlaut -30\r\nKPX Rcommaaccent Omacron -30\r\nKPX Rcommaaccent Oslash -30\r\nKPX Rcommaaccent Otilde -30\r\nKPX Rcommaaccent T -40\r\nKPX Rcommaaccent Tcaron -40\r\nKPX Rcommaaccent Tcommaaccent -40\r\nKPX Rcommaaccent U -30\r\nKPX Rcommaaccent Uacute -30\r\nKPX Rcommaaccent Ucircumflex -30\r\nKPX Rcommaaccent Udieresis -30\r\nKPX Rcommaaccent Ugrave -30\r\nKPX Rcommaaccent Uhungarumlaut -30\r\nKPX Rcommaaccent Umacron -30\r\nKPX Rcommaaccent Uogonek -30\r\nKPX Rcommaaccent Uring -30\r\nKPX Rcommaaccent V -55\r\nKPX Rcommaaccent W -35\r\nKPX Rcommaaccent Y -35\r\nKPX Rcommaaccent Yacute -35\r\nKPX Rcommaaccent Ydieresis -35\r\nKPX T A -90\r\nKPX T Aacute -90\r\nKPX T Abreve -90\r\nKPX T Acircumflex -90\r\nKPX T Adieresis -90\r\nKPX T Agrave -90\r\nKPX T Amacron -90\r\nKPX T Aogonek -90\r\nKPX T Aring -90\r\nKPX T Atilde -90\r\nKPX T O -18\r\nKPX T Oacute -18\r\nKPX T Ocircumflex -18\r\nKPX T Odieresis -18\r\nKPX T Ograve -18\r\nKPX T Ohungarumlaut -18\r\nKPX T Omacron -18\r\nKPX T Oslash -18\r\nKPX T Otilde -18\r\nKPX T a -92\r\nKPX T aacute -92\r\nKPX T abreve -52\r\nKPX T acircumflex -52\r\nKPX T adieresis -52\r\nKPX T agrave -52\r\nKPX T amacron -52\r\nKPX T aogonek -92\r\nKPX T aring -92\r\nKPX T atilde -52\r\nKPX T colon -74\r\nKPX T comma -74\r\nKPX T e -92\r\nKPX T eacute -92\r\nKPX T ecaron -92\r\nKPX T ecircumflex -92\r\nKPX T edieresis -52\r\nKPX T edotaccent -92\r\nKPX T egrave -52\r\nKPX T emacron -52\r\nKPX T eogonek -92\r\nKPX T hyphen -92\r\nKPX T i -18\r\nKPX T iacute -18\r\nKPX T iogonek -18\r\nKPX T o -92\r\nKPX T oacute -92\r\nKPX T ocircumflex -92\r\nKPX T odieresis -92\r\nKPX T ograve -92\r\nKPX T ohungarumlaut -92\r\nKPX T omacron -92\r\nKPX T oslash -92\r\nKPX T otilde -92\r\nKPX T period -90\r\nKPX T r -74\r\nKPX T racute -74\r\nKPX T rcaron -74\r\nKPX T rcommaaccent -74\r\nKPX T semicolon -74\r\nKPX T u -92\r\nKPX T uacute -92\r\nKPX T ucircumflex -92\r\nKPX T udieresis -92\r\nKPX T ugrave -92\r\nKPX T uhungarumlaut -92\r\nKPX T umacron -92\r\nKPX T uogonek -92\r\nKPX T uring -92\r\nKPX T w -74\r\nKPX T y -34\r\nKPX T yacute -34\r\nKPX T ydieresis -34\r\nKPX Tcaron A -90\r\nKPX Tcaron Aacute -90\r\nKPX Tcaron Abreve -90\r\nKPX Tcaron Acircumflex -90\r\nKPX Tcaron Adieresis -90\r\nKPX Tcaron Agrave -90\r\nKPX Tcaron Amacron -90\r\nKPX Tcaron Aogonek -90\r\nKPX Tcaron Aring -90\r\nKPX Tcaron Atilde -90\r\nKPX Tcaron O -18\r\nKPX Tcaron Oacute -18\r\nKPX Tcaron Ocircumflex -18\r\nKPX Tcaron Odieresis -18\r\nKPX Tcaron Ograve -18\r\nKPX Tcaron Ohungarumlaut -18\r\nKPX Tcaron Omacron -18\r\nKPX Tcaron Oslash -18\r\nKPX Tcaron Otilde -18\r\nKPX Tcaron a -92\r\nKPX Tcaron aacute -92\r\nKPX Tcaron abreve -52\r\nKPX Tcaron acircumflex -52\r\nKPX Tcaron adieresis -52\r\nKPX Tcaron agrave -52\r\nKPX Tcaron amacron -52\r\nKPX Tcaron aogonek -92\r\nKPX Tcaron aring -92\r\nKPX Tcaron atilde -52\r\nKPX Tcaron colon -74\r\nKPX Tcaron comma -74\r\nKPX Tcaron e -92\r\nKPX Tcaron eacute -92\r\nKPX Tcaron ecaron -92\r\nKPX Tcaron ecircumflex -92\r\nKPX Tcaron edieresis -52\r\nKPX Tcaron edotaccent -92\r\nKPX Tcaron egrave -52\r\nKPX Tcaron emacron -52\r\nKPX Tcaron eogonek -92\r\nKPX Tcaron hyphen -92\r\nKPX Tcaron i -18\r\nKPX Tcaron iacute -18\r\nKPX Tcaron iogonek -18\r\nKPX Tcaron o -92\r\nKPX Tcaron oacute -92\r\nKPX Tcaron ocircumflex -92\r\nKPX Tcaron odieresis -92\r\nKPX Tcaron ograve -92\r\nKPX Tcaron ohungarumlaut -92\r\nKPX Tcaron omacron -92\r\nKPX Tcaron oslash -92\r\nKPX Tcaron otilde -92\r\nKPX Tcaron period -90\r\nKPX Tcaron r -74\r\nKPX Tcaron racute -74\r\nKPX Tcaron rcaron -74\r\nKPX Tcaron rcommaaccent -74\r\nKPX Tcaron semicolon -74\r\nKPX Tcaron u -92\r\nKPX Tcaron uacute -92\r\nKPX Tcaron ucircumflex -92\r\nKPX Tcaron udieresis -92\r\nKPX Tcaron ugrave -92\r\nKPX Tcaron uhungarumlaut -92\r\nKPX Tcaron umacron -92\r\nKPX Tcaron uogonek -92\r\nKPX Tcaron uring -92\r\nKPX Tcaron w -74\r\nKPX Tcaron y -34\r\nKPX Tcaron yacute -34\r\nKPX Tcaron ydieresis -34\r\nKPX Tcommaaccent A -90\r\nKPX Tcommaaccent Aacute -90\r\nKPX Tcommaaccent Abreve -90\r\nKPX Tcommaaccent Acircumflex -90\r\nKPX Tcommaaccent Adieresis -90\r\nKPX Tcommaaccent Agrave -90\r\nKPX Tcommaaccent Amacron -90\r\nKPX Tcommaaccent Aogonek -90\r\nKPX Tcommaaccent Aring -90\r\nKPX Tcommaaccent Atilde -90\r\nKPX Tcommaaccent O -18\r\nKPX Tcommaaccent Oacute -18\r\nKPX Tcommaaccent Ocircumflex -18\r\nKPX Tcommaaccent Odieresis -18\r\nKPX Tcommaaccent Ograve -18\r\nKPX Tcommaaccent Ohungarumlaut -18\r\nKPX Tcommaaccent Omacron -18\r\nKPX Tcommaaccent Oslash -18\r\nKPX Tcommaaccent Otilde -18\r\nKPX Tcommaaccent a -92\r\nKPX Tcommaaccent aacute -92\r\nKPX Tcommaaccent abreve -52\r\nKPX Tcommaaccent acircumflex -52\r\nKPX Tcommaaccent adieresis -52\r\nKPX Tcommaaccent agrave -52\r\nKPX Tcommaaccent amacron -52\r\nKPX Tcommaaccent aogonek -92\r\nKPX Tcommaaccent aring -92\r\nKPX Tcommaaccent atilde -52\r\nKPX Tcommaaccent colon -74\r\nKPX Tcommaaccent comma -74\r\nKPX Tcommaaccent e -92\r\nKPX Tcommaaccent eacute -92\r\nKPX Tcommaaccent ecaron -92\r\nKPX Tcommaaccent ecircumflex -92\r\nKPX Tcommaaccent edieresis -52\r\nKPX Tcommaaccent edotaccent -92\r\nKPX Tcommaaccent egrave -52\r\nKPX Tcommaaccent emacron -52\r\nKPX Tcommaaccent eogonek -92\r\nKPX Tcommaaccent hyphen -92\r\nKPX Tcommaaccent i -18\r\nKPX Tcommaaccent iacute -18\r\nKPX Tcommaaccent iogonek -18\r\nKPX Tcommaaccent o -92\r\nKPX Tcommaaccent oacute -92\r\nKPX Tcommaaccent ocircumflex -92\r\nKPX Tcommaaccent odieresis -92\r\nKPX Tcommaaccent ograve -92\r\nKPX Tcommaaccent ohungarumlaut -92\r\nKPX Tcommaaccent omacron -92\r\nKPX Tcommaaccent oslash -92\r\nKPX Tcommaaccent otilde -92\r\nKPX Tcommaaccent period -90\r\nKPX Tcommaaccent r -74\r\nKPX Tcommaaccent racute -74\r\nKPX Tcommaaccent rcaron -74\r\nKPX Tcommaaccent rcommaaccent -74\r\nKPX Tcommaaccent semicolon -74\r\nKPX Tcommaaccent u -92\r\nKPX Tcommaaccent uacute -92\r\nKPX Tcommaaccent ucircumflex -92\r\nKPX Tcommaaccent udieresis -92\r\nKPX Tcommaaccent ugrave -92\r\nKPX Tcommaaccent uhungarumlaut -92\r\nKPX Tcommaaccent umacron -92\r\nKPX Tcommaaccent uogonek -92\r\nKPX Tcommaaccent uring -92\r\nKPX Tcommaaccent w -74\r\nKPX Tcommaaccent y -34\r\nKPX Tcommaaccent yacute -34\r\nKPX Tcommaaccent ydieresis -34\r\nKPX U A -60\r\nKPX U Aacute -60\r\nKPX U Abreve -60\r\nKPX U Acircumflex -60\r\nKPX U Adieresis -60\r\nKPX U Agrave -60\r\nKPX U Amacron -60\r\nKPX U Aogonek -60\r\nKPX U Aring -60\r\nKPX U Atilde -60\r\nKPX U comma -50\r\nKPX U period -50\r\nKPX Uacute A -60\r\nKPX Uacute Aacute -60\r\nKPX Uacute Abreve -60\r\nKPX Uacute Acircumflex -60\r\nKPX Uacute Adieresis -60\r\nKPX Uacute Agrave -60\r\nKPX Uacute Amacron -60\r\nKPX Uacute Aogonek -60\r\nKPX Uacute Aring -60\r\nKPX Uacute Atilde -60\r\nKPX Uacute comma -50\r\nKPX Uacute period -50\r\nKPX Ucircumflex A -60\r\nKPX Ucircumflex Aacute -60\r\nKPX Ucircumflex Abreve -60\r\nKPX Ucircumflex Acircumflex -60\r\nKPX Ucircumflex Adieresis -60\r\nKPX Ucircumflex Agrave -60\r\nKPX Ucircumflex Amacron -60\r\nKPX Ucircumflex Aogonek -60\r\nKPX Ucircumflex Aring -60\r\nKPX Ucircumflex Atilde -60\r\nKPX Ucircumflex comma -50\r\nKPX Ucircumflex period -50\r\nKPX Udieresis A -60\r\nKPX Udieresis Aacute -60\r\nKPX Udieresis Abreve -60\r\nKPX Udieresis Acircumflex -60\r\nKPX Udieresis Adieresis -60\r\nKPX Udieresis Agrave -60\r\nKPX Udieresis Amacron -60\r\nKPX Udieresis Aogonek -60\r\nKPX Udieresis Aring -60\r\nKPX Udieresis Atilde -60\r\nKPX Udieresis comma -50\r\nKPX Udieresis period -50\r\nKPX Ugrave A -60\r\nKPX Ugrave Aacute -60\r\nKPX Ugrave Abreve -60\r\nKPX Ugrave Acircumflex -60\r\nKPX Ugrave Adieresis -60\r\nKPX Ugrave Agrave -60\r\nKPX Ugrave Amacron -60\r\nKPX Ugrave Aogonek -60\r\nKPX Ugrave Aring -60\r\nKPX Ugrave Atilde -60\r\nKPX Ugrave comma -50\r\nKPX Ugrave period -50\r\nKPX Uhungarumlaut A -60\r\nKPX Uhungarumlaut Aacute -60\r\nKPX Uhungarumlaut Abreve -60\r\nKPX Uhungarumlaut Acircumflex -60\r\nKPX Uhungarumlaut Adieresis -60\r\nKPX Uhungarumlaut Agrave -60\r\nKPX Uhungarumlaut Amacron -60\r\nKPX Uhungarumlaut Aogonek -60\r\nKPX Uhungarumlaut Aring -60\r\nKPX Uhungarumlaut Atilde -60\r\nKPX Uhungarumlaut comma -50\r\nKPX Uhungarumlaut period -50\r\nKPX Umacron A -60\r\nKPX Umacron Aacute -60\r\nKPX Umacron Abreve -60\r\nKPX Umacron Acircumflex -60\r\nKPX Umacron Adieresis -60\r\nKPX Umacron Agrave -60\r\nKPX Umacron Amacron -60\r\nKPX Umacron Aogonek -60\r\nKPX Umacron Aring -60\r\nKPX Umacron Atilde -60\r\nKPX Umacron comma -50\r\nKPX Umacron period -50\r\nKPX Uogonek A -60\r\nKPX Uogonek Aacute -60\r\nKPX Uogonek Abreve -60\r\nKPX Uogonek Acircumflex -60\r\nKPX Uogonek Adieresis -60\r\nKPX Uogonek Agrave -60\r\nKPX Uogonek Amacron -60\r\nKPX Uogonek Aogonek -60\r\nKPX Uogonek Aring -60\r\nKPX Uogonek Atilde -60\r\nKPX Uogonek comma -50\r\nKPX Uogonek period -50\r\nKPX Uring A -60\r\nKPX Uring Aacute -60\r\nKPX Uring Abreve -60\r\nKPX Uring Acircumflex -60\r\nKPX Uring Adieresis -60\r\nKPX Uring Agrave -60\r\nKPX Uring Amacron -60\r\nKPX Uring Aogonek -60\r\nKPX Uring Aring -60\r\nKPX Uring Atilde -60\r\nKPX Uring comma -50\r\nKPX Uring period -50\r\nKPX V A -135\r\nKPX V Aacute -135\r\nKPX V Abreve -135\r\nKPX V Acircumflex -135\r\nKPX V Adieresis -135\r\nKPX V Agrave -135\r\nKPX V Amacron -135\r\nKPX V Aogonek -135\r\nKPX V Aring -135\r\nKPX V Atilde -135\r\nKPX V G -30\r\nKPX V Gbreve -30\r\nKPX V Gcommaaccent -30\r\nKPX V O -45\r\nKPX V Oacute -45\r\nKPX V Ocircumflex -45\r\nKPX V Odieresis -45\r\nKPX V Ograve -45\r\nKPX V Ohungarumlaut -45\r\nKPX V Omacron -45\r\nKPX V Oslash -45\r\nKPX V Otilde -45\r\nKPX V a -92\r\nKPX V aacute -92\r\nKPX V abreve -92\r\nKPX V acircumflex -92\r\nKPX V adieresis -92\r\nKPX V agrave -92\r\nKPX V amacron -92\r\nKPX V aogonek -92\r\nKPX V aring -92\r\nKPX V atilde -92\r\nKPX V colon -92\r\nKPX V comma -129\r\nKPX V e -100\r\nKPX V eacute -100\r\nKPX V ecaron -100\r\nKPX V ecircumflex -100\r\nKPX V edieresis -100\r\nKPX V edotaccent -100\r\nKPX V egrave -100\r\nKPX V emacron -100\r\nKPX V eogonek -100\r\nKPX V hyphen -74\r\nKPX V i -37\r\nKPX V iacute -37\r\nKPX V icircumflex -37\r\nKPX V idieresis -37\r\nKPX V igrave -37\r\nKPX V imacron -37\r\nKPX V iogonek -37\r\nKPX V o -100\r\nKPX V oacute -100\r\nKPX V ocircumflex -100\r\nKPX V odieresis -100\r\nKPX V ograve -100\r\nKPX V ohungarumlaut -100\r\nKPX V omacron -100\r\nKPX V oslash -100\r\nKPX V otilde -100\r\nKPX V period -145\r\nKPX V semicolon -92\r\nKPX V u -92\r\nKPX V uacute -92\r\nKPX V ucircumflex -92\r\nKPX V udieresis -92\r\nKPX V ugrave -92\r\nKPX V uhungarumlaut -92\r\nKPX V umacron -92\r\nKPX V uogonek -92\r\nKPX V uring -92\r\nKPX W A -120\r\nKPX W Aacute -120\r\nKPX W Abreve -120\r\nKPX W Acircumflex -120\r\nKPX W Adieresis -120\r\nKPX W Agrave -120\r\nKPX W Amacron -120\r\nKPX W Aogonek -120\r\nKPX W Aring -120\r\nKPX W Atilde -120\r\nKPX W O -10\r\nKPX W Oacute -10\r\nKPX W Ocircumflex -10\r\nKPX W Odieresis -10\r\nKPX W Ograve -10\r\nKPX W Ohungarumlaut -10\r\nKPX W Omacron -10\r\nKPX W Oslash -10\r\nKPX W Otilde -10\r\nKPX W a -65\r\nKPX W aacute -65\r\nKPX W abreve -65\r\nKPX W acircumflex -65\r\nKPX W adieresis -65\r\nKPX W agrave -65\r\nKPX W amacron -65\r\nKPX W aogonek -65\r\nKPX W aring -65\r\nKPX W atilde -65\r\nKPX W colon -55\r\nKPX W comma -92\r\nKPX W e -65\r\nKPX W eacute -65\r\nKPX W ecaron -65\r\nKPX W ecircumflex -65\r\nKPX W edieresis -65\r\nKPX W edotaccent -65\r\nKPX W egrave -65\r\nKPX W emacron -65\r\nKPX W eogonek -65\r\nKPX W hyphen -37\r\nKPX W i -18\r\nKPX W iacute -18\r\nKPX W iogonek -18\r\nKPX W o -75\r\nKPX W oacute -75\r\nKPX W ocircumflex -75\r\nKPX W odieresis -75\r\nKPX W ograve -75\r\nKPX W ohungarumlaut -75\r\nKPX W omacron -75\r\nKPX W oslash -75\r\nKPX W otilde -75\r\nKPX W period -92\r\nKPX W semicolon -55\r\nKPX W u -50\r\nKPX W uacute -50\r\nKPX W ucircumflex -50\r\nKPX W udieresis -50\r\nKPX W ugrave -50\r\nKPX W uhungarumlaut -50\r\nKPX W umacron -50\r\nKPX W uogonek -50\r\nKPX W uring -50\r\nKPX W y -60\r\nKPX W yacute -60\r\nKPX W ydieresis -60\r\nKPX Y A -110\r\nKPX Y Aacute -110\r\nKPX Y Abreve -110\r\nKPX Y Acircumflex -110\r\nKPX Y Adieresis -110\r\nKPX Y Agrave -110\r\nKPX Y Amacron -110\r\nKPX Y Aogonek -110\r\nKPX Y Aring -110\r\nKPX Y Atilde -110\r\nKPX Y O -35\r\nKPX Y Oacute -35\r\nKPX Y Ocircumflex -35\r\nKPX Y Odieresis -35\r\nKPX Y Ograve -35\r\nKPX Y Ohungarumlaut -35\r\nKPX Y Omacron -35\r\nKPX Y Oslash -35\r\nKPX Y Otilde -35\r\nKPX Y a -85\r\nKPX Y aacute -85\r\nKPX Y abreve -85\r\nKPX Y acircumflex -85\r\nKPX Y adieresis -85\r\nKPX Y agrave -85\r\nKPX Y amacron -85\r\nKPX Y aogonek -85\r\nKPX Y aring -85\r\nKPX Y atilde -85\r\nKPX Y colon -92\r\nKPX Y comma -92\r\nKPX Y e -111\r\nKPX Y eacute -111\r\nKPX Y ecaron -111\r\nKPX Y ecircumflex -111\r\nKPX Y edieresis -71\r\nKPX Y edotaccent -111\r\nKPX Y egrave -71\r\nKPX Y emacron -71\r\nKPX Y eogonek -111\r\nKPX Y hyphen -92\r\nKPX Y i -37\r\nKPX Y iacute -37\r\nKPX Y iogonek -37\r\nKPX Y o -111\r\nKPX Y oacute -111\r\nKPX Y ocircumflex -111\r\nKPX Y odieresis -111\r\nKPX Y ograve -111\r\nKPX Y ohungarumlaut -111\r\nKPX Y omacron -111\r\nKPX Y oslash -111\r\nKPX Y otilde -111\r\nKPX Y period -92\r\nKPX Y semicolon -92\r\nKPX Y u -92\r\nKPX Y uacute -92\r\nKPX Y ucircumflex -92\r\nKPX Y udieresis -92\r\nKPX Y ugrave -92\r\nKPX Y uhungarumlaut -92\r\nKPX Y umacron -92\r\nKPX Y uogonek -92\r\nKPX Y uring -92\r\nKPX Yacute A -110\r\nKPX Yacute Aacute -110\r\nKPX Yacute Abreve -110\r\nKPX Yacute Acircumflex -110\r\nKPX Yacute Adieresis -110\r\nKPX Yacute Agrave -110\r\nKPX Yacute Amacron -110\r\nKPX Yacute Aogonek -110\r\nKPX Yacute Aring -110\r\nKPX Yacute Atilde -110\r\nKPX Yacute O -35\r\nKPX Yacute Oacute -35\r\nKPX Yacute Ocircumflex -35\r\nKPX Yacute Odieresis -35\r\nKPX Yacute Ograve -35\r\nKPX Yacute Ohungarumlaut -35\r\nKPX Yacute Omacron -35\r\nKPX Yacute Oslash -35\r\nKPX Yacute Otilde -35\r\nKPX Yacute a -85\r\nKPX Yacute aacute -85\r\nKPX Yacute abreve -85\r\nKPX Yacute acircumflex -85\r\nKPX Yacute adieresis -85\r\nKPX Yacute agrave -85\r\nKPX Yacute amacron -85\r\nKPX Yacute aogonek -85\r\nKPX Yacute aring -85\r\nKPX Yacute atilde -85\r\nKPX Yacute colon -92\r\nKPX Yacute comma -92\r\nKPX Yacute e -111\r\nKPX Yacute eacute -111\r\nKPX Yacute ecaron -111\r\nKPX Yacute ecircumflex -111\r\nKPX Yacute edieresis -71\r\nKPX Yacute edotaccent -111\r\nKPX Yacute egrave -71\r\nKPX Yacute emacron -71\r\nKPX Yacute eogonek -111\r\nKPX Yacute hyphen -92\r\nKPX Yacute i -37\r\nKPX Yacute iacute -37\r\nKPX Yacute iogonek -37\r\nKPX Yacute o -111\r\nKPX Yacute oacute -111\r\nKPX Yacute ocircumflex -111\r\nKPX Yacute odieresis -111\r\nKPX Yacute ograve -111\r\nKPX Yacute ohungarumlaut -111\r\nKPX Yacute omacron -111\r\nKPX Yacute oslash -111\r\nKPX Yacute otilde -111\r\nKPX Yacute period -92\r\nKPX Yacute semicolon -92\r\nKPX Yacute u -92\r\nKPX Yacute uacute -92\r\nKPX Yacute ucircumflex -92\r\nKPX Yacute udieresis -92\r\nKPX Yacute ugrave -92\r\nKPX Yacute uhungarumlaut -92\r\nKPX Yacute umacron -92\r\nKPX Yacute uogonek -92\r\nKPX Yacute uring -92\r\nKPX Ydieresis A -110\r\nKPX Ydieresis Aacute -110\r\nKPX Ydieresis Abreve -110\r\nKPX Ydieresis Acircumflex -110\r\nKPX Ydieresis Adieresis -110\r\nKPX Ydieresis Agrave -110\r\nKPX Ydieresis Amacron -110\r\nKPX Ydieresis Aogonek -110\r\nKPX Ydieresis Aring -110\r\nKPX Ydieresis Atilde -110\r\nKPX Ydieresis O -35\r\nKPX Ydieresis Oacute -35\r\nKPX Ydieresis Ocircumflex -35\r\nKPX Ydieresis Odieresis -35\r\nKPX Ydieresis Ograve -35\r\nKPX Ydieresis Ohungarumlaut -35\r\nKPX Ydieresis Omacron -35\r\nKPX Ydieresis Oslash -35\r\nKPX Ydieresis Otilde -35\r\nKPX Ydieresis a -85\r\nKPX Ydieresis aacute -85\r\nKPX Ydieresis abreve -85\r\nKPX Ydieresis acircumflex -85\r\nKPX Ydieresis adieresis -85\r\nKPX Ydieresis agrave -85\r\nKPX Ydieresis amacron -85\r\nKPX Ydieresis aogonek -85\r\nKPX Ydieresis aring -85\r\nKPX Ydieresis atilde -85\r\nKPX Ydieresis colon -92\r\nKPX Ydieresis comma -92\r\nKPX Ydieresis e -111\r\nKPX Ydieresis eacute -111\r\nKPX Ydieresis ecaron -111\r\nKPX Ydieresis ecircumflex -111\r\nKPX Ydieresis edieresis -71\r\nKPX Ydieresis edotaccent -111\r\nKPX Ydieresis egrave -71\r\nKPX Ydieresis emacron -71\r\nKPX Ydieresis eogonek -111\r\nKPX Ydieresis hyphen -92\r\nKPX Ydieresis i -37\r\nKPX Ydieresis iacute -37\r\nKPX Ydieresis iogonek -37\r\nKPX Ydieresis o -111\r\nKPX Ydieresis oacute -111\r\nKPX Ydieresis ocircumflex -111\r\nKPX Ydieresis odieresis -111\r\nKPX Ydieresis ograve -111\r\nKPX Ydieresis ohungarumlaut -111\r\nKPX Ydieresis omacron -111\r\nKPX Ydieresis oslash -111\r\nKPX Ydieresis otilde -111\r\nKPX Ydieresis period -92\r\nKPX Ydieresis semicolon -92\r\nKPX Ydieresis u -92\r\nKPX Ydieresis uacute -92\r\nKPX Ydieresis ucircumflex -92\r\nKPX Ydieresis udieresis -92\r\nKPX Ydieresis ugrave -92\r\nKPX Ydieresis uhungarumlaut -92\r\nKPX Ydieresis umacron -92\r\nKPX Ydieresis uogonek -92\r\nKPX Ydieresis uring -92\r\nKPX a v -25\r\nKPX aacute v -25\r\nKPX abreve v -25\r\nKPX acircumflex v -25\r\nKPX adieresis v -25\r\nKPX agrave v -25\r\nKPX amacron v -25\r\nKPX aogonek v -25\r\nKPX aring v -25\r\nKPX atilde v -25\r\nKPX b b -10\r\nKPX b period -40\r\nKPX b u -20\r\nKPX b uacute -20\r\nKPX b ucircumflex -20\r\nKPX b udieresis -20\r\nKPX b ugrave -20\r\nKPX b uhungarumlaut -20\r\nKPX b umacron -20\r\nKPX b uogonek -20\r\nKPX b uring -20\r\nKPX b v -15\r\nKPX comma quotedblright -45\r\nKPX comma quoteright -55\r\nKPX d w -15\r\nKPX dcroat w -15\r\nKPX e v -15\r\nKPX eacute v -15\r\nKPX ecaron v -15\r\nKPX ecircumflex v -15\r\nKPX edieresis v -15\r\nKPX edotaccent v -15\r\nKPX egrave v -15\r\nKPX emacron v -15\r\nKPX eogonek v -15\r\nKPX f comma -15\r\nKPX f dotlessi -35\r\nKPX f i -25\r\nKPX f o -25\r\nKPX f oacute -25\r\nKPX f ocircumflex -25\r\nKPX f odieresis -25\r\nKPX f ograve -25\r\nKPX f ohungarumlaut -25\r\nKPX f omacron -25\r\nKPX f oslash -25\r\nKPX f otilde -25\r\nKPX f period -15\r\nKPX f quotedblright 50\r\nKPX f quoteright 55\r\nKPX g period -15\r\nKPX gbreve period -15\r\nKPX gcommaaccent period -15\r\nKPX h y -15\r\nKPX h yacute -15\r\nKPX h ydieresis -15\r\nKPX i v -10\r\nKPX iacute v -10\r\nKPX icircumflex v -10\r\nKPX idieresis v -10\r\nKPX igrave v -10\r\nKPX imacron v -10\r\nKPX iogonek v -10\r\nKPX k e -10\r\nKPX k eacute -10\r\nKPX k ecaron -10\r\nKPX k ecircumflex -10\r\nKPX k edieresis -10\r\nKPX k edotaccent -10\r\nKPX k egrave -10\r\nKPX k emacron -10\r\nKPX k eogonek -10\r\nKPX k o -15\r\nKPX k oacute -15\r\nKPX k ocircumflex -15\r\nKPX k odieresis -15\r\nKPX k ograve -15\r\nKPX k ohungarumlaut -15\r\nKPX k omacron -15\r\nKPX k oslash -15\r\nKPX k otilde -15\r\nKPX k y -15\r\nKPX k yacute -15\r\nKPX k ydieresis -15\r\nKPX kcommaaccent e -10\r\nKPX kcommaaccent eacute -10\r\nKPX kcommaaccent ecaron -10\r\nKPX kcommaaccent ecircumflex -10\r\nKPX kcommaaccent edieresis -10\r\nKPX kcommaaccent edotaccent -10\r\nKPX kcommaaccent egrave -10\r\nKPX kcommaaccent emacron -10\r\nKPX kcommaaccent eogonek -10\r\nKPX kcommaaccent o -15\r\nKPX kcommaaccent oacute -15\r\nKPX kcommaaccent ocircumflex -15\r\nKPX kcommaaccent odieresis -15\r\nKPX kcommaaccent ograve -15\r\nKPX kcommaaccent ohungarumlaut -15\r\nKPX kcommaaccent omacron -15\r\nKPX kcommaaccent oslash -15\r\nKPX kcommaaccent otilde -15\r\nKPX kcommaaccent y -15\r\nKPX kcommaaccent yacute -15\r\nKPX kcommaaccent ydieresis -15\r\nKPX n v -40\r\nKPX nacute v -40\r\nKPX ncaron v -40\r\nKPX ncommaaccent v -40\r\nKPX ntilde v -40\r\nKPX o v -10\r\nKPX o w -10\r\nKPX oacute v -10\r\nKPX oacute w -10\r\nKPX ocircumflex v -10\r\nKPX ocircumflex w -10\r\nKPX odieresis v -10\r\nKPX odieresis w -10\r\nKPX ograve v -10\r\nKPX ograve w -10\r\nKPX ohungarumlaut v -10\r\nKPX ohungarumlaut w -10\r\nKPX omacron v -10\r\nKPX omacron w -10\r\nKPX oslash v -10\r\nKPX oslash w -10\r\nKPX otilde v -10\r\nKPX otilde w -10\r\nKPX period quotedblright -55\r\nKPX period quoteright -55\r\nKPX quotedblleft A -10\r\nKPX quotedblleft Aacute -10\r\nKPX quotedblleft Abreve -10\r\nKPX quotedblleft Acircumflex -10\r\nKPX quotedblleft Adieresis -10\r\nKPX quotedblleft Agrave -10\r\nKPX quotedblleft Amacron -10\r\nKPX quotedblleft Aogonek -10\r\nKPX quotedblleft Aring -10\r\nKPX quotedblleft Atilde -10\r\nKPX quoteleft A -10\r\nKPX quoteleft Aacute -10\r\nKPX quoteleft Abreve -10\r\nKPX quoteleft Acircumflex -10\r\nKPX quoteleft Adieresis -10\r\nKPX quoteleft Agrave -10\r\nKPX quoteleft Amacron -10\r\nKPX quoteleft Aogonek -10\r\nKPX quoteleft Aring -10\r\nKPX quoteleft Atilde -10\r\nKPX quoteleft quoteleft -63\r\nKPX quoteright d -20\r\nKPX quoteright dcroat -20\r\nKPX quoteright quoteright -63\r\nKPX quoteright r -20\r\nKPX quoteright racute -20\r\nKPX quoteright rcaron -20\r\nKPX quoteright rcommaaccent -20\r\nKPX quoteright s -37\r\nKPX quoteright sacute -37\r\nKPX quoteright scaron -37\r\nKPX quoteright scedilla -37\r\nKPX quoteright scommaaccent -37\r\nKPX quoteright space -74\r\nKPX quoteright v -20\r\nKPX r c -18\r\nKPX r cacute -18\r\nKPX r ccaron -18\r\nKPX r ccedilla -18\r\nKPX r comma -92\r\nKPX r e -18\r\nKPX r eacute -18\r\nKPX r ecaron -18\r\nKPX r ecircumflex -18\r\nKPX r edieresis -18\r\nKPX r edotaccent -18\r\nKPX r egrave -18\r\nKPX r emacron -18\r\nKPX r eogonek -18\r\nKPX r g -10\r\nKPX r gbreve -10\r\nKPX r gcommaaccent -10\r\nKPX r hyphen -37\r\nKPX r n -15\r\nKPX r nacute -15\r\nKPX r ncaron -15\r\nKPX r ncommaaccent -15\r\nKPX r ntilde -15\r\nKPX r o -18\r\nKPX r oacute -18\r\nKPX r ocircumflex -18\r\nKPX r odieresis -18\r\nKPX r ograve -18\r\nKPX r ohungarumlaut -18\r\nKPX r omacron -18\r\nKPX r oslash -18\r\nKPX r otilde -18\r\nKPX r p -10\r\nKPX r period -100\r\nKPX r q -18\r\nKPX r v -10\r\nKPX racute c -18\r\nKPX racute cacute -18\r\nKPX racute ccaron -18\r\nKPX racute ccedilla -18\r\nKPX racute comma -92\r\nKPX racute e -18\r\nKPX racute eacute -18\r\nKPX racute ecaron -18\r\nKPX racute ecircumflex -18\r\nKPX racute edieresis -18\r\nKPX racute edotaccent -18\r\nKPX racute egrave -18\r\nKPX racute emacron -18\r\nKPX racute eogonek -18\r\nKPX racute g -10\r\nKPX racute gbreve -10\r\nKPX racute gcommaaccent -10\r\nKPX racute hyphen -37\r\nKPX racute n -15\r\nKPX racute nacute -15\r\nKPX racute ncaron -15\r\nKPX racute ncommaaccent -15\r\nKPX racute ntilde -15\r\nKPX racute o -18\r\nKPX racute oacute -18\r\nKPX racute ocircumflex -18\r\nKPX racute odieresis -18\r\nKPX racute ograve -18\r\nKPX racute ohungarumlaut -18\r\nKPX racute omacron -18\r\nKPX racute oslash -18\r\nKPX racute otilde -18\r\nKPX racute p -10\r\nKPX racute period -100\r\nKPX racute q -18\r\nKPX racute v -10\r\nKPX rcaron c -18\r\nKPX rcaron cacute -18\r\nKPX rcaron ccaron -18\r\nKPX rcaron ccedilla -18\r\nKPX rcaron comma -92\r\nKPX rcaron e -18\r\nKPX rcaron eacute -18\r\nKPX rcaron ecaron -18\r\nKPX rcaron ecircumflex -18\r\nKPX rcaron edieresis -18\r\nKPX rcaron edotaccent -18\r\nKPX rcaron egrave -18\r\nKPX rcaron emacron -18\r\nKPX rcaron eogonek -18\r\nKPX rcaron g -10\r\nKPX rcaron gbreve -10\r\nKPX rcaron gcommaaccent -10\r\nKPX rcaron hyphen -37\r\nKPX rcaron n -15\r\nKPX rcaron nacute -15\r\nKPX rcaron ncaron -15\r\nKPX rcaron ncommaaccent -15\r\nKPX rcaron ntilde -15\r\nKPX rcaron o -18\r\nKPX rcaron oacute -18\r\nKPX rcaron ocircumflex -18\r\nKPX rcaron odieresis -18\r\nKPX rcaron ograve -18\r\nKPX rcaron ohungarumlaut -18\r\nKPX rcaron omacron -18\r\nKPX rcaron oslash -18\r\nKPX rcaron otilde -18\r\nKPX rcaron p -10\r\nKPX rcaron period -100\r\nKPX rcaron q -18\r\nKPX rcaron v -10\r\nKPX rcommaaccent c -18\r\nKPX rcommaaccent cacute -18\r\nKPX rcommaaccent ccaron -18\r\nKPX rcommaaccent ccedilla -18\r\nKPX rcommaaccent comma -92\r\nKPX rcommaaccent e -18\r\nKPX rcommaaccent eacute -18\r\nKPX rcommaaccent ecaron -18\r\nKPX rcommaaccent ecircumflex -18\r\nKPX rcommaaccent edieresis -18\r\nKPX rcommaaccent edotaccent -18\r\nKPX rcommaaccent egrave -18\r\nKPX rcommaaccent emacron -18\r\nKPX rcommaaccent eogonek -18\r\nKPX rcommaaccent g -10\r\nKPX rcommaaccent gbreve -10\r\nKPX rcommaaccent gcommaaccent -10\r\nKPX rcommaaccent hyphen -37\r\nKPX rcommaaccent n -15\r\nKPX rcommaaccent nacute -15\r\nKPX rcommaaccent ncaron -15\r\nKPX rcommaaccent ncommaaccent -15\r\nKPX rcommaaccent ntilde -15\r\nKPX rcommaaccent o -18\r\nKPX rcommaaccent oacute -18\r\nKPX rcommaaccent ocircumflex -18\r\nKPX rcommaaccent odieresis -18\r\nKPX rcommaaccent ograve -18\r\nKPX rcommaaccent ohungarumlaut -18\r\nKPX rcommaaccent omacron -18\r\nKPX rcommaaccent oslash -18\r\nKPX rcommaaccent otilde -18\r\nKPX rcommaaccent p -10\r\nKPX rcommaaccent period -100\r\nKPX rcommaaccent q -18\r\nKPX rcommaaccent v -10\r\nKPX space A -55\r\nKPX space Aacute -55\r\nKPX space Abreve -55\r\nKPX space Acircumflex -55\r\nKPX space Adieresis -55\r\nKPX space Agrave -55\r\nKPX space Amacron -55\r\nKPX space Aogonek -55\r\nKPX space Aring -55\r\nKPX space Atilde -55\r\nKPX space T -30\r\nKPX space Tcaron -30\r\nKPX space Tcommaaccent -30\r\nKPX space V -45\r\nKPX space W -30\r\nKPX space Y -55\r\nKPX space Yacute -55\r\nKPX space Ydieresis -55\r\nKPX v a -10\r\nKPX v aacute -10\r\nKPX v abreve -10\r\nKPX v acircumflex -10\r\nKPX v adieresis -10\r\nKPX v agrave -10\r\nKPX v amacron -10\r\nKPX v aogonek -10\r\nKPX v aring -10\r\nKPX v atilde -10\r\nKPX v comma -55\r\nKPX v e -10\r\nKPX v eacute -10\r\nKPX v ecaron -10\r\nKPX v ecircumflex -10\r\nKPX v edieresis -10\r\nKPX v edotaccent -10\r\nKPX v egrave -10\r\nKPX v emacron -10\r\nKPX v eogonek -10\r\nKPX v o -10\r\nKPX v oacute -10\r\nKPX v ocircumflex -10\r\nKPX v odieresis -10\r\nKPX v ograve -10\r\nKPX v ohungarumlaut -10\r\nKPX v omacron -10\r\nKPX v oslash -10\r\nKPX v otilde -10\r\nKPX v period -70\r\nKPX w comma -55\r\nKPX w o -10\r\nKPX w oacute -10\r\nKPX w ocircumflex -10\r\nKPX w odieresis -10\r\nKPX w ograve -10\r\nKPX w ohungarumlaut -10\r\nKPX w omacron -10\r\nKPX w oslash -10\r\nKPX w otilde -10\r\nKPX w period -70\r\nKPX y comma -55\r\nKPX y e -10\r\nKPX y eacute -10\r\nKPX y ecaron -10\r\nKPX y ecircumflex -10\r\nKPX y edieresis -10\r\nKPX y edotaccent -10\r\nKPX y egrave -10\r\nKPX y emacron -10\r\nKPX y eogonek -10\r\nKPX y o -25\r\nKPX y oacute -25\r\nKPX y ocircumflex -25\r\nKPX y odieresis -25\r\nKPX y ograve -25\r\nKPX y ohungarumlaut -25\r\nKPX y omacron -25\r\nKPX y oslash -25\r\nKPX y otilde -25\r\nKPX y period -70\r\nKPX yacute comma -55\r\nKPX yacute e -10\r\nKPX yacute eacute -10\r\nKPX yacute ecaron -10\r\nKPX yacute ecircumflex -10\r\nKPX yacute edieresis -10\r\nKPX yacute edotaccent -10\r\nKPX yacute egrave -10\r\nKPX yacute emacron -10\r\nKPX yacute eogonek -10\r\nKPX yacute o -25\r\nKPX yacute oacute -25\r\nKPX yacute ocircumflex -25\r\nKPX yacute odieresis -25\r\nKPX yacute ograve -25\r\nKPX yacute ohungarumlaut -25\r\nKPX yacute omacron -25\r\nKPX yacute oslash -25\r\nKPX yacute otilde -25\r\nKPX yacute period -70\r\nKPX ydieresis comma -55\r\nKPX ydieresis e -10\r\nKPX ydieresis eacute -10\r\nKPX ydieresis ecaron -10\r\nKPX ydieresis ecircumflex -10\r\nKPX ydieresis edieresis -10\r\nKPX ydieresis edotaccent -10\r\nKPX ydieresis egrave -10\r\nKPX ydieresis emacron -10\r\nKPX ydieresis eogonek -10\r\nKPX ydieresis o -25\r\nKPX ydieresis oacute -25\r\nKPX ydieresis ocircumflex -25\r\nKPX ydieresis odieresis -25\r\nKPX ydieresis ograve -25\r\nKPX ydieresis ohungarumlaut -25\r\nKPX ydieresis omacron -25\r\nKPX ydieresis oslash -25\r\nKPX ydieresis otilde -25\r\nKPX ydieresis period -70\r\nEndKernPairs\r\nEndKernData\r\nEndFontMetrics\r\n";
  },
  'Times-Italic'() {
    return "StartFontMetrics 4.1\r\nComment Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.\r\nComment Creation Date: Thu May  1 12:56:55 1997\r\nComment UniqueID 43067\r\nComment VMusage 47727 58752\r\nFontName Times-Italic\r\nFullName Times Italic\r\nFamilyName Times\r\nWeight Medium\r\nItalicAngle -15.5\r\nIsFixedPitch false\r\nCharacterSet ExtendedRoman\r\nFontBBox -169 -217 1010 883 \r\nUnderlinePosition -100\r\nUnderlineThickness 50\r\nVersion 002.000\r\nNotice Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.Times is a trademark of Linotype-Hell AG and/or its subsidiaries.\r\nEncodingScheme AdobeStandardEncoding\r\nCapHeight 653\r\nXHeight 441\r\nAscender 683\r\nDescender -217\r\nStdHW 32\r\nStdVW 76\r\nStartCharMetrics 315\r\nC 32 ; WX 250 ; N space ; B 0 0 0 0 ;\r\nC 33 ; WX 333 ; N exclam ; B 39 -11 302 667 ;\r\nC 34 ; WX 420 ; N quotedbl ; B 144 421 432 666 ;\r\nC 35 ; WX 500 ; N numbersign ; B 2 0 540 676 ;\r\nC 36 ; WX 500 ; N dollar ; B 31 -89 497 731 ;\r\nC 37 ; WX 833 ; N percent ; B 79 -13 790 676 ;\r\nC 38 ; WX 778 ; N ampersand ; B 76 -18 723 666 ;\r\nC 39 ; WX 333 ; N quoteright ; B 151 436 290 666 ;\r\nC 40 ; WX 333 ; N parenleft ; B 42 -181 315 669 ;\r\nC 41 ; WX 333 ; N parenright ; B 16 -180 289 669 ;\r\nC 42 ; WX 500 ; N asterisk ; B 128 255 492 666 ;\r\nC 43 ; WX 675 ; N plus ; B 86 0 590 506 ;\r\nC 44 ; WX 250 ; N comma ; B -4 -129 135 101 ;\r\nC 45 ; WX 333 ; N hyphen ; B 49 192 282 255 ;\r\nC 46 ; WX 250 ; N period ; B 27 -11 138 100 ;\r\nC 47 ; WX 278 ; N slash ; B -65 -18 386 666 ;\r\nC 48 ; WX 500 ; N zero ; B 32 -7 497 676 ;\r\nC 49 ; WX 500 ; N one ; B 49 0 409 676 ;\r\nC 50 ; WX 500 ; N two ; B 12 0 452 676 ;\r\nC 51 ; WX 500 ; N three ; B 15 -7 465 676 ;\r\nC 52 ; WX 500 ; N four ; B 1 0 479 676 ;\r\nC 53 ; WX 500 ; N five ; B 15 -7 491 666 ;\r\nC 54 ; WX 500 ; N six ; B 30 -7 521 686 ;\r\nC 55 ; WX 500 ; N seven ; B 75 -8 537 666 ;\r\nC 56 ; WX 500 ; N eight ; B 30 -7 493 676 ;\r\nC 57 ; WX 500 ; N nine ; B 23 -17 492 676 ;\r\nC 58 ; WX 333 ; N colon ; B 50 -11 261 441 ;\r\nC 59 ; WX 333 ; N semicolon ; B 27 -129 261 441 ;\r\nC 60 ; WX 675 ; N less ; B 84 -8 592 514 ;\r\nC 61 ; WX 675 ; N equal ; B 86 120 590 386 ;\r\nC 62 ; WX 675 ; N greater ; B 84 -8 592 514 ;\r\nC 63 ; WX 500 ; N question ; B 132 -12 472 664 ;\r\nC 64 ; WX 920 ; N at ; B 118 -18 806 666 ;\r\nC 65 ; WX 611 ; N A ; B -51 0 564 668 ;\r\nC 66 ; WX 611 ; N B ; B -8 0 588 653 ;\r\nC 67 ; WX 667 ; N C ; B 66 -18 689 666 ;\r\nC 68 ; WX 722 ; N D ; B -8 0 700 653 ;\r\nC 69 ; WX 611 ; N E ; B -1 0 634 653 ;\r\nC 70 ; WX 611 ; N F ; B 8 0 645 653 ;\r\nC 71 ; WX 722 ; N G ; B 52 -18 722 666 ;\r\nC 72 ; WX 722 ; N H ; B -8 0 767 653 ;\r\nC 73 ; WX 333 ; N I ; B -8 0 384 653 ;\r\nC 74 ; WX 444 ; N J ; B -6 -18 491 653 ;\r\nC 75 ; WX 667 ; N K ; B 7 0 722 653 ;\r\nC 76 ; WX 556 ; N L ; B -8 0 559 653 ;\r\nC 77 ; WX 833 ; N M ; B -18 0 873 653 ;\r\nC 78 ; WX 667 ; N N ; B -20 -15 727 653 ;\r\nC 79 ; WX 722 ; N O ; B 60 -18 699 666 ;\r\nC 80 ; WX 611 ; N P ; B 0 0 605 653 ;\r\nC 81 ; WX 722 ; N Q ; B 59 -182 699 666 ;\r\nC 82 ; WX 611 ; N R ; B -13 0 588 653 ;\r\nC 83 ; WX 500 ; N S ; B 17 -18 508 667 ;\r\nC 84 ; WX 556 ; N T ; B 59 0 633 653 ;\r\nC 85 ; WX 722 ; N U ; B 102 -18 765 653 ;\r\nC 86 ; WX 611 ; N V ; B 76 -18 688 653 ;\r\nC 87 ; WX 833 ; N W ; B 71 -18 906 653 ;\r\nC 88 ; WX 611 ; N X ; B -29 0 655 653 ;\r\nC 89 ; WX 556 ; N Y ; B 78 0 633 653 ;\r\nC 90 ; WX 556 ; N Z ; B -6 0 606 653 ;\r\nC 91 ; WX 389 ; N bracketleft ; B 21 -153 391 663 ;\r\nC 92 ; WX 278 ; N backslash ; B -41 -18 319 666 ;\r\nC 93 ; WX 389 ; N bracketright ; B 12 -153 382 663 ;\r\nC 94 ; WX 422 ; N asciicircum ; B 0 301 422 666 ;\r\nC 95 ; WX 500 ; N underscore ; B 0 -125 500 -75 ;\r\nC 96 ; WX 333 ; N quoteleft ; B 171 436 310 666 ;\r\nC 97 ; WX 500 ; N a ; B 17 -11 476 441 ;\r\nC 98 ; WX 500 ; N b ; B 23 -11 473 683 ;\r\nC 99 ; WX 444 ; N c ; B 30 -11 425 441 ;\r\nC 100 ; WX 500 ; N d ; B 15 -13 527 683 ;\r\nC 101 ; WX 444 ; N e ; B 31 -11 412 441 ;\r\nC 102 ; WX 278 ; N f ; B -147 -207 424 678 ; L i fi ; L l fl ;\r\nC 103 ; WX 500 ; N g ; B 8 -206 472 441 ;\r\nC 104 ; WX 500 ; N h ; B 19 -9 478 683 ;\r\nC 105 ; WX 278 ; N i ; B 49 -11 264 654 ;\r\nC 106 ; WX 278 ; N j ; B -124 -207 276 654 ;\r\nC 107 ; WX 444 ; N k ; B 14 -11 461 683 ;\r\nC 108 ; WX 278 ; N l ; B 41 -11 279 683 ;\r\nC 109 ; WX 722 ; N m ; B 12 -9 704 441 ;\r\nC 110 ; WX 500 ; N n ; B 14 -9 474 441 ;\r\nC 111 ; WX 500 ; N o ; B 27 -11 468 441 ;\r\nC 112 ; WX 500 ; N p ; B -75 -205 469 441 ;\r\nC 113 ; WX 500 ; N q ; B 25 -209 483 441 ;\r\nC 114 ; WX 389 ; N r ; B 45 0 412 441 ;\r\nC 115 ; WX 389 ; N s ; B 16 -13 366 442 ;\r\nC 116 ; WX 278 ; N t ; B 37 -11 296 546 ;\r\nC 117 ; WX 500 ; N u ; B 42 -11 475 441 ;\r\nC 118 ; WX 444 ; N v ; B 21 -18 426 441 ;\r\nC 119 ; WX 667 ; N w ; B 16 -18 648 441 ;\r\nC 120 ; WX 444 ; N x ; B -27 -11 447 441 ;\r\nC 121 ; WX 444 ; N y ; B -24 -206 426 441 ;\r\nC 122 ; WX 389 ; N z ; B -2 -81 380 428 ;\r\nC 123 ; WX 400 ; N braceleft ; B 51 -177 407 687 ;\r\nC 124 ; WX 275 ; N bar ; B 105 -217 171 783 ;\r\nC 125 ; WX 400 ; N braceright ; B -7 -177 349 687 ;\r\nC 126 ; WX 541 ; N asciitilde ; B 40 183 502 323 ;\r\nC 161 ; WX 389 ; N exclamdown ; B 59 -205 322 473 ;\r\nC 162 ; WX 500 ; N cent ; B 77 -143 472 560 ;\r\nC 163 ; WX 500 ; N sterling ; B 10 -6 517 670 ;\r\nC 164 ; WX 167 ; N fraction ; B -169 -10 337 676 ;\r\nC 165 ; WX 500 ; N yen ; B 27 0 603 653 ;\r\nC 166 ; WX 500 ; N florin ; B 25 -182 507 682 ;\r\nC 167 ; WX 500 ; N section ; B 53 -162 461 666 ;\r\nC 168 ; WX 500 ; N currency ; B -22 53 522 597 ;\r\nC 169 ; WX 214 ; N quotesingle ; B 132 421 241 666 ;\r\nC 170 ; WX 556 ; N quotedblleft ; B 166 436 514 666 ;\r\nC 171 ; WX 500 ; N guillemotleft ; B 53 37 445 403 ;\r\nC 172 ; WX 333 ; N guilsinglleft ; B 51 37 281 403 ;\r\nC 173 ; WX 333 ; N guilsinglright ; B 52 37 282 403 ;\r\nC 174 ; WX 500 ; N fi ; B -141 -207 481 681 ;\r\nC 175 ; WX 500 ; N fl ; B -141 -204 518 682 ;\r\nC 177 ; WX 500 ; N endash ; B -6 197 505 243 ;\r\nC 178 ; WX 500 ; N dagger ; B 101 -159 488 666 ;\r\nC 179 ; WX 500 ; N daggerdbl ; B 22 -143 491 666 ;\r\nC 180 ; WX 250 ; N periodcentered ; B 70 199 181 310 ;\r\nC 182 ; WX 523 ; N paragraph ; B 55 -123 616 653 ;\r\nC 183 ; WX 350 ; N bullet ; B 40 191 310 461 ;\r\nC 184 ; WX 333 ; N quotesinglbase ; B 44 -129 183 101 ;\r\nC 185 ; WX 556 ; N quotedblbase ; B 57 -129 405 101 ;\r\nC 186 ; WX 556 ; N quotedblright ; B 151 436 499 666 ;\r\nC 187 ; WX 500 ; N guillemotright ; B 55 37 447 403 ;\r\nC 188 ; WX 889 ; N ellipsis ; B 57 -11 762 100 ;\r\nC 189 ; WX 1000 ; N perthousand ; B 25 -19 1010 706 ;\r\nC 191 ; WX 500 ; N questiondown ; B 28 -205 368 471 ;\r\nC 193 ; WX 333 ; N grave ; B 121 492 311 664 ;\r\nC 194 ; WX 333 ; N acute ; B 180 494 403 664 ;\r\nC 195 ; WX 333 ; N circumflex ; B 91 492 385 661 ;\r\nC 196 ; WX 333 ; N tilde ; B 100 517 427 624 ;\r\nC 197 ; WX 333 ; N macron ; B 99 532 411 583 ;\r\nC 198 ; WX 333 ; N breve ; B 117 492 418 650 ;\r\nC 199 ; WX 333 ; N dotaccent ; B 207 548 305 646 ;\r\nC 200 ; WX 333 ; N dieresis ; B 107 548 405 646 ;\r\nC 202 ; WX 333 ; N ring ; B 155 492 355 691 ;\r\nC 203 ; WX 333 ; N cedilla ; B -30 -217 182 0 ;\r\nC 205 ; WX 333 ; N hungarumlaut ; B 93 494 486 664 ;\r\nC 206 ; WX 333 ; N ogonek ; B 20 -169 203 40 ;\r\nC 207 ; WX 333 ; N caron ; B 121 492 426 661 ;\r\nC 208 ; WX 889 ; N emdash ; B -6 197 894 243 ;\r\nC 225 ; WX 889 ; N AE ; B -27 0 911 653 ;\r\nC 227 ; WX 276 ; N ordfeminine ; B 42 406 352 676 ;\r\nC 232 ; WX 556 ; N Lslash ; B -8 0 559 653 ;\r\nC 233 ; WX 722 ; N Oslash ; B 60 -105 699 722 ;\r\nC 234 ; WX 944 ; N OE ; B 49 -8 964 666 ;\r\nC 235 ; WX 310 ; N ordmasculine ; B 67 406 362 676 ;\r\nC 241 ; WX 667 ; N ae ; B 23 -11 640 441 ;\r\nC 245 ; WX 278 ; N dotlessi ; B 49 -11 235 441 ;\r\nC 248 ; WX 278 ; N lslash ; B 41 -11 312 683 ;\r\nC 249 ; WX 500 ; N oslash ; B 28 -135 469 554 ;\r\nC 250 ; WX 667 ; N oe ; B 20 -12 646 441 ;\r\nC 251 ; WX 500 ; N germandbls ; B -168 -207 493 679 ;\r\nC -1 ; WX 333 ; N Idieresis ; B -8 0 435 818 ;\r\nC -1 ; WX 444 ; N eacute ; B 31 -11 459 664 ;\r\nC -1 ; WX 500 ; N abreve ; B 17 -11 502 650 ;\r\nC -1 ; WX 500 ; N uhungarumlaut ; B 42 -11 580 664 ;\r\nC -1 ; WX 444 ; N ecaron ; B 31 -11 482 661 ;\r\nC -1 ; WX 556 ; N Ydieresis ; B 78 0 633 818 ;\r\nC -1 ; WX 675 ; N divide ; B 86 -11 590 517 ;\r\nC -1 ; WX 556 ; N Yacute ; B 78 0 633 876 ;\r\nC -1 ; WX 611 ; N Acircumflex ; B -51 0 564 873 ;\r\nC -1 ; WX 500 ; N aacute ; B 17 -11 487 664 ;\r\nC -1 ; WX 722 ; N Ucircumflex ; B 102 -18 765 873 ;\r\nC -1 ; WX 444 ; N yacute ; B -24 -206 459 664 ;\r\nC -1 ; WX 389 ; N scommaaccent ; B 16 -217 366 442 ;\r\nC -1 ; WX 444 ; N ecircumflex ; B 31 -11 441 661 ;\r\nC -1 ; WX 722 ; N Uring ; B 102 -18 765 883 ;\r\nC -1 ; WX 722 ; N Udieresis ; B 102 -18 765 818 ;\r\nC -1 ; WX 500 ; N aogonek ; B 17 -169 476 441 ;\r\nC -1 ; WX 722 ; N Uacute ; B 102 -18 765 876 ;\r\nC -1 ; WX 500 ; N uogonek ; B 42 -169 477 441 ;\r\nC -1 ; WX 611 ; N Edieresis ; B -1 0 634 818 ;\r\nC -1 ; WX 722 ; N Dcroat ; B -8 0 700 653 ;\r\nC -1 ; WX 250 ; N commaaccent ; B 8 -217 133 -50 ;\r\nC -1 ; WX 760 ; N copyright ; B 41 -18 719 666 ;\r\nC -1 ; WX 611 ; N Emacron ; B -1 0 634 795 ;\r\nC -1 ; WX 444 ; N ccaron ; B 30 -11 482 661 ;\r\nC -1 ; WX 500 ; N aring ; B 17 -11 476 691 ;\r\nC -1 ; WX 667 ; N Ncommaaccent ; B -20 -187 727 653 ;\r\nC -1 ; WX 278 ; N lacute ; B 41 -11 395 876 ;\r\nC -1 ; WX 500 ; N agrave ; B 17 -11 476 664 ;\r\nC -1 ; WX 556 ; N Tcommaaccent ; B 59 -217 633 653 ;\r\nC -1 ; WX 667 ; N Cacute ; B 66 -18 690 876 ;\r\nC -1 ; WX 500 ; N atilde ; B 17 -11 511 624 ;\r\nC -1 ; WX 611 ; N Edotaccent ; B -1 0 634 818 ;\r\nC -1 ; WX 389 ; N scaron ; B 16 -13 454 661 ;\r\nC -1 ; WX 389 ; N scedilla ; B 16 -217 366 442 ;\r\nC -1 ; WX 278 ; N iacute ; B 49 -11 355 664 ;\r\nC -1 ; WX 471 ; N lozenge ; B 13 0 459 724 ;\r\nC -1 ; WX 611 ; N Rcaron ; B -13 0 588 873 ;\r\nC -1 ; WX 722 ; N Gcommaaccent ; B 52 -217 722 666 ;\r\nC -1 ; WX 500 ; N ucircumflex ; B 42 -11 475 661 ;\r\nC -1 ; WX 500 ; N acircumflex ; B 17 -11 476 661 ;\r\nC -1 ; WX 611 ; N Amacron ; B -51 0 564 795 ;\r\nC -1 ; WX 389 ; N rcaron ; B 45 0 434 661 ;\r\nC -1 ; WX 444 ; N ccedilla ; B 30 -217 425 441 ;\r\nC -1 ; WX 556 ; N Zdotaccent ; B -6 0 606 818 ;\r\nC -1 ; WX 611 ; N Thorn ; B 0 0 569 653 ;\r\nC -1 ; WX 722 ; N Omacron ; B 60 -18 699 795 ;\r\nC -1 ; WX 611 ; N Racute ; B -13 0 588 876 ;\r\nC -1 ; WX 500 ; N Sacute ; B 17 -18 508 876 ;\r\nC -1 ; WX 544 ; N dcaron ; B 15 -13 658 683 ;\r\nC -1 ; WX 722 ; N Umacron ; B 102 -18 765 795 ;\r\nC -1 ; WX 500 ; N uring ; B 42 -11 475 691 ;\r\nC -1 ; WX 300 ; N threesuperior ; B 43 268 339 676 ;\r\nC -1 ; WX 722 ; N Ograve ; B 60 -18 699 876 ;\r\nC -1 ; WX 611 ; N Agrave ; B -51 0 564 876 ;\r\nC -1 ; WX 611 ; N Abreve ; B -51 0 564 862 ;\r\nC -1 ; WX 675 ; N multiply ; B 93 8 582 497 ;\r\nC -1 ; WX 500 ; N uacute ; B 42 -11 477 664 ;\r\nC -1 ; WX 556 ; N Tcaron ; B 59 0 633 873 ;\r\nC -1 ; WX 476 ; N partialdiff ; B 17 -38 459 710 ;\r\nC -1 ; WX 444 ; N ydieresis ; B -24 -206 441 606 ;\r\nC -1 ; WX 667 ; N Nacute ; B -20 -15 727 876 ;\r\nC -1 ; WX 278 ; N icircumflex ; B 33 -11 327 661 ;\r\nC -1 ; WX 611 ; N Ecircumflex ; B -1 0 634 873 ;\r\nC -1 ; WX 500 ; N adieresis ; B 17 -11 489 606 ;\r\nC -1 ; WX 444 ; N edieresis ; B 31 -11 451 606 ;\r\nC -1 ; WX 444 ; N cacute ; B 30 -11 459 664 ;\r\nC -1 ; WX 500 ; N nacute ; B 14 -9 477 664 ;\r\nC -1 ; WX 500 ; N umacron ; B 42 -11 485 583 ;\r\nC -1 ; WX 667 ; N Ncaron ; B -20 -15 727 873 ;\r\nC -1 ; WX 333 ; N Iacute ; B -8 0 433 876 ;\r\nC -1 ; WX 675 ; N plusminus ; B 86 0 590 506 ;\r\nC -1 ; WX 275 ; N brokenbar ; B 105 -142 171 708 ;\r\nC -1 ; WX 760 ; N registered ; B 41 -18 719 666 ;\r\nC -1 ; WX 722 ; N Gbreve ; B 52 -18 722 862 ;\r\nC -1 ; WX 333 ; N Idotaccent ; B -8 0 384 818 ;\r\nC -1 ; WX 600 ; N summation ; B 15 -10 585 706 ;\r\nC -1 ; WX 611 ; N Egrave ; B -1 0 634 876 ;\r\nC -1 ; WX 389 ; N racute ; B 45 0 431 664 ;\r\nC -1 ; WX 500 ; N omacron ; B 27 -11 495 583 ;\r\nC -1 ; WX 556 ; N Zacute ; B -6 0 606 876 ;\r\nC -1 ; WX 556 ; N Zcaron ; B -6 0 606 873 ;\r\nC -1 ; WX 549 ; N greaterequal ; B 26 0 523 658 ;\r\nC -1 ; WX 722 ; N Eth ; B -8 0 700 653 ;\r\nC -1 ; WX 667 ; N Ccedilla ; B 66 -217 689 666 ;\r\nC -1 ; WX 278 ; N lcommaaccent ; B 22 -217 279 683 ;\r\nC -1 ; WX 300 ; N tcaron ; B 37 -11 407 681 ;\r\nC -1 ; WX 444 ; N eogonek ; B 31 -169 412 441 ;\r\nC -1 ; WX 722 ; N Uogonek ; B 102 -184 765 653 ;\r\nC -1 ; WX 611 ; N Aacute ; B -51 0 564 876 ;\r\nC -1 ; WX 611 ; N Adieresis ; B -51 0 564 818 ;\r\nC -1 ; WX 444 ; N egrave ; B 31 -11 412 664 ;\r\nC -1 ; WX 389 ; N zacute ; B -2 -81 431 664 ;\r\nC -1 ; WX 278 ; N iogonek ; B 49 -169 264 654 ;\r\nC -1 ; WX 722 ; N Oacute ; B 60 -18 699 876 ;\r\nC -1 ; WX 500 ; N oacute ; B 27 -11 487 664 ;\r\nC -1 ; WX 500 ; N amacron ; B 17 -11 495 583 ;\r\nC -1 ; WX 389 ; N sacute ; B 16 -13 431 664 ;\r\nC -1 ; WX 278 ; N idieresis ; B 49 -11 352 606 ;\r\nC -1 ; WX 722 ; N Ocircumflex ; B 60 -18 699 873 ;\r\nC -1 ; WX 722 ; N Ugrave ; B 102 -18 765 876 ;\r\nC -1 ; WX 612 ; N Delta ; B 6 0 608 688 ;\r\nC -1 ; WX 500 ; N thorn ; B -75 -205 469 683 ;\r\nC -1 ; WX 300 ; N twosuperior ; B 33 271 324 676 ;\r\nC -1 ; WX 722 ; N Odieresis ; B 60 -18 699 818 ;\r\nC -1 ; WX 500 ; N mu ; B -30 -209 497 428 ;\r\nC -1 ; WX 278 ; N igrave ; B 49 -11 284 664 ;\r\nC -1 ; WX 500 ; N ohungarumlaut ; B 27 -11 590 664 ;\r\nC -1 ; WX 611 ; N Eogonek ; B -1 -169 634 653 ;\r\nC -1 ; WX 500 ; N dcroat ; B 15 -13 572 683 ;\r\nC -1 ; WX 750 ; N threequarters ; B 23 -10 736 676 ;\r\nC -1 ; WX 500 ; N Scedilla ; B 17 -217 508 667 ;\r\nC -1 ; WX 300 ; N lcaron ; B 41 -11 407 683 ;\r\nC -1 ; WX 667 ; N Kcommaaccent ; B 7 -217 722 653 ;\r\nC -1 ; WX 556 ; N Lacute ; B -8 0 559 876 ;\r\nC -1 ; WX 980 ; N trademark ; B 30 247 957 653 ;\r\nC -1 ; WX 444 ; N edotaccent ; B 31 -11 412 606 ;\r\nC -1 ; WX 333 ; N Igrave ; B -8 0 384 876 ;\r\nC -1 ; WX 333 ; N Imacron ; B -8 0 441 795 ;\r\nC -1 ; WX 611 ; N Lcaron ; B -8 0 586 653 ;\r\nC -1 ; WX 750 ; N onehalf ; B 34 -10 749 676 ;\r\nC -1 ; WX 549 ; N lessequal ; B 26 0 523 658 ;\r\nC -1 ; WX 500 ; N ocircumflex ; B 27 -11 468 661 ;\r\nC -1 ; WX 500 ; N ntilde ; B 14 -9 476 624 ;\r\nC -1 ; WX 722 ; N Uhungarumlaut ; B 102 -18 765 876 ;\r\nC -1 ; WX 611 ; N Eacute ; B -1 0 634 876 ;\r\nC -1 ; WX 444 ; N emacron ; B 31 -11 457 583 ;\r\nC -1 ; WX 500 ; N gbreve ; B 8 -206 487 650 ;\r\nC -1 ; WX 750 ; N onequarter ; B 33 -10 736 676 ;\r\nC -1 ; WX 500 ; N Scaron ; B 17 -18 520 873 ;\r\nC -1 ; WX 500 ; N Scommaaccent ; B 17 -217 508 667 ;\r\nC -1 ; WX 722 ; N Ohungarumlaut ; B 60 -18 699 876 ;\r\nC -1 ; WX 400 ; N degree ; B 101 390 387 676 ;\r\nC -1 ; WX 500 ; N ograve ; B 27 -11 468 664 ;\r\nC -1 ; WX 667 ; N Ccaron ; B 66 -18 689 873 ;\r\nC -1 ; WX 500 ; N ugrave ; B 42 -11 475 664 ;\r\nC -1 ; WX 453 ; N radical ; B 2 -60 452 768 ;\r\nC -1 ; WX 722 ; N Dcaron ; B -8 0 700 873 ;\r\nC -1 ; WX 389 ; N rcommaaccent ; B -3 -217 412 441 ;\r\nC -1 ; WX 667 ; N Ntilde ; B -20 -15 727 836 ;\r\nC -1 ; WX 500 ; N otilde ; B 27 -11 496 624 ;\r\nC -1 ; WX 611 ; N Rcommaaccent ; B -13 -187 588 653 ;\r\nC -1 ; WX 556 ; N Lcommaaccent ; B -8 -217 559 653 ;\r\nC -1 ; WX 611 ; N Atilde ; B -51 0 566 836 ;\r\nC -1 ; WX 611 ; N Aogonek ; B -51 -169 566 668 ;\r\nC -1 ; WX 611 ; N Aring ; B -51 0 564 883 ;\r\nC -1 ; WX 722 ; N Otilde ; B 60 -18 699 836 ;\r\nC -1 ; WX 389 ; N zdotaccent ; B -2 -81 380 606 ;\r\nC -1 ; WX 611 ; N Ecaron ; B -1 0 634 873 ;\r\nC -1 ; WX 333 ; N Iogonek ; B -8 -169 384 653 ;\r\nC -1 ; WX 444 ; N kcommaaccent ; B 14 -187 461 683 ;\r\nC -1 ; WX 675 ; N minus ; B 86 220 590 286 ;\r\nC -1 ; WX 333 ; N Icircumflex ; B -8 0 425 873 ;\r\nC -1 ; WX 500 ; N ncaron ; B 14 -9 510 661 ;\r\nC -1 ; WX 278 ; N tcommaaccent ; B 2 -217 296 546 ;\r\nC -1 ; WX 675 ; N logicalnot ; B 86 108 590 386 ;\r\nC -1 ; WX 500 ; N odieresis ; B 27 -11 489 606 ;\r\nC -1 ; WX 500 ; N udieresis ; B 42 -11 479 606 ;\r\nC -1 ; WX 549 ; N notequal ; B 12 -29 537 541 ;\r\nC -1 ; WX 500 ; N gcommaaccent ; B 8 -206 472 706 ;\r\nC -1 ; WX 500 ; N eth ; B 27 -11 482 683 ;\r\nC -1 ; WX 389 ; N zcaron ; B -2 -81 434 661 ;\r\nC -1 ; WX 500 ; N ncommaaccent ; B 14 -187 474 441 ;\r\nC -1 ; WX 300 ; N onesuperior ; B 43 271 284 676 ;\r\nC -1 ; WX 278 ; N imacron ; B 46 -11 311 583 ;\r\nC -1 ; WX 500 ; N Euro ; B 0 0 0 0 ;\r\nEndCharMetrics\r\nStartKernData\r\nStartKernPairs 2321\r\nKPX A C -30\r\nKPX A Cacute -30\r\nKPX A Ccaron -30\r\nKPX A Ccedilla -30\r\nKPX A G -35\r\nKPX A Gbreve -35\r\nKPX A Gcommaaccent -35\r\nKPX A O -40\r\nKPX A Oacute -40\r\nKPX A Ocircumflex -40\r\nKPX A Odieresis -40\r\nKPX A Ograve -40\r\nKPX A Ohungarumlaut -40\r\nKPX A Omacron -40\r\nKPX A Oslash -40\r\nKPX A Otilde -40\r\nKPX A Q -40\r\nKPX A T -37\r\nKPX A Tcaron -37\r\nKPX A Tcommaaccent -37\r\nKPX A U -50\r\nKPX A Uacute -50\r\nKPX A Ucircumflex -50\r\nKPX A Udieresis -50\r\nKPX A Ugrave -50\r\nKPX A Uhungarumlaut -50\r\nKPX A Umacron -50\r\nKPX A Uogonek -50\r\nKPX A Uring -50\r\nKPX A V -105\r\nKPX A W -95\r\nKPX A Y -55\r\nKPX A Yacute -55\r\nKPX A Ydieresis -55\r\nKPX A quoteright -37\r\nKPX A u -20\r\nKPX A uacute -20\r\nKPX A ucircumflex -20\r\nKPX A udieresis -20\r\nKPX A ugrave -20\r\nKPX A uhungarumlaut -20\r\nKPX A umacron -20\r\nKPX A uogonek -20\r\nKPX A uring -20\r\nKPX A v -55\r\nKPX A w -55\r\nKPX A y -55\r\nKPX A yacute -55\r\nKPX A ydieresis -55\r\nKPX Aacute C -30\r\nKPX Aacute Cacute -30\r\nKPX Aacute Ccaron -30\r\nKPX Aacute Ccedilla -30\r\nKPX Aacute G -35\r\nKPX Aacute Gbreve -35\r\nKPX Aacute Gcommaaccent -35\r\nKPX Aacute O -40\r\nKPX Aacute Oacute -40\r\nKPX Aacute Ocircumflex -40\r\nKPX Aacute Odieresis -40\r\nKPX Aacute Ograve -40\r\nKPX Aacute Ohungarumlaut -40\r\nKPX Aacute Omacron -40\r\nKPX Aacute Oslash -40\r\nKPX Aacute Otilde -40\r\nKPX Aacute Q -40\r\nKPX Aacute T -37\r\nKPX Aacute Tcaron -37\r\nKPX Aacute Tcommaaccent -37\r\nKPX Aacute U -50\r\nKPX Aacute Uacute -50\r\nKPX Aacute Ucircumflex -50\r\nKPX Aacute Udieresis -50\r\nKPX Aacute Ugrave -50\r\nKPX Aacute Uhungarumlaut -50\r\nKPX Aacute Umacron -50\r\nKPX Aacute Uogonek -50\r\nKPX Aacute Uring -50\r\nKPX Aacute V -105\r\nKPX Aacute W -95\r\nKPX Aacute Y -55\r\nKPX Aacute Yacute -55\r\nKPX Aacute Ydieresis -55\r\nKPX Aacute quoteright -37\r\nKPX Aacute u -20\r\nKPX Aacute uacute -20\r\nKPX Aacute ucircumflex -20\r\nKPX Aacute udieresis -20\r\nKPX Aacute ugrave -20\r\nKPX Aacute uhungarumlaut -20\r\nKPX Aacute umacron -20\r\nKPX Aacute uogonek -20\r\nKPX Aacute uring -20\r\nKPX Aacute v -55\r\nKPX Aacute w -55\r\nKPX Aacute y -55\r\nKPX Aacute yacute -55\r\nKPX Aacute ydieresis -55\r\nKPX Abreve C -30\r\nKPX Abreve Cacute -30\r\nKPX Abreve Ccaron -30\r\nKPX Abreve Ccedilla -30\r\nKPX Abreve G -35\r\nKPX Abreve Gbreve -35\r\nKPX Abreve Gcommaaccent -35\r\nKPX Abreve O -40\r\nKPX Abreve Oacute -40\r\nKPX Abreve Ocircumflex -40\r\nKPX Abreve Odieresis -40\r\nKPX Abreve Ograve -40\r\nKPX Abreve Ohungarumlaut -40\r\nKPX Abreve Omacron -40\r\nKPX Abreve Oslash -40\r\nKPX Abreve Otilde -40\r\nKPX Abreve Q -40\r\nKPX Abreve T -37\r\nKPX Abreve Tcaron -37\r\nKPX Abreve Tcommaaccent -37\r\nKPX Abreve U -50\r\nKPX Abreve Uacute -50\r\nKPX Abreve Ucircumflex -50\r\nKPX Abreve Udieresis -50\r\nKPX Abreve Ugrave -50\r\nKPX Abreve Uhungarumlaut -50\r\nKPX Abreve Umacron -50\r\nKPX Abreve Uogonek -50\r\nKPX Abreve Uring -50\r\nKPX Abreve V -105\r\nKPX Abreve W -95\r\nKPX Abreve Y -55\r\nKPX Abreve Yacute -55\r\nKPX Abreve Ydieresis -55\r\nKPX Abreve quoteright -37\r\nKPX Abreve u -20\r\nKPX Abreve uacute -20\r\nKPX Abreve ucircumflex -20\r\nKPX Abreve udieresis -20\r\nKPX Abreve ugrave -20\r\nKPX Abreve uhungarumlaut -20\r\nKPX Abreve umacron -20\r\nKPX Abreve uogonek -20\r\nKPX Abreve uring -20\r\nKPX Abreve v -55\r\nKPX Abreve w -55\r\nKPX Abreve y -55\r\nKPX Abreve yacute -55\r\nKPX Abreve ydieresis -55\r\nKPX Acircumflex C -30\r\nKPX Acircumflex Cacute -30\r\nKPX Acircumflex Ccaron -30\r\nKPX Acircumflex Ccedilla -30\r\nKPX Acircumflex G -35\r\nKPX Acircumflex Gbreve -35\r\nKPX Acircumflex Gcommaaccent -35\r\nKPX Acircumflex O -40\r\nKPX Acircumflex Oacute -40\r\nKPX Acircumflex Ocircumflex -40\r\nKPX Acircumflex Odieresis -40\r\nKPX Acircumflex Ograve -40\r\nKPX Acircumflex Ohungarumlaut -40\r\nKPX Acircumflex Omacron -40\r\nKPX Acircumflex Oslash -40\r\nKPX Acircumflex Otilde -40\r\nKPX Acircumflex Q -40\r\nKPX Acircumflex T -37\r\nKPX Acircumflex Tcaron -37\r\nKPX Acircumflex Tcommaaccent -37\r\nKPX Acircumflex U -50\r\nKPX Acircumflex Uacute -50\r\nKPX Acircumflex Ucircumflex -50\r\nKPX Acircumflex Udieresis -50\r\nKPX Acircumflex Ugrave -50\r\nKPX Acircumflex Uhungarumlaut -50\r\nKPX Acircumflex Umacron -50\r\nKPX Acircumflex Uogonek -50\r\nKPX Acircumflex Uring -50\r\nKPX Acircumflex V -105\r\nKPX Acircumflex W -95\r\nKPX Acircumflex Y -55\r\nKPX Acircumflex Yacute -55\r\nKPX Acircumflex Ydieresis -55\r\nKPX Acircumflex quoteright -37\r\nKPX Acircumflex u -20\r\nKPX Acircumflex uacute -20\r\nKPX Acircumflex ucircumflex -20\r\nKPX Acircumflex udieresis -20\r\nKPX Acircumflex ugrave -20\r\nKPX Acircumflex uhungarumlaut -20\r\nKPX Acircumflex umacron -20\r\nKPX Acircumflex uogonek -20\r\nKPX Acircumflex uring -20\r\nKPX Acircumflex v -55\r\nKPX Acircumflex w -55\r\nKPX Acircumflex y -55\r\nKPX Acircumflex yacute -55\r\nKPX Acircumflex ydieresis -55\r\nKPX Adieresis C -30\r\nKPX Adieresis Cacute -30\r\nKPX Adieresis Ccaron -30\r\nKPX Adieresis Ccedilla -30\r\nKPX Adieresis G -35\r\nKPX Adieresis Gbreve -35\r\nKPX Adieresis Gcommaaccent -35\r\nKPX Adieresis O -40\r\nKPX Adieresis Oacute -40\r\nKPX Adieresis Ocircumflex -40\r\nKPX Adieresis Odieresis -40\r\nKPX Adieresis Ograve -40\r\nKPX Adieresis Ohungarumlaut -40\r\nKPX Adieresis Omacron -40\r\nKPX Adieresis Oslash -40\r\nKPX Adieresis Otilde -40\r\nKPX Adieresis Q -40\r\nKPX Adieresis T -37\r\nKPX Adieresis Tcaron -37\r\nKPX Adieresis Tcommaaccent -37\r\nKPX Adieresis U -50\r\nKPX Adieresis Uacute -50\r\nKPX Adieresis Ucircumflex -50\r\nKPX Adieresis Udieresis -50\r\nKPX Adieresis Ugrave -50\r\nKPX Adieresis Uhungarumlaut -50\r\nKPX Adieresis Umacron -50\r\nKPX Adieresis Uogonek -50\r\nKPX Adieresis Uring -50\r\nKPX Adieresis V -105\r\nKPX Adieresis W -95\r\nKPX Adieresis Y -55\r\nKPX Adieresis Yacute -55\r\nKPX Adieresis Ydieresis -55\r\nKPX Adieresis quoteright -37\r\nKPX Adieresis u -20\r\nKPX Adieresis uacute -20\r\nKPX Adieresis ucircumflex -20\r\nKPX Adieresis udieresis -20\r\nKPX Adieresis ugrave -20\r\nKPX Adieresis uhungarumlaut -20\r\nKPX Adieresis umacron -20\r\nKPX Adieresis uogonek -20\r\nKPX Adieresis uring -20\r\nKPX Adieresis v -55\r\nKPX Adieresis w -55\r\nKPX Adieresis y -55\r\nKPX Adieresis yacute -55\r\nKPX Adieresis ydieresis -55\r\nKPX Agrave C -30\r\nKPX Agrave Cacute -30\r\nKPX Agrave Ccaron -30\r\nKPX Agrave Ccedilla -30\r\nKPX Agrave G -35\r\nKPX Agrave Gbreve -35\r\nKPX Agrave Gcommaaccent -35\r\nKPX Agrave O -40\r\nKPX Agrave Oacute -40\r\nKPX Agrave Ocircumflex -40\r\nKPX Agrave Odieresis -40\r\nKPX Agrave Ograve -40\r\nKPX Agrave Ohungarumlaut -40\r\nKPX Agrave Omacron -40\r\nKPX Agrave Oslash -40\r\nKPX Agrave Otilde -40\r\nKPX Agrave Q -40\r\nKPX Agrave T -37\r\nKPX Agrave Tcaron -37\r\nKPX Agrave Tcommaaccent -37\r\nKPX Agrave U -50\r\nKPX Agrave Uacute -50\r\nKPX Agrave Ucircumflex -50\r\nKPX Agrave Udieresis -50\r\nKPX Agrave Ugrave -50\r\nKPX Agrave Uhungarumlaut -50\r\nKPX Agrave Umacron -50\r\nKPX Agrave Uogonek -50\r\nKPX Agrave Uring -50\r\nKPX Agrave V -105\r\nKPX Agrave W -95\r\nKPX Agrave Y -55\r\nKPX Agrave Yacute -55\r\nKPX Agrave Ydieresis -55\r\nKPX Agrave quoteright -37\r\nKPX Agrave u -20\r\nKPX Agrave uacute -20\r\nKPX Agrave ucircumflex -20\r\nKPX Agrave udieresis -20\r\nKPX Agrave ugrave -20\r\nKPX Agrave uhungarumlaut -20\r\nKPX Agrave umacron -20\r\nKPX Agrave uogonek -20\r\nKPX Agrave uring -20\r\nKPX Agrave v -55\r\nKPX Agrave w -55\r\nKPX Agrave y -55\r\nKPX Agrave yacute -55\r\nKPX Agrave ydieresis -55\r\nKPX Amacron C -30\r\nKPX Amacron Cacute -30\r\nKPX Amacron Ccaron -30\r\nKPX Amacron Ccedilla -30\r\nKPX Amacron G -35\r\nKPX Amacron Gbreve -35\r\nKPX Amacron Gcommaaccent -35\r\nKPX Amacron O -40\r\nKPX Amacron Oacute -40\r\nKPX Amacron Ocircumflex -40\r\nKPX Amacron Odieresis -40\r\nKPX Amacron Ograve -40\r\nKPX Amacron Ohungarumlaut -40\r\nKPX Amacron Omacron -40\r\nKPX Amacron Oslash -40\r\nKPX Amacron Otilde -40\r\nKPX Amacron Q -40\r\nKPX Amacron T -37\r\nKPX Amacron Tcaron -37\r\nKPX Amacron Tcommaaccent -37\r\nKPX Amacron U -50\r\nKPX Amacron Uacute -50\r\nKPX Amacron Ucircumflex -50\r\nKPX Amacron Udieresis -50\r\nKPX Amacron Ugrave -50\r\nKPX Amacron Uhungarumlaut -50\r\nKPX Amacron Umacron -50\r\nKPX Amacron Uogonek -50\r\nKPX Amacron Uring -50\r\nKPX Amacron V -105\r\nKPX Amacron W -95\r\nKPX Amacron Y -55\r\nKPX Amacron Yacute -55\r\nKPX Amacron Ydieresis -55\r\nKPX Amacron quoteright -37\r\nKPX Amacron u -20\r\nKPX Amacron uacute -20\r\nKPX Amacron ucircumflex -20\r\nKPX Amacron udieresis -20\r\nKPX Amacron ugrave -20\r\nKPX Amacron uhungarumlaut -20\r\nKPX Amacron umacron -20\r\nKPX Amacron uogonek -20\r\nKPX Amacron uring -20\r\nKPX Amacron v -55\r\nKPX Amacron w -55\r\nKPX Amacron y -55\r\nKPX Amacron yacute -55\r\nKPX Amacron ydieresis -55\r\nKPX Aogonek C -30\r\nKPX Aogonek Cacute -30\r\nKPX Aogonek Ccaron -30\r\nKPX Aogonek Ccedilla -30\r\nKPX Aogonek G -35\r\nKPX Aogonek Gbreve -35\r\nKPX Aogonek Gcommaaccent -35\r\nKPX Aogonek O -40\r\nKPX Aogonek Oacute -40\r\nKPX Aogonek Ocircumflex -40\r\nKPX Aogonek Odieresis -40\r\nKPX Aogonek Ograve -40\r\nKPX Aogonek Ohungarumlaut -40\r\nKPX Aogonek Omacron -40\r\nKPX Aogonek Oslash -40\r\nKPX Aogonek Otilde -40\r\nKPX Aogonek Q -40\r\nKPX Aogonek T -37\r\nKPX Aogonek Tcaron -37\r\nKPX Aogonek Tcommaaccent -37\r\nKPX Aogonek U -50\r\nKPX Aogonek Uacute -50\r\nKPX Aogonek Ucircumflex -50\r\nKPX Aogonek Udieresis -50\r\nKPX Aogonek Ugrave -50\r\nKPX Aogonek Uhungarumlaut -50\r\nKPX Aogonek Umacron -50\r\nKPX Aogonek Uogonek -50\r\nKPX Aogonek Uring -50\r\nKPX Aogonek V -105\r\nKPX Aogonek W -95\r\nKPX Aogonek Y -55\r\nKPX Aogonek Yacute -55\r\nKPX Aogonek Ydieresis -55\r\nKPX Aogonek quoteright -37\r\nKPX Aogonek u -20\r\nKPX Aogonek uacute -20\r\nKPX Aogonek ucircumflex -20\r\nKPX Aogonek udieresis -20\r\nKPX Aogonek ugrave -20\r\nKPX Aogonek uhungarumlaut -20\r\nKPX Aogonek umacron -20\r\nKPX Aogonek uogonek -20\r\nKPX Aogonek uring -20\r\nKPX Aogonek v -55\r\nKPX Aogonek w -55\r\nKPX Aogonek y -55\r\nKPX Aogonek yacute -55\r\nKPX Aogonek ydieresis -55\r\nKPX Aring C -30\r\nKPX Aring Cacute -30\r\nKPX Aring Ccaron -30\r\nKPX Aring Ccedilla -30\r\nKPX Aring G -35\r\nKPX Aring Gbreve -35\r\nKPX Aring Gcommaaccent -35\r\nKPX Aring O -40\r\nKPX Aring Oacute -40\r\nKPX Aring Ocircumflex -40\r\nKPX Aring Odieresis -40\r\nKPX Aring Ograve -40\r\nKPX Aring Ohungarumlaut -40\r\nKPX Aring Omacron -40\r\nKPX Aring Oslash -40\r\nKPX Aring Otilde -40\r\nKPX Aring Q -40\r\nKPX Aring T -37\r\nKPX Aring Tcaron -37\r\nKPX Aring Tcommaaccent -37\r\nKPX Aring U -50\r\nKPX Aring Uacute -50\r\nKPX Aring Ucircumflex -50\r\nKPX Aring Udieresis -50\r\nKPX Aring Ugrave -50\r\nKPX Aring Uhungarumlaut -50\r\nKPX Aring Umacron -50\r\nKPX Aring Uogonek -50\r\nKPX Aring Uring -50\r\nKPX Aring V -105\r\nKPX Aring W -95\r\nKPX Aring Y -55\r\nKPX Aring Yacute -55\r\nKPX Aring Ydieresis -55\r\nKPX Aring quoteright -37\r\nKPX Aring u -20\r\nKPX Aring uacute -20\r\nKPX Aring ucircumflex -20\r\nKPX Aring udieresis -20\r\nKPX Aring ugrave -20\r\nKPX Aring uhungarumlaut -20\r\nKPX Aring umacron -20\r\nKPX Aring uogonek -20\r\nKPX Aring uring -20\r\nKPX Aring v -55\r\nKPX Aring w -55\r\nKPX Aring y -55\r\nKPX Aring yacute -55\r\nKPX Aring ydieresis -55\r\nKPX Atilde C -30\r\nKPX Atilde Cacute -30\r\nKPX Atilde Ccaron -30\r\nKPX Atilde Ccedilla -30\r\nKPX Atilde G -35\r\nKPX Atilde Gbreve -35\r\nKPX Atilde Gcommaaccent -35\r\nKPX Atilde O -40\r\nKPX Atilde Oacute -40\r\nKPX Atilde Ocircumflex -40\r\nKPX Atilde Odieresis -40\r\nKPX Atilde Ograve -40\r\nKPX Atilde Ohungarumlaut -40\r\nKPX Atilde Omacron -40\r\nKPX Atilde Oslash -40\r\nKPX Atilde Otilde -40\r\nKPX Atilde Q -40\r\nKPX Atilde T -37\r\nKPX Atilde Tcaron -37\r\nKPX Atilde Tcommaaccent -37\r\nKPX Atilde U -50\r\nKPX Atilde Uacute -50\r\nKPX Atilde Ucircumflex -50\r\nKPX Atilde Udieresis -50\r\nKPX Atilde Ugrave -50\r\nKPX Atilde Uhungarumlaut -50\r\nKPX Atilde Umacron -50\r\nKPX Atilde Uogonek -50\r\nKPX Atilde Uring -50\r\nKPX Atilde V -105\r\nKPX Atilde W -95\r\nKPX Atilde Y -55\r\nKPX Atilde Yacute -55\r\nKPX Atilde Ydieresis -55\r\nKPX Atilde quoteright -37\r\nKPX Atilde u -20\r\nKPX Atilde uacute -20\r\nKPX Atilde ucircumflex -20\r\nKPX Atilde udieresis -20\r\nKPX Atilde ugrave -20\r\nKPX Atilde uhungarumlaut -20\r\nKPX Atilde umacron -20\r\nKPX Atilde uogonek -20\r\nKPX Atilde uring -20\r\nKPX Atilde v -55\r\nKPX Atilde w -55\r\nKPX Atilde y -55\r\nKPX Atilde yacute -55\r\nKPX Atilde ydieresis -55\r\nKPX B A -25\r\nKPX B Aacute -25\r\nKPX B Abreve -25\r\nKPX B Acircumflex -25\r\nKPX B Adieresis -25\r\nKPX B Agrave -25\r\nKPX B Amacron -25\r\nKPX B Aogonek -25\r\nKPX B Aring -25\r\nKPX B Atilde -25\r\nKPX B U -10\r\nKPX B Uacute -10\r\nKPX B Ucircumflex -10\r\nKPX B Udieresis -10\r\nKPX B Ugrave -10\r\nKPX B Uhungarumlaut -10\r\nKPX B Umacron -10\r\nKPX B Uogonek -10\r\nKPX B Uring -10\r\nKPX D A -35\r\nKPX D Aacute -35\r\nKPX D Abreve -35\r\nKPX D Acircumflex -35\r\nKPX D Adieresis -35\r\nKPX D Agrave -35\r\nKPX D Amacron -35\r\nKPX D Aogonek -35\r\nKPX D Aring -35\r\nKPX D Atilde -35\r\nKPX D V -40\r\nKPX D W -40\r\nKPX D Y -40\r\nKPX D Yacute -40\r\nKPX D Ydieresis -40\r\nKPX Dcaron A -35\r\nKPX Dcaron Aacute -35\r\nKPX Dcaron Abreve -35\r\nKPX Dcaron Acircumflex -35\r\nKPX Dcaron Adieresis -35\r\nKPX Dcaron Agrave -35\r\nKPX Dcaron Amacron -35\r\nKPX Dcaron Aogonek -35\r\nKPX Dcaron Aring -35\r\nKPX Dcaron Atilde -35\r\nKPX Dcaron V -40\r\nKPX Dcaron W -40\r\nKPX Dcaron Y -40\r\nKPX Dcaron Yacute -40\r\nKPX Dcaron Ydieresis -40\r\nKPX Dcroat A -35\r\nKPX Dcroat Aacute -35\r\nKPX Dcroat Abreve -35\r\nKPX Dcroat Acircumflex -35\r\nKPX Dcroat Adieresis -35\r\nKPX Dcroat Agrave -35\r\nKPX Dcroat Amacron -35\r\nKPX Dcroat Aogonek -35\r\nKPX Dcroat Aring -35\r\nKPX Dcroat Atilde -35\r\nKPX Dcroat V -40\r\nKPX Dcroat W -40\r\nKPX Dcroat Y -40\r\nKPX Dcroat Yacute -40\r\nKPX Dcroat Ydieresis -40\r\nKPX F A -115\r\nKPX F Aacute -115\r\nKPX F Abreve -115\r\nKPX F Acircumflex -115\r\nKPX F Adieresis -115\r\nKPX F Agrave -115\r\nKPX F Amacron -115\r\nKPX F Aogonek -115\r\nKPX F Aring -115\r\nKPX F Atilde -115\r\nKPX F a -75\r\nKPX F aacute -75\r\nKPX F abreve -75\r\nKPX F acircumflex -75\r\nKPX F adieresis -75\r\nKPX F agrave -75\r\nKPX F amacron -75\r\nKPX F aogonek -75\r\nKPX F aring -75\r\nKPX F atilde -75\r\nKPX F comma -135\r\nKPX F e -75\r\nKPX F eacute -75\r\nKPX F ecaron -75\r\nKPX F ecircumflex -75\r\nKPX F edieresis -75\r\nKPX F edotaccent -75\r\nKPX F egrave -75\r\nKPX F emacron -75\r\nKPX F eogonek -75\r\nKPX F i -45\r\nKPX F iacute -45\r\nKPX F icircumflex -45\r\nKPX F idieresis -45\r\nKPX F igrave -45\r\nKPX F imacron -45\r\nKPX F iogonek -45\r\nKPX F o -105\r\nKPX F oacute -105\r\nKPX F ocircumflex -105\r\nKPX F odieresis -105\r\nKPX F ograve -105\r\nKPX F ohungarumlaut -105\r\nKPX F omacron -105\r\nKPX F oslash -105\r\nKPX F otilde -105\r\nKPX F period -135\r\nKPX F r -55\r\nKPX F racute -55\r\nKPX F rcaron -55\r\nKPX F rcommaaccent -55\r\nKPX J A -40\r\nKPX J Aacute -40\r\nKPX J Abreve -40\r\nKPX J Acircumflex -40\r\nKPX J Adieresis -40\r\nKPX J Agrave -40\r\nKPX J Amacron -40\r\nKPX J Aogonek -40\r\nKPX J Aring -40\r\nKPX J Atilde -40\r\nKPX J a -35\r\nKPX J aacute -35\r\nKPX J abreve -35\r\nKPX J acircumflex -35\r\nKPX J adieresis -35\r\nKPX J agrave -35\r\nKPX J amacron -35\r\nKPX J aogonek -35\r\nKPX J aring -35\r\nKPX J atilde -35\r\nKPX J comma -25\r\nKPX J e -25\r\nKPX J eacute -25\r\nKPX J ecaron -25\r\nKPX J ecircumflex -25\r\nKPX J edieresis -25\r\nKPX J edotaccent -25\r\nKPX J egrave -25\r\nKPX J emacron -25\r\nKPX J eogonek -25\r\nKPX J o -25\r\nKPX J oacute -25\r\nKPX J ocircumflex -25\r\nKPX J odieresis -25\r\nKPX J ograve -25\r\nKPX J ohungarumlaut -25\r\nKPX J omacron -25\r\nKPX J oslash -25\r\nKPX J otilde -25\r\nKPX J period -25\r\nKPX J u -35\r\nKPX J uacute -35\r\nKPX J ucircumflex -35\r\nKPX J udieresis -35\r\nKPX J ugrave -35\r\nKPX J uhungarumlaut -35\r\nKPX J umacron -35\r\nKPX J uogonek -35\r\nKPX J uring -35\r\nKPX K O -50\r\nKPX K Oacute -50\r\nKPX K Ocircumflex -50\r\nKPX K Odieresis -50\r\nKPX K Ograve -50\r\nKPX K Ohungarumlaut -50\r\nKPX K Omacron -50\r\nKPX K Oslash -50\r\nKPX K Otilde -50\r\nKPX K e -35\r\nKPX K eacute -35\r\nKPX K ecaron -35\r\nKPX K ecircumflex -35\r\nKPX K edieresis -35\r\nKPX K edotaccent -35\r\nKPX K egrave -35\r\nKPX K emacron -35\r\nKPX K eogonek -35\r\nKPX K o -40\r\nKPX K oacute -40\r\nKPX K ocircumflex -40\r\nKPX K odieresis -40\r\nKPX K ograve -40\r\nKPX K ohungarumlaut -40\r\nKPX K omacron -40\r\nKPX K oslash -40\r\nKPX K otilde -40\r\nKPX K u -40\r\nKPX K uacute -40\r\nKPX K ucircumflex -40\r\nKPX K udieresis -40\r\nKPX K ugrave -40\r\nKPX K uhungarumlaut -40\r\nKPX K umacron -40\r\nKPX K uogonek -40\r\nKPX K uring -40\r\nKPX K y -40\r\nKPX K yacute -40\r\nKPX K ydieresis -40\r\nKPX Kcommaaccent O -50\r\nKPX Kcommaaccent Oacute -50\r\nKPX Kcommaaccent Ocircumflex -50\r\nKPX Kcommaaccent Odieresis -50\r\nKPX Kcommaaccent Ograve -50\r\nKPX Kcommaaccent Ohungarumlaut -50\r\nKPX Kcommaaccent Omacron -50\r\nKPX Kcommaaccent Oslash -50\r\nKPX Kcommaaccent Otilde -50\r\nKPX Kcommaaccent e -35\r\nKPX Kcommaaccent eacute -35\r\nKPX Kcommaaccent ecaron -35\r\nKPX Kcommaaccent ecircumflex -35\r\nKPX Kcommaaccent edieresis -35\r\nKPX Kcommaaccent edotaccent -35\r\nKPX Kcommaaccent egrave -35\r\nKPX Kcommaaccent emacron -35\r\nKPX Kcommaaccent eogonek -35\r\nKPX Kcommaaccent o -40\r\nKPX Kcommaaccent oacute -40\r\nKPX Kcommaaccent ocircumflex -40\r\nKPX Kcommaaccent odieresis -40\r\nKPX Kcommaaccent ograve -40\r\nKPX Kcommaaccent ohungarumlaut -40\r\nKPX Kcommaaccent omacron -40\r\nKPX Kcommaaccent oslash -40\r\nKPX Kcommaaccent otilde -40\r\nKPX Kcommaaccent u -40\r\nKPX Kcommaaccent uacute -40\r\nKPX Kcommaaccent ucircumflex -40\r\nKPX Kcommaaccent udieresis -40\r\nKPX Kcommaaccent ugrave -40\r\nKPX Kcommaaccent uhungarumlaut -40\r\nKPX Kcommaaccent umacron -40\r\nKPX Kcommaaccent uogonek -40\r\nKPX Kcommaaccent uring -40\r\nKPX Kcommaaccent y -40\r\nKPX Kcommaaccent yacute -40\r\nKPX Kcommaaccent ydieresis -40\r\nKPX L T -20\r\nKPX L Tcaron -20\r\nKPX L Tcommaaccent -20\r\nKPX L V -55\r\nKPX L W -55\r\nKPX L Y -20\r\nKPX L Yacute -20\r\nKPX L Ydieresis -20\r\nKPX L quoteright -37\r\nKPX L y -30\r\nKPX L yacute -30\r\nKPX L ydieresis -30\r\nKPX Lacute T -20\r\nKPX Lacute Tcaron -20\r\nKPX Lacute Tcommaaccent -20\r\nKPX Lacute V -55\r\nKPX Lacute W -55\r\nKPX Lacute Y -20\r\nKPX Lacute Yacute -20\r\nKPX Lacute Ydieresis -20\r\nKPX Lacute quoteright -37\r\nKPX Lacute y -30\r\nKPX Lacute yacute -30\r\nKPX Lacute ydieresis -30\r\nKPX Lcommaaccent T -20\r\nKPX Lcommaaccent Tcaron -20\r\nKPX Lcommaaccent Tcommaaccent -20\r\nKPX Lcommaaccent V -55\r\nKPX Lcommaaccent W -55\r\nKPX Lcommaaccent Y -20\r\nKPX Lcommaaccent Yacute -20\r\nKPX Lcommaaccent Ydieresis -20\r\nKPX Lcommaaccent quoteright -37\r\nKPX Lcommaaccent y -30\r\nKPX Lcommaaccent yacute -30\r\nKPX Lcommaaccent ydieresis -30\r\nKPX Lslash T -20\r\nKPX Lslash Tcaron -20\r\nKPX Lslash Tcommaaccent -20\r\nKPX Lslash V -55\r\nKPX Lslash W -55\r\nKPX Lslash Y -20\r\nKPX Lslash Yacute -20\r\nKPX Lslash Ydieresis -20\r\nKPX Lslash quoteright -37\r\nKPX Lslash y -30\r\nKPX Lslash yacute -30\r\nKPX Lslash ydieresis -30\r\nKPX N A -27\r\nKPX N Aacute -27\r\nKPX N Abreve -27\r\nKPX N Acircumflex -27\r\nKPX N Adieresis -27\r\nKPX N Agrave -27\r\nKPX N Amacron -27\r\nKPX N Aogonek -27\r\nKPX N Aring -27\r\nKPX N Atilde -27\r\nKPX Nacute A -27\r\nKPX Nacute Aacute -27\r\nKPX Nacute Abreve -27\r\nKPX Nacute Acircumflex -27\r\nKPX Nacute Adieresis -27\r\nKPX Nacute Agrave -27\r\nKPX Nacute Amacron -27\r\nKPX Nacute Aogonek -27\r\nKPX Nacute Aring -27\r\nKPX Nacute Atilde -27\r\nKPX Ncaron A -27\r\nKPX Ncaron Aacute -27\r\nKPX Ncaron Abreve -27\r\nKPX Ncaron Acircumflex -27\r\nKPX Ncaron Adieresis -27\r\nKPX Ncaron Agrave -27\r\nKPX Ncaron Amacron -27\r\nKPX Ncaron Aogonek -27\r\nKPX Ncaron Aring -27\r\nKPX Ncaron Atilde -27\r\nKPX Ncommaaccent A -27\r\nKPX Ncommaaccent Aacute -27\r\nKPX Ncommaaccent Abreve -27\r\nKPX Ncommaaccent Acircumflex -27\r\nKPX Ncommaaccent Adieresis -27\r\nKPX Ncommaaccent Agrave -27\r\nKPX Ncommaaccent Amacron -27\r\nKPX Ncommaaccent Aogonek -27\r\nKPX Ncommaaccent Aring -27\r\nKPX Ncommaaccent Atilde -27\r\nKPX Ntilde A -27\r\nKPX Ntilde Aacute -27\r\nKPX Ntilde Abreve -27\r\nKPX Ntilde Acircumflex -27\r\nKPX Ntilde Adieresis -27\r\nKPX Ntilde Agrave -27\r\nKPX Ntilde Amacron -27\r\nKPX Ntilde Aogonek -27\r\nKPX Ntilde Aring -27\r\nKPX Ntilde Atilde -27\r\nKPX O A -55\r\nKPX O Aacute -55\r\nKPX O Abreve -55\r\nKPX O Acircumflex -55\r\nKPX O Adieresis -55\r\nKPX O Agrave -55\r\nKPX O Amacron -55\r\nKPX O Aogonek -55\r\nKPX O Aring -55\r\nKPX O Atilde -55\r\nKPX O T -40\r\nKPX O Tcaron -40\r\nKPX O Tcommaaccent -40\r\nKPX O V -50\r\nKPX O W -50\r\nKPX O X -40\r\nKPX O Y -50\r\nKPX O Yacute -50\r\nKPX O Ydieresis -50\r\nKPX Oacute A -55\r\nKPX Oacute Aacute -55\r\nKPX Oacute Abreve -55\r\nKPX Oacute Acircumflex -55\r\nKPX Oacute Adieresis -55\r\nKPX Oacute Agrave -55\r\nKPX Oacute Amacron -55\r\nKPX Oacute Aogonek -55\r\nKPX Oacute Aring -55\r\nKPX Oacute Atilde -55\r\nKPX Oacute T -40\r\nKPX Oacute Tcaron -40\r\nKPX Oacute Tcommaaccent -40\r\nKPX Oacute V -50\r\nKPX Oacute W -50\r\nKPX Oacute X -40\r\nKPX Oacute Y -50\r\nKPX Oacute Yacute -50\r\nKPX Oacute Ydieresis -50\r\nKPX Ocircumflex A -55\r\nKPX Ocircumflex Aacute -55\r\nKPX Ocircumflex Abreve -55\r\nKPX Ocircumflex Acircumflex -55\r\nKPX Ocircumflex Adieresis -55\r\nKPX Ocircumflex Agrave -55\r\nKPX Ocircumflex Amacron -55\r\nKPX Ocircumflex Aogonek -55\r\nKPX Ocircumflex Aring -55\r\nKPX Ocircumflex Atilde -55\r\nKPX Ocircumflex T -40\r\nKPX Ocircumflex Tcaron -40\r\nKPX Ocircumflex Tcommaaccent -40\r\nKPX Ocircumflex V -50\r\nKPX Ocircumflex W -50\r\nKPX Ocircumflex X -40\r\nKPX Ocircumflex Y -50\r\nKPX Ocircumflex Yacute -50\r\nKPX Ocircumflex Ydieresis -50\r\nKPX Odieresis A -55\r\nKPX Odieresis Aacute -55\r\nKPX Odieresis Abreve -55\r\nKPX Odieresis Acircumflex -55\r\nKPX Odieresis Adieresis -55\r\nKPX Odieresis Agrave -55\r\nKPX Odieresis Amacron -55\r\nKPX Odieresis Aogonek -55\r\nKPX Odieresis Aring -55\r\nKPX Odieresis Atilde -55\r\nKPX Odieresis T -40\r\nKPX Odieresis Tcaron -40\r\nKPX Odieresis Tcommaaccent -40\r\nKPX Odieresis V -50\r\nKPX Odieresis W -50\r\nKPX Odieresis X -40\r\nKPX Odieresis Y -50\r\nKPX Odieresis Yacute -50\r\nKPX Odieresis Ydieresis -50\r\nKPX Ograve A -55\r\nKPX Ograve Aacute -55\r\nKPX Ograve Abreve -55\r\nKPX Ograve Acircumflex -55\r\nKPX Ograve Adieresis -55\r\nKPX Ograve Agrave -55\r\nKPX Ograve Amacron -55\r\nKPX Ograve Aogonek -55\r\nKPX Ograve Aring -55\r\nKPX Ograve Atilde -55\r\nKPX Ograve T -40\r\nKPX Ograve Tcaron -40\r\nKPX Ograve Tcommaaccent -40\r\nKPX Ograve V -50\r\nKPX Ograve W -50\r\nKPX Ograve X -40\r\nKPX Ograve Y -50\r\nKPX Ograve Yacute -50\r\nKPX Ograve Ydieresis -50\r\nKPX Ohungarumlaut A -55\r\nKPX Ohungarumlaut Aacute -55\r\nKPX Ohungarumlaut Abreve -55\r\nKPX Ohungarumlaut Acircumflex -55\r\nKPX Ohungarumlaut Adieresis -55\r\nKPX Ohungarumlaut Agrave -55\r\nKPX Ohungarumlaut Amacron -55\r\nKPX Ohungarumlaut Aogonek -55\r\nKPX Ohungarumlaut Aring -55\r\nKPX Ohungarumlaut Atilde -55\r\nKPX Ohungarumlaut T -40\r\nKPX Ohungarumlaut Tcaron -40\r\nKPX Ohungarumlaut Tcommaaccent -40\r\nKPX Ohungarumlaut V -50\r\nKPX Ohungarumlaut W -50\r\nKPX Ohungarumlaut X -40\r\nKPX Ohungarumlaut Y -50\r\nKPX Ohungarumlaut Yacute -50\r\nKPX Ohungarumlaut Ydieresis -50\r\nKPX Omacron A -55\r\nKPX Omacron Aacute -55\r\nKPX Omacron Abreve -55\r\nKPX Omacron Acircumflex -55\r\nKPX Omacron Adieresis -55\r\nKPX Omacron Agrave -55\r\nKPX Omacron Amacron -55\r\nKPX Omacron Aogonek -55\r\nKPX Omacron Aring -55\r\nKPX Omacron Atilde -55\r\nKPX Omacron T -40\r\nKPX Omacron Tcaron -40\r\nKPX Omacron Tcommaaccent -40\r\nKPX Omacron V -50\r\nKPX Omacron W -50\r\nKPX Omacron X -40\r\nKPX Omacron Y -50\r\nKPX Omacron Yacute -50\r\nKPX Omacron Ydieresis -50\r\nKPX Oslash A -55\r\nKPX Oslash Aacute -55\r\nKPX Oslash Abreve -55\r\nKPX Oslash Acircumflex -55\r\nKPX Oslash Adieresis -55\r\nKPX Oslash Agrave -55\r\nKPX Oslash Amacron -55\r\nKPX Oslash Aogonek -55\r\nKPX Oslash Aring -55\r\nKPX Oslash Atilde -55\r\nKPX Oslash T -40\r\nKPX Oslash Tcaron -40\r\nKPX Oslash Tcommaaccent -40\r\nKPX Oslash V -50\r\nKPX Oslash W -50\r\nKPX Oslash X -40\r\nKPX Oslash Y -50\r\nKPX Oslash Yacute -50\r\nKPX Oslash Ydieresis -50\r\nKPX Otilde A -55\r\nKPX Otilde Aacute -55\r\nKPX Otilde Abreve -55\r\nKPX Otilde Acircumflex -55\r\nKPX Otilde Adieresis -55\r\nKPX Otilde Agrave -55\r\nKPX Otilde Amacron -55\r\nKPX Otilde Aogonek -55\r\nKPX Otilde Aring -55\r\nKPX Otilde Atilde -55\r\nKPX Otilde T -40\r\nKPX Otilde Tcaron -40\r\nKPX Otilde Tcommaaccent -40\r\nKPX Otilde V -50\r\nKPX Otilde W -50\r\nKPX Otilde X -40\r\nKPX Otilde Y -50\r\nKPX Otilde Yacute -50\r\nKPX Otilde Ydieresis -50\r\nKPX P A -90\r\nKPX P Aacute -90\r\nKPX P Abreve -90\r\nKPX P Acircumflex -90\r\nKPX P Adieresis -90\r\nKPX P Agrave -90\r\nKPX P Amacron -90\r\nKPX P Aogonek -90\r\nKPX P Aring -90\r\nKPX P Atilde -90\r\nKPX P a -80\r\nKPX P aacute -80\r\nKPX P abreve -80\r\nKPX P acircumflex -80\r\nKPX P adieresis -80\r\nKPX P agrave -80\r\nKPX P amacron -80\r\nKPX P aogonek -80\r\nKPX P aring -80\r\nKPX P atilde -80\r\nKPX P comma -135\r\nKPX P e -80\r\nKPX P eacute -80\r\nKPX P ecaron -80\r\nKPX P ecircumflex -80\r\nKPX P edieresis -80\r\nKPX P edotaccent -80\r\nKPX P egrave -80\r\nKPX P emacron -80\r\nKPX P eogonek -80\r\nKPX P o -80\r\nKPX P oacute -80\r\nKPX P ocircumflex -80\r\nKPX P odieresis -80\r\nKPX P ograve -80\r\nKPX P ohungarumlaut -80\r\nKPX P omacron -80\r\nKPX P oslash -80\r\nKPX P otilde -80\r\nKPX P period -135\r\nKPX Q U -10\r\nKPX Q Uacute -10\r\nKPX Q Ucircumflex -10\r\nKPX Q Udieresis -10\r\nKPX Q Ugrave -10\r\nKPX Q Uhungarumlaut -10\r\nKPX Q Umacron -10\r\nKPX Q Uogonek -10\r\nKPX Q Uring -10\r\nKPX R O -40\r\nKPX R Oacute -40\r\nKPX R Ocircumflex -40\r\nKPX R Odieresis -40\r\nKPX R Ograve -40\r\nKPX R Ohungarumlaut -40\r\nKPX R Omacron -40\r\nKPX R Oslash -40\r\nKPX R Otilde -40\r\nKPX R U -40\r\nKPX R Uacute -40\r\nKPX R Ucircumflex -40\r\nKPX R Udieresis -40\r\nKPX R Ugrave -40\r\nKPX R Uhungarumlaut -40\r\nKPX R Umacron -40\r\nKPX R Uogonek -40\r\nKPX R Uring -40\r\nKPX R V -18\r\nKPX R W -18\r\nKPX R Y -18\r\nKPX R Yacute -18\r\nKPX R Ydieresis -18\r\nKPX Racute O -40\r\nKPX Racute Oacute -40\r\nKPX Racute Ocircumflex -40\r\nKPX Racute Odieresis -40\r\nKPX Racute Ograve -40\r\nKPX Racute Ohungarumlaut -40\r\nKPX Racute Omacron -40\r\nKPX Racute Oslash -40\r\nKPX Racute Otilde -40\r\nKPX Racute U -40\r\nKPX Racute Uacute -40\r\nKPX Racute Ucircumflex -40\r\nKPX Racute Udieresis -40\r\nKPX Racute Ugrave -40\r\nKPX Racute Uhungarumlaut -40\r\nKPX Racute Umacron -40\r\nKPX Racute Uogonek -40\r\nKPX Racute Uring -40\r\nKPX Racute V -18\r\nKPX Racute W -18\r\nKPX Racute Y -18\r\nKPX Racute Yacute -18\r\nKPX Racute Ydieresis -18\r\nKPX Rcaron O -40\r\nKPX Rcaron Oacute -40\r\nKPX Rcaron Ocircumflex -40\r\nKPX Rcaron Odieresis -40\r\nKPX Rcaron Ograve -40\r\nKPX Rcaron Ohungarumlaut -40\r\nKPX Rcaron Omacron -40\r\nKPX Rcaron Oslash -40\r\nKPX Rcaron Otilde -40\r\nKPX Rcaron U -40\r\nKPX Rcaron Uacute -40\r\nKPX Rcaron Ucircumflex -40\r\nKPX Rcaron Udieresis -40\r\nKPX Rcaron Ugrave -40\r\nKPX Rcaron Uhungarumlaut -40\r\nKPX Rcaron Umacron -40\r\nKPX Rcaron Uogonek -40\r\nKPX Rcaron Uring -40\r\nKPX Rcaron V -18\r\nKPX Rcaron W -18\r\nKPX Rcaron Y -18\r\nKPX Rcaron Yacute -18\r\nKPX Rcaron Ydieresis -18\r\nKPX Rcommaaccent O -40\r\nKPX Rcommaaccent Oacute -40\r\nKPX Rcommaaccent Ocircumflex -40\r\nKPX Rcommaaccent Odieresis -40\r\nKPX Rcommaaccent Ograve -40\r\nKPX Rcommaaccent Ohungarumlaut -40\r\nKPX Rcommaaccent Omacron -40\r\nKPX Rcommaaccent Oslash -40\r\nKPX Rcommaaccent Otilde -40\r\nKPX Rcommaaccent U -40\r\nKPX Rcommaaccent Uacute -40\r\nKPX Rcommaaccent Ucircumflex -40\r\nKPX Rcommaaccent Udieresis -40\r\nKPX Rcommaaccent Ugrave -40\r\nKPX Rcommaaccent Uhungarumlaut -40\r\nKPX Rcommaaccent Umacron -40\r\nKPX Rcommaaccent Uogonek -40\r\nKPX Rcommaaccent Uring -40\r\nKPX Rcommaaccent V -18\r\nKPX Rcommaaccent W -18\r\nKPX Rcommaaccent Y -18\r\nKPX Rcommaaccent Yacute -18\r\nKPX Rcommaaccent Ydieresis -18\r\nKPX T A -50\r\nKPX T Aacute -50\r\nKPX T Abreve -50\r\nKPX T Acircumflex -50\r\nKPX T Adieresis -50\r\nKPX T Agrave -50\r\nKPX T Amacron -50\r\nKPX T Aogonek -50\r\nKPX T Aring -50\r\nKPX T Atilde -50\r\nKPX T O -18\r\nKPX T Oacute -18\r\nKPX T Ocircumflex -18\r\nKPX T Odieresis -18\r\nKPX T Ograve -18\r\nKPX T Ohungarumlaut -18\r\nKPX T Omacron -18\r\nKPX T Oslash -18\r\nKPX T Otilde -18\r\nKPX T a -92\r\nKPX T aacute -92\r\nKPX T abreve -92\r\nKPX T acircumflex -92\r\nKPX T adieresis -92\r\nKPX T agrave -92\r\nKPX T amacron -92\r\nKPX T aogonek -92\r\nKPX T aring -92\r\nKPX T atilde -92\r\nKPX T colon -55\r\nKPX T comma -74\r\nKPX T e -92\r\nKPX T eacute -92\r\nKPX T ecaron -92\r\nKPX T ecircumflex -52\r\nKPX T edieresis -52\r\nKPX T edotaccent -92\r\nKPX T egrave -52\r\nKPX T emacron -52\r\nKPX T eogonek -92\r\nKPX T hyphen -74\r\nKPX T i -55\r\nKPX T iacute -55\r\nKPX T iogonek -55\r\nKPX T o -92\r\nKPX T oacute -92\r\nKPX T ocircumflex -92\r\nKPX T odieresis -92\r\nKPX T ograve -92\r\nKPX T ohungarumlaut -92\r\nKPX T omacron -92\r\nKPX T oslash -92\r\nKPX T otilde -92\r\nKPX T period -74\r\nKPX T r -55\r\nKPX T racute -55\r\nKPX T rcaron -55\r\nKPX T rcommaaccent -55\r\nKPX T semicolon -65\r\nKPX T u -55\r\nKPX T uacute -55\r\nKPX T ucircumflex -55\r\nKPX T udieresis -55\r\nKPX T ugrave -55\r\nKPX T uhungarumlaut -55\r\nKPX T umacron -55\r\nKPX T uogonek -55\r\nKPX T uring -55\r\nKPX T w -74\r\nKPX T y -74\r\nKPX T yacute -74\r\nKPX T ydieresis -34\r\nKPX Tcaron A -50\r\nKPX Tcaron Aacute -50\r\nKPX Tcaron Abreve -50\r\nKPX Tcaron Acircumflex -50\r\nKPX Tcaron Adieresis -50\r\nKPX Tcaron Agrave -50\r\nKPX Tcaron Amacron -50\r\nKPX Tcaron Aogonek -50\r\nKPX Tcaron Aring -50\r\nKPX Tcaron Atilde -50\r\nKPX Tcaron O -18\r\nKPX Tcaron Oacute -18\r\nKPX Tcaron Ocircumflex -18\r\nKPX Tcaron Odieresis -18\r\nKPX Tcaron Ograve -18\r\nKPX Tcaron Ohungarumlaut -18\r\nKPX Tcaron Omacron -18\r\nKPX Tcaron Oslash -18\r\nKPX Tcaron Otilde -18\r\nKPX Tcaron a -92\r\nKPX Tcaron aacute -92\r\nKPX Tcaron abreve -92\r\nKPX Tcaron acircumflex -92\r\nKPX Tcaron adieresis -92\r\nKPX Tcaron agrave -92\r\nKPX Tcaron amacron -92\r\nKPX Tcaron aogonek -92\r\nKPX Tcaron aring -92\r\nKPX Tcaron atilde -92\r\nKPX Tcaron colon -55\r\nKPX Tcaron comma -74\r\nKPX Tcaron e -92\r\nKPX Tcaron eacute -92\r\nKPX Tcaron ecaron -92\r\nKPX Tcaron ecircumflex -52\r\nKPX Tcaron edieresis -52\r\nKPX Tcaron edotaccent -92\r\nKPX Tcaron egrave -52\r\nKPX Tcaron emacron -52\r\nKPX Tcaron eogonek -92\r\nKPX Tcaron hyphen -74\r\nKPX Tcaron i -55\r\nKPX Tcaron iacute -55\r\nKPX Tcaron iogonek -55\r\nKPX Tcaron o -92\r\nKPX Tcaron oacute -92\r\nKPX Tcaron ocircumflex -92\r\nKPX Tcaron odieresis -92\r\nKPX Tcaron ograve -92\r\nKPX Tcaron ohungarumlaut -92\r\nKPX Tcaron omacron -92\r\nKPX Tcaron oslash -92\r\nKPX Tcaron otilde -92\r\nKPX Tcaron period -74\r\nKPX Tcaron r -55\r\nKPX Tcaron racute -55\r\nKPX Tcaron rcaron -55\r\nKPX Tcaron rcommaaccent -55\r\nKPX Tcaron semicolon -65\r\nKPX Tcaron u -55\r\nKPX Tcaron uacute -55\r\nKPX Tcaron ucircumflex -55\r\nKPX Tcaron udieresis -55\r\nKPX Tcaron ugrave -55\r\nKPX Tcaron uhungarumlaut -55\r\nKPX Tcaron umacron -55\r\nKPX Tcaron uogonek -55\r\nKPX Tcaron uring -55\r\nKPX Tcaron w -74\r\nKPX Tcaron y -74\r\nKPX Tcaron yacute -74\r\nKPX Tcaron ydieresis -34\r\nKPX Tcommaaccent A -50\r\nKPX Tcommaaccent Aacute -50\r\nKPX Tcommaaccent Abreve -50\r\nKPX Tcommaaccent Acircumflex -50\r\nKPX Tcommaaccent Adieresis -50\r\nKPX Tcommaaccent Agrave -50\r\nKPX Tcommaaccent Amacron -50\r\nKPX Tcommaaccent Aogonek -50\r\nKPX Tcommaaccent Aring -50\r\nKPX Tcommaaccent Atilde -50\r\nKPX Tcommaaccent O -18\r\nKPX Tcommaaccent Oacute -18\r\nKPX Tcommaaccent Ocircumflex -18\r\nKPX Tcommaaccent Odieresis -18\r\nKPX Tcommaaccent Ograve -18\r\nKPX Tcommaaccent Ohungarumlaut -18\r\nKPX Tcommaaccent Omacron -18\r\nKPX Tcommaaccent Oslash -18\r\nKPX Tcommaaccent Otilde -18\r\nKPX Tcommaaccent a -92\r\nKPX Tcommaaccent aacute -92\r\nKPX Tcommaaccent abreve -92\r\nKPX Tcommaaccent acircumflex -92\r\nKPX Tcommaaccent adieresis -92\r\nKPX Tcommaaccent agrave -92\r\nKPX Tcommaaccent amacron -92\r\nKPX Tcommaaccent aogonek -92\r\nKPX Tcommaaccent aring -92\r\nKPX Tcommaaccent atilde -92\r\nKPX Tcommaaccent colon -55\r\nKPX Tcommaaccent comma -74\r\nKPX Tcommaaccent e -92\r\nKPX Tcommaaccent eacute -92\r\nKPX Tcommaaccent ecaron -92\r\nKPX Tcommaaccent ecircumflex -52\r\nKPX Tcommaaccent edieresis -52\r\nKPX Tcommaaccent edotaccent -92\r\nKPX Tcommaaccent egrave -52\r\nKPX Tcommaaccent emacron -52\r\nKPX Tcommaaccent eogonek -92\r\nKPX Tcommaaccent hyphen -74\r\nKPX Tcommaaccent i -55\r\nKPX Tcommaaccent iacute -55\r\nKPX Tcommaaccent iogonek -55\r\nKPX Tcommaaccent o -92\r\nKPX Tcommaaccent oacute -92\r\nKPX Tcommaaccent ocircumflex -92\r\nKPX Tcommaaccent odieresis -92\r\nKPX Tcommaaccent ograve -92\r\nKPX Tcommaaccent ohungarumlaut -92\r\nKPX Tcommaaccent omacron -92\r\nKPX Tcommaaccent oslash -92\r\nKPX Tcommaaccent otilde -92\r\nKPX Tcommaaccent period -74\r\nKPX Tcommaaccent r -55\r\nKPX Tcommaaccent racute -55\r\nKPX Tcommaaccent rcaron -55\r\nKPX Tcommaaccent rcommaaccent -55\r\nKPX Tcommaaccent semicolon -65\r\nKPX Tcommaaccent u -55\r\nKPX Tcommaaccent uacute -55\r\nKPX Tcommaaccent ucircumflex -55\r\nKPX Tcommaaccent udieresis -55\r\nKPX Tcommaaccent ugrave -55\r\nKPX Tcommaaccent uhungarumlaut -55\r\nKPX Tcommaaccent umacron -55\r\nKPX Tcommaaccent uogonek -55\r\nKPX Tcommaaccent uring -55\r\nKPX Tcommaaccent w -74\r\nKPX Tcommaaccent y -74\r\nKPX Tcommaaccent yacute -74\r\nKPX Tcommaaccent ydieresis -34\r\nKPX U A -40\r\nKPX U Aacute -40\r\nKPX U Abreve -40\r\nKPX U Acircumflex -40\r\nKPX U Adieresis -40\r\nKPX U Agrave -40\r\nKPX U Amacron -40\r\nKPX U Aogonek -40\r\nKPX U Aring -40\r\nKPX U Atilde -40\r\nKPX U comma -25\r\nKPX U period -25\r\nKPX Uacute A -40\r\nKPX Uacute Aacute -40\r\nKPX Uacute Abreve -40\r\nKPX Uacute Acircumflex -40\r\nKPX Uacute Adieresis -40\r\nKPX Uacute Agrave -40\r\nKPX Uacute Amacron -40\r\nKPX Uacute Aogonek -40\r\nKPX Uacute Aring -40\r\nKPX Uacute Atilde -40\r\nKPX Uacute comma -25\r\nKPX Uacute period -25\r\nKPX Ucircumflex A -40\r\nKPX Ucircumflex Aacute -40\r\nKPX Ucircumflex Abreve -40\r\nKPX Ucircumflex Acircumflex -40\r\nKPX Ucircumflex Adieresis -40\r\nKPX Ucircumflex Agrave -40\r\nKPX Ucircumflex Amacron -40\r\nKPX Ucircumflex Aogonek -40\r\nKPX Ucircumflex Aring -40\r\nKPX Ucircumflex Atilde -40\r\nKPX Ucircumflex comma -25\r\nKPX Ucircumflex period -25\r\nKPX Udieresis A -40\r\nKPX Udieresis Aacute -40\r\nKPX Udieresis Abreve -40\r\nKPX Udieresis Acircumflex -40\r\nKPX Udieresis Adieresis -40\r\nKPX Udieresis Agrave -40\r\nKPX Udieresis Amacron -40\r\nKPX Udieresis Aogonek -40\r\nKPX Udieresis Aring -40\r\nKPX Udieresis Atilde -40\r\nKPX Udieresis comma -25\r\nKPX Udieresis period -25\r\nKPX Ugrave A -40\r\nKPX Ugrave Aacute -40\r\nKPX Ugrave Abreve -40\r\nKPX Ugrave Acircumflex -40\r\nKPX Ugrave Adieresis -40\r\nKPX Ugrave Agrave -40\r\nKPX Ugrave Amacron -40\r\nKPX Ugrave Aogonek -40\r\nKPX Ugrave Aring -40\r\nKPX Ugrave Atilde -40\r\nKPX Ugrave comma -25\r\nKPX Ugrave period -25\r\nKPX Uhungarumlaut A -40\r\nKPX Uhungarumlaut Aacute -40\r\nKPX Uhungarumlaut Abreve -40\r\nKPX Uhungarumlaut Acircumflex -40\r\nKPX Uhungarumlaut Adieresis -40\r\nKPX Uhungarumlaut Agrave -40\r\nKPX Uhungarumlaut Amacron -40\r\nKPX Uhungarumlaut Aogonek -40\r\nKPX Uhungarumlaut Aring -40\r\nKPX Uhungarumlaut Atilde -40\r\nKPX Uhungarumlaut comma -25\r\nKPX Uhungarumlaut period -25\r\nKPX Umacron A -40\r\nKPX Umacron Aacute -40\r\nKPX Umacron Abreve -40\r\nKPX Umacron Acircumflex -40\r\nKPX Umacron Adieresis -40\r\nKPX Umacron Agrave -40\r\nKPX Umacron Amacron -40\r\nKPX Umacron Aogonek -40\r\nKPX Umacron Aring -40\r\nKPX Umacron Atilde -40\r\nKPX Umacron comma -25\r\nKPX Umacron period -25\r\nKPX Uogonek A -40\r\nKPX Uogonek Aacute -40\r\nKPX Uogonek Abreve -40\r\nKPX Uogonek Acircumflex -40\r\nKPX Uogonek Adieresis -40\r\nKPX Uogonek Agrave -40\r\nKPX Uogonek Amacron -40\r\nKPX Uogonek Aogonek -40\r\nKPX Uogonek Aring -40\r\nKPX Uogonek Atilde -40\r\nKPX Uogonek comma -25\r\nKPX Uogonek period -25\r\nKPX Uring A -40\r\nKPX Uring Aacute -40\r\nKPX Uring Abreve -40\r\nKPX Uring Acircumflex -40\r\nKPX Uring Adieresis -40\r\nKPX Uring Agrave -40\r\nKPX Uring Amacron -40\r\nKPX Uring Aogonek -40\r\nKPX Uring Aring -40\r\nKPX Uring Atilde -40\r\nKPX Uring comma -25\r\nKPX Uring period -25\r\nKPX V A -60\r\nKPX V Aacute -60\r\nKPX V Abreve -60\r\nKPX V Acircumflex -60\r\nKPX V Adieresis -60\r\nKPX V Agrave -60\r\nKPX V Amacron -60\r\nKPX V Aogonek -60\r\nKPX V Aring -60\r\nKPX V Atilde -60\r\nKPX V O -30\r\nKPX V Oacute -30\r\nKPX V Ocircumflex -30\r\nKPX V Odieresis -30\r\nKPX V Ograve -30\r\nKPX V Ohungarumlaut -30\r\nKPX V Omacron -30\r\nKPX V Oslash -30\r\nKPX V Otilde -30\r\nKPX V a -111\r\nKPX V aacute -111\r\nKPX V abreve -111\r\nKPX V acircumflex -111\r\nKPX V adieresis -111\r\nKPX V agrave -111\r\nKPX V amacron -111\r\nKPX V aogonek -111\r\nKPX V aring -111\r\nKPX V atilde -111\r\nKPX V colon -65\r\nKPX V comma -129\r\nKPX V e -111\r\nKPX V eacute -111\r\nKPX V ecaron -111\r\nKPX V ecircumflex -111\r\nKPX V edieresis -71\r\nKPX V edotaccent -111\r\nKPX V egrave -71\r\nKPX V emacron -71\r\nKPX V eogonek -111\r\nKPX V hyphen -55\r\nKPX V i -74\r\nKPX V iacute -74\r\nKPX V icircumflex -34\r\nKPX V idieresis -34\r\nKPX V igrave -34\r\nKPX V imacron -34\r\nKPX V iogonek -74\r\nKPX V o -111\r\nKPX V oacute -111\r\nKPX V ocircumflex -111\r\nKPX V odieresis -111\r\nKPX V ograve -111\r\nKPX V ohungarumlaut -111\r\nKPX V omacron -111\r\nKPX V oslash -111\r\nKPX V otilde -111\r\nKPX V period -129\r\nKPX V semicolon -74\r\nKPX V u -74\r\nKPX V uacute -74\r\nKPX V ucircumflex -74\r\nKPX V udieresis -74\r\nKPX V ugrave -74\r\nKPX V uhungarumlaut -74\r\nKPX V umacron -74\r\nKPX V uogonek -74\r\nKPX V uring -74\r\nKPX W A -60\r\nKPX W Aacute -60\r\nKPX W Abreve -60\r\nKPX W Acircumflex -60\r\nKPX W Adieresis -60\r\nKPX W Agrave -60\r\nKPX W Amacron -60\r\nKPX W Aogonek -60\r\nKPX W Aring -60\r\nKPX W Atilde -60\r\nKPX W O -25\r\nKPX W Oacute -25\r\nKPX W Ocircumflex -25\r\nKPX W Odieresis -25\r\nKPX W Ograve -25\r\nKPX W Ohungarumlaut -25\r\nKPX W Omacron -25\r\nKPX W Oslash -25\r\nKPX W Otilde -25\r\nKPX W a -92\r\nKPX W aacute -92\r\nKPX W abreve -92\r\nKPX W acircumflex -92\r\nKPX W adieresis -92\r\nKPX W agrave -92\r\nKPX W amacron -92\r\nKPX W aogonek -92\r\nKPX W aring -92\r\nKPX W atilde -92\r\nKPX W colon -65\r\nKPX W comma -92\r\nKPX W e -92\r\nKPX W eacute -92\r\nKPX W ecaron -92\r\nKPX W ecircumflex -92\r\nKPX W edieresis -52\r\nKPX W edotaccent -92\r\nKPX W egrave -52\r\nKPX W emacron -52\r\nKPX W eogonek -92\r\nKPX W hyphen -37\r\nKPX W i -55\r\nKPX W iacute -55\r\nKPX W iogonek -55\r\nKPX W o -92\r\nKPX W oacute -92\r\nKPX W ocircumflex -92\r\nKPX W odieresis -92\r\nKPX W ograve -92\r\nKPX W ohungarumlaut -92\r\nKPX W omacron -92\r\nKPX W oslash -92\r\nKPX W otilde -92\r\nKPX W period -92\r\nKPX W semicolon -65\r\nKPX W u -55\r\nKPX W uacute -55\r\nKPX W ucircumflex -55\r\nKPX W udieresis -55\r\nKPX W ugrave -55\r\nKPX W uhungarumlaut -55\r\nKPX W umacron -55\r\nKPX W uogonek -55\r\nKPX W uring -55\r\nKPX W y -70\r\nKPX W yacute -70\r\nKPX W ydieresis -70\r\nKPX Y A -50\r\nKPX Y Aacute -50\r\nKPX Y Abreve -50\r\nKPX Y Acircumflex -50\r\nKPX Y Adieresis -50\r\nKPX Y Agrave -50\r\nKPX Y Amacron -50\r\nKPX Y Aogonek -50\r\nKPX Y Aring -50\r\nKPX Y Atilde -50\r\nKPX Y O -15\r\nKPX Y Oacute -15\r\nKPX Y Ocircumflex -15\r\nKPX Y Odieresis -15\r\nKPX Y Ograve -15\r\nKPX Y Ohungarumlaut -15\r\nKPX Y Omacron -15\r\nKPX Y Oslash -15\r\nKPX Y Otilde -15\r\nKPX Y a -92\r\nKPX Y aacute -92\r\nKPX Y abreve -92\r\nKPX Y acircumflex -92\r\nKPX Y adieresis -92\r\nKPX Y agrave -92\r\nKPX Y amacron -92\r\nKPX Y aogonek -92\r\nKPX Y aring -92\r\nKPX Y atilde -92\r\nKPX Y colon -65\r\nKPX Y comma -92\r\nKPX Y e -92\r\nKPX Y eacute -92\r\nKPX Y ecaron -92\r\nKPX Y ecircumflex -92\r\nKPX Y edieresis -52\r\nKPX Y edotaccent -92\r\nKPX Y egrave -52\r\nKPX Y emacron -52\r\nKPX Y eogonek -92\r\nKPX Y hyphen -74\r\nKPX Y i -74\r\nKPX Y iacute -74\r\nKPX Y icircumflex -34\r\nKPX Y idieresis -34\r\nKPX Y igrave -34\r\nKPX Y imacron -34\r\nKPX Y iogonek -74\r\nKPX Y o -92\r\nKPX Y oacute -92\r\nKPX Y ocircumflex -92\r\nKPX Y odieresis -92\r\nKPX Y ograve -92\r\nKPX Y ohungarumlaut -92\r\nKPX Y omacron -92\r\nKPX Y oslash -92\r\nKPX Y otilde -92\r\nKPX Y period -92\r\nKPX Y semicolon -65\r\nKPX Y u -92\r\nKPX Y uacute -92\r\nKPX Y ucircumflex -92\r\nKPX Y udieresis -92\r\nKPX Y ugrave -92\r\nKPX Y uhungarumlaut -92\r\nKPX Y umacron -92\r\nKPX Y uogonek -92\r\nKPX Y uring -92\r\nKPX Yacute A -50\r\nKPX Yacute Aacute -50\r\nKPX Yacute Abreve -50\r\nKPX Yacute Acircumflex -50\r\nKPX Yacute Adieresis -50\r\nKPX Yacute Agrave -50\r\nKPX Yacute Amacron -50\r\nKPX Yacute Aogonek -50\r\nKPX Yacute Aring -50\r\nKPX Yacute Atilde -50\r\nKPX Yacute O -15\r\nKPX Yacute Oacute -15\r\nKPX Yacute Ocircumflex -15\r\nKPX Yacute Odieresis -15\r\nKPX Yacute Ograve -15\r\nKPX Yacute Ohungarumlaut -15\r\nKPX Yacute Omacron -15\r\nKPX Yacute Oslash -15\r\nKPX Yacute Otilde -15\r\nKPX Yacute a -92\r\nKPX Yacute aacute -92\r\nKPX Yacute abreve -92\r\nKPX Yacute acircumflex -92\r\nKPX Yacute adieresis -92\r\nKPX Yacute agrave -92\r\nKPX Yacute amacron -92\r\nKPX Yacute aogonek -92\r\nKPX Yacute aring -92\r\nKPX Yacute atilde -92\r\nKPX Yacute colon -65\r\nKPX Yacute comma -92\r\nKPX Yacute e -92\r\nKPX Yacute eacute -92\r\nKPX Yacute ecaron -92\r\nKPX Yacute ecircumflex -92\r\nKPX Yacute edieresis -52\r\nKPX Yacute edotaccent -92\r\nKPX Yacute egrave -52\r\nKPX Yacute emacron -52\r\nKPX Yacute eogonek -92\r\nKPX Yacute hyphen -74\r\nKPX Yacute i -74\r\nKPX Yacute iacute -74\r\nKPX Yacute icircumflex -34\r\nKPX Yacute idieresis -34\r\nKPX Yacute igrave -34\r\nKPX Yacute imacron -34\r\nKPX Yacute iogonek -74\r\nKPX Yacute o -92\r\nKPX Yacute oacute -92\r\nKPX Yacute ocircumflex -92\r\nKPX Yacute odieresis -92\r\nKPX Yacute ograve -92\r\nKPX Yacute ohungarumlaut -92\r\nKPX Yacute omacron -92\r\nKPX Yacute oslash -92\r\nKPX Yacute otilde -92\r\nKPX Yacute period -92\r\nKPX Yacute semicolon -65\r\nKPX Yacute u -92\r\nKPX Yacute uacute -92\r\nKPX Yacute ucircumflex -92\r\nKPX Yacute udieresis -92\r\nKPX Yacute ugrave -92\r\nKPX Yacute uhungarumlaut -92\r\nKPX Yacute umacron -92\r\nKPX Yacute uogonek -92\r\nKPX Yacute uring -92\r\nKPX Ydieresis A -50\r\nKPX Ydieresis Aacute -50\r\nKPX Ydieresis Abreve -50\r\nKPX Ydieresis Acircumflex -50\r\nKPX Ydieresis Adieresis -50\r\nKPX Ydieresis Agrave -50\r\nKPX Ydieresis Amacron -50\r\nKPX Ydieresis Aogonek -50\r\nKPX Ydieresis Aring -50\r\nKPX Ydieresis Atilde -50\r\nKPX Ydieresis O -15\r\nKPX Ydieresis Oacute -15\r\nKPX Ydieresis Ocircumflex -15\r\nKPX Ydieresis Odieresis -15\r\nKPX Ydieresis Ograve -15\r\nKPX Ydieresis Ohungarumlaut -15\r\nKPX Ydieresis Omacron -15\r\nKPX Ydieresis Oslash -15\r\nKPX Ydieresis Otilde -15\r\nKPX Ydieresis a -92\r\nKPX Ydieresis aacute -92\r\nKPX Ydieresis abreve -92\r\nKPX Ydieresis acircumflex -92\r\nKPX Ydieresis adieresis -92\r\nKPX Ydieresis agrave -92\r\nKPX Ydieresis amacron -92\r\nKPX Ydieresis aogonek -92\r\nKPX Ydieresis aring -92\r\nKPX Ydieresis atilde -92\r\nKPX Ydieresis colon -65\r\nKPX Ydieresis comma -92\r\nKPX Ydieresis e -92\r\nKPX Ydieresis eacute -92\r\nKPX Ydieresis ecaron -92\r\nKPX Ydieresis ecircumflex -92\r\nKPX Ydieresis edieresis -52\r\nKPX Ydieresis edotaccent -92\r\nKPX Ydieresis egrave -52\r\nKPX Ydieresis emacron -52\r\nKPX Ydieresis eogonek -92\r\nKPX Ydieresis hyphen -74\r\nKPX Ydieresis i -74\r\nKPX Ydieresis iacute -74\r\nKPX Ydieresis icircumflex -34\r\nKPX Ydieresis idieresis -34\r\nKPX Ydieresis igrave -34\r\nKPX Ydieresis imacron -34\r\nKPX Ydieresis iogonek -74\r\nKPX Ydieresis o -92\r\nKPX Ydieresis oacute -92\r\nKPX Ydieresis ocircumflex -92\r\nKPX Ydieresis odieresis -92\r\nKPX Ydieresis ograve -92\r\nKPX Ydieresis ohungarumlaut -92\r\nKPX Ydieresis omacron -92\r\nKPX Ydieresis oslash -92\r\nKPX Ydieresis otilde -92\r\nKPX Ydieresis period -92\r\nKPX Ydieresis semicolon -65\r\nKPX Ydieresis u -92\r\nKPX Ydieresis uacute -92\r\nKPX Ydieresis ucircumflex -92\r\nKPX Ydieresis udieresis -92\r\nKPX Ydieresis ugrave -92\r\nKPX Ydieresis uhungarumlaut -92\r\nKPX Ydieresis umacron -92\r\nKPX Ydieresis uogonek -92\r\nKPX Ydieresis uring -92\r\nKPX a g -10\r\nKPX a gbreve -10\r\nKPX a gcommaaccent -10\r\nKPX aacute g -10\r\nKPX aacute gbreve -10\r\nKPX aacute gcommaaccent -10\r\nKPX abreve g -10\r\nKPX abreve gbreve -10\r\nKPX abreve gcommaaccent -10\r\nKPX acircumflex g -10\r\nKPX acircumflex gbreve -10\r\nKPX acircumflex gcommaaccent -10\r\nKPX adieresis g -10\r\nKPX adieresis gbreve -10\r\nKPX adieresis gcommaaccent -10\r\nKPX agrave g -10\r\nKPX agrave gbreve -10\r\nKPX agrave gcommaaccent -10\r\nKPX amacron g -10\r\nKPX amacron gbreve -10\r\nKPX amacron gcommaaccent -10\r\nKPX aogonek g -10\r\nKPX aogonek gbreve -10\r\nKPX aogonek gcommaaccent -10\r\nKPX aring g -10\r\nKPX aring gbreve -10\r\nKPX aring gcommaaccent -10\r\nKPX atilde g -10\r\nKPX atilde gbreve -10\r\nKPX atilde gcommaaccent -10\r\nKPX b period -40\r\nKPX b u -20\r\nKPX b uacute -20\r\nKPX b ucircumflex -20\r\nKPX b udieresis -20\r\nKPX b ugrave -20\r\nKPX b uhungarumlaut -20\r\nKPX b umacron -20\r\nKPX b uogonek -20\r\nKPX b uring -20\r\nKPX c h -15\r\nKPX c k -20\r\nKPX c kcommaaccent -20\r\nKPX cacute h -15\r\nKPX cacute k -20\r\nKPX cacute kcommaaccent -20\r\nKPX ccaron h -15\r\nKPX ccaron k -20\r\nKPX ccaron kcommaaccent -20\r\nKPX ccedilla h -15\r\nKPX ccedilla k -20\r\nKPX ccedilla kcommaaccent -20\r\nKPX comma quotedblright -140\r\nKPX comma quoteright -140\r\nKPX e comma -10\r\nKPX e g -40\r\nKPX e gbreve -40\r\nKPX e gcommaaccent -40\r\nKPX e period -15\r\nKPX e v -15\r\nKPX e w -15\r\nKPX e x -20\r\nKPX e y -30\r\nKPX e yacute -30\r\nKPX e ydieresis -30\r\nKPX eacute comma -10\r\nKPX eacute g -40\r\nKPX eacute gbreve -40\r\nKPX eacute gcommaaccent -40\r\nKPX eacute period -15\r\nKPX eacute v -15\r\nKPX eacute w -15\r\nKPX eacute x -20\r\nKPX eacute y -30\r\nKPX eacute yacute -30\r\nKPX eacute ydieresis -30\r\nKPX ecaron comma -10\r\nKPX ecaron g -40\r\nKPX ecaron gbreve -40\r\nKPX ecaron gcommaaccent -40\r\nKPX ecaron period -15\r\nKPX ecaron v -15\r\nKPX ecaron w -15\r\nKPX ecaron x -20\r\nKPX ecaron y -30\r\nKPX ecaron yacute -30\r\nKPX ecaron ydieresis -30\r\nKPX ecircumflex comma -10\r\nKPX ecircumflex g -40\r\nKPX ecircumflex gbreve -40\r\nKPX ecircumflex gcommaaccent -40\r\nKPX ecircumflex period -15\r\nKPX ecircumflex v -15\r\nKPX ecircumflex w -15\r\nKPX ecircumflex x -20\r\nKPX ecircumflex y -30\r\nKPX ecircumflex yacute -30\r\nKPX ecircumflex ydieresis -30\r\nKPX edieresis comma -10\r\nKPX edieresis g -40\r\nKPX edieresis gbreve -40\r\nKPX edieresis gcommaaccent -40\r\nKPX edieresis period -15\r\nKPX edieresis v -15\r\nKPX edieresis w -15\r\nKPX edieresis x -20\r\nKPX edieresis y -30\r\nKPX edieresis yacute -30\r\nKPX edieresis ydieresis -30\r\nKPX edotaccent comma -10\r\nKPX edotaccent g -40\r\nKPX edotaccent gbreve -40\r\nKPX edotaccent gcommaaccent -40\r\nKPX edotaccent period -15\r\nKPX edotaccent v -15\r\nKPX edotaccent w -15\r\nKPX edotaccent x -20\r\nKPX edotaccent y -30\r\nKPX edotaccent yacute -30\r\nKPX edotaccent ydieresis -30\r\nKPX egrave comma -10\r\nKPX egrave g -40\r\nKPX egrave gbreve -40\r\nKPX egrave gcommaaccent -40\r\nKPX egrave period -15\r\nKPX egrave v -15\r\nKPX egrave w -15\r\nKPX egrave x -20\r\nKPX egrave y -30\r\nKPX egrave yacute -30\r\nKPX egrave ydieresis -30\r\nKPX emacron comma -10\r\nKPX emacron g -40\r\nKPX emacron gbreve -40\r\nKPX emacron gcommaaccent -40\r\nKPX emacron period -15\r\nKPX emacron v -15\r\nKPX emacron w -15\r\nKPX emacron x -20\r\nKPX emacron y -30\r\nKPX emacron yacute -30\r\nKPX emacron ydieresis -30\r\nKPX eogonek comma -10\r\nKPX eogonek g -40\r\nKPX eogonek gbreve -40\r\nKPX eogonek gcommaaccent -40\r\nKPX eogonek period -15\r\nKPX eogonek v -15\r\nKPX eogonek w -15\r\nKPX eogonek x -20\r\nKPX eogonek y -30\r\nKPX eogonek yacute -30\r\nKPX eogonek ydieresis -30\r\nKPX f comma -10\r\nKPX f dotlessi -60\r\nKPX f f -18\r\nKPX f i -20\r\nKPX f iogonek -20\r\nKPX f period -15\r\nKPX f quoteright 92\r\nKPX g comma -10\r\nKPX g e -10\r\nKPX g eacute -10\r\nKPX g ecaron -10\r\nKPX g ecircumflex -10\r\nKPX g edieresis -10\r\nKPX g edotaccent -10\r\nKPX g egrave -10\r\nKPX g emacron -10\r\nKPX g eogonek -10\r\nKPX g g -10\r\nKPX g gbreve -10\r\nKPX g gcommaaccent -10\r\nKPX g period -15\r\nKPX gbreve comma -10\r\nKPX gbreve e -10\r\nKPX gbreve eacute -10\r\nKPX gbreve ecaron -10\r\nKPX gbreve ecircumflex -10\r\nKPX gbreve edieresis -10\r\nKPX gbreve edotaccent -10\r\nKPX gbreve egrave -10\r\nKPX gbreve emacron -10\r\nKPX gbreve eogonek -10\r\nKPX gbreve g -10\r\nKPX gbreve gbreve -10\r\nKPX gbreve gcommaaccent -10\r\nKPX gbreve period -15\r\nKPX gcommaaccent comma -10\r\nKPX gcommaaccent e -10\r\nKPX gcommaaccent eacute -10\r\nKPX gcommaaccent ecaron -10\r\nKPX gcommaaccent ecircumflex -10\r\nKPX gcommaaccent edieresis -10\r\nKPX gcommaaccent edotaccent -10\r\nKPX gcommaaccent egrave -10\r\nKPX gcommaaccent emacron -10\r\nKPX gcommaaccent eogonek -10\r\nKPX gcommaaccent g -10\r\nKPX gcommaaccent gbreve -10\r\nKPX gcommaaccent gcommaaccent -10\r\nKPX gcommaaccent period -15\r\nKPX k e -10\r\nKPX k eacute -10\r\nKPX k ecaron -10\r\nKPX k ecircumflex -10\r\nKPX k edieresis -10\r\nKPX k edotaccent -10\r\nKPX k egrave -10\r\nKPX k emacron -10\r\nKPX k eogonek -10\r\nKPX k o -10\r\nKPX k oacute -10\r\nKPX k ocircumflex -10\r\nKPX k odieresis -10\r\nKPX k ograve -10\r\nKPX k ohungarumlaut -10\r\nKPX k omacron -10\r\nKPX k oslash -10\r\nKPX k otilde -10\r\nKPX k y -10\r\nKPX k yacute -10\r\nKPX k ydieresis -10\r\nKPX kcommaaccent e -10\r\nKPX kcommaaccent eacute -10\r\nKPX kcommaaccent ecaron -10\r\nKPX kcommaaccent ecircumflex -10\r\nKPX kcommaaccent edieresis -10\r\nKPX kcommaaccent edotaccent -10\r\nKPX kcommaaccent egrave -10\r\nKPX kcommaaccent emacron -10\r\nKPX kcommaaccent eogonek -10\r\nKPX kcommaaccent o -10\r\nKPX kcommaaccent oacute -10\r\nKPX kcommaaccent ocircumflex -10\r\nKPX kcommaaccent odieresis -10\r\nKPX kcommaaccent ograve -10\r\nKPX kcommaaccent ohungarumlaut -10\r\nKPX kcommaaccent omacron -10\r\nKPX kcommaaccent oslash -10\r\nKPX kcommaaccent otilde -10\r\nKPX kcommaaccent y -10\r\nKPX kcommaaccent yacute -10\r\nKPX kcommaaccent ydieresis -10\r\nKPX n v -40\r\nKPX nacute v -40\r\nKPX ncaron v -40\r\nKPX ncommaaccent v -40\r\nKPX ntilde v -40\r\nKPX o g -10\r\nKPX o gbreve -10\r\nKPX o gcommaaccent -10\r\nKPX o v -10\r\nKPX oacute g -10\r\nKPX oacute gbreve -10\r\nKPX oacute gcommaaccent -10\r\nKPX oacute v -10\r\nKPX ocircumflex g -10\r\nKPX ocircumflex gbreve -10\r\nKPX ocircumflex gcommaaccent -10\r\nKPX ocircumflex v -10\r\nKPX odieresis g -10\r\nKPX odieresis gbreve -10\r\nKPX odieresis gcommaaccent -10\r\nKPX odieresis v -10\r\nKPX ograve g -10\r\nKPX ograve gbreve -10\r\nKPX ograve gcommaaccent -10\r\nKPX ograve v -10\r\nKPX ohungarumlaut g -10\r\nKPX ohungarumlaut gbreve -10\r\nKPX ohungarumlaut gcommaaccent -10\r\nKPX ohungarumlaut v -10\r\nKPX omacron g -10\r\nKPX omacron gbreve -10\r\nKPX omacron gcommaaccent -10\r\nKPX omacron v -10\r\nKPX oslash g -10\r\nKPX oslash gbreve -10\r\nKPX oslash gcommaaccent -10\r\nKPX oslash v -10\r\nKPX otilde g -10\r\nKPX otilde gbreve -10\r\nKPX otilde gcommaaccent -10\r\nKPX otilde v -10\r\nKPX period quotedblright -140\r\nKPX period quoteright -140\r\nKPX quoteleft quoteleft -111\r\nKPX quoteright d -25\r\nKPX quoteright dcroat -25\r\nKPX quoteright quoteright -111\r\nKPX quoteright r -25\r\nKPX quoteright racute -25\r\nKPX quoteright rcaron -25\r\nKPX quoteright rcommaaccent -25\r\nKPX quoteright s -40\r\nKPX quoteright sacute -40\r\nKPX quoteright scaron -40\r\nKPX quoteright scedilla -40\r\nKPX quoteright scommaaccent -40\r\nKPX quoteright space -111\r\nKPX quoteright t -30\r\nKPX quoteright tcommaaccent -30\r\nKPX quoteright v -10\r\nKPX r a -15\r\nKPX r aacute -15\r\nKPX r abreve -15\r\nKPX r acircumflex -15\r\nKPX r adieresis -15\r\nKPX r agrave -15\r\nKPX r amacron -15\r\nKPX r aogonek -15\r\nKPX r aring -15\r\nKPX r atilde -15\r\nKPX r c -37\r\nKPX r cacute -37\r\nKPX r ccaron -37\r\nKPX r ccedilla -37\r\nKPX r comma -111\r\nKPX r d -37\r\nKPX r dcroat -37\r\nKPX r e -37\r\nKPX r eacute -37\r\nKPX r ecaron -37\r\nKPX r ecircumflex -37\r\nKPX r edieresis -37\r\nKPX r edotaccent -37\r\nKPX r egrave -37\r\nKPX r emacron -37\r\nKPX r eogonek -37\r\nKPX r g -37\r\nKPX r gbreve -37\r\nKPX r gcommaaccent -37\r\nKPX r hyphen -20\r\nKPX r o -45\r\nKPX r oacute -45\r\nKPX r ocircumflex -45\r\nKPX r odieresis -45\r\nKPX r ograve -45\r\nKPX r ohungarumlaut -45\r\nKPX r omacron -45\r\nKPX r oslash -45\r\nKPX r otilde -45\r\nKPX r period -111\r\nKPX r q -37\r\nKPX r s -10\r\nKPX r sacute -10\r\nKPX r scaron -10\r\nKPX r scedilla -10\r\nKPX r scommaaccent -10\r\nKPX racute a -15\r\nKPX racute aacute -15\r\nKPX racute abreve -15\r\nKPX racute acircumflex -15\r\nKPX racute adieresis -15\r\nKPX racute agrave -15\r\nKPX racute amacron -15\r\nKPX racute aogonek -15\r\nKPX racute aring -15\r\nKPX racute atilde -15\r\nKPX racute c -37\r\nKPX racute cacute -37\r\nKPX racute ccaron -37\r\nKPX racute ccedilla -37\r\nKPX racute comma -111\r\nKPX racute d -37\r\nKPX racute dcroat -37\r\nKPX racute e -37\r\nKPX racute eacute -37\r\nKPX racute ecaron -37\r\nKPX racute ecircumflex -37\r\nKPX racute edieresis -37\r\nKPX racute edotaccent -37\r\nKPX racute egrave -37\r\nKPX racute emacron -37\r\nKPX racute eogonek -37\r\nKPX racute g -37\r\nKPX racute gbreve -37\r\nKPX racute gcommaaccent -37\r\nKPX racute hyphen -20\r\nKPX racute o -45\r\nKPX racute oacute -45\r\nKPX racute ocircumflex -45\r\nKPX racute odieresis -45\r\nKPX racute ograve -45\r\nKPX racute ohungarumlaut -45\r\nKPX racute omacron -45\r\nKPX racute oslash -45\r\nKPX racute otilde -45\r\nKPX racute period -111\r\nKPX racute q -37\r\nKPX racute s -10\r\nKPX racute sacute -10\r\nKPX racute scaron -10\r\nKPX racute scedilla -10\r\nKPX racute scommaaccent -10\r\nKPX rcaron a -15\r\nKPX rcaron aacute -15\r\nKPX rcaron abreve -15\r\nKPX rcaron acircumflex -15\r\nKPX rcaron adieresis -15\r\nKPX rcaron agrave -15\r\nKPX rcaron amacron -15\r\nKPX rcaron aogonek -15\r\nKPX rcaron aring -15\r\nKPX rcaron atilde -15\r\nKPX rcaron c -37\r\nKPX rcaron cacute -37\r\nKPX rcaron ccaron -37\r\nKPX rcaron ccedilla -37\r\nKPX rcaron comma -111\r\nKPX rcaron d -37\r\nKPX rcaron dcroat -37\r\nKPX rcaron e -37\r\nKPX rcaron eacute -37\r\nKPX rcaron ecaron -37\r\nKPX rcaron ecircumflex -37\r\nKPX rcaron edieresis -37\r\nKPX rcaron edotaccent -37\r\nKPX rcaron egrave -37\r\nKPX rcaron emacron -37\r\nKPX rcaron eogonek -37\r\nKPX rcaron g -37\r\nKPX rcaron gbreve -37\r\nKPX rcaron gcommaaccent -37\r\nKPX rcaron hyphen -20\r\nKPX rcaron o -45\r\nKPX rcaron oacute -45\r\nKPX rcaron ocircumflex -45\r\nKPX rcaron odieresis -45\r\nKPX rcaron ograve -45\r\nKPX rcaron ohungarumlaut -45\r\nKPX rcaron omacron -45\r\nKPX rcaron oslash -45\r\nKPX rcaron otilde -45\r\nKPX rcaron period -111\r\nKPX rcaron q -37\r\nKPX rcaron s -10\r\nKPX rcaron sacute -10\r\nKPX rcaron scaron -10\r\nKPX rcaron scedilla -10\r\nKPX rcaron scommaaccent -10\r\nKPX rcommaaccent a -15\r\nKPX rcommaaccent aacute -15\r\nKPX rcommaaccent abreve -15\r\nKPX rcommaaccent acircumflex -15\r\nKPX rcommaaccent adieresis -15\r\nKPX rcommaaccent agrave -15\r\nKPX rcommaaccent amacron -15\r\nKPX rcommaaccent aogonek -15\r\nKPX rcommaaccent aring -15\r\nKPX rcommaaccent atilde -15\r\nKPX rcommaaccent c -37\r\nKPX rcommaaccent cacute -37\r\nKPX rcommaaccent ccaron -37\r\nKPX rcommaaccent ccedilla -37\r\nKPX rcommaaccent comma -111\r\nKPX rcommaaccent d -37\r\nKPX rcommaaccent dcroat -37\r\nKPX rcommaaccent e -37\r\nKPX rcommaaccent eacute -37\r\nKPX rcommaaccent ecaron -37\r\nKPX rcommaaccent ecircumflex -37\r\nKPX rcommaaccent edieresis -37\r\nKPX rcommaaccent edotaccent -37\r\nKPX rcommaaccent egrave -37\r\nKPX rcommaaccent emacron -37\r\nKPX rcommaaccent eogonek -37\r\nKPX rcommaaccent g -37\r\nKPX rcommaaccent gbreve -37\r\nKPX rcommaaccent gcommaaccent -37\r\nKPX rcommaaccent hyphen -20\r\nKPX rcommaaccent o -45\r\nKPX rcommaaccent oacute -45\r\nKPX rcommaaccent ocircumflex -45\r\nKPX rcommaaccent odieresis -45\r\nKPX rcommaaccent ograve -45\r\nKPX rcommaaccent ohungarumlaut -45\r\nKPX rcommaaccent omacron -45\r\nKPX rcommaaccent oslash -45\r\nKPX rcommaaccent otilde -45\r\nKPX rcommaaccent period -111\r\nKPX rcommaaccent q -37\r\nKPX rcommaaccent s -10\r\nKPX rcommaaccent sacute -10\r\nKPX rcommaaccent scaron -10\r\nKPX rcommaaccent scedilla -10\r\nKPX rcommaaccent scommaaccent -10\r\nKPX space A -18\r\nKPX space Aacute -18\r\nKPX space Abreve -18\r\nKPX space Acircumflex -18\r\nKPX space Adieresis -18\r\nKPX space Agrave -18\r\nKPX space Amacron -18\r\nKPX space Aogonek -18\r\nKPX space Aring -18\r\nKPX space Atilde -18\r\nKPX space T -18\r\nKPX space Tcaron -18\r\nKPX space Tcommaaccent -18\r\nKPX space V -35\r\nKPX space W -40\r\nKPX space Y -75\r\nKPX space Yacute -75\r\nKPX space Ydieresis -75\r\nKPX v comma -74\r\nKPX v period -74\r\nKPX w comma -74\r\nKPX w period -74\r\nKPX y comma -55\r\nKPX y period -55\r\nKPX yacute comma -55\r\nKPX yacute period -55\r\nKPX ydieresis comma -55\r\nKPX ydieresis period -55\r\nEndKernPairs\r\nEndKernData\r\nEndFontMetrics\r\n";
  },
  'Times-BoldItalic'() {
    return "StartFontMetrics 4.1\r\nComment Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.\r\nComment Creation Date: Thu May  1 13:04:06 1997\r\nComment UniqueID 43066\r\nComment VMusage 45874 56899\r\nFontName Times-BoldItalic\r\nFullName Times Bold Italic\r\nFamilyName Times\r\nWeight Bold\r\nItalicAngle -15\r\nIsFixedPitch false\r\nCharacterSet ExtendedRoman\r\nFontBBox -200 -218 996 921 \r\nUnderlinePosition -100\r\nUnderlineThickness 50\r\nVersion 002.000\r\nNotice Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.Times is a trademark of Linotype-Hell AG and/or its subsidiaries.\r\nEncodingScheme AdobeStandardEncoding\r\nCapHeight 669\r\nXHeight 462\r\nAscender 683\r\nDescender -217\r\nStdHW 42\r\nStdVW 121\r\nStartCharMetrics 315\r\nC 32 ; WX 250 ; N space ; B 0 0 0 0 ;\r\nC 33 ; WX 389 ; N exclam ; B 67 -13 370 684 ;\r\nC 34 ; WX 555 ; N quotedbl ; B 136 398 536 685 ;\r\nC 35 ; WX 500 ; N numbersign ; B -33 0 533 700 ;\r\nC 36 ; WX 500 ; N dollar ; B -20 -100 497 733 ;\r\nC 37 ; WX 833 ; N percent ; B 39 -10 793 692 ;\r\nC 38 ; WX 778 ; N ampersand ; B 5 -19 699 682 ;\r\nC 39 ; WX 333 ; N quoteright ; B 98 369 302 685 ;\r\nC 40 ; WX 333 ; N parenleft ; B 28 -179 344 685 ;\r\nC 41 ; WX 333 ; N parenright ; B -44 -179 271 685 ;\r\nC 42 ; WX 500 ; N asterisk ; B 65 249 456 685 ;\r\nC 43 ; WX 570 ; N plus ; B 33 0 537 506 ;\r\nC 44 ; WX 250 ; N comma ; B -60 -182 144 134 ;\r\nC 45 ; WX 333 ; N hyphen ; B 2 166 271 282 ;\r\nC 46 ; WX 250 ; N period ; B -9 -13 139 135 ;\r\nC 47 ; WX 278 ; N slash ; B -64 -18 342 685 ;\r\nC 48 ; WX 500 ; N zero ; B 17 -14 477 683 ;\r\nC 49 ; WX 500 ; N one ; B 5 0 419 683 ;\r\nC 50 ; WX 500 ; N two ; B -27 0 446 683 ;\r\nC 51 ; WX 500 ; N three ; B -15 -13 450 683 ;\r\nC 52 ; WX 500 ; N four ; B -15 0 503 683 ;\r\nC 53 ; WX 500 ; N five ; B -11 -13 487 669 ;\r\nC 54 ; WX 500 ; N six ; B 23 -15 509 679 ;\r\nC 55 ; WX 500 ; N seven ; B 52 0 525 669 ;\r\nC 56 ; WX 500 ; N eight ; B 3 -13 476 683 ;\r\nC 57 ; WX 500 ; N nine ; B -12 -10 475 683 ;\r\nC 58 ; WX 333 ; N colon ; B 23 -13 264 459 ;\r\nC 59 ; WX 333 ; N semicolon ; B -25 -183 264 459 ;\r\nC 60 ; WX 570 ; N less ; B 31 -8 539 514 ;\r\nC 61 ; WX 570 ; N equal ; B 33 107 537 399 ;\r\nC 62 ; WX 570 ; N greater ; B 31 -8 539 514 ;\r\nC 63 ; WX 500 ; N question ; B 79 -13 470 684 ;\r\nC 64 ; WX 832 ; N at ; B 63 -18 770 685 ;\r\nC 65 ; WX 667 ; N A ; B -67 0 593 683 ;\r\nC 66 ; WX 667 ; N B ; B -24 0 624 669 ;\r\nC 67 ; WX 667 ; N C ; B 32 -18 677 685 ;\r\nC 68 ; WX 722 ; N D ; B -46 0 685 669 ;\r\nC 69 ; WX 667 ; N E ; B -27 0 653 669 ;\r\nC 70 ; WX 667 ; N F ; B -13 0 660 669 ;\r\nC 71 ; WX 722 ; N G ; B 21 -18 706 685 ;\r\nC 72 ; WX 778 ; N H ; B -24 0 799 669 ;\r\nC 73 ; WX 389 ; N I ; B -32 0 406 669 ;\r\nC 74 ; WX 500 ; N J ; B -46 -99 524 669 ;\r\nC 75 ; WX 667 ; N K ; B -21 0 702 669 ;\r\nC 76 ; WX 611 ; N L ; B -22 0 590 669 ;\r\nC 77 ; WX 889 ; N M ; B -29 -12 917 669 ;\r\nC 78 ; WX 722 ; N N ; B -27 -15 748 669 ;\r\nC 79 ; WX 722 ; N O ; B 27 -18 691 685 ;\r\nC 80 ; WX 611 ; N P ; B -27 0 613 669 ;\r\nC 81 ; WX 722 ; N Q ; B 27 -208 691 685 ;\r\nC 82 ; WX 667 ; N R ; B -29 0 623 669 ;\r\nC 83 ; WX 556 ; N S ; B 2 -18 526 685 ;\r\nC 84 ; WX 611 ; N T ; B 50 0 650 669 ;\r\nC 85 ; WX 722 ; N U ; B 67 -18 744 669 ;\r\nC 86 ; WX 667 ; N V ; B 65 -18 715 669 ;\r\nC 87 ; WX 889 ; N W ; B 65 -18 940 669 ;\r\nC 88 ; WX 667 ; N X ; B -24 0 694 669 ;\r\nC 89 ; WX 611 ; N Y ; B 73 0 659 669 ;\r\nC 90 ; WX 611 ; N Z ; B -11 0 590 669 ;\r\nC 91 ; WX 333 ; N bracketleft ; B -37 -159 362 674 ;\r\nC 92 ; WX 278 ; N backslash ; B -1 -18 279 685 ;\r\nC 93 ; WX 333 ; N bracketright ; B -56 -157 343 674 ;\r\nC 94 ; WX 570 ; N asciicircum ; B 67 304 503 669 ;\r\nC 95 ; WX 500 ; N underscore ; B 0 -125 500 -75 ;\r\nC 96 ; WX 333 ; N quoteleft ; B 128 369 332 685 ;\r\nC 97 ; WX 500 ; N a ; B -21 -14 455 462 ;\r\nC 98 ; WX 500 ; N b ; B -14 -13 444 699 ;\r\nC 99 ; WX 444 ; N c ; B -5 -13 392 462 ;\r\nC 100 ; WX 500 ; N d ; B -21 -13 517 699 ;\r\nC 101 ; WX 444 ; N e ; B 5 -13 398 462 ;\r\nC 102 ; WX 333 ; N f ; B -169 -205 446 698 ; L i fi ; L l fl ;\r\nC 103 ; WX 500 ; N g ; B -52 -203 478 462 ;\r\nC 104 ; WX 556 ; N h ; B -13 -9 498 699 ;\r\nC 105 ; WX 278 ; N i ; B 2 -9 263 684 ;\r\nC 106 ; WX 278 ; N j ; B -189 -207 279 684 ;\r\nC 107 ; WX 500 ; N k ; B -23 -8 483 699 ;\r\nC 108 ; WX 278 ; N l ; B 2 -9 290 699 ;\r\nC 109 ; WX 778 ; N m ; B -14 -9 722 462 ;\r\nC 110 ; WX 556 ; N n ; B -6 -9 493 462 ;\r\nC 111 ; WX 500 ; N o ; B -3 -13 441 462 ;\r\nC 112 ; WX 500 ; N p ; B -120 -205 446 462 ;\r\nC 113 ; WX 500 ; N q ; B 1 -205 471 462 ;\r\nC 114 ; WX 389 ; N r ; B -21 0 389 462 ;\r\nC 115 ; WX 389 ; N s ; B -19 -13 333 462 ;\r\nC 116 ; WX 278 ; N t ; B -11 -9 281 594 ;\r\nC 117 ; WX 556 ; N u ; B 15 -9 492 462 ;\r\nC 118 ; WX 444 ; N v ; B 16 -13 401 462 ;\r\nC 119 ; WX 667 ; N w ; B 16 -13 614 462 ;\r\nC 120 ; WX 500 ; N x ; B -46 -13 469 462 ;\r\nC 121 ; WX 444 ; N y ; B -94 -205 392 462 ;\r\nC 122 ; WX 389 ; N z ; B -43 -78 368 449 ;\r\nC 123 ; WX 348 ; N braceleft ; B 5 -187 436 686 ;\r\nC 124 ; WX 220 ; N bar ; B 66 -218 154 782 ;\r\nC 125 ; WX 348 ; N braceright ; B -129 -187 302 686 ;\r\nC 126 ; WX 570 ; N asciitilde ; B 54 173 516 333 ;\r\nC 161 ; WX 389 ; N exclamdown ; B 19 -205 322 492 ;\r\nC 162 ; WX 500 ; N cent ; B 42 -143 439 576 ;\r\nC 163 ; WX 500 ; N sterling ; B -32 -12 510 683 ;\r\nC 164 ; WX 167 ; N fraction ; B -169 -14 324 683 ;\r\nC 165 ; WX 500 ; N yen ; B 33 0 628 669 ;\r\nC 166 ; WX 500 ; N florin ; B -87 -156 537 707 ;\r\nC 167 ; WX 500 ; N section ; B 36 -143 459 685 ;\r\nC 168 ; WX 500 ; N currency ; B -26 34 526 586 ;\r\nC 169 ; WX 278 ; N quotesingle ; B 128 398 268 685 ;\r\nC 170 ; WX 500 ; N quotedblleft ; B 53 369 513 685 ;\r\nC 171 ; WX 500 ; N guillemotleft ; B 12 32 468 415 ;\r\nC 172 ; WX 333 ; N guilsinglleft ; B 32 32 303 415 ;\r\nC 173 ; WX 333 ; N guilsinglright ; B 10 32 281 415 ;\r\nC 174 ; WX 556 ; N fi ; B -188 -205 514 703 ;\r\nC 175 ; WX 556 ; N fl ; B -186 -205 553 704 ;\r\nC 177 ; WX 500 ; N endash ; B -40 178 477 269 ;\r\nC 178 ; WX 500 ; N dagger ; B 91 -145 494 685 ;\r\nC 179 ; WX 500 ; N daggerdbl ; B 10 -139 493 685 ;\r\nC 180 ; WX 250 ; N periodcentered ; B 51 257 199 405 ;\r\nC 182 ; WX 500 ; N paragraph ; B -57 -193 562 669 ;\r\nC 183 ; WX 350 ; N bullet ; B 0 175 350 525 ;\r\nC 184 ; WX 333 ; N quotesinglbase ; B -5 -182 199 134 ;\r\nC 185 ; WX 500 ; N quotedblbase ; B -57 -182 403 134 ;\r\nC 186 ; WX 500 ; N quotedblright ; B 53 369 513 685 ;\r\nC 187 ; WX 500 ; N guillemotright ; B 12 32 468 415 ;\r\nC 188 ; WX 1000 ; N ellipsis ; B 40 -13 852 135 ;\r\nC 189 ; WX 1000 ; N perthousand ; B 7 -29 996 706 ;\r\nC 191 ; WX 500 ; N questiondown ; B 30 -205 421 492 ;\r\nC 193 ; WX 333 ; N grave ; B 85 516 297 697 ;\r\nC 194 ; WX 333 ; N acute ; B 139 516 379 697 ;\r\nC 195 ; WX 333 ; N circumflex ; B 40 516 367 690 ;\r\nC 196 ; WX 333 ; N tilde ; B 48 536 407 655 ;\r\nC 197 ; WX 333 ; N macron ; B 51 553 393 623 ;\r\nC 198 ; WX 333 ; N breve ; B 71 516 387 678 ;\r\nC 199 ; WX 333 ; N dotaccent ; B 163 550 298 684 ;\r\nC 200 ; WX 333 ; N dieresis ; B 55 550 402 684 ;\r\nC 202 ; WX 333 ; N ring ; B 127 516 340 729 ;\r\nC 203 ; WX 333 ; N cedilla ; B -80 -218 156 5 ;\r\nC 205 ; WX 333 ; N hungarumlaut ; B 69 516 498 697 ;\r\nC 206 ; WX 333 ; N ogonek ; B 15 -183 244 34 ;\r\nC 207 ; WX 333 ; N caron ; B 79 516 411 690 ;\r\nC 208 ; WX 1000 ; N emdash ; B -40 178 977 269 ;\r\nC 225 ; WX 944 ; N AE ; B -64 0 918 669 ;\r\nC 227 ; WX 266 ; N ordfeminine ; B 16 399 330 685 ;\r\nC 232 ; WX 611 ; N Lslash ; B -22 0 590 669 ;\r\nC 233 ; WX 722 ; N Oslash ; B 27 -125 691 764 ;\r\nC 234 ; WX 944 ; N OE ; B 23 -8 946 677 ;\r\nC 235 ; WX 300 ; N ordmasculine ; B 56 400 347 685 ;\r\nC 241 ; WX 722 ; N ae ; B -5 -13 673 462 ;\r\nC 245 ; WX 278 ; N dotlessi ; B 2 -9 238 462 ;\r\nC 248 ; WX 278 ; N lslash ; B -7 -9 307 699 ;\r\nC 249 ; WX 500 ; N oslash ; B -3 -119 441 560 ;\r\nC 250 ; WX 722 ; N oe ; B 6 -13 674 462 ;\r\nC 251 ; WX 500 ; N germandbls ; B -200 -200 473 705 ;\r\nC -1 ; WX 389 ; N Idieresis ; B -32 0 450 862 ;\r\nC -1 ; WX 444 ; N eacute ; B 5 -13 435 697 ;\r\nC -1 ; WX 500 ; N abreve ; B -21 -14 471 678 ;\r\nC -1 ; WX 556 ; N uhungarumlaut ; B 15 -9 610 697 ;\r\nC -1 ; WX 444 ; N ecaron ; B 5 -13 467 690 ;\r\nC -1 ; WX 611 ; N Ydieresis ; B 73 0 659 862 ;\r\nC -1 ; WX 570 ; N divide ; B 33 -29 537 535 ;\r\nC -1 ; WX 611 ; N Yacute ; B 73 0 659 904 ;\r\nC -1 ; WX 667 ; N Acircumflex ; B -67 0 593 897 ;\r\nC -1 ; WX 500 ; N aacute ; B -21 -14 463 697 ;\r\nC -1 ; WX 722 ; N Ucircumflex ; B 67 -18 744 897 ;\r\nC -1 ; WX 444 ; N yacute ; B -94 -205 435 697 ;\r\nC -1 ; WX 389 ; N scommaaccent ; B -19 -218 333 462 ;\r\nC -1 ; WX 444 ; N ecircumflex ; B 5 -13 423 690 ;\r\nC -1 ; WX 722 ; N Uring ; B 67 -18 744 921 ;\r\nC -1 ; WX 722 ; N Udieresis ; B 67 -18 744 862 ;\r\nC -1 ; WX 500 ; N aogonek ; B -21 -183 455 462 ;\r\nC -1 ; WX 722 ; N Uacute ; B 67 -18 744 904 ;\r\nC -1 ; WX 556 ; N uogonek ; B 15 -183 492 462 ;\r\nC -1 ; WX 667 ; N Edieresis ; B -27 0 653 862 ;\r\nC -1 ; WX 722 ; N Dcroat ; B -31 0 700 669 ;\r\nC -1 ; WX 250 ; N commaaccent ; B -36 -218 131 -50 ;\r\nC -1 ; WX 747 ; N copyright ; B 30 -18 718 685 ;\r\nC -1 ; WX 667 ; N Emacron ; B -27 0 653 830 ;\r\nC -1 ; WX 444 ; N ccaron ; B -5 -13 467 690 ;\r\nC -1 ; WX 500 ; N aring ; B -21 -14 455 729 ;\r\nC -1 ; WX 722 ; N Ncommaaccent ; B -27 -218 748 669 ;\r\nC -1 ; WX 278 ; N lacute ; B 2 -9 392 904 ;\r\nC -1 ; WX 500 ; N agrave ; B -21 -14 455 697 ;\r\nC -1 ; WX 611 ; N Tcommaaccent ; B 50 -218 650 669 ;\r\nC -1 ; WX 667 ; N Cacute ; B 32 -18 677 904 ;\r\nC -1 ; WX 500 ; N atilde ; B -21 -14 491 655 ;\r\nC -1 ; WX 667 ; N Edotaccent ; B -27 0 653 862 ;\r\nC -1 ; WX 389 ; N scaron ; B -19 -13 424 690 ;\r\nC -1 ; WX 389 ; N scedilla ; B -19 -218 333 462 ;\r\nC -1 ; WX 278 ; N iacute ; B 2 -9 352 697 ;\r\nC -1 ; WX 494 ; N lozenge ; B 10 0 484 745 ;\r\nC -1 ; WX 667 ; N Rcaron ; B -29 0 623 897 ;\r\nC -1 ; WX 722 ; N Gcommaaccent ; B 21 -218 706 685 ;\r\nC -1 ; WX 556 ; N ucircumflex ; B 15 -9 492 690 ;\r\nC -1 ; WX 500 ; N acircumflex ; B -21 -14 455 690 ;\r\nC -1 ; WX 667 ; N Amacron ; B -67 0 593 830 ;\r\nC -1 ; WX 389 ; N rcaron ; B -21 0 424 690 ;\r\nC -1 ; WX 444 ; N ccedilla ; B -5 -218 392 462 ;\r\nC -1 ; WX 611 ; N Zdotaccent ; B -11 0 590 862 ;\r\nC -1 ; WX 611 ; N Thorn ; B -27 0 573 669 ;\r\nC -1 ; WX 722 ; N Omacron ; B 27 -18 691 830 ;\r\nC -1 ; WX 667 ; N Racute ; B -29 0 623 904 ;\r\nC -1 ; WX 556 ; N Sacute ; B 2 -18 531 904 ;\r\nC -1 ; WX 608 ; N dcaron ; B -21 -13 675 708 ;\r\nC -1 ; WX 722 ; N Umacron ; B 67 -18 744 830 ;\r\nC -1 ; WX 556 ; N uring ; B 15 -9 492 729 ;\r\nC -1 ; WX 300 ; N threesuperior ; B 17 265 321 683 ;\r\nC -1 ; WX 722 ; N Ograve ; B 27 -18 691 904 ;\r\nC -1 ; WX 667 ; N Agrave ; B -67 0 593 904 ;\r\nC -1 ; WX 667 ; N Abreve ; B -67 0 593 885 ;\r\nC -1 ; WX 570 ; N multiply ; B 48 16 522 490 ;\r\nC -1 ; WX 556 ; N uacute ; B 15 -9 492 697 ;\r\nC -1 ; WX 611 ; N Tcaron ; B 50 0 650 897 ;\r\nC -1 ; WX 494 ; N partialdiff ; B 11 -21 494 750 ;\r\nC -1 ; WX 444 ; N ydieresis ; B -94 -205 443 655 ;\r\nC -1 ; WX 722 ; N Nacute ; B -27 -15 748 904 ;\r\nC -1 ; WX 278 ; N icircumflex ; B -3 -9 324 690 ;\r\nC -1 ; WX 667 ; N Ecircumflex ; B -27 0 653 897 ;\r\nC -1 ; WX 500 ; N adieresis ; B -21 -14 476 655 ;\r\nC -1 ; WX 444 ; N edieresis ; B 5 -13 448 655 ;\r\nC -1 ; WX 444 ; N cacute ; B -5 -13 435 697 ;\r\nC -1 ; WX 556 ; N nacute ; B -6 -9 493 697 ;\r\nC -1 ; WX 556 ; N umacron ; B 15 -9 492 623 ;\r\nC -1 ; WX 722 ; N Ncaron ; B -27 -15 748 897 ;\r\nC -1 ; WX 389 ; N Iacute ; B -32 0 432 904 ;\r\nC -1 ; WX 570 ; N plusminus ; B 33 0 537 506 ;\r\nC -1 ; WX 220 ; N brokenbar ; B 66 -143 154 707 ;\r\nC -1 ; WX 747 ; N registered ; B 30 -18 718 685 ;\r\nC -1 ; WX 722 ; N Gbreve ; B 21 -18 706 885 ;\r\nC -1 ; WX 389 ; N Idotaccent ; B -32 0 406 862 ;\r\nC -1 ; WX 600 ; N summation ; B 14 -10 585 706 ;\r\nC -1 ; WX 667 ; N Egrave ; B -27 0 653 904 ;\r\nC -1 ; WX 389 ; N racute ; B -21 0 407 697 ;\r\nC -1 ; WX 500 ; N omacron ; B -3 -13 462 623 ;\r\nC -1 ; WX 611 ; N Zacute ; B -11 0 590 904 ;\r\nC -1 ; WX 611 ; N Zcaron ; B -11 0 590 897 ;\r\nC -1 ; WX 549 ; N greaterequal ; B 26 0 523 704 ;\r\nC -1 ; WX 722 ; N Eth ; B -31 0 700 669 ;\r\nC -1 ; WX 667 ; N Ccedilla ; B 32 -218 677 685 ;\r\nC -1 ; WX 278 ; N lcommaaccent ; B -42 -218 290 699 ;\r\nC -1 ; WX 366 ; N tcaron ; B -11 -9 434 754 ;\r\nC -1 ; WX 444 ; N eogonek ; B 5 -183 398 462 ;\r\nC -1 ; WX 722 ; N Uogonek ; B 67 -183 744 669 ;\r\nC -1 ; WX 667 ; N Aacute ; B -67 0 593 904 ;\r\nC -1 ; WX 667 ; N Adieresis ; B -67 0 593 862 ;\r\nC -1 ; WX 444 ; N egrave ; B 5 -13 398 697 ;\r\nC -1 ; WX 389 ; N zacute ; B -43 -78 407 697 ;\r\nC -1 ; WX 278 ; N iogonek ; B -20 -183 263 684 ;\r\nC -1 ; WX 722 ; N Oacute ; B 27 -18 691 904 ;\r\nC -1 ; WX 500 ; N oacute ; B -3 -13 463 697 ;\r\nC -1 ; WX 500 ; N amacron ; B -21 -14 467 623 ;\r\nC -1 ; WX 389 ; N sacute ; B -19 -13 407 697 ;\r\nC -1 ; WX 278 ; N idieresis ; B 2 -9 364 655 ;\r\nC -1 ; WX 722 ; N Ocircumflex ; B 27 -18 691 897 ;\r\nC -1 ; WX 722 ; N Ugrave ; B 67 -18 744 904 ;\r\nC -1 ; WX 612 ; N Delta ; B 6 0 608 688 ;\r\nC -1 ; WX 500 ; N thorn ; B -120 -205 446 699 ;\r\nC -1 ; WX 300 ; N twosuperior ; B 2 274 313 683 ;\r\nC -1 ; WX 722 ; N Odieresis ; B 27 -18 691 862 ;\r\nC -1 ; WX 576 ; N mu ; B -60 -207 516 449 ;\r\nC -1 ; WX 278 ; N igrave ; B 2 -9 259 697 ;\r\nC -1 ; WX 500 ; N ohungarumlaut ; B -3 -13 582 697 ;\r\nC -1 ; WX 667 ; N Eogonek ; B -27 -183 653 669 ;\r\nC -1 ; WX 500 ; N dcroat ; B -21 -13 552 699 ;\r\nC -1 ; WX 750 ; N threequarters ; B 7 -14 726 683 ;\r\nC -1 ; WX 556 ; N Scedilla ; B 2 -218 526 685 ;\r\nC -1 ; WX 382 ; N lcaron ; B 2 -9 448 708 ;\r\nC -1 ; WX 667 ; N Kcommaaccent ; B -21 -218 702 669 ;\r\nC -1 ; WX 611 ; N Lacute ; B -22 0 590 904 ;\r\nC -1 ; WX 1000 ; N trademark ; B 32 263 968 669 ;\r\nC -1 ; WX 444 ; N edotaccent ; B 5 -13 398 655 ;\r\nC -1 ; WX 389 ; N Igrave ; B -32 0 406 904 ;\r\nC -1 ; WX 389 ; N Imacron ; B -32 0 461 830 ;\r\nC -1 ; WX 611 ; N Lcaron ; B -22 0 671 718 ;\r\nC -1 ; WX 750 ; N onehalf ; B -9 -14 723 683 ;\r\nC -1 ; WX 549 ; N lessequal ; B 29 0 526 704 ;\r\nC -1 ; WX 500 ; N ocircumflex ; B -3 -13 451 690 ;\r\nC -1 ; WX 556 ; N ntilde ; B -6 -9 504 655 ;\r\nC -1 ; WX 722 ; N Uhungarumlaut ; B 67 -18 744 904 ;\r\nC -1 ; WX 667 ; N Eacute ; B -27 0 653 904 ;\r\nC -1 ; WX 444 ; N emacron ; B 5 -13 439 623 ;\r\nC -1 ; WX 500 ; N gbreve ; B -52 -203 478 678 ;\r\nC -1 ; WX 750 ; N onequarter ; B 7 -14 721 683 ;\r\nC -1 ; WX 556 ; N Scaron ; B 2 -18 553 897 ;\r\nC -1 ; WX 556 ; N Scommaaccent ; B 2 -218 526 685 ;\r\nC -1 ; WX 722 ; N Ohungarumlaut ; B 27 -18 723 904 ;\r\nC -1 ; WX 400 ; N degree ; B 83 397 369 683 ;\r\nC -1 ; WX 500 ; N ograve ; B -3 -13 441 697 ;\r\nC -1 ; WX 667 ; N Ccaron ; B 32 -18 677 897 ;\r\nC -1 ; WX 556 ; N ugrave ; B 15 -9 492 697 ;\r\nC -1 ; WX 549 ; N radical ; B 10 -46 512 850 ;\r\nC -1 ; WX 722 ; N Dcaron ; B -46 0 685 897 ;\r\nC -1 ; WX 389 ; N rcommaaccent ; B -67 -218 389 462 ;\r\nC -1 ; WX 722 ; N Ntilde ; B -27 -15 748 862 ;\r\nC -1 ; WX 500 ; N otilde ; B -3 -13 491 655 ;\r\nC -1 ; WX 667 ; N Rcommaaccent ; B -29 -218 623 669 ;\r\nC -1 ; WX 611 ; N Lcommaaccent ; B -22 -218 590 669 ;\r\nC -1 ; WX 667 ; N Atilde ; B -67 0 593 862 ;\r\nC -1 ; WX 667 ; N Aogonek ; B -67 -183 604 683 ;\r\nC -1 ; WX 667 ; N Aring ; B -67 0 593 921 ;\r\nC -1 ; WX 722 ; N Otilde ; B 27 -18 691 862 ;\r\nC -1 ; WX 389 ; N zdotaccent ; B -43 -78 368 655 ;\r\nC -1 ; WX 667 ; N Ecaron ; B -27 0 653 897 ;\r\nC -1 ; WX 389 ; N Iogonek ; B -32 -183 406 669 ;\r\nC -1 ; WX 500 ; N kcommaaccent ; B -23 -218 483 699 ;\r\nC -1 ; WX 606 ; N minus ; B 51 209 555 297 ;\r\nC -1 ; WX 389 ; N Icircumflex ; B -32 0 450 897 ;\r\nC -1 ; WX 556 ; N ncaron ; B -6 -9 523 690 ;\r\nC -1 ; WX 278 ; N tcommaaccent ; B -62 -218 281 594 ;\r\nC -1 ; WX 606 ; N logicalnot ; B 51 108 555 399 ;\r\nC -1 ; WX 500 ; N odieresis ; B -3 -13 471 655 ;\r\nC -1 ; WX 556 ; N udieresis ; B 15 -9 499 655 ;\r\nC -1 ; WX 549 ; N notequal ; B 15 -49 540 570 ;\r\nC -1 ; WX 500 ; N gcommaaccent ; B -52 -203 478 767 ;\r\nC -1 ; WX 500 ; N eth ; B -3 -13 454 699 ;\r\nC -1 ; WX 389 ; N zcaron ; B -43 -78 424 690 ;\r\nC -1 ; WX 556 ; N ncommaaccent ; B -6 -218 493 462 ;\r\nC -1 ; WX 300 ; N onesuperior ; B 30 274 301 683 ;\r\nC -1 ; WX 278 ; N imacron ; B 2 -9 294 623 ;\r\nC -1 ; WX 500 ; N Euro ; B 0 0 0 0 ;\r\nEndCharMetrics\r\nStartKernData\r\nStartKernPairs 2038\r\nKPX A C -65\r\nKPX A Cacute -65\r\nKPX A Ccaron -65\r\nKPX A Ccedilla -65\r\nKPX A G -60\r\nKPX A Gbreve -60\r\nKPX A Gcommaaccent -60\r\nKPX A O -50\r\nKPX A Oacute -50\r\nKPX A Ocircumflex -50\r\nKPX A Odieresis -50\r\nKPX A Ograve -50\r\nKPX A Ohungarumlaut -50\r\nKPX A Omacron -50\r\nKPX A Oslash -50\r\nKPX A Otilde -50\r\nKPX A Q -55\r\nKPX A T -55\r\nKPX A Tcaron -55\r\nKPX A Tcommaaccent -55\r\nKPX A U -50\r\nKPX A Uacute -50\r\nKPX A Ucircumflex -50\r\nKPX A Udieresis -50\r\nKPX A Ugrave -50\r\nKPX A Uhungarumlaut -50\r\nKPX A Umacron -50\r\nKPX A Uogonek -50\r\nKPX A Uring -50\r\nKPX A V -95\r\nKPX A W -100\r\nKPX A Y -70\r\nKPX A Yacute -70\r\nKPX A Ydieresis -70\r\nKPX A quoteright -74\r\nKPX A u -30\r\nKPX A uacute -30\r\nKPX A ucircumflex -30\r\nKPX A udieresis -30\r\nKPX A ugrave -30\r\nKPX A uhungarumlaut -30\r\nKPX A umacron -30\r\nKPX A uogonek -30\r\nKPX A uring -30\r\nKPX A v -74\r\nKPX A w -74\r\nKPX A y -74\r\nKPX A yacute -74\r\nKPX A ydieresis -74\r\nKPX Aacute C -65\r\nKPX Aacute Cacute -65\r\nKPX Aacute Ccaron -65\r\nKPX Aacute Ccedilla -65\r\nKPX Aacute G -60\r\nKPX Aacute Gbreve -60\r\nKPX Aacute Gcommaaccent -60\r\nKPX Aacute O -50\r\nKPX Aacute Oacute -50\r\nKPX Aacute Ocircumflex -50\r\nKPX Aacute Odieresis -50\r\nKPX Aacute Ograve -50\r\nKPX Aacute Ohungarumlaut -50\r\nKPX Aacute Omacron -50\r\nKPX Aacute Oslash -50\r\nKPX Aacute Otilde -50\r\nKPX Aacute Q -55\r\nKPX Aacute T -55\r\nKPX Aacute Tcaron -55\r\nKPX Aacute Tcommaaccent -55\r\nKPX Aacute U -50\r\nKPX Aacute Uacute -50\r\nKPX Aacute Ucircumflex -50\r\nKPX Aacute Udieresis -50\r\nKPX Aacute Ugrave -50\r\nKPX Aacute Uhungarumlaut -50\r\nKPX Aacute Umacron -50\r\nKPX Aacute Uogonek -50\r\nKPX Aacute Uring -50\r\nKPX Aacute V -95\r\nKPX Aacute W -100\r\nKPX Aacute Y -70\r\nKPX Aacute Yacute -70\r\nKPX Aacute Ydieresis -70\r\nKPX Aacute quoteright -74\r\nKPX Aacute u -30\r\nKPX Aacute uacute -30\r\nKPX Aacute ucircumflex -30\r\nKPX Aacute udieresis -30\r\nKPX Aacute ugrave -30\r\nKPX Aacute uhungarumlaut -30\r\nKPX Aacute umacron -30\r\nKPX Aacute uogonek -30\r\nKPX Aacute uring -30\r\nKPX Aacute v -74\r\nKPX Aacute w -74\r\nKPX Aacute y -74\r\nKPX Aacute yacute -74\r\nKPX Aacute ydieresis -74\r\nKPX Abreve C -65\r\nKPX Abreve Cacute -65\r\nKPX Abreve Ccaron -65\r\nKPX Abreve Ccedilla -65\r\nKPX Abreve G -60\r\nKPX Abreve Gbreve -60\r\nKPX Abreve Gcommaaccent -60\r\nKPX Abreve O -50\r\nKPX Abreve Oacute -50\r\nKPX Abreve Ocircumflex -50\r\nKPX Abreve Odieresis -50\r\nKPX Abreve Ograve -50\r\nKPX Abreve Ohungarumlaut -50\r\nKPX Abreve Omacron -50\r\nKPX Abreve Oslash -50\r\nKPX Abreve Otilde -50\r\nKPX Abreve Q -55\r\nKPX Abreve T -55\r\nKPX Abreve Tcaron -55\r\nKPX Abreve Tcommaaccent -55\r\nKPX Abreve U -50\r\nKPX Abreve Uacute -50\r\nKPX Abreve Ucircumflex -50\r\nKPX Abreve Udieresis -50\r\nKPX Abreve Ugrave -50\r\nKPX Abreve Uhungarumlaut -50\r\nKPX Abreve Umacron -50\r\nKPX Abreve Uogonek -50\r\nKPX Abreve Uring -50\r\nKPX Abreve V -95\r\nKPX Abreve W -100\r\nKPX Abreve Y -70\r\nKPX Abreve Yacute -70\r\nKPX Abreve Ydieresis -70\r\nKPX Abreve quoteright -74\r\nKPX Abreve u -30\r\nKPX Abreve uacute -30\r\nKPX Abreve ucircumflex -30\r\nKPX Abreve udieresis -30\r\nKPX Abreve ugrave -30\r\nKPX Abreve uhungarumlaut -30\r\nKPX Abreve umacron -30\r\nKPX Abreve uogonek -30\r\nKPX Abreve uring -30\r\nKPX Abreve v -74\r\nKPX Abreve w -74\r\nKPX Abreve y -74\r\nKPX Abreve yacute -74\r\nKPX Abreve ydieresis -74\r\nKPX Acircumflex C -65\r\nKPX Acircumflex Cacute -65\r\nKPX Acircumflex Ccaron -65\r\nKPX Acircumflex Ccedilla -65\r\nKPX Acircumflex G -60\r\nKPX Acircumflex Gbreve -60\r\nKPX Acircumflex Gcommaaccent -60\r\nKPX Acircumflex O -50\r\nKPX Acircumflex Oacute -50\r\nKPX Acircumflex Ocircumflex -50\r\nKPX Acircumflex Odieresis -50\r\nKPX Acircumflex Ograve -50\r\nKPX Acircumflex Ohungarumlaut -50\r\nKPX Acircumflex Omacron -50\r\nKPX Acircumflex Oslash -50\r\nKPX Acircumflex Otilde -50\r\nKPX Acircumflex Q -55\r\nKPX Acircumflex T -55\r\nKPX Acircumflex Tcaron -55\r\nKPX Acircumflex Tcommaaccent -55\r\nKPX Acircumflex U -50\r\nKPX Acircumflex Uacute -50\r\nKPX Acircumflex Ucircumflex -50\r\nKPX Acircumflex Udieresis -50\r\nKPX Acircumflex Ugrave -50\r\nKPX Acircumflex Uhungarumlaut -50\r\nKPX Acircumflex Umacron -50\r\nKPX Acircumflex Uogonek -50\r\nKPX Acircumflex Uring -50\r\nKPX Acircumflex V -95\r\nKPX Acircumflex W -100\r\nKPX Acircumflex Y -70\r\nKPX Acircumflex Yacute -70\r\nKPX Acircumflex Ydieresis -70\r\nKPX Acircumflex quoteright -74\r\nKPX Acircumflex u -30\r\nKPX Acircumflex uacute -30\r\nKPX Acircumflex ucircumflex -30\r\nKPX Acircumflex udieresis -30\r\nKPX Acircumflex ugrave -30\r\nKPX Acircumflex uhungarumlaut -30\r\nKPX Acircumflex umacron -30\r\nKPX Acircumflex uogonek -30\r\nKPX Acircumflex uring -30\r\nKPX Acircumflex v -74\r\nKPX Acircumflex w -74\r\nKPX Acircumflex y -74\r\nKPX Acircumflex yacute -74\r\nKPX Acircumflex ydieresis -74\r\nKPX Adieresis C -65\r\nKPX Adieresis Cacute -65\r\nKPX Adieresis Ccaron -65\r\nKPX Adieresis Ccedilla -65\r\nKPX Adieresis G -60\r\nKPX Adieresis Gbreve -60\r\nKPX Adieresis Gcommaaccent -60\r\nKPX Adieresis O -50\r\nKPX Adieresis Oacute -50\r\nKPX Adieresis Ocircumflex -50\r\nKPX Adieresis Odieresis -50\r\nKPX Adieresis Ograve -50\r\nKPX Adieresis Ohungarumlaut -50\r\nKPX Adieresis Omacron -50\r\nKPX Adieresis Oslash -50\r\nKPX Adieresis Otilde -50\r\nKPX Adieresis Q -55\r\nKPX Adieresis T -55\r\nKPX Adieresis Tcaron -55\r\nKPX Adieresis Tcommaaccent -55\r\nKPX Adieresis U -50\r\nKPX Adieresis Uacute -50\r\nKPX Adieresis Ucircumflex -50\r\nKPX Adieresis Udieresis -50\r\nKPX Adieresis Ugrave -50\r\nKPX Adieresis Uhungarumlaut -50\r\nKPX Adieresis Umacron -50\r\nKPX Adieresis Uogonek -50\r\nKPX Adieresis Uring -50\r\nKPX Adieresis V -95\r\nKPX Adieresis W -100\r\nKPX Adieresis Y -70\r\nKPX Adieresis Yacute -70\r\nKPX Adieresis Ydieresis -70\r\nKPX Adieresis quoteright -74\r\nKPX Adieresis u -30\r\nKPX Adieresis uacute -30\r\nKPX Adieresis ucircumflex -30\r\nKPX Adieresis udieresis -30\r\nKPX Adieresis ugrave -30\r\nKPX Adieresis uhungarumlaut -30\r\nKPX Adieresis umacron -30\r\nKPX Adieresis uogonek -30\r\nKPX Adieresis uring -30\r\nKPX Adieresis v -74\r\nKPX Adieresis w -74\r\nKPX Adieresis y -74\r\nKPX Adieresis yacute -74\r\nKPX Adieresis ydieresis -74\r\nKPX Agrave C -65\r\nKPX Agrave Cacute -65\r\nKPX Agrave Ccaron -65\r\nKPX Agrave Ccedilla -65\r\nKPX Agrave G -60\r\nKPX Agrave Gbreve -60\r\nKPX Agrave Gcommaaccent -60\r\nKPX Agrave O -50\r\nKPX Agrave Oacute -50\r\nKPX Agrave Ocircumflex -50\r\nKPX Agrave Odieresis -50\r\nKPX Agrave Ograve -50\r\nKPX Agrave Ohungarumlaut -50\r\nKPX Agrave Omacron -50\r\nKPX Agrave Oslash -50\r\nKPX Agrave Otilde -50\r\nKPX Agrave Q -55\r\nKPX Agrave T -55\r\nKPX Agrave Tcaron -55\r\nKPX Agrave Tcommaaccent -55\r\nKPX Agrave U -50\r\nKPX Agrave Uacute -50\r\nKPX Agrave Ucircumflex -50\r\nKPX Agrave Udieresis -50\r\nKPX Agrave Ugrave -50\r\nKPX Agrave Uhungarumlaut -50\r\nKPX Agrave Umacron -50\r\nKPX Agrave Uogonek -50\r\nKPX Agrave Uring -50\r\nKPX Agrave V -95\r\nKPX Agrave W -100\r\nKPX Agrave Y -70\r\nKPX Agrave Yacute -70\r\nKPX Agrave Ydieresis -70\r\nKPX Agrave quoteright -74\r\nKPX Agrave u -30\r\nKPX Agrave uacute -30\r\nKPX Agrave ucircumflex -30\r\nKPX Agrave udieresis -30\r\nKPX Agrave ugrave -30\r\nKPX Agrave uhungarumlaut -30\r\nKPX Agrave umacron -30\r\nKPX Agrave uogonek -30\r\nKPX Agrave uring -30\r\nKPX Agrave v -74\r\nKPX Agrave w -74\r\nKPX Agrave y -74\r\nKPX Agrave yacute -74\r\nKPX Agrave ydieresis -74\r\nKPX Amacron C -65\r\nKPX Amacron Cacute -65\r\nKPX Amacron Ccaron -65\r\nKPX Amacron Ccedilla -65\r\nKPX Amacron G -60\r\nKPX Amacron Gbreve -60\r\nKPX Amacron Gcommaaccent -60\r\nKPX Amacron O -50\r\nKPX Amacron Oacute -50\r\nKPX Amacron Ocircumflex -50\r\nKPX Amacron Odieresis -50\r\nKPX Amacron Ograve -50\r\nKPX Amacron Ohungarumlaut -50\r\nKPX Amacron Omacron -50\r\nKPX Amacron Oslash -50\r\nKPX Amacron Otilde -50\r\nKPX Amacron Q -55\r\nKPX Amacron T -55\r\nKPX Amacron Tcaron -55\r\nKPX Amacron Tcommaaccent -55\r\nKPX Amacron U -50\r\nKPX Amacron Uacute -50\r\nKPX Amacron Ucircumflex -50\r\nKPX Amacron Udieresis -50\r\nKPX Amacron Ugrave -50\r\nKPX Amacron Uhungarumlaut -50\r\nKPX Amacron Umacron -50\r\nKPX Amacron Uogonek -50\r\nKPX Amacron Uring -50\r\nKPX Amacron V -95\r\nKPX Amacron W -100\r\nKPX Amacron Y -70\r\nKPX Amacron Yacute -70\r\nKPX Amacron Ydieresis -70\r\nKPX Amacron quoteright -74\r\nKPX Amacron u -30\r\nKPX Amacron uacute -30\r\nKPX Amacron ucircumflex -30\r\nKPX Amacron udieresis -30\r\nKPX Amacron ugrave -30\r\nKPX Amacron uhungarumlaut -30\r\nKPX Amacron umacron -30\r\nKPX Amacron uogonek -30\r\nKPX Amacron uring -30\r\nKPX Amacron v -74\r\nKPX Amacron w -74\r\nKPX Amacron y -74\r\nKPX Amacron yacute -74\r\nKPX Amacron ydieresis -74\r\nKPX Aogonek C -65\r\nKPX Aogonek Cacute -65\r\nKPX Aogonek Ccaron -65\r\nKPX Aogonek Ccedilla -65\r\nKPX Aogonek G -60\r\nKPX Aogonek Gbreve -60\r\nKPX Aogonek Gcommaaccent -60\r\nKPX Aogonek O -50\r\nKPX Aogonek Oacute -50\r\nKPX Aogonek Ocircumflex -50\r\nKPX Aogonek Odieresis -50\r\nKPX Aogonek Ograve -50\r\nKPX Aogonek Ohungarumlaut -50\r\nKPX Aogonek Omacron -50\r\nKPX Aogonek Oslash -50\r\nKPX Aogonek Otilde -50\r\nKPX Aogonek Q -55\r\nKPX Aogonek T -55\r\nKPX Aogonek Tcaron -55\r\nKPX Aogonek Tcommaaccent -55\r\nKPX Aogonek U -50\r\nKPX Aogonek Uacute -50\r\nKPX Aogonek Ucircumflex -50\r\nKPX Aogonek Udieresis -50\r\nKPX Aogonek Ugrave -50\r\nKPX Aogonek Uhungarumlaut -50\r\nKPX Aogonek Umacron -50\r\nKPX Aogonek Uogonek -50\r\nKPX Aogonek Uring -50\r\nKPX Aogonek V -95\r\nKPX Aogonek W -100\r\nKPX Aogonek Y -70\r\nKPX Aogonek Yacute -70\r\nKPX Aogonek Ydieresis -70\r\nKPX Aogonek quoteright -74\r\nKPX Aogonek u -30\r\nKPX Aogonek uacute -30\r\nKPX Aogonek ucircumflex -30\r\nKPX Aogonek udieresis -30\r\nKPX Aogonek ugrave -30\r\nKPX Aogonek uhungarumlaut -30\r\nKPX Aogonek umacron -30\r\nKPX Aogonek uogonek -30\r\nKPX Aogonek uring -30\r\nKPX Aogonek v -74\r\nKPX Aogonek w -74\r\nKPX Aogonek y -34\r\nKPX Aogonek yacute -34\r\nKPX Aogonek ydieresis -34\r\nKPX Aring C -65\r\nKPX Aring Cacute -65\r\nKPX Aring Ccaron -65\r\nKPX Aring Ccedilla -65\r\nKPX Aring G -60\r\nKPX Aring Gbreve -60\r\nKPX Aring Gcommaaccent -60\r\nKPX Aring O -50\r\nKPX Aring Oacute -50\r\nKPX Aring Ocircumflex -50\r\nKPX Aring Odieresis -50\r\nKPX Aring Ograve -50\r\nKPX Aring Ohungarumlaut -50\r\nKPX Aring Omacron -50\r\nKPX Aring Oslash -50\r\nKPX Aring Otilde -50\r\nKPX Aring Q -55\r\nKPX Aring T -55\r\nKPX Aring Tcaron -55\r\nKPX Aring Tcommaaccent -55\r\nKPX Aring U -50\r\nKPX Aring Uacute -50\r\nKPX Aring Ucircumflex -50\r\nKPX Aring Udieresis -50\r\nKPX Aring Ugrave -50\r\nKPX Aring Uhungarumlaut -50\r\nKPX Aring Umacron -50\r\nKPX Aring Uogonek -50\r\nKPX Aring Uring -50\r\nKPX Aring V -95\r\nKPX Aring W -100\r\nKPX Aring Y -70\r\nKPX Aring Yacute -70\r\nKPX Aring Ydieresis -70\r\nKPX Aring quoteright -74\r\nKPX Aring u -30\r\nKPX Aring uacute -30\r\nKPX Aring ucircumflex -30\r\nKPX Aring udieresis -30\r\nKPX Aring ugrave -30\r\nKPX Aring uhungarumlaut -30\r\nKPX Aring umacron -30\r\nKPX Aring uogonek -30\r\nKPX Aring uring -30\r\nKPX Aring v -74\r\nKPX Aring w -74\r\nKPX Aring y -74\r\nKPX Aring yacute -74\r\nKPX Aring ydieresis -74\r\nKPX Atilde C -65\r\nKPX Atilde Cacute -65\r\nKPX Atilde Ccaron -65\r\nKPX Atilde Ccedilla -65\r\nKPX Atilde G -60\r\nKPX Atilde Gbreve -60\r\nKPX Atilde Gcommaaccent -60\r\nKPX Atilde O -50\r\nKPX Atilde Oacute -50\r\nKPX Atilde Ocircumflex -50\r\nKPX Atilde Odieresis -50\r\nKPX Atilde Ograve -50\r\nKPX Atilde Ohungarumlaut -50\r\nKPX Atilde Omacron -50\r\nKPX Atilde Oslash -50\r\nKPX Atilde Otilde -50\r\nKPX Atilde Q -55\r\nKPX Atilde T -55\r\nKPX Atilde Tcaron -55\r\nKPX Atilde Tcommaaccent -55\r\nKPX Atilde U -50\r\nKPX Atilde Uacute -50\r\nKPX Atilde Ucircumflex -50\r\nKPX Atilde Udieresis -50\r\nKPX Atilde Ugrave -50\r\nKPX Atilde Uhungarumlaut -50\r\nKPX Atilde Umacron -50\r\nKPX Atilde Uogonek -50\r\nKPX Atilde Uring -50\r\nKPX Atilde V -95\r\nKPX Atilde W -100\r\nKPX Atilde Y -70\r\nKPX Atilde Yacute -70\r\nKPX Atilde Ydieresis -70\r\nKPX Atilde quoteright -74\r\nKPX Atilde u -30\r\nKPX Atilde uacute -30\r\nKPX Atilde ucircumflex -30\r\nKPX Atilde udieresis -30\r\nKPX Atilde ugrave -30\r\nKPX Atilde uhungarumlaut -30\r\nKPX Atilde umacron -30\r\nKPX Atilde uogonek -30\r\nKPX Atilde uring -30\r\nKPX Atilde v -74\r\nKPX Atilde w -74\r\nKPX Atilde y -74\r\nKPX Atilde yacute -74\r\nKPX Atilde ydieresis -74\r\nKPX B A -25\r\nKPX B Aacute -25\r\nKPX B Abreve -25\r\nKPX B Acircumflex -25\r\nKPX B Adieresis -25\r\nKPX B Agrave -25\r\nKPX B Amacron -25\r\nKPX B Aogonek -25\r\nKPX B Aring -25\r\nKPX B Atilde -25\r\nKPX B U -10\r\nKPX B Uacute -10\r\nKPX B Ucircumflex -10\r\nKPX B Udieresis -10\r\nKPX B Ugrave -10\r\nKPX B Uhungarumlaut -10\r\nKPX B Umacron -10\r\nKPX B Uogonek -10\r\nKPX B Uring -10\r\nKPX D A -25\r\nKPX D Aacute -25\r\nKPX D Abreve -25\r\nKPX D Acircumflex -25\r\nKPX D Adieresis -25\r\nKPX D Agrave -25\r\nKPX D Amacron -25\r\nKPX D Aogonek -25\r\nKPX D Aring -25\r\nKPX D Atilde -25\r\nKPX D V -50\r\nKPX D W -40\r\nKPX D Y -50\r\nKPX D Yacute -50\r\nKPX D Ydieresis -50\r\nKPX Dcaron A -25\r\nKPX Dcaron Aacute -25\r\nKPX Dcaron Abreve -25\r\nKPX Dcaron Acircumflex -25\r\nKPX Dcaron Adieresis -25\r\nKPX Dcaron Agrave -25\r\nKPX Dcaron Amacron -25\r\nKPX Dcaron Aogonek -25\r\nKPX Dcaron Aring -25\r\nKPX Dcaron Atilde -25\r\nKPX Dcaron V -50\r\nKPX Dcaron W -40\r\nKPX Dcaron Y -50\r\nKPX Dcaron Yacute -50\r\nKPX Dcaron Ydieresis -50\r\nKPX Dcroat A -25\r\nKPX Dcroat Aacute -25\r\nKPX Dcroat Abreve -25\r\nKPX Dcroat Acircumflex -25\r\nKPX Dcroat Adieresis -25\r\nKPX Dcroat Agrave -25\r\nKPX Dcroat Amacron -25\r\nKPX Dcroat Aogonek -25\r\nKPX Dcroat Aring -25\r\nKPX Dcroat Atilde -25\r\nKPX Dcroat V -50\r\nKPX Dcroat W -40\r\nKPX Dcroat Y -50\r\nKPX Dcroat Yacute -50\r\nKPX Dcroat Ydieresis -50\r\nKPX F A -100\r\nKPX F Aacute -100\r\nKPX F Abreve -100\r\nKPX F Acircumflex -100\r\nKPX F Adieresis -100\r\nKPX F Agrave -100\r\nKPX F Amacron -100\r\nKPX F Aogonek -100\r\nKPX F Aring -100\r\nKPX F Atilde -100\r\nKPX F a -95\r\nKPX F aacute -95\r\nKPX F abreve -95\r\nKPX F acircumflex -95\r\nKPX F adieresis -95\r\nKPX F agrave -95\r\nKPX F amacron -95\r\nKPX F aogonek -95\r\nKPX F aring -95\r\nKPX F atilde -95\r\nKPX F comma -129\r\nKPX F e -100\r\nKPX F eacute -100\r\nKPX F ecaron -100\r\nKPX F ecircumflex -100\r\nKPX F edieresis -100\r\nKPX F edotaccent -100\r\nKPX F egrave -100\r\nKPX F emacron -100\r\nKPX F eogonek -100\r\nKPX F i -40\r\nKPX F iacute -40\r\nKPX F icircumflex -40\r\nKPX F idieresis -40\r\nKPX F igrave -40\r\nKPX F imacron -40\r\nKPX F iogonek -40\r\nKPX F o -70\r\nKPX F oacute -70\r\nKPX F ocircumflex -70\r\nKPX F odieresis -70\r\nKPX F ograve -70\r\nKPX F ohungarumlaut -70\r\nKPX F omacron -70\r\nKPX F oslash -70\r\nKPX F otilde -70\r\nKPX F period -129\r\nKPX F r -50\r\nKPX F racute -50\r\nKPX F rcaron -50\r\nKPX F rcommaaccent -50\r\nKPX J A -25\r\nKPX J Aacute -25\r\nKPX J Abreve -25\r\nKPX J Acircumflex -25\r\nKPX J Adieresis -25\r\nKPX J Agrave -25\r\nKPX J Amacron -25\r\nKPX J Aogonek -25\r\nKPX J Aring -25\r\nKPX J Atilde -25\r\nKPX J a -40\r\nKPX J aacute -40\r\nKPX J abreve -40\r\nKPX J acircumflex -40\r\nKPX J adieresis -40\r\nKPX J agrave -40\r\nKPX J amacron -40\r\nKPX J aogonek -40\r\nKPX J aring -40\r\nKPX J atilde -40\r\nKPX J comma -10\r\nKPX J e -40\r\nKPX J eacute -40\r\nKPX J ecaron -40\r\nKPX J ecircumflex -40\r\nKPX J edieresis -40\r\nKPX J edotaccent -40\r\nKPX J egrave -40\r\nKPX J emacron -40\r\nKPX J eogonek -40\r\nKPX J o -40\r\nKPX J oacute -40\r\nKPX J ocircumflex -40\r\nKPX J odieresis -40\r\nKPX J ograve -40\r\nKPX J ohungarumlaut -40\r\nKPX J omacron -40\r\nKPX J oslash -40\r\nKPX J otilde -40\r\nKPX J period -10\r\nKPX J u -40\r\nKPX J uacute -40\r\nKPX J ucircumflex -40\r\nKPX J udieresis -40\r\nKPX J ugrave -40\r\nKPX J uhungarumlaut -40\r\nKPX J umacron -40\r\nKPX J uogonek -40\r\nKPX J uring -40\r\nKPX K O -30\r\nKPX K Oacute -30\r\nKPX K Ocircumflex -30\r\nKPX K Odieresis -30\r\nKPX K Ograve -30\r\nKPX K Ohungarumlaut -30\r\nKPX K Omacron -30\r\nKPX K Oslash -30\r\nKPX K Otilde -30\r\nKPX K e -25\r\nKPX K eacute -25\r\nKPX K ecaron -25\r\nKPX K ecircumflex -25\r\nKPX K edieresis -25\r\nKPX K edotaccent -25\r\nKPX K egrave -25\r\nKPX K emacron -25\r\nKPX K eogonek -25\r\nKPX K o -25\r\nKPX K oacute -25\r\nKPX K ocircumflex -25\r\nKPX K odieresis -25\r\nKPX K ograve -25\r\nKPX K ohungarumlaut -25\r\nKPX K omacron -25\r\nKPX K oslash -25\r\nKPX K otilde -25\r\nKPX K u -20\r\nKPX K uacute -20\r\nKPX K ucircumflex -20\r\nKPX K udieresis -20\r\nKPX K ugrave -20\r\nKPX K uhungarumlaut -20\r\nKPX K umacron -20\r\nKPX K uogonek -20\r\nKPX K uring -20\r\nKPX K y -20\r\nKPX K yacute -20\r\nKPX K ydieresis -20\r\nKPX Kcommaaccent O -30\r\nKPX Kcommaaccent Oacute -30\r\nKPX Kcommaaccent Ocircumflex -30\r\nKPX Kcommaaccent Odieresis -30\r\nKPX Kcommaaccent Ograve -30\r\nKPX Kcommaaccent Ohungarumlaut -30\r\nKPX Kcommaaccent Omacron -30\r\nKPX Kcommaaccent Oslash -30\r\nKPX Kcommaaccent Otilde -30\r\nKPX Kcommaaccent e -25\r\nKPX Kcommaaccent eacute -25\r\nKPX Kcommaaccent ecaron -25\r\nKPX Kcommaaccent ecircumflex -25\r\nKPX Kcommaaccent edieresis -25\r\nKPX Kcommaaccent edotaccent -25\r\nKPX Kcommaaccent egrave -25\r\nKPX Kcommaaccent emacron -25\r\nKPX Kcommaaccent eogonek -25\r\nKPX Kcommaaccent o -25\r\nKPX Kcommaaccent oacute -25\r\nKPX Kcommaaccent ocircumflex -25\r\nKPX Kcommaaccent odieresis -25\r\nKPX Kcommaaccent ograve -25\r\nKPX Kcommaaccent ohungarumlaut -25\r\nKPX Kcommaaccent omacron -25\r\nKPX Kcommaaccent oslash -25\r\nKPX Kcommaaccent otilde -25\r\nKPX Kcommaaccent u -20\r\nKPX Kcommaaccent uacute -20\r\nKPX Kcommaaccent ucircumflex -20\r\nKPX Kcommaaccent udieresis -20\r\nKPX Kcommaaccent ugrave -20\r\nKPX Kcommaaccent uhungarumlaut -20\r\nKPX Kcommaaccent umacron -20\r\nKPX Kcommaaccent uogonek -20\r\nKPX Kcommaaccent uring -20\r\nKPX Kcommaaccent y -20\r\nKPX Kcommaaccent yacute -20\r\nKPX Kcommaaccent ydieresis -20\r\nKPX L T -18\r\nKPX L Tcaron -18\r\nKPX L Tcommaaccent -18\r\nKPX L V -37\r\nKPX L W -37\r\nKPX L Y -37\r\nKPX L Yacute -37\r\nKPX L Ydieresis -37\r\nKPX L quoteright -55\r\nKPX L y -37\r\nKPX L yacute -37\r\nKPX L ydieresis -37\r\nKPX Lacute T -18\r\nKPX Lacute Tcaron -18\r\nKPX Lacute Tcommaaccent -18\r\nKPX Lacute V -37\r\nKPX Lacute W -37\r\nKPX Lacute Y -37\r\nKPX Lacute Yacute -37\r\nKPX Lacute Ydieresis -37\r\nKPX Lacute quoteright -55\r\nKPX Lacute y -37\r\nKPX Lacute yacute -37\r\nKPX Lacute ydieresis -37\r\nKPX Lcommaaccent T -18\r\nKPX Lcommaaccent Tcaron -18\r\nKPX Lcommaaccent Tcommaaccent -18\r\nKPX Lcommaaccent V -37\r\nKPX Lcommaaccent W -37\r\nKPX Lcommaaccent Y -37\r\nKPX Lcommaaccent Yacute -37\r\nKPX Lcommaaccent Ydieresis -37\r\nKPX Lcommaaccent quoteright -55\r\nKPX Lcommaaccent y -37\r\nKPX Lcommaaccent yacute -37\r\nKPX Lcommaaccent ydieresis -37\r\nKPX Lslash T -18\r\nKPX Lslash Tcaron -18\r\nKPX Lslash Tcommaaccent -18\r\nKPX Lslash V -37\r\nKPX Lslash W -37\r\nKPX Lslash Y -37\r\nKPX Lslash Yacute -37\r\nKPX Lslash Ydieresis -37\r\nKPX Lslash quoteright -55\r\nKPX Lslash y -37\r\nKPX Lslash yacute -37\r\nKPX Lslash ydieresis -37\r\nKPX N A -30\r\nKPX N Aacute -30\r\nKPX N Abreve -30\r\nKPX N Acircumflex -30\r\nKPX N Adieresis -30\r\nKPX N Agrave -30\r\nKPX N Amacron -30\r\nKPX N Aogonek -30\r\nKPX N Aring -30\r\nKPX N Atilde -30\r\nKPX Nacute A -30\r\nKPX Nacute Aacute -30\r\nKPX Nacute Abreve -30\r\nKPX Nacute Acircumflex -30\r\nKPX Nacute Adieresis -30\r\nKPX Nacute Agrave -30\r\nKPX Nacute Amacron -30\r\nKPX Nacute Aogonek -30\r\nKPX Nacute Aring -30\r\nKPX Nacute Atilde -30\r\nKPX Ncaron A -30\r\nKPX Ncaron Aacute -30\r\nKPX Ncaron Abreve -30\r\nKPX Ncaron Acircumflex -30\r\nKPX Ncaron Adieresis -30\r\nKPX Ncaron Agrave -30\r\nKPX Ncaron Amacron -30\r\nKPX Ncaron Aogonek -30\r\nKPX Ncaron Aring -30\r\nKPX Ncaron Atilde -30\r\nKPX Ncommaaccent A -30\r\nKPX Ncommaaccent Aacute -30\r\nKPX Ncommaaccent Abreve -30\r\nKPX Ncommaaccent Acircumflex -30\r\nKPX Ncommaaccent Adieresis -30\r\nKPX Ncommaaccent Agrave -30\r\nKPX Ncommaaccent Amacron -30\r\nKPX Ncommaaccent Aogonek -30\r\nKPX Ncommaaccent Aring -30\r\nKPX Ncommaaccent Atilde -30\r\nKPX Ntilde A -30\r\nKPX Ntilde Aacute -30\r\nKPX Ntilde Abreve -30\r\nKPX Ntilde Acircumflex -30\r\nKPX Ntilde Adieresis -30\r\nKPX Ntilde Agrave -30\r\nKPX Ntilde Amacron -30\r\nKPX Ntilde Aogonek -30\r\nKPX Ntilde Aring -30\r\nKPX Ntilde Atilde -30\r\nKPX O A -40\r\nKPX O Aacute -40\r\nKPX O Abreve -40\r\nKPX O Acircumflex -40\r\nKPX O Adieresis -40\r\nKPX O Agrave -40\r\nKPX O Amacron -40\r\nKPX O Aogonek -40\r\nKPX O Aring -40\r\nKPX O Atilde -40\r\nKPX O T -40\r\nKPX O Tcaron -40\r\nKPX O Tcommaaccent -40\r\nKPX O V -50\r\nKPX O W -50\r\nKPX O X -40\r\nKPX O Y -50\r\nKPX O Yacute -50\r\nKPX O Ydieresis -50\r\nKPX Oacute A -40\r\nKPX Oacute Aacute -40\r\nKPX Oacute Abreve -40\r\nKPX Oacute Acircumflex -40\r\nKPX Oacute Adieresis -40\r\nKPX Oacute Agrave -40\r\nKPX Oacute Amacron -40\r\nKPX Oacute Aogonek -40\r\nKPX Oacute Aring -40\r\nKPX Oacute Atilde -40\r\nKPX Oacute T -40\r\nKPX Oacute Tcaron -40\r\nKPX Oacute Tcommaaccent -40\r\nKPX Oacute V -50\r\nKPX Oacute W -50\r\nKPX Oacute X -40\r\nKPX Oacute Y -50\r\nKPX Oacute Yacute -50\r\nKPX Oacute Ydieresis -50\r\nKPX Ocircumflex A -40\r\nKPX Ocircumflex Aacute -40\r\nKPX Ocircumflex Abreve -40\r\nKPX Ocircumflex Acircumflex -40\r\nKPX Ocircumflex Adieresis -40\r\nKPX Ocircumflex Agrave -40\r\nKPX Ocircumflex Amacron -40\r\nKPX Ocircumflex Aogonek -40\r\nKPX Ocircumflex Aring -40\r\nKPX Ocircumflex Atilde -40\r\nKPX Ocircumflex T -40\r\nKPX Ocircumflex Tcaron -40\r\nKPX Ocircumflex Tcommaaccent -40\r\nKPX Ocircumflex V -50\r\nKPX Ocircumflex W -50\r\nKPX Ocircumflex X -40\r\nKPX Ocircumflex Y -50\r\nKPX Ocircumflex Yacute -50\r\nKPX Ocircumflex Ydieresis -50\r\nKPX Odieresis A -40\r\nKPX Odieresis Aacute -40\r\nKPX Odieresis Abreve -40\r\nKPX Odieresis Acircumflex -40\r\nKPX Odieresis Adieresis -40\r\nKPX Odieresis Agrave -40\r\nKPX Odieresis Amacron -40\r\nKPX Odieresis Aogonek -40\r\nKPX Odieresis Aring -40\r\nKPX Odieresis Atilde -40\r\nKPX Odieresis T -40\r\nKPX Odieresis Tcaron -40\r\nKPX Odieresis Tcommaaccent -40\r\nKPX Odieresis V -50\r\nKPX Odieresis W -50\r\nKPX Odieresis X -40\r\nKPX Odieresis Y -50\r\nKPX Odieresis Yacute -50\r\nKPX Odieresis Ydieresis -50\r\nKPX Ograve A -40\r\nKPX Ograve Aacute -40\r\nKPX Ograve Abreve -40\r\nKPX Ograve Acircumflex -40\r\nKPX Ograve Adieresis -40\r\nKPX Ograve Agrave -40\r\nKPX Ograve Amacron -40\r\nKPX Ograve Aogonek -40\r\nKPX Ograve Aring -40\r\nKPX Ograve Atilde -40\r\nKPX Ograve T -40\r\nKPX Ograve Tcaron -40\r\nKPX Ograve Tcommaaccent -40\r\nKPX Ograve V -50\r\nKPX Ograve W -50\r\nKPX Ograve X -40\r\nKPX Ograve Y -50\r\nKPX Ograve Yacute -50\r\nKPX Ograve Ydieresis -50\r\nKPX Ohungarumlaut A -40\r\nKPX Ohungarumlaut Aacute -40\r\nKPX Ohungarumlaut Abreve -40\r\nKPX Ohungarumlaut Acircumflex -40\r\nKPX Ohungarumlaut Adieresis -40\r\nKPX Ohungarumlaut Agrave -40\r\nKPX Ohungarumlaut Amacron -40\r\nKPX Ohungarumlaut Aogonek -40\r\nKPX Ohungarumlaut Aring -40\r\nKPX Ohungarumlaut Atilde -40\r\nKPX Ohungarumlaut T -40\r\nKPX Ohungarumlaut Tcaron -40\r\nKPX Ohungarumlaut Tcommaaccent -40\r\nKPX Ohungarumlaut V -50\r\nKPX Ohungarumlaut W -50\r\nKPX Ohungarumlaut X -40\r\nKPX Ohungarumlaut Y -50\r\nKPX Ohungarumlaut Yacute -50\r\nKPX Ohungarumlaut Ydieresis -50\r\nKPX Omacron A -40\r\nKPX Omacron Aacute -40\r\nKPX Omacron Abreve -40\r\nKPX Omacron Acircumflex -40\r\nKPX Omacron Adieresis -40\r\nKPX Omacron Agrave -40\r\nKPX Omacron Amacron -40\r\nKPX Omacron Aogonek -40\r\nKPX Omacron Aring -40\r\nKPX Omacron Atilde -40\r\nKPX Omacron T -40\r\nKPX Omacron Tcaron -40\r\nKPX Omacron Tcommaaccent -40\r\nKPX Omacron V -50\r\nKPX Omacron W -50\r\nKPX Omacron X -40\r\nKPX Omacron Y -50\r\nKPX Omacron Yacute -50\r\nKPX Omacron Ydieresis -50\r\nKPX Oslash A -40\r\nKPX Oslash Aacute -40\r\nKPX Oslash Abreve -40\r\nKPX Oslash Acircumflex -40\r\nKPX Oslash Adieresis -40\r\nKPX Oslash Agrave -40\r\nKPX Oslash Amacron -40\r\nKPX Oslash Aogonek -40\r\nKPX Oslash Aring -40\r\nKPX Oslash Atilde -40\r\nKPX Oslash T -40\r\nKPX Oslash Tcaron -40\r\nKPX Oslash Tcommaaccent -40\r\nKPX Oslash V -50\r\nKPX Oslash W -50\r\nKPX Oslash X -40\r\nKPX Oslash Y -50\r\nKPX Oslash Yacute -50\r\nKPX Oslash Ydieresis -50\r\nKPX Otilde A -40\r\nKPX Otilde Aacute -40\r\nKPX Otilde Abreve -40\r\nKPX Otilde Acircumflex -40\r\nKPX Otilde Adieresis -40\r\nKPX Otilde Agrave -40\r\nKPX Otilde Amacron -40\r\nKPX Otilde Aogonek -40\r\nKPX Otilde Aring -40\r\nKPX Otilde Atilde -40\r\nKPX Otilde T -40\r\nKPX Otilde Tcaron -40\r\nKPX Otilde Tcommaaccent -40\r\nKPX Otilde V -50\r\nKPX Otilde W -50\r\nKPX Otilde X -40\r\nKPX Otilde Y -50\r\nKPX Otilde Yacute -50\r\nKPX Otilde Ydieresis -50\r\nKPX P A -85\r\nKPX P Aacute -85\r\nKPX P Abreve -85\r\nKPX P Acircumflex -85\r\nKPX P Adieresis -85\r\nKPX P Agrave -85\r\nKPX P Amacron -85\r\nKPX P Aogonek -85\r\nKPX P Aring -85\r\nKPX P Atilde -85\r\nKPX P a -40\r\nKPX P aacute -40\r\nKPX P abreve -40\r\nKPX P acircumflex -40\r\nKPX P adieresis -40\r\nKPX P agrave -40\r\nKPX P amacron -40\r\nKPX P aogonek -40\r\nKPX P aring -40\r\nKPX P atilde -40\r\nKPX P comma -129\r\nKPX P e -50\r\nKPX P eacute -50\r\nKPX P ecaron -50\r\nKPX P ecircumflex -50\r\nKPX P edieresis -50\r\nKPX P edotaccent -50\r\nKPX P egrave -50\r\nKPX P emacron -50\r\nKPX P eogonek -50\r\nKPX P o -55\r\nKPX P oacute -55\r\nKPX P ocircumflex -55\r\nKPX P odieresis -55\r\nKPX P ograve -55\r\nKPX P ohungarumlaut -55\r\nKPX P omacron -55\r\nKPX P oslash -55\r\nKPX P otilde -55\r\nKPX P period -129\r\nKPX Q U -10\r\nKPX Q Uacute -10\r\nKPX Q Ucircumflex -10\r\nKPX Q Udieresis -10\r\nKPX Q Ugrave -10\r\nKPX Q Uhungarumlaut -10\r\nKPX Q Umacron -10\r\nKPX Q Uogonek -10\r\nKPX Q Uring -10\r\nKPX R O -40\r\nKPX R Oacute -40\r\nKPX R Ocircumflex -40\r\nKPX R Odieresis -40\r\nKPX R Ograve -40\r\nKPX R Ohungarumlaut -40\r\nKPX R Omacron -40\r\nKPX R Oslash -40\r\nKPX R Otilde -40\r\nKPX R T -30\r\nKPX R Tcaron -30\r\nKPX R Tcommaaccent -30\r\nKPX R U -40\r\nKPX R Uacute -40\r\nKPX R Ucircumflex -40\r\nKPX R Udieresis -40\r\nKPX R Ugrave -40\r\nKPX R Uhungarumlaut -40\r\nKPX R Umacron -40\r\nKPX R Uogonek -40\r\nKPX R Uring -40\r\nKPX R V -18\r\nKPX R W -18\r\nKPX R Y -18\r\nKPX R Yacute -18\r\nKPX R Ydieresis -18\r\nKPX Racute O -40\r\nKPX Racute Oacute -40\r\nKPX Racute Ocircumflex -40\r\nKPX Racute Odieresis -40\r\nKPX Racute Ograve -40\r\nKPX Racute Ohungarumlaut -40\r\nKPX Racute Omacron -40\r\nKPX Racute Oslash -40\r\nKPX Racute Otilde -40\r\nKPX Racute T -30\r\nKPX Racute Tcaron -30\r\nKPX Racute Tcommaaccent -30\r\nKPX Racute U -40\r\nKPX Racute Uacute -40\r\nKPX Racute Ucircumflex -40\r\nKPX Racute Udieresis -40\r\nKPX Racute Ugrave -40\r\nKPX Racute Uhungarumlaut -40\r\nKPX Racute Umacron -40\r\nKPX Racute Uogonek -40\r\nKPX Racute Uring -40\r\nKPX Racute V -18\r\nKPX Racute W -18\r\nKPX Racute Y -18\r\nKPX Racute Yacute -18\r\nKPX Racute Ydieresis -18\r\nKPX Rcaron O -40\r\nKPX Rcaron Oacute -40\r\nKPX Rcaron Ocircumflex -40\r\nKPX Rcaron Odieresis -40\r\nKPX Rcaron Ograve -40\r\nKPX Rcaron Ohungarumlaut -40\r\nKPX Rcaron Omacron -40\r\nKPX Rcaron Oslash -40\r\nKPX Rcaron Otilde -40\r\nKPX Rcaron T -30\r\nKPX Rcaron Tcaron -30\r\nKPX Rcaron Tcommaaccent -30\r\nKPX Rcaron U -40\r\nKPX Rcaron Uacute -40\r\nKPX Rcaron Ucircumflex -40\r\nKPX Rcaron Udieresis -40\r\nKPX Rcaron Ugrave -40\r\nKPX Rcaron Uhungarumlaut -40\r\nKPX Rcaron Umacron -40\r\nKPX Rcaron Uogonek -40\r\nKPX Rcaron Uring -40\r\nKPX Rcaron V -18\r\nKPX Rcaron W -18\r\nKPX Rcaron Y -18\r\nKPX Rcaron Yacute -18\r\nKPX Rcaron Ydieresis -18\r\nKPX Rcommaaccent O -40\r\nKPX Rcommaaccent Oacute -40\r\nKPX Rcommaaccent Ocircumflex -40\r\nKPX Rcommaaccent Odieresis -40\r\nKPX Rcommaaccent Ograve -40\r\nKPX Rcommaaccent Ohungarumlaut -40\r\nKPX Rcommaaccent Omacron -40\r\nKPX Rcommaaccent Oslash -40\r\nKPX Rcommaaccent Otilde -40\r\nKPX Rcommaaccent T -30\r\nKPX Rcommaaccent Tcaron -30\r\nKPX Rcommaaccent Tcommaaccent -30\r\nKPX Rcommaaccent U -40\r\nKPX Rcommaaccent Uacute -40\r\nKPX Rcommaaccent Ucircumflex -40\r\nKPX Rcommaaccent Udieresis -40\r\nKPX Rcommaaccent Ugrave -40\r\nKPX Rcommaaccent Uhungarumlaut -40\r\nKPX Rcommaaccent Umacron -40\r\nKPX Rcommaaccent Uogonek -40\r\nKPX Rcommaaccent Uring -40\r\nKPX Rcommaaccent V -18\r\nKPX Rcommaaccent W -18\r\nKPX Rcommaaccent Y -18\r\nKPX Rcommaaccent Yacute -18\r\nKPX Rcommaaccent Ydieresis -18\r\nKPX T A -55\r\nKPX T Aacute -55\r\nKPX T Abreve -55\r\nKPX T Acircumflex -55\r\nKPX T Adieresis -55\r\nKPX T Agrave -55\r\nKPX T Amacron -55\r\nKPX T Aogonek -55\r\nKPX T Aring -55\r\nKPX T Atilde -55\r\nKPX T O -18\r\nKPX T Oacute -18\r\nKPX T Ocircumflex -18\r\nKPX T Odieresis -18\r\nKPX T Ograve -18\r\nKPX T Ohungarumlaut -18\r\nKPX T Omacron -18\r\nKPX T Oslash -18\r\nKPX T Otilde -18\r\nKPX T a -92\r\nKPX T aacute -92\r\nKPX T abreve -92\r\nKPX T acircumflex -92\r\nKPX T adieresis -92\r\nKPX T agrave -92\r\nKPX T amacron -92\r\nKPX T aogonek -92\r\nKPX T aring -92\r\nKPX T atilde -92\r\nKPX T colon -74\r\nKPX T comma -92\r\nKPX T e -92\r\nKPX T eacute -92\r\nKPX T ecaron -92\r\nKPX T ecircumflex -92\r\nKPX T edieresis -52\r\nKPX T edotaccent -92\r\nKPX T egrave -52\r\nKPX T emacron -52\r\nKPX T eogonek -92\r\nKPX T hyphen -92\r\nKPX T i -37\r\nKPX T iacute -37\r\nKPX T iogonek -37\r\nKPX T o -95\r\nKPX T oacute -95\r\nKPX T ocircumflex -95\r\nKPX T odieresis -95\r\nKPX T ograve -95\r\nKPX T ohungarumlaut -95\r\nKPX T omacron -95\r\nKPX T oslash -95\r\nKPX T otilde -95\r\nKPX T period -92\r\nKPX T r -37\r\nKPX T racute -37\r\nKPX T rcaron -37\r\nKPX T rcommaaccent -37\r\nKPX T semicolon -74\r\nKPX T u -37\r\nKPX T uacute -37\r\nKPX T ucircumflex -37\r\nKPX T udieresis -37\r\nKPX T ugrave -37\r\nKPX T uhungarumlaut -37\r\nKPX T umacron -37\r\nKPX T uogonek -37\r\nKPX T uring -37\r\nKPX T w -37\r\nKPX T y -37\r\nKPX T yacute -37\r\nKPX T ydieresis -37\r\nKPX Tcaron A -55\r\nKPX Tcaron Aacute -55\r\nKPX Tcaron Abreve -55\r\nKPX Tcaron Acircumflex -55\r\nKPX Tcaron Adieresis -55\r\nKPX Tcaron Agrave -55\r\nKPX Tcaron Amacron -55\r\nKPX Tcaron Aogonek -55\r\nKPX Tcaron Aring -55\r\nKPX Tcaron Atilde -55\r\nKPX Tcaron O -18\r\nKPX Tcaron Oacute -18\r\nKPX Tcaron Ocircumflex -18\r\nKPX Tcaron Odieresis -18\r\nKPX Tcaron Ograve -18\r\nKPX Tcaron Ohungarumlaut -18\r\nKPX Tcaron Omacron -18\r\nKPX Tcaron Oslash -18\r\nKPX Tcaron Otilde -18\r\nKPX Tcaron a -92\r\nKPX Tcaron aacute -92\r\nKPX Tcaron abreve -92\r\nKPX Tcaron acircumflex -92\r\nKPX Tcaron adieresis -92\r\nKPX Tcaron agrave -92\r\nKPX Tcaron amacron -92\r\nKPX Tcaron aogonek -92\r\nKPX Tcaron aring -92\r\nKPX Tcaron atilde -92\r\nKPX Tcaron colon -74\r\nKPX Tcaron comma -92\r\nKPX Tcaron e -92\r\nKPX Tcaron eacute -92\r\nKPX Tcaron ecaron -92\r\nKPX Tcaron ecircumflex -92\r\nKPX Tcaron edieresis -52\r\nKPX Tcaron edotaccent -92\r\nKPX Tcaron egrave -52\r\nKPX Tcaron emacron -52\r\nKPX Tcaron eogonek -92\r\nKPX Tcaron hyphen -92\r\nKPX Tcaron i -37\r\nKPX Tcaron iacute -37\r\nKPX Tcaron iogonek -37\r\nKPX Tcaron o -95\r\nKPX Tcaron oacute -95\r\nKPX Tcaron ocircumflex -95\r\nKPX Tcaron odieresis -95\r\nKPX Tcaron ograve -95\r\nKPX Tcaron ohungarumlaut -95\r\nKPX Tcaron omacron -95\r\nKPX Tcaron oslash -95\r\nKPX Tcaron otilde -95\r\nKPX Tcaron period -92\r\nKPX Tcaron r -37\r\nKPX Tcaron racute -37\r\nKPX Tcaron rcaron -37\r\nKPX Tcaron rcommaaccent -37\r\nKPX Tcaron semicolon -74\r\nKPX Tcaron u -37\r\nKPX Tcaron uacute -37\r\nKPX Tcaron ucircumflex -37\r\nKPX Tcaron udieresis -37\r\nKPX Tcaron ugrave -37\r\nKPX Tcaron uhungarumlaut -37\r\nKPX Tcaron umacron -37\r\nKPX Tcaron uogonek -37\r\nKPX Tcaron uring -37\r\nKPX Tcaron w -37\r\nKPX Tcaron y -37\r\nKPX Tcaron yacute -37\r\nKPX Tcaron ydieresis -37\r\nKPX Tcommaaccent A -55\r\nKPX Tcommaaccent Aacute -55\r\nKPX Tcommaaccent Abreve -55\r\nKPX Tcommaaccent Acircumflex -55\r\nKPX Tcommaaccent Adieresis -55\r\nKPX Tcommaaccent Agrave -55\r\nKPX Tcommaaccent Amacron -55\r\nKPX Tcommaaccent Aogonek -55\r\nKPX Tcommaaccent Aring -55\r\nKPX Tcommaaccent Atilde -55\r\nKPX Tcommaaccent O -18\r\nKPX Tcommaaccent Oacute -18\r\nKPX Tcommaaccent Ocircumflex -18\r\nKPX Tcommaaccent Odieresis -18\r\nKPX Tcommaaccent Ograve -18\r\nKPX Tcommaaccent Ohungarumlaut -18\r\nKPX Tcommaaccent Omacron -18\r\nKPX Tcommaaccent Oslash -18\r\nKPX Tcommaaccent Otilde -18\r\nKPX Tcommaaccent a -92\r\nKPX Tcommaaccent aacute -92\r\nKPX Tcommaaccent abreve -92\r\nKPX Tcommaaccent acircumflex -92\r\nKPX Tcommaaccent adieresis -92\r\nKPX Tcommaaccent agrave -92\r\nKPX Tcommaaccent amacron -92\r\nKPX Tcommaaccent aogonek -92\r\nKPX Tcommaaccent aring -92\r\nKPX Tcommaaccent atilde -92\r\nKPX Tcommaaccent colon -74\r\nKPX Tcommaaccent comma -92\r\nKPX Tcommaaccent e -92\r\nKPX Tcommaaccent eacute -92\r\nKPX Tcommaaccent ecaron -92\r\nKPX Tcommaaccent ecircumflex -92\r\nKPX Tcommaaccent edieresis -52\r\nKPX Tcommaaccent edotaccent -92\r\nKPX Tcommaaccent egrave -52\r\nKPX Tcommaaccent emacron -52\r\nKPX Tcommaaccent eogonek -92\r\nKPX Tcommaaccent hyphen -92\r\nKPX Tcommaaccent i -37\r\nKPX Tcommaaccent iacute -37\r\nKPX Tcommaaccent iogonek -37\r\nKPX Tcommaaccent o -95\r\nKPX Tcommaaccent oacute -95\r\nKPX Tcommaaccent ocircumflex -95\r\nKPX Tcommaaccent odieresis -95\r\nKPX Tcommaaccent ograve -95\r\nKPX Tcommaaccent ohungarumlaut -95\r\nKPX Tcommaaccent omacron -95\r\nKPX Tcommaaccent oslash -95\r\nKPX Tcommaaccent otilde -95\r\nKPX Tcommaaccent period -92\r\nKPX Tcommaaccent r -37\r\nKPX Tcommaaccent racute -37\r\nKPX Tcommaaccent rcaron -37\r\nKPX Tcommaaccent rcommaaccent -37\r\nKPX Tcommaaccent semicolon -74\r\nKPX Tcommaaccent u -37\r\nKPX Tcommaaccent uacute -37\r\nKPX Tcommaaccent ucircumflex -37\r\nKPX Tcommaaccent udieresis -37\r\nKPX Tcommaaccent ugrave -37\r\nKPX Tcommaaccent uhungarumlaut -37\r\nKPX Tcommaaccent umacron -37\r\nKPX Tcommaaccent uogonek -37\r\nKPX Tcommaaccent uring -37\r\nKPX Tcommaaccent w -37\r\nKPX Tcommaaccent y -37\r\nKPX Tcommaaccent yacute -37\r\nKPX Tcommaaccent ydieresis -37\r\nKPX U A -45\r\nKPX U Aacute -45\r\nKPX U Abreve -45\r\nKPX U Acircumflex -45\r\nKPX U Adieresis -45\r\nKPX U Agrave -45\r\nKPX U Amacron -45\r\nKPX U Aogonek -45\r\nKPX U Aring -45\r\nKPX U Atilde -45\r\nKPX Uacute A -45\r\nKPX Uacute Aacute -45\r\nKPX Uacute Abreve -45\r\nKPX Uacute Acircumflex -45\r\nKPX Uacute Adieresis -45\r\nKPX Uacute Agrave -45\r\nKPX Uacute Amacron -45\r\nKPX Uacute Aogonek -45\r\nKPX Uacute Aring -45\r\nKPX Uacute Atilde -45\r\nKPX Ucircumflex A -45\r\nKPX Ucircumflex Aacute -45\r\nKPX Ucircumflex Abreve -45\r\nKPX Ucircumflex Acircumflex -45\r\nKPX Ucircumflex Adieresis -45\r\nKPX Ucircumflex Agrave -45\r\nKPX Ucircumflex Amacron -45\r\nKPX Ucircumflex Aogonek -45\r\nKPX Ucircumflex Aring -45\r\nKPX Ucircumflex Atilde -45\r\nKPX Udieresis A -45\r\nKPX Udieresis Aacute -45\r\nKPX Udieresis Abreve -45\r\nKPX Udieresis Acircumflex -45\r\nKPX Udieresis Adieresis -45\r\nKPX Udieresis Agrave -45\r\nKPX Udieresis Amacron -45\r\nKPX Udieresis Aogonek -45\r\nKPX Udieresis Aring -45\r\nKPX Udieresis Atilde -45\r\nKPX Ugrave A -45\r\nKPX Ugrave Aacute -45\r\nKPX Ugrave Abreve -45\r\nKPX Ugrave Acircumflex -45\r\nKPX Ugrave Adieresis -45\r\nKPX Ugrave Agrave -45\r\nKPX Ugrave Amacron -45\r\nKPX Ugrave Aogonek -45\r\nKPX Ugrave Aring -45\r\nKPX Ugrave Atilde -45\r\nKPX Uhungarumlaut A -45\r\nKPX Uhungarumlaut Aacute -45\r\nKPX Uhungarumlaut Abreve -45\r\nKPX Uhungarumlaut Acircumflex -45\r\nKPX Uhungarumlaut Adieresis -45\r\nKPX Uhungarumlaut Agrave -45\r\nKPX Uhungarumlaut Amacron -45\r\nKPX Uhungarumlaut Aogonek -45\r\nKPX Uhungarumlaut Aring -45\r\nKPX Uhungarumlaut Atilde -45\r\nKPX Umacron A -45\r\nKPX Umacron Aacute -45\r\nKPX Umacron Abreve -45\r\nKPX Umacron Acircumflex -45\r\nKPX Umacron Adieresis -45\r\nKPX Umacron Agrave -45\r\nKPX Umacron Amacron -45\r\nKPX Umacron Aogonek -45\r\nKPX Umacron Aring -45\r\nKPX Umacron Atilde -45\r\nKPX Uogonek A -45\r\nKPX Uogonek Aacute -45\r\nKPX Uogonek Abreve -45\r\nKPX Uogonek Acircumflex -45\r\nKPX Uogonek Adieresis -45\r\nKPX Uogonek Agrave -45\r\nKPX Uogonek Amacron -45\r\nKPX Uogonek Aogonek -45\r\nKPX Uogonek Aring -45\r\nKPX Uogonek Atilde -45\r\nKPX Uring A -45\r\nKPX Uring Aacute -45\r\nKPX Uring Abreve -45\r\nKPX Uring Acircumflex -45\r\nKPX Uring Adieresis -45\r\nKPX Uring Agrave -45\r\nKPX Uring Amacron -45\r\nKPX Uring Aogonek -45\r\nKPX Uring Aring -45\r\nKPX Uring Atilde -45\r\nKPX V A -85\r\nKPX V Aacute -85\r\nKPX V Abreve -85\r\nKPX V Acircumflex -85\r\nKPX V Adieresis -85\r\nKPX V Agrave -85\r\nKPX V Amacron -85\r\nKPX V Aogonek -85\r\nKPX V Aring -85\r\nKPX V Atilde -85\r\nKPX V G -10\r\nKPX V Gbreve -10\r\nKPX V Gcommaaccent -10\r\nKPX V O -30\r\nKPX V Oacute -30\r\nKPX V Ocircumflex -30\r\nKPX V Odieresis -30\r\nKPX V Ograve -30\r\nKPX V Ohungarumlaut -30\r\nKPX V Omacron -30\r\nKPX V Oslash -30\r\nKPX V Otilde -30\r\nKPX V a -111\r\nKPX V aacute -111\r\nKPX V abreve -111\r\nKPX V acircumflex -111\r\nKPX V adieresis -111\r\nKPX V agrave -111\r\nKPX V amacron -111\r\nKPX V aogonek -111\r\nKPX V aring -111\r\nKPX V atilde -111\r\nKPX V colon -74\r\nKPX V comma -129\r\nKPX V e -111\r\nKPX V eacute -111\r\nKPX V ecaron -111\r\nKPX V ecircumflex -111\r\nKPX V edieresis -71\r\nKPX V edotaccent -111\r\nKPX V egrave -71\r\nKPX V emacron -71\r\nKPX V eogonek -111\r\nKPX V hyphen -70\r\nKPX V i -55\r\nKPX V iacute -55\r\nKPX V iogonek -55\r\nKPX V o -111\r\nKPX V oacute -111\r\nKPX V ocircumflex -111\r\nKPX V odieresis -111\r\nKPX V ograve -111\r\nKPX V ohungarumlaut -111\r\nKPX V omacron -111\r\nKPX V oslash -111\r\nKPX V otilde -111\r\nKPX V period -129\r\nKPX V semicolon -74\r\nKPX V u -55\r\nKPX V uacute -55\r\nKPX V ucircumflex -55\r\nKPX V udieresis -55\r\nKPX V ugrave -55\r\nKPX V uhungarumlaut -55\r\nKPX V umacron -55\r\nKPX V uogonek -55\r\nKPX V uring -55\r\nKPX W A -74\r\nKPX W Aacute -74\r\nKPX W Abreve -74\r\nKPX W Acircumflex -74\r\nKPX W Adieresis -74\r\nKPX W Agrave -74\r\nKPX W Amacron -74\r\nKPX W Aogonek -74\r\nKPX W Aring -74\r\nKPX W Atilde -74\r\nKPX W O -15\r\nKPX W Oacute -15\r\nKPX W Ocircumflex -15\r\nKPX W Odieresis -15\r\nKPX W Ograve -15\r\nKPX W Ohungarumlaut -15\r\nKPX W Omacron -15\r\nKPX W Oslash -15\r\nKPX W Otilde -15\r\nKPX W a -85\r\nKPX W aacute -85\r\nKPX W abreve -85\r\nKPX W acircumflex -85\r\nKPX W adieresis -85\r\nKPX W agrave -85\r\nKPX W amacron -85\r\nKPX W aogonek -85\r\nKPX W aring -85\r\nKPX W atilde -85\r\nKPX W colon -55\r\nKPX W comma -74\r\nKPX W e -90\r\nKPX W eacute -90\r\nKPX W ecaron -90\r\nKPX W ecircumflex -90\r\nKPX W edieresis -50\r\nKPX W edotaccent -90\r\nKPX W egrave -50\r\nKPX W emacron -50\r\nKPX W eogonek -90\r\nKPX W hyphen -50\r\nKPX W i -37\r\nKPX W iacute -37\r\nKPX W iogonek -37\r\nKPX W o -80\r\nKPX W oacute -80\r\nKPX W ocircumflex -80\r\nKPX W odieresis -80\r\nKPX W ograve -80\r\nKPX W ohungarumlaut -80\r\nKPX W omacron -80\r\nKPX W oslash -80\r\nKPX W otilde -80\r\nKPX W period -74\r\nKPX W semicolon -55\r\nKPX W u -55\r\nKPX W uacute -55\r\nKPX W ucircumflex -55\r\nKPX W udieresis -55\r\nKPX W ugrave -55\r\nKPX W uhungarumlaut -55\r\nKPX W umacron -55\r\nKPX W uogonek -55\r\nKPX W uring -55\r\nKPX W y -55\r\nKPX W yacute -55\r\nKPX W ydieresis -55\r\nKPX Y A -74\r\nKPX Y Aacute -74\r\nKPX Y Abreve -74\r\nKPX Y Acircumflex -74\r\nKPX Y Adieresis -74\r\nKPX Y Agrave -74\r\nKPX Y Amacron -74\r\nKPX Y Aogonek -74\r\nKPX Y Aring -74\r\nKPX Y Atilde -74\r\nKPX Y O -25\r\nKPX Y Oacute -25\r\nKPX Y Ocircumflex -25\r\nKPX Y Odieresis -25\r\nKPX Y Ograve -25\r\nKPX Y Ohungarumlaut -25\r\nKPX Y Omacron -25\r\nKPX Y Oslash -25\r\nKPX Y Otilde -25\r\nKPX Y a -92\r\nKPX Y aacute -92\r\nKPX Y abreve -92\r\nKPX Y acircumflex -92\r\nKPX Y adieresis -92\r\nKPX Y agrave -92\r\nKPX Y amacron -92\r\nKPX Y aogonek -92\r\nKPX Y aring -92\r\nKPX Y atilde -92\r\nKPX Y colon -92\r\nKPX Y comma -92\r\nKPX Y e -111\r\nKPX Y eacute -111\r\nKPX Y ecaron -111\r\nKPX Y ecircumflex -71\r\nKPX Y edieresis -71\r\nKPX Y edotaccent -111\r\nKPX Y egrave -71\r\nKPX Y emacron -71\r\nKPX Y eogonek -111\r\nKPX Y hyphen -92\r\nKPX Y i -55\r\nKPX Y iacute -55\r\nKPX Y iogonek -55\r\nKPX Y o -111\r\nKPX Y oacute -111\r\nKPX Y ocircumflex -111\r\nKPX Y odieresis -111\r\nKPX Y ograve -111\r\nKPX Y ohungarumlaut -111\r\nKPX Y omacron -111\r\nKPX Y oslash -111\r\nKPX Y otilde -111\r\nKPX Y period -74\r\nKPX Y semicolon -92\r\nKPX Y u -92\r\nKPX Y uacute -92\r\nKPX Y ucircumflex -92\r\nKPX Y udieresis -92\r\nKPX Y ugrave -92\r\nKPX Y uhungarumlaut -92\r\nKPX Y umacron -92\r\nKPX Y uogonek -92\r\nKPX Y uring -92\r\nKPX Yacute A -74\r\nKPX Yacute Aacute -74\r\nKPX Yacute Abreve -74\r\nKPX Yacute Acircumflex -74\r\nKPX Yacute Adieresis -74\r\nKPX Yacute Agrave -74\r\nKPX Yacute Amacron -74\r\nKPX Yacute Aogonek -74\r\nKPX Yacute Aring -74\r\nKPX Yacute Atilde -74\r\nKPX Yacute O -25\r\nKPX Yacute Oacute -25\r\nKPX Yacute Ocircumflex -25\r\nKPX Yacute Odieresis -25\r\nKPX Yacute Ograve -25\r\nKPX Yacute Ohungarumlaut -25\r\nKPX Yacute Omacron -25\r\nKPX Yacute Oslash -25\r\nKPX Yacute Otilde -25\r\nKPX Yacute a -92\r\nKPX Yacute aacute -92\r\nKPX Yacute abreve -92\r\nKPX Yacute acircumflex -92\r\nKPX Yacute adieresis -92\r\nKPX Yacute agrave -92\r\nKPX Yacute amacron -92\r\nKPX Yacute aogonek -92\r\nKPX Yacute aring -92\r\nKPX Yacute atilde -92\r\nKPX Yacute colon -92\r\nKPX Yacute comma -92\r\nKPX Yacute e -111\r\nKPX Yacute eacute -111\r\nKPX Yacute ecaron -111\r\nKPX Yacute ecircumflex -71\r\nKPX Yacute edieresis -71\r\nKPX Yacute edotaccent -111\r\nKPX Yacute egrave -71\r\nKPX Yacute emacron -71\r\nKPX Yacute eogonek -111\r\nKPX Yacute hyphen -92\r\nKPX Yacute i -55\r\nKPX Yacute iacute -55\r\nKPX Yacute iogonek -55\r\nKPX Yacute o -111\r\nKPX Yacute oacute -111\r\nKPX Yacute ocircumflex -111\r\nKPX Yacute odieresis -111\r\nKPX Yacute ograve -111\r\nKPX Yacute ohungarumlaut -111\r\nKPX Yacute omacron -111\r\nKPX Yacute oslash -111\r\nKPX Yacute otilde -111\r\nKPX Yacute period -74\r\nKPX Yacute semicolon -92\r\nKPX Yacute u -92\r\nKPX Yacute uacute -92\r\nKPX Yacute ucircumflex -92\r\nKPX Yacute udieresis -92\r\nKPX Yacute ugrave -92\r\nKPX Yacute uhungarumlaut -92\r\nKPX Yacute umacron -92\r\nKPX Yacute uogonek -92\r\nKPX Yacute uring -92\r\nKPX Ydieresis A -74\r\nKPX Ydieresis Aacute -74\r\nKPX Ydieresis Abreve -74\r\nKPX Ydieresis Acircumflex -74\r\nKPX Ydieresis Adieresis -74\r\nKPX Ydieresis Agrave -74\r\nKPX Ydieresis Amacron -74\r\nKPX Ydieresis Aogonek -74\r\nKPX Ydieresis Aring -74\r\nKPX Ydieresis Atilde -74\r\nKPX Ydieresis O -25\r\nKPX Ydieresis Oacute -25\r\nKPX Ydieresis Ocircumflex -25\r\nKPX Ydieresis Odieresis -25\r\nKPX Ydieresis Ograve -25\r\nKPX Ydieresis Ohungarumlaut -25\r\nKPX Ydieresis Omacron -25\r\nKPX Ydieresis Oslash -25\r\nKPX Ydieresis Otilde -25\r\nKPX Ydieresis a -92\r\nKPX Ydieresis aacute -92\r\nKPX Ydieresis abreve -92\r\nKPX Ydieresis acircumflex -92\r\nKPX Ydieresis adieresis -92\r\nKPX Ydieresis agrave -92\r\nKPX Ydieresis amacron -92\r\nKPX Ydieresis aogonek -92\r\nKPX Ydieresis aring -92\r\nKPX Ydieresis atilde -92\r\nKPX Ydieresis colon -92\r\nKPX Ydieresis comma -92\r\nKPX Ydieresis e -111\r\nKPX Ydieresis eacute -111\r\nKPX Ydieresis ecaron -111\r\nKPX Ydieresis ecircumflex -71\r\nKPX Ydieresis edieresis -71\r\nKPX Ydieresis edotaccent -111\r\nKPX Ydieresis egrave -71\r\nKPX Ydieresis emacron -71\r\nKPX Ydieresis eogonek -111\r\nKPX Ydieresis hyphen -92\r\nKPX Ydieresis i -55\r\nKPX Ydieresis iacute -55\r\nKPX Ydieresis iogonek -55\r\nKPX Ydieresis o -111\r\nKPX Ydieresis oacute -111\r\nKPX Ydieresis ocircumflex -111\r\nKPX Ydieresis odieresis -111\r\nKPX Ydieresis ograve -111\r\nKPX Ydieresis ohungarumlaut -111\r\nKPX Ydieresis omacron -111\r\nKPX Ydieresis oslash -111\r\nKPX Ydieresis otilde -111\r\nKPX Ydieresis period -74\r\nKPX Ydieresis semicolon -92\r\nKPX Ydieresis u -92\r\nKPX Ydieresis uacute -92\r\nKPX Ydieresis ucircumflex -92\r\nKPX Ydieresis udieresis -92\r\nKPX Ydieresis ugrave -92\r\nKPX Ydieresis uhungarumlaut -92\r\nKPX Ydieresis umacron -92\r\nKPX Ydieresis uogonek -92\r\nKPX Ydieresis uring -92\r\nKPX b b -10\r\nKPX b period -40\r\nKPX b u -20\r\nKPX b uacute -20\r\nKPX b ucircumflex -20\r\nKPX b udieresis -20\r\nKPX b ugrave -20\r\nKPX b uhungarumlaut -20\r\nKPX b umacron -20\r\nKPX b uogonek -20\r\nKPX b uring -20\r\nKPX c h -10\r\nKPX c k -10\r\nKPX c kcommaaccent -10\r\nKPX cacute h -10\r\nKPX cacute k -10\r\nKPX cacute kcommaaccent -10\r\nKPX ccaron h -10\r\nKPX ccaron k -10\r\nKPX ccaron kcommaaccent -10\r\nKPX ccedilla h -10\r\nKPX ccedilla k -10\r\nKPX ccedilla kcommaaccent -10\r\nKPX comma quotedblright -95\r\nKPX comma quoteright -95\r\nKPX e b -10\r\nKPX eacute b -10\r\nKPX ecaron b -10\r\nKPX ecircumflex b -10\r\nKPX edieresis b -10\r\nKPX edotaccent b -10\r\nKPX egrave b -10\r\nKPX emacron b -10\r\nKPX eogonek b -10\r\nKPX f comma -10\r\nKPX f dotlessi -30\r\nKPX f e -10\r\nKPX f eacute -10\r\nKPX f edotaccent -10\r\nKPX f eogonek -10\r\nKPX f f -18\r\nKPX f o -10\r\nKPX f oacute -10\r\nKPX f ocircumflex -10\r\nKPX f ograve -10\r\nKPX f ohungarumlaut -10\r\nKPX f oslash -10\r\nKPX f otilde -10\r\nKPX f period -10\r\nKPX f quoteright 55\r\nKPX k e -30\r\nKPX k eacute -30\r\nKPX k ecaron -30\r\nKPX k ecircumflex -30\r\nKPX k edieresis -30\r\nKPX k edotaccent -30\r\nKPX k egrave -30\r\nKPX k emacron -30\r\nKPX k eogonek -30\r\nKPX k o -10\r\nKPX k oacute -10\r\nKPX k ocircumflex -10\r\nKPX k odieresis -10\r\nKPX k ograve -10\r\nKPX k ohungarumlaut -10\r\nKPX k omacron -10\r\nKPX k oslash -10\r\nKPX k otilde -10\r\nKPX kcommaaccent e -30\r\nKPX kcommaaccent eacute -30\r\nKPX kcommaaccent ecaron -30\r\nKPX kcommaaccent ecircumflex -30\r\nKPX kcommaaccent edieresis -30\r\nKPX kcommaaccent edotaccent -30\r\nKPX kcommaaccent egrave -30\r\nKPX kcommaaccent emacron -30\r\nKPX kcommaaccent eogonek -30\r\nKPX kcommaaccent o -10\r\nKPX kcommaaccent oacute -10\r\nKPX kcommaaccent ocircumflex -10\r\nKPX kcommaaccent odieresis -10\r\nKPX kcommaaccent ograve -10\r\nKPX kcommaaccent ohungarumlaut -10\r\nKPX kcommaaccent omacron -10\r\nKPX kcommaaccent oslash -10\r\nKPX kcommaaccent otilde -10\r\nKPX n v -40\r\nKPX nacute v -40\r\nKPX ncaron v -40\r\nKPX ncommaaccent v -40\r\nKPX ntilde v -40\r\nKPX o v -15\r\nKPX o w -25\r\nKPX o x -10\r\nKPX o y -10\r\nKPX o yacute -10\r\nKPX o ydieresis -10\r\nKPX oacute v -15\r\nKPX oacute w -25\r\nKPX oacute x -10\r\nKPX oacute y -10\r\nKPX oacute yacute -10\r\nKPX oacute ydieresis -10\r\nKPX ocircumflex v -15\r\nKPX ocircumflex w -25\r\nKPX ocircumflex x -10\r\nKPX ocircumflex y -10\r\nKPX ocircumflex yacute -10\r\nKPX ocircumflex ydieresis -10\r\nKPX odieresis v -15\r\nKPX odieresis w -25\r\nKPX odieresis x -10\r\nKPX odieresis y -10\r\nKPX odieresis yacute -10\r\nKPX odieresis ydieresis -10\r\nKPX ograve v -15\r\nKPX ograve w -25\r\nKPX ograve x -10\r\nKPX ograve y -10\r\nKPX ograve yacute -10\r\nKPX ograve ydieresis -10\r\nKPX ohungarumlaut v -15\r\nKPX ohungarumlaut w -25\r\nKPX ohungarumlaut x -10\r\nKPX ohungarumlaut y -10\r\nKPX ohungarumlaut yacute -10\r\nKPX ohungarumlaut ydieresis -10\r\nKPX omacron v -15\r\nKPX omacron w -25\r\nKPX omacron x -10\r\nKPX omacron y -10\r\nKPX omacron yacute -10\r\nKPX omacron ydieresis -10\r\nKPX oslash v -15\r\nKPX oslash w -25\r\nKPX oslash x -10\r\nKPX oslash y -10\r\nKPX oslash yacute -10\r\nKPX oslash ydieresis -10\r\nKPX otilde v -15\r\nKPX otilde w -25\r\nKPX otilde x -10\r\nKPX otilde y -10\r\nKPX otilde yacute -10\r\nKPX otilde ydieresis -10\r\nKPX period quotedblright -95\r\nKPX period quoteright -95\r\nKPX quoteleft quoteleft -74\r\nKPX quoteright d -15\r\nKPX quoteright dcroat -15\r\nKPX quoteright quoteright -74\r\nKPX quoteright r -15\r\nKPX quoteright racute -15\r\nKPX quoteright rcaron -15\r\nKPX quoteright rcommaaccent -15\r\nKPX quoteright s -74\r\nKPX quoteright sacute -74\r\nKPX quoteright scaron -74\r\nKPX quoteright scedilla -74\r\nKPX quoteright scommaaccent -74\r\nKPX quoteright space -74\r\nKPX quoteright t -37\r\nKPX quoteright tcommaaccent -37\r\nKPX quoteright v -15\r\nKPX r comma -65\r\nKPX r period -65\r\nKPX racute comma -65\r\nKPX racute period -65\r\nKPX rcaron comma -65\r\nKPX rcaron period -65\r\nKPX rcommaaccent comma -65\r\nKPX rcommaaccent period -65\r\nKPX space A -37\r\nKPX space Aacute -37\r\nKPX space Abreve -37\r\nKPX space Acircumflex -37\r\nKPX space Adieresis -37\r\nKPX space Agrave -37\r\nKPX space Amacron -37\r\nKPX space Aogonek -37\r\nKPX space Aring -37\r\nKPX space Atilde -37\r\nKPX space V -70\r\nKPX space W -70\r\nKPX space Y -70\r\nKPX space Yacute -70\r\nKPX space Ydieresis -70\r\nKPX v comma -37\r\nKPX v e -15\r\nKPX v eacute -15\r\nKPX v ecaron -15\r\nKPX v ecircumflex -15\r\nKPX v edieresis -15\r\nKPX v edotaccent -15\r\nKPX v egrave -15\r\nKPX v emacron -15\r\nKPX v eogonek -15\r\nKPX v o -15\r\nKPX v oacute -15\r\nKPX v ocircumflex -15\r\nKPX v odieresis -15\r\nKPX v ograve -15\r\nKPX v ohungarumlaut -15\r\nKPX v omacron -15\r\nKPX v oslash -15\r\nKPX v otilde -15\r\nKPX v period -37\r\nKPX w a -10\r\nKPX w aacute -10\r\nKPX w abreve -10\r\nKPX w acircumflex -10\r\nKPX w adieresis -10\r\nKPX w agrave -10\r\nKPX w amacron -10\r\nKPX w aogonek -10\r\nKPX w aring -10\r\nKPX w atilde -10\r\nKPX w comma -37\r\nKPX w e -10\r\nKPX w eacute -10\r\nKPX w ecaron -10\r\nKPX w ecircumflex -10\r\nKPX w edieresis -10\r\nKPX w edotaccent -10\r\nKPX w egrave -10\r\nKPX w emacron -10\r\nKPX w eogonek -10\r\nKPX w o -15\r\nKPX w oacute -15\r\nKPX w ocircumflex -15\r\nKPX w odieresis -15\r\nKPX w ograve -15\r\nKPX w ohungarumlaut -15\r\nKPX w omacron -15\r\nKPX w oslash -15\r\nKPX w otilde -15\r\nKPX w period -37\r\nKPX x e -10\r\nKPX x eacute -10\r\nKPX x ecaron -10\r\nKPX x ecircumflex -10\r\nKPX x edieresis -10\r\nKPX x edotaccent -10\r\nKPX x egrave -10\r\nKPX x emacron -10\r\nKPX x eogonek -10\r\nKPX y comma -37\r\nKPX y period -37\r\nKPX yacute comma -37\r\nKPX yacute period -37\r\nKPX ydieresis comma -37\r\nKPX ydieresis period -37\r\nEndKernPairs\r\nEndKernData\r\nEndFontMetrics\r\n";
  },
  Symbol() {
    return "StartFontMetrics 4.1\r\nComment Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated. All rights reserved.\r\nComment Creation Date: Thu May  1 15:12:25 1997\r\nComment UniqueID 43064\r\nComment VMusage 30820 39997\r\nFontName Symbol\r\nFullName Symbol\r\nFamilyName Symbol\r\nWeight Medium\r\nItalicAngle 0\r\nIsFixedPitch false\r\nCharacterSet Special\r\nFontBBox -180 -293 1090 1010 \r\nUnderlinePosition -100\r\nUnderlineThickness 50\r\nVersion 001.008\r\nNotice Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated. All rights reserved.\r\nEncodingScheme FontSpecific\r\nStdHW 92\r\nStdVW 85\r\nStartCharMetrics 190\r\nC 32 ; WX 250 ; N space ; B 0 0 0 0 ;\r\nC 33 ; WX 333 ; N exclam ; B 128 -17 240 672 ;\r\nC 34 ; WX 713 ; N universal ; B 31 0 681 705 ;\r\nC 35 ; WX 500 ; N numbersign ; B 20 -16 481 673 ;\r\nC 36 ; WX 549 ; N existential ; B 25 0 478 707 ;\r\nC 37 ; WX 833 ; N percent ; B 63 -36 771 655 ;\r\nC 38 ; WX 778 ; N ampersand ; B 41 -18 750 661 ;\r\nC 39 ; WX 439 ; N suchthat ; B 48 -17 414 500 ;\r\nC 40 ; WX 333 ; N parenleft ; B 53 -191 300 673 ;\r\nC 41 ; WX 333 ; N parenright ; B 30 -191 277 673 ;\r\nC 42 ; WX 500 ; N asteriskmath ; B 65 134 427 551 ;\r\nC 43 ; WX 549 ; N plus ; B 10 0 539 533 ;\r\nC 44 ; WX 250 ; N comma ; B 56 -152 194 104 ;\r\nC 45 ; WX 549 ; N minus ; B 11 233 535 288 ;\r\nC 46 ; WX 250 ; N period ; B 69 -17 181 95 ;\r\nC 47 ; WX 278 ; N slash ; B 0 -18 254 646 ;\r\nC 48 ; WX 500 ; N zero ; B 24 -14 476 685 ;\r\nC 49 ; WX 500 ; N one ; B 117 0 390 673 ;\r\nC 50 ; WX 500 ; N two ; B 25 0 475 685 ;\r\nC 51 ; WX 500 ; N three ; B 43 -14 435 685 ;\r\nC 52 ; WX 500 ; N four ; B 15 0 469 685 ;\r\nC 53 ; WX 500 ; N five ; B 32 -14 445 690 ;\r\nC 54 ; WX 500 ; N six ; B 34 -14 468 685 ;\r\nC 55 ; WX 500 ; N seven ; B 24 -16 448 673 ;\r\nC 56 ; WX 500 ; N eight ; B 56 -14 445 685 ;\r\nC 57 ; WX 500 ; N nine ; B 30 -18 459 685 ;\r\nC 58 ; WX 278 ; N colon ; B 81 -17 193 460 ;\r\nC 59 ; WX 278 ; N semicolon ; B 83 -152 221 460 ;\r\nC 60 ; WX 549 ; N less ; B 26 0 523 522 ;\r\nC 61 ; WX 549 ; N equal ; B 11 141 537 390 ;\r\nC 62 ; WX 549 ; N greater ; B 26 0 523 522 ;\r\nC 63 ; WX 444 ; N question ; B 70 -17 412 686 ;\r\nC 64 ; WX 549 ; N congruent ; B 11 0 537 475 ;\r\nC 65 ; WX 722 ; N Alpha ; B 4 0 684 673 ;\r\nC 66 ; WX 667 ; N Beta ; B 29 0 592 673 ;\r\nC 67 ; WX 722 ; N Chi ; B -9 0 704 673 ;\r\nC 68 ; WX 612 ; N Delta ; B 6 0 608 688 ;\r\nC 69 ; WX 611 ; N Epsilon ; B 32 0 617 673 ;\r\nC 70 ; WX 763 ; N Phi ; B 26 0 741 673 ;\r\nC 71 ; WX 603 ; N Gamma ; B 24 0 609 673 ;\r\nC 72 ; WX 722 ; N Eta ; B 39 0 729 673 ;\r\nC 73 ; WX 333 ; N Iota ; B 32 0 316 673 ;\r\nC 74 ; WX 631 ; N theta1 ; B 18 -18 623 689 ;\r\nC 75 ; WX 722 ; N Kappa ; B 35 0 722 673 ;\r\nC 76 ; WX 686 ; N Lambda ; B 6 0 680 688 ;\r\nC 77 ; WX 889 ; N Mu ; B 28 0 887 673 ;\r\nC 78 ; WX 722 ; N Nu ; B 29 -8 720 673 ;\r\nC 79 ; WX 722 ; N Omicron ; B 41 -17 715 685 ;\r\nC 80 ; WX 768 ; N Pi ; B 25 0 745 673 ;\r\nC 81 ; WX 741 ; N Theta ; B 41 -17 715 685 ;\r\nC 82 ; WX 556 ; N Rho ; B 28 0 563 673 ;\r\nC 83 ; WX 592 ; N Sigma ; B 5 0 589 673 ;\r\nC 84 ; WX 611 ; N Tau ; B 33 0 607 673 ;\r\nC 85 ; WX 690 ; N Upsilon ; B -8 0 694 673 ;\r\nC 86 ; WX 439 ; N sigma1 ; B 40 -233 436 500 ;\r\nC 87 ; WX 768 ; N Omega ; B 34 0 736 688 ;\r\nC 88 ; WX 645 ; N Xi ; B 40 0 599 673 ;\r\nC 89 ; WX 795 ; N Psi ; B 15 0 781 684 ;\r\nC 90 ; WX 611 ; N Zeta ; B 44 0 636 673 ;\r\nC 91 ; WX 333 ; N bracketleft ; B 86 -155 299 674 ;\r\nC 92 ; WX 863 ; N therefore ; B 163 0 701 487 ;\r\nC 93 ; WX 333 ; N bracketright ; B 33 -155 246 674 ;\r\nC 94 ; WX 658 ; N perpendicular ; B 15 0 652 674 ;\r\nC 95 ; WX 500 ; N underscore ; B -2 -125 502 -75 ;\r\nC 96 ; WX 500 ; N radicalex ; B 480 881 1090 917 ;\r\nC 97 ; WX 631 ; N alpha ; B 41 -18 622 500 ;\r\nC 98 ; WX 549 ; N beta ; B 61 -223 515 741 ;\r\nC 99 ; WX 549 ; N chi ; B 12 -231 522 499 ;\r\nC 100 ; WX 494 ; N delta ; B 40 -19 481 740 ;\r\nC 101 ; WX 439 ; N epsilon ; B 22 -19 427 502 ;\r\nC 102 ; WX 521 ; N phi ; B 28 -224 492 673 ;\r\nC 103 ; WX 411 ; N gamma ; B 5 -225 484 499 ;\r\nC 104 ; WX 603 ; N eta ; B 0 -202 527 514 ;\r\nC 105 ; WX 329 ; N iota ; B 0 -17 301 503 ;\r\nC 106 ; WX 603 ; N phi1 ; B 36 -224 587 499 ;\r\nC 107 ; WX 549 ; N kappa ; B 33 0 558 501 ;\r\nC 108 ; WX 549 ; N lambda ; B 24 -17 548 739 ;\r\nC 109 ; WX 576 ; N mu ; B 33 -223 567 500 ;\r\nC 110 ; WX 521 ; N nu ; B -9 -16 475 507 ;\r\nC 111 ; WX 549 ; N omicron ; B 35 -19 501 499 ;\r\nC 112 ; WX 549 ; N pi ; B 10 -19 530 487 ;\r\nC 113 ; WX 521 ; N theta ; B 43 -17 485 690 ;\r\nC 114 ; WX 549 ; N rho ; B 50 -230 490 499 ;\r\nC 115 ; WX 603 ; N sigma ; B 30 -21 588 500 ;\r\nC 116 ; WX 439 ; N tau ; B 10 -19 418 500 ;\r\nC 117 ; WX 576 ; N upsilon ; B 7 -18 535 507 ;\r\nC 118 ; WX 713 ; N omega1 ; B 12 -18 671 583 ;\r\nC 119 ; WX 686 ; N omega ; B 42 -17 684 500 ;\r\nC 120 ; WX 493 ; N xi ; B 27 -224 469 766 ;\r\nC 121 ; WX 686 ; N psi ; B 12 -228 701 500 ;\r\nC 122 ; WX 494 ; N zeta ; B 60 -225 467 756 ;\r\nC 123 ; WX 480 ; N braceleft ; B 58 -183 397 673 ;\r\nC 124 ; WX 200 ; N bar ; B 65 -293 135 707 ;\r\nC 125 ; WX 480 ; N braceright ; B 79 -183 418 673 ;\r\nC 126 ; WX 549 ; N similar ; B 17 203 529 307 ;\r\nC 160 ; WX 750 ; N Euro ; B 20 -12 714 685 ;\r\nC 161 ; WX 620 ; N Upsilon1 ; B -2 0 610 685 ;\r\nC 162 ; WX 247 ; N minute ; B 27 459 228 735 ;\r\nC 163 ; WX 549 ; N lessequal ; B 29 0 526 639 ;\r\nC 164 ; WX 167 ; N fraction ; B -180 -12 340 677 ;\r\nC 165 ; WX 713 ; N infinity ; B 26 124 688 404 ;\r\nC 166 ; WX 500 ; N florin ; B 2 -193 494 686 ;\r\nC 167 ; WX 753 ; N club ; B 86 -26 660 533 ;\r\nC 168 ; WX 753 ; N diamond ; B 142 -36 600 550 ;\r\nC 169 ; WX 753 ; N heart ; B 117 -33 631 532 ;\r\nC 170 ; WX 753 ; N spade ; B 113 -36 629 548 ;\r\nC 171 ; WX 1042 ; N arrowboth ; B 24 -15 1024 511 ;\r\nC 172 ; WX 987 ; N arrowleft ; B 32 -15 942 511 ;\r\nC 173 ; WX 603 ; N arrowup ; B 45 0 571 910 ;\r\nC 174 ; WX 987 ; N arrowright ; B 49 -15 959 511 ;\r\nC 175 ; WX 603 ; N arrowdown ; B 45 -22 571 888 ;\r\nC 176 ; WX 400 ; N degree ; B 50 385 350 685 ;\r\nC 177 ; WX 549 ; N plusminus ; B 10 0 539 645 ;\r\nC 178 ; WX 411 ; N second ; B 20 459 413 737 ;\r\nC 179 ; WX 549 ; N greaterequal ; B 29 0 526 639 ;\r\nC 180 ; WX 549 ; N multiply ; B 17 8 533 524 ;\r\nC 181 ; WX 713 ; N proportional ; B 27 123 639 404 ;\r\nC 182 ; WX 494 ; N partialdiff ; B 26 -20 462 746 ;\r\nC 183 ; WX 460 ; N bullet ; B 50 113 410 473 ;\r\nC 184 ; WX 549 ; N divide ; B 10 71 536 456 ;\r\nC 185 ; WX 549 ; N notequal ; B 15 -25 540 549 ;\r\nC 186 ; WX 549 ; N equivalence ; B 14 82 538 443 ;\r\nC 187 ; WX 549 ; N approxequal ; B 14 135 527 394 ;\r\nC 188 ; WX 1000 ; N ellipsis ; B 111 -17 889 95 ;\r\nC 189 ; WX 603 ; N arrowvertex ; B 280 -120 336 1010 ;\r\nC 190 ; WX 1000 ; N arrowhorizex ; B -60 220 1050 276 ;\r\nC 191 ; WX 658 ; N carriagereturn ; B 15 -16 602 629 ;\r\nC 192 ; WX 823 ; N aleph ; B 175 -18 661 658 ;\r\nC 193 ; WX 686 ; N Ifraktur ; B 10 -53 578 740 ;\r\nC 194 ; WX 795 ; N Rfraktur ; B 26 -15 759 734 ;\r\nC 195 ; WX 987 ; N weierstrass ; B 159 -211 870 573 ;\r\nC 196 ; WX 768 ; N circlemultiply ; B 43 -17 733 673 ;\r\nC 197 ; WX 768 ; N circleplus ; B 43 -15 733 675 ;\r\nC 198 ; WX 823 ; N emptyset ; B 39 -24 781 719 ;\r\nC 199 ; WX 768 ; N intersection ; B 40 0 732 509 ;\r\nC 200 ; WX 768 ; N union ; B 40 -17 732 492 ;\r\nC 201 ; WX 713 ; N propersuperset ; B 20 0 673 470 ;\r\nC 202 ; WX 713 ; N reflexsuperset ; B 20 -125 673 470 ;\r\nC 203 ; WX 713 ; N notsubset ; B 36 -70 690 540 ;\r\nC 204 ; WX 713 ; N propersubset ; B 37 0 690 470 ;\r\nC 205 ; WX 713 ; N reflexsubset ; B 37 -125 690 470 ;\r\nC 206 ; WX 713 ; N element ; B 45 0 505 468 ;\r\nC 207 ; WX 713 ; N notelement ; B 45 -58 505 555 ;\r\nC 208 ; WX 768 ; N angle ; B 26 0 738 673 ;\r\nC 209 ; WX 713 ; N gradient ; B 36 -19 681 718 ;\r\nC 210 ; WX 790 ; N registerserif ; B 50 -17 740 673 ;\r\nC 211 ; WX 790 ; N copyrightserif ; B 51 -15 741 675 ;\r\nC 212 ; WX 890 ; N trademarkserif ; B 18 293 855 673 ;\r\nC 213 ; WX 823 ; N product ; B 25 -101 803 751 ;\r\nC 214 ; WX 549 ; N radical ; B 10 -38 515 917 ;\r\nC 215 ; WX 250 ; N dotmath ; B 69 210 169 310 ;\r\nC 216 ; WX 713 ; N logicalnot ; B 15 0 680 288 ;\r\nC 217 ; WX 603 ; N logicaland ; B 23 0 583 454 ;\r\nC 218 ; WX 603 ; N logicalor ; B 30 0 578 477 ;\r\nC 219 ; WX 1042 ; N arrowdblboth ; B 27 -20 1023 510 ;\r\nC 220 ; WX 987 ; N arrowdblleft ; B 30 -15 939 513 ;\r\nC 221 ; WX 603 ; N arrowdblup ; B 39 2 567 911 ;\r\nC 222 ; WX 987 ; N arrowdblright ; B 45 -20 954 508 ;\r\nC 223 ; WX 603 ; N arrowdbldown ; B 44 -19 572 890 ;\r\nC 224 ; WX 494 ; N lozenge ; B 18 0 466 745 ;\r\nC 225 ; WX 329 ; N angleleft ; B 25 -198 306 746 ;\r\nC 226 ; WX 790 ; N registersans ; B 50 -20 740 670 ;\r\nC 227 ; WX 790 ; N copyrightsans ; B 49 -15 739 675 ;\r\nC 228 ; WX 786 ; N trademarksans ; B 5 293 725 673 ;\r\nC 229 ; WX 713 ; N summation ; B 14 -108 695 752 ;\r\nC 230 ; WX 384 ; N parenlefttp ; B 24 -293 436 926 ;\r\nC 231 ; WX 384 ; N parenleftex ; B 24 -85 108 925 ;\r\nC 232 ; WX 384 ; N parenleftbt ; B 24 -293 436 926 ;\r\nC 233 ; WX 384 ; N bracketlefttp ; B 0 -80 349 926 ;\r\nC 234 ; WX 384 ; N bracketleftex ; B 0 -79 77 925 ;\r\nC 235 ; WX 384 ; N bracketleftbt ; B 0 -80 349 926 ;\r\nC 236 ; WX 494 ; N bracelefttp ; B 209 -85 445 925 ;\r\nC 237 ; WX 494 ; N braceleftmid ; B 20 -85 284 935 ;\r\nC 238 ; WX 494 ; N braceleftbt ; B 209 -75 445 935 ;\r\nC 239 ; WX 494 ; N braceex ; B 209 -85 284 935 ;\r\nC 241 ; WX 329 ; N angleright ; B 21 -198 302 746 ;\r\nC 242 ; WX 274 ; N integral ; B 2 -107 291 916 ;\r\nC 243 ; WX 686 ; N integraltp ; B 308 -88 675 920 ;\r\nC 244 ; WX 686 ; N integralex ; B 308 -88 378 975 ;\r\nC 245 ; WX 686 ; N integralbt ; B 11 -87 378 921 ;\r\nC 246 ; WX 384 ; N parenrighttp ; B 54 -293 466 926 ;\r\nC 247 ; WX 384 ; N parenrightex ; B 382 -85 466 925 ;\r\nC 248 ; WX 384 ; N parenrightbt ; B 54 -293 466 926 ;\r\nC 249 ; WX 384 ; N bracketrighttp ; B 22 -80 371 926 ;\r\nC 250 ; WX 384 ; N bracketrightex ; B 294 -79 371 925 ;\r\nC 251 ; WX 384 ; N bracketrightbt ; B 22 -80 371 926 ;\r\nC 252 ; WX 494 ; N bracerighttp ; B 48 -85 284 925 ;\r\nC 253 ; WX 494 ; N bracerightmid ; B 209 -85 473 935 ;\r\nC 254 ; WX 494 ; N bracerightbt ; B 48 -75 284 935 ;\r\nC -1 ; WX 790 ; N apple ; B 56 -3 733 808 ;\r\nEndCharMetrics\r\nEndFontMetrics\r\n";
  },
  ZapfDingbats() {
    return "StartFontMetrics 4.1\r\nComment Copyright (c) 1985, 1987, 1988, 1989, 1997 Adobe Systems Incorporated. All Rights Reserved.\r\nComment Creation Date: Thu May  1 15:14:13 1997\r\nComment UniqueID 43082\r\nComment VMusage 45775 55535\r\nFontName ZapfDingbats\r\nFullName ITC Zapf Dingbats\r\nFamilyName ZapfDingbats\r\nWeight Medium\r\nItalicAngle 0\r\nIsFixedPitch false\r\nCharacterSet Special\r\nFontBBox -1 -143 981 820 \r\nUnderlinePosition -100\r\nUnderlineThickness 50\r\nVersion 002.000\r\nNotice Copyright (c) 1985, 1987, 1988, 1989, 1997 Adobe Systems Incorporated. All Rights Reserved.ITC Zapf Dingbats is a registered trademark of International Typeface Corporation.\r\nEncodingScheme FontSpecific\r\nStdHW 28\r\nStdVW 90\r\nStartCharMetrics 202\r\nC 32 ; WX 278 ; N space ; B 0 0 0 0 ;\r\nC 33 ; WX 974 ; N a1 ; B 35 72 939 621 ;\r\nC 34 ; WX 961 ; N a2 ; B 35 81 927 611 ;\r\nC 35 ; WX 974 ; N a202 ; B 35 72 939 621 ;\r\nC 36 ; WX 980 ; N a3 ; B 35 0 945 692 ;\r\nC 37 ; WX 719 ; N a4 ; B 34 139 685 566 ;\r\nC 38 ; WX 789 ; N a5 ; B 35 -14 755 705 ;\r\nC 39 ; WX 790 ; N a119 ; B 35 -14 755 705 ;\r\nC 40 ; WX 791 ; N a118 ; B 35 -13 761 705 ;\r\nC 41 ; WX 690 ; N a117 ; B 34 138 655 553 ;\r\nC 42 ; WX 960 ; N a11 ; B 35 123 925 568 ;\r\nC 43 ; WX 939 ; N a12 ; B 35 134 904 559 ;\r\nC 44 ; WX 549 ; N a13 ; B 29 -11 516 705 ;\r\nC 45 ; WX 855 ; N a14 ; B 34 59 820 632 ;\r\nC 46 ; WX 911 ; N a15 ; B 35 50 876 642 ;\r\nC 47 ; WX 933 ; N a16 ; B 35 139 899 550 ;\r\nC 48 ; WX 911 ; N a105 ; B 35 50 876 642 ;\r\nC 49 ; WX 945 ; N a17 ; B 35 139 909 553 ;\r\nC 50 ; WX 974 ; N a18 ; B 35 104 938 587 ;\r\nC 51 ; WX 755 ; N a19 ; B 34 -13 721 705 ;\r\nC 52 ; WX 846 ; N a20 ; B 36 -14 811 705 ;\r\nC 53 ; WX 762 ; N a21 ; B 35 0 727 692 ;\r\nC 54 ; WX 761 ; N a22 ; B 35 0 727 692 ;\r\nC 55 ; WX 571 ; N a23 ; B -1 -68 571 661 ;\r\nC 56 ; WX 677 ; N a24 ; B 36 -13 642 705 ;\r\nC 57 ; WX 763 ; N a25 ; B 35 0 728 692 ;\r\nC 58 ; WX 760 ; N a26 ; B 35 0 726 692 ;\r\nC 59 ; WX 759 ; N a27 ; B 35 0 725 692 ;\r\nC 60 ; WX 754 ; N a28 ; B 35 0 720 692 ;\r\nC 61 ; WX 494 ; N a6 ; B 35 0 460 692 ;\r\nC 62 ; WX 552 ; N a7 ; B 35 0 517 692 ;\r\nC 63 ; WX 537 ; N a8 ; B 35 0 503 692 ;\r\nC 64 ; WX 577 ; N a9 ; B 35 96 542 596 ;\r\nC 65 ; WX 692 ; N a10 ; B 35 -14 657 705 ;\r\nC 66 ; WX 786 ; N a29 ; B 35 -14 751 705 ;\r\nC 67 ; WX 788 ; N a30 ; B 35 -14 752 705 ;\r\nC 68 ; WX 788 ; N a31 ; B 35 -14 753 705 ;\r\nC 69 ; WX 790 ; N a32 ; B 35 -14 756 705 ;\r\nC 70 ; WX 793 ; N a33 ; B 35 -13 759 705 ;\r\nC 71 ; WX 794 ; N a34 ; B 35 -13 759 705 ;\r\nC 72 ; WX 816 ; N a35 ; B 35 -14 782 705 ;\r\nC 73 ; WX 823 ; N a36 ; B 35 -14 787 705 ;\r\nC 74 ; WX 789 ; N a37 ; B 35 -14 754 705 ;\r\nC 75 ; WX 841 ; N a38 ; B 35 -14 807 705 ;\r\nC 76 ; WX 823 ; N a39 ; B 35 -14 789 705 ;\r\nC 77 ; WX 833 ; N a40 ; B 35 -14 798 705 ;\r\nC 78 ; WX 816 ; N a41 ; B 35 -13 782 705 ;\r\nC 79 ; WX 831 ; N a42 ; B 35 -14 796 705 ;\r\nC 80 ; WX 923 ; N a43 ; B 35 -14 888 705 ;\r\nC 81 ; WX 744 ; N a44 ; B 35 0 710 692 ;\r\nC 82 ; WX 723 ; N a45 ; B 35 0 688 692 ;\r\nC 83 ; WX 749 ; N a46 ; B 35 0 714 692 ;\r\nC 84 ; WX 790 ; N a47 ; B 34 -14 756 705 ;\r\nC 85 ; WX 792 ; N a48 ; B 35 -14 758 705 ;\r\nC 86 ; WX 695 ; N a49 ; B 35 -14 661 706 ;\r\nC 87 ; WX 776 ; N a50 ; B 35 -6 741 699 ;\r\nC 88 ; WX 768 ; N a51 ; B 35 -7 734 699 ;\r\nC 89 ; WX 792 ; N a52 ; B 35 -14 757 705 ;\r\nC 90 ; WX 759 ; N a53 ; B 35 0 725 692 ;\r\nC 91 ; WX 707 ; N a54 ; B 35 -13 672 704 ;\r\nC 92 ; WX 708 ; N a55 ; B 35 -14 672 705 ;\r\nC 93 ; WX 682 ; N a56 ; B 35 -14 647 705 ;\r\nC 94 ; WX 701 ; N a57 ; B 35 -14 666 705 ;\r\nC 95 ; WX 826 ; N a58 ; B 35 -14 791 705 ;\r\nC 96 ; WX 815 ; N a59 ; B 35 -14 780 705 ;\r\nC 97 ; WX 789 ; N a60 ; B 35 -14 754 705 ;\r\nC 98 ; WX 789 ; N a61 ; B 35 -14 754 705 ;\r\nC 99 ; WX 707 ; N a62 ; B 34 -14 673 705 ;\r\nC 100 ; WX 687 ; N a63 ; B 36 0 651 692 ;\r\nC 101 ; WX 696 ; N a64 ; B 35 0 661 691 ;\r\nC 102 ; WX 689 ; N a65 ; B 35 0 655 692 ;\r\nC 103 ; WX 786 ; N a66 ; B 34 -14 751 705 ;\r\nC 104 ; WX 787 ; N a67 ; B 35 -14 752 705 ;\r\nC 105 ; WX 713 ; N a68 ; B 35 -14 678 705 ;\r\nC 106 ; WX 791 ; N a69 ; B 35 -14 756 705 ;\r\nC 107 ; WX 785 ; N a70 ; B 36 -14 751 705 ;\r\nC 108 ; WX 791 ; N a71 ; B 35 -14 757 705 ;\r\nC 109 ; WX 873 ; N a72 ; B 35 -14 838 705 ;\r\nC 110 ; WX 761 ; N a73 ; B 35 0 726 692 ;\r\nC 111 ; WX 762 ; N a74 ; B 35 0 727 692 ;\r\nC 112 ; WX 762 ; N a203 ; B 35 0 727 692 ;\r\nC 113 ; WX 759 ; N a75 ; B 35 0 725 692 ;\r\nC 114 ; WX 759 ; N a204 ; B 35 0 725 692 ;\r\nC 115 ; WX 892 ; N a76 ; B 35 0 858 705 ;\r\nC 116 ; WX 892 ; N a77 ; B 35 -14 858 692 ;\r\nC 117 ; WX 788 ; N a78 ; B 35 -14 754 705 ;\r\nC 118 ; WX 784 ; N a79 ; B 35 -14 749 705 ;\r\nC 119 ; WX 438 ; N a81 ; B 35 -14 403 705 ;\r\nC 120 ; WX 138 ; N a82 ; B 35 0 104 692 ;\r\nC 121 ; WX 277 ; N a83 ; B 35 0 242 692 ;\r\nC 122 ; WX 415 ; N a84 ; B 35 0 380 692 ;\r\nC 123 ; WX 392 ; N a97 ; B 35 263 357 705 ;\r\nC 124 ; WX 392 ; N a98 ; B 34 263 357 705 ;\r\nC 125 ; WX 668 ; N a99 ; B 35 263 633 705 ;\r\nC 126 ; WX 668 ; N a100 ; B 36 263 634 705 ;\r\nC 128 ; WX 390 ; N a89 ; B 35 -14 356 705 ;\r\nC 129 ; WX 390 ; N a90 ; B 35 -14 355 705 ;\r\nC 130 ; WX 317 ; N a93 ; B 35 0 283 692 ;\r\nC 131 ; WX 317 ; N a94 ; B 35 0 283 692 ;\r\nC 132 ; WX 276 ; N a91 ; B 35 0 242 692 ;\r\nC 133 ; WX 276 ; N a92 ; B 35 0 242 692 ;\r\nC 134 ; WX 509 ; N a205 ; B 35 0 475 692 ;\r\nC 135 ; WX 509 ; N a85 ; B 35 0 475 692 ;\r\nC 136 ; WX 410 ; N a206 ; B 35 0 375 692 ;\r\nC 137 ; WX 410 ; N a86 ; B 35 0 375 692 ;\r\nC 138 ; WX 234 ; N a87 ; B 35 -14 199 705 ;\r\nC 139 ; WX 234 ; N a88 ; B 35 -14 199 705 ;\r\nC 140 ; WX 334 ; N a95 ; B 35 0 299 692 ;\r\nC 141 ; WX 334 ; N a96 ; B 35 0 299 692 ;\r\nC 161 ; WX 732 ; N a101 ; B 35 -143 697 806 ;\r\nC 162 ; WX 544 ; N a102 ; B 56 -14 488 706 ;\r\nC 163 ; WX 544 ; N a103 ; B 34 -14 508 705 ;\r\nC 164 ; WX 910 ; N a104 ; B 35 40 875 651 ;\r\nC 165 ; WX 667 ; N a106 ; B 35 -14 633 705 ;\r\nC 166 ; WX 760 ; N a107 ; B 35 -14 726 705 ;\r\nC 167 ; WX 760 ; N a108 ; B 0 121 758 569 ;\r\nC 168 ; WX 776 ; N a112 ; B 35 0 741 705 ;\r\nC 169 ; WX 595 ; N a111 ; B 34 -14 560 705 ;\r\nC 170 ; WX 694 ; N a110 ; B 35 -14 659 705 ;\r\nC 171 ; WX 626 ; N a109 ; B 34 0 591 705 ;\r\nC 172 ; WX 788 ; N a120 ; B 35 -14 754 705 ;\r\nC 173 ; WX 788 ; N a121 ; B 35 -14 754 705 ;\r\nC 174 ; WX 788 ; N a122 ; B 35 -14 754 705 ;\r\nC 175 ; WX 788 ; N a123 ; B 35 -14 754 705 ;\r\nC 176 ; WX 788 ; N a124 ; B 35 -14 754 705 ;\r\nC 177 ; WX 788 ; N a125 ; B 35 -14 754 705 ;\r\nC 178 ; WX 788 ; N a126 ; B 35 -14 754 705 ;\r\nC 179 ; WX 788 ; N a127 ; B 35 -14 754 705 ;\r\nC 180 ; WX 788 ; N a128 ; B 35 -14 754 705 ;\r\nC 181 ; WX 788 ; N a129 ; B 35 -14 754 705 ;\r\nC 182 ; WX 788 ; N a130 ; B 35 -14 754 705 ;\r\nC 183 ; WX 788 ; N a131 ; B 35 -14 754 705 ;\r\nC 184 ; WX 788 ; N a132 ; B 35 -14 754 705 ;\r\nC 185 ; WX 788 ; N a133 ; B 35 -14 754 705 ;\r\nC 186 ; WX 788 ; N a134 ; B 35 -14 754 705 ;\r\nC 187 ; WX 788 ; N a135 ; B 35 -14 754 705 ;\r\nC 188 ; WX 788 ; N a136 ; B 35 -14 754 705 ;\r\nC 189 ; WX 788 ; N a137 ; B 35 -14 754 705 ;\r\nC 190 ; WX 788 ; N a138 ; B 35 -14 754 705 ;\r\nC 191 ; WX 788 ; N a139 ; B 35 -14 754 705 ;\r\nC 192 ; WX 788 ; N a140 ; B 35 -14 754 705 ;\r\nC 193 ; WX 788 ; N a141 ; B 35 -14 754 705 ;\r\nC 194 ; WX 788 ; N a142 ; B 35 -14 754 705 ;\r\nC 195 ; WX 788 ; N a143 ; B 35 -14 754 705 ;\r\nC 196 ; WX 788 ; N a144 ; B 35 -14 754 705 ;\r\nC 197 ; WX 788 ; N a145 ; B 35 -14 754 705 ;\r\nC 198 ; WX 788 ; N a146 ; B 35 -14 754 705 ;\r\nC 199 ; WX 788 ; N a147 ; B 35 -14 754 705 ;\r\nC 200 ; WX 788 ; N a148 ; B 35 -14 754 705 ;\r\nC 201 ; WX 788 ; N a149 ; B 35 -14 754 705 ;\r\nC 202 ; WX 788 ; N a150 ; B 35 -14 754 705 ;\r\nC 203 ; WX 788 ; N a151 ; B 35 -14 754 705 ;\r\nC 204 ; WX 788 ; N a152 ; B 35 -14 754 705 ;\r\nC 205 ; WX 788 ; N a153 ; B 35 -14 754 705 ;\r\nC 206 ; WX 788 ; N a154 ; B 35 -14 754 705 ;\r\nC 207 ; WX 788 ; N a155 ; B 35 -14 754 705 ;\r\nC 208 ; WX 788 ; N a156 ; B 35 -14 754 705 ;\r\nC 209 ; WX 788 ; N a157 ; B 35 -14 754 705 ;\r\nC 210 ; WX 788 ; N a158 ; B 35 -14 754 705 ;\r\nC 211 ; WX 788 ; N a159 ; B 35 -14 754 705 ;\r\nC 212 ; WX 894 ; N a160 ; B 35 58 860 634 ;\r\nC 213 ; WX 838 ; N a161 ; B 35 152 803 540 ;\r\nC 214 ; WX 1016 ; N a163 ; B 34 152 981 540 ;\r\nC 215 ; WX 458 ; N a164 ; B 35 -127 422 820 ;\r\nC 216 ; WX 748 ; N a196 ; B 35 94 698 597 ;\r\nC 217 ; WX 924 ; N a165 ; B 35 140 890 552 ;\r\nC 218 ; WX 748 ; N a192 ; B 35 94 698 597 ;\r\nC 219 ; WX 918 ; N a166 ; B 35 166 884 526 ;\r\nC 220 ; WX 927 ; N a167 ; B 35 32 892 660 ;\r\nC 221 ; WX 928 ; N a168 ; B 35 129 891 562 ;\r\nC 222 ; WX 928 ; N a169 ; B 35 128 893 563 ;\r\nC 223 ; WX 834 ; N a170 ; B 35 155 799 537 ;\r\nC 224 ; WX 873 ; N a171 ; B 35 93 838 599 ;\r\nC 225 ; WX 828 ; N a172 ; B 35 104 791 588 ;\r\nC 226 ; WX 924 ; N a173 ; B 35 98 889 594 ;\r\nC 227 ; WX 924 ; N a162 ; B 35 98 889 594 ;\r\nC 228 ; WX 917 ; N a174 ; B 35 0 882 692 ;\r\nC 229 ; WX 930 ; N a175 ; B 35 84 896 608 ;\r\nC 230 ; WX 931 ; N a176 ; B 35 84 896 608 ;\r\nC 231 ; WX 463 ; N a177 ; B 35 -99 429 791 ;\r\nC 232 ; WX 883 ; N a178 ; B 35 71 848 623 ;\r\nC 233 ; WX 836 ; N a179 ; B 35 44 802 648 ;\r\nC 234 ; WX 836 ; N a193 ; B 35 44 802 648 ;\r\nC 235 ; WX 867 ; N a180 ; B 35 101 832 591 ;\r\nC 236 ; WX 867 ; N a199 ; B 35 101 832 591 ;\r\nC 237 ; WX 696 ; N a181 ; B 35 44 661 648 ;\r\nC 238 ; WX 696 ; N a200 ; B 35 44 661 648 ;\r\nC 239 ; WX 874 ; N a182 ; B 35 77 840 619 ;\r\nC 241 ; WX 874 ; N a201 ; B 35 73 840 615 ;\r\nC 242 ; WX 760 ; N a183 ; B 35 0 725 692 ;\r\nC 243 ; WX 946 ; N a184 ; B 35 160 911 533 ;\r\nC 244 ; WX 771 ; N a197 ; B 34 37 736 655 ;\r\nC 245 ; WX 865 ; N a185 ; B 35 207 830 481 ;\r\nC 246 ; WX 771 ; N a194 ; B 34 37 736 655 ;\r\nC 247 ; WX 888 ; N a198 ; B 34 -19 853 712 ;\r\nC 248 ; WX 967 ; N a186 ; B 35 124 932 568 ;\r\nC 249 ; WX 888 ; N a195 ; B 34 -19 853 712 ;\r\nC 250 ; WX 831 ; N a187 ; B 35 113 796 579 ;\r\nC 251 ; WX 873 ; N a188 ; B 36 118 838 578 ;\r\nC 252 ; WX 927 ; N a189 ; B 35 150 891 542 ;\r\nC 253 ; WX 970 ; N a190 ; B 35 76 931 616 ;\r\nC 254 ; WX 918 ; N a191 ; B 34 99 884 593 ;\r\nEndCharMetrics\r\nEndFontMetrics\r\n";
  }
};
class StandardFont extends PDFFont {
  constructor(document, name, id) {
    super();
    this.document = document;
    this.name = name;
    this.id = id;
    this.font = new AFMFont(STANDARD_FONTS[this.name]());
    ({
      ascender: this.ascender,
      descender: this.descender,
      bbox: this.bbox,
      lineGap: this.lineGap,
      xHeight: this.xHeight,
      capHeight: this.capHeight
    } = this.font);
  }
  embed() {
    this.dictionary.data = {
      Type: 'Font',
      BaseFont: this.name,
      Subtype: 'Type1',
      Encoding: 'WinAnsiEncoding'
    };
    return this.dictionary.end();
  }
  encode(text) {
    const encoded = this.font.encodeText(text);
    const glyphs = this.font.glyphsForString(`${text}`);
    const advances = this.font.advancesForGlyphs(glyphs);
    const positions = [];
    for (let i = 0; i < glyphs.length; i++) {
      const glyph = glyphs[i];
      positions.push({
        xAdvance: advances[i],
        yAdvance: 0,
        xOffset: 0,
        yOffset: 0,
        advanceWidth: this.font.widthOfGlyph(glyph)
      });
    }
    return [encoded, positions];
  }
  widthOfString(string, size) {
    const glyphs = this.font.glyphsForString(`${string}`);
    const advances = this.font.advancesForGlyphs(glyphs);
    let width = 0;
    for (let advance of advances) {
      width += advance;
    }
    const scale = size / 1000;
    return width * scale;
  }
  static isStandardFont(name) {
    return name in STANDARD_FONTS;
  }
}

const toHex = function (num) {
  return `0000${num.toString(16)}`.slice(-4);
};
class EmbeddedFont extends PDFFont {
  constructor(document, font, id) {
    super();
    this.document = document;
    this.font = font;
    this.id = id;
    this.subset = this.font.createSubset();
    this.unicode = [[0]];
    this.widths = [this.font.getGlyph(0).advanceWidth];
    this.name = this.font.postscriptName;
    this.scale = 1000 / this.font.unitsPerEm;
    this.ascender = this.font.ascent * this.scale;
    this.descender = this.font.descent * this.scale;
    this.xHeight = this.font.xHeight * this.scale;
    this.capHeight = this.font.capHeight * this.scale;
    this.lineGap = this.font.lineGap * this.scale;
    this.bbox = this.font.bbox;
    if (document.options.fontLayoutCache !== false) {
      this.layoutCache = Object.create(null);
    }
  }
  layoutRun(text, features) {
    const run = this.font.layout(text, features);
    for (let i = 0; i < run.positions.length; i++) {
      const position = run.positions[i];
      for (let key in position) {
        position[key] *= this.scale;
      }
      position.advanceWidth = run.glyphs[i].advanceWidth * this.scale;
    }
    return run;
  }
  layoutCached(text) {
    if (!this.layoutCache) {
      return this.layoutRun(text);
    }
    let cached;
    if (cached = this.layoutCache[text]) {
      return cached;
    }
    const run = this.layoutRun(text);
    this.layoutCache[text] = run;
    return run;
  }
  layout(text, features, onlyWidth) {
    if (features) {
      return this.layoutRun(text, features);
    }
    let glyphs = onlyWidth ? null : [];
    let positions = onlyWidth ? null : [];
    let advanceWidth = 0;
    let last = 0;
    let index = 0;
    while (index <= text.length) {
      var needle;
      if (index === text.length && last < index || (needle = text.charAt(index), [' ', '\t'].includes(needle))) {
        const run = this.layoutCached(text.slice(last, ++index));
        if (!onlyWidth) {
          glyphs = glyphs.concat(run.glyphs);
          positions = positions.concat(run.positions);
        }
        advanceWidth += run.advanceWidth;
        last = index;
      } else {
        index++;
      }
    }
    return {
      glyphs,
      positions,
      advanceWidth
    };
  }
  encode(text, features) {
    const {
      glyphs,
      positions
    } = this.layout(text, features);
    const res = [];
    for (let i = 0; i < glyphs.length; i++) {
      const glyph = glyphs[i];
      const gid = this.subset.includeGlyph(glyph.id);
      res.push(`0000${gid.toString(16)}`.slice(-4));
      if (this.widths[gid] == null) {
        this.widths[gid] = glyph.advanceWidth * this.scale;
      }
      if (this.unicode[gid] == null) {
        this.unicode[gid] = glyph.codePoints;
      }
    }
    return [res, positions];
  }
  widthOfString(string, size, features) {
    const width = this.layout(string, features, true).advanceWidth;
    const scale = size / 1000;
    return width * scale;
  }
  embed() {
    const isCFF = this.subset.cff != null;
    const fontFile = this.document.ref();
    if (isCFF) {
      fontFile.data.Subtype = 'CIDFontType0C';
    }
    fontFile.end(this.subset.encode());
    const familyClass = ((this.font['OS/2'] != null ? this.font['OS/2'].sFamilyClass : undefined) || 0) >> 8;
    let flags = 0;
    if (this.font.post.isFixedPitch) {
      flags |= 1 << 0;
    }
    if (1 <= familyClass && familyClass <= 7) {
      flags |= 1 << 1;
    }
    flags |= 1 << 2;
    if (familyClass === 10) {
      flags |= 1 << 3;
    }
    if (this.font.head.macStyle.italic) {
      flags |= 1 << 6;
    }
    const tag = [1, 2, 3, 4, 5, 6].map(i => String.fromCharCode((this.id.charCodeAt(i) || 73) + 17)).join('');
    const name = tag + '+' + this.font.postscriptName?.replaceAll(' ', '_');
    const {
      bbox
    } = this.font;
    const descriptor = this.document.ref({
      Type: 'FontDescriptor',
      FontName: name,
      Flags: flags,
      FontBBox: [bbox.minX * this.scale, bbox.minY * this.scale, bbox.maxX * this.scale, bbox.maxY * this.scale],
      ItalicAngle: this.font.italicAngle,
      Ascent: this.ascender,
      Descent: this.descender,
      CapHeight: (this.font.capHeight || this.font.ascent) * this.scale,
      XHeight: (this.font.xHeight || 0) * this.scale,
      StemV: 0
    });
    if (isCFF) {
      descriptor.data.FontFile3 = fontFile;
    } else {
      descriptor.data.FontFile2 = fontFile;
    }
    if (this.document.subset && this.document.subset === 1) {
      const CIDSet = Buffer.from('FFFFFFFFC0', 'hex');
      const CIDSetRef = this.document.ref();
      CIDSetRef.write(CIDSet);
      CIDSetRef.end();
      descriptor.data.CIDSet = CIDSetRef;
    }
    descriptor.end();
    const descendantFontData = {
      Type: 'Font',
      Subtype: 'CIDFontType0',
      BaseFont: name,
      CIDSystemInfo: {
        Registry: new String('Adobe'),
        Ordering: new String('Identity'),
        Supplement: 0
      },
      FontDescriptor: descriptor,
      W: [0, this.widths]
    };
    if (!isCFF) {
      descendantFontData.Subtype = 'CIDFontType2';
      descendantFontData.CIDToGIDMap = 'Identity';
    }
    const descendantFont = this.document.ref(descendantFontData);
    descendantFont.end();
    this.dictionary.data = {
      Type: 'Font',
      Subtype: 'Type0',
      BaseFont: name,
      Encoding: 'Identity-H',
      DescendantFonts: [descendantFont],
      ToUnicode: this.toUnicodeCmap()
    };
    return this.dictionary.end();
  }
  toUnicodeCmap() {
    const cmap = this.document.ref();
    const entries = [];
    for (let codePoints of this.unicode) {
      const encoded = [];
      for (let value of codePoints) {
        if (value > 0xffff) {
          value -= 0x10000;
          encoded.push(toHex(value >>> 10 & 0x3ff | 0xd800));
          value = 0xdc00 | value & 0x3ff;
        }
        encoded.push(toHex(value));
      }
      entries.push(`<${encoded.join(' ')}>`);
    }
    const chunkSize = 256;
    const chunks = Math.ceil(entries.length / chunkSize);
    const ranges = [];
    for (let i = 0; i < chunks; i++) {
      const start = i * chunkSize;
      const end = Math.min((i + 1) * chunkSize, entries.length);
      ranges.push(`<${toHex(start)}> <${toHex(end - 1)}> [${entries.slice(start, end).join(' ')}]`);
    }
    cmap.end(`\
/CIDInit /ProcSet findresource begin
12 dict begin
begincmap
/CIDSystemInfo <<
  /Registry (Adobe)
  /Ordering (UCS)
  /Supplement 0
>> def
/CMapName /Adobe-Identity-UCS def
/CMapType 2 def
1 begincodespacerange
<0000><ffff>
endcodespacerange
1 beginbfrange
${ranges.join('\n')}
endbfrange
endcmap
CMapName currentdict /CMap defineresource pop
end
end\
`);
    return cmap;
  }
}

class PDFFontFactory {
  static open(document, src, family, id) {
    let font;
    if (typeof src === 'string') {
      if (StandardFont.isStandardFont(src)) {
        return new StandardFont(document, src, id);
      }
      src = fs.readFileSync(src);
    }
    if (src instanceof Uint8Array) {
      font = fontkit.create(src, family);
    } else if (src instanceof ArrayBuffer) {
      font = fontkit.create(new Uint8Array(src), family);
    }
    if (font == null) {
      throw new Error('Not a supported font format or standard PDF font.');
    }
    return new EmbeddedFont(document, font, id);
  }
}

const isEqualFont = (font1, font2) => {
  if (font1.font._tables?.head?.checkSumAdjustment !== font2.font._tables?.head?.checkSumAdjustment) {
    return false;
  }
  if (JSON.stringify(font1.font._tables?.name?.records) !== JSON.stringify(font2.font._tables?.name?.records)) {
    return false;
  }
  return true;
};
var FontsMixin = {
  initFonts(defaultFont = 'Helvetica', defaultFontFamily = null, defaultFontSize = 12) {
    this._fontFamilies = {};
    this._fontCount = 0;
    this._fontSource = defaultFont;
    this._fontFamily = defaultFontFamily;
    this._fontSize = defaultFontSize;
    this._font = null;
    this._remSize = defaultFontSize;
    this._registeredFonts = {};
    if (defaultFont) {
      this.font(defaultFont, defaultFontFamily);
    }
  },
  font(src, family, size) {
    let cacheKey, font;
    if (typeof family === 'number') {
      size = family;
      family = null;
    }
    if (typeof src === 'string' && this._registeredFonts[src]) {
      cacheKey = src;
      ({
        src,
        family
      } = this._registeredFonts[src]);
    } else {
      cacheKey = family || src;
      if (typeof cacheKey !== 'string') {
        cacheKey = null;
      }
    }
    this._fontSource = src;
    this._fontFamily = family;
    if (size != null) {
      this.fontSize(size);
    }
    if (font = this._fontFamilies[cacheKey]) {
      this._font = font;
      return this;
    }
    const id = `F${++this._fontCount}`;
    this._font = PDFFontFactory.open(this, src, family, id);
    if ((font = this._fontFamilies[this._font.name]) && isEqualFont(this._font, font)) {
      this._font = font;
      return this;
    }
    if (cacheKey) {
      this._fontFamilies[cacheKey] = this._font;
    }
    if (this._font.name) {
      this._fontFamilies[this._font.name] = this._font;
    }
    return this;
  },
  fontSize(_fontSize) {
    this._fontSize = this.sizeToPoint(_fontSize);
    return this;
  },
  currentLineHeight(includeGap) {
    return this._font.lineHeight(this._fontSize, includeGap);
  },
  registerFont(name, src, family) {
    this._registeredFonts[name] = {
      src,
      family
    };
    return this;
  },
  sizeToPoint(size, defaultValue = 0, page = this.page, percentageWidth = undefined) {
    if (!percentageWidth) percentageWidth = this._fontSize;
    if (typeof defaultValue !== 'number') defaultValue = this.sizeToPoint(defaultValue);
    if (size === undefined) return defaultValue;
    if (typeof size === 'number') return size;
    if (typeof size === 'boolean') return Number(size);
    const match = String(size).match(/((\d+)?(\.\d+)?)(em|in|px|cm|mm|pc|ex|ch|rem|vw|vh|vmin|vmax|%|pt)?/);
    if (!match) throw new Error(`Unsupported size '${size}'`);
    let multiplier;
    switch (match[4]) {
      case 'em':
        multiplier = this._fontSize;
        break;
      case 'in':
        multiplier = IN_TO_PT;
        break;
      case 'px':
        multiplier = PX_TO_IN * IN_TO_PT;
        break;
      case 'cm':
        multiplier = CM_TO_IN * IN_TO_PT;
        break;
      case 'mm':
        multiplier = MM_TO_CM * CM_TO_IN * IN_TO_PT;
        break;
      case 'pc':
        multiplier = PC_TO_PT;
        break;
      case 'ex':
        multiplier = this.currentLineHeight();
        break;
      case 'ch':
        multiplier = this.widthOfString('0');
        break;
      case 'rem':
        multiplier = this._remSize;
        break;
      case 'vw':
        multiplier = page.width / 100;
        break;
      case 'vh':
        multiplier = page.height / 100;
        break;
      case 'vmin':
        multiplier = Math.min(page.width, page.height) / 100;
        break;
      case 'vmax':
        multiplier = Math.max(page.width, page.height) / 100;
        break;
      case '%':
        multiplier = percentageWidth / 100;
        break;
      case 'pt':
      default:
        multiplier = 1;
    }
    return multiplier * Number(match[1]);
  }
};

const SOFT_HYPHEN = '\u00AD';
const HYPHEN = '-';
class LineWrapper extends events.EventEmitter {
  constructor(document, options) {
    super();
    this.document = document;
    this.horizontalScaling = options.horizontalScaling || 100;
    this.indent = (options.indent || 0) * this.horizontalScaling / 100;
    this.characterSpacing = (options.characterSpacing || 0) * this.horizontalScaling / 100;
    this.wordSpacing = (options.wordSpacing === 0) * this.horizontalScaling / 100;
    this.columns = options.columns || 1;
    this.columnGap = (options.columnGap != null ? options.columnGap : 18) * this.horizontalScaling / 100;
    this.lineWidth = (options.width * this.horizontalScaling / 100 - this.columnGap * (this.columns - 1)) / this.columns;
    this.spaceLeft = this.lineWidth;
    this.startX = this.document.x;
    this.startY = this.document.y;
    this.column = 1;
    this.ellipsis = options.ellipsis;
    this.continuedX = 0;
    this.features = options.features;
    if (options.height != null) {
      this.height = options.height;
      this.maxY = PDFNumber(this.startY + options.height);
    } else {
      this.maxY = PDFNumber(this.document.page.maxY());
    }
    this.on('firstLine', options => {
      const indent = this.continuedX || this.indent;
      this.document.x += indent;
      this.lineWidth -= indent;
      if (options.indentAllLines) {
        return;
      }
      this.once('line', () => {
        this.document.x -= indent;
        this.lineWidth += indent;
        if (options.continued && !this.continuedX) {
          this.continuedX = this.indent;
        }
        if (!options.continued) {
          this.continuedX = 0;
        }
      });
    });
    this.on('lastLine', options => {
      const {
        align
      } = options;
      if (align === 'justify') {
        options.align = 'left';
      }
      this.lastLine = true;
      this.once('line', () => {
        this.document.y += options.paragraphGap || 0;
        options.align = align;
        return this.lastLine = false;
      });
    });
  }
  wordWidth(word) {
    return PDFNumber(this.document.widthOfString(word, this) + this.characterSpacing + this.wordSpacing);
  }
  canFit(word, w) {
    if (word[word.length - 1] != SOFT_HYPHEN) {
      return w <= this.spaceLeft;
    }
    return w + this.wordWidth(HYPHEN) <= this.spaceLeft;
  }
  eachWord(text, fn) {
    let bk;
    const breaker = new LineBreaker(text);
    let last = null;
    const wordWidths = Object.create(null);
    while (bk = breaker.nextBreak()) {
      var shouldContinue;
      let word = text.slice((last != null ? last.position : undefined) || 0, bk.position);
      let w = wordWidths[word] != null ? wordWidths[word] : wordWidths[word] = this.wordWidth(word);
      if (w > this.lineWidth + this.continuedX) {
        let lbk = last;
        const fbk = {};
        while (word.length) {
          var l, mightGrow;
          if (w > this.spaceLeft) {
            l = Math.ceil(this.spaceLeft / (w / word.length));
            w = this.wordWidth(word.slice(0, l));
            mightGrow = w <= this.spaceLeft && l < word.length;
          } else {
            l = word.length;
          }
          let mustShrink = w > this.spaceLeft && l > 0;
          while (mustShrink || mightGrow) {
            if (mustShrink) {
              w = this.wordWidth(word.slice(0, --l));
              mustShrink = w > this.spaceLeft && l > 0;
            } else {
              w = this.wordWidth(word.slice(0, ++l));
              mustShrink = w > this.spaceLeft && l > 0;
              mightGrow = w <= this.spaceLeft && l < word.length;
            }
          }
          if (l === 0 && this.spaceLeft === this.lineWidth) {
            l = 1;
          }
          fbk.required = bk.required || l < word.length;
          shouldContinue = fn(word.slice(0, l), w, fbk, lbk);
          lbk = {
            required: false
          };
          word = word.slice(l);
          w = this.wordWidth(word);
          if (shouldContinue === false) {
            break;
          }
        }
      } else {
        shouldContinue = fn(word, w, bk, last);
      }
      if (shouldContinue === false) {
        break;
      }
      last = bk;
    }
  }
  wrap(text, options) {
    this.horizontalScaling = options.horizontalScaling || 100;
    if (options.indent != null) {
      this.indent = options.indent * this.horizontalScaling / 100;
    }
    if (options.characterSpacing != null) {
      this.characterSpacing = options.characterSpacing * this.horizontalScaling / 100;
    }
    if (options.wordSpacing != null) {
      this.wordSpacing = options.wordSpacing * this.horizontalScaling / 100;
    }
    if (options.ellipsis != null) {
      this.ellipsis = options.ellipsis;
    }
    const nextY = this.document.y + this.document.currentLineHeight(true);
    if (this.document.y > this.maxY || nextY > this.maxY) {
      this.nextSection();
    }
    let buffer = '';
    let textWidth = 0;
    let wc = 0;
    let lc = 0;
    let {
      y
    } = this.document;
    const emitLine = () => {
      options.textWidth = textWidth + this.wordSpacing * (wc - 1);
      options.wordCount = wc;
      options.lineWidth = this.lineWidth;
      ({
        y
      } = this.document);
      this.emit('line', buffer, options, this);
      return lc++;
    };
    this.emit('sectionStart', options, this);
    this.eachWord(text, (word, w, bk, last) => {
      if (last == null || last.required) {
        this.emit('firstLine', options, this);
        this.spaceLeft = this.lineWidth;
      }
      if (this.canFit(word, w)) {
        buffer += word;
        textWidth += w;
        wc++;
      }
      if (bk.required || !this.canFit(word, w)) {
        const lh = this.document.currentLineHeight(true);
        if (this.height != null && this.ellipsis && PDFNumber(this.document.y + lh * 2) > this.maxY && this.column >= this.columns) {
          if (this.ellipsis === true) {
            this.ellipsis = '…';
          }
          buffer = buffer.replace(/\s+$/, '');
          textWidth = this.wordWidth(buffer + this.ellipsis);
          while (buffer && textWidth > this.lineWidth) {
            buffer = buffer.slice(0, -1).replace(/\s+$/, '');
            textWidth = this.wordWidth(buffer + this.ellipsis);
          }
          if (textWidth <= this.lineWidth) {
            buffer = buffer + this.ellipsis;
          }
          textWidth = this.wordWidth(buffer);
        }
        if (bk.required) {
          if (w > this.spaceLeft) {
            emitLine();
            buffer = word;
            textWidth = w;
            wc = 1;
          }
          this.emit('lastLine', options, this);
        }
        if (buffer[buffer.length - 1] == SOFT_HYPHEN) {
          buffer = buffer.slice(0, -1) + HYPHEN;
          this.spaceLeft -= this.wordWidth(HYPHEN);
        }
        emitLine();
        if (PDFNumber(this.document.y + lh) > this.maxY) {
          this.emit('sectionEnd', options, this);
          const shouldContinue = this.nextSection();
          if (!shouldContinue) {
            wc = 0;
            buffer = '';
            return false;
          }
          this.emit('sectionStart', options, this);
        }
        if (bk.required) {
          this.spaceLeft = this.lineWidth;
          buffer = '';
          textWidth = 0;
          return wc = 0;
        } else {
          this.spaceLeft = this.lineWidth - w;
          buffer = word;
          textWidth = w;
          return wc = 1;
        }
      } else {
        return this.spaceLeft -= w;
      }
    });
    if (wc > 0) {
      this.emit('lastLine', options, this);
      emitLine();
    }
    this.emit('sectionEnd', options, this);
    if (options.continued === true) {
      if (lc > 1) {
        this.continuedX = 0;
      }
      this.continuedX += options.textWidth || 0;
      this.document.y = y;
    } else {
      this.document.x = this.startX;
    }
  }
  nextSection(options) {
    if (++this.column > this.columns) {
      if (this.height != null) {
        return false;
      }
      this.document.continueOnNewPage();
      this.column = 1;
      this.startY = this.document.page.margins.top;
      this.maxY = this.document.page.maxY();
      this.document.x = this.startX;
      if (this.document._fillColor) {
        this.document.fillColor(...this.document._fillColor);
      }
      this.emit('pageBreak', options, this);
    } else {
      this.document.x += this.lineWidth + this.columnGap;
      this.document.y = this.startY;
      this.emit('columnBreak', options, this);
    }
    return true;
  }
}

const {
  number
} = PDFObject;
function formatListLabel(n, listType) {
  if (listType === 'numbered') {
    return `${n}.`;
  }
  var letter = String.fromCharCode((n - 1) % 26 + 65);
  var times = Math.floor((n - 1) / 26 + 1);
  var text = Array(times + 1).join(letter);
  return `${text}.`;
}
var TextMixin = {
  initText() {
    this._line = this._line.bind(this);
    this.x = 0;
    this.y = 0;
    this._lineGap = 0;
  },
  lineGap(_lineGap) {
    this._lineGap = _lineGap;
    return this;
  },
  moveDown(lines) {
    if (lines == null) {
      lines = 1;
    }
    this.y += this.currentLineHeight(true) * lines + this._lineGap;
    return this;
  },
  moveUp(lines) {
    if (lines == null) {
      lines = 1;
    }
    this.y -= this.currentLineHeight(true) * lines + this._lineGap;
    return this;
  },
  _text(text, x, y, options, lineCallback) {
    options = this._initOptions(x, y, options);
    text = text == null ? '' : `${text}`;
    if (options.wordSpacing) {
      text = text.replace(/\s{2,}/g, ' ');
    }
    const addStructure = () => {
      if (options.structParent) {
        options.structParent.add(this.struct(options.structType || 'P', [this.markStructureContent(options.structType || 'P')]));
      }
    };
    if (options.rotation !== 0) {
      this.save();
      this.rotate(-options.rotation, {
        origin: [this.x, this.y]
      });
    }
    if (options.width) {
      let wrapper = this._wrapper;
      if (!wrapper) {
        wrapper = new LineWrapper(this, options);
        wrapper.on('line', lineCallback);
        wrapper.on('firstLine', addStructure);
      }
      this._wrapper = options.continued ? wrapper : null;
      this._textOptions = options.continued ? options : null;
      wrapper.wrap(text, options);
    } else {
      for (let line of text.split('\n')) {
        addStructure();
        lineCallback(line, options);
      }
    }
    if (options.rotation !== 0) this.restore();
    return this;
  },
  text(text, x, y, options) {
    return this._text(text, x, y, options, this._line);
  },
  widthOfString(string, options = {}) {
    const horizontalScaling = options.horizontalScaling || 100;
    return (this._font.widthOfString(string, this._fontSize, options.features) + (options.characterSpacing || 0) * (string.length - 1)) * horizontalScaling / 100;
  },
  boundsOfString(string, x, y, options) {
    options = this._initOptions(x, y, options);
    ({
      x,
      y
    } = this);
    const lineGap = options.lineGap ?? this._lineGap ?? 0;
    const lineHeight = this.currentLineHeight(true) + lineGap;
    let contentWidth = 0;
    string = String(string ?? '');
    if (options.wordSpacing) {
      string = string.replace(/\s{2,}/g, ' ');
    }
    if (options.width) {
      let wrapper = new LineWrapper(this, options);
      wrapper.on('line', (text, options) => {
        this.y += lineHeight;
        text = text.replace(/\n/g, '');
        if (text.length) {
          let wordSpacing = options.wordSpacing ?? 0;
          const characterSpacing = options.characterSpacing ?? 0;
          if (options.width && options.align === 'justify') {
            const words = text.trim().split(/\s+/);
            const textWidth = this.widthOfString(text.replace(/\s+/g, ''), options);
            const spaceWidth = this.widthOfString(' ') + characterSpacing;
            wordSpacing = Math.max(0, (options.lineWidth - textWidth) / Math.max(1, words.length - 1) - spaceWidth);
          }
          contentWidth = Math.max(contentWidth, options.textWidth + wordSpacing * (options.wordCount - 1) + characterSpacing * (text.length - 1));
        }
      });
      wrapper.wrap(string, options);
    } else {
      for (let line of string.split('\n')) {
        const lineWidth = this.widthOfString(line, options);
        this.y += lineHeight;
        contentWidth = Math.max(contentWidth, lineWidth);
      }
    }
    let contentHeight = this.y - y;
    if (options.height) contentHeight = Math.min(contentHeight, options.height);
    this.x = x;
    this.y = y;
    if (options.rotation === 0) {
      return {
        x,
        y,
        width: contentWidth,
        height: contentHeight
      };
    } else if (options.rotation === 90) {
      return {
        x: x,
        y: y - contentWidth,
        width: contentHeight,
        height: contentWidth
      };
    } else if (options.rotation === 180) {
      return {
        x: x - contentWidth,
        y: y - contentHeight,
        width: contentWidth,
        height: contentHeight
      };
    } else if (options.rotation === 270) {
      return {
        x: x - contentHeight,
        y: y,
        width: contentHeight,
        height: contentWidth
      };
    }
    const cos = cosine(options.rotation);
    const sin = sine(options.rotation);
    const x1 = x;
    const y1 = y;
    const x2 = x + contentWidth * cos;
    const y2 = y - contentWidth * sin;
    const x3 = x + contentWidth * cos + contentHeight * sin;
    const y3 = y - contentWidth * sin + contentHeight * cos;
    const x4 = x + contentHeight * sin;
    const y4 = y + contentHeight * cos;
    const xMin = Math.min(x1, x2, x3, x4);
    const xMax = Math.max(x1, x2, x3, x4);
    const yMin = Math.min(y1, y2, y3, y4);
    const yMax = Math.max(y1, y2, y3, y4);
    return {
      x: xMin,
      y: yMin,
      width: xMax - xMin,
      height: yMax - yMin
    };
  },
  heightOfString(text, options) {
    const {
      x,
      y
    } = this;
    options = this._initOptions(options);
    options.height = Infinity;
    const lineGap = options.lineGap || this._lineGap || 0;
    this._text(text, this.x, this.y, options, () => {
      this.y += this.currentLineHeight(true) + lineGap;
    });
    const height = this.y - y;
    this.x = x;
    this.y = y;
    return height;
  },
  list(list, x, y, options) {
    options = this._initOptions(x, y, options);
    const listType = options.listType || 'bullet';
    const unit = Math.round(this._font.ascender / 1000 * this._fontSize);
    const midLine = unit / 2;
    const r = options.bulletRadius || unit / 3;
    const indent = options.textIndent || (listType === 'bullet' ? r * 5 : unit * 2);
    const itemIndent = options.bulletIndent || (listType === 'bullet' ? r * 8 : unit * 2);
    let level = 1;
    const items = [];
    const levels = [];
    const numbers = [];
    var flatten = function (list) {
      let n = 1;
      for (let i = 0; i < list.length; i++) {
        const item = list[i];
        if (Array.isArray(item)) {
          level++;
          flatten(item);
          level--;
        } else {
          items.push(item);
          levels.push(level);
          if (listType !== 'bullet') {
            numbers.push(n++);
          }
        }
      }
    };
    flatten(list);
    const drawListItem = function (listItem, i) {
      const wrapper = new LineWrapper(this, options);
      wrapper.on('line', this._line);
      level = 1;
      wrapper.once('firstLine', () => {
        let item, itemType, labelType, bodyType;
        if (options.structParent) {
          if (options.structTypes) {
            [itemType, labelType, bodyType] = options.structTypes;
          } else {
            [itemType, labelType, bodyType] = ['LI', 'Lbl', 'LBody'];
          }
        }
        if (itemType) {
          item = this.struct(itemType);
          options.structParent.add(item);
        } else if (options.structParent) {
          item = options.structParent;
        }
        let l;
        if ((l = levels[i++]) !== level) {
          const diff = itemIndent * (l - level);
          this.x += diff;
          wrapper.lineWidth -= diff;
          level = l;
        }
        if (item && (labelType || bodyType)) {
          item.add(this.struct(labelType || bodyType, [this.markStructureContent(labelType || bodyType)]));
        }
        switch (listType) {
          case 'bullet':
            this.circle(this.x - indent + r, this.y + midLine, r);
            this.fill();
            break;
          case 'numbered':
          case 'lettered':
            var text = formatListLabel(numbers[i - 1], listType);
            this._fragment(text, this.x - indent, this.y, options);
            break;
        }
        if (item && labelType && bodyType) {
          item.add(this.struct(bodyType, [this.markStructureContent(bodyType)]));
        }
        if (item && item !== options.structParent) {
          item.end();
        }
      });
      wrapper.on('sectionStart', () => {
        const pos = indent + itemIndent * (level - 1);
        this.x += pos;
        wrapper.lineWidth -= pos;
      });
      wrapper.on('sectionEnd', () => {
        const pos = indent + itemIndent * (level - 1);
        this.x -= pos;
        wrapper.lineWidth += pos;
      });
      wrapper.wrap(listItem, options);
    };
    for (let i = 0; i < items.length; i++) {
      drawListItem.call(this, items[i], i);
    }
    return this;
  },
  _initOptions(x = {}, y, options = {}) {
    if (typeof x === 'object') {
      options = x;
      x = null;
    }
    const result = Object.assign({}, options);
    if (this._textOptions) {
      for (let key in this._textOptions) {
        const val = this._textOptions[key];
        if (key !== 'continued') {
          if (result[key] === undefined) {
            result[key] = val;
          }
        }
      }
    }
    if (x != null) {
      this.x = x;
    }
    if (y != null) {
      this.y = y;
    }
    if (result.lineBreak !== false) {
      if (result.width == null) {
        result.width = this.page.width - this.x - this.page.margins.right;
      }
      result.width = Math.max(result.width, 0);
    }
    if (!result.columns) {
      result.columns = 0;
    }
    if (result.columnGap == null) {
      result.columnGap = 18;
    }
    result.rotation = Number(options.rotation ?? 0) % 360;
    if (result.rotation < 0) result.rotation += 360;
    return result;
  },
  _line(text, options = {}, wrapper) {
    this._fragment(text, this.x, this.y, options);
    if (wrapper) {
      const lineGap = options.lineGap || this._lineGap || 0;
      this.y += this.currentLineHeight(true) + lineGap;
    } else {
      this.x += this.widthOfString(text, options);
    }
  },
  _fragment(text, x, y, options) {
    let dy, encoded, i, positions, textWidth, words;
    text = `${text}`.replace(/\n/g, '');
    if (text.length === 0) {
      return;
    }
    const align = options.align || 'left';
    let wordSpacing = options.wordSpacing || 0;
    const characterSpacing = options.characterSpacing || 0;
    const horizontalScaling = options.horizontalScaling || 100;
    if (options.width) {
      switch (align) {
        case 'right':
          textWidth = this.widthOfString(text.replace(/\s+$/, ''), options);
          x += options.lineWidth - textWidth;
          break;
        case 'center':
          x += options.lineWidth / 2 - options.textWidth / 2;
          break;
        case 'justify':
          words = text.trim().split(/\s+/);
          textWidth = this.widthOfString(text.replace(/\s+/g, ''), options);
          var spaceWidth = this.widthOfString(' ') + characterSpacing;
          wordSpacing = Math.max(0, (options.lineWidth - textWidth) / Math.max(1, words.length - 1) - spaceWidth);
          break;
      }
    }
    if (typeof options.baseline === 'number') {
      dy = -options.baseline;
    } else {
      switch (options.baseline) {
        case 'svg-middle':
          dy = 0.5 * this._font.xHeight;
          break;
        case 'middle':
        case 'svg-central':
          dy = 0.5 * (this._font.descender + this._font.ascender);
          break;
        case 'bottom':
        case 'ideographic':
          dy = this._font.descender;
          break;
        case 'alphabetic':
          dy = 0;
          break;
        case 'mathematical':
          dy = 0.5 * this._font.ascender;
          break;
        case 'hanging':
          dy = 0.8 * this._font.ascender;
          break;
        case 'top':
          dy = this._font.ascender;
          break;
        default:
          dy = this._font.ascender;
      }
      dy = dy / 1000 * this._fontSize;
    }
    const renderedWidth = options.textWidth + wordSpacing * (options.wordCount - 1) + characterSpacing * (text.length - 1);
    if (options.link != null) {
      this.link(x, y, renderedWidth, this.currentLineHeight(), options.link);
    }
    if (options.goTo != null) {
      this.goTo(x, y, renderedWidth, this.currentLineHeight(), options.goTo);
    }
    if (options.destination != null) {
      this.addNamedDestination(options.destination, 'XYZ', x, y, null);
    }
    if (options.underline) {
      this.save();
      if (!options.stroke) {
        this.strokeColor(...(this._fillColor || []));
      }
      const lineWidth = this._fontSize < 10 ? 0.5 : Math.floor(this._fontSize / 10);
      this.lineWidth(lineWidth);
      let lineY = y + this.currentLineHeight() - lineWidth;
      this.moveTo(x, lineY);
      this.lineTo(x + renderedWidth, lineY);
      this.stroke();
      this.restore();
    }
    if (options.strike) {
      this.save();
      if (!options.stroke) {
        this.strokeColor(...(this._fillColor || []));
      }
      const lineWidth = this._fontSize < 10 ? 0.5 : Math.floor(this._fontSize / 10);
      this.lineWidth(lineWidth);
      let lineY = y + this.currentLineHeight() / 2;
      this.moveTo(x, lineY);
      this.lineTo(x + renderedWidth, lineY);
      this.stroke();
      this.restore();
    }
    this.save();
    if (options.oblique) {
      let skew;
      if (typeof options.oblique === 'number') {
        skew = -Math.tan(options.oblique * Math.PI / 180);
      } else {
        skew = -0.25;
      }
      this.transform(1, 0, 0, 1, x, y);
      this.transform(1, 0, skew, 1, -skew * dy, 0);
      this.transform(1, 0, 0, 1, -x, -y);
    }
    this.transform(1, 0, 0, -1, 0, this.page.height);
    y = this.page.height - y - dy;
    if (this.page.fonts[this._font.id] == null) {
      this.page.fonts[this._font.id] = this._font.ref();
    }
    this.addContent('BT');
    this.addContent(`1 0 0 1 ${number(x)} ${number(y)} Tm`);
    this.addContent(`/${this._font.id} ${number(this._fontSize)} Tf`);
    const mode = options.fill && options.stroke ? 2 : options.stroke ? 1 : 0;
    if (mode) {
      this.addContent(`${mode} Tr`);
    }
    if (characterSpacing) {
      this.addContent(`${number(characterSpacing)} Tc`);
    }
    if (horizontalScaling !== 100) {
      this.addContent(`${horizontalScaling} Tz`);
    }
    if (wordSpacing) {
      words = text.trim().split(/\s+/);
      wordSpacing += this.widthOfString(' ') + characterSpacing;
      wordSpacing *= 1000 / this._fontSize;
      encoded = [];
      positions = [];
      for (let word of words) {
        const [encodedWord, positionsWord] = this._font.encode(word, options.features);
        encoded = encoded.concat(encodedWord);
        positions = positions.concat(positionsWord);
        const space = {};
        const object = positions[positions.length - 1];
        for (let key in object) {
          const val = object[key];
          space[key] = val;
        }
        space.xAdvance += wordSpacing;
        positions[positions.length - 1] = space;
      }
    } else {
      [encoded, positions] = this._font.encode(text, options.features);
    }
    const scale = this._fontSize / 1000;
    const commands = [];
    let last = 0;
    let hadOffset = false;
    const addSegment = cur => {
      if (last < cur) {
        const hex = encoded.slice(last, cur).join('');
        const advance = positions[cur - 1].xAdvance - positions[cur - 1].advanceWidth;
        commands.push(`<${hex}> ${number(-advance)}`);
      }
      last = cur;
    };
    const flush = i => {
      addSegment(i);
      if (commands.length > 0) {
        this.addContent(`[${commands.join(' ')}] TJ`);
        commands.length = 0;
      }
    };
    for (i = 0; i < positions.length; i++) {
      const pos = positions[i];
      if (pos.xOffset || pos.yOffset) {
        flush(i);
        this.addContent(`1 0 0 1 ${number(x + pos.xOffset * scale)} ${number(y + pos.yOffset * scale)} Tm`);
        flush(i + 1);
        hadOffset = true;
      } else {
        if (hadOffset) {
          this.addContent(`1 0 0 1 ${number(x)} ${number(y)} Tm`);
          hadOffset = false;
        }
        if (pos.xAdvance - pos.advanceWidth !== 0) {
          addSegment(i + 1);
        }
      }
      x += pos.xAdvance * scale;
    }
    flush(i);
    this.addContent('ET');
    this.restore();
  }
};

const MARKERS = [0xffc0, 0xffc1, 0xffc2, 0xffc3, 0xffc5, 0xffc6, 0xffc7, 0xffc8, 0xffc9, 0xffca, 0xffcb, 0xffcc, 0xffcd, 0xffce, 0xffcf];
const COLOR_SPACE_MAP = {
  1: 'DeviceGray',
  3: 'DeviceRGB',
  4: 'DeviceCMYK'
};
class JPEG {
  constructor(data, label) {
    let marker;
    this.data = data;
    this.label = label;
    if (this.data.readUInt16BE(0) !== 0xffd8) {
      throw 'SOI not found in JPEG';
    }
    this.orientation = exif.fromBuffer(this.data).Orientation || 1;
    let pos = 2;
    while (pos < this.data.length) {
      marker = this.data.readUInt16BE(pos);
      pos += 2;
      if (MARKERS.includes(marker)) {
        break;
      }
      pos += this.data.readUInt16BE(pos);
    }
    if (!MARKERS.includes(marker)) {
      throw 'Invalid JPEG.';
    }
    pos += 2;
    this.bits = this.data[pos++];
    this.height = this.data.readUInt16BE(pos);
    pos += 2;
    this.width = this.data.readUInt16BE(pos);
    pos += 2;
    const channels = this.data[pos++];
    this.colorSpace = COLOR_SPACE_MAP[channels];
    this.obj = null;
  }
  embed(document) {
    if (this.obj) {
      return;
    }
    this.obj = document.ref({
      Type: 'XObject',
      Subtype: 'Image',
      BitsPerComponent: this.bits,
      Width: this.width,
      Height: this.height,
      ColorSpace: this.colorSpace,
      Filter: 'DCTDecode'
    });
    if (this.colorSpace === 'DeviceCMYK') {
      this.obj.data['Decode'] = [1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0];
    }
    this.obj.end(this.data);
    return this.data = null;
  }
}

class PNGImage {
  constructor(data, label) {
    this.label = label;
    this.image = new PNG(data);
    this.width = this.image.width;
    this.height = this.image.height;
    this.imgData = this.image.imgData;
    this.obj = null;
  }
  embed(document) {
    let dataDecoded = false;
    this.document = document;
    if (this.obj) {
      return;
    }
    const hasAlphaChannel = this.image.hasAlphaChannel;
    const isInterlaced = this.image.interlaceMethod === 1;
    this.obj = this.document.ref({
      Type: 'XObject',
      Subtype: 'Image',
      BitsPerComponent: hasAlphaChannel ? 8 : this.image.bits,
      Width: this.width,
      Height: this.height,
      Filter: 'FlateDecode'
    });
    if (!hasAlphaChannel) {
      const params = this.document.ref({
        Predictor: isInterlaced ? 1 : 15,
        Colors: this.image.colors,
        BitsPerComponent: this.image.bits,
        Columns: this.width
      });
      this.obj.data['DecodeParms'] = params;
      params.end();
    }
    if (this.image.palette.length === 0) {
      this.obj.data['ColorSpace'] = this.image.colorSpace;
    } else {
      const palette = this.document.ref();
      palette.end(Buffer.from(this.image.palette));
      this.obj.data['ColorSpace'] = ['Indexed', 'DeviceRGB', this.image.palette.length / 3 - 1, palette];
    }
    if (this.image.transparency.grayscale != null) {
      const val = this.image.transparency.grayscale;
      this.obj.data['Mask'] = [val, val];
    } else if (this.image.transparency.rgb) {
      const {
        rgb
      } = this.image.transparency;
      const mask = [];
      for (let x of rgb) {
        mask.push(x, x);
      }
      this.obj.data['Mask'] = mask;
    } else if (this.image.transparency.indexed) {
      dataDecoded = true;
      return this.loadIndexedAlphaChannel();
    } else if (hasAlphaChannel) {
      dataDecoded = true;
      return this.splitAlphaChannel();
    }
    if (isInterlaced && !dataDecoded) {
      return this.decodeData();
    }
    this.finalize();
  }
  finalize() {
    if (this.alphaChannel) {
      const sMask = this.document.ref({
        Type: 'XObject',
        Subtype: 'Image',
        Height: this.height,
        Width: this.width,
        BitsPerComponent: 8,
        Filter: 'FlateDecode',
        ColorSpace: 'DeviceGray',
        Decode: [0, 1]
      });
      sMask.end(this.alphaChannel);
      this.obj.data['SMask'] = sMask;
    }
    this.obj.end(this.imgData);
    this.image = null;
    return this.imgData = null;
  }
  splitAlphaChannel() {
    return this.image.decodePixels(pixels => {
      let a, p;
      const colorCount = this.image.colors;
      const pixelCount = this.width * this.height;
      const imgData = Buffer.alloc(pixelCount * colorCount);
      const alphaChannel = Buffer.alloc(pixelCount);
      let i = p = a = 0;
      const len = pixels.length;
      const skipByteCount = this.image.bits === 16 ? 1 : 0;
      while (i < len) {
        for (let colorIndex = 0; colorIndex < colorCount; colorIndex++) {
          imgData[p++] = pixels[i++];
          i += skipByteCount;
        }
        alphaChannel[a++] = pixels[i++];
        i += skipByteCount;
      }
      this.imgData = zlib.deflateSync(imgData);
      this.alphaChannel = zlib.deflateSync(alphaChannel);
      return this.finalize();
    });
  }
  loadIndexedAlphaChannel() {
    const transparency = this.image.transparency.indexed;
    return this.image.decodePixels(pixels => {
      const alphaChannel = Buffer.alloc(this.width * this.height);
      let i = 0;
      for (let j = 0, end = pixels.length; j < end; j++) {
        alphaChannel[i++] = transparency[pixels[j]];
      }
      this.alphaChannel = zlib.deflateSync(alphaChannel);
      return this.finalize();
    });
  }
  decodeData() {
    this.image.decodePixels(pixels => {
      this.imgData = zlib.deflateSync(pixels);
      this.finalize();
    });
  }
}

class PDFImage {
  static open(src, label) {
    let data;
    if (Buffer.isBuffer(src)) {
      data = src;
    } else if (src instanceof ArrayBuffer) {
      data = Buffer.from(new Uint8Array(src));
    } else {
      const match = /^data:.+?;base64,(.*)$/.exec(src);
      if (match) {
        data = Buffer.from(match[1], 'base64');
      } else {
        data = fs.readFileSync(src);
        if (!data) {
          return;
        }
      }
    }
    if (data[0] === 0xff && data[1] === 0xd8) {
      return new JPEG(data, label);
    } else if (data[0] === 0x89 && data.toString('ascii', 1, 4) === 'PNG') {
      return new PNGImage(data, label);
    } else {
      throw new Error('Unknown image format.');
    }
  }
}

var ImagesMixin = {
  initImages() {
    this._imageRegistry = {};
    this._imageCount = 0;
  },
  image(src, x, y, options = {}) {
    let bh, bp, bw, image, ip, left, left1, originX, originY;
    if (typeof x === 'object') {
      options = x;
      x = null;
    }
    const ignoreOrientation = options.ignoreOrientation || options.ignoreOrientation !== false && this.options.ignoreOrientation;
    const inDocumentFlow = typeof y !== 'number';
    x = (left = x != null ? x : options.x) != null ? left : this.x;
    y = (left1 = y != null ? y : options.y) != null ? left1 : this.y;
    if (typeof src === 'string') {
      image = this._imageRegistry[src];
    }
    if (!image) {
      if (src.width && src.height) {
        image = src;
      } else {
        image = this.openImage(src);
      }
    }
    if (!image.obj) {
      image.embed(this);
    }
    if (this.page.xobjects[image.label] == null) {
      this.page.xobjects[image.label] = image.obj;
    }
    let {
      width,
      height
    } = image;
    if (!ignoreOrientation && image.orientation > 4) {
      [width, height] = [height, width];
    }
    let w = options.width || width;
    let h = options.height || height;
    if (options.width && !options.height) {
      const wp = w / width;
      w = width * wp;
      h = height * wp;
    } else if (options.height && !options.width) {
      const hp = h / height;
      w = width * hp;
      h = height * hp;
    } else if (options.scale) {
      w = width * options.scale;
      h = height * options.scale;
    } else if (options.fit) {
      [bw, bh] = options.fit;
      bp = bw / bh;
      ip = width / height;
      if (ip > bp) {
        w = bw;
        h = bw / ip;
      } else {
        h = bh;
        w = bh * ip;
      }
    } else if (options.cover) {
      [bw, bh] = options.cover;
      bp = bw / bh;
      ip = width / height;
      if (ip > bp) {
        h = bh;
        w = bh * ip;
      } else {
        w = bw;
        h = bw / ip;
      }
    }
    if (options.fit || options.cover) {
      if (options.align === 'center') {
        x = x + bw / 2 - w / 2;
      } else if (options.align === 'right') {
        x = x + bw - w;
      }
      if (options.valign === 'center') {
        y = y + bh / 2 - h / 2;
      } else if (options.valign === 'bottom') {
        y = y + bh - h;
      }
    }
    let rotateAngle = 0;
    let xTransform = x;
    let yTransform = y;
    let hTransform = h;
    let wTransform = w;
    if (!ignoreOrientation) {
      switch (image.orientation) {
        default:
        case 1:
          hTransform = -h;
          yTransform += h;
          break;
        case 2:
          wTransform = -w;
          hTransform = -h;
          xTransform += w;
          yTransform += h;
          break;
        case 3:
          originX = x;
          originY = y;
          hTransform = -h;
          xTransform -= w;
          rotateAngle = 180;
          break;
        case 4:
          break;
        case 5:
          originX = x;
          originY = y;
          wTransform = h;
          hTransform = w;
          yTransform -= hTransform;
          rotateAngle = 90;
          break;
        case 6:
          originX = x;
          originY = y;
          wTransform = h;
          hTransform = -w;
          rotateAngle = 90;
          break;
        case 7:
          originX = x;
          originY = y;
          hTransform = -w;
          wTransform = -h;
          xTransform += h;
          rotateAngle = 90;
          break;
        case 8:
          originX = x;
          originY = y;
          wTransform = h;
          hTransform = -w;
          xTransform -= h;
          yTransform += w;
          rotateAngle = -90;
          break;
      }
    } else {
      hTransform = -h;
      yTransform += h;
    }
    if (options.link != null) {
      this.link(x, y, w, h, options.link);
    }
    if (options.goTo != null) {
      this.goTo(x, y, w, h, options.goTo);
    }
    if (options.destination != null) {
      this.addNamedDestination(options.destination, 'XYZ', x, y, null);
    }
    if (inDocumentFlow) {
      this.y += h;
    }
    this.save();
    if (rotateAngle) {
      this.rotate(rotateAngle, {
        origin: [originX, originY]
      });
    }
    this.transform(wTransform, 0, 0, hTransform, xTransform, yTransform);
    this.addContent(`/${image.label} Do`);
    this.restore();
    return this;
  },
  openImage(src) {
    let image;
    if (typeof src === 'string') {
      image = this._imageRegistry[src];
    }
    if (!image) {
      image = PDFImage.open(src, `I${++this._imageCount}`);
      if (typeof src === 'string') {
        this._imageRegistry[src] = image;
      }
    }
    return image;
  }
};

var AnnotationsMixin = {
  annotate(x, y, w, h, options) {
    options.Type = 'Annot';
    options.Rect = this._convertRect(x, y, w, h);
    options.Border = [0, 0, 0];
    if (options.Subtype === 'Link' && typeof options.F === 'undefined') {
      options.F = 1 << 2;
    }
    if (options.Subtype !== 'Link') {
      if (options.C == null) {
        options.C = this._normalizeColor(options.color || [0, 0, 0]);
      }
    }
    delete options.color;
    if (typeof options.Dest === 'string') {
      options.Dest = new String(options.Dest);
    }
    for (let key in options) {
      const val = options[key];
      options[key[0].toUpperCase() + key.slice(1)] = val;
    }
    const ref = this.ref(options);
    this.page.annotations.push(ref);
    ref.end();
    return this;
  },
  note(x, y, w, h, contents, options = {}) {
    options.Subtype = 'Text';
    options.Contents = new String(contents);
    if (options.Name == null) {
      options.Name = 'Comment';
    }
    if (options.color == null) {
      options.color = [243, 223, 92];
    }
    return this.annotate(x, y, w, h, options);
  },
  goTo(x, y, w, h, name, options = {}) {
    options.Subtype = 'Link';
    options.A = this.ref({
      S: 'GoTo',
      D: new String(name)
    });
    options.A.end();
    return this.annotate(x, y, w, h, options);
  },
  link(x, y, w, h, url, options = {}) {
    options.Subtype = 'Link';
    if (typeof url === 'number') {
      const pages = this._root.data.Pages.data;
      if (url >= 0 && url < pages.Kids.length) {
        options.A = this.ref({
          S: 'GoTo',
          D: [pages.Kids[url], 'XYZ', null, null, null]
        });
        options.A.end();
      } else {
        throw new Error(`The document has no page ${url}`);
      }
    } else {
      options.A = this.ref({
        S: 'URI',
        URI: new String(url)
      });
      options.A.end();
    }
    return this.annotate(x, y, w, h, options);
  },
  _markup(x, y, w, h, options = {}) {
    const [x1, y1, x2, y2] = this._convertRect(x, y, w, h);
    options.QuadPoints = [x1, y2, x2, y2, x1, y1, x2, y1];
    options.Contents = new String();
    return this.annotate(x, y, w, h, options);
  },
  highlight(x, y, w, h, options = {}) {
    options.Subtype = 'Highlight';
    if (options.color == null) {
      options.color = [241, 238, 148];
    }
    return this._markup(x, y, w, h, options);
  },
  underline(x, y, w, h, options = {}) {
    options.Subtype = 'Underline';
    return this._markup(x, y, w, h, options);
  },
  strike(x, y, w, h, options = {}) {
    options.Subtype = 'StrikeOut';
    return this._markup(x, y, w, h, options);
  },
  lineAnnotation(x1, y1, x2, y2, options = {}) {
    options.Subtype = 'Line';
    options.Contents = new String();
    options.L = [x1, this.page.height - y1, x2, this.page.height - y2];
    return this.annotate(x1, y1, x2, y2, options);
  },
  rectAnnotation(x, y, w, h, options = {}) {
    options.Subtype = 'Square';
    options.Contents = new String();
    return this.annotate(x, y, w, h, options);
  },
  ellipseAnnotation(x, y, w, h, options = {}) {
    options.Subtype = 'Circle';
    options.Contents = new String();
    return this.annotate(x, y, w, h, options);
  },
  textAnnotation(x, y, w, h, text, options = {}) {
    options.Subtype = 'FreeText';
    options.Contents = new String(text);
    options.DA = new String();
    return this.annotate(x, y, w, h, options);
  },
  fileAnnotation(x, y, w, h, file = {}, options = {}) {
    const filespec = this.file(file.src, Object.assign({
      hidden: true
    }, file));
    options.Subtype = 'FileAttachment';
    options.FS = filespec;
    if (options.Contents) {
      options.Contents = new String(options.Contents);
    } else if (filespec.data.Desc) {
      options.Contents = filespec.data.Desc;
    }
    return this.annotate(x, y, w, h, options);
  },
  _convertRect(x1, y1, w, h) {
    let y2 = y1;
    y1 += h;
    let x2 = x1 + w;
    const [m0, m1, m2, m3, m4, m5] = this._ctm;
    x1 = m0 * x1 + m2 * y1 + m4;
    y1 = m1 * x1 + m3 * y1 + m5;
    x2 = m0 * x2 + m2 * y2 + m4;
    y2 = m1 * x2 + m3 * y2 + m5;
    return [x1, y1, x2, y2];
  }
};

class PDFOutline {
  constructor(document, parent, title, dest, options = {
    expanded: false
  }) {
    this.document = document;
    this.options = options;
    this.outlineData = {};
    if (dest !== null) {
      this.outlineData['Dest'] = [dest.dictionary, 'Fit'];
    }
    if (parent !== null) {
      this.outlineData['Parent'] = parent;
    }
    if (title !== null) {
      this.outlineData['Title'] = new String(title);
    }
    this.dictionary = this.document.ref(this.outlineData);
    this.children = [];
  }
  addItem(title, options = {
    expanded: false
  }) {
    const result = new PDFOutline(this.document, this.dictionary, title, this.document.page, options);
    this.children.push(result);
    return result;
  }
  endOutline() {
    if (this.children.length > 0) {
      if (this.options.expanded) {
        this.outlineData.Count = this.children.length;
      }
      const first = this.children[0],
        last = this.children[this.children.length - 1];
      this.outlineData.First = first.dictionary;
      this.outlineData.Last = last.dictionary;
      for (let i = 0, len = this.children.length; i < len; i++) {
        const child = this.children[i];
        if (i > 0) {
          child.outlineData.Prev = this.children[i - 1].dictionary;
        }
        if (i < this.children.length - 1) {
          child.outlineData.Next = this.children[i + 1].dictionary;
        }
        child.endOutline();
      }
    }
    return this.dictionary.end();
  }
}

var OutlineMixin = {
  initOutline() {
    this.outline = new PDFOutline(this, null, null, null);
  },
  endOutline() {
    this.outline.endOutline();
    if (this.outline.children.length > 0) {
      this._root.data.Outlines = this.outline.dictionary;
      return this._root.data.PageMode = 'UseOutlines';
    }
  }
};

class PDFStructureContent {
  constructor(pageRef, mcid) {
    this.refs = [{
      pageRef,
      mcid
    }];
  }
  push(structContent) {
    structContent.refs.forEach(ref => this.refs.push(ref));
  }
}

class PDFStructureElement {
  constructor(document, type, options = {}, children = null) {
    this.document = document;
    this._attached = false;
    this._ended = false;
    this._flushed = false;
    this.dictionary = document.ref({
      S: type
    });
    const data = this.dictionary.data;
    if (Array.isArray(options) || this._isValidChild(options)) {
      children = options;
      options = {};
    }
    if (typeof options.title !== 'undefined') {
      data.T = new String(options.title);
    }
    if (typeof options.lang !== 'undefined') {
      data.Lang = new String(options.lang);
    }
    if (typeof options.alt !== 'undefined') {
      data.Alt = new String(options.alt);
    }
    if (typeof options.expanded !== 'undefined') {
      data.E = new String(options.expanded);
    }
    if (typeof options.actual !== 'undefined') {
      data.ActualText = new String(options.actual);
    }
    this._children = [];
    if (children) {
      if (!Array.isArray(children)) {
        children = [children];
      }
      children.forEach(child => this.add(child));
      this.end();
    }
  }
  add(child) {
    if (this._ended) {
      throw new Error(`Cannot add child to already-ended structure element`);
    }
    if (!this._isValidChild(child)) {
      throw new Error(`Invalid structure element child`);
    }
    if (child instanceof PDFStructureElement) {
      child.setParent(this.dictionary);
      if (this._attached) {
        child.setAttached();
      }
    }
    if (child instanceof PDFStructureContent) {
      this._addContentToParentTree(child);
    }
    if (typeof child === 'function' && this._attached) {
      child = this._contentForClosure(child);
    }
    this._children.push(child);
    return this;
  }
  _addContentToParentTree(content) {
    content.refs.forEach(({
      pageRef,
      mcid
    }) => {
      const pageStructParents = this.document.getStructParentTree().get(pageRef.data.StructParents);
      pageStructParents[mcid] = this.dictionary;
    });
  }
  setParent(parentRef) {
    if (this.dictionary.data.P) {
      throw new Error(`Structure element added to more than one parent`);
    }
    this.dictionary.data.P = parentRef;
    this._flush();
  }
  setAttached() {
    if (this._attached) {
      return;
    }
    this._children.forEach((child, index) => {
      if (child instanceof PDFStructureElement) {
        child.setAttached();
      }
      if (typeof child === 'function') {
        this._children[index] = this._contentForClosure(child);
      }
    });
    this._attached = true;
    this._flush();
  }
  end() {
    if (this._ended) {
      return;
    }
    this._children.filter(child => child instanceof PDFStructureElement).forEach(child => child.end());
    this._ended = true;
    this._flush();
  }
  _isValidChild(child) {
    return child instanceof PDFStructureElement || child instanceof PDFStructureContent || typeof child === 'function';
  }
  _contentForClosure(closure) {
    const content = this.document.markStructureContent(this.dictionary.data.S);
    closure();
    this.document.endMarkedContent();
    this._addContentToParentTree(content);
    return content;
  }
  _isFlushable() {
    if (!this.dictionary.data.P || !this._ended) {
      return false;
    }
    return this._children.every(child => {
      if (typeof child === 'function') {
        return false;
      }
      if (child instanceof PDFStructureElement) {
        return child._isFlushable();
      }
      return true;
    });
  }
  _flush() {
    if (this._flushed || !this._isFlushable()) {
      return;
    }
    this.dictionary.data.K = [];
    this._children.forEach(child => this._flushChild(child));
    this.dictionary.end();
    this._children = [];
    this.dictionary.data.K = null;
    this._flushed = true;
  }
  _flushChild(child) {
    if (child instanceof PDFStructureElement) {
      this.dictionary.data.K.push(child.dictionary);
    }
    if (child instanceof PDFStructureContent) {
      child.refs.forEach(({
        pageRef,
        mcid
      }) => {
        if (!this.dictionary.data.Pg) {
          this.dictionary.data.Pg = pageRef;
        }
        if (this.dictionary.data.Pg === pageRef) {
          this.dictionary.data.K.push(mcid);
        } else {
          this.dictionary.data.K.push({
            Type: 'MCR',
            Pg: pageRef,
            MCID: mcid
          });
        }
      });
    }
  }
}

class PDFNumberTree extends PDFTree {
  _compareKeys(a, b) {
    return parseInt(a) - parseInt(b);
  }
  _keysName() {
    return 'Nums';
  }
  _dataForKey(k) {
    return parseInt(k);
  }
}

var MarkingsMixin = {
  initMarkings(options) {
    this.structChildren = [];
    if (options.tagged) {
      this.getMarkInfoDictionary().data.Marked = true;
      this.getStructTreeRoot();
    }
  },
  markContent(tag, options = null) {
    if (tag === 'Artifact' || options && options.mcid) {
      let toClose = 0;
      this.page.markings.forEach(marking => {
        if (toClose || marking.structContent || marking.tag === 'Artifact') {
          toClose++;
        }
      });
      while (toClose--) {
        this.endMarkedContent();
      }
    }
    if (!options) {
      this.page.markings.push({
        tag
      });
      this.addContent(`/${tag} BMC`);
      return this;
    }
    this.page.markings.push({
      tag,
      options
    });
    const dictionary = {};
    if (typeof options.mcid !== 'undefined') {
      dictionary.MCID = options.mcid;
    }
    if (tag === 'Artifact') {
      if (typeof options.type === 'string') {
        dictionary.Type = options.type;
      }
      if (Array.isArray(options.bbox)) {
        dictionary.BBox = [options.bbox[0], this.page.height - options.bbox[3], options.bbox[2], this.page.height - options.bbox[1]];
      }
      if (Array.isArray(options.attached) && options.attached.every(val => typeof val === 'string')) {
        dictionary.Attached = options.attached;
      }
    }
    if (tag === 'Span') {
      if (options.lang) {
        dictionary.Lang = new String(options.lang);
      }
      if (options.alt) {
        dictionary.Alt = new String(options.alt);
      }
      if (options.expanded) {
        dictionary.E = new String(options.expanded);
      }
      if (options.actual) {
        dictionary.ActualText = new String(options.actual);
      }
    }
    this.addContent(`/${tag} ${PDFObject.convert(dictionary)} BDC`);
    return this;
  },
  markStructureContent(tag, options = {}) {
    const pageStructParents = this.getStructParentTree().get(this.page.structParentTreeKey);
    const mcid = pageStructParents.length;
    pageStructParents.push(null);
    this.markContent(tag, {
      ...options,
      mcid
    });
    const structContent = new PDFStructureContent(this.page.dictionary, mcid);
    this.page.markings.slice(-1)[0].structContent = structContent;
    return structContent;
  },
  endMarkedContent() {
    this.page.markings.pop();
    this.addContent('EMC');
    return this;
  },
  struct(type, options = {}, children = null) {
    return new PDFStructureElement(this, type, options, children);
  },
  addStructure(structElem) {
    const structTreeRoot = this.getStructTreeRoot();
    structElem.setParent(structTreeRoot);
    structElem.setAttached();
    this.structChildren.push(structElem);
    if (!structTreeRoot.data.K) {
      structTreeRoot.data.K = [];
    }
    structTreeRoot.data.K.push(structElem.dictionary);
    return this;
  },
  initPageMarkings(pageMarkings) {
    pageMarkings.forEach(marking => {
      if (marking.structContent) {
        const structContent = marking.structContent;
        const newStructContent = this.markStructureContent(marking.tag, marking.options);
        structContent.push(newStructContent);
        this.page.markings.slice(-1)[0].structContent = structContent;
      } else {
        this.markContent(marking.tag, marking.options);
      }
    });
  },
  endPageMarkings(page) {
    const pageMarkings = page.markings;
    pageMarkings.forEach(() => page.write('EMC'));
    page.markings = [];
    return pageMarkings;
  },
  getMarkInfoDictionary() {
    if (!this._root.data.MarkInfo) {
      this._root.data.MarkInfo = this.ref({});
    }
    return this._root.data.MarkInfo;
  },
  hasMarkInfoDictionary() {
    return !!this._root.data.MarkInfo;
  },
  getStructTreeRoot() {
    if (!this._root.data.StructTreeRoot) {
      this._root.data.StructTreeRoot = this.ref({
        Type: 'StructTreeRoot',
        ParentTree: new PDFNumberTree(),
        ParentTreeNextKey: 0
      });
    }
    return this._root.data.StructTreeRoot;
  },
  getStructParentTree() {
    return this.getStructTreeRoot().data.ParentTree;
  },
  createStructParentTreeNextKey() {
    this.getMarkInfoDictionary();
    const structTreeRoot = this.getStructTreeRoot();
    const key = structTreeRoot.data.ParentTreeNextKey++;
    structTreeRoot.data.ParentTree.add(key, []);
    return key;
  },
  endMarkings() {
    const structTreeRoot = this._root.data.StructTreeRoot;
    if (structTreeRoot) {
      structTreeRoot.end();
      this.structChildren.forEach(structElem => structElem.end());
    }
    if (this._root.data.MarkInfo) {
      this._root.data.MarkInfo.end();
    }
  }
};

const FIELD_FLAGS = {
  readOnly: 1,
  required: 2,
  noExport: 4,
  multiline: 0x1000,
  password: 0x2000,
  toggleToOffButton: 0x4000,
  radioButton: 0x8000,
  pushButton: 0x10000,
  combo: 0x20000,
  edit: 0x40000,
  sort: 0x80000,
  multiSelect: 0x200000,
  noSpell: 0x400000
};
const FIELD_JUSTIFY = {
  left: 0,
  center: 1,
  right: 2
};
const VALUE_MAP = {
  value: 'V',
  defaultValue: 'DV'
};
const FORMAT_SPECIAL = {
  zip: '0',
  zipPlus4: '1',
  zip4: '1',
  phone: '2',
  ssn: '3'
};
const FORMAT_DEFAULT = {
  number: {
    nDec: 0,
    sepComma: false,
    negStyle: 'MinusBlack',
    currency: '',
    currencyPrepend: true
  },
  percent: {
    nDec: 0,
    sepComma: false
  }
};
var AcroFormMixin = {
  initForm() {
    if (!this._font) {
      throw new Error('Must set a font before calling initForm method');
    }
    this._acroform = {
      fonts: {},
      defaultFont: this._font.name
    };
    this._acroform.fonts[this._font.id] = this._font.ref();
    let data = {
      Fields: [],
      NeedAppearances: true,
      DA: new String(`/${this._font.id} 0 Tf 0 g`),
      DR: {
        Font: {}
      }
    };
    data.DR.Font[this._font.id] = this._font.ref();
    const AcroForm = this.ref(data);
    this._root.data.AcroForm = AcroForm;
    return this;
  },
  endAcroForm() {
    if (this._root.data.AcroForm) {
      if (!Object.keys(this._acroform.fonts).length && !this._acroform.defaultFont) {
        throw new Error('No fonts specified for PDF form');
      }
      let fontDict = this._root.data.AcroForm.data.DR.Font;
      Object.keys(this._acroform.fonts).forEach(name => {
        fontDict[name] = this._acroform.fonts[name];
      });
      this._root.data.AcroForm.data.Fields.forEach(fieldRef => {
        this._endChild(fieldRef);
      });
      this._root.data.AcroForm.end();
    }
    return this;
  },
  _endChild(ref) {
    if (Array.isArray(ref.data.Kids)) {
      ref.data.Kids.forEach(childRef => {
        this._endChild(childRef);
      });
      ref.end();
    }
    return this;
  },
  formField(name, options = {}) {
    let fieldDict = this._fieldDict(name, null, options);
    let fieldRef = this.ref(fieldDict);
    this._addToParent(fieldRef);
    return fieldRef;
  },
  formAnnotation(name, type, x, y, w, h, options = {}) {
    let fieldDict = this._fieldDict(name, type, options);
    fieldDict.Subtype = 'Widget';
    if (fieldDict.F === undefined) {
      fieldDict.F = 4;
    }
    this.annotate(x, y, w, h, fieldDict);
    let annotRef = this.page.annotations[this.page.annotations.length - 1];
    return this._addToParent(annotRef);
  },
  formText(name, x, y, w, h, options = {}) {
    return this.formAnnotation(name, 'text', x, y, w, h, options);
  },
  formPushButton(name, x, y, w, h, options = {}) {
    return this.formAnnotation(name, 'pushButton', x, y, w, h, options);
  },
  formCombo(name, x, y, w, h, options = {}) {
    return this.formAnnotation(name, 'combo', x, y, w, h, options);
  },
  formList(name, x, y, w, h, options = {}) {
    return this.formAnnotation(name, 'list', x, y, w, h, options);
  },
  formRadioButton(name, x, y, w, h, options = {}) {
    return this.formAnnotation(name, 'radioButton', x, y, w, h, options);
  },
  formCheckbox(name, x, y, w, h, options = {}) {
    return this.formAnnotation(name, 'checkbox', x, y, w, h, options);
  },
  _addToParent(fieldRef) {
    let parent = fieldRef.data.Parent;
    if (parent) {
      if (!parent.data.Kids) {
        parent.data.Kids = [];
      }
      parent.data.Kids.push(fieldRef);
    } else {
      this._root.data.AcroForm.data.Fields.push(fieldRef);
    }
    return this;
  },
  _fieldDict(name, type, options = {}) {
    if (!this._acroform) {
      throw new Error('Call document.initForm() method before adding form elements to document');
    }
    let opts = Object.assign({}, options);
    if (type !== null) {
      opts = this._resolveType(type, options);
    }
    opts = this._resolveFlags(opts);
    opts = this._resolveJustify(opts);
    opts = this._resolveFont(opts);
    opts = this._resolveStrings(opts);
    opts = this._resolveColors(opts);
    opts = this._resolveFormat(opts);
    opts.T = new String(name);
    if (opts.parent) {
      opts.Parent = opts.parent;
      delete opts.parent;
    }
    return opts;
  },
  _resolveType(type, opts) {
    if (type === 'text') {
      opts.FT = 'Tx';
    } else if (type === 'pushButton') {
      opts.FT = 'Btn';
      opts.pushButton = true;
    } else if (type === 'radioButton') {
      opts.FT = 'Btn';
      opts.radioButton = true;
    } else if (type === 'checkbox') {
      opts.FT = 'Btn';
    } else if (type === 'combo') {
      opts.FT = 'Ch';
      opts.combo = true;
    } else if (type === 'list') {
      opts.FT = 'Ch';
    } else {
      throw new Error(`Invalid form annotation type '${type}'`);
    }
    return opts;
  },
  _resolveFormat(opts) {
    const f = opts.format;
    if (f && f.type) {
      let fnKeystroke;
      let fnFormat;
      let params = '';
      if (FORMAT_SPECIAL[f.type] !== undefined) {
        fnKeystroke = `AFSpecial_Keystroke`;
        fnFormat = `AFSpecial_Format`;
        params = FORMAT_SPECIAL[f.type];
      } else {
        let format = f.type.charAt(0).toUpperCase() + f.type.slice(1);
        fnKeystroke = `AF${format}_Keystroke`;
        fnFormat = `AF${format}_Format`;
        if (f.type === 'date') {
          fnKeystroke += 'Ex';
          params = String(f.param);
        } else if (f.type === 'time') {
          params = String(f.param);
        } else if (f.type === 'number') {
          let p = Object.assign({}, FORMAT_DEFAULT.number, f);
          params = String([String(p.nDec), p.sepComma ? '0' : '1', '"' + p.negStyle + '"', 'null', '"' + p.currency + '"', String(p.currencyPrepend)].join(','));
        } else if (f.type === 'percent') {
          let p = Object.assign({}, FORMAT_DEFAULT.percent, f);
          params = String([String(p.nDec), p.sepComma ? '0' : '1'].join(','));
        }
      }
      opts.AA = opts.AA ? opts.AA : {};
      opts.AA.K = {
        S: 'JavaScript',
        JS: new String(`${fnKeystroke}(${params});`)
      };
      opts.AA.F = {
        S: 'JavaScript',
        JS: new String(`${fnFormat}(${params});`)
      };
    }
    delete opts.format;
    return opts;
  },
  _resolveColors(opts) {
    let color = this._normalizeColor(opts.backgroundColor);
    if (color) {
      if (!opts.MK) {
        opts.MK = {};
      }
      opts.MK.BG = color;
    }
    color = this._normalizeColor(opts.borderColor);
    if (color) {
      if (!opts.MK) {
        opts.MK = {};
      }
      opts.MK.BC = color;
    }
    delete opts.backgroundColor;
    delete opts.borderColor;
    return opts;
  },
  _resolveFlags(options) {
    let result = 0;
    Object.keys(options).forEach(key => {
      if (FIELD_FLAGS[key]) {
        if (options[key]) {
          result |= FIELD_FLAGS[key];
        }
        delete options[key];
      }
    });
    if (result !== 0) {
      options.Ff = options.Ff ? options.Ff : 0;
      options.Ff |= result;
    }
    return options;
  },
  _resolveJustify(options) {
    let result = 0;
    if (options.align !== undefined) {
      if (typeof FIELD_JUSTIFY[options.align] === 'number') {
        result = FIELD_JUSTIFY[options.align];
      }
      delete options.align;
    }
    if (result !== 0) {
      options.Q = result;
    }
    return options;
  },
  _resolveFont(options) {
    if (this._acroform.fonts[this._font.id] == null) {
      this._acroform.fonts[this._font.id] = this._font.ref();
    }
    if (this._acroform.defaultFont !== this._font.name) {
      options.DR = {
        Font: {}
      };
      const fontSize = options.fontSize || 0;
      options.DR.Font[this._font.id] = this._font.ref();
      options.DA = new String(`/${this._font.id} ${fontSize} Tf 0 g`);
    }
    return options;
  },
  _resolveStrings(options) {
    let select = [];
    function appendChoices(a) {
      if (Array.isArray(a)) {
        for (let idx = 0; idx < a.length; idx++) {
          if (typeof a[idx] === 'string') {
            select.push(new String(a[idx]));
          } else {
            select.push(a[idx]);
          }
        }
      }
    }
    appendChoices(options.Opt);
    if (options.select) {
      appendChoices(options.select);
      delete options.select;
    }
    if (select.length) {
      options.Opt = select;
    }
    Object.keys(VALUE_MAP).forEach(key => {
      if (options[key] !== undefined) {
        options[VALUE_MAP[key]] = options[key];
        delete options[key];
      }
    });
    ['V', 'DV'].forEach(key => {
      if (typeof options[key] === 'string') {
        options[key] = new String(options[key]);
      }
    });
    if (options.MK && options.MK.CA) {
      options.MK.CA = new String(options.MK.CA);
    }
    if (options.label) {
      options.MK = options.MK ? options.MK : {};
      options.MK.CA = new String(options.label);
      delete options.label;
    }
    return options;
  }
};

var AttachmentsMixin = {
  file(src, options = {}) {
    options.name = options.name || src;
    options.relationship = options.relationship || 'Unspecified';
    const refBody = {
      Type: 'EmbeddedFile',
      Params: {}
    };
    let data;
    if (!src) {
      throw new Error('No src specified');
    }
    if (Buffer.isBuffer(src)) {
      data = src;
    } else if (src instanceof ArrayBuffer) {
      data = Buffer.from(new Uint8Array(src));
    } else {
      const match = /^data:(.*?);base64,(.*)$/.exec(src);
      if (match) {
        if (match[1]) {
          refBody.Subtype = match[1].replace('/', '#2F');
        }
        data = Buffer.from(match[2], 'base64');
      } else {
        data = fs.readFileSync(src);
        if (!data) {
          throw new Error(`Could not read contents of file at filepath ${src}`);
        }
        const {
          birthtime,
          ctime
        } = fs.statSync(src);
        refBody.Params.CreationDate = birthtime;
        refBody.Params.ModDate = ctime;
      }
    }
    if (options.creationDate instanceof Date) {
      refBody.Params.CreationDate = options.creationDate;
    }
    if (options.modifiedDate instanceof Date) {
      refBody.Params.ModDate = options.modifiedDate;
    }
    if (options.type) {
      refBody.Subtype = options.type.replace('/', '#2F');
    }
    const checksum = CryptoJS.MD5(CryptoJS.lib.WordArray.create(new Uint8Array(data)));
    refBody.Params.CheckSum = new String(checksum);
    refBody.Params.Size = data.byteLength;
    let ref;
    if (!this._fileRegistry) this._fileRegistry = {};
    let file = this._fileRegistry[options.name];
    if (file && isEqual(refBody, file)) {
      ref = file.ref;
    } else {
      ref = this.ref(refBody);
      ref.end(data);
      this._fileRegistry[options.name] = {
        ...refBody,
        ref
      };
    }
    const fileSpecBody = {
      Type: 'Filespec',
      AFRelationship: options.relationship,
      F: new String(options.name),
      EF: {
        F: ref
      },
      UF: new String(options.name)
    };
    if (options.description) {
      fileSpecBody.Desc = new String(options.description);
    }
    const filespec = this.ref(fileSpecBody);
    filespec.end();
    if (!options.hidden) {
      this.addNamedEmbeddedFile(options.name, filespec);
    }
    if (this._root.data.AF) {
      this._root.data.AF.push(filespec);
    } else {
      this._root.data.AF = [filespec];
    }
    return filespec;
  }
};
function isEqual(a, b) {
  return a.Subtype === b.Subtype && a.Params.CheckSum.toString() === b.Params.CheckSum.toString() && a.Params.Size === b.Params.Size && a.Params.CreationDate.getTime() === b.Params.CreationDate.getTime() && (a.Params.ModDate === undefined && b.Params.ModDate === undefined || a.Params.ModDate.getTime() === b.Params.ModDate.getTime());
}

var PDFA = {
  initPDFA(pSubset) {
    if (pSubset.charAt(pSubset.length - 3) === '-') {
      this.subset_conformance = pSubset.charAt(pSubset.length - 1).toUpperCase();
      this.subset = parseInt(pSubset.charAt(pSubset.length - 2));
    } else {
      this.subset_conformance = 'B';
      this.subset = parseInt(pSubset.charAt(pSubset.length - 1));
    }
  },
  endSubset() {
    this._addPdfaMetadata();
    this._addColorOutputIntent();
  },
  _addColorOutputIntent() {
    const iccProfile = Buffer("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","base64");
    const colorProfileRef = this.ref({
      Length: iccProfile.length,
      N: 3
    });
    colorProfileRef.write(iccProfile);
    colorProfileRef.end();
    const intentRef = this.ref({
      Type: 'OutputIntent',
      S: 'GTS_PDFA1',
      Info: new String('sRGB IEC61966-2.1'),
      OutputConditionIdentifier: new String('sRGB IEC61966-2.1'),
      DestOutputProfile: colorProfileRef
    });
    intentRef.end();
    this._root.data.OutputIntents = [intentRef];
  },
  _getPdfaid() {
    return `
        <rdf:Description xmlns:pdfaid="http://www.aiim.org/pdfa/ns/id/" rdf:about="">
            <pdfaid:part>${this.subset}</pdfaid:part>
            <pdfaid:conformance>${this.subset_conformance}</pdfaid:conformance>
        </rdf:Description>
        `;
  },
  _addPdfaMetadata() {
    this.appendXML(this._getPdfaid());
  }
};

var PDFUA = {
  initPDFUA() {
    this.subset = 1;
  },
  endSubset() {
    this._addPdfuaMetadata();
  },
  _addPdfuaMetadata() {
    this.appendXML(this._getPdfuaid());
  },
  _getPdfuaid() {
    return `
        <rdf:Description xmlns:pdfuaid="http://www.aiim.org/pdfua/ns/id/" rdf:about="">
            <pdfuaid:part>${this.subset}</pdfuaid:part>
        </rdf:Description>
        `;
  }
};

var SubsetMixin = {
  _importSubset(subset) {
    Object.assign(this, subset);
  },
  initSubset(options) {
    switch (options.subset) {
      case 'PDF/A-1':
      case 'PDF/A-1a':
      case 'PDF/A-1b':
      case 'PDF/A-2':
      case 'PDF/A-2a':
      case 'PDF/A-2b':
      case 'PDF/A-3':
      case 'PDF/A-3a':
      case 'PDF/A-3b':
        this._importSubset(PDFA);
        this.initPDFA(options.subset);
        break;
      case 'PDF/UA':
        this._importSubset(PDFUA);
        this.initPDFUA();
        break;
    }
  }
};

const ROW_FIELDS = ['height', 'minHeight', 'maxHeight'];
const COLUMN_FIELDS = ['width', 'minWidth', 'maxWidth'];
function memoize(fn, maxSize) {
  const cache = new Map();
  return function (...args) {
    const key = args[0];
    if (!cache.has(key)) {
      cache.set(key, fn(...args));
      if (cache.size > maxSize) cache.delete(cache.keys().next());
    }
    return cache.get(key);
  };
}
function isObject(item) {
  return item && typeof item === 'object' && !Array.isArray(item);
}
function deepMerge(target, ...sources) {
  if (!isObject(target)) return target;
  target = deepClone(target);
  for (const source of sources) {
    if (isObject(source)) {
      for (const key in source) {
        if (isObject(source[key])) {
          if (!(key in target)) target[key] = {};
          target[key] = deepMerge(target[key], source[key]);
        } else if (source[key] !== undefined) {
          target[key] = deepClone(source[key]);
        }
      }
    }
  }
  return target;
}
function deepClone(obj) {
  let result = obj;
  if (obj && typeof obj == 'object') {
    result = Array.isArray(obj) ? [] : {};
    for (const key in obj) result[key] = deepClone(obj[key]);
  }
  return result;
}

function normalizedDefaultStyle(defaultStyleInternal) {
  let defaultStyle = defaultStyleInternal;
  if (typeof defaultStyle !== 'object') defaultStyle = {
    text: defaultStyle
  };
  const defaultRowStyle = Object.fromEntries(Object.entries(defaultStyle).filter(([k]) => ROW_FIELDS.includes(k)));
  const defaultColStyle = Object.fromEntries(Object.entries(defaultStyle).filter(([k]) => COLUMN_FIELDS.includes(k)));
  defaultStyle.padding = normalizeSides(defaultStyle.padding);
  defaultStyle.border = normalizeSides(defaultStyle.border);
  defaultStyle.borderColor = normalizeSides(defaultStyle.borderColor);
  defaultStyle.align = normalizeAlignment(defaultStyle.align);
  return {
    defaultStyle,
    defaultRowStyle,
    defaultColStyle
  };
}
function normalizedRowStyle(defaultRowStyle, rowStyleInternal, i) {
  let rowStyle = rowStyleInternal(i);
  if (rowStyle == null || typeof rowStyle !== 'object') {
    rowStyle = {
      height: rowStyle
    };
  }
  rowStyle.padding = normalizeSides(rowStyle.padding);
  rowStyle.border = normalizeSides(rowStyle.border);
  rowStyle.borderColor = normalizeSides(rowStyle.borderColor);
  rowStyle.align = normalizeAlignment(rowStyle.align);
  rowStyle = deepMerge(defaultRowStyle, rowStyle);
  const document = this.document;
  const page = document.page;
  const contentHeight = page.contentHeight;
  if (rowStyle.height == null || rowStyle.height === 'auto') {
    rowStyle.height = 'auto';
  } else {
    rowStyle.height = document.sizeToPoint(rowStyle.height, 0, page, contentHeight);
  }
  rowStyle.minHeight = document.sizeToPoint(rowStyle.minHeight, 0, page, contentHeight);
  rowStyle.maxHeight = document.sizeToPoint(rowStyle.maxHeight, 0, page, contentHeight);
  return rowStyle;
}
function normalizedColumnStyle(defaultColStyle, colStyleInternal, i) {
  let colStyle = colStyleInternal(i);
  if (colStyle == null || typeof colStyle !== 'object') {
    colStyle = {
      width: colStyle
    };
  }
  colStyle.padding = normalizeSides(colStyle.padding);
  colStyle.border = normalizeSides(colStyle.border);
  colStyle.borderColor = normalizeSides(colStyle.borderColor);
  colStyle.align = normalizeAlignment(colStyle.align);
  colStyle = deepMerge(defaultColStyle, colStyle);
  if (colStyle.width == null || colStyle.width === '*') {
    colStyle.width = '*';
  } else {
    colStyle.width = this.document.sizeToPoint(colStyle.width, 0, this.document.page, this._maxWidth);
  }
  colStyle.minWidth = this.document.sizeToPoint(colStyle.minWidth, 0, this.document.page, this._maxWidth);
  colStyle.maxWidth = this.document.sizeToPoint(colStyle.maxWidth, 0, this.document.page, this._maxWidth);
  return colStyle;
}
function normalizeAlignment(align) {
  return align == null || typeof align === 'string' ? {
    x: align,
    y: align
  } : align;
}

function normalizeTable() {
  const doc = this.document;
  const opts = this.opts;
  let index = doc._tableIndex++;
  this._id = new String(opts.id ?? `table-${index}`);
  this._position = {
    x: doc.sizeToPoint(opts.position?.x, doc.x),
    y: doc.sizeToPoint(opts.position?.y, doc.y)
  };
  this._maxWidth = doc.sizeToPoint(opts.maxWidth, doc.page.width - doc.page.margins.right - this._position.x);
  const {
    defaultStyle,
    defaultColStyle,
    defaultRowStyle
  } = normalizedDefaultStyle(opts.defaultStyle);
  this._defaultStyle = defaultStyle;
  let colStyle;
  if (opts.columnStyles) {
    if (Array.isArray(opts.columnStyles)) {
      colStyle = i => opts.columnStyles[i];
    } else if (typeof opts.columnStyles === 'function') {
      colStyle = memoize(i => opts.columnStyles(i), Infinity);
    } else if (typeof opts.columnStyles === 'object') {
      colStyle = () => opts.columnStyles;
    }
  }
  if (!colStyle) colStyle = () => ({});
  this._colStyle = normalizedColumnStyle.bind(this, defaultColStyle, colStyle);
  let rowStyle;
  if (opts.rowStyles) {
    if (Array.isArray(opts.rowStyles)) {
      rowStyle = i => opts.rowStyles[i];
    } else if (typeof opts.rowStyles === 'function') {
      rowStyle = memoize(i => opts.rowStyles(i), 10);
    } else if (typeof opts.rowStyles === 'object') {
      rowStyle = () => opts.rowStyles;
    }
  }
  if (!rowStyle) rowStyle = () => ({});
  this._rowStyle = normalizedRowStyle.bind(this, defaultRowStyle, rowStyle);
}
function normalizeText(text) {
  if (text != null) text = `${text}`;
  return text;
}
function normalizeCell(cell, rowIndex, colIndex) {
  const colStyle = this._colStyle(colIndex);
  let rowStyle = this._rowStyle(rowIndex);
  const font = deepMerge({}, colStyle.font, rowStyle.font, cell.font);
  const customFont = Object.values(font).filter(v => v != null).length > 0;
  const doc = this.document;
  const rollbackFont = doc._fontSource;
  const rollbackFontSize = doc._fontSize;
  const rollbackFontFamily = doc._fontFamily;
  if (customFont) {
    if (font.src) doc.font(font.src, font.family);
    if (font.size) doc.fontSize(font.size);
    rowStyle = this._rowStyle(rowIndex);
  }
  cell.padding = normalizeSides(cell.padding);
  cell.border = normalizeSides(cell.border);
  cell.borderColor = normalizeSides(cell.borderColor);
  const config = deepMerge(this._defaultStyle, colStyle, rowStyle, cell);
  config.rowIndex = rowIndex;
  config.colIndex = colIndex;
  config.font = font ?? {};
  config.customFont = customFont;
  config.text = normalizeText(config.text);
  config.rowSpan = config.rowSpan ?? 1;
  config.colSpan = config.colSpan ?? 1;
  config.padding = normalizeSides(config.padding, '0.25em', x => doc.sizeToPoint(x, '0.25em'));
  config.border = normalizeSides(config.border, 1, x => doc.sizeToPoint(x, 1));
  config.borderColor = normalizeSides(config.borderColor, 'black', x => x ?? 'black');
  config.align = normalizeAlignment(config.align);
  config.align.x = config.align.x ?? 'left';
  config.align.y = config.align.y ?? 'top';
  config.textStroke = doc.sizeToPoint(config.textStroke, 0);
  config.textStrokeColor = config.textStrokeColor ?? 'black';
  config.textColor = config.textColor ?? 'black';
  config.textOptions = config.textOptions ?? {};
  config.id = new String(config.id ?? `${this._id}-${rowIndex}-${colIndex}`);
  config.type = config.type?.toUpperCase() === 'TH' ? 'TH' : 'TD';
  if (config.scope) {
    config.scope = config.scope.toLowerCase();
    if (config.scope === 'row') config.scope = 'Row';else if (config.scope === 'both') config.scope = 'Both';else if (config.scope === 'column') config.scope = 'Column';
  }
  if (typeof this.opts.debug === 'boolean') config.debug = this.opts.debug;
  if (customFont) doc.font(rollbackFont, rollbackFontFamily, rollbackFontSize);
  return config;
}
function normalizeRow(row, rowIndex) {
  if (!this._cellClaim) this._cellClaim = new Set();
  let colIndex = 0;
  return row.map(cell => {
    if (cell == null || typeof cell !== 'object') cell = {
      text: cell
    };
    while (this._cellClaim.has(`${rowIndex},${colIndex}`)) {
      colIndex++;
    }
    cell = normalizeCell.call(this, cell, rowIndex, colIndex);
    for (let i = 0; i < cell.rowSpan; i++) {
      for (let j = 0; j < cell.colSpan; j++) {
        this._cellClaim.add(`${rowIndex + i},${colIndex + j}`);
      }
    }
    colIndex += cell.colSpan;
    return cell;
  });
}

function ensure(row) {
  this._columnWidths = [];
  ensureColumnWidths.call(this, row.reduce((a, cell) => a + cell.colSpan, 0));
  this._rowHeights = [];
  this._rowYPos = [this._position.y];
  this._rowBuffer = new Set();
}
function ensureColumnWidths(numCols) {
  let starColumnIndexes = [];
  let starMinAcc = 0;
  let unclaimedWidth = this._maxWidth;
  for (let i = 0; i < numCols; i++) {
    let col = this._colStyle(i);
    if (col.width === '*') {
      starColumnIndexes[i] = col;
      starMinAcc += col.minWidth;
    } else {
      unclaimedWidth -= col.width;
      this._columnWidths[i] = col.width;
    }
  }
  let starColCount = starColumnIndexes.reduce(x => x + 1, 0);
  if (starMinAcc >= unclaimedWidth) {
    starColumnIndexes.forEach((cell, i) => {
      this._columnWidths[i] = cell.minWidth;
    });
  } else if (starColCount > 0) {
    starColumnIndexes.forEach((col, i) => {
      let starSize = unclaimedWidth / starColCount;
      this._columnWidths[i] = Math.max(starSize, col.minWidth);
      if (col.maxWidth > 0) {
        this._columnWidths[i] = Math.min(this._columnWidths[i], col.maxWidth);
      }
      unclaimedWidth -= this._columnWidths[i];
      starColCount--;
    });
  }
  let tempX = this._position.x;
  this._columnXPos = Array.from(this._columnWidths, v => {
    const t = tempX;
    tempX += v;
    return t;
  });
}
function measure(row, rowIndex) {
  row.forEach(cell => this._rowBuffer.add(cell));
  if (rowIndex > 0) {
    this._rowYPos[rowIndex] = this._rowYPos[rowIndex - 1] + this._rowHeights[rowIndex - 1];
  }
  const rowStyle = this._rowStyle(rowIndex);
  let toRender = [];
  this._rowBuffer.forEach(cell => {
    if (cell.rowIndex + cell.rowSpan - 1 === rowIndex) {
      toRender.push(measureCell.call(this, cell, rowStyle.height));
      this._rowBuffer.delete(cell);
    }
  });
  let rowHeight = rowStyle.height;
  if (rowHeight === 'auto') {
    rowHeight = toRender.reduce((acc, cell) => {
      let minHeight = cell.textBounds.height + cell.padding.top + cell.padding.bottom;
      for (let i = 0; i < cell.rowSpan - 1; i++) {
        minHeight -= this._rowHeights[cell.rowIndex + i];
      }
      return Math.max(acc, minHeight);
    }, 0);
  }
  rowHeight = Math.max(rowHeight, rowStyle.minHeight);
  if (rowStyle.maxHeight > 0) {
    rowHeight = Math.min(rowHeight, rowStyle.maxHeight);
  }
  this._rowHeights[rowIndex] = rowHeight;
  let newPage = false;
  if (rowHeight > this.document.page.contentHeight) {
    console.warn(new Error(`Row ${rowIndex} requested more than the safe page height, row has been clamped`).stack.slice(7));
    this._rowHeights[rowIndex] = this.document.page.maxY() - this._rowYPos[rowIndex];
  } else if (this._rowYPos[rowIndex] + rowHeight >= this.document.page.maxY()) {
    this._rowYPos[rowIndex] = this.document.page.margins.top;
    newPage = true;
  }
  return {
    newPage,
    toRender: toRender.map(cell => measureCell.call(this, cell, rowHeight))
  };
}
function measureCell(cell, rowHeight) {
  let cellWidth = 0;
  for (let i = 0; i < cell.colSpan; i++) {
    cellWidth += this._columnWidths[cell.colIndex + i];
  }
  let cellHeight = rowHeight;
  if (cellHeight === 'auto') {
    cellHeight = this.document.page.contentHeight;
  } else {
    for (let i = 0; i < cell.rowSpan - 1; i++) {
      cellHeight += this._rowHeights[cell.rowIndex + i];
    }
  }
  const textAllocatedWidth = cellWidth - cell.padding.left - cell.padding.right;
  const textAllocatedHeight = cellHeight - cell.padding.top - cell.padding.bottom;
  const rotation = cell.textOptions.rotation ?? 0;
  const {
    width: textMaxWidth,
    height: textMaxHeight
  } = computeBounds(rotation, textAllocatedWidth, textAllocatedHeight);
  const textOptions = {
    align: cell.align.x,
    ellipsis: true,
    stroke: cell.textStroke > 0,
    fill: true,
    width: textMaxWidth,
    height: textMaxHeight,
    rotation,
    ...cell.textOptions
  };
  let textBounds = {
    x: 0,
    y: 0,
    width: 0,
    height: 0
  };
  if (cell.text) {
    const rollbackFont = this.document._fontSource;
    const rollbackFontSize = this.document._fontSize;
    const rollbackFontFamily = this.document._fontFamily;
    if (cell.font?.src) this.document.font(cell.font.src, cell.font?.family);
    if (cell.font?.size) this.document.fontSize(cell.font.size);
    const unRotatedTextBounds = this.document.boundsOfString(cell.text, 0, 0, {
      ...textOptions,
      rotation: 0
    });
    textOptions.width = unRotatedTextBounds.width;
    textOptions.height = unRotatedTextBounds.height;
    textBounds = this.document.boundsOfString(cell.text, 0, 0, textOptions);
    this.document.font(rollbackFont, rollbackFontFamily, rollbackFontSize);
  }
  return {
    ...cell,
    textOptions,
    x: this._columnXPos[cell.colIndex],
    y: this._rowYPos[cell.rowIndex],
    textX: this._columnXPos[cell.colIndex] + cell.padding.left,
    textY: this._rowYPos[cell.rowIndex] + cell.padding.top,
    width: cellWidth,
    height: cellHeight,
    textAllocatedHeight,
    textAllocatedWidth,
    textBounds
  };
}
function computeBounds(rotation, allocWidth, allocHeight) {
  let textMaxWidth, textMaxHeight;
  const cos = cosine(rotation);
  const sin = sine(rotation);
  if (rotation === 0 || rotation === 180) {
    textMaxWidth = allocWidth;
    textMaxHeight = allocHeight;
  } else if (rotation === 90 || rotation === 270) {
    textMaxWidth = allocHeight;
    textMaxHeight = allocWidth;
  } else if (rotation < 90 || rotation > 180 && rotation < 270) {
    textMaxWidth = allocWidth / (2 * cos);
    textMaxHeight = allocWidth / (2 * sin);
  } else {
    textMaxHeight = allocWidth / (2 * cos);
    textMaxWidth = allocWidth / (2 * sin);
  }
  const EF = sin * textMaxWidth;
  const FG = cos * textMaxHeight;
  if (EF + FG > allocHeight) {
    const denominator = cos * cos - sin * sin;
    if (rotation === 0 || rotation === 180) {
      textMaxWidth = allocWidth;
      textMaxHeight = allocHeight;
    } else if (rotation === 90 || rotation === 270) {
      textMaxWidth = allocHeight;
      textMaxHeight = allocWidth;
    } else if (rotation < 90 || rotation > 180 && rotation < 270) {
      textMaxWidth = (allocWidth * cos - allocHeight * sin) / denominator;
      textMaxHeight = (allocHeight * cos - allocWidth * sin) / denominator;
    } else {
      textMaxHeight = (allocWidth * cos - allocHeight * sin) / denominator;
      textMaxWidth = (allocHeight * cos - allocWidth * sin) / denominator;
    }
  }
  return {
    width: Math.abs(textMaxWidth),
    height: Math.abs(textMaxHeight)
  };
}

function accommodateTable() {
  const structParent = this.opts.structParent;
  if (structParent) {
    this._tableStruct = this.document.struct('Table');
    this._tableStruct.dictionary.data.ID = this._id;
    if (structParent instanceof PDFStructureElement) {
      structParent.add(this._tableStruct);
    } else if (structParent instanceof PDFDocument) {
      structParent.addStructure(this._tableStruct);
    }
    this._headerRowLookup = {};
    this._headerColumnLookup = {};
  }
}
function accommodateCleanup() {
  if (this._tableStruct) this._tableStruct.end();
}
function accessibleRow(row, rowIndex, renderCell) {
  const rowStruct = this.document.struct('TR');
  rowStruct.dictionary.data.ID = new String(`${this._id}-${rowIndex}`);
  this._tableStruct.add(rowStruct);
  row.forEach(cell => renderCell(cell, rowStruct));
  rowStruct.end();
}
function accessibleCell(cell, rowStruct, callback) {
  const doc = this.document;
  const cellStruct = doc.struct(cell.type, {
    title: cell.title
  });
  cellStruct.dictionary.data.ID = cell.id;
  rowStruct.add(cellStruct);
  const padding = cell.padding;
  const border = cell.border;
  const attributes = {
    O: 'Table',
    Width: cell.width,
    Height: cell.height,
    Padding: [padding.top, padding.bottom, padding.left, padding.right],
    RowSpan: cell.rowSpan > 1 ? cell.rowSpan : undefined,
    ColSpan: cell.colSpan > 1 ? cell.colSpan : undefined,
    BorderThickness: [border.top, border.bottom, border.left, border.right]
  };
  if (cell.type === 'TH') {
    if (cell.scope === 'Row' || cell.scope === 'Both') {
      for (let i = 0; i < cell.rowSpan; i++) {
        if (!this._headerRowLookup[cell.rowIndex + i]) {
          this._headerRowLookup[cell.rowIndex + i] = [];
        }
        this._headerRowLookup[cell.rowIndex + i].push(cell.id);
      }
      attributes.Scope = cell.scope;
    }
    if (cell.scope === 'Column' || cell.scope === 'Both') {
      for (let i = 0; i < cell.colSpan; i++) {
        if (!this._headerColumnLookup[cell.colIndex + i]) {
          this._headerColumnLookup[cell.colIndex + i] = [];
        }
        this._headerColumnLookup[cell.colIndex + i].push(cell.id);
      }
      attributes.Scope = cell.scope;
    }
  }
  const Headers = new Set([...Array.from({
    length: cell.colSpan
  }, (_, i) => this._headerColumnLookup[cell.colIndex + i]).flat(), ...Array.from({
    length: cell.rowSpan
  }, (_, i) => this._headerRowLookup[cell.rowIndex + i]).flat()].filter(Boolean));
  if (Headers.size) attributes.Headers = Array.from(Headers);
  const normalizeColor = doc._normalizeColor;
  if (cell.backgroundColor != null) {
    attributes.BackgroundColor = normalizeColor(cell.backgroundColor);
  }
  const hasBorder = [border.top, border.bottom, border.left, border.right];
  if (hasBorder.some(x => x)) {
    const borderColor = cell.borderColor;
    attributes.BorderColor = [hasBorder[0] ? normalizeColor(borderColor.top) : null, hasBorder[1] ? normalizeColor(borderColor.bottom) : null, hasBorder[2] ? normalizeColor(borderColor.left) : null, hasBorder[3] ? normalizeColor(borderColor.right) : null];
  }
  Object.keys(attributes).forEach(key => attributes[key] === undefined && delete attributes[key]);
  cellStruct.dictionary.data.A = doc.ref(attributes);
  cellStruct.add(callback);
  cellStruct.end();
  cellStruct.dictionary.data.A.end();
}

function renderRow(row, rowIndex) {
  if (this._tableStruct) {
    accessibleRow.call(this, row, rowIndex, renderCell.bind(this));
  } else {
    row.forEach(cell => renderCell.call(this, cell));
  }
  return this._rowYPos[rowIndex] + this._rowHeights[rowIndex];
}
function renderCell(cell, rowStruct) {
  const cellRenderer = () => {
    if (cell.backgroundColor != null) {
      this.document.save().rect(cell.x, cell.y, cell.width, cell.height).fill(cell.backgroundColor).restore();
    }
    renderBorder.call(this, cell.border, cell.borderColor, cell.x, cell.y, cell.width, cell.height);
    if (cell.debug) {
      this.document.save();
      this.document.dash(1, {
        space: 1
      }).lineWidth(1).strokeOpacity(0.3);
      this.document.rect(cell.x, cell.y, cell.width, cell.height).stroke('green');
      this.document.restore();
    }
    if (cell.text) renderCellText.call(this, cell);
  };
  if (rowStruct) accessibleCell.call(this, cell, rowStruct, cellRenderer);else cellRenderer();
}
function renderCellText(cell) {
  const doc = this.document;
  const rollbackFont = doc._fontSource;
  const rollbackFontSize = doc._fontSize;
  const rollbackFontFamily = doc._fontFamily;
  if (cell.customFont) {
    if (cell.font.src) doc.font(cell.font.src, cell.font.family);
    if (cell.font.size) doc.fontSize(cell.font.size);
  }
  const x = cell.textX;
  const y = cell.textY;
  const Ah = cell.textAllocatedHeight;
  const Aw = cell.textAllocatedWidth;
  const Cw = cell.textBounds.width;
  const Ch = cell.textBounds.height;
  const Ox = -cell.textBounds.x;
  const Oy = -cell.textBounds.y;
  const PxScale = cell.align.x === 'right' ? 1 : cell.align.x === 'center' ? 0.5 : 0;
  const Px = (Aw - Cw) * PxScale;
  const PyScale = cell.align.y === 'bottom' ? 1 : cell.align.y === 'center' ? 0.5 : 0;
  const Py = (Ah - Ch) * PyScale;
  const dx = Px + Ox;
  const dy = Py + Oy;
  if (cell.debug) {
    doc.save();
    doc.dash(1, {
      space: 1
    }).lineWidth(1).strokeOpacity(0.3);
    if (cell.text) {
      doc.moveTo(x + Px, y).lineTo(x + Px, y + Ah).moveTo(x + Px + Cw, y).lineTo(x + Px + Cw, y + Ah).stroke('blue').moveTo(x, y + Py).lineTo(x + Aw, y + Py).moveTo(x, y + Py + Ch).lineTo(x + Aw, y + Py + Ch).stroke('green');
    }
    doc.rect(x, y, Aw, Ah).stroke('orange');
    doc.restore();
  }
  doc.save().rect(x, y, Aw, Ah).clip();
  doc.fillColor(cell.textColor).strokeColor(cell.textStrokeColor);
  if (cell.textStroke > 0) doc.lineWidth(cell.textStroke);
  doc.text(cell.text, x + dx, y + dy, cell.textOptions);
  doc.restore();
  if (cell.font) doc.font(rollbackFont, rollbackFontFamily, rollbackFontSize);
}
function renderBorder(border, borderColor, x, y, width, height, mask) {
  border = Object.fromEntries(Object.entries(border).map(([k, v]) => [k, mask && !mask[k] ? 0 : v]));
  const doc = this.document;
  if ([border.right, border.bottom, border.left].every(val => val === border.top)) {
    if (border.top > 0) {
      doc.save().lineWidth(border.top).rect(x, y, width, height).stroke(borderColor.top).restore();
    }
  } else {
    if (border.top > 0) {
      doc.save().lineWidth(border.top).moveTo(x, y).lineTo(x + width, y).stroke(borderColor.top).restore();
    }
    if (border.right > 0) {
      doc.save().lineWidth(border.right).moveTo(x + width, y).lineTo(x + width, y + height).stroke(borderColor.right).restore();
    }
    if (border.bottom > 0) {
      doc.save().lineWidth(border.bottom).moveTo(x + width, y + height).lineTo(x, y + height).stroke(borderColor.bottom).restore();
    }
    if (border.left > 0) {
      doc.save().lineWidth(border.left).moveTo(x, y + height).lineTo(x, y).stroke(borderColor.left).restore();
    }
  }
}

class PDFTable {
  constructor(document, opts = {}) {
    this.document = document;
    this.opts = Object.freeze(opts);
    normalizeTable.call(this);
    accommodateTable.call(this);
    this._currRowIndex = 0;
    this._ended = false;
    if (opts.data) {
      for (const row of opts.data) this.row(row);
      return this.end();
    }
  }
  row(row, lastRow = false) {
    if (this._ended) {
      throw new Error(`Table was marked as ended on row ${this._currRowIndex}`);
    }
    row = Array.from(row);
    row = normalizeRow.call(this, row, this._currRowIndex);
    if (this._currRowIndex === 0) ensure.call(this, row);
    const {
      newPage,
      toRender
    } = measure.call(this, row, this._currRowIndex);
    if (newPage) this.document.continueOnNewPage();
    const yPos = renderRow.call(this, toRender, this._currRowIndex);
    this.document.x = this._position.x;
    this.document.y = yPos;
    if (lastRow) return this.end();
    this._currRowIndex++;
    return this;
  }
  end() {
    while (this._rowBuffer?.size) this.row([]);
    this._ended = true;
    accommodateCleanup.call(this);
    return this.document;
  }
}

var TableMixin = {
  initTables() {
    this._tableIndex = 0;
  },
  table(opts) {
    return new PDFTable(this, opts);
  }
};

class PDFMetadata {
  constructor() {
    this._metadata = `
        <?xpacket begin="\ufeff" id="W5M0MpCehiHzreSzNTczkc9d"?>
            <x:xmpmeta xmlns:x="adobe:ns:meta/">
                <rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">
        `;
  }
  _closeTags() {
    this._metadata = this._metadata.concat(`
                </rdf:RDF>
            </x:xmpmeta>
        <?xpacket end="w"?>
        `);
  }
  append(xml, newline = true) {
    this._metadata = this._metadata.concat(xml);
    if (newline) this._metadata = this._metadata.concat('\n');
  }
  getXML() {
    return this._metadata;
  }
  getLength() {
    return this._metadata.length;
  }
  end() {
    this._closeTags();
    this._metadata = this._metadata.trim();
  }
}

var MetadataMixin = {
  initMetadata() {
    this.metadata = new PDFMetadata();
  },
  appendXML(xml, newline = true) {
    this.metadata.append(xml, newline);
  },
  _addInfo() {
    this.appendXML(`
        <rdf:Description rdf:about="" xmlns:xmp="http://ns.adobe.com/xap/1.0/">
            <xmp:CreateDate>${this.info.CreationDate.toISOString().split('.')[0] + 'Z'}</xmp:CreateDate>
            <xmp:CreatorTool>${this.info.Creator}</xmp:CreatorTool>
        </rdf:Description>
        `);
    if (this.info.Title || this.info.Author || this.info.Subject) {
      this.appendXML(`
            <rdf:Description rdf:about="" xmlns:dc="http://purl.org/dc/elements/1.1/">
            `);
      if (this.info.Title) {
        this.appendXML(`
                <dc:title>
                    <rdf:Alt>
                        <rdf:li xml:lang="x-default">${this.info.Title}</rdf:li>
                    </rdf:Alt>
                </dc:title>
                `);
      }
      if (this.info.Author) {
        this.appendXML(`
                <dc:creator>
                    <rdf:Seq>
                        <rdf:li>${this.info.Author}</rdf:li>
                    </rdf:Seq>
                </dc:creator>
                `);
      }
      if (this.info.Subject) {
        this.appendXML(`
                <dc:description>
                    <rdf:Alt>
                        <rdf:li xml:lang="x-default">${this.info.Subject}</rdf:li>
                    </rdf:Alt>
                </dc:description>
                `);
      }
      this.appendXML(`
            </rdf:Description>
            `);
    }
    this.appendXML(`
        <rdf:Description rdf:about="" xmlns:pdf="http://ns.adobe.com/pdf/1.3/">
            <pdf:Producer>${this.info.Creator}</pdf:Producer>`, false);
    if (this.info.Keywords) {
      this.appendXML(`
            <pdf:Keywords>${this.info.Keywords}</pdf:Keywords>`, false);
    }
    this.appendXML(`
        </rdf:Description>
        `);
  },
  endMetadata() {
    this._addInfo();
    this.metadata.end();
    if (this.version != 1.3) {
      this.metadataRef = this.ref({
        length: this.metadata.getLength(),
        Type: 'Metadata',
        Subtype: 'XML'
      });
      this.metadataRef.compress = false;
      this.metadataRef.write(Buffer.from(this.metadata.getXML(), 'utf-8'));
      this.metadataRef.end();
      this._root.data.Metadata = this.metadataRef;
    }
  }
};

class PDFDocument extends stream.Readable {
  constructor(options = {}) {
    super(options);
    this.options = options;
    switch (options.pdfVersion) {
      case '1.4':
        this.version = 1.4;
        break;
      case '1.5':
        this.version = 1.5;
        break;
      case '1.6':
        this.version = 1.6;
        break;
      case '1.7':
      case '1.7ext3':
        this.version = 1.7;
        break;
      default:
        this.version = 1.3;
        break;
    }
    this.compress = this.options.compress != null ? this.options.compress : true;
    this._pageBuffer = [];
    this._pageBufferStart = 0;
    this._offsets = [];
    this._waiting = 0;
    this._ended = false;
    this._offset = 0;
    const Pages = this.ref({
      Type: 'Pages',
      Count: 0,
      Kids: []
    });
    const Names = this.ref({
      Dests: new PDFNameTree()
    });
    this._root = this.ref({
      Type: 'Catalog',
      Pages,
      Names
    });
    if (this.options.lang) {
      this._root.data.Lang = new String(this.options.lang);
    }
    this.page = null;
    this.initMetadata();
    this.initColor();
    this.initVector();
    this.initFonts(options.font);
    this.initText();
    this.initImages();
    this.initOutline();
    this.initMarkings(options);
    this.initTables();
    this.initSubset(options);
    this.info = {
      Producer: 'PDFKit',
      Creator: 'PDFKit',
      CreationDate: new Date()
    };
    if (this.options.info) {
      for (let key in this.options.info) {
        const val = this.options.info[key];
        this.info[key] = val;
      }
    }
    if (this.options.displayTitle) {
      this._root.data.ViewerPreferences = this.ref({
        DisplayDocTitle: true
      });
    }
    this._id = PDFSecurity.generateFileID(this.info);
    this._security = PDFSecurity.create(this, options);
    this._write(`%PDF-${this.version}`);
    this._write('%\xFF\xFF\xFF\xFF');
    if (this.options.autoFirstPage !== false) {
      this.addPage();
    }
  }
  addPage(options) {
    if (options == null) {
      ({
        options
      } = this);
    }
    if (!this.options.bufferPages) {
      this.flushPages();
    }
    this.page = new PDFPage(this, options);
    this._pageBuffer.push(this.page);
    const pages = this._root.data.Pages.data;
    pages.Kids.push(this.page.dictionary);
    pages.Count++;
    this.x = this.page.margins.left;
    this.y = this.page.margins.top;
    this._ctm = [1, 0, 0, 1, 0, 0];
    this.transform(1, 0, 0, -1, 0, this.page.height);
    this.emit('pageAdded');
    return this;
  }
  continueOnNewPage(options) {
    const pageMarkings = this.endPageMarkings(this.page);
    this.addPage(options ?? this.page._options);
    this.initPageMarkings(pageMarkings);
    return this;
  }
  bufferedPageRange() {
    return {
      start: this._pageBufferStart,
      count: this._pageBuffer.length
    };
  }
  switchToPage(n) {
    let page;
    if (!(page = this._pageBuffer[n - this._pageBufferStart])) {
      throw new Error(`switchToPage(${n}) out of bounds, current buffer covers pages ${this._pageBufferStart} to ${this._pageBufferStart + this._pageBuffer.length - 1}`);
    }
    return this.page = page;
  }
  flushPages() {
    const pages = this._pageBuffer;
    this._pageBuffer = [];
    this._pageBufferStart += pages.length;
    for (let page of pages) {
      this.endPageMarkings(page);
      page.end();
    }
  }
  addNamedDestination(name, ...args) {
    if (args.length === 0) {
      args = ['XYZ', null, null, null];
    }
    if (args[0] === 'XYZ' && args[2] !== null) {
      args[2] = this.page.height - args[2];
    }
    args.unshift(this.page.dictionary);
    this._root.data.Names.data.Dests.add(name, args);
  }
  addNamedEmbeddedFile(name, ref) {
    if (!this._root.data.Names.data.EmbeddedFiles) {
      this._root.data.Names.data.EmbeddedFiles = new PDFNameTree({
        limits: false
      });
    }
    this._root.data.Names.data.EmbeddedFiles.add(name, ref);
  }
  addNamedJavaScript(name, js) {
    if (!this._root.data.Names.data.JavaScript) {
      this._root.data.Names.data.JavaScript = new PDFNameTree();
    }
    let data = {
      JS: new String(js),
      S: 'JavaScript'
    };
    this._root.data.Names.data.JavaScript.add(name, data);
  }
  ref(data) {
    const ref = new PDFReference(this, this._offsets.length + 1, data);
    this._offsets.push(null);
    this._waiting++;
    return ref;
  }
  _read() {}
  _write(data) {
    if (!Buffer.isBuffer(data)) {
      data = Buffer.from(data + '\n', 'binary');
    }
    this.push(data);
    this._offset += data.length;
  }
  addContent(data) {
    this.page.write(data);
    return this;
  }
  _refEnd(ref) {
    this._offsets[ref.id - 1] = ref.offset;
    if (--this._waiting === 0 && this._ended) {
      this._finalize();
      this._ended = false;
    }
  }
  end() {
    this.flushPages();
    this._info = this.ref();
    for (let key in this.info) {
      let val = this.info[key];
      if (typeof val === 'string') {
        val = new String(val);
      }
      let entry = this.ref(val);
      entry.end();
      this._info.data[key] = entry;
    }
    this._info.end();
    for (let name in this._fontFamilies) {
      const font = this._fontFamilies[name];
      font.finalize();
    }
    this.endOutline();
    this.endMarkings();
    if (this.subset) {
      this.endSubset();
    }
    this.endMetadata();
    this._root.end();
    this._root.data.Pages.end();
    this._root.data.Names.end();
    this.endAcroForm();
    if (this._root.data.ViewerPreferences) {
      this._root.data.ViewerPreferences.end();
    }
    if (this._security) {
      this._security.end();
    }
    if (this._waiting === 0) {
      this._finalize();
    } else {
      this._ended = true;
    }
  }
  _finalize() {
    const xRefOffset = this._offset;
    this._write('xref');
    this._write(`0 ${this._offsets.length + 1}`);
    this._write('0000000000 65535 f ');
    for (let offset of this._offsets) {
      offset = `0000000000${offset}`.slice(-10);
      this._write(offset + ' 00000 n ');
    }
    const trailer = {
      Size: this._offsets.length + 1,
      Root: this._root,
      Info: this._info,
      ID: [this._id, this._id]
    };
    if (this._security) {
      trailer.Encrypt = this._security.dictionary;
    }
    this._write('trailer');
    this._write(PDFObject.convert(trailer));
    this._write('startxref');
    this._write(`${xRefOffset}`);
    this._write('%%EOF');
    this.push(null);
  }
  toString() {
    return '[object PDFDocument]';
  }
}
const mixin = methods => {
  Object.assign(PDFDocument.prototype, methods);
};
mixin(MetadataMixin);
mixin(ColorMixin);
mixin(VectorMixin);
mixin(FontsMixin);
mixin(TextMixin);
mixin(ImagesMixin);
mixin(AnnotationsMixin);
mixin(OutlineMixin);
mixin(MarkingsMixin);
mixin(AcroFormMixin);
mixin(AttachmentsMixin);
mixin(SubsetMixin);
mixin(TableMixin);
PDFDocument.LineWrapper = LineWrapper;

module.exports = PDFDocument;


}).call(this)}).call(this,require("buffer").Buffer)
},{"buffer":36,"crypto-js":56,"events":94,"fontkit":96,"fs":35,"jpeg-exif":118,"linebreak":120,"png-js":135,"stream":142,"zlib":23}],2:[function(require,module,exports){
"use strict";

function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else obj[key] = value;

    return obj;
}
exports._ = _define_property;

},{}],3:[function(require,module,exports){
"use strict";

exports._ = require("tslib").__decorate;

},{"tslib":159}],4:[function(require,module,exports){
(function (global){(function (){
'use strict';

var objectAssign = require('object.assign/polyfill')();

// compare and isBuffer taken from https://github.com/feross/buffer/blob/680e9e5e488f22aac27599a57dc844a6315928dd/index.js
// original notice:

/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
function compare(a, b) {
  if (a === b) {
    return 0;
  }

  var x = a.length;
  var y = b.length;

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i];
      y = b[i];
      break;
    }
  }

  if (x < y) {
    return -1;
  }
  if (y < x) {
    return 1;
  }
  return 0;
}
function isBuffer(b) {
  if (global.Buffer && typeof global.Buffer.isBuffer === 'function') {
    return global.Buffer.isBuffer(b);
  }
  return !!(b != null && b._isBuffer);
}

// based on node assert, original notice:
// NB: The URL to the CommonJS spec is kept just for tradition.
//     node-assert has evolved a lot since then, both in API and behavior.

// http://wiki.commonjs.org/wiki/Unit_Testing/1.0
//
// THIS IS NOT TESTED NOR LIKELY TO WORK OUTSIDE V8!
//
// Originally from narwhal.js (http://narwhaljs.org)
// Copyright (c) 2009 Thomas Robinson <280north.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the 'Software'), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

var util = require('util/');
var hasOwn = Object.prototype.hasOwnProperty;
var pSlice = Array.prototype.slice;
var functionsHaveNames = (function () {
  return function foo() {}.name === 'foo';
}());
function pToString (obj) {
  return Object.prototype.toString.call(obj);
}
function isView(arrbuf) {
  if (isBuffer(arrbuf)) {
    return false;
  }
  if (typeof global.ArrayBuffer !== 'function') {
    return false;
  }
  if (typeof ArrayBuffer.isView === 'function') {
    return ArrayBuffer.isView(arrbuf);
  }
  if (!arrbuf) {
    return false;
  }
  if (arrbuf instanceof DataView) {
    return true;
  }
  if (arrbuf.buffer && arrbuf.buffer instanceof ArrayBuffer) {
    return true;
  }
  return false;
}
// 1. The assert module provides functions that throw
// AssertionError's when particular conditions are not met. The
// assert module must conform to the following interface.

var assert = module.exports = ok;

// 2. The AssertionError is defined in assert.
// new assert.AssertionError({ message: message,
//                             actual: actual,
//                             expected: expected })

var regex = /\s*function\s+([^\(\s]*)\s*/;
// based on https://github.com/ljharb/function.prototype.name/blob/adeeeec8bfcc6068b187d7d9fb3d5bb1d3a30899/implementation.js
function getName(func) {
  if (!util.isFunction(func)) {
    return;
  }
  if (functionsHaveNames) {
    return func.name;
  }
  var str = func.toString();
  var match = str.match(regex);
  return match && match[1];
}
assert.AssertionError = function AssertionError(options) {
  this.name = 'AssertionError';
  this.actual = options.actual;
  this.expected = options.expected;
  this.operator = options.operator;
  if (options.message) {
    this.message = options.message;
    this.generatedMessage = false;
  } else {
    this.message = getMessage(this);
    this.generatedMessage = true;
  }
  var stackStartFunction = options.stackStartFunction || fail;
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, stackStartFunction);
  } else {
    // non v8 browsers so we can have a stacktrace
    var err = new Error();
    if (err.stack) {
      var out = err.stack;

      // try to strip useless frames
      var fn_name = getName(stackStartFunction);
      var idx = out.indexOf('\n' + fn_name);
      if (idx >= 0) {
        // once we have located the function frame
        // we need to strip out everything before it (and its line)
        var next_line = out.indexOf('\n', idx + 1);
        out = out.substring(next_line + 1);
      }

      this.stack = out;
    }
  }
};

// assert.AssertionError instanceof Error
util.inherits(assert.AssertionError, Error);

function truncate(s, n) {
  if (typeof s === 'string') {
    return s.length < n ? s : s.slice(0, n);
  } else {
    return s;
  }
}
function inspect(something) {
  if (functionsHaveNames || !util.isFunction(something)) {
    return util.inspect(something);
  }
  var rawname = getName(something);
  var name = rawname ? ': ' + rawname : '';
  return '[Function' +  name + ']';
}
function getMessage(self) {
  return truncate(inspect(self.actual), 128) + ' ' +
         self.operator + ' ' +
         truncate(inspect(self.expected), 128);
}

// At present only the three keys mentioned above are used and
// understood by the spec. Implementations or sub modules can pass
// other keys to the AssertionError's constructor - they will be
// ignored.

// 3. All of the following functions must throw an AssertionError
// when a corresponding condition is not met, with a message that
// may be undefined if not provided.  All assertion methods provide
// both the actual and expected values to the assertion error for
// display purposes.

function fail(actual, expected, message, operator, stackStartFunction) {
  throw new assert.AssertionError({
    message: message,
    actual: actual,
    expected: expected,
    operator: operator,
    stackStartFunction: stackStartFunction
  });
}

// EXTENSION! allows for well behaved errors defined elsewhere.
assert.fail = fail;

// 4. Pure assertion tests whether a value is truthy, as determined
// by !!guard.
// assert.ok(guard, message_opt);
// This statement is equivalent to assert.equal(true, !!guard,
// message_opt);. To test strictly for the value true, use
// assert.strictEqual(true, guard, message_opt);.

function ok(value, message) {
  if (!value) fail(value, true, message, '==', assert.ok);
}
assert.ok = ok;

// 5. The equality assertion tests shallow, coercive equality with
// ==.
// assert.equal(actual, expected, message_opt);

assert.equal = function equal(actual, expected, message) {
  if (actual != expected) fail(actual, expected, message, '==', assert.equal);
};

// 6. The non-equality assertion tests for whether two objects are not equal
// with != assert.notEqual(actual, expected, message_opt);

assert.notEqual = function notEqual(actual, expected, message) {
  if (actual == expected) {
    fail(actual, expected, message, '!=', assert.notEqual);
  }
};

// 7. The equivalence assertion tests a deep equality relation.
// assert.deepEqual(actual, expected, message_opt);

assert.deepEqual = function deepEqual(actual, expected, message) {
  if (!_deepEqual(actual, expected, false)) {
    fail(actual, expected, message, 'deepEqual', assert.deepEqual);
  }
};

assert.deepStrictEqual = function deepStrictEqual(actual, expected, message) {
  if (!_deepEqual(actual, expected, true)) {
    fail(actual, expected, message, 'deepStrictEqual', assert.deepStrictEqual);
  }
};

function _deepEqual(actual, expected, strict, memos) {
  // 7.1. All identical values are equivalent, as determined by ===.
  if (actual === expected) {
    return true;
  } else if (isBuffer(actual) && isBuffer(expected)) {
    return compare(actual, expected) === 0;

  // 7.2. If the expected value is a Date object, the actual value is
  // equivalent if it is also a Date object that refers to the same time.
  } else if (util.isDate(actual) && util.isDate(expected)) {
    return actual.getTime() === expected.getTime();

  // 7.3 If the expected value is a RegExp object, the actual value is
  // equivalent if it is also a RegExp object with the same source and
  // properties (`global`, `multiline`, `lastIndex`, `ignoreCase`).
  } else if (util.isRegExp(actual) && util.isRegExp(expected)) {
    return actual.source === expected.source &&
           actual.global === expected.global &&
           actual.multiline === expected.multiline &&
           actual.lastIndex === expected.lastIndex &&
           actual.ignoreCase === expected.ignoreCase;

  // 7.4. Other pairs that do not both pass typeof value == 'object',
  // equivalence is determined by ==.
  } else if ((actual === null || typeof actual !== 'object') &&
             (expected === null || typeof expected !== 'object')) {
    return strict ? actual === expected : actual == expected;

  // If both values are instances of typed arrays, wrap their underlying
  // ArrayBuffers in a Buffer each to increase performance
  // This optimization requires the arrays to have the same type as checked by
  // Object.prototype.toString (aka pToString). Never perform binary
  // comparisons for Float*Arrays, though, since e.g. +0 === -0 but their
  // bit patterns are not identical.
  } else if (isView(actual) && isView(expected) &&
             pToString(actual) === pToString(expected) &&
             !(actual instanceof Float32Array ||
               actual instanceof Float64Array)) {
    return compare(new Uint8Array(actual.buffer),
                   new Uint8Array(expected.buffer)) === 0;

  // 7.5 For all other Object pairs, including Array objects, equivalence is
  // determined by having the same number of owned properties (as verified
  // with Object.prototype.hasOwnProperty.call), the same set of keys
  // (although not necessarily the same order), equivalent values for every
  // corresponding key, and an identical 'prototype' property. Note: this
  // accounts for both named and indexed properties on Arrays.
  } else if (isBuffer(actual) !== isBuffer(expected)) {
    return false;
  } else {
    memos = memos || {actual: [], expected: []};

    var actualIndex = memos.actual.indexOf(actual);
    if (actualIndex !== -1) {
      if (actualIndex === memos.expected.indexOf(expected)) {
        return true;
      }
    }

    memos.actual.push(actual);
    memos.expected.push(expected);

    return objEquiv(actual, expected, strict, memos);
  }
}

function isArguments(object) {
  return Object.prototype.toString.call(object) == '[object Arguments]';
}

function objEquiv(a, b, strict, actualVisitedObjects) {
  if (a === null || a === undefined || b === null || b === undefined)
    return false;
  // if one is a primitive, the other must be same
  if (util.isPrimitive(a) || util.isPrimitive(b))
    return a === b;
  if (strict && Object.getPrototypeOf(a) !== Object.getPrototypeOf(b))
    return false;
  var aIsArgs = isArguments(a);
  var bIsArgs = isArguments(b);
  if ((aIsArgs && !bIsArgs) || (!aIsArgs && bIsArgs))
    return false;
  if (aIsArgs) {
    a = pSlice.call(a);
    b = pSlice.call(b);
    return _deepEqual(a, b, strict);
  }
  var ka = objectKeys(a);
  var kb = objectKeys(b);
  var key, i;
  // having the same number of owned properties (keys incorporates
  // hasOwnProperty)
  if (ka.length !== kb.length)
    return false;
  //the same set of keys (although not necessarily the same order),
  ka.sort();
  kb.sort();
  //~~~cheap key test
  for (i = ka.length - 1; i >= 0; i--) {
    if (ka[i] !== kb[i])
      return false;
  }
  //equivalent values for every corresponding key, and
  //~~~possibly expensive deep test
  for (i = ka.length - 1; i >= 0; i--) {
    key = ka[i];
    if (!_deepEqual(a[key], b[key], strict, actualVisitedObjects))
      return false;
  }
  return true;
}

// 8. The non-equivalence assertion tests for any deep inequality.
// assert.notDeepEqual(actual, expected, message_opt);

assert.notDeepEqual = function notDeepEqual(actual, expected, message) {
  if (_deepEqual(actual, expected, false)) {
    fail(actual, expected, message, 'notDeepEqual', assert.notDeepEqual);
  }
};

assert.notDeepStrictEqual = notDeepStrictEqual;
function notDeepStrictEqual(actual, expected, message) {
  if (_deepEqual(actual, expected, true)) {
    fail(actual, expected, message, 'notDeepStrictEqual', notDeepStrictEqual);
  }
}


// 9. The strict equality assertion tests strict equality, as determined by ===.
// assert.strictEqual(actual, expected, message_opt);

assert.strictEqual = function strictEqual(actual, expected, message) {
  if (actual !== expected) {
    fail(actual, expected, message, '===', assert.strictEqual);
  }
};

// 10. The strict non-equality assertion tests for strict inequality, as
// determined by !==.  assert.notStrictEqual(actual, expected, message_opt);

assert.notStrictEqual = function notStrictEqual(actual, expected, message) {
  if (actual === expected) {
    fail(actual, expected, message, '!==', assert.notStrictEqual);
  }
};

function expectedException(actual, expected) {
  if (!actual || !expected) {
    return false;
  }

  if (Object.prototype.toString.call(expected) == '[object RegExp]') {
    return expected.test(actual);
  }

  try {
    if (actual instanceof expected) {
      return true;
    }
  } catch (e) {
    // Ignore.  The instanceof check doesn't work for arrow functions.
  }

  if (Error.isPrototypeOf(expected)) {
    return false;
  }

  return expected.call({}, actual) === true;
}

function _tryBlock(block) {
  var error;
  try {
    block();
  } catch (e) {
    error = e;
  }
  return error;
}

function _throws(shouldThrow, block, expected, message) {
  var actual;

  if (typeof block !== 'function') {
    throw new TypeError('"block" argument must be a function');
  }

  if (typeof expected === 'string') {
    message = expected;
    expected = null;
  }

  actual = _tryBlock(block);

  message = (expected && expected.name ? ' (' + expected.name + ').' : '.') +
            (message ? ' ' + message : '.');

  if (shouldThrow && !actual) {
    fail(actual, expected, 'Missing expected exception' + message);
  }

  var userProvidedMessage = typeof message === 'string';
  var isUnwantedException = !shouldThrow && util.isError(actual);
  var isUnexpectedException = !shouldThrow && actual && !expected;

  if ((isUnwantedException &&
      userProvidedMessage &&
      expectedException(actual, expected)) ||
      isUnexpectedException) {
    fail(actual, expected, 'Got unwanted exception' + message);
  }

  if ((shouldThrow && actual && expected &&
      !expectedException(actual, expected)) || (!shouldThrow && actual)) {
    throw actual;
  }
}

// 11. Expected to throw an error:
// assert.throws(block, Error_opt, message_opt);

assert.throws = function(block, /*optional*/error, /*optional*/message) {
  _throws(true, block, error, message);
};

// EXTENSION! This is annoying to write outside this module.
assert.doesNotThrow = function(block, /*optional*/error, /*optional*/message) {
  _throws(false, block, error, message);
};

assert.ifError = function(err) { if (err) throw err; };

// Expose a strict only variant of assert
function strict(value, message) {
  if (!value) fail(value, true, message, '==', strict);
}
assert.strict = objectAssign(strict, assert, {
  equal: assert.strictEqual,
  deepEqual: assert.deepStrictEqual,
  notEqual: assert.notStrictEqual,
  notDeepEqual: assert.notDeepStrictEqual
});
assert.strict.strict = assert.strict;

var objectKeys = Object.keys || function (obj) {
  var keys = [];
  for (var key in obj) {
    if (hasOwn.call(obj, key)) keys.push(key);
  }
  return keys;
};

}).call(this)}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"object.assign/polyfill":134,"util/":7}],5:[function(require,module,exports){
if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor
    var TempCtor = function () {}
    TempCtor.prototype = superCtor.prototype
    ctor.prototype = new TempCtor()
    ctor.prototype.constructor = ctor
  }
}

},{}],6:[function(require,module,exports){
module.exports = function isBuffer(arg) {
  return arg && typeof arg === 'object'
    && typeof arg.copy === 'function'
    && typeof arg.fill === 'function'
    && typeof arg.readUInt8 === 'function';
}
},{}],7:[function(require,module,exports){
(function (process,global){(function (){
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

var formatRegExp = /%[sdj%]/g;
exports.format = function(f) {
  if (!isString(f)) {
    var objects = [];
    for (var i = 0; i < arguments.length; i++) {
      objects.push(inspect(arguments[i]));
    }
    return objects.join(' ');
  }

  var i = 1;
  var args = arguments;
  var len = args.length;
  var str = String(f).replace(formatRegExp, function(x) {
    if (x === '%%') return '%';
    if (i >= len) return x;
    switch (x) {
      case '%s': return String(args[i++]);
      case '%d': return Number(args[i++]);
      case '%j':
        try {
          return JSON.stringify(args[i++]);
        } catch (_) {
          return '[Circular]';
        }
      default:
        return x;
    }
  });
  for (var x = args[i]; i < len; x = args[++i]) {
    if (isNull(x) || !isObject(x)) {
      str += ' ' + x;
    } else {
      str += ' ' + inspect(x);
    }
  }
  return str;
};


// Mark that a method should not be used.
// Returns a modified function which warns once by default.
// If --no-deprecation is set, then it is a no-op.
exports.deprecate = function(fn, msg) {
  // Allow for deprecating things in the process of starting up.
  if (isUndefined(global.process)) {
    return function() {
      return exports.deprecate(fn, msg).apply(this, arguments);
    };
  }

  if (process.noDeprecation === true) {
    return fn;
  }

  var warned = false;
  function deprecated() {
    if (!warned) {
      if (process.throwDeprecation) {
        throw new Error(msg);
      } else if (process.traceDeprecation) {
        console.trace(msg);
      } else {
        console.error(msg);
      }
      warned = true;
    }
    return fn.apply(this, arguments);
  }

  return deprecated;
};


var debugs = {};
var debugEnviron;
exports.debuglog = function(set) {
  if (isUndefined(debugEnviron))
    debugEnviron = process.env.NODE_DEBUG || '';
  set = set.toUpperCase();
  if (!debugs[set]) {
    if (new RegExp('\\b' + set + '\\b', 'i').test(debugEnviron)) {
      var pid = process.pid;
      debugs[set] = function() {
        var msg = exports.format.apply(exports, arguments);
        console.error('%s %d: %s', set, pid, msg);
      };
    } else {
      debugs[set] = function() {};
    }
  }
  return debugs[set];
};


/**
 * Echos the value of a value. Trys to print the value out
 * in the best way possible given the different types.
 *
 * @param {Object} obj The object to print out.
 * @param {Object} opts Optional options object that alters the output.
 */
/* legacy: obj, showHidden, depth, colors*/
function inspect(obj, opts) {
  // default options
  var ctx = {
    seen: [],
    stylize: stylizeNoColor
  };
  // legacy...
  if (arguments.length >= 3) ctx.depth = arguments[2];
  if (arguments.length >= 4) ctx.colors = arguments[3];
  if (isBoolean(opts)) {
    // legacy...
    ctx.showHidden = opts;
  } else if (opts) {
    // got an "options" object
    exports._extend(ctx, opts);
  }
  // set default options
  if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
  if (isUndefined(ctx.depth)) ctx.depth = 2;
  if (isUndefined(ctx.colors)) ctx.colors = false;
  if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
  if (ctx.colors) ctx.stylize = stylizeWithColor;
  return formatValue(ctx, obj, ctx.depth);
}
exports.inspect = inspect;


// http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
inspect.colors = {
  'bold' : [1, 22],
  'italic' : [3, 23],
  'underline' : [4, 24],
  'inverse' : [7, 27],
  'white' : [37, 39],
  'grey' : [90, 39],
  'black' : [30, 39],
  'blue' : [34, 39],
  'cyan' : [36, 39],
  'green' : [32, 39],
  'magenta' : [35, 39],
  'red' : [31, 39],
  'yellow' : [33, 39]
};

// Don't use 'blue' not visible on cmd.exe
inspect.styles = {
  'special': 'cyan',
  'number': 'yellow',
  'boolean': 'yellow',
  'undefined': 'grey',
  'null': 'bold',
  'string': 'green',
  'date': 'magenta',
  // "name": intentionally not styling
  'regexp': 'red'
};


function stylizeWithColor(str, styleType) {
  var style = inspect.styles[styleType];

  if (style) {
    return '\u001b[' + inspect.colors[style][0] + 'm' + str +
           '\u001b[' + inspect.colors[style][1] + 'm';
  } else {
    return str;
  }
}


function stylizeNoColor(str, styleType) {
  return str;
}


function arrayToHash(array) {
  var hash = {};

  array.forEach(function(val, idx) {
    hash[val] = true;
  });

  return hash;
}


function formatValue(ctx, value, recurseTimes) {
  // Provide a hook for user-specified inspect functions.
  // Check that value is an object with an inspect function on it
  if (ctx.customInspect &&
      value &&
      isFunction(value.inspect) &&
      // Filter out the util module, it's inspect function is special
      value.inspect !== exports.inspect &&
      // Also filter out any prototype objects using the circular check.
      !(value.constructor && value.constructor.prototype === value)) {
    var ret = value.inspect(recurseTimes, ctx);
    if (!isString(ret)) {
      ret = formatValue(ctx, ret, recurseTimes);
    }
    return ret;
  }

  // Primitive types cannot have properties
  var primitive = formatPrimitive(ctx, value);
  if (primitive) {
    return primitive;
  }

  // Look up the keys of the object.
  var keys = Object.keys(value);
  var visibleKeys = arrayToHash(keys);

  if (ctx.showHidden) {
    keys = Object.getOwnPropertyNames(value);
  }

  // IE doesn't make error fields non-enumerable
  // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
  if (isError(value)
      && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
    return formatError(value);
  }

  // Some type of object without properties can be shortcutted.
  if (keys.length === 0) {
    if (isFunction(value)) {
      var name = value.name ? ': ' + value.name : '';
      return ctx.stylize('[Function' + name + ']', 'special');
    }
    if (isRegExp(value)) {
      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
    }
    if (isDate(value)) {
      return ctx.stylize(Date.prototype.toString.call(value), 'date');
    }
    if (isError(value)) {
      return formatError(value);
    }
  }

  var base = '', array = false, braces = ['{', '}'];

  // Make Array say that they are Array
  if (isArray(value)) {
    array = true;
    braces = ['[', ']'];
  }

  // Make functions say that they are functions
  if (isFunction(value)) {
    var n = value.name ? ': ' + value.name : '';
    base = ' [Function' + n + ']';
  }

  // Make RegExps say that they are RegExps
  if (isRegExp(value)) {
    base = ' ' + RegExp.prototype.toString.call(value);
  }

  // Make dates with properties first say the date
  if (isDate(value)) {
    base = ' ' + Date.prototype.toUTCString.call(value);
  }

  // Make error with message first say the error
  if (isError(value)) {
    base = ' ' + formatError(value);
  }

  if (keys.length === 0 && (!array || value.length == 0)) {
    return braces[0] + base + braces[1];
  }

  if (recurseTimes < 0) {
    if (isRegExp(value)) {
      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
    } else {
      return ctx.stylize('[Object]', 'special');
    }
  }

  ctx.seen.push(value);

  var output;
  if (array) {
    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
  } else {
    output = keys.map(function(key) {
      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
    });
  }

  ctx.seen.pop();

  return reduceToSingleString(output, base, braces);
}


function formatPrimitive(ctx, value) {
  if (isUndefined(value))
    return ctx.stylize('undefined', 'undefined');
  if (isString(value)) {
    var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
                                             .replace(/'/g, "\\'")
                                             .replace(/\\"/g, '"') + '\'';
    return ctx.stylize(simple, 'string');
  }
  if (isNumber(value))
    return ctx.stylize('' + value, 'number');
  if (isBoolean(value))
    return ctx.stylize('' + value, 'boolean');
  // For some reason typeof null is "object", so special case here.
  if (isNull(value))
    return ctx.stylize('null', 'null');
}


function formatError(value) {
  return '[' + Error.prototype.toString.call(value) + ']';
}


function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
  var output = [];
  for (var i = 0, l = value.length; i < l; ++i) {
    if (hasOwnProperty(value, String(i))) {
      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
          String(i), true));
    } else {
      output.push('');
    }
  }
  keys.forEach(function(key) {
    if (!key.match(/^\d+$/)) {
      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
          key, true));
    }
  });
  return output;
}


function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
  var name, str, desc;
  desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
  if (desc.get) {
    if (desc.set) {
      str = ctx.stylize('[Getter/Setter]', 'special');
    } else {
      str = ctx.stylize('[Getter]', 'special');
    }
  } else {
    if (desc.set) {
      str = ctx.stylize('[Setter]', 'special');
    }
  }
  if (!hasOwnProperty(visibleKeys, key)) {
    name = '[' + key + ']';
  }
  if (!str) {
    if (ctx.seen.indexOf(desc.value) < 0) {
      if (isNull(recurseTimes)) {
        str = formatValue(ctx, desc.value, null);
      } else {
        str = formatValue(ctx, desc.value, recurseTimes - 1);
      }
      if (str.indexOf('\n') > -1) {
        if (array) {
          str = str.split('\n').map(function(line) {
            return '  ' + line;
          }).join('\n').substr(2);
        } else {
          str = '\n' + str.split('\n').map(function(line) {
            return '   ' + line;
          }).join('\n');
        }
      }
    } else {
      str = ctx.stylize('[Circular]', 'special');
    }
  }
  if (isUndefined(name)) {
    if (array && key.match(/^\d+$/)) {
      return str;
    }
    name = JSON.stringify('' + key);
    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
      name = name.substr(1, name.length - 2);
      name = ctx.stylize(name, 'name');
    } else {
      name = name.replace(/'/g, "\\'")
                 .replace(/\\"/g, '"')
                 .replace(/(^"|"$)/g, "'");
      name = ctx.stylize(name, 'string');
    }
  }

  return name + ': ' + str;
}


function reduceToSingleString(output, base, braces) {
  var numLinesEst = 0;
  var length = output.reduce(function(prev, cur) {
    numLinesEst++;
    if (cur.indexOf('\n') >= 0) numLinesEst++;
    return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
  }, 0);

  if (length > 60) {
    return braces[0] +
           (base === '' ? '' : base + '\n ') +
           ' ' +
           output.join(',\n  ') +
           ' ' +
           braces[1];
  }

  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
}


// NOTE: These type checking functions intentionally don't use `instanceof`
// because it is fragile and can be easily faked with `Object.create()`.
function isArray(ar) {
  return Array.isArray(ar);
}
exports.isArray = isArray;

function isBoolean(arg) {
  return typeof arg === 'boolean';
}
exports.isBoolean = isBoolean;

function isNull(arg) {
  return arg === null;
}
exports.isNull = isNull;

function isNullOrUndefined(arg) {
  return arg == null;
}
exports.isNullOrUndefined = isNullOrUndefined;

function isNumber(arg) {
  return typeof arg === 'number';
}
exports.isNumber = isNumber;

function isString(arg) {
  return typeof arg === 'string';
}
exports.isString = isString;

function isSymbol(arg) {
  return typeof arg === 'symbol';
}
exports.isSymbol = isSymbol;

function isUndefined(arg) {
  return arg === void 0;
}
exports.isUndefined = isUndefined;

function isRegExp(re) {
  return isObject(re) && objectToString(re) === '[object RegExp]';
}
exports.isRegExp = isRegExp;

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}
exports.isObject = isObject;

function isDate(d) {
  return isObject(d) && objectToString(d) === '[object Date]';
}
exports.isDate = isDate;

function isError(e) {
  return isObject(e) &&
      (objectToString(e) === '[object Error]' || e instanceof Error);
}
exports.isError = isError;

function isFunction(arg) {
  return typeof arg === 'function';
}
exports.isFunction = isFunction;

function isPrimitive(arg) {
  return arg === null ||
         typeof arg === 'boolean' ||
         typeof arg === 'number' ||
         typeof arg === 'string' ||
         typeof arg === 'symbol' ||  // ES6 symbol
         typeof arg === 'undefined';
}
exports.isPrimitive = isPrimitive;

exports.isBuffer = require('./support/isBuffer');

function objectToString(o) {
  return Object.prototype.toString.call(o);
}


function pad(n) {
  return n < 10 ? '0' + n.toString(10) : n.toString(10);
}


var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
              'Oct', 'Nov', 'Dec'];

// 26 Feb 16:19:34
function timestamp() {
  var d = new Date();
  var time = [pad(d.getHours()),
              pad(d.getMinutes()),
              pad(d.getSeconds())].join(':');
  return [d.getDate(), months[d.getMonth()], time].join(' ');
}


// log is just a thin wrapper to console.log that prepends a timestamp
exports.log = function() {
  console.log('%s - %s', timestamp(), exports.format.apply(exports, arguments));
};


/**
 * Inherit the prototype methods from one constructor into another.
 *
 * The Function.prototype.inherits from lang.js rewritten as a standalone
 * function (not on Function.prototype). NOTE: If this file is to be loaded
 * during bootstrapping this function needs to be rewritten using some native
 * functions as prototype setup using normal JavaScript does not work as
 * expected during bootstrapping (see mirror.js in r114903).
 *
 * @param {function} ctor Constructor function which needs to inherit the
 *     prototype.
 * @param {function} superCtor Constructor function to inherit prototype from.
 */
exports.inherits = require('inherits');

exports._extend = function(origin, add) {
  // Don't do anything if add isn't an object
  if (!add || !isObject(add)) return origin;

  var keys = Object.keys(add);
  var i = keys.length;
  while (i--) {
    origin[keys[i]] = add[keys[i]];
  }
  return origin;
};

function hasOwnProperty(obj, prop) {
  return Object.prototype.hasOwnProperty.call(obj, prop);
}

}).call(this)}).call(this,require('_process'),typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./support/isBuffer":6,"_process":137,"inherits":5}],8:[function(require,module,exports){
(function (global){(function (){
'use strict';

var possibleNames = require('possible-typed-array-names');

var g = typeof globalThis === 'undefined' ? global : globalThis;

/** @type {import('.')} */
module.exports = function availableTypedArrays() {
	var /** @type {ReturnType<typeof availableTypedArrays>} */ out = [];
	for (var i = 0; i < possibleNames.length; i++) {
		if (typeof g[possibleNames[i]] === 'function') {
			// @ts-expect-error
			out[out.length] = possibleNames[i];
		}
	}
	return out;
};

}).call(this)}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"possible-typed-array-names":136}],9:[function(require,module,exports){
'use strict'

exports.byteLength = byteLength
exports.toByteArray = toByteArray
exports.fromByteArray = fromByteArray

var lookup = []
var revLookup = []
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array

var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
for (var i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i]
  revLookup[code.charCodeAt(i)] = i
}

// Support decoding URL-safe base64 strings, as Node.js does.
// See: https://en.wikipedia.org/wiki/Base64#URL_applications
revLookup['-'.charCodeAt(0)] = 62
revLookup['_'.charCodeAt(0)] = 63

function getLens (b64) {
  var len = b64.length

  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4')
  }

  // Trim off extra bytes after placeholder bytes are found
  // See: https://github.com/beatgammit/base64-js/issues/42
  var validLen = b64.indexOf('=')
  if (validLen === -1) validLen = len

  var placeHoldersLen = validLen === len
    ? 0
    : 4 - (validLen % 4)

  return [validLen, placeHoldersLen]
}

// base64 is 4/3 + up to two characters of the original data
function byteLength (b64) {
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function _byteLength (b64, validLen, placeHoldersLen) {
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function toByteArray (b64) {
  var tmp
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]

  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen))

  var curByte = 0

  // if there are placeholders, only get up to the last complete 4 chars
  var len = placeHoldersLen > 0
    ? validLen - 4
    : validLen

  var i
  for (i = 0; i < len; i += 4) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 18) |
      (revLookup[b64.charCodeAt(i + 1)] << 12) |
      (revLookup[b64.charCodeAt(i + 2)] << 6) |
      revLookup[b64.charCodeAt(i + 3)]
    arr[curByte++] = (tmp >> 16) & 0xFF
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 2) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 2) |
      (revLookup[b64.charCodeAt(i + 1)] >> 4)
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 1) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 10) |
      (revLookup[b64.charCodeAt(i + 1)] << 4) |
      (revLookup[b64.charCodeAt(i + 2)] >> 2)
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  return arr
}

function tripletToBase64 (num) {
  return lookup[num >> 18 & 0x3F] +
    lookup[num >> 12 & 0x3F] +
    lookup[num >> 6 & 0x3F] +
    lookup[num & 0x3F]
}

function encodeChunk (uint8, start, end) {
  var tmp
  var output = []
  for (var i = start; i < end; i += 3) {
    tmp =
      ((uint8[i] << 16) & 0xFF0000) +
      ((uint8[i + 1] << 8) & 0xFF00) +
      (uint8[i + 2] & 0xFF)
    output.push(tripletToBase64(tmp))
  }
  return output.join('')
}

function fromByteArray (uint8) {
  var tmp
  var len = uint8.length
  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
  var parts = []
  var maxChunkLength = 16383 // must be multiple of 3

  // go through the array every three bytes, we'll deal with trailing stuff later
  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)))
  }

  // pad the end with zeros, but make sure to not forget the extra bytes
  if (extraBytes === 1) {
    tmp = uint8[len - 1]
    parts.push(
      lookup[tmp >> 2] +
      lookup[(tmp << 4) & 0x3F] +
      '=='
    )
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + uint8[len - 1]
    parts.push(
      lookup[tmp >> 10] +
      lookup[(tmp >> 4) & 0x3F] +
      lookup[(tmp << 2) & 0x3F] +
      '='
    )
  }

  return parts.join('')
}

},{}],10:[function(require,module,exports){
/* Copyright 2013 Google Inc. All Rights Reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

   Bit reading helpers
*/

var BROTLI_READ_SIZE = 4096;
var BROTLI_IBUF_SIZE =  (2 * BROTLI_READ_SIZE + 32);
var BROTLI_IBUF_MASK =  (2 * BROTLI_READ_SIZE - 1);

var kBitMask = new Uint32Array([
  0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, 32767,
  65535, 131071, 262143, 524287, 1048575, 2097151, 4194303, 8388607, 16777215
]);

/* Input byte buffer, consist of a ringbuffer and a "slack" region where */
/* bytes from the start of the ringbuffer are copied. */
function BrotliBitReader(input) {
  this.buf_ = new Uint8Array(BROTLI_IBUF_SIZE);
  this.input_ = input;    /* input callback */
  
  this.reset();
}

BrotliBitReader.READ_SIZE = BROTLI_READ_SIZE;
BrotliBitReader.IBUF_MASK = BROTLI_IBUF_MASK;

BrotliBitReader.prototype.reset = function() {
  this.buf_ptr_ = 0;      /* next input will write here */
  this.val_ = 0;          /* pre-fetched bits */
  this.pos_ = 0;          /* byte position in stream */
  this.bit_pos_ = 0;      /* current bit-reading position in val_ */
  this.bit_end_pos_ = 0;  /* bit-reading end position from LSB of val_ */
  this.eos_ = 0;          /* input stream is finished */
  
  this.readMoreInput();
  for (var i = 0; i < 4; i++) {
    this.val_ |= this.buf_[this.pos_] << (8 * i);
    ++this.pos_;
  }
  
  return this.bit_end_pos_ > 0;
};

/* Fills up the input ringbuffer by calling the input callback.

   Does nothing if there are at least 32 bytes present after current position.

   Returns 0 if either:
    - the input callback returned an error, or
    - there is no more input and the position is past the end of the stream.

   After encountering the end of the input stream, 32 additional zero bytes are
   copied to the ringbuffer, therefore it is safe to call this function after
   every 32 bytes of input is read.
*/
BrotliBitReader.prototype.readMoreInput = function() {
  if (this.bit_end_pos_ > 256) {
    return;
  } else if (this.eos_) {
    if (this.bit_pos_ > this.bit_end_pos_)
      throw new Error('Unexpected end of input ' + this.bit_pos_ + ' ' + this.bit_end_pos_);
  } else {
    var dst = this.buf_ptr_;
    var bytes_read = this.input_.read(this.buf_, dst, BROTLI_READ_SIZE);
    if (bytes_read < 0) {
      throw new Error('Unexpected end of input');
    }
    
    if (bytes_read < BROTLI_READ_SIZE) {
      this.eos_ = 1;
      /* Store 32 bytes of zero after the stream end. */
      for (var p = 0; p < 32; p++)
        this.buf_[dst + bytes_read + p] = 0;
    }
    
    if (dst === 0) {
      /* Copy the head of the ringbuffer to the slack region. */
      for (var p = 0; p < 32; p++)
        this.buf_[(BROTLI_READ_SIZE << 1) + p] = this.buf_[p];

      this.buf_ptr_ = BROTLI_READ_SIZE;
    } else {
      this.buf_ptr_ = 0;
    }
    
    this.bit_end_pos_ += bytes_read << 3;
  }
};

/* Guarantees that there are at least 24 bits in the buffer. */
BrotliBitReader.prototype.fillBitWindow = function() {    
  while (this.bit_pos_ >= 8) {
    this.val_ >>>= 8;
    this.val_ |= this.buf_[this.pos_ & BROTLI_IBUF_MASK] << 24;
    ++this.pos_;
    this.bit_pos_ = this.bit_pos_ - 8 >>> 0;
    this.bit_end_pos_ = this.bit_end_pos_ - 8 >>> 0;
  }
};

/* Reads the specified number of bits from Read Buffer. */
BrotliBitReader.prototype.readBits = function(n_bits) {
  if (32 - this.bit_pos_ < n_bits) {
    this.fillBitWindow();
  }
  
  var val = ((this.val_ >>> this.bit_pos_) & kBitMask[n_bits]);
  this.bit_pos_ += n_bits;
  return val;
};

module.exports = BrotliBitReader;

},{}],11:[function(require,module,exports){
/* Copyright 2013 Google Inc. All Rights Reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

   Lookup table to map the previous two bytes to a context id.

   There are four different context modeling modes defined here:
     CONTEXT_LSB6: context id is the least significant 6 bits of the last byte,
     CONTEXT_MSB6: context id is the most significant 6 bits of the last byte,
     CONTEXT_UTF8: second-order context model tuned for UTF8-encoded text,
     CONTEXT_SIGNED: second-order context model tuned for signed integers.

   The context id for the UTF8 context model is calculated as follows. If p1
   and p2 are the previous two bytes, we calcualte the context as

     context = kContextLookup[p1] | kContextLookup[p2 + 256].

   If the previous two bytes are ASCII characters (i.e. < 128), this will be
   equivalent to

     context = 4 * context1(p1) + context2(p2),

   where context1 is based on the previous byte in the following way:

     0  : non-ASCII control
     1  : \t, \n, \r
     2  : space
     3  : other punctuation
     4  : " '
     5  : %
     6  : ( < [ {
     7  : ) > ] }
     8  : , ; :
     9  : .
     10 : =
     11 : number
     12 : upper-case vowel
     13 : upper-case consonant
     14 : lower-case vowel
     15 : lower-case consonant

   and context2 is based on the second last byte:

     0 : control, space
     1 : punctuation
     2 : upper-case letter, number
     3 : lower-case letter

   If the last byte is ASCII, and the second last byte is not (in a valid UTF8
   stream it will be a continuation byte, value between 128 and 191), the
   context is the same as if the second last byte was an ASCII control or space.

   If the last byte is a UTF8 lead byte (value >= 192), then the next byte will
   be a continuation byte and the context id is 2 or 3 depending on the LSB of
   the last byte and to a lesser extent on the second last byte if it is ASCII.

   If the last byte is a UTF8 continuation byte, the second last byte can be:
     - continuation byte: the next byte is probably ASCII or lead byte (assuming
       4-byte UTF8 characters are rare) and the context id is 0 or 1.
     - lead byte (192 - 207): next byte is ASCII or lead byte, context is 0 or 1
     - lead byte (208 - 255): next byte is continuation byte, context is 2 or 3

   The possible value combinations of the previous two bytes, the range of
   context ids and the type of the next byte is summarized in the table below:

   |--------\-----------------------------------------------------------------|
   |         \                         Last byte                              |
   | Second   \---------------------------------------------------------------|
   | last byte \    ASCII            |   cont. byte        |   lead byte      |
   |            \   (0-127)          |   (128-191)         |   (192-)         |
   |=============|===================|=====================|==================|
   |  ASCII      | next: ASCII/lead  |  not valid          |  next: cont.     |
   |  (0-127)    | context: 4 - 63   |                     |  context: 2 - 3  |
   |-------------|-------------------|---------------------|------------------|
   |  cont. byte | next: ASCII/lead  |  next: ASCII/lead   |  next: cont.     |
   |  (128-191)  | context: 4 - 63   |  context: 0 - 1     |  context: 2 - 3  |
   |-------------|-------------------|---------------------|------------------|
   |  lead byte  | not valid         |  next: ASCII/lead   |  not valid       |
   |  (192-207)  |                   |  context: 0 - 1     |                  |
   |-------------|-------------------|---------------------|------------------|
   |  lead byte  | not valid         |  next: cont.        |  not valid       |
   |  (208-)     |                   |  context: 2 - 3     |                  |
   |-------------|-------------------|---------------------|------------------|

   The context id for the signed context mode is calculated as:

     context = (kContextLookup[512 + p1] << 3) | kContextLookup[512 + p2].

   For any context modeling modes, the context ids can be calculated by |-ing
   together two lookups from one table using context model dependent offsets:

     context = kContextLookup[offset1 + p1] | kContextLookup[offset2 + p2].

   where offset1 and offset2 are dependent on the context mode.
*/

var CONTEXT_LSB6         = 0;
var CONTEXT_MSB6         = 1;
var CONTEXT_UTF8         = 2;
var CONTEXT_SIGNED       = 3;

/* Common context lookup table for all context modes. */
exports.lookup = new Uint8Array([
  /* CONTEXT_UTF8, last byte. */
  /* ASCII range. */
   0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  4,  0,  0,  4,  0,  0,
   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
   8, 12, 16, 12, 12, 20, 12, 16, 24, 28, 12, 12, 32, 12, 36, 12,
  44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 32, 32, 24, 40, 28, 12,
  12, 48, 52, 52, 52, 48, 52, 52, 52, 48, 52, 52, 52, 52, 52, 48,
  52, 52, 52, 52, 52, 48, 52, 52, 52, 52, 52, 24, 12, 28, 12, 12,
  12, 56, 60, 60, 60, 56, 60, 60, 60, 56, 60, 60, 60, 60, 60, 56,
  60, 60, 60, 60, 60, 56, 60, 60, 60, 60, 60, 24, 12, 28, 12,  0,
  /* UTF8 continuation byte range. */
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
  0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
  /* UTF8 lead byte range. */
  2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
  2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
  2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
  2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3, 2, 3,
  /* CONTEXT_UTF8 second last byte. */
  /* ASCII range. */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1,
  1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1,
  1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 0,
  /* UTF8 continuation byte range. */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  /* UTF8 lead byte range. */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  /* CONTEXT_SIGNED, second last byte. */
  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7,
  /* CONTEXT_SIGNED, last byte, same as the above values shifted by 3 bits. */
   0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
  40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
  40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
  40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56,
  /* CONTEXT_LSB6, last byte. */
   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
   0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
  /* CONTEXT_MSB6, last byte. */
   0,  0,  0,  0,  1,  1,  1,  1,  2,  2,  2,  2,  3,  3,  3,  3,
   4,  4,  4,  4,  5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  7,
   8,  8,  8,  8,  9,  9,  9,  9, 10, 10, 10, 10, 11, 11, 11, 11,
  12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15,
  16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19,
  20, 20, 20, 20, 21, 21, 21, 21, 22, 22, 22, 22, 23, 23, 23, 23,
  24, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 27,
  28, 28, 28, 28, 29, 29, 29, 29, 30, 30, 30, 30, 31, 31, 31, 31,
  32, 32, 32, 32, 33, 33, 33, 33, 34, 34, 34, 34, 35, 35, 35, 35,
  36, 36, 36, 36, 37, 37, 37, 37, 38, 38, 38, 38, 39, 39, 39, 39,
  40, 40, 40, 40, 41, 41, 41, 41, 42, 42, 42, 42, 43, 43, 43, 43,
  44, 44, 44, 44, 45, 45, 45, 45, 46, 46, 46, 46, 47, 47, 47, 47,
  48, 48, 48, 48, 49, 49, 49, 49, 50, 50, 50, 50, 51, 51, 51, 51,
  52, 52, 52, 52, 53, 53, 53, 53, 54, 54, 54, 54, 55, 55, 55, 55,
  56, 56, 56, 56, 57, 57, 57, 57, 58, 58, 58, 58, 59, 59, 59, 59,
  60, 60, 60, 60, 61, 61, 61, 61, 62, 62, 62, 62, 63, 63, 63, 63,
  /* CONTEXT_{M,L}SB6, second last byte, */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
]);

exports.lookupOffsets = new Uint16Array([
  /* CONTEXT_LSB6 */
  1024, 1536,
  /* CONTEXT_MSB6 */
  1280, 1536,
  /* CONTEXT_UTF8 */
  0, 256,
  /* CONTEXT_SIGNED */
  768, 512,
]);

},{}],12:[function(require,module,exports){
/* Copyright 2013 Google Inc. All Rights Reserved.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

var BrotliInput = require('./streams').BrotliInput;
var BrotliOutput = require('./streams').BrotliOutput;
var BrotliBitReader = require('./bit_reader');
var BrotliDictionary = require('./dictionary');
var HuffmanCode = require('./huffman').HuffmanCode;
var BrotliBuildHuffmanTable = require('./huffman').BrotliBuildHuffmanTable;
var Context = require('./context');
var Prefix = require('./prefix');
var Transform = require('./transform');

var kDefaultCodeLength = 8;
var kCodeLengthRepeatCode = 16;
var kNumLiteralCodes = 256;
var kNumInsertAndCopyCodes = 704;
var kNumBlockLengthCodes = 26;
var kLiteralContextBits = 6;
var kDistanceContextBits = 2;

var HUFFMAN_TABLE_BITS = 8;
var HUFFMAN_TABLE_MASK = 0xff;
/* Maximum possible Huffman table size for an alphabet size of 704, max code
 * length 15 and root table bits 8. */
var HUFFMAN_MAX_TABLE_SIZE = 1080;

var CODE_LENGTH_CODES = 18;
var kCodeLengthCodeOrder = new Uint8Array([
  1, 2, 3, 4, 0, 5, 17, 6, 16, 7, 8, 9, 10, 11, 12, 13, 14, 15,
]);

var NUM_DISTANCE_SHORT_CODES = 16;
var kDistanceShortCodeIndexOffset = new Uint8Array([
  3, 2, 1, 0, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2
]);

var kDistanceShortCodeValueOffset = new Int8Array([
  0, 0, 0, 0, -1, 1, -2, 2, -3, 3, -1, 1, -2, 2, -3, 3
]);

var kMaxHuffmanTableSize = new Uint16Array([
  256, 402, 436, 468, 500, 534, 566, 598, 630, 662, 694, 726, 758, 790, 822,
  854, 886, 920, 952, 984, 1016, 1048, 1080
]);

function DecodeWindowBits(br) {
  var n;
  if (br.readBits(1) === 0) {
    return 16;
  }
  
  n = br.readBits(3);
  if (n > 0) {
    return 17 + n;
  }
  
  n = br.readBits(3);
  if (n > 0) {
    return 8 + n;
  }
  
  return 17;
}

/* Decodes a number in the range [0..255], by reading 1 - 11 bits. */
function DecodeVarLenUint8(br) {
  if (br.readBits(1)) {
    var nbits = br.readBits(3);
    if (nbits === 0) {
      return 1;
    } else {
      return br.readBits(nbits) + (1 << nbits);
    }
  }
  return 0;
}

function MetaBlockLength() {
  this.meta_block_length = 0;
  this.input_end = 0;
  this.is_uncompressed = 0;
  this.is_metadata = false;
}

function DecodeMetaBlockLength(br) {
  var out = new MetaBlockLength;  
  var size_nibbles;
  var size_bytes;
  var i;
  
  out.input_end = br.readBits(1);
  if (out.input_end && br.readBits(1)) {
    return out;
  }
  
  size_nibbles = br.readBits(2) + 4;
  if (size_nibbles === 7) {
    out.is_metadata = true;
    
    if (br.readBits(1) !== 0)
      throw new Error('Invalid reserved bit');
    
    size_bytes = br.readBits(2);
    if (size_bytes === 0)
      return out;
    
    for (i = 0; i < size_bytes; i++) {
      var next_byte = br.readBits(8);
      if (i + 1 === size_bytes && size_bytes > 1 && next_byte === 0)
        throw new Error('Invalid size byte');
      
      out.meta_block_length |= next_byte << (i * 8);
    }
  } else {
    for (i = 0; i < size_nibbles; ++i) {
      var next_nibble = br.readBits(4);
      if (i + 1 === size_nibbles && size_nibbles > 4 && next_nibble === 0)
        throw new Error('Invalid size nibble');
      
      out.meta_block_length |= next_nibble << (i * 4);
    }
  }
  
  ++out.meta_block_length;
  
  if (!out.input_end && !out.is_metadata) {
    out.is_uncompressed = br.readBits(1);
  }
  
  return out;
}

/* Decodes the next Huffman code from bit-stream. */
function ReadSymbol(table, index, br) {
  var start_index = index;
  
  var nbits;
  br.fillBitWindow();
  index += (br.val_ >>> br.bit_pos_) & HUFFMAN_TABLE_MASK;
  nbits = table[index].bits - HUFFMAN_TABLE_BITS;
  if (nbits > 0) {
    br.bit_pos_ += HUFFMAN_TABLE_BITS;
    index += table[index].value;
    index += (br.val_ >>> br.bit_pos_) & ((1 << nbits) - 1);
  }
  br.bit_pos_ += table[index].bits;
  return table[index].value;
}

function ReadHuffmanCodeLengths(code_length_code_lengths, num_symbols, code_lengths, br) {
  var symbol = 0;
  var prev_code_len = kDefaultCodeLength;
  var repeat = 0;
  var repeat_code_len = 0;
  var space = 32768;
  
  var table = [];
  for (var i = 0; i < 32; i++)
    table.push(new HuffmanCode(0, 0));
  
  BrotliBuildHuffmanTable(table, 0, 5, code_length_code_lengths, CODE_LENGTH_CODES);

  while (symbol < num_symbols && space > 0) {
    var p = 0;
    var code_len;
    
    br.readMoreInput();
    br.fillBitWindow();
    p += (br.val_ >>> br.bit_pos_) & 31;
    br.bit_pos_ += table[p].bits;
    code_len = table[p].value & 0xff;
    if (code_len < kCodeLengthRepeatCode) {
      repeat = 0;
      code_lengths[symbol++] = code_len;
      if (code_len !== 0) {
        prev_code_len = code_len;
        space -= 32768 >> code_len;
      }
    } else {
      var extra_bits = code_len - 14;
      var old_repeat;
      var repeat_delta;
      var new_len = 0;
      if (code_len === kCodeLengthRepeatCode) {
        new_len = prev_code_len;
      }
      if (repeat_code_len !== new_len) {
        repeat = 0;
        repeat_code_len = new_len;
      }
      old_repeat = repeat;
      if (repeat > 0) {
        repeat -= 2;
        repeat <<= extra_bits;
      }
      repeat += br.readBits(extra_bits) + 3;
      repeat_delta = repeat - old_repeat;
      if (symbol + repeat_delta > num_symbols) {
        throw new Error('[ReadHuffmanCodeLengths] symbol + repeat_delta > num_symbols');
      }
      
      for (var x = 0; x < repeat_delta; x++)
        code_lengths[symbol + x] = repeat_code_len;
      
      symbol += repeat_delta;
      
      if (repeat_code_len !== 0) {
        space -= repeat_delta << (15 - repeat_code_len);
      }
    }
  }
  if (space !== 0) {
    throw new Error("[ReadHuffmanCodeLengths] space = " + space);
  }
  
  for (; symbol < num_symbols; symbol++)
    code_lengths[symbol] = 0;
}

function ReadHuffmanCode(alphabet_size, tables, table, br) {
  var table_size = 0;
  var simple_code_or_skip;
  var code_lengths = new Uint8Array(alphabet_size);
  
  br.readMoreInput();
  
  /* simple_code_or_skip is used as follows:
     1 for simple code;
     0 for no skipping, 2 skips 2 code lengths, 3 skips 3 code lengths */
  simple_code_or_skip = br.readBits(2);
  if (simple_code_or_skip === 1) {
    /* Read symbols, codes & code lengths directly. */
    var i;
    var max_bits_counter = alphabet_size - 1;
    var max_bits = 0;
    var symbols = new Int32Array(4);
    var num_symbols = br.readBits(2) + 1;
    while (max_bits_counter) {
      max_bits_counter >>= 1;
      ++max_bits;
    }

    for (i = 0; i < num_symbols; ++i) {
      symbols[i] = br.readBits(max_bits) % alphabet_size;
      code_lengths[symbols[i]] = 2;
    }
    code_lengths[symbols[0]] = 1;
    switch (num_symbols) {
      case 1:
        break;
      case 3:
        if ((symbols[0] === symbols[1]) ||
            (symbols[0] === symbols[2]) ||
            (symbols[1] === symbols[2])) {
          throw new Error('[ReadHuffmanCode] invalid symbols');
        }
        break;
      case 2:
        if (symbols[0] === symbols[1]) {
          throw new Error('[ReadHuffmanCode] invalid symbols');
        }
        
        code_lengths[symbols[1]] = 1;
        break;
      case 4:
        if ((symbols[0] === symbols[1]) ||
            (symbols[0] === symbols[2]) ||
            (symbols[0] === symbols[3]) ||
            (symbols[1] === symbols[2]) ||
            (symbols[1] === symbols[3]) ||
            (symbols[2] === symbols[3])) {
          throw new Error('[ReadHuffmanCode] invalid symbols');
        }
        
        if (br.readBits(1)) {
          code_lengths[symbols[2]] = 3;
          code_lengths[symbols[3]] = 3;
        } else {
          code_lengths[symbols[0]] = 2;
        }
        break;
    }
  } else {  /* Decode Huffman-coded code lengths. */
    var i;
    var code_length_code_lengths = new Uint8Array(CODE_LENGTH_CODES);
    var space = 32;
    var num_codes = 0;
    /* Static Huffman code for the code length code lengths */
    var huff = [
      new HuffmanCode(2, 0), new HuffmanCode(2, 4), new HuffmanCode(2, 3), new HuffmanCode(3, 2), 
      new HuffmanCode(2, 0), new HuffmanCode(2, 4), new HuffmanCode(2, 3), new HuffmanCode(4, 1),
      new HuffmanCode(2, 0), new HuffmanCode(2, 4), new HuffmanCode(2, 3), new HuffmanCode(3, 2), 
      new HuffmanCode(2, 0), new HuffmanCode(2, 4), new HuffmanCode(2, 3), new HuffmanCode(4, 5)
    ];
    for (i = simple_code_or_skip; i < CODE_LENGTH_CODES && space > 0; ++i) {
      var code_len_idx = kCodeLengthCodeOrder[i];
      var p = 0;
      var v;
      br.fillBitWindow();
      p += (br.val_ >>> br.bit_pos_) & 15;
      br.bit_pos_ += huff[p].bits;
      v = huff[p].value;
      code_length_code_lengths[code_len_idx] = v;
      if (v !== 0) {
        space -= (32 >> v);
        ++num_codes;
      }
    }
    
    if (!(num_codes === 1 || space === 0))
      throw new Error('[ReadHuffmanCode] invalid num_codes or space');
    
    ReadHuffmanCodeLengths(code_length_code_lengths, alphabet_size, code_lengths, br);
  }
  
  table_size = BrotliBuildHuffmanTable(tables, table, HUFFMAN_TABLE_BITS, code_lengths, alphabet_size);
  
  if (table_size === 0) {
    throw new Error("[ReadHuffmanCode] BuildHuffmanTable failed: ");
  }
  
  return table_size;
}

function ReadBlockLength(table, index, br) {
  var code;
  var nbits;
  code = ReadSymbol(table, index, br);
  nbits = Prefix.kBlockLengthPrefixCode[code].nbits;
  return Prefix.kBlockLengthPrefixCode[code].offset + br.readBits(nbits);
}

function TranslateShortCodes(code, ringbuffer, index) {
  var val;
  if (code < NUM_DISTANCE_SHORT_CODES) {
    index += kDistanceShortCodeIndexOffset[code];
    index &= 3;
    val = ringbuffer[index] + kDistanceShortCodeValueOffset[code];
  } else {
    val = code - NUM_DISTANCE_SHORT_CODES + 1;
  }
  return val;
}

function MoveToFront(v, index) {
  var value = v[index];
  var i = index;
  for (; i; --i) v[i] = v[i - 1];
  v[0] = value;
}

function InverseMoveToFrontTransform(v, v_len) {
  var mtf = new Uint8Array(256);
  var i;
  for (i = 0; i < 256; ++i) {
    mtf[i] = i;
  }
  for (i = 0; i < v_len; ++i) {
    var index = v[i];
    v[i] = mtf[index];
    if (index) MoveToFront(mtf, index);
  }
}

/* Contains a collection of huffman trees with the same alphabet size. */
function HuffmanTreeGroup(alphabet_size, num_htrees) {
  this.alphabet_size = alphabet_size;
  this.num_htrees = num_htrees;
  this.codes = new Array(num_htrees + num_htrees * kMaxHuffmanTableSize[(alphabet_size + 31) >>> 5]);  
  this.htrees = new Uint32Array(num_htrees);
}

HuffmanTreeGroup.prototype.decode = function(br) {
  var i;
  var table_size;
  var next = 0;
  for (i = 0; i < this.num_htrees; ++i) {
    this.htrees[i] = next;
    table_size = ReadHuffmanCode(this.alphabet_size, this.codes, next, br);
    next += table_size;
  }
};

function DecodeContextMap(context_map_size, br) {
  var out = { num_htrees: null, context_map: null };
  var use_rle_for_zeros;
  var max_run_length_prefix = 0;
  var table;
  var i;
  
  br.readMoreInput();
  var num_htrees = out.num_htrees = DecodeVarLenUint8(br) + 1;

  var context_map = out.context_map = new Uint8Array(context_map_size);
  if (num_htrees <= 1) {
    return out;
  }

  use_rle_for_zeros = br.readBits(1);
  if (use_rle_for_zeros) {
    max_run_length_prefix = br.readBits(4) + 1;
  }
  
  table = [];
  for (i = 0; i < HUFFMAN_MAX_TABLE_SIZE; i++) {
    table[i] = new HuffmanCode(0, 0);
  }
  
  ReadHuffmanCode(num_htrees + max_run_length_prefix, table, 0, br);
  
  for (i = 0; i < context_map_size;) {
    var code;

    br.readMoreInput();
    code = ReadSymbol(table, 0, br);
    if (code === 0) {
      context_map[i] = 0;
      ++i;
    } else if (code <= max_run_length_prefix) {
      var reps = 1 + (1 << code) + br.readBits(code);
      while (--reps) {
        if (i >= context_map_size) {
          throw new Error("[DecodeContextMap] i >= context_map_size");
        }
        context_map[i] = 0;
        ++i;
      }
    } else {
      context_map[i] = code - max_run_length_prefix;
      ++i;
    }
  }
  if (br.readBits(1)) {
    InverseMoveToFrontTransform(context_map, context_map_size);
  }
  
  return out;
}

function DecodeBlockType(max_block_type, trees, tree_type, block_types, ringbuffers, indexes, br) {
  var ringbuffer = tree_type * 2;
  var index = tree_type;
  var type_code = ReadSymbol(trees, tree_type * HUFFMAN_MAX_TABLE_SIZE, br);
  var block_type;
  if (type_code === 0) {
    block_type = ringbuffers[ringbuffer + (indexes[index] & 1)];
  } else if (type_code === 1) {
    block_type = ringbuffers[ringbuffer + ((indexes[index] - 1) & 1)] + 1;
  } else {
    block_type = type_code - 2;
  }
  if (block_type >= max_block_type) {
    block_type -= max_block_type;
  }
  block_types[tree_type] = block_type;
  ringbuffers[ringbuffer + (indexes[index] & 1)] = block_type;
  ++indexes[index];
}

function CopyUncompressedBlockToOutput(output, len, pos, ringbuffer, ringbuffer_mask, br) {
  var rb_size = ringbuffer_mask + 1;
  var rb_pos = pos & ringbuffer_mask;
  var br_pos = br.pos_ & BrotliBitReader.IBUF_MASK;
  var nbytes;

  /* For short lengths copy byte-by-byte */
  if (len < 8 || br.bit_pos_ + (len << 3) < br.bit_end_pos_) {
    while (len-- > 0) {
      br.readMoreInput();
      ringbuffer[rb_pos++] = br.readBits(8);
      if (rb_pos === rb_size) {
        output.write(ringbuffer, rb_size);
        rb_pos = 0;
      }
    }
    return;
  }

  if (br.bit_end_pos_ < 32) {
    throw new Error('[CopyUncompressedBlockToOutput] br.bit_end_pos_ < 32');
  }

  /* Copy remaining 0-4 bytes from br.val_ to ringbuffer. */
  while (br.bit_pos_ < 32) {
    ringbuffer[rb_pos] = (br.val_ >>> br.bit_pos_);
    br.bit_pos_ += 8;
    ++rb_pos;
    --len;
  }

  /* Copy remaining bytes from br.buf_ to ringbuffer. */
  nbytes = (br.bit_end_pos_ - br.bit_pos_) >> 3;
  if (br_pos + nbytes > BrotliBitReader.IBUF_MASK) {
    var tail = BrotliBitReader.IBUF_MASK + 1 - br_pos;
    for (var x = 0; x < tail; x++)
      ringbuffer[rb_pos + x] = br.buf_[br_pos + x];
    
    nbytes -= tail;
    rb_pos += tail;
    len -= tail;
    br_pos = 0;
  }

  for (var x = 0; x < nbytes; x++)
    ringbuffer[rb_pos + x] = br.buf_[br_pos + x];
  
  rb_pos += nbytes;
  len -= nbytes;

  /* If we wrote past the logical end of the ringbuffer, copy the tail of the
     ringbuffer to its beginning and flush the ringbuffer to the output. */
  if (rb_pos >= rb_size) {
    output.write(ringbuffer, rb_size);
    rb_pos -= rb_size;    
    for (var x = 0; x < rb_pos; x++)
      ringbuffer[x] = ringbuffer[rb_size + x];
  }

  /* If we have more to copy than the remaining size of the ringbuffer, then we
     first fill the ringbuffer from the input and then flush the ringbuffer to
     the output */
  while (rb_pos + len >= rb_size) {
    nbytes = rb_size - rb_pos;
    if (br.input_.read(ringbuffer, rb_pos, nbytes) < nbytes) {
      throw new Error('[CopyUncompressedBlockToOutput] not enough bytes');
    }
    output.write(ringbuffer, rb_size);
    len -= nbytes;
    rb_pos = 0;
  }

  /* Copy straight from the input onto the ringbuffer. The ringbuffer will be
     flushed to the output at a later time. */
  if (br.input_.read(ringbuffer, rb_pos, len) < len) {
    throw new Error('[CopyUncompressedBlockToOutput] not enough bytes');
  }

  /* Restore the state of the bit reader. */
  br.reset();
}

/* Advances the bit reader position to the next byte boundary and verifies
   that any skipped bits are set to zero. */
function JumpToByteBoundary(br) {
  var new_bit_pos = (br.bit_pos_ + 7) & ~7;
  var pad_bits = br.readBits(new_bit_pos - br.bit_pos_);
  return pad_bits == 0;
}

function BrotliDecompressedSize(buffer) {
  var input = new BrotliInput(buffer);
  var br = new BrotliBitReader(input);
  DecodeWindowBits(br);
  var out = DecodeMetaBlockLength(br);
  return out.meta_block_length;
}

exports.BrotliDecompressedSize = BrotliDecompressedSize;

function BrotliDecompressBuffer(buffer, output_size) {
  var input = new BrotliInput(buffer);
  
  if (output_size == null) {
    output_size = BrotliDecompressedSize(buffer);
  }
  
  var output_buffer = new Uint8Array(output_size);
  var output = new BrotliOutput(output_buffer);
  
  BrotliDecompress(input, output);
  
  if (output.pos < output.buffer.length) {
    output.buffer = output.buffer.subarray(0, output.pos);
  }
  
  return output.buffer;
}

exports.BrotliDecompressBuffer = BrotliDecompressBuffer;

function BrotliDecompress(input, output) {
  var i;
  var pos = 0;
  var input_end = 0;
  var window_bits = 0;
  var max_backward_distance;
  var max_distance = 0;
  var ringbuffer_size;
  var ringbuffer_mask;
  var ringbuffer;
  var ringbuffer_end;
  /* This ring buffer holds a few past copy distances that will be used by */
  /* some special distance codes. */
  var dist_rb = [ 16, 15, 11, 4 ];
  var dist_rb_idx = 0;
  /* The previous 2 bytes used for context. */
  var prev_byte1 = 0;
  var prev_byte2 = 0;
  var hgroup = [new HuffmanTreeGroup(0, 0), new HuffmanTreeGroup(0, 0), new HuffmanTreeGroup(0, 0)];
  var block_type_trees;
  var block_len_trees;
  var br;

  /* We need the slack region for the following reasons:
       - always doing two 8-byte copies for fast backward copying
       - transforms
       - flushing the input ringbuffer when decoding uncompressed blocks */
  var kRingBufferWriteAheadSlack = 128 + BrotliBitReader.READ_SIZE;

  br = new BrotliBitReader(input);

  /* Decode window size. */
  window_bits = DecodeWindowBits(br);
  max_backward_distance = (1 << window_bits) - 16;

  ringbuffer_size = 1 << window_bits;
  ringbuffer_mask = ringbuffer_size - 1;
  ringbuffer = new Uint8Array(ringbuffer_size + kRingBufferWriteAheadSlack + BrotliDictionary.maxDictionaryWordLength);
  ringbuffer_end = ringbuffer_size;

  block_type_trees = [];
  block_len_trees = [];
  for (var x = 0; x < 3 * HUFFMAN_MAX_TABLE_SIZE; x++) {
    block_type_trees[x] = new HuffmanCode(0, 0);
    block_len_trees[x] = new HuffmanCode(0, 0);
  }

  while (!input_end) {
    var meta_block_remaining_len = 0;
    var is_uncompressed;
    var block_length = [ 1 << 28, 1 << 28, 1 << 28 ];
    var block_type = [ 0 ];
    var num_block_types = [ 1, 1, 1 ];
    var block_type_rb = [ 0, 1, 0, 1, 0, 1 ];
    var block_type_rb_index = [ 0 ];
    var distance_postfix_bits;
    var num_direct_distance_codes;
    var distance_postfix_mask;
    var num_distance_codes;
    var context_map = null;
    var context_modes = null;
    var num_literal_htrees;
    var dist_context_map = null;
    var num_dist_htrees;
    var context_offset = 0;
    var context_map_slice = null;
    var literal_htree_index = 0;
    var dist_context_offset = 0;
    var dist_context_map_slice = null;
    var dist_htree_index = 0;
    var context_lookup_offset1 = 0;
    var context_lookup_offset2 = 0;
    var context_mode;
    var htree_command;

    for (i = 0; i < 3; ++i) {
      hgroup[i].codes = null;
      hgroup[i].htrees = null;
    }

    br.readMoreInput();
    
    var _out = DecodeMetaBlockLength(br);
    meta_block_remaining_len = _out.meta_block_length;
    if (pos + meta_block_remaining_len > output.buffer.length) {
      /* We need to grow the output buffer to fit the additional data. */
      var tmp = new Uint8Array( pos + meta_block_remaining_len );
      tmp.set( output.buffer );
      output.buffer = tmp;
    }    
    input_end = _out.input_end;
    is_uncompressed = _out.is_uncompressed;
    
    if (_out.is_metadata) {
      JumpToByteBoundary(br);
      
      for (; meta_block_remaining_len > 0; --meta_block_remaining_len) {
        br.readMoreInput();
        /* Read one byte and ignore it. */
        br.readBits(8);
      }
      
      continue;
    }
    
    if (meta_block_remaining_len === 0) {
      continue;
    }
    
    if (is_uncompressed) {
      br.bit_pos_ = (br.bit_pos_ + 7) & ~7;
      CopyUncompressedBlockToOutput(output, meta_block_remaining_len, pos,
                                    ringbuffer, ringbuffer_mask, br);
      pos += meta_block_remaining_len;
      continue;
    }
    
    for (i = 0; i < 3; ++i) {
      num_block_types[i] = DecodeVarLenUint8(br) + 1;
      if (num_block_types[i] >= 2) {
        ReadHuffmanCode(num_block_types[i] + 2, block_type_trees, i * HUFFMAN_MAX_TABLE_SIZE, br);
        ReadHuffmanCode(kNumBlockLengthCodes, block_len_trees, i * HUFFMAN_MAX_TABLE_SIZE, br);
        block_length[i] = ReadBlockLength(block_len_trees, i * HUFFMAN_MAX_TABLE_SIZE, br);
        block_type_rb_index[i] = 1;
      }
    }
    
    br.readMoreInput();
    
    distance_postfix_bits = br.readBits(2);
    num_direct_distance_codes = NUM_DISTANCE_SHORT_CODES + (br.readBits(4) << distance_postfix_bits);
    distance_postfix_mask = (1 << distance_postfix_bits) - 1;
    num_distance_codes = (num_direct_distance_codes + (48 << distance_postfix_bits));
    context_modes = new Uint8Array(num_block_types[0]);

    for (i = 0; i < num_block_types[0]; ++i) {
       br.readMoreInput();
       context_modes[i] = (br.readBits(2) << 1);
    }
    
    var _o1 = DecodeContextMap(num_block_types[0] << kLiteralContextBits, br);
    num_literal_htrees = _o1.num_htrees;
    context_map = _o1.context_map;
    
    var _o2 = DecodeContextMap(num_block_types[2] << kDistanceContextBits, br);
    num_dist_htrees = _o2.num_htrees;
    dist_context_map = _o2.context_map;
    
    hgroup[0] = new HuffmanTreeGroup(kNumLiteralCodes, num_literal_htrees);
    hgroup[1] = new HuffmanTreeGroup(kNumInsertAndCopyCodes, num_block_types[1]);
    hgroup[2] = new HuffmanTreeGroup(num_distance_codes, num_dist_htrees);

    for (i = 0; i < 3; ++i) {
      hgroup[i].decode(br);
    }

    context_map_slice = 0;
    dist_context_map_slice = 0;
    context_mode = context_modes[block_type[0]];
    context_lookup_offset1 = Context.lookupOffsets[context_mode];
    context_lookup_offset2 = Context.lookupOffsets[context_mode + 1];
    htree_command = hgroup[1].htrees[0];

    while (meta_block_remaining_len > 0) {
      var cmd_code;
      var range_idx;
      var insert_code;
      var copy_code;
      var insert_length;
      var copy_length;
      var distance_code;
      var distance;
      var context;
      var j;
      var copy_dst;

      br.readMoreInput();
      
      if (block_length[1] === 0) {
        DecodeBlockType(num_block_types[1],
                        block_type_trees, 1, block_type, block_type_rb,
                        block_type_rb_index, br);
        block_length[1] = ReadBlockLength(block_len_trees, HUFFMAN_MAX_TABLE_SIZE, br);
        htree_command = hgroup[1].htrees[block_type[1]];
      }
      --block_length[1];
      cmd_code = ReadSymbol(hgroup[1].codes, htree_command, br);
      range_idx = cmd_code >> 6;
      if (range_idx >= 2) {
        range_idx -= 2;
        distance_code = -1;
      } else {
        distance_code = 0;
      }
      insert_code = Prefix.kInsertRangeLut[range_idx] + ((cmd_code >> 3) & 7);
      copy_code = Prefix.kCopyRangeLut[range_idx] + (cmd_code & 7);
      insert_length = Prefix.kInsertLengthPrefixCode[insert_code].offset +
          br.readBits(Prefix.kInsertLengthPrefixCode[insert_code].nbits);
      copy_length = Prefix.kCopyLengthPrefixCode[copy_code].offset +
          br.readBits(Prefix.kCopyLengthPrefixCode[copy_code].nbits);
      prev_byte1 = ringbuffer[pos-1 & ringbuffer_mask];
      prev_byte2 = ringbuffer[pos-2 & ringbuffer_mask];
      for (j = 0; j < insert_length; ++j) {
        br.readMoreInput();

        if (block_length[0] === 0) {
          DecodeBlockType(num_block_types[0],
                          block_type_trees, 0, block_type, block_type_rb,
                          block_type_rb_index, br);
          block_length[0] = ReadBlockLength(block_len_trees, 0, br);
          context_offset = block_type[0] << kLiteralContextBits;
          context_map_slice = context_offset;
          context_mode = context_modes[block_type[0]];
          context_lookup_offset1 = Context.lookupOffsets[context_mode];
          context_lookup_offset2 = Context.lookupOffsets[context_mode + 1];
        }
        context = (Context.lookup[context_lookup_offset1 + prev_byte1] |
                   Context.lookup[context_lookup_offset2 + prev_byte2]);
        literal_htree_index = context_map[context_map_slice + context];
        --block_length[0];
        prev_byte2 = prev_byte1;
        prev_byte1 = ReadSymbol(hgroup[0].codes, hgroup[0].htrees[literal_htree_index], br);
        ringbuffer[pos & ringbuffer_mask] = prev_byte1;
        if ((pos & ringbuffer_mask) === ringbuffer_mask) {
          output.write(ringbuffer, ringbuffer_size);
        }
        ++pos;
      }
      meta_block_remaining_len -= insert_length;
      if (meta_block_remaining_len <= 0) break;

      if (distance_code < 0) {
        var context;
        
        br.readMoreInput();
        if (block_length[2] === 0) {
          DecodeBlockType(num_block_types[2],
                          block_type_trees, 2, block_type, block_type_rb,
                          block_type_rb_index, br);
          block_length[2] = ReadBlockLength(block_len_trees, 2 * HUFFMAN_MAX_TABLE_SIZE, br);
          dist_context_offset = block_type[2] << kDistanceContextBits;
          dist_context_map_slice = dist_context_offset;
        }
        --block_length[2];
        context = (copy_length > 4 ? 3 : copy_length - 2) & 0xff;
        dist_htree_index = dist_context_map[dist_context_map_slice + context];
        distance_code = ReadSymbol(hgroup[2].codes, hgroup[2].htrees[dist_htree_index], br);
        if (distance_code >= num_direct_distance_codes) {
          var nbits;
          var postfix;
          var offset;
          distance_code -= num_direct_distance_codes;
          postfix = distance_code & distance_postfix_mask;
          distance_code >>= distance_postfix_bits;
          nbits = (distance_code >> 1) + 1;
          offset = ((2 + (distance_code & 1)) << nbits) - 4;
          distance_code = num_direct_distance_codes +
              ((offset + br.readBits(nbits)) <<
               distance_postfix_bits) + postfix;
        }
      }

      /* Convert the distance code to the actual distance by possibly looking */
      /* up past distnaces from the ringbuffer. */
      distance = TranslateShortCodes(distance_code, dist_rb, dist_rb_idx);
      if (distance < 0) {
        throw new Error('[BrotliDecompress] invalid distance');
      }

      if (pos < max_backward_distance &&
          max_distance !== max_backward_distance) {
        max_distance = pos;
      } else {
        max_distance = max_backward_distance;
      }

      copy_dst = pos & ringbuffer_mask;

      if (distance > max_distance) {
        if (copy_length >= BrotliDictionary.minDictionaryWordLength &&
            copy_length <= BrotliDictionary.maxDictionaryWordLength) {
          var offset = BrotliDictionary.offsetsByLength[copy_length];
          var word_id = distance - max_distance - 1;
          var shift = BrotliDictionary.sizeBitsByLength[copy_length];
          var mask = (1 << shift) - 1;
          var word_idx = word_id & mask;
          var transform_idx = word_id >> shift;
          offset += word_idx * copy_length;
          if (transform_idx < Transform.kNumTransforms) {
            var len = Transform.transformDictionaryWord(ringbuffer, copy_dst, offset, copy_length, transform_idx);
            copy_dst += len;
            pos += len;
            meta_block_remaining_len -= len;
            if (copy_dst >= ringbuffer_end) {
              output.write(ringbuffer, ringbuffer_size);
              
              for (var _x = 0; _x < (copy_dst - ringbuffer_end); _x++)
                ringbuffer[_x] = ringbuffer[ringbuffer_end + _x];
            }
          } else {
            throw new Error("Invalid backward reference. pos: " + pos + " distance: " + distance +
              " len: " + copy_length + " bytes left: " + meta_block_remaining_len);
          }
        } else {
          throw new Error("Invalid backward reference. pos: " + pos + " distance: " + distance +
            " len: " + copy_length + " bytes left: " + meta_block_remaining_len);
        }
      } else {
        if (distance_code > 0) {
          dist_rb[dist_rb_idx & 3] = distance;
          ++dist_rb_idx;
        }

        if (copy_length > meta_block_remaining_len) {
          throw new Error("Invalid backward reference. pos: " + pos + " distance: " + distance +
            " len: " + copy_length + " bytes left: " + meta_block_remaining_len);
        }

        for (j = 0; j < copy_length; ++j) {
          ringbuffer[pos & ringbuffer_mask] = ringbuffer[(pos - distance) & ringbuffer_mask];
          if ((pos & ringbuffer_mask) === ringbuffer_mask) {
            output.write(ringbuffer, ringbuffer_size);
          }
          ++pos;
          --meta_block_remaining_len;
        }
      }

      /* When we get here, we must have inserted at least one literal and */
      /* made a copy of at least length two, therefore accessing the last 2 */
      /* bytes is valid. */
      prev_byte1 = ringbuffer[(pos - 1) & ringbuffer_mask];
      prev_byte2 = ringbuffer[(pos - 2) & ringbuffer_mask];
    }

    /* Protect pos from overflow, wrap it around at every GB of input data */
    pos &= 0x3fffffff;
  }

  output.write(ringbuffer, pos & ringbuffer_mask);
}

exports.BrotliDecompress = BrotliDecompress;

BrotliDictionary.init();

},{"./bit_reader":10,"./context":11,"./dictionary":15,"./huffman":16,"./prefix":17,"./streams":18,"./transform":19}],13:[function(require,module,exports){
var base64 = require('base64-js');

/**
 * The normal dictionary-data.js is quite large, which makes it 
 * unsuitable for browser usage. In order to make it smaller, 
 * we read dictionary.bin, which is a compressed version of
 * the dictionary, and on initial load, Brotli decompresses 
 * it's own dictionary. 😜
 */
exports.init = function() {
  var BrotliDecompressBuffer = require('./decode').BrotliDecompressBuffer;
  var compressed = base64.toByteArray(require('./dictionary.bin.js'));
  return BrotliDecompressBuffer(compressed);
};

},{"./decode":12,"./dictionary.bin.js":14,"base64-js":9}],14:[function(require,module,exports){
module.exports="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