<div align="center">

# 🛡️ SheerID Verification Tool

[![GitHub Stars](https://img.shields.io/github/stars/ThanhNguyxn/SheerID-Verification-Tool?style=social)](https://github.com/ThanhNguyxn/SheerID-Verification-Tool/stargazers)
[![GitHub Forks](https://img.shields.io/github/forks/ThanhNguyxn/SheerID-Verification-Tool?style=social)](https://github.com/ThanhNguyxn/SheerID-Verification-Tool/network/members)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

**学生認証プログラムを通じてGemini AdvancedとChatGPT Plusを無料で入手するための包括的な多言語ガイド。**

<p align="center">
  <a href="https://thanhnguyxn.github.io/SheerID-Verification-Tool/">
    <img src="https://img.shields.io/badge/Live_Tool-4285F4?style=for-the-badge&logo=google-chrome&logoColor=white" alt="Live Tool">
  </a>
  <a href="https://thanhnguyxn.github.io/student-card-generator/">
    <img src="https://img.shields.io/badge/Card_Generator-34A853?style=for-the-badge&logo=google&logoColor=white" alt="Student Card Generator">
  </a>
  <a href="#-目次">
    <img src="https://img.shields.io/badge/Documentation-gray?style=for-the-badge&logo=readthedocs&logoColor=white" alt="Documentation">
  </a>
  <a href="https://github.com/ThanhNguyxn/SheerID-Verification-Tool/issues">
    <img src="https://img.shields.io/badge/Report_Bug-EA4335?style=for-the-badge&logo=github&logoColor=white" alt="Report Bug">
  </a>
</p>

</div>



---

## 📖 プロジェクトについて

**SheerID Verification Tool**は、世界中の学生がGoogleのGemini Advanced AIプラットフォームに無料でアクセスするためのステップバイステップガイドを提供します。このツールは、SheerID学生確認システムを使用して確認プロセスを簡素化し、学生がGemini Advanced、2TBのGoogleドライブストレージ、NotebookLM Pro、AI動画作成クレジットなどのプレミアム機能を利用できるようにします。

### ✨ 特徴

- 🌍 **多言語サポート** - 英語、ベトナム語、スペイン語、フランス語、ドイツ語、中国語、ポルトガル語、ロシア語、日本語、韓国語、インドネシア語で利用可能
- 📋 **ステップバイステップガイド** - 確認プロセス全体の明確な手順
- 🔒 **セキュリティ重視** - 安全な実践と信頼できるソースを強調
- 🎁 **プレミアム特典** - Gemini Advanced、2TBストレージなどを12ヶ月間利用可能
- 🤖 **Telegramボット統合** - 安全なTelegramボットによる自動確認
- 🆓 **完全無料** - 無料の学生期間中は隠れたコストなし

---

## 📚 目次

- [⚠️ 免責事項と責任](#️-免責事項と責任)
- [📋 要件](#-要件)
- [🚀 インストールと使用法](#-インストールと使用法)
- [🎁 特典](#-特典)
- [⚠️ セキュリティに関する注意](#️-セキュリティに関する注意)
- [🔗 追加リソース](#-追加リソース)
- [💖 プロジェクトを支援](#-プロジェクトを支援)
- [📄 ライセンス](#-ライセンス)

---

## ⚠️ 免責事項と責任

> [!WARNING]
> **教育目的のみ** - このガイドは情報提供のみを目的としています。

**📁 このツールが行うこと：**
- 🔗 サードパーティ検証サービスへの**ディレクトリ**として機能
- 📖 学生検証のための**教育ガイド**を提供

**🚫 私たちが行わないこと：**
- ❌ Telegramボットを**ホスティング、運営、管理していません**
- ❌ サードパーティボットのセキュリティやデータプライバシーに**責任を負いません**
- ❌ Google、SheerID、Telegramと**提携していません**

**✅ あなたの責任：**
- 👤 あなたは自分自身の行動に責任を持ちます
- 📜 Googleの利用規約を遵守する必要があります
- 🔒 情報を共有する前にボットの真正性を確認してください

> [!CAUTION]
> **自己責任で使用してください** - 個人情報を提供する前に必ずソースを確認してください。

---

## 📋 要件

始める前に、以下を確認してください：

- ✅ **Telegramアカウント** - ボット確認用
- ✅ **Google/OpenAI アカウント** - 確認用の有効なアカウント
- ✅ **有効な支払い方法** - 銀行カードまたは電子ウォレット（無料パッケージの請求なし）
- ✅ **VPN** - （例：Urban VPN）必要に応じて地域を米国 (US) またはその他の対象国に切り替えるため

## 🚀 インストールと使用法

### 🌐 ステップ1：新しいブラウザプロファイルの作成

1. **新しいブラウザプロファイルを作成**するか、データの競合を避けるためにシークレットモードを使用してください

2. **VPN拡張機能をインストール**（すでに**US**などのサポートされている地域にいる場合はスキップ）：
   - [Urban VPN](https://chrome.google.com/webstore/detail/urban-vpn) (Chrome/Edge)
   - [Proton VPN](https://protonvpn.com/) (すべてのブラウザ)

> [!IMPORTANT]
> **シークレットモードを使用していますか？** 拡張機能の設定に移動し、VPNが機能するように**「シークレット モードでの実行を許可する」**を有効にしてください。
>
> ![Allow in Incognito](images/allow-incognito.png)

> [!TIP]
> ステップ2に進む前に、**米国（US）またはその他の対象国**に接続してください。

### 🎓 ステップ2：学生プログラムへのアクセス

プログラムを選択し、確認リンクを取得してください：

| プログラム | リンク | 対象 |
|------------|--------|------|
| 🤖 **Google Gemini** | [gemini.google/students](https://gemini.google/students) | 大学生 |
| 💬 **ChatGPT Plus** | [chatgpt.com/plans/k12-teachers](https://chatgpt.com/plans/k12-teachers/) | K-12 教師 |

**Join Student Program** または同等のボタンをクリックして、確認リンクを受け取ってください。

> [!IMPORTANT]
> **国の適格性：** お住まいの国がサポートされていない場合は、VPNを使用して対象国（米国など）に切り替えてください。
> 
> **💡 ヒント：** 「Google Student Program supported countries」でオンライン検索するか、AIに最新の対象地域を尋ねてください。

### 📱 ステップ3：Telegram経由での学生ステータスの確認

1. Telegramを開き、以下のボットのいずれかにアクセスします：
   - [SheerID VIP Bot](https://t.me/SheerID_VIP_Bot?start=ref_REF001124) ✅ *GPT K12をサポート*
   - [SheerID VN Bot](https://t.me/sheeridvn_bot?start=invite_7762497789)

2. プログラムに応じて適切なコマンドを送信します：

   **Google Geminiの場合:**
   ```
   /verify https://services.sheerid.com/verify/***
   ```
   
   **ChatGPT Plus（K-12）の場合:**
   ```
   /vc https://services.sheerid.com/verify/***
   ```
   
   *（実際の確認リンクに置き換えてください）*

3. ボットからの確認完了を待ちます

> [!TIP]
> **💰 完全無料！** 無料コインを獲得：
> - 友達をボットに招待する
> - 毎日 `/checkin` を使ってポイントを獲得
> 
> *コインが緊急に必要ですか？チャージオプションもサポートしています。*

> [!WARNING]
> **エラーが発生しましたか？** `/fix` コマンドを使用して、確認リンクをもう一度貼り付けてください。複数回試してもエラーが続く場合は、別のGoogleアカウントを使用してみてください。

### ✨ ステップ4：プレミアムプランの有効化

**Google Geminiの場合:**
1. 確認後、**Google One AI Premium** に登録します
2. 支払い方法を追加します（無料期間中は請求されません）
3. 登録プロセスを完了します

**ChatGPT Plusの場合:**
1. 確認後、ChatGPT Plusは自動的に有効になります
2. 無料サブスクリプションをお楽しみください！

> [!NOTE]
> **VPNユーザーの方へ：** 確認後、支払い方法を追加する前にVPNを切断し、ページをリロードしてください。これにより、お住まいの国の支払いオプションとの互換性が確保されます。

### ⚙️ ステップ5：サブスクリプションの管理

12ヶ月の期間終了後に請求されないようにするには、[Google Playの定期購入](https://play.google.com/store/account/subscriptions)にアクセスしてキャンセルしてください。

**⏰ ヒント：** 自動更新の請求を避けるために、カレンダーのリマインダーを設定してください！

## 🎁 特典

正常に完了すると、以下を受け取ります：

**Google Gemini:**
- ✨ **Gemini Advanced** - 12ヶ月間無料
- 💾 **2TB Google Drive** - 大容量クラウドストレージ
- 📝 **NotebookLM Pro** - 高度なメモ機能
- 🎥 **1,000 AI動画クレジット** - VEO3で動画を作成

**ChatGPT Plus:**
- 💬 **ChatGPT Plus** - K-12 教員向け無料
- 🧠 **GPT-4o アクセス** - 高度なAI機能
- 🎨 **DALL·E など** - 画像生成とその他の機能

## ⚠️ セキュリティに関する注意

- 🔐 このガイドに記載されている信頼できるボットソースのみを使用してください
- 🚫 支払い情報を第三者と共有しないでください
- ⏰ キャンセルしない場合、12ヶ月後にパッケージは有料になります

## 🔗 追加リソース

**代替確認手段：** Telegram経由で確認できない場合は、[SheerID Verification Tool](https://thanhnguyxn.github.io/SheerID-Verification-Tool/)を使用してください

**公式リンク：**
- [Google One AI Premium](https://one.google.com)
- [Gemini ヘルプセンター](https://support.google.com/gemini)

---

## 💖 プロジェクトを支援

このガイドが役立つと思われた場合は、プロジェクトの維持と改善を支援することを検討してください：

<a href="https://buymeacoffee.com/thanhnguyxn" target="_blank"><img src="https://cdn.buymeacoffee.com/buttons/v2/default-yellow.png" alt="Buy Me A Coffee" style="height: 60px !important;width: 217px !important;" ></a>

---

## 🌐 他の言語

- [🇬🇧 English](../README.md)
- [🇻🇳 Tiếng Việt](README.vi.md)
- [🇪🇸 Español](README.es.md)
- [🇫🇷 Français](README.fr.md)
- [🇩🇪 Deutsch](README.de.md)
- [🇨🇳 中文](README.zh.md)
- [🇧🇷 Português](README.pt-BR.md)
- [🇷🇺 Русский](README.ru.md)
- [🇯🇵 日本語](README.ja.md)
- [🇰🇷 한국어](README.ko.md)
- [🇮🇩 Indonesia](README.id.md)
- [🇮🇳 हिन्दी](README.hi.md)
- [🇸🇦 العربية](README.ar.md)
- [🇹🇷 Türkçe](README.tr.md)
- [🇮🇹 Italiano](README.it.md)
- [🇹🇭 ไทย](README.th.md)
- [🇵🇱 Polski](README.pl.md)

---

## 📄 ライセンス

このプロジェクトはMITライセンスの下でライセンスされています - 詳細は[LICENSE](LICENSE)ファイルを参照してください。

Copyright (c) 2025 SheerID Verification Tool Contributors

---

<div align="center">

**世界中の学生のために❤️で作られました**

このガイドが役立った場合は、[GitHub](https://github.com/ThanhNguyxn/SheerID-Verification-Tool)で⭐を付けることを検討してください！

[⬆ トップに戻る](#-sheerid-verification-tool)

</div>
