<div align="center">

# 🔐 SheerID Verification Tool

[![GitHub Stars](https://img.shields.io/github/stars/ThanhNguyxn/SheerID-Verification-Tool?style=social)](https://github.com/ThanhNguyxn/SheerID-Verification-Tool/stargazers)
[![GitHub Forks](https://img.shields.io/github/forks/ThanhNguyxn/SheerID-Verification-Tool?style=social)](https://github.com/ThanhNguyxn/SheerID-Verification-Tool/network/members)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

**全面的多语言指南，帮助学生通过学生验证计划免费获得 Gemini Advanced 和 ChatGPT Plus。**

<p align="center">
  <a href="https://thanhnguyxn.github.io/SheerID-Verification-Tool/">
    <img src="https://img.shields.io/badge/Live_Tool-4285F4?style=for-the-badge&logo=google-chrome&logoColor=white" alt="Live Tool">
  </a>
  <a href="https://thanhnguyxn.github.io/student-card-generator/">
    <img src="https://img.shields.io/badge/Card_Generator-34A853?style=for-the-badge&logo=google&logoColor=white" alt="Student Card Generator">
  </a>
  <a href="#-目录">
    <img src="https://img.shields.io/badge/Documentation-gray?style=for-the-badge&logo=readthedocs&logoColor=white" alt="Documentation">
  </a>
  <a href="https://github.com/ThanhNguyxn/SheerID-Verification-Tool/issues">
    <img src="https://img.shields.io/badge/Report_Bug-EA4335?style=for-the-badge&logo=github&logoColor=white" alt="Report Bug">
  </a>
</p>

</div>



---

## 📖 关于项目

**SheerID Verification Tool** 为全球学生提供逐步指南，免费访问 Google 的 Gemini Advanced AI 平台。该工具使用 SheerID 学生验证系统简化验证过程，使学生能够解锁高级功能，包括 Gemini Advanced、2TB Google Drive 存储、NotebookLM Pro 和 AI 视频创建积分。

### ✨ 功能

- 🌍 **多语言支持** - 提供英语、越南语、西班牙语、法语、德语和中文版本
- 📋 **分步指南** - 整个验证过程的清晰说明
- 🔒 **注重安全** - 强调安全做法和可信来源
- 🎁 **高级权益** - 访问 Gemini Advanced、ChatGPT Plus、2TB 存储等功能
- 🤖 **Telegram 机器人集成** - 通过安全的 Telegram 机器人自动验证
- 🆓 **完全免费** - 学生免费期间无隐藏费用

---

## 📚 目录

- [⚠️ 免责声明](#️-免责声明)
- [📋 要求](#-要求)
- [🚀 安装和使用](#-安装和使用)
- [🎁 权益](#-权益)
- [⚠️ 安全提示](#️-安全提示)
- [🔗 其他资源](#-其他资源)
- [💖 支持项目](#-支持项目)
- [📄 许可证](#-许可证)

---

## ⚠️ 免责声明

> [!WARNING]
> **仅供教育使用** - 本指南仅供参考。

**📁 此工具的作用：**
- 🔗 作为第三方验证服务的**目录**
- 📖 提供学生验证的**教育指南**

**🚫 我们不做的事情：**
- ❌ 我们**不**托管、运营或管理 Telegram 机器人
- ❌ 我们**不**对第三方机器人的安全性或数据隐私负责
- ❌ 我们与 Google、SheerID 或 Telegram **无关联**

**✅ 您的责任：**
- 👤 您对自己的行为负责
- 📜 您必须遵守 Google 的服务条款
- 🔒 在分享信息前验证机器人的真实性

> [!CAUTION]
> **风险自负** - 在提供个人信息之前，请始终验证来源。

---

## 📋 要求

开始之前，请确保您有：

- ✅ **Telegram账号** - 用于机器人验证
- ✅ **Google/OpenAI 账号** - 用于验证的有效账户
- ✅ **有效的支付方式** - 银行卡或电子钱包（免费套餐无需付费）
- ✅ **VPN** - （例如 Urban VPN）如果需要，可将地区切换到美国 (US) 或其他符合条件的国家

## 🚀 安装和使用

### 🌐 步骤 1：设置浏览器

1. **创建新的浏览器配置文件** 或使用隐身模式以避免数据冲突

2. **安装 VPN 扩展**（如果您已在 **US** 等支持地区则跳过）：
   - [Urban VPN](https://chrome.google.com/webstore/detail/urban-vpn) (Chrome/Edge)
   - [Proton VPN](https://protonvpn.com/) (所有浏览器)
   - 或任何可靠的 VPN

> [!IMPORTANT]
> **使用隐身模式？** 请前往扩展设置并启用 **“在隐身模式下启用”** 以确保 VPN 正常工作。
>
> ![Allow in Incognito](images/allow-incognito.png)

> [!TIP]
> 在进入步骤 2 之前，请连接到 **美国 (US) 或其他符合条件的国家**。

### 🎓 步骤 2：访问学生计划

选择您的计划并获取验证链接：

| 计划 | 链接 | 适用对象 |
|------|------|----------|
| 🤖 **Google Gemini** | [gemini.google/students](https://gemini.google/students) | 大学生 |
| 💬 **ChatGPT Plus** | [chatgpt.com/plans/k12-teachers](https://chatgpt.com/plans/k12-teachers/) | K-12 教师 |

点击 **Join Student Program** 或相应按钮以获取您的验证链接。

> [!IMPORTANT]
> **国家/地区资格：** 如果您的国家/地区不受支持，请使用 VPN 切换到符合条件的国家/地区（美国等）。
> 
> **💡 提示：** 在线搜索“Google Student Program supported countries”。

### 📱 步骤 3：通过 Telegram 验证学生身份

1. 打开 Telegram 并访问以下机器人之一：
   - [SheerID VIP Bot](https://t.me/SheerID_VIP_Bot?start=ref_REF001124) ✅ *支持 GPT K12*
   - [SheerID VN Bot](https://t.me/sheeridvn_bot?start=invite_7762497789)

2. 根据您的计划发送相应命令：

   **Google Gemini:**
   ```
   /verify https://services.sheerid.com/verify/***
   ```
   
   **ChatGPT Plus (K-12):**
   ```
   /vc https://services.sheerid.com/verify/***
   ```
   
   *（替换为您的验证链接）*

3. 等待机器人确认

> [!TIP]
> **💰 完全免费！** 赚取免费金币：
> - 邀请朋友使用机器人
> - 每天使用 `/checkin` 赚取积分
> 
> *急需金币？我们也提供充值选项。*

> [!WARNING]
> **遇到错误？** 使用 `/fix` 命令并重新粘贴您的验证链接。如果错误仍然存​​在，请尝试使用其他 Google 帐户。

### ✨ 步骤 4：激活高级计划

**Google Gemini:**
1. 验证后，注册 **Google One AI Premium**
2. 添加您的付款方式（免费期间不收费）
3. 完成注册

**ChatGPT Plus:**
1. 验证后，您的 ChatGPT Plus 将自动激活
2. 享受您的免费订阅！

> [!NOTE]
> **VPN 用户：** 验证后，请断开 VPN 并重新加载页面，然后再添加付款方式。

### ⚙️ 步骤 5：管理您的订阅

访问 [Google Play 订阅](https://play.google.com/store/account/subscriptions) 以在 12 个月期限结束前取消。

**⏰ 提示：** 设置日历提醒以避免自动续费！

## 🎁 权益

成功完成后，您将获得：

**Google Gemini:**
- ✨ **Gemini Advanced** - 免费使用12个月
- 💾 **2TB Google Drive** - 充足的云存储空间
- 📝 **NotebookLM Pro** - 高级笔记功能
- 🎥 **1,000个AI视频积分** - 使用VEO3创建视频

**ChatGPT Plus:**
- 💬 **ChatGPT Plus** - K-12 教师免费
- 🧠 **GPT-4o 访问权限** - 高级 AI 功能
- 🎨 **DALL·E 等** - 图像生成和更多功能

## ⚠️ 安全提示

- 🔐 仅使用本指南中列出的可信机器人来源
- 🚫 切勿与第三方分享支付信息
- ⏰ 12个月后，如果未取消，套餐将转为付费

## 🔗 其他资源

**替代验证：** 如果无法通过Telegram验证，请使用[SheerID Verification Tool](https://thanhnguyxn.github.io/SheerID-Verification-Tool/)

**官方链接：**
- [Google One AI Premium](https://one.google.com)
- [Gemini帮助中心](https://support.google.com/gemini)

---

## 💖 支持项目

如果您觉得本指南有用，请考虑支持以帮助维护和改进项目：

<a href="https://buymeacoffee.com/thanhnguyxn" target="_blank"><img src="https://cdn.buymeacoffee.com/buttons/v2/default-yellow.png" alt="Buy Me A Coffee" style="height: 60px !important;width: 217px !important;" ></a>

---

## 🌐 其他语言

- [🇬🇧 English](../README.md)
- [🇻🇳 Tiếng Việt](README.vi.md)
- [🇪🇸 Español](README.es.md)
- [🇫🇷 Français](README.fr.md)
- [🇩🇪 Deutsch](README.de.md)
- [🇨🇳 中文](README.zh.md)
- [🇧🇷 Português](README.pt-BR.md)
- [🇷🇺 Русский](README.ru.md)
- [🇯🇵 日本語](README.ja.md)
- [🇰🇷 한국어](README.ko.md)
- [🇮🇩 Indonesia](README.id.md)
- [🇮🇳 हिन्दी](README.hi.md)
- [🇸🇦 العربية](README.ar.md)
- [🇹🇷 Türkçe](README.tr.md)
- [🇮🇹 Italiano](README.it.md)
- [🇹🇭 ไทย](README.th.md)
- [🇵🇱 Polski](README.pl.md)

---

## 📄 许可证

本项目根据 MIT 许可证授权 - 有关详细信息，请参阅 [LICENSE](LICENSE) 文件。

Copyright (c) 2025 SheerID Verification Tool Contributors

---

<div align="center">

**用 ❤️ 为全球学生制作**

如果您觉得本指南有用，请考虑在 [GitHub](https://github.com/ThanhNguyxn/SheerID-Verification-Tool) 上给它一个 ⭐！

[⬆ 返回顶部](#-sheerid-verification-tool)

</div>
